<?php
/**
 * 工资页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class salaryclassControl extends BaseHomeControl{
	private $fixeditem_arr = array(); 
	public function __construct(){
		parent::__construct();
		Language::read('salaryclass');
		//$sitemtype_arr = array(1=>'输入项',2=>'计算项',3=>'所得税项',4=>'年终奖个税项',5=>'继承上月项',6=>'销售提成项',7=>'考勤项');
		$sitemtype_arr = array(1=>Language::get('bp_salary_input_item'),2=>Language::get('bp_salary_calculate_item'),3=>Language::get('bp_salary_income_tax'),5=>Language::get('bp_salary_inherit_lastmonth_item'),6=>Language::get('bp_salary_sale_bonus_item'));
		Tpl::output('sitemtype_arr',$sitemtype_arr);
		$sitemroundtype_arr = array(0=>Language::get('bp_salary_round'),1=>Language::get('bp_salary_all_lost'),2=>Language::get('bp_salary_all_in'));
		Tpl::output('sitemroundtype_arr',$sitemroundtype_arr);
		//固定参与计算的项目
		$this->fixeditem_arr = array('status_amount'=>Language::get('bp_salary_sale_amount'),'status_profity'=>Language::get('bp_salary_profit'));
		Tpl::output('fixeditem_arr',$this->fixeditem_arr);
	}
	/**
	 * 工资帐套管理
	 */
	public function salaryclassmanageOp(){
		if (!empty($_GET['type'])){
			$funname = "salaryclass_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//工资帐套列表
			$this->salaryclass_clist();
		}
	}
	/**
	 * 帐套列表
	 */
	public function salaryclass_clist(){
		$model = Model();
		$where = array();
		//名称或者编号
		if (!empty($_GET['search_content'])){
			$where['sc_number|sc_name'] = array('like',"%{$_GET['search_content']}%");
		}
		//状态
		$search_state = intval($_GET['search_state']);
		if ($search_state > 0){
			$where['sc_state'] = $search_state - 1;
		}
		$sc_list = $model->table('salaryclass')->where($where)->order('sc_number asc')->page(10)->select();
		Tpl::output('sc_list',$sc_list);
		Tpl::output('show_page',$model->showpage(2));
		//左侧菜单
		$this->setleftmenu('salaryclass');
		Tpl::showpage('salaryclass_clist');
	}
	/**
	 * 新增帐套
	 */
	public function salaryclass_cadd(){
		if (chksubmit()){
			$model = Model();
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["c_number"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_addcode'));
			$validate_arr[] = array("input"=>$_POST["c_name"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_addname'));
			$validate_arr[] = array("input"=>$_POST["state"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choosestat'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//帐套编号或者名称是否存在
			$where = array();
			$where['sc_number'] = array('eq',$_POST['c_number']);
			$where['sc_name'] = array('eq',$_POST['c_name']);
			$where['_op'] = 'or';
			$sc_list = $model->table('salaryclass')->where($where)->select();
			if(!empty($sc_list)){
				$number_exist = false;
				$name_exist = false;
				foreach((array)$sc_list as $k=>$v){
					if($v['sc_number'] == $_POST["c_number"] && $number_exist == false){
						$number_exist = true;
					}
					if($v['sc_name'] == $_POST["c_name"] && $name_exist == false){
						$name_exist = true;
					}
				}
				if($name_exist == true && $number_exist == true){
					showDialog(Language::get('bp_salaryclass_codename_exist'),'','error');
				}elseif($number_exist == true){
					showDialog(Language::get('bp_salaryclass_code_exist'),'','error');
				}elseif($name_exist == true){
					showDialog(Language::get('bp_salaryclass_name_exist'),'','error');
				}
			}
			$insert_arr = array();
			$insert_arr['sc_number'] = $_POST['c_number'];
			$insert_arr['sc_name'] = $_POST['c_name'];
			$insert_arr['sc_updatetime'] = time();
			$insert_arr['sc_state'] = intval($_POST['state']);
			$insert_arr['sc_operatorid'] = $_SESSION['member_id'];
			$insert_arr['sc_operatorname'] = $_SESSION['truename'];
			$rs = $model->table('salaryclass')->insert($insert_arr);
			if ($rs){
				H('salaryclass',true,'file');//更新缓存
				showDialog(Language::get('bp_salaryclass_addsucc'),'index.php?act=salaryclass&op=salaryclassmanage&type=clist','succ');
			}else {
				showDialog(Language::get('bp_salaryclass_addfailed'),'','error');
			}
		}else{
			//左侧菜单
			$this->setleftmenu('salaryclass');
			Tpl::showpage('salaryclass_cadd');
		}
	}
	/**
	 * 验证帐套编号是否存在
	 */
	public function salaryclass_checkclassnumber(){
		$model = Model();
		//帐套编号是否存在
		$where = array();
		$where['sc_number'] = array('eq',$_GET['c_number']);
		$sc_info = $model->table('salaryclass')->where($where)->find();
		if (empty($sc_info)){
			echo 'true'; die;
		}else {
			if (intval($sc_info['sc_id']) == intval($_GET['c_id'])){//编辑时
				echo 'true'; die;
			}else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 验证帐套名称是否存在
	 */
	public function salaryclass_checkclassname(){
		$model = Model();
		//帐套名称是否存在
		$where = array();
		$where['sc_name'] = array('eq',$_GET['c_name']);
		$sc_info = $model->table('salaryclass')->where($where)->find();
		if (empty($sc_info)){
			echo 'true'; die;
		}else {
			if (intval($sc_info['sc_id']) == intval($_GET['c_id'])){//编辑时
				echo 'true'; die;
			}else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 编辑帐套
	 */
	public function salaryclass_cedit(){
		$cid = intval($_GET['cid']);
		if ($cid<=0){
			$cid = intval($_POST['cid']);
		}
		if ($cid<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$sc_info = $model->table('salaryclass')->where(array('sc_id'=>$cid))->find();
		if(empty($sc_info)){
			showDialog(Language::get('bp_salaryclass_info_error'),'','error');
		}
		if (chksubmit()){
			$model = Model();
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["c_number"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_addcode'));
			$validate_arr[] = array("input"=>$_POST["c_name"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_addname'));
			$validate_arr[] = array("input"=>$_POST["state"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choosestat'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if($sc_info['sc_number'] != $_POST['c_number']){
				$where = array();
				$where['sc_number'] = $_POST['c_number'];
				$count = $model->table('salaryclass')->where($where)->count();
				if($count > 0){
					showDialog(Language::get('bp_salaryclass_code_exist'),'','error');
				}
			}
			if($sc_info['sc_name'] != $_POST['c_name']){
				$where = array();
				$where['sc_name'] = $_POST['c_name'];
				$count = $model->table('salaryclass')->where($where)->count();
				if($count > 0){
					showDialog(Language::get('bp_salaryclass_name_exist'),'','error');
				}
			}
			$update_arr = array();
			$update_arr['sc_number'] = $_POST['c_number'];
			$update_arr['sc_name'] = $_POST['c_name'];
			$update_arr['sc_updatetime'] = time();
			$update_arr['sc_state'] = intval($_POST['state']);
			$update_arr['sc_operatorid'] = $_SESSION['member_id'];
			$update_arr['sc_operatorname'] = $_SESSION['truename'];
			$rs = $model->table('salaryclass')->where(array('sc_id'=>$cid))->update($update_arr);
			if ($rs){
				H('salaryclass',true,'file');//更新缓存
				showDialog(Language::get('bp_salaryclass_editsucc'),'index.php?act=salaryclass&op=salaryclassmanage&type=clist','succ');
			}else {
				showDialog(Language::get('bp_salaryclass_editfailed'),'','error');
			}
		}else{
			Tpl::output('sc_info',$sc_info);
			//左侧菜单
			$this->setleftmenu('salaryclass');
			Tpl::showpage('salaryclass_cadd');
		}
	}
	/*
	 * 删除帐套
	 */
	public function salaryclass_cdel(){
		$cid = $_GET['cid'];
		if (empty($cid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		//查询销售机会详细
		$model = Model();
		$where = array();
		$where['sc_id'] = $cid;
		$rs = $model->table('salaryclass')->where($where)->delete();
		if ($rs){
			H('salaryclass',true,'file');//更新缓存
			//删除帐套工资项目
			$model->table('salaryitem')->where(array('sitem_classid'=>$cid))->delete();
			showDialog(Language::get('bp_salaryclass_delsucc'),'index.php?act=salaryclass&op=salaryclassmanage&type=clist','succ');
		}else{
			showDialog(Language::get('bp_salaryclass_delfailed'),'','error');
		}
	}
	/**
	 * 帐套工资项列表
	 */
	public function salaryclass_itemlist(){
		$cid = intval($_GET['cid']);
		if ($cid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询帐套
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		if (empty($salaryclass) || empty($salaryclass[$cid])){
			showDialog(Language::get('bp_salaryclass_info_error'),'','error');
		}
		$sc_info = $salaryclass[$cid]['info'];
		//查询工资项
		$sitem_list = $model->table('salaryitem')->where(array('sitem_classid'=>$cid))->order('sitem_order asc')->select();
		Tpl::output('sc_info',$sc_info);
		Tpl::output('sitem_list',$sitem_list);
		//左侧菜单
		$this->setleftmenu('salaryclass');
		Tpl::showpage('salaryclass_itemlist');
	}
	/**
	 * 新增帐套工资项
	 */
	public function salaryclass_itemadd(){
		$cid = intval($_GET['cid']);
		if ($cid <= 0){
			$cid = intval($_POST['cid']);
		}
		if ($cid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询帐套
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		if (empty($salaryclass) || empty($salaryclass[$cid])){
			showDialog(Language::get('bp_salaryclass_info_error'),'','error');
		}
		$sc_info = $salaryclass[$cid]['info'];
		Tpl::output('sc_info',$sc_info);
		if (chksubmit()){
			$model = Model();
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["item_name"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_add_project'));
			$validate_arr[] = array("input"=>$_POST["item_type"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choose_project_type'));
			$validate_arr[] = array("input"=>$_POST["item_roundtype"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choose_round_type'));
			$validate_arr[] = array("input"=>$_POST["item_order"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_add_sortnum'));
			$validate_arr[] = array("input"=>$_POST["item_order"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choose_status'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//工作项目名称是否存在
			$where = array();
			$where['sitem_name'] = $_POST['item_name'];
			$where['sitem_classid'] = $sc_info['sc_id'];
			$sitem_info = $model->table('salaryitem')->where($where)->find();
			if(!empty($sitem_info)){
				showDialog(Language::get('bp_salaryclass_project_name_exist'),'','error');
			}
			$insert_arr = array();
			$insert_arr['sitem_order'] = $_POST['item_order'];
			$insert_arr['sitem_name'] = $_POST['item_name'];
			$insert_arr['sitem_classid'] = $cid;
			$insert_arr['sitem_type'] = $_POST['item_type'];
			$insert_arr['sitem_roundtype'] = $_POST['item_roundtype'];
			$insert_arr['sitem_initial'] = $_POST['item_initial'];
			$insert_arr['sitem_isshow'] = intval($_POST['item_state']);
			if ($_POST['item_type'] == 1 || $_POST['item_type'] == 5){
				$insert_arr['sitem_expression'] = '';
			}else{
				$insert_arr['sitem_expression'] = $_POST['item_expression'];
			}
			$rs = $model->table('salaryitem')->insert($insert_arr);
			if ($rs){
				H('salaryclass',true,'file');//更新缓存
				showDialog(Language::get('bp_salaryclass_project_addsucc'),"index.php?act=salaryclass&op=salaryclassmanage&type=itemlist&cid=$cid",'succ');
			}else{
				showDialog(Language::get('bp_salaryclass_project_addfailed'),'','error');
			}
		}else{
			//左侧菜单
			$this->setleftmenu('salaryclass');
			Tpl::showpage('salaryclass_itemadd');
		}
	}
	/**
	 * 编辑帐套工资项
	 */
	public function salaryclass_itemedit(){
		$itemid = intval($_GET['itemid']);
		if ($itemid <= 0){
			$itemid = intval($_POST['itemid']);
		}
		if ($itemid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询工资项
		$sitem_info = $model->table('salaryitem')->where(array('sitem_id'=>$itemid))->find();
		if (empty($sitem_info)){
			showDialog(Language::get('bp_salaryclass_subject_info_error'),'','error');
		}
		//查询帐套
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		if (empty($salaryclass) || empty($salaryclass[$sitem_info['sitem_classid']])){
			showDialog(Language::get('bp_salaryclass_info_error'),'','error');
		}
		$sc_info = $salaryclass[$sitem_info['sitem_classid']]['info'];
		Tpl::output('sitem_info',$sitem_info);
		Tpl::output('sc_info',$sc_info);
		
		if (chksubmit()){
			$model = Model();
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["item_name"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_add_project'));
			$validate_arr[] = array("input"=>$_POST["item_type"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choose_project_type'));
			$validate_arr[] = array("input"=>$_POST["item_roundtype"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choose_round_type'));
			$validate_arr[] = array("input"=>$_POST["item_order"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_add_sortnum'));
			$validate_arr[] = array("input"=>$_POST["item_order"],"require"=>"true","message"=>Language::get('bp_salaryclass_pls_choose_status'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//工作项目名称是否存在
			if ($_POST['item_name'] != $sitem_info['sitem_name']){
				$where = array();
				$where['sitem_name'] = $_POST['item_name'];
				$where['sitem_classid'] = $sc_info['sc_id'];
				$sitem_info = $model->table('salaryitem')->where($where)->find();
				if(!empty($sitem_info)){
					showDialog(Language::get('bp_salaryclass_project_name_exist'),'','error');
				}
			}
			$update_arr = array();
			$update_arr['sitem_order'] = $_POST['item_order'];
			$update_arr['sitem_name'] = $_POST['item_name'];
			$update_arr['sitem_type'] = $_POST['item_type'];
			$update_arr['sitem_roundtype'] = $_POST['item_roundtype'];
			$update_arr['sitem_initial'] = $_POST['item_initial'];
			$update_arr['sitem_isshow'] = intval($_POST['item_state']);
			if ($_POST['item_type'] == 1 || $_POST['item_type'] == 5){
				$update_arr['sitem_expression'] = '';
			}else{
				$update_arr['sitem_expression'] = $_POST['item_expression'];
			}
			$rs = $model->table('salaryitem')->where(array('sitem_id'=>$itemid))->update($update_arr);
			if ($rs){
				H('salaryclass',true,'file');//更新缓存
				showDialog(Language::get('bp_salaryclass_project_editsucc'),"index.php?act=salaryclass&op=salaryclassmanage&type=itemlist&cid={$sc_info['sc_id']}",'succ');
			}else{
				showDialog(Language::get('bp_salaryclass_project_editfailed'),'','error');
			}
		}else{
			//左侧菜单
			$this->setleftmenu('salaryclass');
			Tpl::showpage('salaryclass_itemadd');
		}
	}
	/*
	 * 删除工资项目
	 */
	public function salaryclass_itemdel(){
		$itemid = $_GET['itemid'];
		if (empty($itemid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		$where['sitem_id'] = $itemid;
		$rs = $model->table('salaryitem')->where($where)->delete();
		if ($rs){
			H('salaryclass',true,'file');//更新缓存
			//----------------------------------删除帐套其他相关信息------------------------------------
			showDialog(Language::get('bp_salaryclass_project_delsucc'),'index.php?act=salaryclass&op=salaryclassmanage&type=itemlist&cid='.$_GET['cid'],'succ');
		}else{
			showDialog(Language::get('bp_salaryclass_project_delfailed'),'','error');
		}
	}
	/**
	 * 新增帐套工资项之计算公式
	 */
	public function salaryclass_itemexp(){
		$cid = intval($_GET['cid']);
		if ($cid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询工资项目
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		if (empty($salaryclass) || empty($salaryclass[$cid])){
			showDialog(Language::get('bp_salaryclass_info_error'),'','error');
		}
		$sitem_list = $salaryclass[$cid]['item'];
		Tpl::output('sitem_list',$sitem_list);
		if ($_GET['itemtype'] == 3){
			$personaltax_rateinfo = C('personaltax_rateinfo');
			if (!empty($personaltax_rateinfo)){
				$personaltax_rateinfo = unserialize(C('personaltax_rateinfo'));
			}
			if (intval($_GET['itemid'])>0){
				//查询工资项目信息
				$sitem_info = $model->table('salaryitem')->where(array('sitem_id'=>intval($_GET['itemid'])))->find();				
				if (!empty($sitem_info) && $sitem_info['sitem_expression']){
					//解析表达式
					preg_match_all('/{(.*)}/U',$sitem_info['sitem_expression'],$matches);
				}
				$sitem_info['sitem_expressioninfo'] = $matches[1];
				Tpl::output('sitem_info',$sitem_info);
			}
			Tpl::output('personaltax_rateinfo',$personaltax_rateinfo);
			Tpl::showpage('salaryclass_itemexp_personaltax','null_layout');
		} elseif ($_GET['itemtype'] == 6){
			$salepercentage_type = C('salepercentage_type');
			$salepercentage_value = C('salepercentage_value');
			if ($salepercentage_type == 1){
				if (!empty($salepercentage_value)){
					$salepercentage_list = unserialize(C('salepercentage_value'));
				}
				Tpl::output('salepercentage_list',$salepercentage_list);
			}else {
				$salepercentage_value = $salepercentage_value > 0 ?$salepercentage_value:0;
				Tpl::output('salepercentage_value',$salepercentage_value);
			}
			if (intval($_GET['itemid'])>0){
				//查询工资项目信息
				$sitem_info = $model->table('salaryitem')->where(array('sitem_id'=>intval($_GET['itemid'])))->find();				
				if (!empty($sitem_info) && $sitem_info['sitem_expression']){
					//解析表达式
					preg_match_all('/{(.*)}/U',$sitem_info['sitem_expression'],$matches);
				}
				$sitem_info['sitem_expressioninfo'] = $matches[1];
				Tpl::output('sitem_info',$sitem_info);
			}
			Tpl::showpage('salaryclass_itemexp_salepercentage','null_layout');
		}else{
			Tpl::showpage('salaryclass_itemexp','null_layout');
		}
	}
	/**
	 * 验证工资项目名称是否存在
	 */
	public function salaryclass_checkitemname(){
		$model = Model();
		//工资项目名称是否存在
		$where = array();
		$where['sitem_name'] = $_GET['itemname'];
		$where['sitem_classid'] = $_GET['cid'];
		$sitem_info = $model->table('salaryitem')->where($where)->find();
		if (empty($sitem_info)){
			echo 'true'; die;
		} else {
			if (intval($sitem_info['sitem_id']) == intval($_GET['itemid'])){//编辑时
				echo 'true'; die;
			}else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 帐套查看
	 */
	public function salaryclassviewOp(){
		if (!empty($_GET['type'])){
			$funname = "classview_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//工资帐套列表
			$this->classview_clist();
		}
	}
	/**
	 * 验证工资项目名称是否存在
	 */
	public function classview_clist(){
		$model = Model();
		$where = array();
		//名称或者编号
		if (!empty($_GET['search_content'])){
			$where['sc_number|sc_name'] = array('like',"%{$_GET['search_content']}%");
		}
		//状态
		$search_state = intval($_GET['search_state']);
		if ($search_state > 0){
			$where['sc_state'] = $search_state - 1;
		}
		$sc_list = $model->table('salaryclass')->where($where)->order('sc_number asc')->page(10)->select();
		Tpl::output('sc_list',$sc_list);
		Tpl::output('show_page',$model->showpage(2));
		//左侧菜单
		$this->setleftmenu('salaryclassview');
		Tpl::showpage('salaryclass_cviewlist');
	}
	/**
	 * 验证工资项目名称是否存在
	 */
	public function classview_cinfo(){
		$cid = intval($_GET['cid']);
		if ($cid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询帐套
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		if (empty($salaryclass) || empty($salaryclass[$cid])){
			showDialog(Language::get('bp_salaryclass_info_error'),'','error');
		}
		$sc_info = $salaryclass[$cid]['info'];
		//查询工资项
		$sitem_list = $model->table('salaryitem')->where(array('sitem_classid'=>$cid))->order('sitem_order asc')->select();
		Tpl::output('sc_info',$sc_info);
		Tpl::output('sitem_list',$sitem_list);
		//左侧菜单
		$this->setleftmenu('salaryclassview');
		Tpl::showpage('salaryclass_cviewinfo');
	}
	/**
	 * 编辑帐套工资项排序
	 */
	public function salaryclass_itemorder(){
		$itemid = intval($_GET['itemid']);
		if ($itemid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询工资项信息
		$model->table('salaryitem')->where(array('sitem_id'=>$itemid))->update(array('sitem_order'=>$_GET['o']));
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_salary_salaryclass'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'salaryclass','menu_name'=>Language::get('bp_salary_salaryclass_manage'),	'menu_act'=>'salaryclass','menu_op'=>'salaryclassmanage','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'salaryclassview','menu_name'=>Language::get('bp_salary_salaryclass_view'),	'menu_act'=>'salaryclass','menu_op'=>'salaryclassview','linktype'=>'0');
		
		$arr[1] = array('menu_name'=>Language::get('bp_salary_manage'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'salaryuser','menu_name'=>Language::get('bp_salary_staff_salaryclass_setting'),	'menu_act'=>'salary','menu_op'=>'salaryuser','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'salarypacket','menu_name'=>Language::get('bp_salary_salarytable_manage'),	'menu_act'=>'salary','menu_op'=>'salarypacket','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'salarypacketpersonal','menu_name'=>Language::get('bp_salary_personal_salary_search'),	'menu_act'=>'salary','menu_op'=>'salarypacketpersonal','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}