<?php
/**
 * 工资页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class salaryControl extends BaseHomeControl{
	private $fixeditem_arr = array(); 
	public function __construct(){
		parent::__construct();
		Language::read('salary');
		//$sitemtype_arr = array(1=>'输入项',2=>'计算项',3=>'所得税项',4=>'年终奖个税项',5=>'继承上月项',6=>'销售提成项',7=>'考勤项');
		$sitemtype_arr = array(1=>Language::get('bp_salary_input_item'),2=>Language::get('bp_salary_calculate_item'),3=>Language::get('bp_salary_income_tax'),5=>Language::get('bp_salary_inherit_lastmonth_item'),6=>Language::get('bp_salary_sale_bonus_item'));
		Tpl::output('sitemtype_arr',$sitemtype_arr);
		$sitemroundtype_arr = array(0=>Language::get('bp_salary_round'),1=>Language::get('bp_salary_all_lost'),2=>Language::get('bp_salary_all_in'));
		Tpl::output('sitemroundtype_arr',$sitemroundtype_arr);
		//固定参与计算的项目
		$this->fixeditem_arr = array('status_amount'=>Language::get('bp_salary_sale_amount'),'status_profity'=>Language::get('bp_salary_profit'));
		Tpl::output('fixeditem_arr',$this->fixeditem_arr);
	}
	/**
	 * 员工帐套设定
	 */
	public function salaryuserOp(){
		//查询员工信息
		$model = Model('department');
		if (chksubmit()){
			$error = '';
			if (empty($_POST['uid'])){
				$error .= Language::get('bp_salary_pls_choose_transfer_user').'<br>';
			}
			if (empty($_POST['tosclass'])){
				$error .= Language::get('bp_salary_pls_choose_salaryclass');
			}
			if ($error){
				showDialog($error,'','error');
			}
			$model = Model();
			//查询帐套信息
			$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
			if (empty($salaryclass) || empty($salaryclass[$_POST['tosclass']])){
				showDialog(Language::get('bp_salary_salaryclass_error_transfailed'),'','error');
			}
			$sc_info = $salaryclass[$_POST['tosclass']]['info'];
			$where = array();
			$where['user_id'] = array('in',$_POST['uid']);
			//查询员工信息
			$userlist = $model->table('user')->where($where)->select();
			$rs = $model->table('user')->where($where)->update(array('user_salaryclassid'=>$_POST['tosclass']));
			if ($rs){
				//记录员工日志
				$loginsert_arr = array();
				foreach ((array)$userlist as $k=>$v){
					if ($v['user_salaryclassid'] != $_POST['tosclass']){
						$tmp_arr = array();
						$tmp_arr['clog_type'] = 'user';
						$tmp_arr['clog_originalid'] = $v['user_id'];
						$tmp_arr['clog_addtime'] = time();
						$tmp_arr['clog_operatorid'] = $_SESSION['member_id'];
						$tmp_arr['clog_operatorname'] = $_SESSION['truename'];
						$tmp_arr['clog_content'] = Language::get('bp_salary_adjust_salaryclass_to').Language::get('bp_colon')."{$sc_info['sc_name']}".Language::get('bp_semicolon');
						if ($_POST['explain']){
							$tmp_arr['clog_content'] .= Language::get('bp_salary_adjust_intro').Language::get('bp_colon').$_POST['explain'];
						}
						$loginsert_arr[] = $tmp_arr;
					}
				}
				$model->table('commonlog')->insertAll($loginsert_arr);
				showDialog(Language::get('bp_salary_salaryclass_setting_succ'),"index.php?act=salary&op=salaryuser",'succ');
			}else{
				showDialog(Language::get('bp_salary_salaryclass_setting_failed'),'','error');
			}
		}else {
			//添加自定义搜索条件
			if ($_GET['search_did']){
				$did = intval($_GET['search_did']);
				$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
				$d_idarr = array();
				//从缓存查询子部门
				$d_info = $tree_arr[$did];
				if (!empty($tree_arr[$did]['son'])){
					$d_idarr = explode(',',$tree_arr[$did]['son']);
				}
				$d_idarr[] = $did;
				$where['user_department'] = array('in',$d_idarr);
			}
			if (!empty($_GET['search_jpid'])){
				$where['user_jobpost'] = intval($_GET['search_jpid']);
			}
			if (!empty($_GET['search_state'])){
				$where['user_state'] = intval($_GET['search_state'])-1;
			}
			if (!empty($_GET['search_content'])){
				switch ($_GET['search_type']){
					case 'uname':
						$where['user_name'] = array('like',"%{$_GET['search_content']}%");
						break;
					case 'truename':
						$where['user_truename'] = array('like',"%{$_GET['search_content']}%");
						break;
				}
			}
			//帐套搜索
			if (!empty($_GET['search_sclass'])){
				if ($_GET['search_sclass'] == 'other'){
					$where['user_salaryclassid'] = 0;
				}else{
					$where['user_salaryclassid'] = intval($_GET['search_sclass']);
				}
			}
			$user_list = $model->table('user')->where($where)->order('user_id desc')->page(10)->select();
			Tpl::output('show_page',$model->showpage(2));
			Tpl::output('user_list',$user_list);
			//获得部门select
			$start_id = 0;
			$selecthtml = $model->getDepartmentCacheSelect(false,$_GET['search_did'],'',$start_id);
			Tpl::output('selecthtml',$selecthtml);
			//查询工资帐套信息
			$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
			$sc_list = array();
			if (!empty($salaryclass)){
				foreach ((array)$salaryclass as $k=>$v){
					if ($v['info']['sc_state'] == 1){
						$sc_list[$k] = $v['info'];
					}
				}
			}
			Tpl::output('sc_list',$sc_list);
			//左侧菜单
			$this->setleftmenu('salaryuser');
			Tpl::showpage('salaryuser_userlist');	
		}
	}
	
	/**
	 * 工资表管理
	 */
	public function salarypacketOp(){
		if (!empty($_GET['type'])){
			$funname = "salarypacket_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//工资帐套列表
			$this->salarypacket_list();
		}
	}
	/**
	 * 工资包列表
	 */
	private function salarypacket_list(){
		$model = Model();
		$where = array();
		//查询工资包
		if ($_GET['search_sclass']){
			$where['sp_classid'] = $_GET['search_sclass'];
		}
		if ($_GET['search_finishstate']){
			$where['sp_finishstate'] = intval($_GET['search_finishstate'])-1;
		}
		$sp_list = $model->table('salarypacket')->where($where)->order('sp_time desc')->select();
		Tpl::output('sp_list',$sp_list);
		//查询帐套信息
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		$salary_list = array();
		foreach ((array)$salaryclass as $k=>$v){
			$salary_list[$k] = $v['info']['sc_name'];
		}
		Tpl::output('salary_list',$salary_list);
		//左侧菜单
		$this->setleftmenu('salarypacket');
		Tpl::showpage('salarypacket_list');
	}
	/**
	 * 工资表管理
	 */
	public function salarypacketmanageOp(){
		if (!empty($_GET['type'])){
			$funname = "salarypackemanage_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//工资帐套列表
			$this->salarypackemanage_add();
		}
	}
	/**
	 * 新增工资表
	 */
	public function salarypackemanage_add(){
		if (chksubmit()){
			$model = Model();
			$error = '';
			$sc_id = intval($_POST['sclass']);
			if ($sc_id <= 0){
				$error .= Language::get('bp_salary_pls_choose_salaryclass');
			}
			$year = intval($_POST['syear']);
			$month = intval($_POST['smonth']);
			if ($year <= 0 || $month<1 || $month >12){
				$error .= Language::get('bp_salary_pls_choose_right_time');
			}
			if ($error != ''){
				showDialog($error,'','error');
			}
			$error = '';
			//查询工资帐套是否存在
			$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
			if (empty($salaryclass[$sc_id]) || $salaryclass[$sc_id]['info']['sc_state'] == 0){
				showDialog(Language::get('bp_salary_salarytable_exist_donotadd'),'','error');
			}
			$time = strtotime($year.'-'.$month.'-'.'01');
			//查询同帐套同时间段的工资表是否已经存在
			$salarypacket_count = $model->table('salarypacket')->where(array('sp_classid'=>$sc_id,'sp_time'=>$time))->count();
			if ($salarypacket_count > 0){
				showDialog(Language::get('bp_salary_salaryclass_exist_donotadd'),'','error');
			}
			//添加工资数据包
			$insert_arr = array();
			$insert_arr['sp_classid'] = $sc_id;
			$insert_arr['sp_classname'] = $salaryclass[$sc_id]['info']['sc_name'];
			$insert_arr['sp_time'] = $time;
			$salaryitem_arr = array();
			foreach ((array)$salaryclass[$sc_id]['item'] as $k=>$v){
				$salaryitem_arr[] = $v;
			}
			$insert_arr['sp_items'] = serialize($salaryitem_arr);
			$insert_arr['sp_finishstate'] = 0;
			$insert_arr['sp_operatorid'] = $_SESSION['member_id'];
			$insert_arr['sp_operatorname'] = $_SESSION['truename'];
			$insert_arr['sp_departmentid'] = $_SESSION['dp_id'];
			$rs = $model->table('salarypacket')->insert($insert_arr);
			if ($rs){
				//查询工资帐套对应的员工
				$model = Model();
				$where = array();
				$where['user_salaryclassid'] = $sc_id;				
				$userlist = $model->table('user')->where($where)->order('user_id desc')->select();
				if (!empty($userlist)){
					//查询员工月销售统计历史
					$userid_arr = array();
					foreach ((array)$userlist as $k=>$v){
						$userid_arr[] = $v['user_id'];
					}
					$status_list = $model->table('statusersales')->where(array('status_userid'=>array('in',$userid_arr),'status_stattime'=>$time))->select();
					$status_listnew = array();
					foreach ((array)$status_list as $k=>$v){
						$status_listnew[$v['status_userid']] = $v;
					}
					//查询上月工资包
					$lastmonth_time = strtotime(date('Y-m-01',strtotime(date('Y',$time).'-'.(date('m',$time)-1).'-01')));
					$lastmonth_spinfo = $model->table('salarypacket')->where(array('sp_classid'=>$sc_id,'sp_time'=>$lastmonth_time))->find();
					$lastmonth_spitemlist = array();
					if (!empty($lastmonth_spinfo)){
						$lastmonth_spitemlisttmp = $model->table('salarypacketitem')->where(array('spitem_spid'=>$lastmonth_spinfo['sp_id']))->select();
						foreach ((array)$lastmonth_spitemlisttmp as $k=>$v){
							$lastmonth_spitemlist[$v['spitem_userid'].'_'.$v['spitem_itemid']] = $v['spitem_money'];
						}
					}
					$infoinsert_arr = array();
					$iteminsert_arr = array();
					$i = 0;
					foreach ((array)$userlist as $k=>$v){
						//新增工资表详细信息
						$infotmp = array();
						$infotmp['spi_spid'] = $rs;
						$infotmp['spi_userid'] = $v['user_id'];
						$infotmp['spi_usernumbers'] = $v['user_numbers'];
						$infotmp['spi_truename'] = $v['user_truename'];
						$infotmp['spi_departmentid'] = $v['user_department'];
						$infotmp['spi_jobpostid'] = $v['user_jobpost'];
						$infotmp['spi_time'] = $time;
						$infotmp['spi_state'] = 0;
						//工资表工资项记录
						$itemtmp_arr = array();
						foreach ((array)$salaryclass[$sc_id]['item'] as $item_k=>$item_v){
							$itemtmp = array();
							$itemtmp['spitem_spid'] = $rs;
							$itemtmp['spitem_userid'] = $v['user_id'];
							$itemtmp['spitem_itemid'] = $item_k;
							//输入项
							if ($item_v['sitem_type'] == 1){
								$itemtmp['spitem_money'] = $item_v['sitem_initial'];
							}
							//计算项
							if ($item_v['sitem_type'] == 2){
								$expression = $item_v['sitem_expression'];
								//替换“销售额”，“毛利润”
								foreach ((array)$this->fixeditem_arr as $fitem_k=>$fitem_v){//此处$fitem_k需要与数据库字段对应，请注意
									$status_listnew[$v['user_id']][$fitem_k] = floatval($status_listnew[$v['user_id']][$fitem_k]);
									if (!$status_listnew[$v['user_id']][$fitem_k]){
										$status_listnew[$v['user_id']][$fitem_k] = 0;
									}
									$expression = str_replace("{{$fitem_v}}","{$status_listnew[$v['user_id']][$fitem_k]}",$expression);
								}
								foreach ((array)$salaryclass[$sc_id]['item'] as $k2=>$v2){
									if (isset($itemtmp_arr[$v2['sitem_id']]['spitem_money'])){
										$expression = str_replace("{{$v2['sitem_name']}}",$itemtmp_arr[$v2['sitem_id']]['spitem_money'],$expression);
									}else{
										$expression = str_replace("{{$v2['sitem_name']}}",0,$expression);
									}
								}
								eval("\$expressionval = $expression;");
								$itemtmp['spitem_money'] =ncPriceFormat($expressionval);
							}
							//所得税项
							if ($item_v['sitem_type'] == 3){
								$expression = $item_v['sitem_expression'];
								$accordingitemvalue = 0;
								foreach ((array)$salaryclass[$sc_id]['item'] as $k2=>$v2){
									if (strpos($expression,"{{$v2['sitem_name']}}") !== false){
										if (isset($itemtmp_arr[$v2['sitem_id']]['spitem_money'])){
											$accordingitemvalue = $itemtmp_arr[$v2['sitem_id']]['spitem_money'];
										}else{
											$accordingitemvalue = 0;
										}
									}
								}
								//所得税
								$accordingitemvalue = $accordingitemvalue - C('personaltax_start');
								if ($accordingitemvalue > 0 ){
									$percentage = C('personaltax_rateinfo')?unserialize(C('personaltax_rateinfo')):array();
									foreach ((array)$percentage as $percentage_k=>$percentage_v){
										if ($accordingitemvalue > $percentage_v['start']){
											$itemtmp['spitem_money'] = ncPriceFormat($accordingitemvalue * ($percentage_v['rate']/100) - $percentage_v['deduct']);
										}
									}
								}else {
									$itemtmp['spitem_money'] = ncPriceFormat(0);
								}
							}
							//继承上月项
							if ($item_v['sitem_type'] == 5){
								//复制上月该项工资
								$itemtmp['spitem_money'] = floatval($lastmonth_spitemlist[$v['user_id'].'_'.$item_v['sitem_id']]);
								$itemtmp['spitem_money'] = ncPriceFormat($itemtmp['spitem_money']);
							}
							//销售提成项
							if ($item_v['sitem_type'] == 6){
								$expression = $item_v['sitem_expression'];
								$accordingitemvalue = 0;
								foreach ((array)$salaryclass[$sc_id]['item'] as $k2=>$v2){
									if (strpos($expression,"{{$v2['sitem_name']}}") !== false){
										if (isset($itemtmp_arr[$v2['sitem_id']]['spitem_money'])){
											$accordingitemvalue = $itemtmp_arr[$v2['sitem_id']]['spitem_money'];
										}else{
											$accordingitemvalue = 0;
										}
									}
								}
								if (intval(C('salepercentage_type')) == 1){
									$percentage = C('salepercentage_value')?unserialize(C('salepercentage_value')):'';
									foreach ((array)$percentage as $percentage_k=>$percentage_v){
										if ($accordingitemvalue > $percentage_v['start'] && $accordingitemvalue <= $percentage_v['end']){
											$itemtmp['spitem_money'] = ncPriceFormat($accordingitemvalue * ($percentage_v['rate']/100));
										}
									}
								}else {
									$salepercentage_value = floatval(C('salepercentage_value'));
									$itemtmp['spitem_money'] = ncPriceFormat($accordingitemvalue*($salepercentage_value/100));
								}
								if (!$itemtmp['spitem_money']){
									$itemtmp['spitem_money'] = ncPriceFormat(0);
								}
							}
							$itemtmp_arr[$item_k] = $itemtmp;
						}
						$tmp = intval($i/100);
						$infoinsert_arr[$tmp][] = $infotmp;
						foreach ((array)$itemtmp_arr as $item_v){
							$iteminsert_arr[$tmp][] = $item_v;
						}
						$i++;
					}
					//每100条重新执行一次sql
					foreach ((array)$infoinsert_arr as $k=>$v){
						$model->table('salarypacketinfo')->insertAll($v);
					}
					foreach ((array)$iteminsert_arr as $k=>$v){
						$model->table('salarypacketitem')->insertAll($v);
					}
				}
				showDialog('','','js',"window.location.replace('index.php?act=salary&op=salarypacketmanage&type=add2&spid=".$rs."');",0);
			}else {
				showDialog(Language::get('bp_salary_salarytable_addfailed'),'','error');
			}
		} else {
			//查询帐套信息
			$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
			$salary_list = array();
			foreach ((array)$salaryclass as $k=>$v){
				if ($v['info']['sc_state'] == 1){
					$salary_list[$k] = $v['info']['sc_name'];
				}
			}
			Tpl::output('salary_list',$salary_list);
			
			$year_arr = getSystemYearArr();
			Tpl::output('year_arr',$year_arr);
			$month_arr = getSystemMonthArr();
			Tpl::output('month_arr',$month_arr);
			//左侧菜单
			$this->setleftmenu('salarypacket');
			Tpl::showpage('salarypacket_add');
		}
	}
	/**
	 * 新增工资表第二步
	 */
	public function salarypackemanage_add2(){
		$sp_id = intval($_GET['spid']);
		if ($sp_id <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model('department');
		$where = array();
		//查询工资表
		$where['sp_id'] = $sp_id;
		$sp_info = $model->table('salarypacket')->where($where)->find();
		unset($where);
		if (empty($sp_info)){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		//处理工资表项目
		$sp_itemarr = $sp_info['sp_items']?unserialize($sp_info['sp_items']):'';
		//查询工资详细表
		$where = array();
		if (!empty($_GET['search_content'])){
			switch ($_GET['search_type']){
				case 'unumbers':
					$where['spi_usernumbers'] = array('like',"%{$_GET['search_content']}%");
					break;
				case 'truename':
					$where['spi_truename'] = array('like',"%{$_GET['search_content']}%");
					break;
			}
		}
		//所属部门
		if ($_GET['search_did']){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$did = intval($_GET['search_did']);
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$did];
			if (!empty($tree_arr[$did]['son'])){
				$d_idarr = explode(',',$tree_arr[$did]['son']);
			}
			$d_idarr[] = $did;
			$where['spi_departmentid'] = array('in',$d_idarr);
		}
		$where['spi_spid'] = $sp_id;
		
		if ($_GET['exporttype'] == 'excel'){
			$spinfo_list = $model->table('salarypacketinfo')->where($where)->order('spi_id')->select();
		}else{
			$spinfo_list = $model->table('salarypacketinfo')->where($where)->order('spi_id')->page(20)->select();
		}
		unset($where);
		if (!empty($spinfo_list)){
			$usercache = ($t = F('user')) ? $t : H('user',true,'file');
			//查询工资表项目金额
			$where = array();
			$where['spitem_spid'] = $sp_id;
			//项目总和
			$spitem_counttmp = $model->table('salarypacketitem')->field("spitem_itemid,sum(spitem_money) as itemsum")->where($where)->group('spitem_itemid')->select();
			foreach ((array)$spitem_counttmp as $k=>$v){
				$spitem_count['itemvalue_'.$v['spitem_itemid']] = ncPriceFormat($v['itemsum']);
			}
			$spitem_list = $model->table('salarypacketitem')->where($where)->order('spitem_id')->select();
			$spitem_listnew = array();
			foreach ((array)$spitem_list as $k=>$v){
				$spitem_listnew[$v['spitem_userid']][] = $v;
			}
			$pageitemcount_arr = array();
			foreach ((array)$spinfo_list as $k=>$v){
				$v['spi_departmentname'] = $usercache[$v['spi_userid']]['user_departmentname'];
				$v['spi_jobpostname'] = $usercache[$v['spi_userid']]['user_jobpostname'];
				foreach ((array)$spitem_listnew[$v['spi_userid']] as $item_k=>$item_v){
					if ($item_v['spitem_money']){
						$v['itemvalue_'.$item_v['spitem_itemid']] = $item_v['spitem_money'];
					}else {
						$v['itemvalue_'.$item_v['spitem_itemid']] = 0;
					}
					$pageitemcount_arr['itemvalue_'.$item_v['spitem_itemid']] += $v['itemvalue_'.$item_v['spitem_itemid']];
					$v['itemvalue_'.$item_v['spitem_itemid']] = ncPriceFormat($v['itemvalue_'.$item_v['spitem_itemid']]);
				}
				$spinfo_list[$k] = $v;
			}
		}
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		$salaryclass = $salaryclass[$sp_info['sp_classid']];
		//导出Excel
		if ($_GET['exporttype'] == 'excel'){
			//导出Excel
			import('excel#class');
			$excel_class = new ExcelXML(C('exportfilefont'));
			$excel_data = array();
			//设置样式
			$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_salary_sortnum'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_salary_staff_code'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_salary_staff_truename'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_salary_department'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_salary_jobpost'));
			foreach((array)$sp_itemarr as $k=>$v){
				if ($v['sitem_isshow'] == 1){
					$excel_data[0][] = array('styleid'=>'s_title','data'=>$v['sitem_name']);
				}
			}
			//data
			foreach ((array)$spinfo_list as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$k+1);
				$tmp[] = array('data'=>$v['spi_usernumbers']);
				$tmp[] = array('data'=>$v['spi_truename']);
				$tmp[] = array('data'=>$v['spi_departmentname']);
				$tmp[] = array('data'=>$v['spi_jobpostname']);
				foreach((array)$sp_itemarr as $item_k=>$item_v){
					if ($item_v['sitem_isshow'] == 1){
						$tmp[] = array('data'=>$v['itemvalue_'.$item_v['sitem_id']]?$v['itemvalue_'.$item_v['sitem_id']]:ncPriceFormat(0));
					}
				}
				$excel_data[] = $tmp;
			}
			
			$tmp = array();
			$tmp[] = array('data'=>Language::get('bp_salary_sum'));
			$tmp[] = array('data'=>'');
			$tmp[] = array('data'=>'');
			$tmp[] = array('data'=>'');
			$tmp[] = array('data'=>'');
			foreach((array)$sp_itemarr as $item_k=>$item_v){
				if ($item_v['sitem_isshow'] == 1){
					$tmp[] = array('data'=>$spitem_count['itemvalue_'.$item_v['sitem_id']]);
				}
			}
			$excel_data[] = $tmp;
			$excel_class->addArray($excel_data);
			$sheetname = @date('Y',$sp_info['sp_time']).$lang['bp_salary_year'].@date('m',$sp_info['sp_time']).$lang['bp_salary_month'].$salaryclass['info']['sc_name'];;
			$excel_class->addWorksheet($sheetname);
			$excel_class->generateXML($sheetname.date('Y-m-d H-i-s',time()));
			exit();
		}
		
		Tpl::output('spitem_count',$spitem_count);
		Tpl::output('pageitemcount_arr',$pageitemcount_arr);
		Tpl::output('spinfo_list',$spinfo_list);
		Tpl::output('show_page',$model->showpage(2));
		//获得部门select
		$start_id = 0;
		$selecthtml = $model->getDepartmentCacheSelect(false,$_GET['search_did'],'',$start_id);
		Tpl::output('selecthtml',$selecthtml);
		Tpl::output('sp_itemarr',$sp_itemarr);
		Tpl::output('sp_info',$sp_info);
		Tpl::output('salaryclass',$salaryclass);
		//左侧菜单
		$this->setleftmenu('salarypacket');
		Tpl::showpage('salarypacket_add2');
		
	}
	/**
	 * 编辑和增加工资卡片
	 */
	public function salarypackemanage_addcard(){
		$spinfoid = intval($_GET['spinfoid']);
		if ($spinfoid <= 0){
			$spinfoid = intval($_POST['spinfoid']);
		}
		if ($spinfoid <= 0){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		//查询工资详细
		$model = Model();
		$where = array();
		//获得所有查询共有条件
		$where['spi_id'] = $spinfoid;
		$spinfo = $model->table('salarypacketinfo')->where($where)->find();
		if (empty($spinfo)){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		if (chksubmit()){
			//防止工资项发生改变造成冗余数据存在，先删除原有工资项目金额表数据在插入新数据
			$model->table('salarypacketitem')->where(array('spitem_spid'=>$spinfo['spi_spid'],'spitem_userid'=>$spinfo['spi_userid']))->delete();
			$insert_arr = array();
			foreach ((array)$_POST['item'] as $k=>$v){
				$tmp = array();
				$tmp['spitem_spid'] = $spinfo['spi_spid'];
				$tmp['spitem_userid'] = $spinfo['spi_userid'];
				$tmp['spitem_itemid'] = $k;
				$tmp['spitem_money'] = $v;
				$insert_arr[] = $tmp;
			}
			$model->table('salarypacketitem')->insertAll($insert_arr);
			//输出js
			$js = "window.location.reload();";
			showDialog('','','js',$js,0);
		} else {
			$spacket = $model->table('salarypacket')->where(array('sp_id'=>$spinfo['spi_spid']))->find();
			if (empty($spacket)){
				showDialog(Language::get('bp_salary_table_info_error'),'','error');
			}
			//处理工资表项目
			$sp_itemarr = $spacket['sp_items']?unserialize($spacket['sp_items']):'';
			//查询项目金额表
			$spitem = $model->table('salarypacketitem')->where(array('spitem_spid'=>$spinfo['spi_spid'],'spitem_userid'=>$spinfo['spi_userid']))->select();
			$spitem_new = array();
			foreach ((array)$sp_itemarr as $item_k=>$item_v){
				foreach ((array)$spitem as $k=>$v){
					if ($item_v['sitem_id'] == $v['spitem_itemid']){
						$v['itemname'] = $item_v['sitem_name'];
						$v['sitem_type'] = $item_v['sitem_type'];
						$v['sitem_isshow'] = $item_v['sitem_isshow'];
						$spitem_new[] = $v;
					}
				}
			}
			Tpl::output('spinfo',$spinfo);
			Tpl::output('spitem',$spitem_new);
			Tpl::output('spacket',$spacket);
			//员工缓存
			$usercache = ($t = F('user')) ? $t : H('user',true,'file');
			Tpl::output('usercache',$usercache);
			//部门缓存
			$departmentcache = ($t = F('department')) ? $t : H('department',true,'file');
			Tpl::output('departmentcache',$departmentcache);
			Tpl::showpage('salarypacket_addcard','null_layout');
		}
	}
	/**
	 * 编辑和增加工资卡片
	 */
	public function salarypackemanage_ajaxcard(){
		$spi_id = $_POST['spinfoid'];
		if ($spi_id <= 0){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		//查询工资详细
		$model = Model();
		$spi_info = $model->table('salarypacketinfo')->where(array('spi_id'=>$spi_id))->find();
		if (empty($spi_info)){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		$spacket = $model->table('salarypacket')->where(array('sp_id'=>$spi_info['spi_spid']))->find();
		if (empty($spacket)){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		//处理工资表项目
		$sp_itemarr = $spacket['sp_items']?unserialize($spacket['sp_items']):'';
		//查询销售记录
		$status_info = $model->table('statusersales')->where(array('status_userid'=>$spi_info['spi_userid'],'status_stattime'=>$spacket['sp_time']))->find();
		
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		$itemmoney = array();
		foreach ((array)$sp_itemarr as $k=>$v){
			if ($v['sitem_type'] == 2){//计算项
				$expression = $v['sitem_expression'];
				//替换“销售额”，“毛利润”
				foreach ((array)$this->fixeditem_arr as $fitem_k=>$fitem_v){//此处$fitem_k需要与数据库字段对应，请注意
					$status_info[$fitem_k] = floatval($status_info[$fitem_k]);
					if (!$status_info[$fitem_k]){
						$status_info[$fitem_k] = 0;
					}
					$expression = str_replace("{{$fitem_v}}",$status_info[$fitem_k],$expression);
				}
				foreach ((array)$sp_itemarr as $k2=>$v2){
					if (isset($itemmoney[$v2['sitem_id']])){
						$expression = str_replace("{{$v2['sitem_name']}}",$itemmoney[$v2['sitem_id']],$expression);
					}else{
						$expression = str_replace("{{$v2['sitem_name']}}",$_POST['item'][$v2['sitem_id']],$expression);
					}
				}
				eval("\$expressionval = $expression;");
				$itemmoney[$v['sitem_id']] = ncPriceFormat($expressionval);
			}elseif ($v['sitem_type']== 6){//销售提成项
				$expression = $v['sitem_expression'];
				$accordingitemvalue = 0;
				foreach ((array)$sp_itemarr as $k2=>$v2){
					if (strpos($expression,"{{$v2['sitem_name']}}") !== false){
						if (isset($itemmoney[$v2['sitem_id']])){
							$accordingitemvalue = $itemmoney[$v2['sitem_id']];
						}else{
							$accordingitemvalue = $_POST['item'][$v2['sitem_id']];
						}
					}
				}
				if (intval(C('salepercentage_type')) == 1){
					$percentage = C('salepercentage_value')?unserialize(C('salepercentage_value')):'';
					foreach ((array)$percentage as $percentage_k=>$percentage_v){
						if ($accordingitemvalue > $percentage_v['start'] && $accordingitemvalue <= $percentage_v['end']){
							$itemmoney[$v['sitem_id']] = ncPriceFormat($accordingitemvalue * ($percentage_v['rate']/100));
						}
					}
				}else {
					$salepercentage_value = floatval(C('salepercentage_value'));
					$itemmoney[$v['sitem_id']] = ncPriceFormat($accordingitemvalue*($salepercentage_value/100));
				}
			}elseif ($v['sitem_type']== 3){//所得税项
				$expression = $v['sitem_expression'];
				$accordingitemvalue = 0;
				foreach ((array)$sp_itemarr as $k2=>$v2){
					if (strpos($expression,"{{$v2['sitem_name']}}") !== false){
						if (isset($itemmoney[$v2['sitem_id']])){
							$accordingitemvalue = $itemmoney[$v2['sitem_id']];
						}else{
							$accordingitemvalue = $_POST['item'][$v2['sitem_id']];
						}
					}
				}
				//所得税
				$accordingitemvalue = $accordingitemvalue - C('personaltax_start');
				if ($accordingitemvalue > 0 ){
					$percentage = C('personaltax_rateinfo')?unserialize(C('personaltax_rateinfo')):array();
					foreach ((array)$percentage as $percentage_k=>$percentage_v){
						if ($accordingitemvalue > $percentage_v['start'] && $accordingitemvalue <= $percentage_v['end']){
							$itemmoney[$v['sitem_id']] = ncPriceFormat($accordingitemvalue * ($percentage_v['rate']/100) - $percentage_v['deduct']);
						}
					}
				}else {
					$itemmoney[$v['sitem_id']] = ncPriceFormat(0);
				}
			}else {
				$itemmoney[$v['sitem_id']] = ncPriceFormat($_POST['item'][$v['sitem_id']]);
			}
			if (!$itemmoney[$v['sitem_id']]){
				$itemmoney[$v['sitem_id']] = ncPriceFormat(0);
			}
		}
		$result = json_encode($itemmoney);
		showDialog('','','js',"changeItem($result)",0);
	}
	/**
	 * 删除工资卡片
	 */
	public function salarypackemanage_delcard(){
		$spi_id = $_GET['spinfoid'];
		if ($spi_id <= 0){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		//查询工资详细
		$model = Model();
		$where = array();
		//获得所有查询共有条件
		$where['spi_id'] = $spi_id;
		$spi_info = $model->table('salarypacketinfo')->where($where)->find();
		if (empty($spi_info)){
			showDialog(Language::get('bp_salary_table_info_error'),'','error');
		}
		//删除工资详细表
		$rs = $model->table('salarypacketinfo')->where(array('spi_id'=>$spi_id))->delete();
		if ($rs){
			$model->table('salarypacketitem')->where(array('spitem_spid'=>$spi_info['spi_spid'],'spitem_userid'=>$spi_info['spi_userid']))->delete();
			showDialog(Language::get('bp_salary_info_delsucc'),"index.php?act=salary&op=salarypacketmanage&type=add2&spid={$spi_info['spi_spid']}",'succ');
		}else {
			showDialog(Language::get('bp_salary_info_delfailed'),'','error');
		}
	}
	/**
	 * 删除工资表
	 */
	public function salarypackemanage_delpacket(){
		$sp_id = $_GET['spid'];
		if ($sp_id <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		//获得所有查询共有条件
		$where['sp_id'] = $sp_id;
		$sp_info = $model->table('salarypacket')->where($where)->find();
		if (empty($sp_info)){
			showDialog(Language::get('bp_salary_dueto_dataerror_delfailed'),'','error');
		}
		$rs = $model->table('salarypacket')->where(array('sp_id'=>$sp_info['sp_id']))->delete();
		if ($rs) {
			//删除工资详细表
			$model->table('salarypacketinfo')->where(array('spi_spid'=>$sp_id))->delete();
			$model->table('salarypacketitem')->where(array('spitem_spid'=>$sp_id))->delete();
			showDialog(Language::get('bp_salary_info_delsucc'),"index.php?act=salary&op=salarypacket",'succ');
		}else{
			showDialog(Language::get('bp_salary_info_delfailed'),'','error');
		}
	}
	/**
	 * 检查帐套工资项是否发生改变
	 */
	public function salarypackemanage_checkitemchange(){
		$sp_id = $_GET['spid'];
		if ($sp_id <= 0){
			echo -1; die;
		}
		//查询工资包信息
		$model = Model();
		$sp_info = $model->table('salarypacket')->where(array('sp_id'=>$sp_id))->find();
		if (empty($sp_info)){
			echo -1; die;
		}
		//加载帐套缓存
		$salaryclass = ($t = F('salaryclass')) ? $t : H('salaryclass',true,'file');
		$salaryitem_arr = array();
		foreach ((array)$salaryclass[$sp_info['sp_classid']]['item'] as $k=>$v){
			$salaryitem_arr[] = $v;
		}
		if (empty($salaryitem_arr)){
			echo 0; die;
		}
		$item_arr = empty($sp_info['sp_items'])?array():unserialize($sp_info['sp_items']);	
		if ($item_arr == $salaryitem_arr){
			echo 1; die;
		} else {
			echo 0; die;
		}
	}
	/**
	 * 工资表结账
	 */
	public function salarypackemanage_finishpacket(){
		$sp_id = $_GET['spid'];
		if ($sp_id <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$rs = $model->table('salarypacket')->where(array('sp_id'=>$sp_id))->update(array('sp_finishstate'=>'1'));
		if ($rs){
			showDialog(Language::get('bp_salary_settle_succ'),'index.php?act=salary&op=salarypacket','succ');
		}else {
			showDialog(Language::get('bp_salary_settle_failed'),'index.php?act=salary&op=salarypacket','error');
		}
	}
	/**
	 * 个人工资查询
	 */
	public function salarypacketpersonalOp(){
		$model = Model();
		//查询工资详细表
		$where = array();
		$where['spi_userid'] = $_SESSION['member_id'];
		$spinfo_list = $model->table('salarypacket,salarypacketinfo')->join('left')->on('salarypacket.sp_id = salarypacketinfo.spi_spid')->where($where)->order('spi_time desc')->page(20)->select();
		unset($where);
		if (!empty($spinfo_list)){
			$spid_arr = array();
			$usercache = ($t = F('user')) ? $t : H('user',true,'file');
			foreach ((array)$spinfo_list as $k=>$v){
				$v['spi_departmentname'] = $usercache[$v['spi_userid']]['user_departmentname'];
				$v['spi_jobpostname'] = $usercache[$v['spi_userid']]['user_jobpostname'];
				//处理工资表项目
				$v['spi_spitemarr'] = $v['sp_items']?unserialize($v['sp_items']):'';
				$spinfo_listnew[$v['spi_spid']] = $v;
				
				$spid_arr[] = $v['spi_spid'];
			}
			//查询工资项表
			$where = array();
			$where['spitem_userid'] = $_SESSION['member_id'];
			$where['spitem_spid'] = array('in',$spid_arr);
			$spitem_list = $model->table('salarypacketitem')->where($where)->select();
			foreach ((array)$spitem_list as $item_k=>$item_v){
				$spinfo_listnew[$item_v['spitem_spid']]['itemvalue_'.$item_v['spitem_itemid']] = ncPriceFormat($item_v['spitem_money']);
			}
		}
		Tpl::output('spinfo_list',$spinfo_listnew);
		Tpl::output('show_page',$model->showpage(2));
		//左侧菜单
		$this->setleftmenu('salarypacketpersonal');
		Tpl::showpage('salarypacket_personal');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_salary_salaryclass'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'salaryclass','menu_name'=>Language::get('bp_salary_salaryclass_manage'),	'menu_act'=>'salaryclass','menu_op'=>'salaryclassmanage','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'salaryclassview','menu_name'=>Language::get('bp_salary_salaryclass_view'),	'menu_act'=>'salaryclass','menu_op'=>'salaryclassview','linktype'=>'0');
		
		$arr[1] = array('menu_name'=>Language::get('bp_salary_manage'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'salaryuser','menu_name'=>Language::get('bp_salary_staff_salaryclass_setting'),	'menu_act'=>'salary','menu_op'=>'salaryuser','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'salarypacket','menu_name'=>Language::get('bp_salary_salarytable_manage'),	'menu_act'=>'salary','menu_op'=>'salarypacket','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'salarypacketpersonal','menu_name'=>Language::get('bp_salary_personal_salary_search'),	'menu_act'=>'salary','menu_op'=>'salarypacketpersonal','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}