<?php
/**
 * 详细需求管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class requirementControl extends BaseHomeControl{
	private $reqimportant_arr;
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		Language::read('requirement');

		$this->reqimportant_arr = array(1=>Language::get('bp_requirement_is_not_important'),2=>Language::get('bp_requirement_in_general'),3=>Language::get('bp_requirement_important'),4=>Language::get('bp_requirement_it_is_very_important'),);
		Tpl::output('reqimportant_arr',$this->reqimportant_arr);

		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['req_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['req_userid'] = $_SESSION['member_id'];
		}
	}
	/**
	 * 需求列表
	 */
	public function requirementlistOp(){
		$model = Model();
		$where = $this->commonwhere;
		if (!empty($_GET['search_content'])){
			$where['req_title|req_content'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		if (!empty($_GET['search_cname'])){
			$where['req_customername'] = array('like',"%{$_GET['search_cname']}%");
		}
		if (!empty($_GET['search_chance'])){
			$where['req_chancetitle'] = array('like',"%{$_GET['search_chance']}%");
		}
		if (!empty($_GET['search_important'])){
			$where['req_importantdegree'] = $_GET['search_important'];
		}
		if (!empty($_GET['search_complete'])){
			$where['req_completedegree'] = intval($_GET['search_complete'])-1;
		}
		$req_list = $model->table('requirement')->where($where)->order('req_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('req_list',$req_list);
		//左侧菜单
		$this->setleftmenu('requirementlist');
		Tpl::showpage('requirementlist');
	}
	/**
	 * 新添加详细需求
	 */
	public function requirementaddOp(){
		//实例化模型
		$model = Model();
		//添加日程
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["req_cid"],"require"=>"true","message"=>Language::get('bp_requirement_please_select_a_membership'));
			$validate_arr[] = array("input"=>$_POST["req_title"],"require"=>"true","message"=>Language::get('bp_requirement_please_fill_out_the_demand_for_the_title'));
			$validate_arr[] = array("input"=>$_POST["req_content"],"require"=>"true","message"=>Language::get('bp_requirement_please_fill_out_the_required_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>intval($_POST["req_cid"]),'cc_isdel'=>0,'cc_insea'=>0))->find();
			if(empty($customer_info)){
				showDialog(Language::get('bp_requirement_member_information_does_not_exist_or_has_entered'),'','error');
			}
			$insert_array = array();
			$insert_array['req_customerid'] = $customer_info['cc_id'];
			$insert_array['req_customername'] = $customer_info['cc_name'];
			if(intval($_POST['req_chance']) > 0){
				$insert_array['req_chanceid'] = intval($_POST['req_chance']);
				$insert_array['req_chancetitle'] = $_POST['req_chancetitle'];
			}
			$insert_array['req_title'] = trim($_POST['req_title']);
			$insert_array['req_adduserid'] = $_SESSION['member_id'];
			$insert_array['req_addusername'] = $_SESSION['truename'];
			$insert_array['req_adddepartmentid'] = $_SESSION['dp_id'];
			$insert_array['req_userid'] = $_SESSION['member_id'];
			$insert_array['req_username'] = $_SESSION['truename'];
			$insert_array['req_departmentid'] = $_SESSION['dp_id'];
			$insert_array['req_recordtime'] = $_POST['req_recordtime']?strtotime($_POST['req_recordtime']):0;
			$insert_array['req_addtime'] = time();
			$insert_array['req_importantdegree'] = $_POST['req_important'];
			$insert_array['req_content'] = trim($_POST['req_content']);
			$insert_array['req_completedegree'] = intval($_POST['req_degree']);
			$rs = $model->table('requirement')->insert($insert_array);

			$url = 'index.php?act=requirement&op=requirementlist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$insert_array['req_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_array['req_customerid'];
			}
			if($rs){
				showDialog(Language::get('bp_requirement_need_to_add_success'),$url,'succ');
			}else{
				showDialog(Language::get('bp_requirement_need_to_add_failure'),'','error');
			}
		}else{
			//如果来自会员详情页面则调取该会员信息
			if(intval($_GET['cc_id']) > 0){
				$cc_id = intval($_GET['cc_id']);
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$cc_id,'cc_isdel'=>0))->find();
				if(empty($cc_info)){
					showMessage(Language::get('bp_requirement_member_information_does_not_exist_or_has_entered'));
				}else{
					//查询销售机会信息
					$chancelist = $model->table('chance')->where(array('cha_customerid'=>$cc_info['cc_id'],'cha_istrash'=>0))->select();
					Tpl::output('cc_info',$cc_info);
					Tpl::output('chancelist',$chancelist);
				}
			}elseif (intval($_GET['chance_id']) > 0){
				$chance_id = intval($_GET['chance_id']);
				//查询销售机会详细
				$chance_info = $model->table('chance')->where(array('cha_id'=>$chance_id,'cha_istrash'=>0))->find();
				if(empty($chance_info)){
					showMessage(Language::get('bp_requirement_sales_lead_information_does_not_exist_or_has'));
				}else{
					//查询会员
					$cc_info  = $model->table('customer')->where(array('cc_id'=>$chance_info['cha_customerid'],'cc_isdel'=>0))->find();
					if(empty($cc_info)){
						showMessage(Language::get('bp_requirement_sales_lead_information_errors').Language::get('bp_comma').Language::get('bp_requirement_unable_to_add_demand'));
					}
					Tpl::output('chance_info',$chance_info);
				}
			}
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			//左侧菜单
			$this->setleftmenu('requirementlist');
			//模板输出
			Tpl::showpage('requirementadd');
		}
	}
	/*
	 * 需求编辑
	 */
	public function requirementeditOp(){
		$reqid = intval($_GET['reqid']);
		if ($reqid<=0){
			$reqid = intval($_POST['reqid']);
		}
		if ($reqid<=0){
			showDialog(Language::get('bp_requirement_parameter_error'),'','error');
		}
		//实例化模型
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		$where['req_id'] = $reqid;
		//查询需求详细
		$req_info = $model->table('requirement')->where($where)->find();
		if(empty($req_info)){
			showDialog(Language::get('bp_requirement_wrong_information'),'','error');
		}
		//编辑需求
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["req_title"],"require"=>"true","message"=>Language::get('bp_requirement_please_fill_out_the_demand_for_the_title'));
			$validate_arr[] = array("input"=>$_POST["req_content"],"require"=>"true","message"=>Language::get('bp_requirement_please_fill_out_the_required_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['req_title'] = trim($_POST['req_title']);
			$update_arr['req_recordtime'] = $_POST['req_recordtime']?strtotime($_POST['req_recordtime']):0;
			$update_arr['req_importantdegree'] = $_POST['req_important'];
			$update_arr['req_content'] = trim($_POST['req_content']);
			$update_arr['req_completedegree'] = intval($_POST['req_degree']);
			$rs = $model->table('requirement')->where(array('req_id'=>$req_info['req_id']))->update($update_arr);
			$url = 'index.php?act=requirement&op=requirementlist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$req_info['req_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$req_info['req_customerid'];
			}
			if($rs){
				showDialog(Language::get('bp_requirement_need_to_edit_success'),$url,'succ');
			}else{
				showDialog(Language::get('bp_requirement_need_to_edit_failed'),'','error');
			}
		}else{
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			Tpl::output('req_info',$req_info);
			//左侧菜单
			$this->setleftmenu('requirementlist');
			//模板输出
			Tpl::showpage('requirementadd');
		}
	}
	/**
	 * 删除需求
	 */
	public function requirementdelOp(){
		$reqid = $_GET['reqid'];
		if (empty($reqid)){
			$reqid = $_POST['reqid'];
		}
		if (empty($reqid)){
			showDialog(Language::get('bp_requirement_parameter_error'),'','error');
		}
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		if (is_array($reqid)){
			$where['req_id'] = array('in',$reqid);
		}else {
			$where['req_id'] = $reqid;
		}
		$rs = $model->table('requirement')->where($where)->delete();
		$url = 'index.php?act=requirement&op=requirementlist';
		if(intval($_GET['cc_id']) > 0){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}elseif (intval($_GET['chance_id']) > 0){
			$url = 'index.php?act=chance&op=chanceview&cid='.intval($_GET['chance_id']);
		}
		if ($rs){
			showDialog(Language::get('bp_requirement_delete_the_success'),$url,'succ');
		} else {
			showDialog(Language::get('bp_requirement_delete_failed'),'','error');
		}
	}
	/*
	 * 需求查看
	 */
	public function requirementviewOp(){
		$reqid = intval($_GET['reqid']);
		if ($reqid<=0){
			showDialog(Language::get('bp_requirement_parameter_error'),'','error');
		}
		//实例化模型
		$model = Model();
		//查询需求详细
		$req_info = $model->table('requirement')->where(array('req_id'=>$reqid))->find();
		if(empty($req_info)){
			showDialog(Language::get('bp_requirement_wrong_information'),'','error');
		}
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		$url = 'index.php?act=requirement&op=requirementlist';
		if ($source == 'chance'){
			$url = 'index.php?act=chance&op=chanceview&cid='.$req_info['req_chanceid'];
		}elseif ($source == 'customer'){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.$req_info['req_customerid'];
		}
		Tpl::output('backurl',$url);
		Tpl::output('source',$source);
		Tpl::output('req_info',$req_info);
		//模板输出
		Tpl::showpage('requirementview','windowopen_layout');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_requirement_sales_opportunities'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'chancelist','menu_name'=>Language::get('bp_requirement_opportunity_management'),'menu_act'=>'chance','menu_op'=>'chancelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'chancetransfer','menu_name'=>Language::get('bp_requirement_opportunity_to_transfer'),'menu_act'=>'chance','menu_op'=>'chancetransfer','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'chancetransferlog','menu_name'=>Language::get('bp_requirement_transfer_the_log'),'menu_act'=>'chance','menu_op'=>'chancetransfer','menu_url'=>'index.php?act=chance&op=chancetransfer&type=log','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'chancefiller','menu_name'=>Language::get('bp_requirement_the_sales_funnel'),'menu_act'=>'chance','menu_op'=>'chancefiller','linktype'=>'0');

		$arr[1] = array('menu_name'=>Language::get('bp_requirement_sales_tracking'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'requirementlist','menu_name'=>Language::get('bp_requirement_membership_requirements'),'menu_act'=>'requirement','menu_op'=>'requirementlist','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'solutionlist','menu_name'=>Language::get('bp_requirement_the_solution'),'menu_act'=>'solution','menu_op'=>'solutionlist','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'quotedpricelist','menu_name'=>Language::get('bp_requirement_bid_management'),'menu_act'=>'quotedprice','menu_op'=>'quotedpricelist','linktype'=>'0');
		$arr[1]['submenu'][3] = array('menu_key'=>'competitorlist','menu_name'=>Language::get('bp_requirement_competitors'),'menu_act'=>'competitor','menu_op'=>'competitorlist','linktype'=>'0');

		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}