<?php
/**
 * 报告页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class reportControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('report');
    }

	/**
	 * 报告列表
	 */
	public function reportlistOp(){
		$where = array();
		$where['rpt_userid'] = $_SESSION['member_id'];
		$where['rpt_type'] = 0;
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 1:
					$where['rpt_issubmit'] = 0;
					break;
				case 2:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 2;
					break;
			}
		}
		if (!empty($_GET['search_content'])){
			$where['rpt_summary|rpt_plan'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['rpt_recordtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['rpt_recordtime'] = array('elt',"$etime");
		}

		$model = Model();
		$reportlist = $model->table('report')->where($where)->order('rpt_recordtime desc')->page(10)->select();
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		$this->setleftmenu('reportlist');
		Tpl::showpage('reportlist');
	}
	/**
	 * 周报列表
	 */
	public function reportweeklistOp(){
		$where = array();
		$where['rpt_userid'] = $_SESSION['member_id'];
		$where['rpt_type'] = 1;
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 1:
					$where['rpt_issubmit'] = 0;
					break;
				case 2:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 2;
					break;
			}
		}
		if (!empty($_GET['search_content'])){
			$where['rpt_summary|rpt_plan'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['rpt_recordtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['rpt_recordtime'] = array('elt',"$etime");
		}
		$model = Model('report');
		$reportlist = $model->getReportWeekList($where,10);
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		$this->setleftmenu('reportlist');
		Tpl::showpage('reportlist_week');
	}
	/**
	 * 月报列表
	 */
	public function reportmonthlistOp(){
		$where = array();
		$where['rpt_userid'] = $_SESSION['member_id'];
		$where['rpt_type'] = 2;
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 1:
					$where['rpt_issubmit'] = 0;
					break;
				case 2:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_issubmit'] = 1;
					$where['rpt_pass'] = 2;
					break;
			}
		}
		if (!empty($_GET['search_content'])){
			$where['rpt_summary|rpt_plan'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		$year = intval($_GET['r_year']);
		$month = intval($_GET['r_month']);
		if ($year > 0 && $month > 0){
			$stime = mktime(0, 0, 0, $month, 1, $year);
			$etime = mktime(0, 0, 0, $month+1, 0, $year);
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($year > 0){
			$stime = mktime(0, 0, 0, 1, 1, $year);
			$etime = mktime(0, 0, 0, 12, 31, $year);
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}
		$model = Model('report');
		$reportlist = $model->getReportMonthList($where,10);
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		//年
		$year_arr = getSystemYearArr();
		//月
		$month_arr = getSystemMonthArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('month_arr',$month_arr);
		$this->setleftmenu('reportlist');
		Tpl::showpage('reportlist_month');
	}
	/*
	 * 写日报
	 */
	public function reportdayaddOp(){
		$model = Model();
		//查询当日报告记录
		$date = date('Y-m-d',time());
		if(!empty($_GET['date'])){
			$date = $_GET['date'];
		}
		if(!empty($_POST['r_time'])){
			$date = $_POST["r_time"];
		}
		$datetime = ($t = strtotime($date))>0?$t:0;
		$reportinfo = $model->table('report')->where(array('rpt_userid'=>$_SESSION['member_id'],'rpt_type'=>0,'rpt_recordtime'=>$datetime))->find();
		if (chksubmit()){
			$this->addreport(0,$datetime,$reportinfo);
		}else{
			$reportinfo['rpt_recorddate'] = $date;
			Tpl::output('reportinfo',$reportinfo);
			$this->setleftmenu('reportlist');
			Tpl::showpage('reportadd_day');
		}
	}
	/*
	 * 写周报
	 */
	public function reportweekaddOp(){
		$model = Model();
		//查询本周报告记录
		$end_num = 0;//本周的前num周
		if(!empty($_GET['r_num'])){
			$end_num = intval($_GET['r_num']);
		}
		if(!empty($_POST['r_num'])){
			$end_num = intval($_POST['r_num']);
		}
		$end_time = strtotime("{$end_num} week Sunday");
		$start_time = $end_time - 86400*6;

		$start_date = date('Y-m-d',$start_time);
		$end_date = date('Y-m-d',$end_time);

		$where = array();
		$where['rpt_userid'] = $_SESSION['member_id'];
		$where['rpt_type'] = 1;
		$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
		$reportinfo = $model->table('report')->where($where)->find();
		if (chksubmit()){
			$this->addreport(1,$end_time,$reportinfo);
		}else{
			$start_date = date('Y-m-d',$start_time);
			$end_date = date('Y-m-d',$end_time);
			Tpl::output('end_num',$end_num);
			Tpl::output('start_date',$start_date);
			Tpl::output('end_date',$end_date);
			Tpl::output('reportinfo',$reportinfo);
			$this->setleftmenu('reportlist');
			Tpl::showpage('reportadd_week');
		}
	}
	/*
	 * 写月报
	 */
	public function reportmonthaddOp(){
		$model = Model();
		//年
		$year_arr = getSystemYearArr();
		//月
		$month_arr = getSystemMonthArr();
		//查询本月报告记录
		$year = date('Y');
		$month = date('m');
		if(!empty($_GET['r_year']) && !empty($_GET['r_month'])){
			$year = intval($_GET['r_year']);
			$month = intval($_GET['r_month']);
		}
		if(!empty($_POST['r_year']) && !empty($_POST['r_month'])){
			$year = intval($_POST['r_year']);
			$month = intval($_POST['r_month']);
		}
		if(!in_array($year,$year_arr) || !in_array($month,$month_arr)){
			$year = date('Y');
			$month = date('m');
		}
		$start_time = mktime(0, 0, 0, $month, 1, $year);
		$end_time = mktime(0, 0, 0, $month+1, 0, $year);

		$where = array();
		$where['rpt_userid'] = $_SESSION['member_id'];
		$where['rpt_type'] = 2;
		$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
		$reportinfo = $model->table('report')->where($where)->find();
		if (chksubmit()){
			$this->addreport(2,$end_time,$reportinfo);
		}else{
			Tpl::output('year',$year);
			Tpl::output('month',$month);
			Tpl::output('year_arr',$year_arr);
			Tpl::output('month_arr',$month_arr);
			Tpl::output('reportinfo',$reportinfo);
			$this->setleftmenu('reportlist');
			Tpl::showpage('reportadd_month');
		}
	}
	/*
	 * 添加报告记录
	 */
	private function addreport($type,$recordtime,$reportinfo=array()){
		switch($type){
			case 1:
				$op = 'reportweeklist';
				break;
			case 2:
				$op = 'reportmonthlist';
				break;
			default:
				$op = 'reportlist';
				break;
		}
		if($reportinfo['rpt_pass'] == 1){//通过后不可再编辑
			showDialog(Language::get('bp_report_operation_is_successful'),'index.php?act=report&op='+$op,'succ');
		}
		$obj_validate = new Validate();
		$validate_arr[] = array("input"=>$_POST["summary_content"],"require"=>"true","message"=>Language::get('bp_report_please_add_a_summary'));
		$obj_validate -> validateparam = $validate_arr;
		$error = $obj_validate->validate();
		if ($error != ''){
			showDialog($error,'','error');
		}
		$model = Model();
		//查询需要报告给的岗位信息
		$jp_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id'],'jp_state'=>'1'))->find();
		if(empty($jp_info)){
			showDialog(Language::get('bp_report_post_information_is_wrong'),'','error');
		}
		if(empty($reportinfo)){
			$insert = array();
			$insert['rpt_userid'] = $_SESSION['member_id'];
			$insert['rpt_username'] = $_SESSION['truename'];
			$insert['rpt_jpid'] = $jp_info['jp_reportto'];
			$insert['rpt_type'] = $type;
			$insert['rpt_summary'] = $_POST["summary_content"];
			$insert['rpt_plan'] = $_POST["plan_content"];
			$insert['rpt_issubmit'] = $_POST['savetype'] == 'handin'?1:0;
			$insert['rpt_recordtime'] = $recordtime;
			$date = date('Y-m-d',time());
			$insert['rpt_submittime'] = strtotime($date);
			//计算延迟天数
			$insert['rpt_delaydays'] = ($t= ($insert['rpt_submittime'] - $insert['rpt_recordtime'])/86400) <= 0?0:$t;
			$rs = $model->table('report')->insert($insert);
		}else{
			$update = array();
			$update['rpt_jpid'] = $jp_info['jp_reportto'];
			$update['rpt_summary'] = $_POST["summary_content"];
			$update['rpt_plan'] = $_POST["plan_content"];
			if($reportinfo['rpt_issubmit'] == 0){//第一次提交时，才记录提交时间
				$update['rpt_issubmit'] = $_POST['savetype'] == 'handin'?1:0;
				$date = date('Y-m-d',time());
				$update['rpt_submittime'] = strtotime($date);
				//计算延迟天数
				$update['rpt_delaydays'] = ($t= ($update['rpt_submittime'] - $reportinfo['rpt_recordtime'])/86400) <= 0?0:$t;
			}
			$rs = $model->table('report')->where(array('rpt_id'=>$reportinfo['rpt_id']))->update($update);
		}
		if($rs){
			showDialog(Language::get('bp_report_operation_is_successful'),'index.php?act=report&op='.$op,'succ');
		}else{
			showDialog(Language::get('bp_report_the_operation_failure'),'','error');
		}
	}
	/*
	 * 批复管理
	 */
	public function reportreplyOp(){
		if (!empty($_GET['type'])){
			$funname = "reply".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//日报列表
			$this->replylist();
		}
	}
	/*
	 * 获得员工和岗位列表
	 */
	private function getUserList(){
		//查询报告给该岗位的员工
		$model = Model('user');
		$userlist = $model->getUserAndJobpostList(array('jp_reportto'=>$_SESSION['jp_id'],'user_state'=>'0'));
		return $userlist;
	}
	/*
	 * 批复日报列表
	 */
	private function replylist(){
		$where = array();
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_type'] = 0;
		$where['rpt_issubmit'] = 1;
		//员工
		if (!empty($_GET['search_user'])){
			$where['rpt_userid'] = $_GET['search_user'];
		}
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 2:
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_pass'] = 2;
					break;
			}
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['rpt_recordtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['rpt_recordtime'] = array('elt',"$etime");
		}
		$model = Model();
		$reportlist = $model->table('report')->where($where)->order('rpt_recordtime desc')->page(10)->select();
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		$userlist = $this->getUserList();
		Tpl::output('userlist',$userlist);
		$this->setleftmenu('reportreply');
		Tpl::showpage('reportreplylist');
	}
	/*
	 * 批复周报列表
	 */
	private function replyweeklist(){
		$where = array();
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_type'] = 1;
		$where['rpt_issubmit'] = 1;
		//员工
		if (!empty($_GET['search_user'])){
			$where['rpt_userid'] = $_GET['search_user'];
		}
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 2:
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_pass'] = 2;
					break;
			}
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['rpt_recordtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['rpt_recordtime'] = array('elt',"$etime");
		}
		$model = Model('report');
		$reportlist = $model->getReportWeekList($where,10);
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		$userlist = $this->getUserList();
		Tpl::output('userlist',$userlist);
		$this->setleftmenu('reportreply');
		Tpl::showpage('reportreplylist_week');
	}
	/*
	 * 批复月报列表
	 */
	private function replymonthlist(){
		$where = array();
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_type'] = 2;
		$where['rpt_issubmit'] = 1;
		//员工
		if (!empty($_GET['search_user'])){
			$where['rpt_userid'] = $_GET['search_user'];
		}
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 2:
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_pass'] = 2;
					break;
			}
		}
		//时间
		$year = intval($_GET['r_year']);
		$month = intval($_GET['r_month']);
		if ($year > 0 && $month > 0){
			$stime = mktime(0, 0, 0, $month, 1, $year);
			$etime = mktime(0, 0, 0, $month+1, 0, $year);
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($year > 0){
			$stime = mktime(0, 0, 0, 1, 1, $year);
			$etime = mktime(0, 0, 0, 12, 31, $year);
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}
		$model = Model('report');
		$reportlist = $model->getReportMonthList($where,10);
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		//年
		$year_arr = getSystemYearArr();
		//月
		$month_arr = getSystemMonthArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('month_arr',$month_arr);

		$userlist = $this->getUserList();
		Tpl::output('userlist',$userlist);
		$this->setleftmenu('reportreply');
		Tpl::showpage('reportreplylist_month');
	}
	/*
	 * 批复日报
	 */
	private function replydayadd(){
		$model = Model();
		//查询当日报告记录
		if(!empty($_GET['r_time']) && !empty($_GET['uid'])){
			$date = $_GET['r_time'];
			$uid = $_GET['uid'];
		}
		if(!empty($_POST['r_time']) && !empty($_POST['uid'])){
			$date = $_POST["r_time"];
			$uid = $_POST['uid'];
		}
		if(empty($date) || empty($uid)){
			showDialog(Language::get('bp_report_parameter_error'),'index.php?act=report&op=reportreply','error');
		}
		$datetime = strtotime($date);
		$reportinfo = $model->table('report')->where(array('rpt_userid'=>$uid,'rpt_type'=>0,'rpt_recordtime'=>$datetime,'rpt_jpid'=>$_SESSION['jp_id'],'rpt_issubmit'=>1))->find();
		if (chksubmit()){
			if(empty($reportinfo)){
				showDialog(Language::get('bp_report_logging_the_error'),'index.php?act=report&op=reportreply','error');
			}
			$this->addreply(0,$reportinfo);
		}else{
			Tpl::output('reportinfo',$reportinfo);
			$userlist = $this->getUserList();
			Tpl::output('userlist',$userlist);
			Tpl::output('uid',$uid);
			Tpl::output('r_time',$date);
			$this->setleftmenu('reportreply');
			Tpl::showpage('reportreplyadd_day');
		}
	}
	/*
	 * 批复周报
	 */
	public function replyweekadd(){
		$model = Model();
		//查询本周报告记录
		$end_num = 0;
		if(isset($_GET['r_num']) && !empty($_GET['uid'])){
			$end_num = intval($_GET['r_num']);
			$uid = $_GET['uid'];
		}
		if(isset($_POST['r_num']) && !empty($_POST['uid'])){
			$end_num = intval($_POST['r_num']);
			$uid = $_POST['uid'];
		}
		if(!isset($end_num) || empty($uid)){
			showDialog(Language::get('bp_report_parameter_error'),'index.php?act=report&op=reportreply&type=weeklist','error');
		}
		$end_time = strtotime("{$end_num} week Sunday");
		$start_time = $end_time - 86400*6;

		$start_date = date('Y-m-d',$start_time);
		$end_date = date('Y-m-d',$end_time);

		$where = array();
		$where['rpt_userid'] = $uid;
		$where['rpt_type'] = 1;
		$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_issubmit'] = 1;
		$reportinfo = $model->table('report')->where($where)->find();
		if (chksubmit()){
			if(empty($reportinfo)){
				showDialog(Language::get('bp_report_logging_the_error'),'index.php?act=report&op=reportreply&type=weeklist','error');
			}
			$this->addreply(1,$reportinfo);
		}else{
			$start_date = date('Y-m-d',$start_time);
			$end_date = date('Y-m-d',$end_time);
			Tpl::output('end_num',$end_num);
			Tpl::output('start_date',$start_date);
			Tpl::output('end_date',$end_date);
			Tpl::output('uid',$uid);
			Tpl::output('reportinfo',$reportinfo);
			$userlist = $this->getUserList();
			Tpl::output('userlist',$userlist);
			$this->setleftmenu('reportreply');
			Tpl::showpage('reportreplyadd_week');
		}
	}
	/*
	 * 批复月报
	 */
	private function replymonthadd(){
		$model = Model();
		//年
		$year_arr = getSystemYearArr();
		//月
		$month_arr = getSystemMonthArr();
		//查询本月报告记录
		$year = date('Y');
		$month = date('m');
		if(!empty($_GET['r_year']) && !empty($_GET['r_month'])){
			$year = intval($_GET['r_year']);
			$month = intval($_GET['r_month']);
			$uid = $_GET['uid'];
		}
		if(!empty($_POST['r_year']) && !empty($_POST['r_month'])){
			$year = intval($_POST['r_year']);
			$month = intval($_POST['r_month']);
			$uid = $_POST['uid'];
		}
		if(empty($uid) || !in_array($year,$year_arr) || !in_array($month,$month_arr)){
			showDialog(Language::get('bp_report_parameter_error'),'index.php?act=report&op=reportreply&type=weeklist','error');
		}
		$start_time = mktime(0, 0, 0, $month, 1, $year);
		$end_time = mktime(0, 0, 0, $month+1, 0, $year);

		$where = array();
		$where['rpt_userid'] = $uid;
		$where['rpt_type'] = 2;
		$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_issubmit'] = 1;
		$reportinfo = $model->table('report')->where($where)->find();
		if (chksubmit()){
			if(empty($reportinfo)){
				showDialog(Language::get('bp_report_logging_the_error'),'index.php?act=report&op=reportreply&type=weeklist','error');
			}
			$this->addreply(2,$reportinfo);
		}else{
			Tpl::output('year',$year);
			Tpl::output('month',$month);
			Tpl::output('year_arr',$year_arr);
			Tpl::output('month_arr',$month_arr);
			Tpl::output('reportinfo',$reportinfo);
			Tpl::output('uid',$uid);
			$userlist = $this->getUserList();
			Tpl::output('userlist',$userlist);
			$this->setleftmenu('reportreply');
			Tpl::showpage('reportreplyadd_month');
		}
	}
	/*
	 * 添加批复信息
	 */
	private function addreply($type,$reportinfo=array()){
		if($reportinfo['rpt_pass'] == 1){//通过后不可再编辑
			showDialog(Language::get('bp_report_operation_is_successful'),'','succ');
		}
		if(empty($_POST["ispass"])){
			showDialog(Language::get('bp_report_please_select_state_of_examination_and_approval'),'','error');
		}
		$model = Model();
		$update = array();
		if(in_array($_POST["ispass"],array(0,1,2))){
			$update['rpt_pass'] = $_POST["ispass"];
		}else{
			$update['rpt_pass'] = 0;
		}
		$update['rpt_replytext'] = $_POST["reply_content"];
		$rs = $model->table('report')->where(array('rpt_id'=>$reportinfo['rpt_id']))->update($update);
		$url = getReferer();
		if($rs){
			showDialog(Language::get('bp_report_operation_is_successful'),$url,'succ');
		}else{
			showDialog(Language::get('bp_report_the_operation_failure'),$url,'error');
		}
	}
	/**
	 * 提交统计
	 */
	public function reportsubmitstatOp(){
		if (!empty($_GET['type'])){
			$funname = "submitstat".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//日报列表
			$this->submitstatday();
		}
	}
	/**
	 * 日报一个月统计
	 */
	private function submitstatday(){
		//查询某月的日报
		$where = array();
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_type'] = 0;
		$where['rpt_issubmit'] = 1;

		$year = date('Y',time());
		$month = date('m',time());
		if (!empty($_GET['year']) && !empty($_GET['month'])){
			$year = $_GET['year'];
			$month = $_GET['month'];
		}elseif (!empty($_POST['year']) && !empty($_POST['month'])){
			$year = $_POST['year'];
			$month = $_POST['month'];
		}
		$stime = strtotime($year.'-'.$month.'-01');
		$etime = strtotime(date('Y-m-t', strtotime($year.'-'.$month)));
		$where['rpt_recordtime'] = array(array('egt',$stime),array('elt',$etime),'and');
		$model = Model();
		$report_list = $model->table('report')->where($where)->select();
		//月份应用天数
		$daynum = date('t',$stime);
		if (!empty($report_list)){
			$report_listnew = array();
			foreach ((array)$report_list as $k=>$v) {
				$day = date('j',$v['rpt_recordtime']);
				$tmp = array();
				$tmp['submitted'] = true;//已经提交
				$tmp['rpt_delaydays'] = $v['rpt_delaydays'];//延误天数
				$report_listnew[$v['rpt_userid']][$day] = $tmp;
				$report_listnew[$v['rpt_userid']]['info'] = $v;
			}
			foreach ((array)$report_listnew as $k_one=>$v_one){
				for ($i=1;$i<=$daynum;$i++){
					if (!isset($v_one[$i])){
						$report_listnew[$k_one][$i] = array('submitted'=>false);
					}
				}
				ksort($report_listnew[$k_one]);
			}
			//构造一周第几天的数组
			$week_arr = array();
			for ($i=1;$i<=$daynum;$i++){
				$week_arr[$i]['num'] = date('N',strtotime($year.'-'.$month.'-'.$i));
				switch ($week_arr[$i]['num']){
					case 1:
						$week_arr[$i]['text'] = Language::get('bp_report_a');
						break;
					case 2:
						$week_arr[$i]['text'] = Language::get('bp_report_(2)');
						break;
					case 3:
						$week_arr[$i]['text'] = Language::get('bp_report_three');
						break;
					case 4:
						$week_arr[$i]['text'] = Language::get('bp_report_four');
						break;
					case 5:
						$week_arr[$i]['text'] = Language::get('bp_report_five');
						break;
					case 6:
						$week_arr[$i]['text'] = Language::get('bp_report_six');
						break;
					case 7:
						$week_arr[$i]['text'] = Language::get('bp_report_day');
						break;
				}
			}
		}
		Tpl::output('daynum',$daynum);
		Tpl::output('report_list',$report_listnew);
		Tpl::output('week_arr',$week_arr);
		Tpl::output('year',$year);
		Tpl::output('month',$month);
		//年
		$year_arr = getSystemYearArr();
		//月
		$month_arr = getSystemMonthArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('month_arr',$month_arr);
		$this->setleftmenu('reportsubmitstat');
		Tpl::showpage('reportsubmitstat_day');
	}
	/**
	 * 周报一个月统计
	 */
	private function submitstatweek(){
		//查询某月的周报
		$where = array();
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_type'] = 1;
		$where['rpt_issubmit'] = 1;

		$year = date('Y',time());
		if (!empty($_GET['year'])){
			$year = $_GET['year'];
		}elseif (!empty($_POST['year'])){
			$year = $_POST['year'];
		}
		$stime = strtotime($year.'-01-01');
		$etime = strtotime($year.'-12-31');
		$where['rpt_recordtime'] = array(array('egt',$stime),array('elt',$etime),'and');
		$model = Model();
		$report_list = $model->table('report')->where($where)->select();

		//计算出一年中按照周划分的数组
		//一年的第一周有几天
		$firstweekday = (7 - date('N',strtotime($year.'-01-01')) +1);
		//计算第一个周一的时间
		$starttime = strtotime($year.'-01-01')+3600*24*$firstweekday;
		//一年的最后一周有几天
		$lastweekday = date('N',strtotime($year.'-12-31'));
		//一年的最后一个周末的时间
		$endtime = strtotime($year.'-12-31')-3600*24*$lastweekday;
		$step = 3600*24*7;//步长值
		$week_arr = array();
		$countweek = 0;
		for ($i=$starttime;$i<$endtime;$i= $i+3600*24*7){
			$current_month = date('n',$i);
			$countweek++;
			$week_arr[$current_month][]  = $countweek;
		}
		if (!empty($report_list)){
			$report_listnew = array();
			foreach ((array)$report_list as $k=>$v) {
				$week = date('W',$v['rpt_recordtime']);
				$tmp = array();
				$tmp['submitted'] = true;//已经提交
				$tmp['rpt_delaydays'] = $v['rpt_delaydays'];//延误天数
				$report_listnew[$v['rpt_userid']][$week] = $tmp;
				$report_listnew[$v['rpt_userid']]['info'] = $v;
			}
			foreach ((array)$report_listnew as $k_one=>$v_one){
				for ($i=1;$i<=$countweek;$i++){
					if (!isset($v_one[$i])){
						$report_listnew[$k_one][$i] = array('submitted'=>false);
					}
				}
				ksort($report_listnew[$k_one]);
			}
		}

		//年
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('week_arr',$week_arr);
		Tpl::output('countweek',$countweek);
		Tpl::output('report_list',$report_listnew);
		Tpl::output('year',$year);
		$this->setleftmenu('reportsubmitstat');
		Tpl::showpage('reportsubmitstat_week');
	}
	/**
	 * 月报一个月统计
	 */
	private function submitstatmonth(){
		//查询某月的周报
		$where = array();
		$where['rpt_jpid'] = $_SESSION['jp_id'];
		$where['rpt_type'] = 2;
		$where['rpt_issubmit'] = 1;

		$year = date('Y',time());
		if (!empty($_GET['year'])){
			$year = $_GET['year'];
		}elseif (!empty($_POST['year'])){
			$year = $_POST['year'];
		}
		$stime = strtotime($year.'-01-01');
		$etime = strtotime($year.'-12-31');
		$where['rpt_recordtime'] = array(array('egt',$stime),array('elt',$etime),'and');
		$model = Model();
		$report_list = $model->table('report')->where($where)->select();
		if (!empty($report_list)){
			$report_listnew = array();
			foreach ((array)$report_list as $k=>$v) {
				$month = date('n',$v['rpt_recordtime']);
				$tmp = array();
				$tmp['submitted'] = true;//已经提交
				$tmp['rpt_delaydays'] = $v['rpt_delaydays'];//延误天数
				$report_listnew[$v['rpt_userid']][$month] = $tmp;
				$report_listnew[$v['rpt_userid']]['info'] = $v;
			}
			foreach ((array)$report_listnew as $k_one=>$v_one){
				for ($i=1;$i<=12;$i++){
					if (!isset($v_one[$i])){
						$report_listnew[$k_one][$i] = array('submitted'=>false);
					}
				}
				ksort($report_listnew[$k_one]);
			}
		}
		//年
		$year_arr = getSystemYearArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('report_list',$report_listnew);
		Tpl::output('year',$year);
		$this->setleftmenu('reportsubmitstat');
		Tpl::showpage('reportsubmitstat_month');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_report_daily_weekly_monthly_management'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'reportlist','menu_name'=>Language::get('bp_report_report_to_management'),'menu_act'=>'report','menu_op'=>'reportlist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'reportreply','menu_name'=>Language::get('bp_report_management_approval'),'menu_act'=>'report','menu_op'=>'reportreply','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'reportsubmitstat','menu_name'=>Language::get('bp_report_submit_case'),'menu_act'=>'report','menu_op'=>'reportsubmitstat','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}