<?php
/**
 * 报价管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class quotedpriceControl extends BaseHomeControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
        Language::read('quotedprice');

		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['qp_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['qp_userid'] = $_SESSION['member_id'];
		}
		Language::read('quotedprice');
	}
	/**
	 * 报价列表
	 */
	public function quotedpricelistOp(){
		$model = Model();
		$where = $this->commonwhere;
		if (!empty($_GET['search_title'])){
			$where['qp_title'] = array(array('like',"%{$_GET['search_title']}%"));
		}
		if (!empty($_GET['search_cname'])){
			$where['qp_customername'] = array('like',"%{$_GET['search_cname']}%");
		}
		if (!empty($_GET['search_cccname'])){
			$where['qp_contactname'] = array('like',"%{$_GET['search_cccname']}%");
		}
		if (!empty($_GET['search_chance'])){
			$where['qp_chancetitle'] = array('like',"%{$_GET['search_chance']}%");
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['qp_quotationdate'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['qp_quotationdate'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['qp_quotationdate'] = array('elt',"$etime");
		}
		$qp_list = $model->table('quotedprice')->where($where)->order('qp_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('qp_list',$qp_list);
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		Tpl::output('dic_array',$dic_array);
		//左侧菜单
		$this->setleftmenu('quotedpricelist');
		Tpl::showpage('quotedpricelist');
	}
	/**
	 * 新添加详细报价单
	 */
	public function quotedpriceaddOp(){
		//实例化模型
		$model = Model();
		//添加日程
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["qp_cid"],"require"=>"true","message"=>Language::get('bp_quotedprice_please_select_a_membership'));
			$validate_arr[] = array("input"=>$_POST["qp_title"],"require"=>"true","message"=>Language::get('bp_quotedprice_please_fill_in_the_title'));
			$validate_arr[] = array("input"=>$_POST["qp_qdate"],"require"=>"true","message"=>Language::get('bp_quotedprice_please_fill_in_the_date_of_quotation'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>$_POST["qp_cid"],'cc_isdel'=>0,'cc_insea'=>0))->find();
			if(empty($customer_info)){
				showDialog(Language::get('bp_quotedprice_member_information_does_not_exist_or_has_entered'),'','error');
			}
			//构造报价单商品数组
			$insert_product_array = array();
			$p_num = intval($_POST['total_product_num']);
			$total_price = 0;
			for($i=1;$i<=$p_num;$i++){
				if(intval($_POST['cp_id_'.$i]) > 0){
					$insert_product_array[] = array(
						'qpp_productid'=>intval($_POST['cp_id_'.$i]),
						'qpp_productname'=>trim($_POST['cp_pname_'.$i]),
						'qpp_unitprice'=>floatval($_POST['p_unitprice_'.$i]),
						'qpp_pnum'=>intval($_POST['p_num_'.$i]),
						'qpp_note'=>trim($_POST['p_note_'.$i])
					);
					$total_price += (intval($_POST['p_num_'.$i])*floatval($_POST['p_unitprice_'.$i]));
				}
			}
			$insert_array = array();
			$insert_array['qp_customerid'] = $customer_info['cc_id'];
			$insert_array['qp_customername'] = $customer_info['cc_name'];
			if(intval($_POST['qp_chance']) > 0){
				$insert_array['qp_chanceid'] = intval($_POST['qp_chance']);
				$insert_array['qp_chancetitle'] = $_POST['qp_chancetitle'];
			}
			$insert_array['qp_title'] = trim($_POST['qp_title']);
			$insert_array['qp_quotationdate'] = ($t = strtotime($_POST['qp_qdate']))>0?$t:0;
			$insert_array['qp_amount'] = $total_price;
			//查询联系人信息
			if(!empty($_POST['qp_contacts']) && $customer_info['cc_type'] == 1){
				$contacts_info = $model->table('company_contact')->where(array('ccc_id'=>$_POST['qp_contacts'],'ccc_isdel'=>'0','cc_id'=>$customer_info['cc_id']))->find();
				$insert_array['qp_contactid'] = $contacts_info['ccc_id'];
				$insert_array['qp_contactname'] = $contacts_info['ccc_name'];
			}
			$insert_array['qp_adduserid'] = $_SESSION['member_id'];
			$insert_array['qp_addusername'] = $_SESSION['truename'];
			$insert_array['qp_adddepartmentid'] = $_SESSION['dp_id'];
			$insert_array['qp_userid'] = $_SESSION['member_id'];
			$insert_array['qp_username'] = $_SESSION['truename'];
			$insert_array['qp_departmentid'] = $_SESSION['dp_id'];
			$insert_array['qp_deliverexplain'] = trim($_POST['qp_dexplain']);
			$insert_array['qp_payexplain'] = trim($_POST['qp_pexplain']);
			$insert_array['qp_transportexplain'] = trim($_POST['qp_texplain']);
			$insert_array['qp_remark'] = trim($_POST['qp_remark']);
			$insert_array['qp_addtime'] = time();
			$rs = $model->table('quotedprice')->insert($insert_array);
			$url = 'index.php?act=quotedprice&op=quotedpricelist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$insert_array['qp_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_array['qp_customerid'];
			}
			if($rs){
				if (!empty($insert_product_array)){
					//添加报价单商品信息
					foreach ((array)$insert_product_array as $k=>$v){
						$insert_product_array[$k]['qpp_qpid'] = $rs;
					}
					$model->table('quotedprice_product')->insertAll($insert_product_array);
				}
				showDialog(Language::get('bp_quotedprice_quotation_added_successfully'),$url,'succ');
			}else{
				showDialog(Language::get('bp_quotedprice_the_quotation_add_failure'),'','error');
			}
		}else{
			//如果来自会员详情页面则调取该会员信息
			if(intval($_GET['cc_id']) > 0){
				$cc_id = intval($_GET['cc_id']);
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$cc_id,'cc_isdel'=>0))->find();
				if(empty($cc_info)){
					showMessage(Language::get('bp_quotedprice_member_information_does_not_exist_or_has_entered'));
				}else{
					//如果是企业会员调取联系人名单
					if($cc_info['cc_type'] == 1){
						$ccc_info = $model->table('company_contact')->where(array('cc_id'=>$cc_id,'ccc_isdel'=>0))->select();
						Tpl::output('ccc_info',$ccc_info);
					}
					//查询销售机会信息
					$chancelist = $model->table('chance')->where(array('cha_customerid'=>$cc_info['cc_id'],'cha_istrash'=>0))->select();
					Tpl::output('cc_info',$cc_info);
					Tpl::output('chancelist',$chancelist);
				}
			}elseif (intval($_GET['chance_id']) > 0){
				$chance_id = intval($_GET['chance_id']);
				//查询销售机会详细
				$chance_info = $model->table('chance')->where(array('cha_id'=>$chance_id,'cha_istrash'=>0))->find();
				if(empty($chance_info)){
					showMessage(Language::get('bp_quotedprice_sales_lead_information_does_not_exist_or_has'));
				}else{
					//查询会员
					$cc_info  = $model->table('customer')->where(array('cc_id'=>$chance_info['cha_customerid'],'cc_isdel'=>0))->find();
					if(empty($cc_info)){
						showMessage(Language::get('bp_quotedprice_sales_lead_information_errors').Language::get('bp_comma').Language::get('bp_quotedprice_unable_to_add_the_quotation_for_it'));
					}
					$ccc_info = $model->table('company_contact')->where(array('cc_id'=>$chance_info['cha_customerid'],'ccc_isdel'=>0))->select();
					Tpl::output('ccc_info',$ccc_info);
					Tpl::output('chance_info',$chance_info);
					Tpl::output('cc_info',$cc_info);
				}
			}
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('quotedpricelist');
			//模板输出
			Tpl::showpage('quotedpriceadd');
		}
	}
	/*
	 * 报价单编辑
	 */
	public function quotedpriceeditOp(){
		$qpid = intval($_GET['qpid']);
		if ($qpid<=0){
			$qpid = intval($_POST['qpid']);
		}
		if ($qpid<=0){
			showDialog(Language::get('bp_quotedprice_parameter_error'),'','error');
		}
		//实例化模型
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		$where['qp_id'] = $qpid;
		//查询报价单详细
		$qp_info = $model->table('quotedprice')->where($where)->find();
		if(empty($qp_info)){
			showDialog(Language::get('bp_quotedprice_wrong_information'),'','error');
		}
		//编辑报价单
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["qp_title"],"require"=>"true","message"=>Language::get('bp_quotedprice_please_fill_in_the_title'));
			$validate_arr[] = array("input"=>$_POST["qp_qdate"],"require"=>"true","message"=>Language::get('bp_quotedprice_please_fill_in_the_date_of_quotation'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//构造报价单商品数组
			$insert_product_array = array();
			$p_num = intval($_POST['total_product_num']);
			$total_price = 0;
			for($i=1;$i<=$p_num;$i++){
				if(intval($_POST['cp_id_'.$i]) > 0){
					$insert_product_array[] = array(
						'qpp_productid'=>intval($_POST['cp_id_'.$i]),
						'qpp_productname'=>trim($_POST['cp_pname_'.$i]),
						'qpp_unitprice'=>floatval($_POST['p_unitprice_'.$i]),
						'qpp_pnum'=>intval($_POST['p_num_'.$i]),
						'qpp_note'=>trim($_POST['p_note_'.$i])
					);
					$total_price += (intval($_POST['p_num_'.$i])*floatval($_POST['p_unitprice_'.$i]));
				}
			}

			$update_arr = array();
			$update_arr['qp_title'] = trim($_POST['qp_title']);
			$update_arr['qp_quotationdate'] = ($t = strtotime($_POST['qp_qdate']))>0?$t:0;
			$update_arr['qp_amount'] = $total_price;
			$update_arr['qp_deliverexplain'] = trim($_POST['qp_dexplain']);
			$update_arr['qp_payexplain'] = trim($_POST['qp_pexplain']);
			$update_arr['qp_transportexplain'] = trim($_POST['qp_texplain']);
			$update_arr['qp_remark'] = trim($_POST['qp_remark']);
			$rs = $model->table('quotedprice')->where(array('qp_id'=>$qp_info['qp_id']))->update($update_arr);
			$url = 'index.php?act=quotedprice&op=quotedpricelist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$qp_info['qp_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$qp_info['qp_customerid'];
			}
			if($rs){
				//删除原有报价单商品
				$model->table('quotedprice_product')->where(array('qpp_qpid'=>$qp_info['qp_id']))->delete();
				if (!empty($insert_product_array)){
					//添加报价单商品信息
					foreach ((array)$insert_product_array as $k=>$v){
						$insert_product_array[$k]['qpp_qpid'] = $qp_info['qp_id'];
					}
					$model->table('quotedprice_product')->insertAll($insert_product_array);
				}
				showDialog(Language::get('bp_quotedprice_quotation_sheet_edit_successfully'),$url,'succ');
			}else{
				showDialog(Language::get('bp_quotedprice_quotation_sheet_editing_failed'),'','error');
			}
		}else{
			//查询报价单商品详细
			$where = array();
			$field = 'quotedprice_product.*,product.cp_id,product.cp_name,product.cp_mallurl';
			$on = 'quotedprice_product.qpp_productid=product.cp_id';
			$where['qpp_qpid'] = $qp_info['qp_id'];
			$qpproducts_list = $model->table('quotedprice_product,product')->field($field)->join('left')->on($on)->where('quotedprice_product.qpp_qpid='.$qp_info['qp_id'])->select();
			Tpl::output('qpproducts_list',$qpproducts_list);
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			Tpl::output('qp_info',$qp_info);
			Tpl::output('qpproducts_list',$qpproducts_list);
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('quotedpricelist');
			//模板输出
			Tpl::showpage('quotedpriceadd');
		}
	}
	/**
	 * 删除报价单
	 */
	public function quotedpricedelOp(){
		$qpid = $_GET['qpid'];
		if (empty($qpid)){
			$qpid = $_POST['qpid'];
		}
		if (empty($qpid)){
			showDialog(Language::get('bp_quotedprice_parameter_error'),'','error');
		}
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		if (is_array($qpid)){
			$where['qp_id'] = array('in',$qpid);
		}else {
			$where['qp_id'] = $qpid;
		}
		$rs = $model->table('quotedprice')->where($where)->delete();
		$url = 'index.php?act=quotedprice&op=quotedpricelist';
		if(intval($_GET['cc_id']) > 0){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}elseif (intval($_GET['chance_id']) > 0){
			$url = 'index.php?act=chance&op=chanceview&cid='.intval($_GET['chance_id']);
		}
		if ($rs){
			showDialog(Language::get('bp_quotedprice_delete_the_success'),$url,'succ');
		} else {
			showDialog(Language::get('bp_quotedprice_delete_failed'),'','error');
		}
	}
	/*
	 * 报价单查看
	 */
	public function quotedpriceviewOp(){
		$qpid = intval($_GET['qpid']);
		if ($qpid<=0){
			showDialog(Language::get('bp_quotedprice_parameter_error'),'','error');
		}
		//实例化模型
		$model = Model('department');
		//查询报价单详细
		$qp_info = $model->table('quotedprice')->where(array('qp_id'=>$qpid))->find();
		if(empty($qp_info)){
			showDialog(Language::get('bp_quotedprice_wrong_information'),'','error');
		}
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		$url = 'index.php?act=quotedprice&op=quotedpricelist';
		if ($source == 'chance'){
			$url = 'index.php?act=chance&op=chanceview&cid='.$qp_info['qp_chanceid'];
		}elseif ($source == 'customer'){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.$qp_info['qp_customerid'];
		}
		Tpl::output('backurl',$url);
		Tpl::output('source',$source);
		Tpl::output('qp_info',$qp_info);
		//查询报价单商品详细
		$where = array();
		$field = 'quotedprice_product.*,product.cp_id,product.cp_name,product.cp_mallurl';
		$on = 'quotedprice_product.qpp_productid=product.cp_id';
		$where['qpp_qpid'] = $qp_info['qp_id'];
		$qpproducts_list = $model->table('quotedprice_product,product')->field($field)->join('left')->on($on)->where('quotedprice_product.qpp_qpid='.$qp_info['qp_id'])->select();
		Tpl::output('qpproducts_list',$qpproducts_list);
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		Tpl::output('dic_array',$dic_array);
		//模板输出
		Tpl::showpage('quotedpriceview','windowopen_layout');
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_quotedprice_sales_opportunities'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'chancelist','menu_name'=>Language::get('bp_quotedprice_opportunity_management'),'menu_act'=>'chance','menu_op'=>'chancelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'chancetransfer','menu_name'=>Language::get('bp_quotedprice_opportunity_to_transfer'),'menu_act'=>'chance','menu_op'=>'chancetransfer','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'chancetransferlog','menu_name'=>Language::get('bp_quotedprice_transfer_the_log'),'menu_act'=>'chance','menu_op'=>'chancetransfer','menu_url'=>'index.php?act=chance&op=chancetransfer&type=log','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'chancefiller','menu_name'=>Language::get('bp_quotedprice_the_sales_funnel'),'menu_act'=>'chance','menu_op'=>'chancefiller','linktype'=>'0');

		$arr[1] = array('menu_name'=>Language::get('bp_quotedprice_sales_tracking'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'requirementlist','menu_name'=>Language::get('bp_quotedprice_membership_requirements'),'menu_act'=>'requirement','menu_op'=>'requirementlist','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'solutionlist','menu_name'=>Language::get('bp_quotedprice_the_solution'),'menu_act'=>'solution','menu_op'=>'solutionlist','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'quotedpricelist','menu_name'=>Language::get('bp_quotedprice_bid_management'),'menu_act'=>'quotedprice','menu_op'=>'quotedpricelist','linktype'=>'0');
		$arr[1]['submenu'][3] = array('menu_key'=>'competitorlist','menu_name'=>Language::get('bp_quotedprice_competitors'),'menu_act'=>'competitor','menu_op'=>'competitorlist','linktype'=>'0');

		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}