<?php
/**
 * 用户资料管理页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class profilesControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('profiles');
    }

	/**
	 * 编辑用户资料
	 */
	public function profileseditOp(){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["u_truename"],"require"=>"true","message"=>Language::get('bp_profiles_please_add_the_real_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//上传头像
			if (!empty($_FILES['u_avatar']['name'])){
				$upload = new UploadFile();
				$upload->set('default_dir',	ATTACH_AVATAR);
				$upload->set('thumb_ext',	'');
				$upload->set('file_name','');
				$upload->set('ifremove',false);
				$result = $upload->upfile('u_avatar');
				if ($result){
					$_POST['u_avatar'] = $upload->file_name;
				}else {
					showDialog($upload->error);
				}
			}
			//删除旧头像
			if (!empty($_POST['u_avatar']) && !empty($_POST['old_u_avatar'])){
				@unlink(BasePath.DS.ATTACH_AVATAR.DS.$_POST['old_u_avatar']);
			}
			$update_arr = array();
			$update_arr['user_truename'] = $_POST['u_truename'];
			$update_arr['user_avatar'] = empty($_POST['u_avatar'])?$_POST['old_u_avatar']:$_POST['u_avatar'];
			$rs = $model->table('user')->where(array('user_id'=>$_SESSION['member_id']))->update($update_arr);
			if ($rs){
				//新增扩展信息
				$exupdate_arr = array();
				$exupdate_arr['uex_sex'] = $_POST['uex_sex'];
				$exupdate_arr['uex_birthday'] =  ($t = strtotime($_POST['uex_birthday']))>0?$t:0;
				$exupdate_arr['uex_education'] = $_POST['uex_education'];
				$exupdate_arr['uex_mobile'] = $_POST['uex_mobile'];
				$exupdate_arr['uex_telephone'] = $_POST['uex_telephone'];
				$exupdate_arr['uex_email'] = $_POST['uex_email'];
				$exupdate_arr['uex_qq'] = $_POST['uex_qq'];
				$exupdate_arr['uex_msn'] = $_POST['uex_msn'];
				$exupdate_arr['uex_skype'] = $_POST['uex_skype'];
				if(intval($_POST['p_select']) > 0){
					$exupdate_arr['uex_province'] = $_POST['p_text'];
				}
				if(intval($_POST['c_select']) > 0){
					$exupdate_arr['uex_city'] = $_POST['c_text'];
				}
				if(intval($_POST['d_select']) > 0){
					$exupdate_arr['uex_county'] = $_POST['d_text'];
				}
				if(empty($exupdate_arr['uex_province']) || empty($exupdate_arr['uex_city']) || empty($exupdate_arr['uex_county'])){
					unset($exupdate_arr['uex_province'],$exupdate_arr['uex_city'] ,$exupdate_arr['uex_county']);
				}
				$exupdate_arr['uex_address'] = $_POST['addressinfo'];
				$model->table('userextend')->where(array('uex_userid'=>$_SESSION['member_id']))->update($exupdate_arr);
				showDialog(Language::get('bp_profiles_edit_the_success'),'index.php?act=profiles&op=profilesedit','succ');
			}else {
				showDialog(Language::get('bp_profiles_edit_failed'),'','error');
			}
		}else {
			//查询用户信息
			$u_info = $model->table('user')->where(array('user_id'=>$_SESSION['member_id'],'user_state'=>0))->find();
			if (empty($u_info)){
				showDialog(Language::get('bp_profiles_wrong_information'),'','error');
			}
			//查询用户扩展信息
			$uex_info = $model->table('userextend')->where(array('uex_userid'=>$u_info['user_id']))->find();
			$uex_info['uex_birthday'] = empty($uex_info['uex_birthday'])?'':@date('Y-m-d',$uex_info['uex_birthday']);
			$uex_info['uex_entrytime'] = empty($uex_info['uex_entrytime'])?'':@date('Y-m-d',$uex_info['uex_entrytime']);
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			$u_info['shop_name'] = $shop_list[$u_info['user_shopid']]['shop_name'];
			Tpl::output('u_info',$u_info);
			Tpl::output('uex_info',$uex_info);
			//左侧菜单
			$this->setleftmenu('profilesedit');
			Tpl::showpage('profilesedit');
		}
	}
	/**
	 * 编辑密码
	 */
	public function profilespwOp(){
		if (chksubmit()){
			$model = Model();
			$obj_validate = new Validate();
			$obj_validate->validateparam = array(
			array("input"=>$_POST["oldpw"],		"require"=>"true",		"message"=>Language::get('bp_profiles_please_fill_in_the_old_password')),
			array("input"=>$_POST["newpw"],		"require"=>"true",		"message"=>Language::get('bp_profiles_please_fill_in_new_password')),
			array("input"=>$_POST["newpwrepeat"],	"require"=>"true",	"message"=>Language::get('bp_profiles_please_fill_in_the_confirm_password')),
			);
			$error = $obj_validate->validate();
			if ($error != ''){
				showValidateError($error);
			}
			$u_info	= $model->table('user')->where(array('user_name'=>trim($_SESSION['member_name']),'user_password'=>md5(trim($_POST['oldpw'])),'user_state'=>'0'))->find();
			if(empty($u_info)) {
				showDialog(Language::get('bp_profiles_the_old_password_mistake'));
			}
			$rs	= $model->table('user')->where(array('user_id'=>$_SESSION['member_id']))->update(array('user_password'=>md5(trim($_POST['newpw']))));
			if($rs) {
				showDialog(Language::get('bp_profiles_edit_the_success'),'index.php?act=login&op=logout','succ');
			} else {
				showDialog(Language::get('bp_profiles_edit_failed'),'','error');
			}
		}else{
			//左侧菜单
			$this->setleftmenu('profilespw');
			Tpl::showpage('profilespw');
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//一级菜单
		$arr[0] = array('menu_key'=>'profilesedit','menu_name'=>Language::get('bp_profiles_personal_settings'),	'menu_act'=>'profiles','menu_op'=>'profilesedit','linktype'=>'0');
		$arr[1] = array('menu_key'=>'profilespw','menu_name'=>Language::get('bp_profiles_change_the_password'),	'menu_act'=>'profiles','menu_op'=>'profilespw','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}