<?php
/**
 * 商品管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class productControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('product');
    }

	/**
	 * 商品管理
	 */
	public function product_listOp(){
		set_time_limit(0);
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_product_you_have_no_permission_to_view_the_store'));
			}
			if(intval($_GET['shop_id']) == 0){
				redirect('index.php?act=product&op=product_list&shop_id='.$_SESSION['shop_id']);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					redirect('index.php?act=product&op=product_list&shop_id='.$default_shop);die;
				}
			}
		}
		/**
		 * 实例化模型
		 */
		$model = Model('product_class');
		/**
		 * 调取商品列表
		 */
		$filter = trim($_GET['filter']);
		$where_condition = array();
		switch ($filter){
			case 'onsale':
				$where_condition['product.cp_status'] = 1;
				break;
			case 'instock':
				$where_condition['product.cp_status'] = 2;
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'product_name':
					$where_condition['product.cp_name'] = array('like','%'.trim($_GET['search_content'].'%'));
					break;
				case 'product_code':
					$where_condition['product.cp_code'] = array('like','%'.trim($_GET['search_content'].'%'));
					break;
				case 'product_barcode':
					$where_condition['product.cp_barcode'] = array('like','%'.trim($_GET['search_content'].'%'));
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition['product.shop_id'] = intval($_GET['shop_id']);
		}
		//自定义字段的搜索处理
		if(!empty($_GET['selfdic_search'])){
			$sd_choose = array();
			foreach ((array)$_GET['selfdic_search'] as $sk=>$sv){
				if($sv != 0){
					$where_condition['product.cp_self_field'] = array('like','%'.$sv.'%');
					$sd_choose[] = $sv;
				}
			}
			Tpl::output('sd_choose',$sd_choose);
		}
		if ($_GET['exporttype'] == 'excel'){
			$product_list = $model->field('product.*,shop.shop_name')->table('product,shop')->join('left')->on('product.shop_id=shop.shop_id')->where($where_condition)->order('product.cp_updatetime desc')->select();
		}else {
			//每页显示条数
			$pagesize = intval($_GET['pagesize']) > 0 ? intval($_GET['pagesize']) : 10;
			$product_list = $model->field('product.*,shop.shop_name')->table('product,shop')->join('left')->on('product.shop_id=shop.shop_id')->where($where_condition)->page($pagesize)->order('product.cp_updatetime desc')->select();
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 自定义字段的处理
		 */
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>3))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		//导出Excel
		if ($_GET['exporttype'] == 'excel'){
			//导出Excel
			import('excel#class');
			$excel_class = new ExcelXML(C('exportfilefont'));
			$excel_data = array();
			//设置样式
			$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_name_of_commodity'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_commodity_code'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_the_name_of_the_shop'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_inventory_quantity'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_the_sales_price'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_state'));
			if(!empty($selfdic_show) && is_array($selfdic_show)){
				foreach ((array)$selfdic_show as $sk=>$sv){
					$excel_data[0][] = array('styleid'=>'s_title','data'=>$sv['field_name']);
				}
			}
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_product_product_pictures'));
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			//data
			foreach ((array)$product_list as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['cp_name']);
				$tmp[] = array('data'=>$v['cp_code']);
				$tmp[] = array('data'=>$shop_list[$v['shop_id']]['shop_name']);
				$tmp[] = array('data'=>$v['cp_num']);
				$tmp[] = array('data'=>ncPriceFormat($v['cp_ori_price']));
				switch ($v['cp_status']){
				 	case '1':
				 		$tmp[] = array('data'=>Language::get('bp_product_shelves'));
				 		break;
				 	case '2':
				 		$tmp[] = array('data'=>Language::get('bp_product_the_shelves'));
				 		break;
				}
				if(!empty($selfdic_show) && is_array($selfdic_show)){
					$selfdic_choose = unserialize($v['cc_self_field']);
					foreach ((array)$output['selfdic_show'] as $sk=>$sv){
						$tmp[] = array('data'=>(intval($selfdic_choose[$sv['p_id']])==0?Language::get('bp_product_no'):$sv['child_option'][$selfdic_choose[$sv['p_id']]]['cd_name']));
					}
				}
				$img = $v['cp_pic']!=''?$v['cp_pic']:SiteUrl.'/templates/default/images/default_goods_image.gif';
				$tmp[] = array('data'=>$img);
				$excel_data[] = $tmp;
			}
			$excel_class->addArray($excel_data);
			$excel_class->addWorksheet(Language::get('bp_product_commodity_information'));
			$excel_class->generateXML(Language::get('bp_product_commodity_information').date('Y-m-d H-i-s',time()));
			exit();
		}
		Tpl::output('selfdic_show',$selfdic_show);
		Tpl::output('selfdic_search',$selfdic_search);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('product_list');
		/**
		 * 模板输出
		 */
		Tpl::output('currenturl',request_uri());
		Tpl::output('product_list',$product_list);
		Tpl::output('dic_array',$dic_array);
		Tpl::output('shop_name',$shop_list[intval($_GET['shop_id'])]['shop_name']);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('product_list');
	}
	/**
	 * 新增商品
	 */
	public function product_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model('product_class');
		/**
		 * 添加新商品
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["product_name"],"require"=>"true","message"=>Language::get('bp_product_name_of_commodity_must_fill_in'));
			$validate_arr[] = array("input"=>$_POST["product_class"], "require"=>'true',"message"=>Language::get('bp_product_commodity_classification_must_be_chosen'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if(trim($_POST['product_cost'])=='' || trim($_POST['cp_ori_price'])=='' || trim($_POST['cp_lowest_price'])==''){
				showDialog(Language::get('bp_product_commodity_price').Language::get('bp_comma').Language::get('bp_product_the_lowest_price').Language::get('bp_comma').Language::get('bp_product_must_fill_in_the_cost_price'));
			}
			//自定义字段的处理
			$cp_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$cp_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			//价格策略数据的处理
			$cp_saleprice = array();
			if(is_array($_POST['saleprice_id']) && !empty($_POST['saleprice_id'])){
				foreach ((array)$_POST['saleprice_id'] as $k=>$v){
					$cp_saleprice[$v] = array('price'=>$_POST['saleprice'][$k],'currency_unit'=>$_POST['currency_unit'][$k]);
				}
			}
			$insert_array = array(
				'cp_name'=>trim($_POST['product_name']),
				'cp_ptime'=>($t = strtotime(trim($_POST['product_ptime'])))>0?$t:0,
				'cp_otime'=>($t = strtotime(trim($_POST['product_otime'])))>0?$t:0,
				'cp_barcode'=>trim($_POST['product_barcode']),
				'cp_code'=>trim($_POST['product_code']),
				'cp_unit'=>intval($_POST['product_unit']),
				'cp_intro'=>trim($_POST['cp_intro']),
				'cp_spec'=>trim($_POST['cp_spec']),
				'cp_updatetime'=>time(),
				'cp_updatestaff'=>$_SESSION['member_id'],
				'cp_status'=>intval($_POST['cp_status']),
				'cp_self_field'=>serialize($cp_self_field),
				'cp_saleprice'=>serialize($cp_saleprice),
				'cp_cost'=>trim($_POST['product_cost']),
				'cp_pic'=>trim($_POST['product_image']),
				'cp_note'=>trim($_POST['cp_note']),
				'cp_ori_price'=>trim($_POST['cp_ori_price']),
				'cp_lowest_price'=>trim($_POST['cp_lowest_price'])
			);
			$result = $model->table('product')->insert($insert_array);
			if($result != false){
				//添加商品库存信息表
				if(!empty($_POST['wh_id'])){
					$insert_cpw = array();
					foreach ($_POST['wh_id'] as $k=>$v){
						$insert_cpw[] = array(
							'cp_id'=>$result,
							'wh_id'=>$v,
							'alert_num'=>$_POST['alert_num'][$k]
						);
					}
					$model->table('product_whinfo')->insertAll($insert_cpw);
				}
				showDialog(Language::get('bp_product_commodity_information_into_success'),'index.php?act=product&op=product_list','succ');
			}else{
				showDialog(Language::get('bp_product_commodity_information_input_failed').Language::get('bp_comma').Language::get('bp_product_please_try_again'),'','error');
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('product_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>3))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 调取仓库信息
		 */
		$wh_list = $model->field('wh_id,wh_name')->table('warehouse')->where(true)->select();
		Tpl::output('wh_list',$wh_list);
		/**
		 * 调取商品分类信息
		 */
		$selecthtml = $model->getProductClassCacheSelect();
		Tpl::output('selecthtml',$selecthtml);
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::showpage('product_add');
	}
	/**
	 * 编辑商品
	 */
	public function product_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model('product_class');

		/**
		 * 编辑商品
		 */
		if (chksubmit()){
			$cp_id = intval($_POST['cp_id']);

			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["product_name"],"require"=>"true","message"=>Language::get('bp_product_name_of_commodity_must_fill_in'));
			$validate_arr[] = array("input"=>$_POST["product_class"], "require"=>'true',"message"=>Language::get('bp_product_commodity_classification_must_be_chosen'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if(trim($_POST['product_cost'])=='' || trim($_POST['cp_ori_price'])=='' || trim($_POST['cp_lowest_price'])==''){
				showDialog(Language::get('bp_product_commodity_price').Language::get('bp_comma').Language::get('bp_product_the_lowest_price').Language::get('bp_comma').Language::get('bp_product_must_fill_in_the_cost_price'));
			}
			//自定义字段的处理
			$cp_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$cp_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			//价格策略数据的处理
			$cp_saleprice = array();
			if(is_array($_POST['saleprice_id']) && !empty($_POST['saleprice_id'])){
				foreach ((array)$_POST['saleprice_id'] as $k=>$v){
					$cp_saleprice[$v] = array('price'=>$_POST['saleprice'][$k],'currency_unit'=>$_POST['currency_unit'][$k]);
				}
			}
			$update_array = array(
				'cp_name'=>trim($_POST['product_name']),
				'cp_ptime'=>($t = strtotime(trim($_POST['product_ptime'])))>0?$t:0,
				'cp_otime'=>($t = strtotime(trim($_POST['product_otime'])))>0?$t:0,
				'cp_barcode'=>trim($_POST['product_barcode']),
				'cp_code'=>trim($_POST['product_code']),
				'cp_intro'=>trim($_POST['cp_intro']),
				'cp_spec'=>trim($_POST['cp_spec']),
				'cp_status'=>intval($_POST['cp_status']),
				'cp_self_field'=>serialize($cp_self_field),
				'cp_saleprice'=>serialize($cp_saleprice),
				'cp_cost'=>trim($_POST['product_cost']),
				'cp_note'=>trim($_POST['cp_note']),
				'cp_ori_price'=>trim($_POST['cp_ori_price']),
				'cp_lowest_price'=>trim($_POST['cp_lowest_price'])
			);
			if(trim($_POST['product_image']) != ''){
				$update_array['cp_pic'] = trim($_POST['product_image']);
			}
			$result = $model->table('product')->where(array('cp_id'=>$cp_id))->update($update_array);
			if($result != false){
				//同步ShopNC商城商品状态
				$cp_info = $model->field('cp_id,cp_mall,cp_mallpid')->table('product')->where(array('cp_id'=>$cp_id))->find();
				if(C('shopnc_syncopen') == 1 && intval($_POST['cp_status']) != intval($_POST['old_cp_status']) && $cp_info['cp_mall'] == 1 && $cp_info['cp_mallpid'] != 0){
					$sid     = C('shopnc_storeid');
					$api_url = C('shopnc_apiurl');
					$auth_string = 'commend=state&type=product&sp='.$cp_info['cp_mallpid'].'&value='.(intval($_POST['cp_status'])==1?1:0).'&sid='.$sid;
					$key = rawurlencode(authcode($auth_string,''));
					$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
					$opts = array(
					  'http'=>array(
					    'method'=>"POST",
					    'timeout'=>60,
					   )
					);
					$context   = stream_context_create($opts);
					$json_data = file_get_contents($final_url,false,$context);
				}
				//更新商品库存表信息
				if(!empty($_POST['cpw_id'])){
					foreach ($_POST['cpw_id'] as $k=>$v){
						$model->table('product_whinfo')->where(array('cpw_id'=>$v))->update(array('alert_num'=>$_POST['alert_num'][$k]));
					}
				}
				//新增商品库存表信息
				if(!empty($_POST['add_wh_id'])){
					$insert_cpw = array();
					foreach ($_POST['add_wh_id'] as $k=>$v){
						$insert_cpw[] = array(
							'cp_id'=>$cp_id,
							'wh_id'=>$v,
							'alert_num'=>$_POST['add_alert_num'][$k]
						);
					}
					$model->table('product_whinfo')->insertAll($insert_cpw);
				}
				showDialog(Language::get('bp_product_commodity_information_updated'),'index.php?act=product&op=product_list','succ');
			}else{
				showDialog(Language::get('bp_product_commodity_information_update_failure').Language::get('bp_comma').Language::get('bp_product_please_try_again'),'','error');
			}
		}
		/**
		 * 调取商品信息
		 */
		$cp_id = intval($_GET['cp_id']);
		$product_info = $model->table('product')->where(array('cp_id'=>$cp_id))->find();
		if(empty($product_info) || !is_array($product_info)){
			showMessage(Language::get('bp_product_didnt_find_the_commodity_information'));
		}
		Tpl::output('product_info',$product_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('product_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>3))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 调取商品库存信息
		 */
		$cpw_list = $model->field('product_whinfo.*,warehouse.wh_name')->table('product_whinfo,warehouse')->join('left')->on('product_whinfo.wh_id=warehouse.wh_id')->where(array('product_whinfo.cp_id'=>$cp_id))->select();
		$cpw_wh_arr = array();
		if(!empty($cpw_list)){
			foreach ($cpw_list as $k=>$v){
				$cpw_wh_arr[] = $v['wh_id'];
			}
		}
		Tpl::output('cpw_list',$cpw_list);
		$wh_list = $model->field('wh_id,wh_name')->table('warehouse')->where(true)->select();
		$add_wh = array();
		if(!empty($wh_list)){
			foreach ($wh_list as $k=>$v){
				if(!in_array($v['wh_id'], $cpw_wh_arr)){
					$add_wh[] = $v;
				}
			}
		}
		Tpl::output('add_wh',$add_wh);
		/**
		 * 模板输出
		 */
		Tpl::output('cp_saleprice',unserialize($product_info['cp_saleprice']));
		Tpl::output('cp_self_field',unserialize($product_info['cp_self_field']));
		Tpl::output('dic_array',$dic_array);
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::showpage('product_edit');
	}
	/**
	 * 删除商品
	 */
	public function product_delOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		$cp_id = intval($_GET['cp_id']);
		if($cp_id == 0){
			showMessage(Language::get('bp_product_parameter_error').Language::get('bp_comma').Language::get('bp_product_unable_to_delete_the_commodity_information'));
		}else{
			$result = $model->table('product')->where(array('cp_id'=>$cp_id))->update(array('cp_status'=>-1));
			if($result){
				showDialog(Language::get('bp_product_goods_to_delete_successful'),'index.php?act=product&op=product_list','succ');
			}else{
				showDialog(Language::get('bp_product_commodity_delete_failed'),'','error');
			}
		}
	}
	/**
	 * 恢复已删除的会员
	 *
	 */
	public function product_returnOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();

		$cp_id = intval($_GET['cp_id']);
		if($cp_id == 0){
			showMessage(Language::get('bp_product_parameter_error').Language::get('bp_comma').Language::get('bp_product_unable_to_restore_the_commodity_information'));
		}else{
			$result = $model->table('product')->where(array('cp_id'=>$cp_id))->update(array('cp_status'=>0));
			if($result){
				showDialog(Language::get('bp_product_commodity_information_recovery_success'),'index.php?act=product&op=product_list','succ');
			}else{
				showDialog(Language::get('bp_product_commodity_information_failure_recovery'),'','error');
			}
		}
	}
	/**
	 * 查看商品
	 */
	/*public function product_viewOp(){
		if(intval($_GET['shop_id']) <= 0 || trim($_GET['mallpid'])==''){
			showDialog("参数错误！");
		}
		$product_list = ($t = F('product')) ? $t : H('product',true,'file');
		redirect($product_list[intval($_GET['shop_id']).'|'.trim($_GET['mallpid'])]['cp_mallurl']);
	}*/
	/**
	 * 商品状态批量转换
	 */
	public function status_batch_switchOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		$shop_id = intval($_GET['shop_id']);
		if($shop_id <= 0){
			showDialog(Language::get('bp_product_parameter_error'));
		}
		$product_id = trim($_GET['product_id'],',');
		if($product_id == ''){
			showDialog(Language::get('bp_product_please_select_a_product'),'','error');
		}
		//同步线上商城数据
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		$shop_info = $shop_list[intval($_GET['shop_id'])];
		$platinfo  = unserialize($shop_info['shop_platinfo']);
		$cp_list = $model->field('cp_mallpid')->table('product')->where(array('cp_id'=>array('in',$product_id)))->select();
		switch ($shop_info['shop_platform']){
			case 1://ShopNC体系商城
					$sid = $platinfo['shopnc_sid'];
					$api_url = $platinfo['shopnc_apiurl'];
					$signkey = $platinfo['shopnc_sk'];
					$nc_cp_status = trim($_GET['type'])=='onsale'?1:0;
					foreach ((array)$cp_list as $k=>$v){
						$auth_string = 'commend=state&type=product&sp='.$v['cp_mallpid'].'&value='.$nc_cp_status.'&sid='.$sid;
						$key = rawurlencode(authcode($auth_string,$signkey,''));
						$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
						$opts = array(
						  'http'=>array(
						    'method'=>"GET",
						    'timeout'=>60,
						   )
						);
						$context   = stream_context_create($opts);
						$json_data = file_get_contents($final_url,false,$context);
					}
				break;
			case 2://淘宝
				require(BasePath.'/framework/function/top.php');
				$tc = new TopClient();
				$tc->appKey    = '21513519';
				$tc->appSecret = '2bfcbf47bed3fafd4ffbb51ca04af002';
				$param['method'] = 'taobao.item.update';
				$param['approve_status'] = trim($_GET['type'])=='onsale'?'onsale':'instock';
				$param['session'] = $platinfo['session'];
				foreach ((array)$cp_list as $k=>$v){
					$param['num_iid'] = $v['cp_mallpid'];
					$result_arr = $tc->reqdata($param);
				}
				break;
		}
		//更新本地数据
		switch (trim($_GET['type'])){
			case 'onsale':
				$change_status = 1;
				break;
			case 'instock':
				$change_status = 2;
				break;
		}
		$rs = $model->table('product')->where(array('cp_id'=>array('in',$product_id)))->update(array('cp_status'=>$change_status));
		showDialog(Language::get('bp_product_batch_conversion_completed_goods_status'),'index.php?act=product&op=product_list','succ');
	}
	/**
	 * ajax上传商品图片
	 */
	public function ajax_productpic_uploadOp(){
		$upload = new UploadFile();
		$upload->set('default_dir',ATTACH_PRODUCT);
		/**
		 * 系统图标上传
		 */
		if (!empty($_FILES['tmp_product_image']['name'])){
			$upload->set('file_name', '');
			$upload->set('thumb_width',	0);
			$upload->set('thumb_height',0);
			$upload->set('thumb_ext',	false);
			$result = $upload->upfile('tmp_product_image');
			if ($result){
				$product_image = $upload->file_name;
			}
		}
		/*
		 * 构造更新数据数组
		 */
		if ($product_image != ''){
			echo json_encode(array('done'=>true,'pic'=>$product_image));
		}else{
			echo json_encode(array('done'=>false,'pic'=>''));
		}
	}
	/**
	 * 信息数组空数据过滤处理（空字段显示“暂无”,适用于一元数组）
	 *
	 * @param $data_array 待处理的数组
	 * @return array 返回处理后的数组
	 */
	private function array_filter($data_array){
		if(is_array($data_array) && !empty($data_array)){
			foreach ((array)$data_array as $k=>$v){
				if($v == ''){
					$data_array[$k] = Language::get('bp_product_no');
				}
			}
			return $data_array;
		}else{
			return false;
		}
	}
	/**
	 * 商品快速编辑
	 */
	public function quick_editOp(){
		$model = Model();
		$cp_id = intval($_GET['cp_id']);
		if($cp_id <= 0){
			showDialog(Language::get('bp_product_parameter_error'));
		}
		/*保存并同步*/
		if(trim($_GET['exc']) == 'ok'){
			//验证
			if(intval($_GET['shop_platform'])==2 && ncPriceFormat($_GET['cp_ori_price']) == '0.00'){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_commodity_prices_cannot_be_zero')));die;
			}
			//同步线上商城数据
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			$shop_info = $shop_list[intval($_GET['shop_id'])];
			$platinfo  = unserialize($shop_info['shop_platinfo']);
			switch (intval($_GET['shop_platform'])){
				case 1://ShopNC体系
					$sid = $platinfo['shopnc_sid'];
					$api_url = $platinfo['shopnc_apiurl'];
					$signkey = $platinfo['shopnc_sk'];
					$cp_info = $model->field('cp_id,cp_mallpid')->table('product')->where(array('cp_id'=>$cp_id))->find();
					$cp_state = intval($_GET['cp_status'])==1?1:0;
					$auth_string = 'commend=state&type=product&sp='.$cp_info['cp_mallpid'].'&value='.$cp_state.'&sid='.$sid;
					$key = rawurlencode(authcode($auth_string,$signkey,''));
					$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
					$opts = array(
					  'http'=>array(
					    'method'=>"GET",
					    'timeout'=>60,
					   )
					);
					$context   = stream_context_create($opts);
					$json_data = file_get_contents($final_url,false,$context);
					if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_commodity_information_synchronization_failure')));die; }
					$data = json_decode($json_data,true);
					if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 0){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_commodity_information_synchronization_failure')));die; }
					break;
				case 2://淘宝
					require(BasePath.'/framework/function/top.php');
					$tc = new TopClient();
					$tc->appKey    = '21513519';
					$tc->appSecret = '2bfcbf47bed3fafd4ffbb51ca04af002';
					$param['method'] = 'taobao.item.update';
					$param['num_iid'] = trim($_GET['cp_mallpid']);
					$param['num'] = trim($_GET['cp_num']);
					$param['price'] = trim($_GET['cp_ori_price']);
					$param['post_fee'] = trim($_GET['cp_postfee']);
					$param['express_fee'] = trim($_GET['cp_expressfee']);
					$param['ems_fee'] = trim($_GET['cp_emsfee']);
					$param['approve_status'] = intval($_GET['cp_status'])==1?'onsale':'instock';
					$param['session'] = $platinfo['session'];
					$result_arr = $tc->reqdata($param);
					if(!is_array($result_arr) || !empty($result_arr['error_response'])){
						if($result_arr['error_response']['msg'] == 'Invalid session:session-expired'){
							//处理session过期
							$model->table('shop')->where(array('shop_id'=>intval($_GET['shop_id'])))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
							echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_taobao_the_session_expires').Language::get('bp_comma').Language::get('bp_product_please_bind_again')));die;
						}
						echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_commodity_information_synchronization_failure').Language::get('bp_openparen').'ERROR:'.$result_arr['error_response']['msg'].Language::get('bp_closeparen')));die;
					}
					break;
				case 3://ShopEx单店
					$api_url = $platinfo['shopex_apiurl'];
					$cp_info = $model->field('cp_id,cp_mallpid')->table('product')->where(array('cp_id'=>$cp_id))->find();
					$cp_state = intval($_GET['cp_status'])==1?'true':'false';
					$inquire_str = 'command=productedit&goods_id='.$cp_info['cp_mallpid'].'&status='.$cp_state;
					$final_url = $api_url.'/index.php?'.$inquire_str;
					$opts = array(
					  'http'=>array(
					    'method'=>"GET",
					    'timeout'=>60,
					   )
					);
					$context   = stream_context_create($opts);
					$json_data = file_get_contents($final_url,false,$context);
					if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_commodity_information_synchronization_failure')));die; }
					$data = json_decode($json_data,true);
					if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 'failed'){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_commodity_information_synchronization_failure')));die; }
					break;
			}
			//更新本地数据
			$update_array = array();
			$update_array['cp_status'] = intval($_GET['cp_status']);
			if(intval($_GET['shop_platform']) == 2){
				$update_array['cp_ori_price'] = floatval($_GET['cp_ori_price']);
				$update_array['cp_num'] = intval($_GET['cp_num']);
				$update_array['cp_postfee'] = floatval($_GET['cp_postfee']);
				$update_array['cp_expressfee'] = floatval($_GET['cp_expressfee']);
				$update_array['cp_emsfee'] = floatval($_GET['cp_emsfee']);
			}
			$update_rs = $model->table('product')->where(array('cp_id'=>$cp_id))->update($update_array);
			if($update_rs){
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_editors_save_failed')));die;
			}
		}
		//调取商品信息
		$cp_info = $model->field('product.*,shop.shop_platform')->table('product,shop')->join('left')->on('product.shop_id=shop.shop_id')->where(array('cp_id'=>$cp_id))->find();
		Tpl::output('cp_info',$cp_info);
		Tpl::showpage('cp_quickedit','null_layout');
	}
	/**
	 * 商品附加信息
	 */
	public function addon_infoOp(){
		$model = Model();
		$cp_id = intval($_GET['cp_id']);
		if($cp_id <= 0){
			showDialog(Language::get('bp_product_parameter_error'));
		}
		/*保存并同步*/
		if(trim($_GET['exc']) == 'ok'){
			//验证
			$cp_ptime = ($t = strtotime(trim($_GET['cp_ptime'])))>0?$t:0;
			$cp_otime = ($t = strtotime(trim($_GET['cp_otime'])))>0?$t:0;
			if(($cp_ptime!=0 || $cp_otime!=0) && $cp_ptime >= $cp_otime){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_production_date_must_be_less_than_the_expiry_date')));die;
			}
			//自定义字段的处理
			$cp_self_field = array();
			$self_field_pid = explode(',', trim($_GET['self_field_pid'],','));
			$self_field_option = explode(',', trim($_GET['self_field_option'],','));
			if(is_array($self_field_pid) && !empty($self_field_pid)){
				foreach ((array)$self_field_pid as $k=>$v){
					$cp_self_field[$v] = $self_field_option[$k];
				}
			}
			//价格策略数据的处理
			$cp_saleprice = array();
			$saleprice_id = explode(',', trim($_GET['saleprice_id'],','));
			$saleprice_val = explode(',', trim($_GET['saleprice_val'],','));
			if(is_array($saleprice_id) && !empty($saleprice_id)){
				foreach ((array)$saleprice_id as $k=>$v){
					$cp_saleprice[$v] = array('price'=>$saleprice_val[$k]);
				}
			}
			//更新商品数据
			$update_array = array();
			$update_array['cp_lowest_price'] = trim($_GET['cp_lowest_price']);
			$update_array['cp_cost'] = trim($_GET['cp_cost']);
			$update_array['cp_ptime'] = $cp_ptime;
			$update_array['cp_otime'] = $cp_otime;
			$update_array['cp_barcode'] = trim($_GET['cp_barcode']);
			$update_array['cp_note'] = trim($_GET['cp_note']);
			$update_array['cp_saleprice'] = serialize($cp_saleprice);
			$update_array['cp_self_field'] = serialize($cp_self_field);
			$rs = $model->table('product')->where(array('cp_id'=>$cp_id))->update($update_array);
			if($rs){
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_editors_save_failed_goods_additional_information')));die;
			}
		}
		//调取商品信息
		$cp_info = $model->table('product')->where(array('cp_id'=>$cp_id))->find();
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>3))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		Tpl::output('cp_saleprice',unserialize($cp_info['cp_saleprice']));
		Tpl::output('cp_self_field',unserialize($cp_info['cp_self_field']));
		Tpl::output('dic_array',$dic_array);
		Tpl::output('cp_info',$cp_info);
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('html_title',Language::get('bp_product_additional_information') .'['.$cp_info['cp_name'].']');
		Tpl::showpage('cp_addoninfo','windowopen_layout');
	}
	/**
	 * 商品规格信息
	 */
	public function sku_infoOp(){
		$model = Model();
		$cp_id = intval($_GET['cp_id']);
		if($cp_id <= 0){
			showDialog(Language::get('bp_product_parameter_error'));
		}
		/*保存并同步*/
		if(trim($_GET['exc']) == 'ok'){
			$sku_id = explode(',', trim($_GET['sku_id'],','));
			$sku_num = explode(',', trim($_GET['sku_num'],','));
			$sku_price = explode(',', trim($_GET['sku_price'],','));
			$sku_prop = explode(',', trim($_GET['sku_prop'],','));
			$sku_code = explode(',', trim($_GET['sku_code'],','));
			//同步线上数据
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			$shop_info = $shop_list[intval($_GET['shop_id'])];
			$platinfo  = unserialize($shop_info['shop_platinfo']);
			switch (intval($_GET['shop_platform'])){
				case 1://ShopNC体系商城
					$sid = $platinfo['shopnc_sid'];
					$api_url = $platinfo['shopnc_apiurl'];
					$signkey = $platinfo['shopnc_sk'];
					$sync_array = array();
					foreach ((array)$sku_id as $k=>$v){
						$sync_array[$v] = array(
							'price'=>$sku_price[$k],
							'storage'=>$sku_num[$k]
						);
					}
					$sync_string = trim(base64_encode(serialize($sync_array)),'=');
					$cp_info = $model->field('cp_id,cp_mallpid')->table('product')->where(array('cp_id'=>$cp_id))->find();
					$auth_string = 'commend=update_product&pid='.$cp_info['cp_mallpid'].'&content='.$sync_string;
					$key = rawurlencode(authcode($auth_string,$signkey,''));
					$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
					$opts = array(
					  'http'=>array(
					    'method'=>"GET",
					    'timeout'=>60,
					   )
					);
					$context   = stream_context_create($opts);
					$json_data = file_get_contents($final_url,false,$context);
					if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_product_specification_information_synchronization')));die; }
					$data = json_decode($json_data,true);
					if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 0){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_product_specification_information_synchronization')));die; }
					break;
				case 2://淘宝
					require(BasePath.'/framework/function/top.php');
					$tc = new TopClient();
					$tc->appKey    = '21513519';
					$tc->appSecret = '2bfcbf47bed3fafd4ffbb51ca04af002';
					$param['method'] = 'taobao.item.update';
					$param['num_iid'] = trim($_GET['cp_mallpid']);
					$param['sku_outer_ids'] = trim($_GET['sku_id'],',');
					$param['sku_quantities'] = trim($_GET['sku_num'],',');
					$param['sku_prices'] = trim($_GET['sku_price'],',');
					$result_arr = $tc->reqdata($param);
					if(!is_array($result_arr) || !empty($result_arr['error_response'])){
						if($result_arr['error_response']['msg'] == 'Invalid session:session-expired'){
							//处理session过期
							$model->table('shop')->where(array('shop_id'=>intval($_GET['shop_id'])))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
							echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_taobao_the_session_expires').Language::get('bp_comma').Language::get('bp_product_please_bind_again')));die;
						}
						echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_product_specification_information_synchronization').Language::get('bp_openparen').'ERROR:'.$result_arr['error_response']['msg'].Language::get('bp_closeparen')));die;
					}
					break;
				case 3://ShopEx单店
					$api_url = $platinfo['shopex_apiurl'];
					$sync_array = array();
					foreach ((array)$sku_id as $k=>$v){
						$sync_array[$v] = array(
							'price'=>$sku_price[$k],
							'storage'=>$sku_num[$k]
						);
					}
					$sync_string = base64_encode(serialize($sync_array));
					$cp_info = $model->field('cp_id,cp_mallpid')->table('product')->where(array('cp_id'=>$cp_id))->find();
					$inquire_string = 'command=skuedit&goods_id='.$cp_info['cp_mallpid'].'&sku_edit='.$sync_string;
					$final_url = $api_url.'/index.php?'.$inquire_string;
					$opts = array(
					  'http'=>array(
					    'method'=>"GET",
					    'timeout'=>60,
					   )
					);
					$context   = stream_context_create($opts);
					$json_data = file_get_contents($final_url,false,$context);
					if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_product_specification_information_synchronization')));die; }
					$data = json_decode($json_data,true);
					if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] != 'finish'){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_product_specification_information_synchronization')));die; }
					break;
			}
			//更新本地数据
			$sku_array = array();
			foreach ((array)$sku_id as $k=>$v){
				switch (intval($_GET['shop_platform'])){
					case 1://ShopNC体系商城
						$sku_array[] = array('spec_id'=>$v,'storage'=>$sku_num[$k],'price'=>$sku_price[$k],'serial'=>$sku_code[$k],'desc'=>$sku_prop[$k]);
						break;
					case 2://淘宝
						$sku_array[] = array('sku_id'=>$v,'properties_name'=>$sku_prop[$k],'quantity'=>$sku_num[$k],'price'=>$sku_price[$k],'outer_id'=>$sku_code[$k]);
						break;
					case 3://ShopEx单店
						$sku_array[] = array('product_id'=>$v,'store'=>$sku_num[$k],'price'=>$sku_price[$k],'bn'=>$sku_code[$k],'pdt_desc'=>$sku_prop[$k]);
						break;
				}
			}
			$update_rs = $model->table('product')->where(array('cp_id'=>$cp_id))->update(array('cp_sku'=>serialize($sku_array)));
			if($update_rs){
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_product_editors_save_failed')));die;
			}
		}
		//调取商品信息
		$cp_info = $model->field('product.*,shop.shop_platform')->table('product,shop')->join('left')->on('product.shop_id=shop.shop_id')->where(array('cp_id'=>$cp_id))->find();
		Tpl::output('cp_info',$cp_info);
		Tpl::output('sku_list',unserialize($cp_info['cp_sku']));
		Tpl::showpage('cp_skuinfo','windowopen_layout');
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_product_goods'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'product_list','menu_name'=>Language::get('bp_product_shop_goods'),'menu_act'=>'product','menu_op'=>'product_list');
		//$arr[0]['submenu'][1] = array('menu_key'=>'class_list','menu_name'=>'商品分类','menu_act'=>'product_class','menu_op'=>'class_list');
		//$arr[0]['submenu'][2] = array('menu_key'=>'import','menu_name'=>'商品导入','menu_act'=>'product_import','menu_op'=>'import');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}