<?php
/**
 * 权限组管理页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class permissionControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('permission');
    }

	/**
	 * 权限组列表
	 */
	public function permissionlistOp(){
		//一般列表
		$model = Model();
		if (!empty($_GET['search_name'])){
			$where['pmn_name'] = array('like',"%{$_GET['search_name']}%");
		}
		$pmn_list = $model->table('permission')->where($where)->order('pmn_sort asc,pmn_id asc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('pmn_list',$pmn_list);
		//左侧菜单
		$this->setleftmenu('permissionlist');
		Tpl::showpage('permissionlist');
	}
	/**
	 * 添加权限组
	 */
	public function permissionaddOp(){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["pmn_name"],"require"=>"true","message"=>Language::get('bp_permission_please_add_the_name_of_the'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if (empty($_POST['m'])){
				showDialog(Language::get('bp_permission_to_access_the_module._please_select'),'','error');
			}
			$insert_arr = array();
			$insert_arr['pmn_name'] = trim($_POST['pmn_name']);
			$insert_arr['pmn_sort'] = intval($_POST['pmn_sort']);
			$permissionstr = implode(',',$_POST['m']);
			$insert_arr['pmn_accessright'] = $permissionstr;
			$rs = $model->table('permission')->insert($insert_arr);
			if ($rs){
				showDialog(Language::get('bp_permission_privilege_groups_added_successfully'),"index.php?act=permission&op=permissionlist",'succ');
			}else{
				showDialog(Language::get('bp_permission_add_failure_privilege_groups'),'','error');
			}
		}else {
			//查询模块列表
			$mlist = $model->table('sysmodule')->where()->order('sm_sort,sm_id')->select(array('limit'=>'all'));
			if (empty($mlist)){
				showDialog(Language::get('bp_permission_system_module_information_error'),'','error');
			}
			$mlist_new = array();
			foreach ((array)$mlist as $k=>$v){
				if (!isset($mlist_new[$v['sm_actkey']])){
					$mlist_new[$v['sm_actkey']]['act'] = array('sm_actkey'=>$v['sm_actkey'],'sm_actname'=>$v['sm_actname']);
				}
				$mlist_new[$v['sm_actkey']]['op'][] = $v;
			}
			Tpl::output('mlist_new',$mlist_new);
			//左侧菜单
			$this->setleftmenu('permissionlist');
			Tpl::showpage('permissionadd');
		}
	}
	/**
	 * 编辑权限组
	 */
	public function permissioneditOp(){
		if (!empty($_GET['type'])){
			$funname = "edit".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//一般编辑操作
			$pmnid = intval($_GET['pmnid']);
			if ($pmnid<=1){
				$pmnid = intval($_POST['pmnid']);
			}
			if($pmnid <= 1){
				showDialog(Language::get('bp_permission_parameter_error'),'','error');
			}
			$model = Model();
			if (chksubmit()){
				$obj_validate = new Validate();
				$validate_arr[] = array("input"=>$_POST["pmn_name"],"require"=>"true","message"=>Language::get('bp_permission_please_add_the_name_of_the'));
				$obj_validate -> validateparam = $validate_arr;
				$error = $obj_validate->validate();
				if ($error != ''){
					showDialog($error,'','error');
				}
				if (empty($_POST['m'])){
					showDialog(Language::get('bp_permission_to_access_the_module._please_select'),'','error');
				}
				$update_arr = array();
				$update_arr['pmn_name'] = trim($_POST['pmn_name']);
				$update_arr['pmn_sort'] = intval($_POST['pmn_sort']);
				$permissionstr = implode(',',$_POST['m']);
				$update_arr['pmn_accessright'] = $permissionstr;
				$rs = $model->table('permission')->where(array('pmn_id'=>$pmnid))->update($update_arr);
				if ($rs){
					showDialog(Language::get('bp_permission_permissions_set_editor'),"index.php?act=permission&op=permissionlist",'succ');
				}else{
					showDialog(Language::get('bp_permission_permissions_set_editor_fails'),'','error');
				}
			}else {
				//查询岗位信息
				$pmn_info = $model->table('permission')->where(array('pmn_id'=>$pmnid))->find();
				if (empty($pmn_info)){
					showDialog(Language::get('bp_permission_wrong_information'),'','error');
				}
				//处理权限字段
				$pmn_info['pmn_accessrightarr'] = array();
				if (!empty($pmn_info['pmn_accessright'])){
					$pmn_info['pmn_accessrightarr'] = explode(',',$pmn_info['pmn_accessright']);
				}
				//查询模块列表
				$mlist = $model->table('sysmodule')->order('sm_sort,sm_id')->select(array('limit'=>'all'));
				if (empty($mlist)){
					showDialog(Language::get('bp_permission_system_module_information_error'),'','error');
				}
				$mlist_new = array();
				foreach ((array)$mlist as $k=>$v){
					if (!isset($mlist_new[$v['sm_actkey']])){
						$mlist_new[$v['sm_actkey']]['act'] = array('sm_actkey'=>$v['sm_actkey'],'sm_actname'=>$v['sm_actname']);
					}
					$mlist_new[$v['sm_actkey']]['op'][] = $v;
				}
				Tpl::output('mlist_new',$mlist_new);
				Tpl::output('pmn_info',$pmn_info);
				//左侧菜单
				$this->setleftmenu('permissionlist');
				Tpl::showpage('permissionadd');
			}
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_permission_employees'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'departmentlist','menu_name'=>Language::get('bp_permission_department_of_management'),	'menu_act'=>'department','menu_op'=>'departmentlist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'permissionlist','menu_name'=>Language::get('bp_permission_permissions_set'),	'menu_act'=>'permission','menu_op'=>'permissionlist','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'jobpostlist','menu_name'=>Language::get('bp_permission_post_management'),	'menu_act'=>'jobpost','menu_op'=>'jobpostlist','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'userlist','menu_name'=>Language::get('bp_permission_staff_management'),	'menu_act'=>'user','menu_op'=>'userlist','linktype'=>'0');
		$arr[0]['submenu'][4] = array('menu_key'=>'userloglist','menu_name'=>Language::get('bp_permission_employees_log'),	'menu_act'=>'user','menu_op'=>'userlog','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}