<?php
/**
 * 订单管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class orderControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('order');
    }

	/**
	 * 订单列表
	 */
	public function order_listOp(){
		set_time_limit(0);
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		/**
		 * 调取订单列表
		 */
		$where_condition = array();
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_order_you_have_no_permission_to_view_the_store'));
			}
			if(intval($_GET['shop_id']) == 0){
				redirect('index.php?act=order&op=order_list&shop_id='.$_SESSION['shop_id']);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					redirect('index.php?act=order&op=order_list&shop_id='.$default_shop);die;
				}
			}
		}
		//过滤器
		$filter = trim($_GET['filter']);
		switch ($filter){
			case '':
				$where_condition['orders.co_status'] = array('neq',3);
				break;
			case 'working':
				$where_condition['orders.co_status'] = 0;
				break;
			case 'done':
				$where_condition['orders.co_status'] = 1;
				break;
			case 'shipment':
				$where_condition['orders.co_status'] = 2;
				break;
			case 'trash':
				if (!cPermission('order','order_del')){
					showMessage(Language::get('bp_order_you_dont_have_the_right_to_the_operation'));
				}
				$where_condition['orders.co_status'] = 3;
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'co_subject':
					$where_condition['orders.co_subject'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cc_name':
					$where_condition['customer.cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'co_code':
					$where_condition['orders.co_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition['orders.shop_id'] = intval($_GET['shop_id']);
		}
		//自定义字段的搜索处理
		if(!empty($_GET['selfdic_search'])){
			$sd_choose = array();
			foreach ((array)$_GET['selfdic_search'] as $sk=>$sv){
				if($sv != 0){
					$where_condition['orders.co_self_field'] = array('like','%'.$sv.'%');
					$sd_choose[] = $sv;
				}
			}
			Tpl::output('sd_choose',$sd_choose);
		}
		if ($_GET['exporttype'] == 'excel'){
			$order_list = $model->field('orders.*,customer.cc_name,user.user_truename,shop.shop_name')->table('orders,customer,user,shop')->join('left')->on('customer.cc_id=orders.cc_id,orders.co_staff_id=user.user_id,orders.shop_id=shop.shop_id')->where($where_condition)->order('orders.co_addtime desc')->select();
		}else {
			//每页显示条数
			$pagesize = intval($_GET['pagesize']) > 0 ? intval($_GET['pagesize']) : 10;
			$order_list = $model->field('orders.*,customer.cc_name,user.user_truename,shop.shop_name')->table('orders,customer,user,shop')->join('left')->on('customer.cc_id=orders.cc_id,orders.co_staff_id=user.user_id,orders.shop_id=shop.shop_id')->where($where_condition)->page($pagesize)->order('orders.co_addtime desc')->select();
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 自定义字段的处理
		 */
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		//导出Excel
		if ($_GET['exporttype'] == 'excel'){
			//导出Excel
			import('excel#class');
			$excel_class = new ExcelXML(C('exportfilefont'));
			$excel_data = array();
			//设置样式
			$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_the_order_number'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_the_name_of_the_shop'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_member_name'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_amount_of_goods'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_courier_fees'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_amount_actually_paid'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_payment_time'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_place_the_order_of_time'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_review_the_status'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_order_the_order_status'));
			if(!empty($selfdic_show) && is_array($selfdic_show)){
				foreach ((array)$selfdic_show as $sk=>$sv){
					$excel_data[0][] = array('styleid'=>'s_title','data'=>$sv['field_name']);
				}
			}
			//data
			foreach ((array)$order_list as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['co_code']);
				$tmp[] = array('data'=>$v['shop_name']);
				$tmp[] = array('data'=>($v['cc_name']==''?'<font style="color:red">'.Language::get('bp_order_have_been_unable_to_find_the_member_data').'</font>':$v['cc_name']));
				$tmp[] = array('format'=>'Number','data'=>ncPriceFormat($v['co_total_price']));
				$tmp[] = array('format'=>'Number','data'=>ncPriceFormat($v['express_payment']));
				$tmp[] = array('format'=>'Number','data'=>ncPriceFormat($v['co_final_price']));
				$tmp[] = array('data'=>@date('Y-m-d H:i:s',$v['co_paytime']));
				$tmp[] = array('data'=>@date('Y-m-d H:i:s',$v['co_addtime']));
				switch ($v['co_check']){
					case '0':
						$tmp[] = array('data'=>Language::get('bp_order_not_audit'));
						break;
					case '1':
						$tmp[] = array('data'=>Language::get('bp_order_approved'));
						break;
					case '2':
						$tmp[] = array('data'=>Language::get('bp_order_abnormal'));
						break;
				}
				switch ($v['co_status']){
					case '0':
						$tmp[] = array('data'=>Language::get('bp_order_conducted_in_the'));
						break;
					case '1':
						$tmp[] = array('data'=>Language::get('bp_order_transaction_completed'));
						break;
					case '2':
						$tmp[] = array('data'=>Language::get('bp_order_already_shipping'));
						break;
					case '3':
						$tmp[] = array('data'=>Language::get('bp_order_has_been_shut_down'));
						break;
				}
				if(!empty($selfdic_show) && is_array($selfdic_show)){
					$selfdic_choose = unserialize($v['cc_self_field']);
					foreach ((array)$output['selfdic_show'] as $sk=>$sv){
						$tmp[] = array('data'=>(intval($selfdic_choose[$sv['p_id']])==0?Language::get('bp_order_no'):$sv['child_option'][$selfdic_choose[$sv['p_id']]]['cd_name']));
					}
				}
				$excel_data[] = $tmp;
			}
			$excel_class->addArray($excel_data);
			$excel_class->addWorksheet(Language::get('bp_order_the_order_information'));
			$excel_class->generateXML(Language::get('bp_order_the_order_information').date('Y-m-d H-i-s',time()));
			exit();
		}
		Tpl::output('selfdic_show',$selfdic_show);
		Tpl::output('selfdic_search',$selfdic_search);
		Tpl::output('order_list',$order_list);
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['filter']) == 'trash' && trim($_GET['from']) == 'tm'){
			settrashleftmenu('order_trash');
		}else{
			$this->setleftmenu('order_list');
		}
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('currenturl',request_uri());
		Tpl::output('shop_name',$shop_list[intval($_GET['shop_id'])]['shop_name']);
		Tpl::showpage('order_list');
	}
	/**
	 * 新增订单
	 */
	public function order_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 添加订单
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["co_subject"],"require"=>"true","message"=>Language::get('bp_order_please_fill_out_the_order'));
			$validate_arr[] = array("input"=>$_POST["np_cid"],"require"=>"true","message"=>Language::get('bp_order_please_select_the_order_members'));
			$validate_arr[] = array("input"=>$_POST["co_code"],"require"=>"true","message"=>Language::get('bp_order_please_fill_out_the_order_number'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//订单编号去重判断
			$co_info = $model->field('co_id,co_code')->table('orders')->where(array('co_code'=>trim($_POST['co_code'])))->find();
			if(!empty($co_info)){
				showDialog(Language::get('bp_order_the_order_number_is_already_in_use'));
			}
			//判断是否有收货地址和是否选择了商品
			if(trim($_POST['address_method']) == '' || (trim($_POST['address_method'])=='get' && intval($_POST['address_select'])==0) || (trim($_POST['address_method'])=='add' && (trim($_POST['receiver_name'])=='' || trim($_POST['address_detail'])==''))){
				showDialog(Language::get('bp_order_orders_must_be_the_consignee_and_shipping_address'));
			}
			$insert_product_array = array();
			$p_num = intval($_POST['total_product_num']);
			$co_total_price = 0;
			$co_cost_price = 0;
			for($i=1;$i<=$p_num;$i++){
				if(intval($_POST['cp_id_'.$i]) <= 0){
					continue;
				}
				if(trim($_POST['np_pname_'.$i]) != Language::get('bp_order_click_on_the_select_goods') && trim($_POST['np_pname_'.$i]) != Language::get('bp_order_please_search_from_above')){
					//判断是否填写了负数或零
					if($_POST['p_num_'.$i] <= 0 || $_POST['p_unitprice_'.$i] <= 0){
						showDialog(Language::get('bp_order_product_sales_quantity_and_sales_unit_price_must'),'','error','','5');
					}
					//判断是否低于最低销售单价
					if((trim($_POST['p_unitprice_'.$i])) < trim($_POST['cp_lowest_price_'.$i])){
						showDialog('"'.trim($_POST['np_pname_'.$i]).'"'.Language::get('bp_order_the_price_cannot_be_lower_than_the_set_up_of_the').Language::get('bp_comma').Language::get('bp_order_please_check_the'),'','error','','5');
					}
					$insert_product_array[] = array(
						'cp_id'=>intval($_POST['cp_id_'.$i]),
						'cop_unitprice'=>trim($_POST['p_unitprice_'.$i]),
						'cop_pnum'=>intval($_POST['p_num_'.$i]),
						'cop_total_price'=>intval($_POST['p_num_'.$i])*trim($_POST['p_unitprice_'.$i]),
						'cop_note'=>trim($_POST['p_note_'.$i]),
						'cp_ori_price'=>trim($_POST['cp_ori_price_'.$i]),
						'cp_cost'=>trim($_POST['cp_cost_'.$i])
					);
					$co_total_price += intval($_POST['p_num_'.$i])*trim($_POST['p_unitprice_'.$i]);
					$co_cost_price += intval($_POST['p_num_'.$i])*trim($_POST['cp_cost_'.$i]);
				}
			}
			if(empty($insert_product_array)){
				showDialog(Language::get('bp_order_the_order_have_to_choose_goods'));
			}
			//订单收货地址数据录入
			if(trim($_POST['address_method']) == 'add'){
				$insert_address_array = array(
					'cc_id'=>intval($_POST["np_cid"]),
					'receiver_name'=>trim($_POST['receiver_name']),
					'address_detail'=>trim($_POST['address_detail']),
					'postcode'=>trim($_POST['postcode']),
					'phone'=>trim($_POST['receiver_phone']),
					'mobilephone'=>trim($_POST['receiver_mobilephone'])
				);
				$address_id = $model->table('address')->insert($insert_address_array);
				if($address_id === false){
					showDialog(Language::get('bp_order_the_new_shipping_address_to_fail').Language::get('bp_comma').Language::get('bp_order_this_order_is_not_saved_successfully'));
				}
			}else{
				$address_id = intval($_POST['address_select']);
			}
			/*订单表数据录入*/
			//自定义字段的处理
			$co_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$co_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			//调取客户信息
			$cc_info = $model->field('cc_id,shop_id')->table('customer')->where(array('cc_id'=>intval($_POST['np_cid'])))->find();
			$insert_order_array = array(
				'cc_id'=>intval($_POST['np_cid']),
				'co_staff_id'=>$_SESSION['member_id'],
				'co_subject'=>trim($_POST['co_subject']),
				'co_code'=>trim($_POST['co_code']),
				'co_type'=>intval($_POST['co_type']),
				'co_paymethod'=>intval($_POST['paymethod']),
				'co_addstaff'=>$_SESSION['member_id'],
				'co_addtime'=>time(),
				'late_delivery_time'=> ($t = strtotime(trim($_POST['last_delivery_time'])))>0?$t:0,
				'address_id'=>$address_id,
				'co_note'=>trim($_POST['co_note']),
				'co_status'=>0,
				'co_statuschangetime'=>time(),
				'co_total_price'=>ncPriceFormat($co_total_price),
				'co_final_price'=>ncPriceFormat($co_total_price)+trim($_POST['adjust_price']),
				'co_cost_price'=>$co_cost_price,
				'co_self_field'=>serialize($co_self_field),
				'express_payment'=>trim($_POST['express_payment'])
			);
			$co_id = $model->table('orders')->insert($insert_order_array);
			if($co_id === false){
				showDialog(Language::get('bp_order_order_entry_failure'));
			}
			//订单商品详细表数据录入
			foreach ((array)$insert_product_array as $k=>$v){
				$insert_product_array[$k]['co_id'] = $co_id;
			}
			//确保订单会员不再是公海认领会员
			$model->table('customer')->where(array('cc_id'=>intval($_POST['np_cid'])))->update(array('cc_getseatime'=>0));

			$rs = $model->table('order_product')->insertAll($insert_product_array);
			if($rs){
				showDialog(Language::get('bp_order_order_is_saved_successfully'),'index.php?act=order&op=order_list','succ');
			}else{
				showDialog(Language::get('bp_order_save_failed_orders'));
			}
		}
		//调取该模块自定义字段信息
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('order_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::showpage('order_add');
	}
	/**
	 * 编辑订单
	 */
	public function order_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 编辑订单
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["co_subject"],"require"=>"true","message"=>Language::get('bp_order_please_fill_out_the_order'));
			$validate_arr[] = array("input"=>$_POST["currency_unit"],"require"=>"true","message"=>Language::get('bp_order_please_select_a_currency_unit'));
			$validate_arr[] = array("input"=>$_POST["co_code"],"require"=>"true","message"=>Language::get('bp_order_please_fill_out_the_order_number'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//订单状态修改条件判断
			if(intval($_POST['pre_co_status']) != intval($_POST['co_status'])){
				$cop_list = $model->table('order_product')->where(array('co_id'=>intval($_POST['co_id'])))->select();
				switch (intval($_POST['co_status'])){
					case '1':
						foreach ((array)$cop_list as $k=>$v){
							if($v['cop_pnum'] > $v['cop_given']){
								showDialog(Language::get('bp_order_the_order_have_not_delivery_the_goods').Language::get('bp_comma').Language::get('bp_order_so_we_can_not_modify_the_status_to').'"'.Language::get('bp_order_transaction_completed').'"');
								break;
							}
						}
						break;
					case '3':
						foreach ((array)$cop_list as $k=>$v){
							if($v['cop_given'] > 0){
								showDialog(Language::get('bp_order_this_order_already_delivery_warehouse').Language::get('bp_comma').Language::get('bp_order_so_we_can_not_modify_the_status_to').'"'.Language::get('bp_order_has_been_cancelled').'"');
								break;
							}
						}
						break;
				}
			}
			/*判断是否有收货地址和是否选择了商品*/
			//地址
			if(trim($_POST['address_method']) == '' || (trim($_POST['address_method'])=='get' && intval($_POST['address_select'])==0) || (trim($_POST['address_method'])=='add' && (trim($_POST['receiver_name'])=='' || trim($_POST['address_detail'])==''))){
				showDialog(Language::get('bp_order_orders_must_be_the_consignee_and_shipping_address'));
			}
			//商品
			$insert_product_array = array();
			$p_num = intval($_POST['new_product_num']);
			$co_total_price = 0;
			$co_cost_price = 0;
			for($i=1;$i<=$p_num;$i++){
				if(intval($_POST['cp_id_'.$i]) <= 0){
					continue;
				}
				if(trim($_POST['np_pname_'.$i]) != Language::get('bp_order_click_on_the_select_goods') && trim($_POST['np_pname_'.$i]) != Language::get('bp_order_please_search_from_above')){
					//判断是否填写了负数或零
					if($_POST['p_num_'.$i] <= 0 || $_POST['p_unitprice_'.$i] <= 0){
						showDialog(Language::get('bp_order_product_sales_quantity_and_sales_unit_price_must'),'','error','','5');
					}
					//判断是否低于最低销售单价
					if((trim($_POST['p_unitprice_'.$i])) < trim($_POST['cp_lowest_price_'.$i])){
						showDialog('"'.trim($_POST['np_pname_'.$i]).'"'.Language::get('bp_order_the_price_cannot_be_lower_than_the_set_up_of_the').Language::get('bp_comma').Language::get('bp_order_please_check_the'),'','error','','5');
					}
					$insert_product_array[] = array(
						'cp_id'=>intval($_POST['cp_id_'.$i]),
						'co_id'=>intval($_POST['co_id']),
						'cop_unitprice'=>trim($_POST['p_unitprice_'.$i]),
						'cop_pnum'=>intval($_POST['p_num_'.$i]),
						'cop_given'=>intval($_POST['p_given_'.$i]),
						'cop_total_price'=>intval($_POST['p_num_'.$i])*trim($_POST['p_unitprice_'.$i]),
						'cop_note'=>trim($_POST['p_note_'.$i]),
						'cp_ori_price'=>trim($_POST['cp_ori_price_'.$i]),
						'cp_cost'=>trim($_POST['cp_cost_'.$i])
					);
					$co_total_price += intval($_POST['p_num_'.$i])*trim($_POST['p_unitprice_'.$i]);
					$co_cost_price += intval($_POST['p_num_'.$i])*trim($_POST['cp_cost_'.$i]);
				}
			}
			if(empty($insert_product_array) && (count($_POST['p_del'])==count($_POST['cop_id']))){
				showDialog(Language::get('bp_order_orders_for_goods_cant_for_empty'));
			}
			$model->table('order_product')->insertAll($insert_product_array);
			if(!empty($_POST['cop_id'])){
				foreach ((array)$_POST['cop_id'] as $k=>$v){
					if(in_array($v, $_POST['p_del'])){
						$model->table('order_product')->where(array('cop_id'=>$v))->delete();
					}else{
						if((trim($_POST['cop_unitprice'][$k])) < trim($_POST['lowest_price'][$k])){
							showDialog('"'.trim($_POST['cp_name'][$k]).'"'.Language::get('bp_order_the_price_cannot_be_lower_than_the_set_up_of_the').Language::get('bp_comma').Language::get('bp_order_please_check_the'),'','error','','5');
						}
						$tmp_update_product = array(
							'cop_pnum'=>intval($_POST['cop_pnum'][$k]),
							'cop_given'=>intval($_POST['cop_given'][$k]),
							'cop_unitprice'=>trim($_POST['cop_unitprice'][$k]),
							'cop_note'=>trim($_POST['cop_note'][$k]),
							'cop_total_price'=>intval($_POST['cop_pnum'][$k])*trim($_POST['cop_unitprice'][$k])
						);
						$co_total_price += $tmp_update_product['cop_pnum']*$tmp_update_product['cop_unitprice'];
						$co_cost_price += $tmp_update_product['cop_pnum']*trim($_POST['cp_cost'][$k]);
						$model->table('order_product')->where(array('cop_id'=>$v))->update($tmp_update_product);
						unset($tmp_update_product);
					}
				}
			}
			//订单收货地址数据录入
			if(trim($_POST['address_method']) == 'add'){
				$insert_address_array = array(
					'cc_id'=>intval($_POST["cc_id"]),
					'receiver_name'=>trim($_POST['receiver_name']),
					'address_detail'=>trim($_POST['address_detail']),
					'postcode'=>trim($_POST['postcode']),
					'phone'=>trim($_POST['receiver_phone']),
					'mobilephone'=>trim($_POST['receiver_mobilephone'])
				);
				$address_id = $model->table('address')->insert($insert_address_array);
				if($address_id === false){
					showDialog(Language::get('bp_order_the_new_shipping_address_to_fail').Language::get('bp_comma').Language::get('bp_order_failed_to_edit_this_order_successfully'));
				}
			}else{
				$address_id = intval($_POST['address_select']);
			}
			/*更新订单主表数据*/
			//自定义字段的处理
			$co_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$co_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			$update_order_array = array(
				'co_subject'=>trim($_POST['co_subject']),
				'co_code'=>trim($_POST['co_code']),
				'co_type'=>intval($_POST['co_type']),
				'co_paymethod'=>intval($_POST['paymethod']),
				'late_delivery_time'=> ($t = strtotime(trim($_POST['last_delivery_time'])))>0?$t:0,
				'address_id'=>$address_id,
				'co_note'=>trim($_POST['co_note']),
				'co_total_price'=>ncPriceFormat($co_total_price),
				'co_final_price'=>ncPriceFormat($co_total_price)+trim($_POST['adjust_price']),
				'co_cost_price'=>$co_cost_price,
				'co_self_field'=>serialize($co_self_field),
				'co_statuschangetime'=>time(),
				'express_delivery'=>intval($_POST['express_delivery']),
				'express_payment'=>trim($_POST['express_payment']),
				'co_check'=>0,
				'co_checkrp'=>''
			);
			$rs = $model->table('orders')->where(array('co_id'=>intval($_POST['co_id'])))->update($update_order_array);
			if($rs){
				showDialog(Language::get('bp_order_order_to_edit_success'),'index.php?act=order&op=order_list','succ');
			}else{
				showDialog(Language::get('bp_order_order_editing_failed'));
			}
		}
		/**
		 * 调取订单数据
		 */
		$co_id = intval($_GET['co_id']);
		if($co_id <= 0){
			showDialog(Language::get('bp_order_parameter_error'));
		}
		$co_info = $model->field('orders.*,customer.cc_name,user.user_truename')->table('orders,customer,user')->join('left')->on('orders.cc_id=customer.cc_id,orders.co_staff_id=user.user_id')->where(array('orders.co_id'=>$co_id))->find();
		Tpl::output('co_info',$co_info);
		//调取该模块自定义字段信息
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		//调取订单商品列表
		$product_list = $model->field('order_product.*,product.cp_name,product.cp_lowest_price,product.cp_cost,product.cp_mallurl')->table('order_product,product')->join('left')->on('order_product.cp_id=product.cp_id')->where(array('order_product.co_id'=>$co_id))->select();
		Tpl::output('product_list',$product_list);
		//调取订单收货地址信息
		$address_list = $model->table('address')->where(array('cc_id'=>$co_info['cc_id']))->select();
		Tpl::output('address_list',$address_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('order_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('selfdic_select',unserialize($co_info['co_self_field']));
		Tpl::showpage('order_edit');
	}
	/**
	 * 订单日志列表
	 */
	public function order_logOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_order_you_have_no_permission_to_view_the_store'));
			}
			if(intval($_GET['shop_id']) == 0){
				$r_url = 'index.php?act=order&op=order_log&shop_id='.$_SESSION['shop_id'];
				if(trim($_GET['from']) != ''){
					$r_url .= '&from='.trim($_GET['from']);
				}
				redirect($r_url);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					$r_url = 'index.php?act=order&op=order_log&shop_id='.$default_shop;
					if(trim($_GET['from']) != ''){
						$r_url .= '&from='.trim($_GET['from']);
					}
					redirect($r_url);die;
				}
			}
		}
		/**
		 * 调取日志列表信息
		 */
		$where_condition = "";
		if(intval($_GET['co_id']) > 0){
			$where_condition['order_log.co_id'] = intval($_GET['co_id']);
			$co_info = $model->field('co_code')->table('orders')->where(array('co_id'=>intval($_GET['co_id'])))->find();
			Tpl::output('co_code',$co_info['co_code']);
		}else{
			//处理检索表单的请求
			if(trim($_GET['search_content']) != ''){
				$where_condition['orders.co_code'] = array('like','%'.trim($_GET['search_content']).'%');
				Tpl::output('search_content',trim($_GET['search_content']));
			}
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition['orders.shop_id'] = intval($_GET['shop_id']);
		}
		//每页显示条数
		$pagesize = intval($_GET['pagesize']) > 0 ? intval($_GET['pagesize']) : 10;
		$order_log_list = $model->field('order_log.*,orders.co_code,user.user_truename,shop.shop_name')->table('order_log,orders,user,shop')->join('left')->on('order_log.co_id=orders.co_id,order_log.col_staff=user.user_id,orders.shop_id=shop.shop_id')->where($where_condition)->page($pagesize)->order('order_log.col_time desc')->select();
		Tpl::output('order_log_list',$order_log_list);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from']) == 'lm'){
			setlogleftmenu('order_log');
		}else{
			$this->setleftmenu('order_log');
		}
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('order_log');
	}
	/**
	 * 查看订单详情
	 */
	public function order_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取订单数据
		 */
		$co_id = intval($_GET['co_id']);
		$co_info = $model->field('orders.*,customer.cc_name,user.user_truename,shop.shop_name')->table('orders,customer,user,shop')->join('left')->on('orders.cc_id=customer.cc_id,orders.co_staff_id=user.user_id,orders.shop_id=shop.shop_id')->where(array('orders.co_id'=>$co_id))->find();
		if(empty($co_info)){
			showMessage(Language::get('bp_order_cant_find_the_order_information'));
		}
		/*判断当前用户是否有查看权限*/
		if($_SESSION['shop_id'] > 0 && $_SESSION['shop_id'] != $co_info['shop_id']){
			showMessage(Language::get('bp_order_you_have_no_right_to_view_the_store_information'));
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('order_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		//调取订单商品列表
		$product_list = $model->field('order_product.*,product.cp_name,product.cp_mallurl')->table('order_product,product')->join('left')->on('order_product.cp_id=product.cp_id')->where(array('order_product.co_id'=>$co_id))->select();
		Tpl::output('product_list',$product_list);
		//调取订单收货地址信息
		$address_info = $model->table('address')->where(array('address_id'=>$co_info['address_id']))->find();
		Tpl::output('address_info',$address_info);
		//调取订单日志信息
		$orderlog_list = $model->field('order_log.*,user.user_truename')->table('order_log,user')->join('left')->on('order_log.col_staff=user.user_id')->where(array('co_id'=>$co_id))->order('col_time desc')->select();
		Tpl::output('orderlog_list',$orderlog_list);
		/**
		 * 模板输出
		 */
		Tpl::output('co_info',$co_info);
		Tpl::output('dic_array',$dic_array);
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('selfdic_select',unserialize($co_info['co_self_field']));
		Tpl::showpage('order_view','windowopen_layout');
	}
	/**
	 * 取消订单
	 */
	public function order_delOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		if(trim($_GET['type'])=='batch'){
			$co_id_string = trim($_GET['co_id'],',');
			if($co_id_string == ''){
				showDialog(Language::get('bp_order_parameter_error'));
			}
			$rs = $model->table('orders')->where(array('co_id'=>array('in',$co_id_string)))->update(array('co_status'=>3));
		}else{
			$co_id = intval($_GET['co_id']);
			if($co_id <= 0){
				showDialog(Language::get('bp_order_parameter_error'));
			}
			$rs = $model->table('orders')->where(array('co_id'=>$co_id))->update(array('co_status'=>3));
		}
		if($rs){
			showDialog(Language::get('bp_order_order_cancellation_is_successful'),'index.php?act=order&op=order_list','succ');
		}else{
			showDialog(Language::get('bp_order_cancel_the_order_failed'));
		}
	}
	/**
	 * 发货记录
	 */
	public function shipment_listOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 根据权限范围调取发货记录
		 */
		/*分析当前员工的权限范围*/
		$right_array = cDataPermission('orders');
		$where_condition = array();
		//部门范围
		if($right_array['data'] == 'dp'){
			$where_condition['orders.dp_id'] = array('in',$_SESSION['dp_id'].($this->dp_son!=''?",".$this->dp_son:''));
		}
		//个人范围
		if($right_array['data'] == 'own'){
			$where_condition['orders.co_staff_id'] = $_SESSION['member_id'];
		}
		//过滤器
		$filter = trim($_GET['filter']);
		switch ($filter){
			case 'unverify':
				$where_condition['shipment.shipment_verify'] = 0;
				break;
			case 'unshipment':
				$where_condition['shipment.shipment_finish'] = 0;
				break;
			case 'alldone':
				$where_condition['shipment.shipment_verify'] = 1;
				$where_condition['shipment.shipment_finish'] = 1;
				break;
			case 'allundone':
				$where_condition['shipment.shipment_verify'] = 0;
				$where_condition['shipment.shipment_finish'] = 0;
				break;
			case 'unusual':
				$where_condition['shipment.shipment_verify'] = 2;
				break;
			case 'outwh_unusual':
				$where_condition['pick.pick_rstatus'] = 2;
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'co_subject':
					$where_condition['orders.co_subject'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cc_name':
					$where_condition['customer.cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'co_code':
					$where_condition['orders.co_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'shipment_code':
					$where_condition['shipment.shipment_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		$shipment_list = $model->field('shipment.*,orders.co_code,orders.co_subject,customer.cc_name')->table('shipment,orders,customer,pick')->join('left')->on('shipment.co_id=orders.co_id,orders.cc_id=customer.cc_id,shipment.shipment_id=pick.shipment_id')->where($where_condition)->order('shipment.addstaff_time desc')->page(10)->select();
		Tpl::output('shipment_list',$shipment_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('shipment_list');
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('shipment_list');
	}
	/**
	 * 新增发货单
	 */
	public function shipment_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 新增发货单
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["co_id"],"require"=>"true","message"=>"请选择订单");
			$validate_arr[] = array("input"=>$_POST["shipment_code"],"require"=>"true","message"=>"请填写发货单编号");
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//添加发货单条件判断
			if(!empty($_POST['shipment_num'])){
				foreach ((array)$_POST['shipment_num'] as $k=>$v){
					if($v < 0){
						showDialog('发货数量不能为负数');
					}
					if($v > $_POST['remain_num'][$k]){
						showDialog('"'.$_POST['cp_name'][$k].'"的发货数量不能大于未发货数，请检查','','error','','5');
					}
				}
			}
			//更新订单商品表信息
			$shipment_info = array();
			if(!empty($_POST['shipment_num'])){
				foreach ((array)$_POST['shipment_num'] as $k=>$v){
					if($v > 0){
						$model->table('order_product')->where(array('cop_id'=>$_POST['cop_id'][$k]))->update(array('cop_given'=>$_POST['cop_given'][$k]+$v));
						$shipment_info[] = array('cop_id'=>$_POST['cop_id'][$k],'cp_name'=>$_POST['cp_name'][$k],'cp_unit'=>$_POST['cp_unit'][$k],'p_num'=>$_POST['p_num'][$k],'p_given'=>$_POST['cop_given'][$k]+$v,'shipment_num'=>$v);
					}
				}
			}
			if(empty($shipment_info)){
				showDialog('请填写发货商品的发货数量');
			}
			//添加一个发货单
			$insert_array = array(
				'shipment_code'=>trim($_POST['shipment_code']),
				'co_id'=>intval($_POST['co_id']),
				'shipment_info'=>serialize($shipment_info),
				'addstaff_id'=>$_SESSION['member_id'],
				'addstaff_time'=>time(),
				'shipment_note'=>trim($_POST['shipment_note']),
				'shipment_sepsend'=>$_POST['shipment_sepsend']==''?1:intval($_POST['shipment_sepsend'])
			);
			$rs = $model->table('shipment')->insert($insert_array);
			if($rs){
				showDialog('发货单添加成功！','index.php?act=order&op=shipment_list','succ');
			}else{
				showDialog('发货单添加失败');
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('shipment_list');
		/**
		 * 模板输出
		 */
		Tpl::showpage('shipment_add');
	}
	/**
	 * 查看发货单
	 */
	public function shipment_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取发货单数据
		 */
		$shipment_id = intval($_GET['shipment_id']);
		if($shipment_id <= 0){
			showDialog('参数错误','','exception','error',1,0);
		}
		$where_condition = "shipment.shipment_id=".$shipment_id;
		$shipment_info = $model->field('shipment.*,orders.co_subject,orders.co_code,orders.co_staff_id,orders.dp_id,customer.cc_name,user.user_truename')->table('shipment,orders,customer,user')->join('left')->on('shipment.co_id=orders.co_id,orders.cc_id=customer.cc_id,shipment.addstaff_id=user.user_id')->where($where_condition)->find();
		if(empty($shipment_info)){
			showDialog('未能找到该发货单信息','','exception','error',1,0);
		}
		/*判断当前用户是否有查看权限*/
		//订单部门、个人范围(仓库人员不判断)
		if (!cPermission('warehouse','shipment_verify')){
			$right_array = cDataPermission('orders');
			$allpdp_id = $this->dp_array[$shipment_info['dp_id']]['d_allparentid'];
			if(($right_array['data'] == 'dp' && ($shipment_info['dp_id'] != $_SESSION['dp_id'] && strpos($allpdp_id,','.$_SESSION['dp_id'].',')===false)) || ($right_array['data'] == 'own' && $shipment_info['co_staff_id'] != $_SESSION['member_id'])){
				showMessage('您无权查看该发货单信息','','exception','error',1,0);
			}
		}
		Tpl::output('shipment_info',$shipment_info);
		$exc_staff = '';
		if($shipment_info['verify_staff'] > 0){
			$exc_staff  .= $shipment_info['verify_staff'].',';
		}
		if($shipment_info['shipment_staff'] > 0){
			$exc_staff  .= $shipment_info['shipment_staff'].',';
		}
		$exc_staff = trim($exc_staff,',');
		if($exc_staff != ''){
			$tmp_exc_staff_info = $model->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',$exc_staff)))->select();
			$exc_staff_info = array();
			if(!empty($tmp_exc_staff_info)){
				foreach ((array)$tmp_exc_staff_info as $k=>$v){
					$exc_staff_info[$v['user_id']] = $v['user_truename'];
				}
			}
			Tpl::output('exc_staff_info',$exc_staff_info);
		}
		//处理发货单商品详情信息
		$shipment_product = unserialize($shipment_info['shipment_info']);
		if(!empty($shipment_product)){
			$cop_id_string = '';
			foreach ($shipment_product as $k=>$v){
				$cop_id_string .= $v['cop_id'].',';
			}
			$cop_list = $model->field('cop_id,cp_id')->table('order_product')->where(array('cop_id'=>array('in',trim($cop_id_string,','))))->select();
			foreach ($shipment_product as $k=>$v){
				foreach ((array)$cop_list as $ck=>$cv){
					if($v['cop_id'] == $cv['cop_id']){
						$shipment_product[$k]['cp_id'] = $cv['cp_id'];
					}
				}
			}
		}
		Tpl::output('shipment_product',$shipment_product);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from'])=='w'){
			$this->setleftmenu('shipment_verify');
		}else{
			$this->setleftmenu('shipment_list');
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		//调取拣货单信息
		$pick_list = $model->field('pick.*,outwarehouse.outwh_status')->table('pick,outwarehouse')->join('left')->on('pick.pick_id=outwarehouse.outwh_des')->where(array('shipment_id'=>$shipment_id))->select();
		Tpl::output('pick_list',$pick_list);
		/**
		 * 模板输出
		 */
		Tpl::output('html_title','发货单详情');
		Tpl::showpage('shipment_view','windowopen_layout');
	}
	/**
	 * 编辑发货单
	 */
	public function shipment_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 编辑发货单
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["shipment_code"],"require"=>"true","message"=>"请填写发货单编号");
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//处理发货数量信息
			$shipment_info_array = array();
			if(!empty($_POST['cop_id'])){
				foreach ((array)$_POST['cop_id'] as $k=>$v){
					if($_POST['shipment_num'][$k] <= 0){
						showDialog('发货数量必须为正数');
					}
					if($_POST['shipment_num'][$k] > $_POST['max_shipment_num'][$k]){
						showDialog('"'.$_POST['cp_name'][$k].'"的发货数量不能大于本发货单之前的最大未发货数'.$_POST['max_shipment_num'][$k],'','error','','5');
					}
					$new_given = $_POST['p_given'][$k]-$_POST['old_shipment_num'][$k]+$_POST['shipment_num'][$k];
					if($_POST['shipment_num'][$k] != $_POST['old_shipment_num'][$k]){
						$model->table('order_product')->where(array('cop_id'=>$v))->update(array('cop_given'=>$new_given));
					}
					$shipment_info_array[] = array('cop_id'=>$v,'cp_name'=>$_POST['cp_name'][$k],'cp_unit'=>$_POST['cp_unit'][$k],'p_num'=>$_POST['p_num'][$k],'p_given'=>$new_given,'shipment_num'=>$_POST['shipment_num'][$k]);
					unset($new_given);
				}
			}
			//更新发货单表
			$update_shipment_array = array(
				'shipment_code'=>trim($_POST['shipment_code']),
				'shipment_note'=>trim($_POST['shipment_note']),
				'shipment_info'=>serialize($shipment_info_array),
				'shipment_sepsend'=>$_POST['shipment_sepsend']==''?1:intval($_POST['shipment_sepsend'])
			);
			$rs = $model->table('shipment')->where(array('shipment_id'=>intval($_POST['shipment_id'])))->update($update_shipment_array);
			if($rs){
				showDialog('发货单编辑成功！','index.php?act=order&op=shipment_list','succ');
			}else{
				showDialog('发货单编辑失败');
			}
		}
		/**
		 * 调取发货单详情
		 */
		$shipment_id = intval($_GET['shipment_id']);
		if($shipment_id <= 0){
			showDialog('参数错误');
		}
		$where_condition = "shipment.shipment_id=".$shipment_id;
		$shipment_info = $model->field('shipment.*,orders.co_subject,orders.co_code,customer.cc_name,user.user_truename')->table('shipment,orders,customer,user')->join('left')->on('shipment.co_id=orders.co_id,orders.cc_id=customer.cc_id,shipment.addstaff_id=user.user_id')->where($where_condition)->find();
		Tpl::output('shipment_info',$shipment_info);
		//处理发货单商品详情信息
		$shipment_product = unserialize($shipment_info['shipment_info']);
		Tpl::output('shipment_product',$shipment_product);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('shipment_list');
		/**
		 * 模板输出
		 */
		Tpl::showpage('shipment_edit');
	}
	/**
	 * 删除发货单
	 */
	public function shipment_delOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		$shipment_id = intval($_GET['shipment_id']);
		if($shipment_id <= 0){
			showDialog('参数错误');
		}
		$rs = $model->table('shipment')->where(array('shipment_id'=>intval($_GET['shipment_id'])))->delete();
		if($rs){
			showDialog('发货单删除成功！','index.php?act=order&op=shipment_list','succ');
		}else{
			showDialog('发货单删除失败');
		}
	}
	/**
	 * 发货日志
	 */
	public function shipment_logOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取发货日志信息
		 */
		if(intval($_GET['co_id']) > 0){
			$where_condition['shipment.co_id'] = intval($_GET['co_id']);
			$co_info = $model->field('co_code')->table('orders')->where(array('co_id'=>intval($_GET['co_id'])))->find();
			Tpl::output('co_code',$co_info['co_code']);
		}else{
			//分析当前员工的权限范围
			$right_array = cDataPermission('orders');
			$where_condition = array();
			//部门范围
			if($right_array['data'] == 'dp'){
				$where_condition['orders.dp_id'] = array('in',$_SESSION['dp_id'].($this->dp_son!=''?",".$this->dp_son:''));
			}
			//个人范围
			if($right_array['data'] == 'own'){
				$where_condition['orders.co_staff_id'] = $_SESSION['member_id'];
			}
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'co_code':
					$where_condition['orders.co_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'shipment_code':
					$where_condition['shipment.shipment_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		$csl_list = $model->field('shipment_log.*,shipment.shipment_code,user.user_truename,orders.co_code,orders.co_id')->table('shipment_log,shipment,user,orders')->join('left')->on('shipment_log.shipment_id=shipment.shipment_id,shipment_log.csl_staff=user.user_id,orders.co_id=shipment.co_id')->where($where_condition)->page(10)->order('shipment_log.csl_time desc')->select();
		Tpl::output('csl_list',$csl_list);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from']) == 'lm'){
			setlogleftmenu('shipment_log');
		}else{
			$this->setleftmenu('shipment_log');
		}
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('shipment_log');
	}
	/**
	 * 收款单列表
	 */
	public function income_listOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取收款记录
		 */
		/*分析当前员工的权限范围*/
		$right_array = cDataPermission('orders');
		$where_condition = array();
		//部门范围
		if($right_array['data'] == 'dp'){
			$where_condition['orders.dp_id'] = array('in',$_SESSION['dp_id'].($this->dp_son!=''?",".$this->dp_son:''));
		}
		//个人范围
		if($right_array['data'] == 'own'){
			$where_condition['orders.co_staff_id'] = $_SESSION['member_id'];
		}
		//过滤器
		$filter = trim($_GET['filter']);
		switch ($filter){
			case 'verify':
				$where_condition['income.ci_status'] = 0;
				break;
			case 'done':
				$where_condition['income.ci_status'] = 1;
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'co_code':
					$where_condition['orders.co_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cc_name':
					$where_condition['customer.cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'ci_code':
					$where_condition['income.ci_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		if(trim($_GET['ci_paymethod']) != ''){
			$where_condition['income.ci_paymethod'] = intval($_GET['ci_paymethod']);
			Tpl::output('ci_paymethod',trim($_GET['ci_paymethod']));
		}
		$income_list = $model->field('income.*,orders.co_code,orders.co_staff_id,customer.cc_name')->table('income,customer,orders')->join('left')->on('customer.cc_id=income.cc_id,income.co_id=orders.co_id')->where($where_condition)->page(10)->order('income.ci_addtime desc')->select();
		/**
		 * 订单所属员工
		 */
		$user_array = ($t = F('user')) ? $t : H('user',true,'file');
		if(!empty($income_list)){
			foreach ($income_list as $k=>$v){
				$income_list[$k]['co_staff_name'] = $user_array[$v['co_staff_id']]['user_truename'];
			}
		}
		Tpl::output('income_list',$income_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('income_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('income_list');
	}
	/**
	 * 新增收款单
	 */
	public function income_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 新增收款记录
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["co_id"],"require"=>"true","message"=>"请选择订单");
			$validate_arr[] = array("input"=>$_POST["ci_money"],"require"=>"true","message"=>"请填写收款金额");
			$validate_arr[] = array("input"=>$_POST["ci_payback_time"],"require"=>"true","message"=>"请选择收款时间");
			$validate_arr[] = array("input"=>$_POST["ci_code"],"require"=>"true","message"=>"请填写收款单编号");
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if(floatval(trim($_POST['ci_money'])) <= 0 || floatval(trim($_POST['ci_exchange_rate'])) <= 0){
				showDialog('收款金额和汇率必须为正数');
			}
			$co_info = $model->field('cc_id,dp_id,co_staff_id')->table('orders')->where(array('co_id'=>intval($_POST['co_id'])))->find();
			$insert_array = array(
				'ci_code'=>trim($_POST['ci_code']),
				'cc_id'=>intval($_POST['cc_id']),
				'co_id'=>intval($_POST['co_id']),
				'ci_batch'=>trim($_POST['ci_batch']),
				'ci_money'=>trim($_POST['ci_money']),
				'ci_price_unit'=>intval($_POST['ci_price_unit']),
				'ci_exchange_rate'=>trim($_POST['ci_exchange_rate']),
				'ci_paymethod'=>intval($_POST['ci_paymethod']),
				'ci_payback_time'=> ($t = strtotime(trim($_POST['ci_payback_time'])))>0?$t:0,
				'ci_bill'=>intval($_POST['ci_bill']),
				'ci_note'=>trim($_POST['ci_note']),
				'ci_addstaff'=>$_SESSION['member_id'],
				'ci_addtime'=>time(),
				'dp_id'=>$co_info['dp_id'],
				'ci_staff_id'=>$co_info['co_staff_id']
			);

			$rs = $model->table('income')->insert($insert_array);
			if($rs){
				showDialog('收款单添加成功！','index.php?act=order&op=income_list','succ');
			}else{
				showDialog('收款单添加失败');
			}
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('income_list');
		/**
		 * 模板输出
		 */
		Tpl::showpage('income_add');
	}
	/**
	 * 编辑收款单
	 */
	public function income_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 编辑收款记录
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["ci_money"],"require"=>"true","message"=>"请填写收款金额");
			$validate_arr[] = array("input"=>$_POST["ci_payback_time"],"require"=>"true","message"=>"请选择收款时间");
			$validate_arr[] = array("input"=>$_POST["ci_code"],"require"=>"true","message"=>"请填写收款单编号");
			$validate_arr[] = array("input"=>$_POST["ci_exchange_rate"],"require"=>"true","message"=>"请填写货币汇率");
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if(floatval(trim($_POST['ci_money'])) <= 0 || floatval(trim($_POST['ci_exchange_rate'])) <= 0){
				showDialog('收款金额和汇率必须为正数');
			}
			$update_array = array(
				'ci_code'=>trim($_POST['ci_code']),
				'ci_batch'=>trim($_POST['ci_batch']),
				'ci_money'=>trim($_POST['ci_money']),
				'ci_price_unit'=>intval($_POST['ci_price_unit']),
				'ci_exchange_rate'=>trim($_POST['ci_exchange_rate']),
				'ci_paymethod'=>intval($_POST['ci_paymethod']),
				'ci_payback_time'=>($t = strtotime(trim($_POST['ci_payback_time'])))>0?$t:0,
				'ci_bill'=>intval($_POST['ci_bill']),
				'ci_note'=>trim($_POST['ci_note']),
				'ci_addstaff'=>$_SESSION['member_id'],
				'ci_addtime'=>time()
			);

			$rs = $model->table('income')->where(array('ci_id'=>intval($_POST['ci_id'])))->update($update_array);
			if($rs){
				if(trim($_POST['from']) == 'finance'){
					showDialog('收款单编辑成功！','index.php?act=finance&op=payback_verify','succ');
				}else{
					showDialog('收款单编辑成功！','index.php?act=order&op=income_list','succ');
				}
			}else{
				showDialog('收款单编辑失败');
			}
		}
		/**
		 * 调取收款单数据
		 */
		$ci_id = intval($_GET['ci_id']);
		if($ci_id <= 0){
			showDialog('参数错误');
		}
		$ci_info = $model->field('income.*,customer.cc_name,customer.cc_id,orders.co_subject,orders.co_code')->table('income,orders,customer')->join('left')->on('income.co_id=orders.co_id,income.cc_id=customer.cc_id')->where(array('income.ci_id'=>$ci_id))->find();
		Tpl::output('ci_info',$ci_info);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from']) == 'finance'){
			$this->setleftmenu2('payback_verify');
		}else{
			$this->setleftmenu('income_list');
		}
		/**
		 * 模板输出
		 */
		Tpl::showpage('income_edit');
	}
	/**
	 * 查看收款单
	 */
	public function income_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取收款单数据
		 */
		$ci_id = intval($_GET['ci_id']);
		if($ci_id <= 0){
			showDialog('参数错误');
		}
		$ci_info = $model->field('income.*,customer.cc_name,customer.cc_id,orders.co_subject,orders.co_code,orders.co_staff_id,user.user_truename')->table('income,orders,customer,user')->join('left')->on('income.co_id=orders.co_id,income.cc_id=customer.cc_id,income.ci_addstaff=user.user_id')->where(array('income.ci_id'=>$ci_id))->find();
		if(empty($ci_info)){
			showDialog('无法找到该收款单信息','','exception','error',1,0);
		}
		/*判断当前用户是否有查看权限*/
		$right_array_f  = cDataPermission('finance');
		$right_array_co = cDataPermission('orders');
		$allpdp_id = $this->dp_array[$ci_info['dp_id']]['d_allparentid'];
		if($right_array_f['data'] == 'dp' && $right_array_co['data'] != 'dp'){
			if($ci_info['dp_id'] != $_SESSION['pdp_id'] && strpos($allpdp_id,','.$_SESSION['pdp_id'].',')===false){
				showMessage('您无权查看该收款单信息','','exception','error',1,0);
			}
		}else{
			if(($right_array_co['data'] == 'dp' && ($ci_info['dp_id'] != $_SESSION['dp_id'] && strpos($allpdp_id,','.$_SESSION['dp_id'].',')===false)) || ($right_array_co['data'] == 'own' && $ci_info['co_staff_id'] != $_SESSION['member_id'])){
				showMessage('您无权查看该收款单信息','','exception','error',1,0);
			}
		}
		/**
		 * 订单所属员工
		 */
		$user_array = ($t = F('user')) ? $t : H('user',true,'file');
		$ci_info['co_staff_name'] = $user_array[$ci_info['co_staff_id']]['user_truename'];
		Tpl::output('ci_info',$ci_info);
		/**
		 * 调取审核人员信息
		 */
		$verifyer_info = $model->field('user_truename')->table('user')->where(array('user_id'=>$ci_info['ci_excstaff']))->find();
		Tpl::output('verifyer_info',$verifyer_info);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from']) == 'finance'){
			$this->setleftmenu2('payback_verify');
		}else{
			$this->setleftmenu('income_list');
		}
		/**
		 * 模板输出
		 */
		Tpl::output('html_title','收款单详情');
		Tpl::showpage('income_view','windowopen_layout');
	}
	/**
	 * 删除收款单
	 */
	public function income_delOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		$ci_id = intval($_GET['ci_id']);
		if($ci_id <= 0){
			showDialog('参数错误');
		}
		$rs = $model->table('income')->where(array('ci_id'=>$ci_id))->delete();
		if($rs){
			showDialog('收款单删除成功！','index.php?act=order&op=income_list','succ');
		}else{
			showDialog('收款单删除失败');
		}
	}
	/**
	 * 退货列表
	 */
	public function return_listOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取退货单列表
		 */
		/*分析当前员工的权限范围*/
		$right_array = cDataPermission('orders');
		$where_condition = array();
		//部门范围
		if($right_array['data'] == 'dp'){
			$where_condition['orders.dp_id'] = array('in',$_SESSION['dp_id'].($this->dp_son!=''?",".$this->dp_son:''));
		}
		//个人范围
		if($right_array['data'] == 'own'){
			$where_condition['orders.co_staff_id'] = $_SESSION['member_id'];
		}
		//过滤器
		$filter = trim($_GET['filter']);
		switch ($filter){
			case '':
				$where_condition['returns.cr_del'] = 0;
				break;
			case 'no_return':
				$where_condition['returns.return_status'] = 0;
				$where_condition['returns.cr_del'] = 0;
				break;
			case 'returned':
				$where_condition['returns.return_status'] = 1;
				$where_condition['returns.cr_del'] = 0;
				break;
			case 'no_refund':
				$where_condition['returns.refund_status'] = 0;
				$where_condition['returns.cr_del'] = 0;
				break;
			case 'refunded':
				$where_condition['returns.refund_status'] = 1;
				$where_condition['returns.cr_del'] = 0;
				break;
			case 'trash':
				if (!cPermission('order','return_del')){
					showMessage('您不具备进行该操作的权利');
				}
				$where_condition['returns.cr_del'] = 1;
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'co_code':
					$where_condition['orders.co_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cc_name':
					$where_condition['customer.cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cr_code':
					$where_condition['returns.cr_code'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		$return_list = $model->field('returns.*,orders.co_code,customer.cc_name')->table('returns,orders,customer')->join('left')->on('returns.co_id=orders.co_id,customer.cc_id=returns.cc_id')->where($where_condition)->page(10)->order('returns.cr_addtime desc')->select();
		Tpl::output('return_list',$return_list);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('return_list');
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::showpage('return_list');
	}
	/**
	 * 新增退货单
	 */
	public function return_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 新增退货单
		 */
		if(chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["co_id"],"require"=>"true","message"=>"请选择订单");
			$validate_arr[] = array("input"=>$_POST["cr_total_price"],"require"=>"true","message"=>"请填写退款总额");
			$validate_arr[] = array("input"=>$_POST["currency_unit"],"require"=>"true","message"=>"请选择退款货币单位");
			$validate_arr[] = array("input"=>$_POST["exchange_rate"],"require"=>"true","message"=>"请填写退款汇率");
			$validate_arr[] = array("input"=>$_POST["cr_code"],"require"=>"true","message"=>"请填写退货单编号");
			$validate_arr[] = array("input"=>$_POST["wh_id"],"require"=>"true","message"=>"请选择退货仓库");
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			if(floatval($_POST["cr_total_price"]) <= 0 || floatval($_POST["exchange_rate"]) <= 0){
				showDialog('退款总额和汇率必须为正数');
			}
			//处理退货信息
			$cr_content = array();
			if(is_array($_POST['return_num']) && !empty($_POST['return_num'])){
				foreach ((array)$_POST['return_num'] as $k=>$v){
					if(intval($v)>0 && intval($v)<=intval($_POST['cop_given'][$k])){
						$cr_content[] = array(
							'cop_id'=>$_POST['cop_id'][$k],
							'cp_name'=>$_POST['cp_name'][$k],
							'cp_unit'=>$_POST['cp_unit'][$k],
							'cop_unitprice'=>$_POST['cop_unitprice'][$k],
							'p_num'=>$_POST['p_num'][$k],
							'cop_given'=>$_POST['cop_given'][$k],
							'return_num'=>$v
						);
					}else{
						showDialog('"'.$_POST['cp_name'][$k].'"的退货数量必须为正数并且不大于该商品的已发货数量');
					}
				}
			}
			if(empty($cr_content)){
				showDialog('没有任何退货商品,退货单无法建立');
			}
			$insert_array = array(
				'cr_code'=>trim($_POST['cr_code']),
				'co_id'=>intval($_POST['co_id']),
				'cc_id'=>intval($_POST['cc_id']),
				'cr_content'=>serialize($cr_content),
				'cr_total_price'=>trim($_POST['cr_total_price']),
				'currency_unit'=>intval($_POST['currency_unit']),
				'exchange_rate'=>trim($_POST['exchange_rate']),
				'cr_addstaff'=>$_SESSION['member_id'],
				'cr_addtime'=>time(),
				'cr_note'=>trim($_POST['cr_note']),
				'wh_id'=>intval($_POST['wh_id'])
			);
			$rs = $model->table('returns')->insert($insert_array);
			if($rs){
				showDialog('退货单添加成功！','index.php?act=order&op=return_list','succ');
			}else{
				showDialog('退货单添加失败');
			}
		}
		//调取仓库信息
		$wh_list = $model->field('wh_id,wh_name')->table('warehouse')->where(true)->select();
		Tpl::output('wh_list',$wh_list);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('return_list');
		/**
		 * 模板输出
		 */
		Tpl::showpage('return_add');
	}
	/**
	 * 编辑退货单
	 */
	public function return_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 编辑退货单
		 */
		if(chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cr_total_price"],"require"=>"true","message"=>"请填写退款总额");
			$validate_arr[] = array("input"=>$_POST["currency_unit"],"require"=>"true","message"=>"请选择退款货币单位");
			$validate_arr[] = array("input"=>$_POST["exchange_rate"],"require"=>"true","message"=>"请填写退款汇率");
			$validate_arr[] = array("input"=>$_POST["cr_code"],"require"=>"true","message"=>"请填写退货单编号");
			$validate_arr[] = array("input"=>$_POST["wh_id"],"require"=>"true","message"=>"请选择退货仓库");
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$cr_id = intval($_POST['cr_id']);
			if($cr_id <= 0){
				showDialog('参数错误');
			}
			//处理退货信息
			$cr_content = array();
			if(is_array($_POST['return_num']) && !empty($_POST['return_num'])){
				foreach ((array)$_POST['return_num'] as $k=>$v){
					if(intval($v)>0 && intval($v)<=intval($_POST['cop_given'][$k])){
						$cr_content[] = array(
							'cop_id'=>$_POST['cop_id'][$k],
							'cp_name'=>$_POST['cp_name'][$k],
							'cp_unit'=>$_POST['cp_unit'][$k],
							'cop_unitprice'=>$_POST['cop_unitprice'][$k],
							'p_num'=>$_POST['p_num'][$k],
							'cop_given'=>$_POST['cop_given'][$k],
							'return_num'=>$v
						);
					}else{
						showDialog('"'.$_POST['cp_name'][$k].'"的退货数量必须为正数并且不大于该商品的已发货数量');
					}
				}
			}
			if(empty($cr_content)){
				showDialog('没有任何退货商品,退货单无法建立');
			}
			$update_array = array(
				'cr_code'=>trim($_POST['cr_code']),
				'cr_content'=>serialize($cr_content),
				'cr_total_price'=>floatval(trim($_POST['cr_total_price'])),
				'currency_unit'=>intval($_POST['currency_unit']),
				'exchange_rate'=>trim($_POST['exchange_rate']),
				'cr_note'=>trim($_POST['cr_note']),
				'wh_id'=>intval($_POST['wh_id'])
			);
			$rs = $model->table('returns')->where(array('cr_id'=>$cr_id))->update($update_array);
			if($rs){
				showDialog('退货单编辑成功！','index.php?act=order&op=return_list','succ');
			}else{
				showDialog('退货单编辑失败');
			}
		}
		/**
		 * 调取退货单信息
		 */
		$cr_id = intval($_GET['cr_id']);
		if($cr_id <= 0){
			showDialog('参数错误');
		}
		$cr_info = $model->table('returns')->where(array('cr_id'=>$cr_id))->find();
		Tpl::output('cr_info',$cr_info);
		$co_info = $model->field('orders.*,customer.cc_name')->table('orders,customer')->join('left')->on('orders.cc_id=customer.cc_id')->where(array('orders.co_id'=>$cr_info['co_id']))->find();
		Tpl::output('co_info',$co_info);
		$cop_list = $model->table('order_product')->where(array('co_id'=>$cr_info['co_id']))->select();
		//处理订单商品数据
		$return_list = unserialize($cr_info['cr_content']);
		if(is_array($cop_list) && !empty($cop_list) && !empty($return_list)){
			foreach ((array)$cop_list as $k=>$v){
				foreach ((array)$return_list as $rk=>$rv){
					if($rv['cop_id'] == $v['cop_id']){
						$cop_list[$k]['cp_name'] = $rv['cp_name'];
						$cop_list[$k]['cp_unit'] = $rv['cp_unit'];
						$cop_list[$k]['return_num'] = $rv['return_num'];
						break;
					}
				}
			}
		}
		Tpl::output('cop_list',$cop_list);
		//调取仓库信息
		$wh_list = $model->field('wh_id,wh_name')->table('warehouse')->where(true)->select();
		Tpl::output('wh_list',$wh_list);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('return_list');
		/**
		 * 模板输出
		 */
		Tpl::showpage('return_edit');
	}
	/**
	 * 查看退货单
	 */
	public function return_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取退货单信息
		 */
		$cr_id = intval($_GET['cr_id']);
		if($cr_id <= 0){
			showDialog('参数错误','','exception','error',1,0);
		}
		$cr_info = $model->field('returns.*,user.user_truename,warehouse.wh_name')->table('returns,user,warehouse')->join('left')->on('returns.cr_addstaff=user.user_id,returns.wh_id=warehouse.wh_id')->where(array('returns.cr_id'=>$cr_id))->find();
		Tpl::output('cr_info',$cr_info);
		if(empty($cr_info)){
			showDialog('无法找到该退货单信息','','exception','error',1,0);
		}
		$co_info = $model->field('orders.*,customer.cc_name')->table('orders,customer')->join('left')->on('orders.cc_id=customer.cc_id')->where(array('orders.co_id'=>$cr_info['co_id']))->find();
		/*判断当前用户是否有查看权限*/
		if (!cPermission('warehouse','return_verify')){
			$right_array_f  = cDataPermission('finance');
			$right_array_co = cDataPermission('orders');
			$allpdp_id = $this->dp_array[$co_info['dp_id']]['d_allparentid'];
			if($right_array_f['data'] == 'dp' && $right_array_co['data'] != 'dp'){
				if($co_info['dp_id'] != $_SESSION['pdp_id'] && strpos($allpdp_id,','.$_SESSION['pdp_id'].',')===false){
					showMessage('您无权查看该退货单信息','','exception','error',1,0);
				}
			}else{
				if(($right_array_co['data'] == 'dp' && ($co_info['dp_id'] != $_SESSION['dp_id'] && strpos($allpdp_id,','.$_SESSION['dp_id'].',')===false)) || ($right_array_co['data'] == 'own' && $co_info['co_staff_id'] != $_SESSION['member_id'])){
					showMessage('您无权查看该退货单信息','','exception','error',1,0);
				}
			}
		}
		Tpl::output('co_info',$co_info);
		$return_list = unserialize($cr_info['cr_content']);
		Tpl::output('return_list',$return_list);
		/**
		 * 调取审核人信息
		 */
		$verifyer_id_array = array();
		if(!in_array($cr_info['return_excstaff'], $verifyer_id_array)){
			$verifyer_id_array[] = $cr_info['return_excstaff'];
		}
		if(!in_array($cr_info['refund_excstaff'], $verifyer_id_array)){
			$verifyer_id_array[] = $cr_info['refund_excstaff'];
		}
		$tmp_verifyer_info = $model->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',implode(',', $verifyer_id_array))))->select();
		$verifyer_info = array();
		if(!empty($tmp_verifyer_info)){
			foreach ($tmp_verifyer_info as $k=>$v){
				$verifyer_info[$v['user_id']] = $v['user_truename'];
			}
		}
		Tpl::output('verifyer_info',$verifyer_info);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from']) == 'finance'){
			$this->setleftmenu2('refund_verify');
		}elseif (trim($_GET['from']) == 'w'){
			$this->setleftmenu('return_verify');
		}else{
			$this->setleftmenu('return_list');
		}
		/**
		 * 模板输出
		 */
		Tpl::output('html_title','退货单详情');
		Tpl::showpage('return_view','windowopen_layout');
	}
	/**
	 * 删除退货单
	 */
	public function return_delOp(){
		$model = Model();
		if(trim($_GET['type'])=='batch'){
			$cr_id_string = trim($_GET['cr_id'],',');
			if($cr_id_string == ''){
				showDialog('参数错误');
			}
			$rs = $model->table('returns')->where(array('cr_id'=>array('in',$cr_id_string)))->update(array('cr_del'=>1));
		}else{
			$cr_id = intval($_GET['cr_id']);
			if($cr_id <= 0){
				showDialog('参数错误');
			}
			$rs = $model->table('returns')->where(array('cr_id'=>$cr_id))->update(array('cr_del'=>1));
		}
		if($rs){
			showDialog('退货单成功删除！','index.php?act=order&op=return_list','succ');
		}else{
			showDialog('退货单删除失败');
		}
	}
	/**
	 * 恢复删除的退货单
	 */
	public function return_returnOp(){
		$model = Model();
		$cr_id = intval($_GET['cr_id']);
		if($cr_id <= 0){
			showDialog('参数错误');
		}
		$rs = $model->table('returns')->where(array('cr_id'=>$cr_id))->update(array('cr_del'=>0));
		if($rs){
			showDialog('退货单成功恢复！','index.php?act=order&op=return_list','succ');
		}else{
			showDialog('退货单恢复失败');
		}
	}
	/**
	 * 退货审核
	 */
	public function return_verifyOp(){
		$model = Model();
		$cr_id = intval($_GET['cr_id']);
		if($cr_id <= 0){
			showDialog('参数错误');
		}
		$rs = $model->table('returns')->where(array('cr_id'=>$cr_id))->update(array('return_status'=>1));
		if($rs){
			showDialog('退货审核成功！','index.php?act=order&op=return_view&cr_id='.$cr_id,'succ');
		}else{
			showDialog('退货审核失败');
		}
	}
	/**
	 * 订单合并
	 */
	public function order_mergeOp(){
		if($_GET['auto'] == '') showDialog(Language::get('bp_order_parameter_error'));
		$model = Model();
		switch(intval($_GET['auto'])){
			//手动合并订单
			case 0:
				//验证
				$co_id_string = trim($_GET['co_id'],',');
				if($co_id_string == '') showDialog(Language::get('bp_order_please_select_orders_to_be_combined'));
				$order_list = $model->table('orders')->where(array('co_id'=>array('in',$co_id_string)))->order('co_addtime asc')->select();
				if(empty($order_list)){
					showDialog(Language::get('bp_order_the_selected_order_information_was_not_found'));
				}else{
					//作判断时需要的字段
					$address_id    = 0;
					$co_type       = 0;
					$co_self_field = '';
					$co_id         = 0;
					$co_paymethod  = 0;
					$express_delivery = 0;
					//更新订单时需要的字段
					$cc_id           = 0;
					$co_return_money = 0;
					$late_delivery_time = 0;
					$co_total_price = 0;
					$co_final_price = 0;
					$co_cost_price  = 0;
					$co_note = '';
					$cop_change_coid = '';
					foreach ((array)$order_list as $k=>$v){
						if($v['co_status'] != 0) showDialog(Language::get('bp_order_only_state_for_ongoing_orders_can_be_merged'));
						if($k==0){
							$co_id         = $v['co_id'];
							$cc_id         = $v['cc_id'];
							$address_id    = $v['address_id'];
							$co_type       = $v['co_type'];
							$co_self_field = $v['co_self_field'];
							$co_paymethod  = $v['co_paymethod'];
							$late_delivery_time = $v['late_delivery_time'];
							$express_delivery = $v['express_delivery'];
						}else{
							if($v['cc_id'] != $cc_id){
								showDialog(Language::get('bp_order_members_of_different_order_could_not_be_merged'));
							}
							if($v['address_id'] != $address_id){
								showDialog(Language::get('bp_order_receiving_information_of_different_order_could_not'));
							}
							if($v['co_type'] != $co_type){
								showDialog(Language::get('bp_order_order_type_different_order_could_not_be_merged'));
							}
							if($v['co_paymethod'] != $co_paymethod){
								showDialog(Language::get('bp_order_order_of_payment_cant_be_different_order_merge'));
							}
							if($v['express_delivery'] != $express_delivery){
								showDialog(Language::get('bp_order_different_logistics_companies_to_order_merge'));
							}
							if($v['late_delivery_time'] > $late_delivery_time){
								$late_delivery_time = $v['late_delivery_time'];
							}
							$cop_change_coid .= $v['co_id'].',';
						}
						$co_return_money += $v['co_return_money'];
						$co_total_price  += $v['co_total_price'];
						$co_final_price  += $v['co_final_price'];
						$co_cost_price   += $v['co_cost_price'];
						$co_note .= $v['co_note'].'；';
					}
					//进行订单合并操作
					$update_array = array();
					$update_array['co_return_money']    = $co_return_money;
					$update_array['co_total_price']     = $co_total_price;
					$update_array['co_final_price']     = $co_final_price;
					$update_array['co_cost_price']      = $co_cost_price;
					$update_array['late_delivery_time'] = $late_delivery_time;
					$update_array['co_note'] = trim($co_note,'；');
					$rs = $model->table('orders')->where(array('co_id'=>$co_id))->update($update_array);
					if($rs){
						//更新订单商品
						$rs_cop = $model->table('order_product')->where(array('co_id'=>array('in',trim($cop_change_coid,','))))->update(array('co_id'=>$co_id));
						//删除掉被合并掉的订单
						$rs_del = $model->table('orders')->where(array('co_id'=>array('in',trim($cop_change_coid,','))))->delete();
						if($rs_cop && $rs_del){
							showDialog(Language::get('bp_order_order_merger_success'),'index.php?act=order&op=order_list','succ');
						}else{
							showDialog(Language::get('bp_order_order_merger_failure'));
						}
					}else{
						showDialog(Language::get('bp_order_order_merger_failure'));
					}
				}
				break;
			//自动合并订单
			case 1:
				//调取员工所属店铺的订单资料并根据规则进行合并
				$where_condition = $_SESSION['shop_id']==0?true:array('shop_id'=>$_SESSION['shop_id']);
				$tmp_order_list = $model->table('orders')->where($where_condition)->order('co_addtime asc')->select();
				if(empty($tmp_order_list)){
					showDialog(Language::get('bp_order_did_not_find_the_need_to_deal_with_the_order'));
				}else{
					$order_list = array();
					$del_arr    = array();
					foreach ((array)$tmp_order_list as $k=>$v){
						if($v['co_status'] == 0 && !in_array($k, $del_arr)){
							$tmp_arr   = array();
							$tmp_arr[] = $v;
							foreach ((array)$tmp_order_list as $tk=>$tv){
								if($k!=$tk && $tv['shipment_id']=='' && $v['cc_id']==$tv['cc_id'] && $v['address_id']==$tv['address_id'] && $v['co_type']==$tv['co_type'] && $v['co_self_field']==$tv['co_self_field'] && $v['co_paymethod']==$tv['co_paymethod'] && $v['express_delivery']==$tv['express_delivery']){
									$tmp_arr[] = $tv;
									$del_arr[] = $tk;
								}
							}
							if(count($tmp_arr) >= 2){
								$order_list[] = $tmp_arr;
							}
							unset($tmp_arr);
						}
					}
					//进行合并操作
					if(empty($order_list)){
						showDialog(Language::get('bp_order_meet_terms_of_merger_that_order_was_not_found'));
					}else{
						$merge_failed_order = '';
						foreach ((array)$order_list as $val){
							//更新订单时需要的字段
							$cc_id              = 0;
							$co_code            = '';
							$co_return_money    = 0;
							$late_delivery_time = 0;
							$co_total_price     = 0;
							$co_final_price     = 0;
							$co_cost_price      = 0;
							$co_note            = '';
							$cop_change_coid    = '';
							foreach ($val as $k=>$v){
								if($k==0){
									$co_id         = $v['co_id'];
									$co_code       = $v['co_code'];
									$cc_id         = $v['cc_id'];
									$address_id    = $v['address_id'];
									$co_type       = $v['co_type'];
									$co_staff_id   = $v['co_staff_id'];
									$co_self_field = $v['co_self_field'];
									$co_paymethod  = $v['co_paymethod'];
									$late_delivery_time = $v['late_delivery_time'];
								}else{
									if($v['late_delivery_time'] > $late_delivery_time){
										$late_delivery_time = $v['late_delivery_time'];
									}
									$cop_change_coid .= $v['co_id'].',';
								}
								$co_return_money += $v['co_return_money'];
								$co_total_price  += $v['co_total_price'];
								$co_final_price  += $v['co_final_price'];
								$co_cost_price   += $v['co_cost_price'];
								$co_note .= $v['co_note'].'；';
							}
							//进行订单合并操作
							$update_array = array();
							$update_array['co_return_money']    = $co_return_money;
							$update_array['co_total_price']     = $co_total_price;
							$update_array['co_final_price']     = $co_final_price;
							$update_array['co_cost_price']      = $co_cost_price;
							$update_array['late_delivery_time'] = $late_delivery_time;
							$update_array['co_note'] = trim($co_note,'；');
							$rs = $model->table('orders')->where(array('co_id'=>$co_id))->update($update_array);
							if($rs){
								//更新订单商品
								$rs_cop = $model->table('order_product')->where(array('co_id'=>array('in',trim($cop_change_coid,','))))->update(array('co_id'=>$co_id));
								//删除掉被合并掉的订单
								$rs_del = $model->table('orders')->where(array('co_id'=>array('in',trim($cop_change_coid,','))))->delete();
							}else{
								$merge_failed_order .= $co_code.',';
							}
						}
						if($merge_failed_order == ''){
							showDialog(Language::get('bp_order_automerge_order_has_been_completed'),'index.php?act=order&op=order_list','succ');
						}else{
							showDialog(Language::get('bp_order_automerge_order_has_been_completed').Language::get('bp_comma').Language::get('bp_order_but_the_following_orders_merger_failure').Language::get('bp_colon').trim($merge_failed_order,','));
						}
					}
				}
				break;
		}
	}
	/**
	 * 订单审核
	 */
	public function order_verify_singleOp(){
		$model = Model();
		if(trim($_GET['exc']) == 'ok'){
			$co_id = intval($_GET['co_id']);
			if($co_id <= 0){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_parameter_error')));die;
			}
			if(intval($_GET['order_verify_status']) == 1 && intval($_GET['express_delivery']) == 0){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_approved_orders_must_choose_courier_company')));die;
			}
			$update_array = array(
				'co_check'=>intval($_GET['order_verify_status']),
				'co_checkrp'=>trim($_GET['order_verify_note']),
				'express_delivery'=>intval($_GET['express_delivery']),
				'co_staff_id'=>intval($_GET['user_id'])
			);
			$rs = $model->table('orders')->where(array('co_id'=>$co_id))->update($update_array);
			if($rs){
				//插入订单日志
				$insert_colog = array(
					'co_id'=>$co_id,
					'col_staff'=>$_SESSION['member_id'],
					'col_time'=>time(),
					'col_content'=>Language::get('bp_order_to_complete_the_order_review').Language::get('bp_comma').Language::get('bp_order_as_the_results_of_audit').Language::get('bp_colon').'"'.(intval($_GET['order_verify_status'])==1?Language::get('bp_order_approved').Language::get('bp_comma').'"':Language::get('bp_order_abnormal').'"')
				);
				$model->table('order_log')->insert($insert_colog);
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false));die;
			}
		}
		/**
		 * 调取员工列表
		 */
		$user_array = ($t = F('user')) ? $t : H('user',true,'file');
		if($_SESSION['shop_id'] > 0){
			$user_list = array();
			if(!empty($user_array)){
				foreach ($user_array as $k=>$v){
					if($v['user_shopid'] == $_SESSION['shop_id']){
						$user_list[] = $v;
					}
				}
			}
			Tpl::output('user_list',$user_list);
		}else{
			Tpl::output('user_list',$user_array);
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('co_id',intval($_GET['co_id']));
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('order_verify_single','null_layout');
	}
	/**
	 * 完成发货（如果来源于店铺则会进行同步）
	 */
	public function shipment_confirmOp(){
		$model = Model();
		if(trim($_GET['exc']) == 'ok'){
			$co_id = intval($_GET['co_id']);
			if($co_id <= 0){
				echo json_encode(array('done'=>false,'msg'=>Language::get('wrong_argument')));die;
			}
			$co_info = $model->field('shop_id,co_code,co_status')->table('orders')->where(array('co_id'=>$co_id))->find();
			if($co_info['shop_id'] > 0){
				$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
				$shop_info = $shop_list[$co_info['shop_id']];
				$platinfo  = unserialize($shop_info['shop_platinfo']);
				switch ($shop_info['shop_platform']){
					case 1://ShopNC商城体系
						$sid = $platinfo['shopnc_sid'];
						$api_url = $platinfo['shopnc_apiurl'];
						$signkey = $platinfo['shopnc_sk'];
						$auth_string = 'commend=state&type=order&sp='.$co_info['co_code'].'&value=30&sid='.$sid;
						$key = rawurlencode(authcode($auth_string,$signkey,''));
						$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
						$opts = array(
						  'http'=>array(
						    'method'=>"GET",
						    'timeout'=>60,
						   )
						);
						$context   = stream_context_create($opts);
						$json_data = file_get_contents($final_url,false,$context);
						if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_shipment_info_sync_failed')));die; }
						$data = json_decode($json_data,true);
						if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 0){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_shipment_info_sync_failed')));die; }
						break;
					case 2://淘宝
						require(BasePath.'/framework/function/top.php');
						$tc = new TopClient();
						$tc->appKey    = '21513519';
						$tc->appSecret = '2bfcbf47bed3fafd4ffbb51ca04af002';
						$param['method'] = 'taobao.logistics.online.confirm';
						$param['session'] = $platinfo['session'];
						$param['tid'] = $co_info['co_code'];
						$param['out_sid'] = trim($_GET['express_code']);
						$result_arr = $tc->reqdata($param);
						if(!is_array($result_arr) || !empty($result_arr['error_response'])){
							if($result_arr['error_response']['msg'] == 'Invalid session:session-expired'){
								//处理session过期
								$model->table('shop')->where(array('shop_id'=>intval($_GET['shop_id'])))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
								echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_taobao_the_session_expires').Language::get('bp_comma').Language::get('bp_order_please_bind_again')));die;
							}
							echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_shipment_info_sync_failed')));die;
						}
						break;
					case 3://ShopEx单店
						$api_url = $platinfo['shopex_apiurl'];
						$inquire_str = 'command=orderedit&order_id='.$co_info['co_code'].'&status=shipment';
						$final_url = $api_url.'/index.php?'.$inquire_str;
						$opts = array(
						  'http'=>array(
						    'method'=>"GET",
						    'timeout'=>60,
						   )
						);
						$context   = stream_context_create($opts);
						$json_data = file_get_contents($final_url,false,$context);
						if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_shipment_info_sync_failed')));die; }
						$data = json_decode($json_data,true);
						if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 'failed'){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_shipment_info_sync_failed')));die; }
						break;
				}
			}
			//更新本地订单状态和物流单号
			if($model->table('orders')->where(array('co_id'=>$co_id))->update(array('express_code'=>trim($_GET['express_code']),'co_status'=>2))){
				//添加订单日志
				$insert_colog = array(
					'co_id'=>$co_id,
					'col_staff'=>$_SESSION['member_id'],
					'col_time'=>time(),
					'col_content'=>Language::get('bp_order_finish_order_shipment_op')
				);
				$model->table('order_log')->insert($insert_colog);
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_shipment_op_failed')));die;
			}
		}
		/**
		 * 模板输出
		 */
		Tpl::output('co_id',intval($_GET['co_id']));
		Tpl::showpage('order_shipment_confirm','null_layout');
	}
	/**
	 * 关闭交易（如何来源于店铺则会进行同步）
	 */
	public function close_tradeOp(){
		$model = Model();
		if(trim($_GET['exc']) == 'ok'){
			$co_id = intval($_GET['co_id']);
			if($co_id <= 0){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_parameter_error')));die;
			}
			$co_info = $model->field('shop_id,co_code,co_status')->table('orders')->where(array('co_id'=>$co_id))->find();
			if($co_info['shop_id'] > 0){
				$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
				$shop_info = $shop_list[$co_info['shop_id']];
				$platinfo  = unserialize($shop_info['shop_platinfo']);
				switch ($shop_info['shop_platform']){
					case 1://ShopNC商城体系
						$sid = $platinfo['shopnc_sid'];
						$api_url = $platinfo['shopnc_apiurl'];
						$signkey = $platinfo['shopnc_sk'];
						$auth_string = 'commend=state&type=order&sp='.$co_info['co_code'].'&value=0&sid='.$sid;
						$key = rawurlencode(authcode($auth_string,$signkey,''));
						$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
						$opts = array(
						  'http'=>array(
						    'method'=>"GET",
						    'timeout'=>60,
						   )
						);
						$context   = stream_context_create($opts);
						$json_data = file_get_contents($final_url,false,$context);
						if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_close_the_deal_information_synchronization_failure')));die; }
						$data = json_decode($json_data,true);
						if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 0){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_close_the_deal_information_synchronization_failure')));die; }
						break;
					case 2://淘宝
						require(BasePath.'/framework/function/top.php');
						$tc = new TopClient();
						$tc->appKey    = '21513519';
						$tc->appSecret = '2bfcbf47bed3fafd4ffbb51ca04af002';
						$param['method'] = 'taobao.trade.close';
						$param['session'] = $platinfo['session'];
						$param['tid'] = $co_info['co_code'];
						$param['close_reason'] = trim($_GET['close_reason']);
						$result_arr = $tc->reqdata($param);
						if(!is_array($result_arr) || !empty($result_arr['error_response'])){
							if($result_arr['error_response']['msg'] == 'Invalid session:session-expired'){
								//处理session过期
								$model->table('shop')->where(array('shop_id'=>intval($_GET['shop_id'])))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
								echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_taobao_the_session_expires').Language::get('bp_comma').Language::get('bp_order_please_bind_again')));die;
							}
							echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_close_the_deal_information_synchronization_failure')));die;
						}
						break;
					case 3://ShopEx单店
						$api_url = $platinfo['shopex_apiurl'];
						$inquire_str = 'command=orderedit&order_id='.$co_info['co_code'].'&status=dead';
						$final_url = $api_url.'/index.php?'.$inquire_str;
						$opts = array(
						  'http'=>array(
						    'method'=>"GET",
						    'timeout'=>60,
						   )
						);
						$context   = stream_context_create($opts);
						$json_data = file_get_contents($final_url,false,$context);
						if($json_data === false){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_close_the_deal_information_synchronization_failure')));die; }
						$data = json_decode($json_data,true);
						if($data['code'] == '404' || $data['code'] == '500' || $data['datas'] == 'failed'){ echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_close_the_deal_information_synchronization_failure')));die; }
						break;
				}
			}
			//更新本地订单状态
			if($model->table('orders')->where(array('co_id'=>$co_id))->update(array('co_status'=>3))){
				//添加订单日志
				$insert_colog = array(
					'co_id'=>$co_id,
					'col_staff'=>$_SESSION['member_id'],
					'col_time'=>time(),
					'col_content'=>Language::get('bp_order_the_order_was_closed_deal')
				);
				$model->table('order_log')->insert($insert_colog);
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_close_the_deal_fails')));die;
			}
		}
		/**
		 * 模板输出
		 */
		Tpl::output('co_id',intval($_GET['co_id']));
		Tpl::showpage('close_trade','null_layout');
	}
	/**
	 * 拆单操作
	 */
	public function order_splitOp(){
		$model = Model();
		if(trim($_GET['exc']) == 'ok'){
			$co_id = intval($_GET['co_id']);
			if($co_id <= 0){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_parameter_error')));die;
			}
			//检验
			$choose_pnum = count(explode(',', trim($_GET['choose_cop'],',')));
			if($choose_pnum == intval($_GET['ori_pnum'])){
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_the_selected_commodity_quantity_must_be_smaller')));die;
			}
			//调取原订单数据
			$co_info = $model->table('orders')->where(array('co_id'=>$co_id))->find();
			$insert_array = array(
				'cc_id'=>$co_info['cc_id'],
				'co_staff_id'=>$co_info['co_staff_id'],
				'dp_id'=>$co_info['dp_id'],
				'co_code'=>$co_info['co_code'],
				'co_type'=>$co_info['co_type'],
				'co_paymethod'=>$co_info['co_paymethod'],
				'co_addtime'=>$co_info['co_addtime'],
				'late_delivery_time'=>$co_info['late_delivery_time'],
				'address_id'=>$co_info['late_delivery_time'],
				'co_total_price'=>$co_info['co_total_price'],
				'co_final_price'=>$co_info['co_final_price'],
				'co_cost_price'=>$co_info['co_cost_price'],
				'co_note'=>$co_info['co_note'],
				'co_self_field'=>$co_info['co_self_field'],
				'shop_id'=>$co_info['shop_id'],
				'co_malloid'=>$co_info['co_malloid'],
				'co_buyermsg'=>$co_info['co_buyermsg'],
				'co_sellermemo'=>$co_info['co_sellermemo'],
				'co_subject'=>$co_info['co_subject'],
				'co_paytime'=>$co_info['co_paytime']
			);
			$new_coid = $model->table('orders')->insert($insert_array);
			$rs = $model->table('order_product')->where(array('cop_id'=>array('in',trim($_GET['choose_cop'],','))))->update(array('co_id'=>$new_coid));
			if($rs){
				echo json_encode(array('done'=>true));die;
			}else{
				echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_split_the_order_failed')));die;
			}
		}
		//调取订单信息
		$co_info = $model->field('orders.co_id,orders.co_code,customer.cc_name,shop.shop_name')->table('orders,customer,shop')->join('left')->on('orders.cc_id=customer.cc_id,orders.shop_id=shop.shop_id')->where(array('orders.co_id'=>intval($_GET['co_id'])))->find();
		//调取订单商品信息
		$cop_list = $model->field('order_product.cop_id,order_product.cop_unitprice,order_product.cop_pnum,product.cp_name,product.cp_code')->table('order_product,product')->join('left')->on('order_product.cp_id=product.cp_id')->where(array('order_product.co_id'=>intval($_GET['co_id'])))->select();
		/**
		 * 模板输出
		 */
		Tpl::output('co_info',$co_info);
		Tpl::output('cop_list',$cop_list);
		Tpl::showpage('order_split','null_layout');
	}
	/**
	 * 手动完成订单交易
	 */
	public function finish_orderOp(){
		$model = Model();
		$co_id = intval($_GET['co_id']);
		if($co_id <= 0){
			echo json_encode(array('done'=>false,'msg'=>Language::get('bp_order_parameter_error')));die;
		}
		if($model->table('orders')->where(array('co_id'=>$co_id))->update(array('co_status'=>1))){
			//插入订单日志
			$insert_colog = array(
				'co_id'=>$co_id,
				'col_staff'=>$_SESSION['member_id'],
				'col_time'=>time(),
				'col_content'=>Language::get('bp_order_order_status_change_for').'"'.Language::get('bp_order_transaction_completed').'"'
			);
			$model->table('order_log')->insert($insert_colog);
			showDialog(Language::get('bp_order_order_status_changes_to_success'),'index.php?act=order&op=order_list','succ');
		}else{
			showDialog(Language::get('bp_order_order_status_change_failed'));
		}
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_order_to_place_an_order_for'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'order_list','menu_name'=>Language::get('bp_order_the_order_management'),'menu_act'=>'order','menu_op'=>'order_list');
		$arr[0]['submenu'][1] = array('menu_key'=>'order_log','menu_name'=>Language::get('bp_order_the_order_log'),'menu_act'=>'order','menu_op'=>'order_log');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
	/**
	 * 设置左菜单（财务）
	 */
	private function setleftmenu2($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_order_financial'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'payback_verify','menu_name'=>Language::get('bp_order_credit_review'),'menu_act'=>'finance','menu_op'=>'payback_verify');
		$arr[0]['submenu'][1] = array('menu_key'=>'refund_verify','menu_name'=>Language::get('bp_order_refund_to_review'),'menu_act'=>'finance','menu_op'=>'refund_verify');
		$arr[0]['submenu'][2] = array('menu_key'=>'refund_list','menu_name'=>Language::get('bp_order_refund_the_log'),'menu_act'=>'finance','menu_op'=>'refund_list');
		$arr[0]['submenu'][3] = array('menu_key'=>'bill_list','menu_name'=>Language::get('bp_order_instrument_management'),'menu_act'=>'finance','menu_op'=>'bill_list');
		$arr[0]['submenu'][4] = array('menu_key'=>'finance_note_list','menu_name'=>Language::get('bp_order_balance_of_the_log'),'menu_act'=>'finance','menu_op'=>'finance_note_list');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}