<?php
/**
 * 公告页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class noticeControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('notice,department');
    }

	/**
	 * 公告列表
	 */
	public function noticelistOp(){
		$s_where = "";
		if (!empty($_GET['search_content'])){
			$s_where .= " and (ntt_title like '%{$_GET['search_content']}%' or ntt_content like '%{$_GET['search_content']}%') ";
		}
		if (!empty($_GET['search_state'])){
			switch ($_GET['search_state']){
				case 1:
					$s_where .= " and (ntread_state IS NULL) ";
					break;
				case 2:
					$s_where .= " and (ntread_state = 1) ";
					break;
			}
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if($stime > 0){
			$s_where .= " and (ntt_sendtime > $stime) ";
		}
		if($etime>0){
			$s_where .= " and (ntt_sendtime < $etime) ";
		}
		$model = Model();
		$on = "noticetext.ntt_id=notice.nt_nttid,noticetext.ntt_id=noticeread.ntread_nttid and noticeread.ntread_uid ={$_SESSION['member_id']}";
		$table = 'noticetext,notice,noticeread';
		$where = " (nt_rectype =2 OR (nt_rectype =0 AND nt_recid ={$_SESSION['member_id']}) OR ( nt_rectype =1 AND nt_recid ={$_SESSION['dp_id']})) ";
		$where .= " and (ntread_state = 1 or ntread_state is null) ";
		if ($s_where){
			$where .= $s_where;
		}
		$notice_list = $model->table($table)->field('ntt_id,ntt_title,ntread_state,ntt_sendtime,ntt_senduname')->join('left,left')->on($on)->where($where)->order('ntt_istop desc,ntt_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('notice_list',$notice_list);
		//左侧菜单
		$this->setleftmenu('noticelist');
		Tpl::showpage('noticelist');
	}
	/**
	 * 查看公告
	 */
	public function noticeinfoOp(){
		$id = intval($_GET['id']);
		if ($id<=0){
			showMessage(Language::get('bp_notice_parameter_error'),'','exception','error',1,0);
		}
		$model = Model();
		$on = "noticetext.ntt_id=notice.nt_nttid,noticetext.ntt_id=noticeread.ntread_nttid and noticeread.ntread_uid ={$_SESSION['member_id']}";
		$table = 'noticetext,notice,noticeread';
		$where = " ntt_id = $id ";
		$where .= " and (nt_rectype =2 OR (nt_rectype =0 AND nt_recid ={$_SESSION['member_id']}) OR ( nt_rectype =1 AND nt_recid ={$_SESSION['dp_id']})) ";
		$where .= " and (ntread_state = 1 or ntread_state is null) ";
		$notice_info = $model->table($table)->join('left,left')->on($on)->where($where)->find();
		if (empty($notice_info)){
			showMessage(Language::get('bp_notice_wrong_information'),'','exception','error',1,0);
		}
		if (!empty($notice_info) && ($notice_info['ntread_state'] != 1)){//已读记录不存在
			//添加已读记录
			$insert_arr = array();
			$insert_arr['ntread_uid'] = $_SESSION['member_id'];
			$insert_arr['ntread_nttid'] = $notice_info['ntt_id'];
			$insert_arr['ntread_state'] = 1;
			$model->table('noticeread')->insert($insert_arr);
		}
		$notice_info['ntt_content'] = htmlspecialchars_decode($notice_info['ntt_content']);
		Tpl::output('notice_info',$notice_info);
		Tpl::showpage('noticeinfo','windowopen_layout');
	}
	/**
	 * 隐藏接收的公告
	 */
	public function noticehideOp(){
		$nid = $_GET['nid'];
		if (empty($nid)){
			$nid = $_POST['nid'];
		}
		if (empty($nid)){
			showDialog(Language::get('bp_notice_parameter_error'),'','error');
		}
		$model = Model();
		$on = "noticetext.ntt_id=noticeread.ntread_nttid and noticeread.ntread_uid ={$_SESSION['member_id']}";
		$table = 'noticetext,noticeread';
		$where = '';
		if (is_array($nid)){
			$nid = implode(',',$nid);
			$where .=" ntt_id in($nid)";
		}else {
			$where .=" ntt_id = $nid ";
		}
		$where .= " and (ntread_state = 1 or ntread_state is null) ";
		$notice_list = $model->table($table)->join('left')->on($on)->where($where)->select();

		//处理记录将已读和未读分开
		if (!empty($notice_list)){
			$insert_arr = array();
			$update_arr = array();
			foreach ((array)$notice_list as $k=>$v){
				if (!empty($v['ntread_id'])){//记录已存在
					$update_arr[] = $v['ntread_id'];
				}else {
					$insert_arr[] = array('ntread_uid'=>$_SESSION['member_id'],'ntread_nttid'=>$v['ntt_id'],'ntread_state'=>'2');
				}
			}
			if (!empty($insert_arr)){
				$model->table('noticeread')->insertAll($insert_arr);
			}
			if (!empty($update_arr)){
				$model->table('noticeread')->where(array('ntread_id'=>array('in',$update_arr)))->update(array('ntread_state'=>2));
			}
			showDialog(Language::get('bp_notice_delete_the_success'),'index.php?act=notice&op=noticelist','succ');
		}else {
			showDialog(Language::get('bp_notice_delete_failed'),'index.php?act=notice&op=noticelist','error');
		}
	}
	/**
	 * 公告发布(包括发布人的所有操作)
	 */
	public function noticepublishOp(){
		if (!empty($_GET['type'])){
			$funname = "publish".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//发布的公告列表
			$this->publishlist();
		}
	}
	/**
	 * 已发布公告列表
	 */
	private function publishlist(){
		$where = array();
		$where['ntt_sendstate'] = 0;
		$where['ntt_senduid'] = $_SESSION['member_id'];
		if (!empty($_GET['search_content'])){
			$where['ntt_title|ntt_content'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime >0 && $etime > 0){
			$where['ntt_sendtime'] = array(array('gt',$stime),array('lt',$etime),'and');
		}elseif ($stime > 0) {
			$where['ntt_sendtime'] = array(array('gt',$stime));
		}elseif ($etime > 0) {
			$where['ntt_sendtime'] = array(array('lt',$etime));
		}
		$model = Model();
		$notice_list = $model->table('noticetext')->where($where)->order('ntt_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('notice_list',$notice_list);
		//左侧菜单
		$this->setleftmenu('noticepublish');
		Tpl::showpage('noticepublishlist');
	}
	/**
	 * 新增公告
	 */
	private function publishadd(){
		$model = Model('department');
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["n_title"],"require"=>"true","message"=>Language::get('bp_notice_please_add_a_title'));
			$validate_arr[] = array("input"=>$_POST["n_content"],"require"=>"true","message"=>Language::get('bp_notice_please_add_the_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//判断接收方不能为空
			if ($_POST['n_rectype'] == 2 && empty($_POST['choosedep'])){//部门接收
				showDialog(Language::get('bp_notice_please_select_a_recipient_information'),'','error');
			}elseif ($_POST['n_rectype'] == 1 && empty($_POST['chooseuser'])){//员工接收
				showDialog(Language::get('bp_notice_please_select_a_recipient_information'),'','error');
			}
			//添加公告内容表
			$ntext_insert_arr = array();
			$ntext_insert_arr['ntt_title'] = $_POST['n_title'];
			$ntext_insert_arr['ntt_content'] = $_POST['n_content'];
			$ntext_insert_arr['ntt_senduid'] = $_SESSION['member_id'];
			$ntext_insert_arr['ntt_senduname'] = $_SESSION['truename'];
			$ntext_insert_arr['ntt_istop'] = $_POST['istop']==1?1:0;
			$ntext_insert_arr['ntt_sendtime'] = time();
			$ntext_insert_arr['ntt_sendstate'] = 0;
			$ntext_insert_arr['ntt_rectype'] = ($t = intval($_POST['n_rectype'])-1)>0?$t:0;
			$rs = $model->table('noticetext')->insert($ntext_insert_arr);
			if ($rs){
				//添加公告接收表记录
				$n_insert_arr = array();
				if ($_POST['n_rectype'] == 2){//部门接收
					foreach ((array)$_POST['choosedep'] as $k=>$v){
						$tmp_insert = array();
						$tmp_insert['nt_recid'] = $v;
						$tmp_insert['nt_recname'] = $_POST['choosedepname'][$k];
						$tmp_insert['nt_rectype'] = 1;
						$tmp_insert['nt_nttid'] = $rs;
						$n_insert_arr[] = $tmp_insert;
					}
				}
				if ($_POST['n_rectype'] == 1){//员工接收
					foreach ((array)$_POST['chooseuser'] as $k=>$v){
						$tmp_insert = array();
						$tmp_insert['nt_recid'] = $v;
						$tmp_insert['nt_recname'] = $_POST['chooseusername'][$k];
						$tmp_insert['nt_rectype'] = 0;
						$tmp_insert['nt_nttid'] = $rs;
						$n_insert_arr[] = $tmp_insert;
					}
				}
				if ($_POST['n_rectype'] == 3){//全体人员接收
					$tmp_insert = array();
					$tmp_insert['nt_recid'] = 0;
					$tmp_insert['nt_recname'] = '';
					$tmp_insert['nt_rectype'] = 2;
					$tmp_insert['nt_nttid'] = $rs;
					$n_insert_arr[] = $tmp_insert;
				}
				$model->table('notice')->insertAll($n_insert_arr);
				showDialog(Language::get('bp_notice_announcement_of_new_success'),'index.php?act=notice&op=noticepublish','succ');
			}else {
				showDialog(Language::get('bp_notice_announcement_of_new_failure'),'','error');
			}
		}else{
			$rectype_arr = array(3=>Language::get('bp_notice_all_the_staff'),2=>Language::get('bp_notice_specify_the_department'),1=>Language::get('bp_notice_designated_employees'));
			Tpl::output('rectype_arr',$rectype_arr);
			//调取部门信息
			$model = Model('department');
			$dlist = $model->getDepartmentCacheTree();
			Tpl::output('dlist',$dlist);
			//左侧菜单
			$this->setleftmenu('noticepublish');
			Tpl::showpage('noticeadd');
		}
	}
	/**
	 * 编辑公告
	 */
	private function publishedit(){
		$model = Model('department');
		$nid = $_GET['nid'];
		if (empty($nid)){
			$nid = $_POST['nid'];
		}
		if (empty($nid)){
			showDialog(Language::get('bp_notice_parameter_error'),'','error');
		}
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["n_title"],"require"=>"true","message"=>Language::get('bp_notice_please_add_a_title'));
			$validate_arr[] = array("input"=>$_POST["n_content"],"require"=>"true","message"=>Language::get('bp_notice_please_add_the_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['ntt_title'] = $_POST['n_title'];
			$update_arr['ntt_content'] = $_POST['n_content'];
			$update_arr['ntt_istop'] = $_POST['istop']==1?1:0;
			$rs = $model->table('noticetext')->where(array('ntt_id'=>$nid,'ntt_senduid'=>$_SESSION['member_id']))->update($update_arr);
			if ($rs){
				showDialog(Language::get('bp_notice_bulletin_editorial_success'),'index.php?act=notice&op=noticepublish','succ');
			}else {
				showDialog(Language::get('bp_notice_bulletin_editing_failed'),'','error');
			}
		}else{
			//查询公告详细
			$ntt_info = $model->table('noticetext')->where(array('ntt_id'=>$nid,'ntt_senduid'=>$_SESSION['member_id']))->find();
			if (empty($ntt_info)){
				showDialog(Language::get('bp_notice_wrong_information'),'','error');
			}
			//查询接收信息
			$nt_list = $model->table('notice')->where(array('nt_nttid'=>$ntt_info['ntt_id']))->select();
			if (empty($nt_list)){
				showDialog(Language::get('bp_notice_wrong_information'),'','error');
			}
			if ($ntt_info['ntt_rectype'] == 1){
				foreach ((array)$nt_list as $k=>$v){
					$ntt_info['checkdid'][] = $v['nt_recid'];
				}
				if (!empty($ntt_info['checkdid'])){
					$ntt_info['checkdid'] = implode(',',$ntt_info['checkdid']);
				}
			}
			Tpl::output('ntt_info',$ntt_info);
			Tpl::output('nt_list',$nt_list);
			//调取部门信息
			$model = Model('department');
			$dlist = $model->getDepartmentCacheTree(false,$ntt_info['checkdid']);
			Tpl::output('dlist',$dlist);
			//左侧菜单
			$this->setleftmenu('noticepublish');
			Tpl::showpage('noticeedit');
		}
	}
	/**
	 * 发布人隐藏信息
	 */
	private function publishhide(){
		$nid = $_GET['nid'];
		if (empty($nid)){
			$nid = $_POST['nid'];
		}
		if (empty($nid)){
			showDialog(Language::get('bp_notice_parameter_error'),'','error');
		}
		$model = Model();
		$where = array();
		if (is_array($nid)){
			$where['ntt_id']= array('in',$nid);
		}else {
			$where['ntt_id']= $nid;
		}
		$where['ntt_senduid']= $_SESSION['member_id'];
		$rs = $model->table('noticetext')->where($where)->update(array('ntt_sendstate'=>'1'));
		if ($rs){
			showDialog(Language::get('bp_notice_delete_the_success'),'index.php?act=notice&op=noticepublish','succ');
		}else {
			showDialog(Language::get('bp_notice_delete_failed'),'index.php?act=notice&op=noticepublish','error');
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_notice_announcement_of_the_management'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'noticelist','menu_name'=>Language::get('bp_notice_receive_the_notice'),'menu_act'=>'notice','menu_op'=>'noticelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'noticepublish','menu_name'=>Language::get('bp_notice_has_announced'),'menu_act'=>'notice','menu_op'=>'noticepublish','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}