<?php
/**
 * 记事本管理页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class notepadControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('notepad');
    }

	/**
	 * 记事本列表
	 */
	public function notepadlistOp(){
		//一般列表
		$model = Model();
		$where['np_userid'] = $_SESSION['member_id'];
		if (!empty($_GET['search_content'])){
			$where['np_title|np_content'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		if (!empty($_GET['search_cname'])){
			$where['np_customername'] = array('like',"%{$_GET['search_cname']}%");
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['np_executetime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['np_executetime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['np_executetime'] = array('elt',"$etime");
		}
		$np_list = $model->table('notepad')->where($where)->order('np_state asc,np_id desc')->page(10)->select();
		$this->setleftmenu('notepadlist');
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('np_list',$np_list);
		Tpl::showpage('notepadlist');
	}
	/**
	 * 添加记事本
	 */
	public function notepadaddOp(){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["np_title"],"require"=>"true","message"=>Language::get('bp_notepad_please_add_a_title'));
			$validate_arr[] = array("input"=>$_POST["np_content"], "require"=>'true',"message"=>Language::get('bp_notepad_please_add_the_content'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_arr = array();
			$insert_arr['np_title'] = $_POST['np_title'];
			if (intval($_POST['np_cid'])>0){
				$insert_arr['np_customerid'] = $_POST['np_cid'];
				$insert_arr['np_customername'] = $_POST['np_cname'];
			}else{
				$insert_arr['np_customerid'] = 0;
				$insert_arr['np_customername'] = '';
			}
			$insert_arr['np_executetime'] = ($t = strtotime($_POST['np_time'].' '.$_POST['done_time']))>0?$t:0;
			//计算提醒时间
			if (intval($_POST['np_remindtime'])>0){
				$insert_arr['np_remindtime'] = $insert_arr['np_executetime'] - intval($_POST['np_remindtime'])*3600*24;
			}
			$insert_arr['np_content'] = $_POST['np_content'];
			$insert_arr['np_userid'] = $_SESSION['member_id'];
			$insert_arr['np_username'] = $_SESSION['truename'];
			$insert_arr['np_addtime'] = time();
			$insert_arr['np_state'] = $_POST['np_state'];
			//处理上传附件部分
			$attachment_id = array();
			foreach ((array)$_POST['att_num'] as $k=>$v){
				if($_POST['file_rs_'.$v] != ''){
					$tmp_file_info = explode(',', $_POST['file_rs_'.$v]);
					$att_id = $model->table('attachment')->insert(array('ca_name'=>$tmp_file_info[0],'ca_size'=>$tmp_file_info[1],'ca_type'=>$tmp_file_info[2],'ca_model'=>'notepad','ca_addstaff'=>$_SESSION['member_id'],'ca_addtime'=>time(),'ca_note'=>$tmp_file_info[3]));
					if($att_id != false){
						$attachment_id[] = $att_id;
					}
					unset($tmp_file_info);
					unset($att_id);
				}
			}
			$insert_arr['np_attachment'] = empty($attachment_id)?'':implode(',',$attachment_id);
			$rs = $model->table('notepad')->insert($insert_arr);
			$url = 'index.php?act=notepad&op=notepadlist';
			if ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_arr['np_customerid'];
			}
			if ($rs){
				showDialog(Language::get('bp_notepad_new_success'),$url,'succ');
			}else {
				showDialog(Language::get('bp_notepad_new_failure'),'','error');
			}
		}else {
			//如果来自会员详情页面则调取该会员信息
			if(intval($_GET['cc_id']) > 0){
				$cc_id = intval($_GET['cc_id']);
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$cc_id,'cc_isdel'=>0))->find();
				if(empty($cc_info)){
					showMessage(Language::get('bp_notepad_cant_find_the_member_information'));
				}else{
					Tpl::output('cc_info',$cc_info);
				}
			}
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}
			$this->setleftmenu('notepadlist');
			Tpl::output('source',$source);
			Tpl::showpage('notepadadd');
		}
	}
	/**
	 * 编辑记事本
	 */
	public function notepadeditOp(){
		if (!empty($_GET['type'])){
			$funname = "edit".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$npid = intval($_GET['npid']);
			if ($npid<=0){
				$npid = intval($_POST['npid']);
			}
			if ($npid<=0){
				showDialog(Language::get('bp_notepad_parameter_error'),'','error');
			}
			$model = Model();
			if (chksubmit()){
				$obj_validate = new Validate();
				$validate_arr[] = array("input"=>$_POST["np_title"],"require"=>"true","message"=>Language::get('bp_notepad_please_add_a_title'));
				$validate_arr[] = array("input"=>$_POST["np_content"], "require"=>'true',"message"=>Language::get('bp_notepad_please_add_the_content'));
				$obj_validate -> validateparam = $validate_arr;
				$error = $obj_validate->validate();
				if ($error != ''){
					showDialog($error,'','error');
				}
				$update_arr = array();
				$update_arr['np_title'] = $_POST['np_title'];
				$update_arr['np_customerid'] = $_POST['np_cid'];
				$update_arr['np_customername'] = $_POST['np_cname'];
				$update_arr['np_executetime'] = ($t = strtotime($_POST['np_time'].' '.$_POST['done_time']))>0?$t:0;
				//计算提醒时间
				if (intval($_POST['np_remindtime'])>0){
					$update_arr['np_remindtime'] = $update_arr['np_executetime'] - intval($_POST['np_remindtime'])*3600*24;
				}else{
					$update_arr['np_remindtime'] = 0;
				}
				$update_arr['np_content'] = $_POST['np_content'];
				$update_arr['np_addtime'] = time();
				$update_arr['np_state'] = $_POST['np_state'];

				//处理上传附件部分
				$new_attachment_id = array();
				foreach ((array)$_POST['att_num'] as $k=>$v){
					if($_POST['file_rs_'.$v] != ''){
						$tmp_file_info = explode(',', $_POST['file_rs_'.$v]);
						$att_id = $model->table('attachment')->insert(array('ca_name'=>$tmp_file_info[0],'ca_size'=>$tmp_file_info[1],'ca_type'=>$tmp_file_info[2],'ca_model'=>'notepad','ca_addstaff'=>$_SESSION['member_id'],'ca_addtime'=>time(),'ca_note'=>$tmp_file_info[3]));
						if($att_id != false){
							$new_attachment_id[] = $att_id;
						}
						unset($tmp_file_info);
						unset($att_id);
					}
				}
				//原附件信息处理部分
				$old_att_array = empty($_POST['old_attachment'])?array():explode(',', $_POST['old_attachment']);
				if(is_array($_POST['att_del']) && !empty($_POST['att_del'])){
					foreach ((array)$old_att_array as $k=>$v){
						if(in_array($v, $_POST['att_del'])){
							unset($old_att_array[$k]);
							$model->table('attachment')->where(array('ca_id'=>$v))->delete();
							unlink(BasePath.'/upload/file/'.$_POST['att_del_name'][$k]);
						}
					}
				}
				$attachment_idnew = array_merge($new_attachment_id,$old_att_array);
				$update_arr['np_attachment'] = empty($attachment_idnew)?'':implode(',',$attachment_idnew);
				$rs = $model->table('notepad')->where(array('np_id'=>$npid,'np_userid'=>$_SESSION['member_id']))->update($update_arr);
				$url = 'index.php?act=notepad&op=notepadlist';
				if ($_POST['source'] == 'customer'){
					$url = 'index.php?act=customer&op=customer_view&cc_id='.$update_arr['np_customerid'];
				}
				if ($rs){
					showDialog(Language::get('bp_notepad_edit_the_success'),$url,'succ');
				}else {
					showDialog(Language::get('bp_notepad_edit_failed'),'','error');
				}
			}else {
				//查询记事本详细
				$np_info = $model->table('notepad')->where(array('np_id'=>$npid,'np_userid'=>$_SESSION['member_id']))->find();
				if ($np_info['np_executetime'] > 0 && $np_info['np_remindtime'] > 0){
					//计算提前天数
					$np_info['np_remindtime'] = ($np_info['np_executetime'] - $np_info['np_remindtime'])/3600/24;
					if ($np_info['np_remindtime'] <= 0){
						$np_info['np_remindtime'] = '';
					}
				}else {
					$np_info['np_remindtime'] = '';
				}
				Tpl::output('np_info',$np_info);
				//获取任务附件信息
				$attachment_list = array();
				if($np_info['np_attachment'] != ''){
					$attachment_list = $model->table('attachment')->where(array('ca_id'=>array('in',$np_info['np_attachment'])))->select();
				}
				Tpl::output('attachment_list',$attachment_list);
				$source = '';
				if(intval($_GET['cc_id']) > 0){
					$source = 'customer';
				}
				$this->setleftmenu('notepadlist');
				Tpl::output('source',$source);
				Tpl::showpage('notepadadd');
			}
		}
	}
	/**
	 * 更新状态
	 */
	private function editstate(){
		$npid = $_GET['npid'];
		if (empty($npid)){
			$npid = $_POST['npid'];
		}
		if (empty($npid)){
			showDialog(Language::get('bp_notepad_parameter_error'),'','error');
		}
		//查询岗位信息
		$model = Model();
		$cstate = 0;
		if ($_GET['cstate'] == 1){
			$cstate = 1;
		}
		$where = array();
		if (is_array($npid)){
			$where['np_id'] = array('in',$npid);
		}else {
			$where['np_id'] = $npid;
		}
		$where['np_userid'] = $_SESSION['member_id'];
		$rs = $model->table('notepad')->where($where)->update(array('np_state'=>$cstate));
		$url = 'index.php?act=notepad&op=notepadlist';
		if(intval($_GET['cc_id']) > 0){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}
		if ($rs){
			showDialog(Language::get('bp_notepad_edit_the_success'),$url,'succ');
		}else{
			showDialog(Language::get('bp_notepad_edit_failed'),'','error');
		}
	}
	/**
	 * 删除记事本
	 */
	public function notepaddelOp(){
		$npid = $_GET['npid'];
		if (empty($npid)){
			$npid = $_POST['npid'];
		}
		if (empty($npid)){
			showDialog(Language::get('bp_notepad_parameter_error'),'','error');
		}
		$model = Model();
		$where = array();
		if (is_array($npid)){
			$where['np_id'] = array('in',$npid);
		}else {
			$where['np_id'] = $npid;
		}
		$where['np_userid'] = $_SESSION['member_id'];
		//查询岗位信息
		$rs = $model->table('notepad')->where($where)->delete();
		$url = 'index.php?act=notepad&op=notepadlist';
		if(intval($_GET['cc_id']) > 0){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}
		if ($rs){
			showDialog(Language::get('bp_notepad_delete_the_success'),$url,'succ');
		} else {
			showDialog(Language::get('bp_notepad_delete_failed'),'','error');
		}
	}
	/**
	 * 上传文件
	 */
	public function ajax_upload_fileOp(){
		$upload = new UploadFile();
		$upload->set('default_dir',ATTACH_FILE);
		$att_num = intval($_GET['att_num']);
		/**
		 * 文件上传
		 */
		if (!empty($_FILES['cm_attachment_'.$att_num]['name'])){
			$upload->set('file_name', '');
			$upload->set('max_size', 10240);
			$upload->set('thumb_width',	'400');
			$upload->set('thumb_height','400');
			$upload->set('thumb_ext','_small');
			$result = $upload->upfile('cm_attachment_'.$att_num);
			if ($result){
				$file_name = $upload->file_name;
				$file_size = $_FILES['cm_attachment_'.$att_num]['size'];
			}
		}
		/*
		 * 构造更新数据数组
		 */
		if ($file_name != ''){
			echo json_encode(array('done'=>true,'file_name'=>$file_name,'file_size'=>$file_size,'file_ext'=>$file_ext,'ori_name'=>$_FILES['cm_attachment_'.$att_num]['name']));
		}else{
			echo json_encode(array('done'=>false,'ori_name'=>$_FILES['cm_attachment_'.$att_num]['name']));
		}
	}
	/**
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_notepad_notepad_management'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'notepadlist','menu_name'=>Language::get('bp_notepad_notepad_management'),'menu_act'=>'notepad','menu_op'=>'notepadlist','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}