<?php
/**
 * 待办任务管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class missionControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('mission');
    }

	/**
	 * 待办任务列表
	 */
	public function mission_listOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取任务列表
		 */
		$where_condition = array();
		$filter = trim($_GET['filter']);
		$where_condition = array();
		switch ($filter){
			case '':
				if ($_SESSION['permission'] != 'all'){
				$where_condition['mission.cm_addstaff|mission.cm_excstaff'] = array(array('eq',$_SESSION['member_id']),array(array('like','%,'.$_SESSION['member_id'].',%'),array('eq','all'),'or'),'_multi'=>'1');
				}
				break;
			case 'done':
				if ($_SESSION['permission'] != 'all'){
				$where_condition['mission.cm_addstaff|mission.cm_excstaff'] = array(array('eq',$_SESSION['member_id']),array(array('like','%,'.$_SESSION['member_id'].',%'),array('eq','all'),'or'),'_multi'=>'1');
				}
				$where_condition['mission.cm_status'] = 0;
				break;
			case 'undone':
				if ($_SESSION['permission'] != 'all'){
				$where_condition['mission.cm_addstaff|mission.cm_excstaff'] = array(array('eq',$_SESSION['member_id']),array(array('like','%,'.$_SESSION['member_id'].',%'),array('eq','all'),'or'),'_multi'=>'1');
				}
				$where_condition['mission.cm_status'] = 1;
				break;
			case 'cancel':
				if ($_SESSION['permission'] != 'all'){
				$where_condition['mission.cm_addstaff|mission.cm_excstaff'] = array(array('eq',$_SESSION['member_id']),array(array('like','%,'.$_SESSION['member_id'].',%'),array('eq','all'),'or'),'_multi'=>'1');
				}
				$where_condition['mission.cm_status'] = -1;
				break;
			case 'fromme':
				$where_condition['mission.cm_addstaff'] = $_SESSION['member_id'];
				break;
			case 'tome':
				$where_condition['mission.cm_excstaff'] = array(array('like','%,'.$_SESSION['member_id'].',%'),array('eq','all'),'or');
				break;
		}
		//处理检索表单的请求
		$donedate_before = strtotime(trim($_GET['donedate_before']));
		if($donedate_before > 0){
			$where_condition['mission.cm_donedate'] = array('lt',$donedate_before);
		}
		if(intval($_GET['cm_type']) != 0){
			$where_condition['mission.cm_type'] = intval($_GET['cm_type']);
		}
		if(intval($_GET['cm_priority']) != 0){
			$where_condition['mission.cm_priority'] = intval($_GET['cm_priority']);
		}
		Tpl::output('cm_type',intval($_GET['cm_type']));
		Tpl::output('cm_donedate',trim($_GET['donedate_before']));
		Tpl::output('cm_priority',intval($_GET['cm_priority']));
		$mission_list = $model->field('mission.*,customer.cc_name,user.user_truename')->table('mission,customer,user')->join('left')->on('mission.cc_id=customer.cc_id,mission.cm_addstaff=user.user_id')->where($where_condition)->page(10)->order('mission.cm_addtime desc')->select();
		Tpl::output('mission_list',$mission_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('mission_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('mission_list');
	}
	/**
	 * 添加新待办任务
	 */
	public function mission_addOp(){

        Language::read('department');

		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 添加任务
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cm_subject"],"require"=>"true","message"=>Language::get('bp_mission_please_fill_out_the_to-do_task_topic'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$cc_type = intval($_POST['cc_type']);
			$insert_array = array();
			$insert_array['cm_subject'] = trim($_POST['cm_subject']);
			$insert_array['cc_id'] = intval($_POST['np_cid']);
			$insert_array['cm_chanceid'] = intval($_POST['chance_id']);
			$insert_array['cm_contact'] = $cc_type == 1?intval($_POST['ccc_id']):0;
			$insert_array['cm_priority'] = intval($_POST['cm_priority']);
			$insert_array['cm_donedate'] = ($t = strtotime(trim($_POST['done_date']).' '.trim($_POST['done_time'])))>0?$t:0;
			$insert_array['cm_status'] = 1;
			$insert_array['cm_addstaff'] = $_SESSION['member_id'];
			$insert_array['cm_addtime'] = time();
			$insert_array['cm_type'] = intval($_POST['cm_type']);
			$insert_array['cm_note'] = trim($_POST['cm_note']);
			//处理部门信息
			$insert_array['cm_dp_id']    = $_SESSION['dp_id'];
			//处理任务参与人员部分
			$n_rectype = intval($_POST['n_rectype']);
			switch ($n_rectype){
				case '1'://选择员工
					$choose_user = ',';
					if(is_array($_POST['chooseuser']) && !empty($_POST['chooseuser'])){
						foreach ((array)$_POST['chooseuser'] as $k=>$v){
							$choose_user .= $v.',';
						}
					}
					if($choose_user == ','){
						showDialog(Language::get('bp_mission_please_select_a_task_participants'),'','error');
					}
					$insert_array['cm_excstaff'] = $choose_user;
					break;
				case '2'://选择部门
					$choose_dp = '';
					if(is_array($_POST['choosedep']) && !empty($_POST['choosedep'])){
						foreach ((array)$_POST['choosedep'] as $k=>$v){
							$choose_dp .= $v.',';
						}
					}
					$choose_dp = trim($choose_dp,',');
					if($choose_dp == ''){
						showDialog(Language::get('bp_mission_please_select_a_task_to_participate_in_the'),'','error');
					}
					$dp_staff_list = $model->field('user_id')->table('user')->where(array('user_department'=>array('in',$choose_dp)))->select();
					if(empty($dp_staff_list)){
						showDialog(Language::get('bp_mission_selected_departments_below_do_not_have_any'),'','error');
					}else{
						$dp_staff = '';
						foreach ((array)$dp_staff_list as $k=>$v){
							$dp_staff .= $v['user_id'].',';
						}
					}
					$insert_array['cm_excstaff'] = trim($dp_staff,',');
					break;
				case '3'://全体人员
					$insert_array['cm_excstaff'] = 'all';
					break;
			}
			//处理上传附件部分
			$attachment_id = '';
			foreach ((array)$_POST['att_num'] as $k=>$v){
				if($_POST['file_rs_'.$v] != ''){
					$tmp_file_info = explode(',', $_POST['file_rs_'.$v]);
					$att_id = $model->table('attachment')->insert(array('ca_name'=>$tmp_file_info[0],'ca_size'=>$tmp_file_info[1],'ca_type'=>$tmp_file_info[2],'ca_model'=>'mission','ca_addstaff'=>$_SESSION['member_id'],'ca_addtime'=>time(),'ca_note'=>$tmp_file_info[3]));
					if($att_id != false){
						$attachment_id .= $att_id.',';
					}
					unset($tmp_file_info);
					unset($att_id);
				}
			}
			$insert_array['cm_attachment'] = trim($attachment_id,',');
			$result = $model->table('mission')->insert($insert_array);
			$url = 'index.php?act=mission&op=mission_list';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$insert_array['cm_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_array['cc_id'];
			}
			if($result != false){
				showDialog(Language::get('bp_mission_to-do_tasks_added_successfully'),$url,'succ');
			}else{
				showDialog(Language::get('bp_mission_add_failure_to-do_tasks'),'','error');
			}
		}
		//如果来自会员详情页面则调取该会员信息
		if(intval($_GET['cc_id']) > 0){
			$cc_info  = $model->table('customer')->where(array('cc_id'=>intval($_GET['cc_id']),'cc_isdel'=>0))->find();
			if(empty($cc_info)){
				showMessage(Language::get('bp_mission_member_information_does_not_exist_or_has_entered'));
			}else{
				Tpl::output('cc_info',$cc_info);
				//如果是企业会员调取联系人名单
				if($cc_info['cc_type'] == 1){
					$ccc_info = $model->table('company_contact')->where(array('cc_id'=>intval($_GET['cc_id'])))->select();
					Tpl::output('ccc_info',$ccc_info);
				}
			}
		}elseif (intval($_GET['chance_id']) > 0){
			$chance_id = intval($_GET['chance_id']);
			//查询销售机会详细
			$chance_info = $model->table('chance')->where(array('cha_id'=>$chance_id,'cha_istrash'=>0))->find();
			if(empty($chance_info)){
				showMessage(Language::get('bp_mission_sales_lead_information_does_not_exist_or_has'));
			}else{
				Tpl::output('chance_info',$chance_info);
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$chance_info['cha_customerid'],'cc_isdel'=>0))->find();
				Tpl::output('cc_info',$cc_info);
				//如果是企业会员调取联系人名单
				if ($cc_info['cc_type'] == 1){
					$ccc_info = $model->table('company_contact')->where(array('cc_id'=>$cc_info['cc_id']))->select();
					Tpl::output('ccc_info',$ccc_info);
				}
			}
		}

		//调取部门信息
		$model_dp = Model('department');
		$dlist = $model_dp->getDepartmentCacheTree();
		Tpl::output('dlist',$dlist);
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		Tpl::output('source',$source);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('mission_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('mission_add');
	}
	/**
	 * 编辑任务
	 */
	public function mission_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 编辑任务
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cm_subject"],"require"=>"true","message"=>Language::get('bp_mission_please_fill_out_the_to-do_task_topic'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['cm_subject'] = trim($_POST['cm_subject']);
			$update_array['cm_contact'] = intval($_POST['cc_type']) == 1?intval($_POST['ccc_id']):0;
			$update_array['cm_priority'] = intval($_POST['cm_priority']);
			$update_array['cm_donedate'] = ($t = strtotime(trim($_POST['done_date']).' '.trim($_POST['done_time'])))>0?$t:0;
			if(trim($_POST['overtime']) != 'yes'){
				$update_array['cm_status'] = intval($_POST['cm_status']);
			}
			$update_array['cm_type'] = intval($_POST['cm_type']);
			$update_array['cm_note'] = trim($_POST['cm_note']);
			//状态转变为“已完成”状态时向会员行动历史表中插入数据
			if($_POST['old_status'] !=0 && intval($_POST['cm_status']) == 0){
				$insert_act_array = array();
				$insert_act_array['cc_id'] = intval($_POST['cc_id']);
				$insert_act_array['cca_addstaff'] = $_SESSION['member_id'];
				$insert_act_array['cca_addtime'] = time();
				$insert_act_array['cca_content'] = trim($_POST['cm_subject']).Language::get('nc_colon').trim($_POST['cm_note']);
				$insert_act_array['cca_start_time'] = time();
				$insert_act_array['cca_excstaff'] = trim($_POST['excstaff']);
				$insert_act_array['cca_ismission'] = 1;
				$insert_act_array['cca_chanceid'] = intval($_POST['chance_id']);
				//处理部门信息
				$cc_info = $model->table('customer')->where(array('cc_id'=>intval($_POST['cc_id'])))->find();
				$insert_action_array['cca_dp_id']    = $cc_info['cc_dept_id'];
				$model->table('customer_action')->insert($insert_act_array);
			}
			//处理上传附件部分
			$new_attachment_id = '';
			foreach ((array)$_POST['att_num'] as $k=>$v){
				if($_POST['file_rs_'.$v] != ''){
					$tmp_file_info = explode(',', $_POST['file_rs_'.$v]);
					$att_id = $model->table('attachment')->insert(array('ca_name'=>$tmp_file_info[0],'ca_size'=>$tmp_file_info[1],'ca_type'=>$tmp_file_info[2],'ca_model'=>'mission','ca_addstaff'=>$_SESSION['member_id'],'ca_addtime'=>time(),'ca_note'=>$tmp_file_info[3]));
					if($att_id != false){
						$new_attachment_id .= $att_id.',';
					}
					unset($tmp_file_info);
					unset($att_id);
				}
			}
			//原附件信息处理部分
			$old_att_array = explode(',', $_POST['old_attachment']);
			if(is_array($_POST['att_del']) && !empty($_POST['att_del'])){
				foreach ((array)$old_att_array as $k=>$v){
					if(in_array($v, $_POST['att_del'])){
						unset($old_att_array[$k]);
						$model->table('attachment')->where(array('ca_id'=>$v))->delete();
						unlink(BasePath.'/upload/file/'.$_POST['att_del_name'][$k]);
					}
				}
			}
			$old_attachment = implode(',',$old_att_array);
			$new_attachment_id = trim($new_attachment_id,',');
			$update_array['cm_attachment'] = $old_attachment!=''?$old_attachment.($new_attachment_id!=''?','.$new_attachment_id:''):$new_attachment_id;

			$rs = $model->table('mission')->where(array('cm_id'=>$_POST['cm_id'],'cm_addstaff'=>$_SESSION['member_id']))->update($update_array);
			$url = 'index.php?act=mission&op=mission_list';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.intval($_POST['chance_id']);
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_POST['cc_id']);
			}
			if($rs){
				showDialog(Language::get('bp_mission_to-do_tasks_edit_saved_successfully'),$url,'succ');
			}else{
				showDialog(Language::get('bp_mission_save_failed_to-do_task_editor'),'','error');
			}
		}
		/**
		 * 调取任务相关信息
		 */
		$cm_id = intval($_GET['cm_id']);
		$cm_info = $model->field('mission.*,customer.cc_type,customer.cc_name')->table('mission,customer')->join('left')->on('mission.cc_id=customer.cc_id')->where(array('mission.cm_id'=>$cm_id))->find();
		if(empty($cm_info)){
			showMessage(Language::get('bp_mission_not_found_the_task_information'));
		}
		Tpl::output('cm_info',$cm_info);
		//获取参与任务人员名单
		if($cm_info['cm_excstaff'] != 'all'){
			$staff_list = $model->field('user_truename,user_departmentname,user_jobpostname')->table('user')->where(array('user_id'=>array('in',trim(substr($cm_info['cm_excstaff'], 1),','))))->select();
			if(empty($staff_list)){
				showMessage(Language::get('bp_mission_not_found_in_the_task_information'));
			}
			Tpl::output('staff_list',$staff_list);
		}
		//获取任务附件信息
		if($cm_info['cm_attachment'] != ''){
			$attachment_list = $model->table('attachment')->where(array('ca_id'=>array('in',$cm_info['cm_attachment'])))->select();
			Tpl::output('attachment_list',$attachment_list);
		}
		//如果选择了会员则调取该会员信息
		if($cm_info['cc_id'] > 0){
			$cc_info  = $model->table('customer')->where(array('cc_id'=>$cm_info['cc_id']))->find();
			if(!empty($cc_info)){
				Tpl::output('cc_info',$cc_info);
			}
		}
		//如果是企业会员调取联系人名单
		if($cm_info['cc_type'] == 1){
			$ccc_info = $model->table('company_contact')->where(array('cc_id'=>intval($cm_info['cc_id'])))->select();
			Tpl::output('ccc_info',$ccc_info);
		}
		//如果选择了销售机会查询销售机会信息
		if($cm_info['cm_chanceid'] > 0){
			$chance_info  = $model->table('chance')->where(array('cha_id'=>$cm_info['cm_chanceid']))->find();
			if(!empty($chance_info)){
				Tpl::output('chance_info',$chance_info);
			}
		}
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		Tpl::output('source',$source);


		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('mission_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('mission_edit');
	}
	/**
	 * 查看任务
	 */
	public function mission_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取任务相关信息
		 */
		$cm_id = intval($_GET['cm_id']);
		$cm_info = $model->field('mission.*,customer.cc_name,customer.cc_type,customer.cc_dept_id,customer.cc_staff_id,user.user_truename')->table('mission,customer,user')->join('left')->on('mission.cc_id=customer.cc_id,mission.cm_addstaff=user.user_id')->where(array('mission.cm_id'=>$cm_id))->find();
		if(empty($cm_info)){
			showMessage(Language::get('bp_mission_not_found_the_task_information'),'','exception','error',1,0);
		}
		$tmp_excstaff = explode(',', $cm_info['cm_excstaff']);
		if(!in_array($_SESSION['member_id'],$tmp_excstaff) && $cm_info['cm_addstaff'] != $_SESSION['member_id'] && $cm_info['cm_excstaff'] != 'all' && $_SESSION['permission']!='all'){
			showMessage(Language::get('bp_mission_you_have_no_right_to_view_the_task_information'),'','exception','error',1,0);
		}
		//获取参与任务人员名单
		if($cm_info['cm_excstaff'] != 'all'){
			$staff_list = $model->field('user_truename,user_departmentname,user_jobpostname')->table('user')->where(array('user_id'=>array('in',$cm_info['cm_excstaff'])))->select();
			if(empty($staff_list)){
				showMessage(Language::get('bp_mission_not_found_in_the_task_information'),'','exception','error',1,0);
			}
			Tpl::output('staff_list',$staff_list);
		}
		//获取任务附件信息
		if($cm_info['cm_attachment'] != ''){
			$attachment_list = $model->table('attachment')->where(array('ca_id'=>array('in',$cm_info['cm_attachment'])))->select();
			Tpl::output('attachment_list',$attachment_list);
		}
		//如果是企业会员调取联系人名单
		if($cm_info['cc_type'] == 1){
			$ccc_info = $model->table('company_contact')->where(array('ccc_id'=>intval($cm_info['cm_contact'])))->find();
			Tpl::output('ccc_info',$ccc_info);
		}
		Tpl::output('cm_info',$cm_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('mission_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('html_title','任务详情');
		Tpl::showpage('mission_view','windowopen_layout');
	}
	/**
	 * 上传文件
	 */
	public function ajax_upload_fileOp(){
		$upload = new UploadFile();
		$upload->set('default_dir',ATTACH_FILE);
		$att_num = intval($_GET['att_num']);
		/**
		 * 文件上传
		 */
		if (!empty($_FILES['cm_attachment_'.$att_num]['name'])){
			$upload->set('file_name', '');
			$upload->set('max_size', 10240);
			$upload->set('thumb_width',	'400');
			$upload->set('thumb_height','400');
			$upload->set('thumb_ext', '_small');
			$result = $upload->upfile('cm_attachment_'.$att_num);
			if ($result){
				$file_name = $upload->file_name;
				$file_size = $_FILES['cm_attachment_'.$att_num]['size'];
			}
		}
		/*
		 * 构造更新数据数组
		 */
		if ($file_name != ''){
			echo json_encode(array('done'=>true,'file_name'=>$file_name,'file_size'=>$file_size,'file_ext'=>$file_ext,'ori_name'=>$_FILES['cm_attachment_'.$att_num]['name']));
		}else{
			echo json_encode(array('done'=>false,'ori_name'=>$_FILES['cm_attachment_'.$att_num]['name']));
		}
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_mission_schedule_the_task'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'calendar_show','menu_name'=>Language::get('bp_mission_work_desk_calendar'),'menu_act'=>'work_calendar','menu_op'=>'calendar_show');
		$arr[0]['submenu'][1] = array('menu_key'=>'mission_list','menu_name'=>Language::get('bp_mission_task_management'),'menu_act'=>'mission','menu_op'=>'mission_list');
		$arr[0]['submenu'][2] = array('menu_key'=>'schedule_list','menu_name'=>Language::get('bp_mission_schedule_management'),'menu_act'=>'schedule','menu_op'=>'schedule_list');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}