<?php
/**
 * 登录
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class loginControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('login');
    }

	/*
	 * 登录
	 */
	public function indexOp(){
		$model = Model();
		//检查登录状态
		if($_SESSION['is_login'] == '1') {
			@header("Location: index.php");
			exit();
		}

		if (chksubmit()){
			if (cookie('tm_login') == 5){
				showDialog(Language::get('bp_login_your_operating_too_often').Language::get('bp_comma').Language::get('bp_login_please_try_again_later'),SiteUrl);
			}
			Security::checkToken();
			$obj_validate = new Validate();
			$obj_validate->validateparam = array(
				array("input"=>$_POST["username"],	"require"=>"true", "message"=>Language::get('bp_login_please_enter_a_username')),
				array("input"=>$_POST["pw"],	"require"=>"true", "message"=>Language::get('bp_login_please_enter_the_password')),
				array("input"=>$_POST["captcha"],	"require"=>"true", "message"=>Language::get('bp_login_please_enter_the_verification_code')),
			);
			$error = $obj_validate->validate();
			if ($error != ''){
				showValidateError($error);
			}else {
				if (!checkSeccode($_POST['nchash'],$_POST['captcha'])){
					showDialog(Language::get('bp_login_verification_code_error'));
				}
				$where	= array();
				$where['user_name']	= trim($_POST['username']);
				$where['user_password']	= md5(trim($_POST['pw']));
				$where['user_state']	= '0';//在职
				$where['d_state']	= 1;//开启
				$u_info = $model->table('user,department')->field('*')->join('left')->on('user.user_department = department.d_id')->where($where)->find();
				if(!empty($u_info)){
					setNcCookie('tm_login','',time()-3600);
					//写入session
					Session::set('is_login','1');
					Session::set('member_id',$u_info['user_id']);
					Session::set('member_name',$u_info['user_name']);
					Session::set('truename',$u_info['user_truename']);
					//部门编号
					Session::set('dp_id',$u_info['user_department']);
					Session::set('pdp_id',$u_info['d_parentid']);
					//店铺信息
					Session::set('shop_id',$u_info['user_shopid']);
					//保存权限
					Session::set('jp_id',$u_info['user_jobpost']);
					$permission_arr = $this->getPermission();
					Session::set('permission',$permission_arr['access']);
					//认领的公海会员，超出时限则重归公海
					seacustomer_overtime();
					$_POST['ref_url'] = strstr($_POST['ref_url'],'logout')=== false && !empty($_POST['ref_url']) ? $_POST['ref_url'] : 'index.php';
					if (empty($_GET['inajax'])){
						@header('location: '.$_POST['ref_url']);exit();
					}else {
						showDialog(Language::get('bp_login_login_successful'),'reload','succ',$extrajs);
					}
				} else {
					showDialog(Language::get('bp_login_the_user_name_and_password_mistake').Language::get('bp_comma').Language::get('bp_login_or_subordinate_departments_have_been_closed'));
				}
			}
		}
		if(empty($_GET['ref_url'])) $_GET['ref_url'] = getReferer();
		Tpl::output('nchash',substr(md5(SiteUrl.$_GET['act'].$_GET['op']),0,8));
		Tpl::showpage('login','simple_layout');
	}
	/*
	 * 处理权限
	 */
	private function getPermission(){
		$model = Model();
		//查询员工所在岗位信息和权限信息
		$jp_info = $model->table('jobpost,permission')->join('left')->on('jobpost.jp_permissionid=permission.pmn_id')->where(array('jp_id'=>$_SESSION['jp_id']))->find();;
		if (empty($jp_info)){
			return '';
		}
		//访问权限
		$p_arr['access'] = $jp_info['pmn_accessright'];
		return $p_arr;
	}
	/**
	 * 退出操作
	 */
	public function logoutOp(){
		Session::destroy();
		redirect();
	}
}