<?php
/**
 * 岗位管理页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class jobpostControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('jobpost');
    }

	/**
	 * 岗位列表
	 */
	public function jobpostlistOp(){
		//一般列表
		$model = Model();
		if (!empty($_GET['search_name'])){
			$where['jp_name'] = array('like',"%{$_GET['search_name']}%");
		}
		if (!empty($_GET['did'])){
			$where['jp_departmentid'] = $_GET['did'];
		}
		$jp_list = $model->table('jobpost')->where($where)->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('jp_list',$jp_list);
		//左侧菜单
		$this->setleftmenu('jobpostlist');
		Tpl::showpage('jobpostlist');
	}
	/**
	 * 添加岗位
	 */
	public function jobpostaddOp(){
		$model = Model('department');
		if (chksubmit()){
			$did = intval($_POST["jp_did"]);
			if($did<=0){
				$did = 0;
			}
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["jp_name"],"require"=>"true","message"=>Language::get('bp_jobpost_please_add_name'));
			$validate_arr[] = array("input"=>$did, "require"=>'true',"message"=>Language::get('bp_jobpost_please_select_a_department'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询部门信息
			$d_info = $model->table('department')->where(array('d_id'=>$did,'d_state'=>1))->find();
			if(empty($d_info)){
				showDialog(Language::get('bp_jobpost_department_information_error'),'','error');
			}
			//同一部门下不能存在相同名称的岗位
			$same_jp = $model->table('jobpost')->where(array('jp_name'=>$_POST['jp_name'],'jp_departmentid'=>$did))->find();
			if (!empty($same_jp)){
				showDialog(Language::get('bp_jobpost_job_name_already_exists'),'','error');
			}
			$d_namearr = array();//所有上级部门名称数组
			//全部上级部门
			if (!empty($d_info['d_allparentid'])){
				$d_list = $model->table('department')->where(array('d_id'=>array('in',$d_info['d_allparentid']),'d_state'=>1))->select();
				$d_listnew = array();
				foreach ((array)$d_list as $k=>$v){
					$d_listnew[$v['d_id']] = $v;
				}
				$d_idarr = explode(',',$d_info['d_allparentid']);
				foreach ((array)$d_idarr as $k=>$v){
					if (!empty($d_listnew[$v]['d_name'])){
						$d_namearr[] = $d_listnew[$v]['d_name'];
					}
				}
			}
			$d_namearr[] = $d_info['d_name'];

			$insert_arr = array();
			$insert_arr['jp_name'] = $_POST['jp_name'];
			$insert_arr['jp_intro'] = $_POST['jp_intro'];
			$insert_arr['jp_departmentid'] = $did;
			$insert_arr['jp_departmentname'] = implode('->',$d_namearr);
			$insert_arr['jp_reportto'] = intval($_POST['jp_tojpid']);
			$insert_arr['jp_permissionid'] = intval($_POST['jp_pmnid']);
			$insert_arr['jp_isleader'] = intval($_POST['leader']);
			if ($insert_arr['jp_isleader'] == 1){
				$insert_arr['jp_only'] = 1;
			}else{
				$insert_arr['jp_only'] = $_POST['jp_only'];
			}
			$insert_arr['jp_state'] = $_POST['status'];
			$rs = $model->table('jobpost')->insert($insert_arr);
			if ($rs){
				showDialog(Language::get('bp_jobpost_job_creation_is_successful'),'index.php?act=jobpost&op=jobpostlist','succ');
			}else {
				showDialog(Language::get('bp_jobpost_post_new_failure'),'','error');
			}
		}else {
			//获得部门select
			$selecthtml = $model->getDepartmentCacheSelect(false);
			Tpl::output('selecthtml',$selecthtml);
			//查询权限组
			$permissionlist = $model->table('permission')->where()->order('pmn_sort asc')->select();
			Tpl::output('permissionlist',$permissionlist);
			//左侧菜单
			$this->setleftmenu('jobpostlist');
			Tpl::showpage('jobpostadd');
		}
	}
	/**
	 * 编辑岗位
	 */
	public function jobposteditOp(){
		if (!empty($_GET['type'])){
			$funname = "edit".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//一般编辑操作
			$id = intval($_GET['id']);
			if ($id<=1){
				$id = intval($_POST['id']);
			}
			if ($id<=1){//1为系统默认管理员不能编辑
				showDialog(Language::get('bp_jobpost_parameter_error'),'','error');
			}
			$model = Model('department');
			//查询岗位信息
			$jp_info = $model->table('jobpost')->where(array('jp_id'=>$id))->find();
			if (empty($jp_info)){
				showDialog(Language::get('bp_jobpost_wrong_information'),'','error');
			}
			if (chksubmit()){
				$did = intval($_POST["jp_did"]);
				if($did<=0){
					$did = '';
				}
				$obj_validate = new Validate();
				$validate_arr[] = array("input"=>$_POST["jp_name"],"require"=>"true","message"=>Language::get('bp_jobpost_please_add_name'));
				$validate_arr[] = array("input"=>$did, "require"=>'true',"message"=>Language::get('bp_jobpost_please_select_a_department'));
				$obj_validate -> validateparam = $validate_arr;
				$error = $obj_validate->validate();
				if ($error != ''){
					showDialog($error,'','error');
				}
				//查询部门信息
				$d_info = $model->table('department')->where(array('d_id'=>$did,'d_state'=>1))->find();
				if(empty($d_info)){
					showDialog(Language::get('bp_jobpost_department_information_error'),'','error');
				}
				$d_namearr = array();//所有上级部门名称数组
				//全部上级部门
				if (!empty($d_info['d_allparentid'])){
					$d_list = $model->table('department')->where(array('d_id'=>array('in',$d_info['d_allparentid']),'d_state'=>1))->select();
					$d_listnew = array();
					foreach ((array)$d_list as $k=>$v){
						$d_listnew[$v['d_id']] = $v;
					}
					$d_idarr = explode(',',$d_info['d_allparentid']);
					foreach ((array)$d_idarr as $k=>$v){
						if (!empty($d_listnew[$v]['d_name'])){
							$d_namearr[] = $d_listnew[$v]['d_name'];
						}
					}
				}
				$d_namearr[] = $d_info['d_name'];
				if ($_POST['jp_name'] != $jp_info['jp_name']){
					//同一部门下不能存在相同名称的岗位
					$same_jp = $model->table('jobpost')->where(array('jp_name'=>$_POST['jp_name'],'jp_departmentid'=>$did))->find();
					if (!empty($same_jp)){
						showDialog(Language::get('bp_jobpost_job_name_already_exists'),'','error');
					}
				}
				$update_arr = array();
				$update_arr['jp_name'] = $_POST['jp_name'];
				$update_arr['jp_intro'] = $_POST['jp_intro'];
				$update_arr['jp_departmentid'] = $did;
				$update_arr['jp_departmentname'] = implode('->',$d_namearr);
				$update_arr['jp_permissionid'] = intval($_POST['jp_pmnid']);
				$update_arr['jp_reportto'] = intval($_POST['jp_tojpid']);
				$update_arr['jp_isleader'] = intval($_POST['leader']);
				if ($update_arr['jp_isleader'] == 1){
					$update_arr['jp_only'] = 1;
				}
				$rs = $model->table('jobpost')->where(array('jp_id'=>$id))->update($update_arr);
				if ($rs){
					H('user',true,'file');//更新缓存
					showDialog(Language::get('bp_jobpost_post_editing_success'),'index.php?act=jobpost&op=jobpostlist','succ');
				}else {
					showDialog(Language::get('bp_jobpost_post_editing_failed'),'','error');
				}
			}else {
				//获得部门select
				$selecthtml = $model->getDepartmentCacheSelect(false,$jp_info['jp_departmentid']);
				Tpl::output('selecthtml',$selecthtml);
				$reportto_info = array();//报告给的岗位信息
				if (!empty($jp_info['jp_reportto'])){
					//查询报告给岗位信息并且除去默认系统管理员（即id=1的岗位）
					$reportto_info = $model->table('jobpost')->where(array('jp_id'=>$jp_info['jp_reportto']))->find();
				}
				Tpl::output('reportto_info',$reportto_info);
				Tpl::output('jp_info',$jp_info);
				//查询权限组
				$permissionlist = $model->table('permission')->where()->order('pmn_sort asc')->select();
				Tpl::output('permissionlist',$permissionlist);
				//左侧菜单
				$this->setleftmenu('jobpostlist');
				Tpl::showpage('jobpostadd');
			}
		}
	}
	/**
	 * 编辑岗位状态
	 */
	private function editstate(){
		$id = intval($_GET['id']);
		if ($id<=1){//1为系统默认管理员不能编辑
			showDialog(Language::get('bp_jobpost_parameter_error'),'','error');
		}
		//查询岗位信息
		$model = Model();
		$cstate = 0;
		if ($_GET['cstate'] == 1){
			$cstate = 1;
		}
		if ($cstate == 1){//开启岗位
			$rs = $model->table('jobpost')->where(array('jp_id'=>$id))->update(array('jp_state'=>1));
		}else {
			//关闭岗位时，先判断是否存在下属员工
			$u_count = $model->table('user')->where(array('user_jobpost'=>$id))->count();
			if ($u_count > 0){
				showDialog(Language::get('bp_jobpost_employees_are_using_the_position_information').Language::get('bp_comma').Language::get('bp_jobpost_please_transfer_the_employee_to_other_jobs'),'','error');
			}
			$rs = $model->table('jobpost')->where(array('jp_id'=>$id))->update(array('jp_state'=>0));
		}
		if ($rs){
			showDialog(Language::get('bp_jobpost_state_to_edit_success'),'index.php?act=jobpost&op=jobpostlist','succ');
		}else{
			showDialog(Language::get('bp_jobpost_editor_state_failure'),'','error');
		}
	}
	/**
	 * 编辑岗位状态
	 */
	private function editonly(){
		$id = intval($_GET['id']);
		if ($id<=1){//1为系统默认管理员不能编辑
			showDialog(Language::get('bp_jobpost_parameter_error'),'','error');
		}
		//查询岗位信息
		$model = Model();
		$conly = 0;
		if ($_GET['conly'] == 1){
			$conly = 1;
		}
		if ($conly == 1){
			//开启唯一，判断岗位下是否存在一个以上的员工
			$u_count = $model->table('user')->where(array('user_jobpost'=>$id))->count();
			if ($u_count > 1){
				showDialog(Language::get('bp_jobpost_many_employees_in_the_use_of_the_post_information').Language::get('bp_comma').Language::get('bp_jobpost_please_make_sure_that_the_post_staff_only'),'','error');
			}
			$rs = $model->table('jobpost')->where(array('jp_id'=>$id))->update(array('jp_only'=>1));
		}else {
			//关闭唯一
			$rs = $model->table('jobpost')->where(array('jp_id'=>$id))->update(array('jp_only'=>0));
		}
		if ($rs){
			showDialog(Language::get('bp_jobpost_state_to_edit_success'),'index.php?act=jobpost&op=jobpostlist','succ');
		}else{
			showDialog(Language::get('bp_jobpost_editor_state_failure'),'','error');
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_jobpost_employees'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'departmentlist','menu_name'=>Language::get('bp_jobpost_department_of_management'),	'menu_act'=>'department','menu_op'=>'departmentlist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'permissionlist','menu_name'=>Language::get('bp_jobpost_permissions_set'),	'menu_act'=>'permission','menu_op'=>'permissionlist','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'jobpostlist','menu_name'=>Language::get('bp_jobpost_post_management'),	'menu_act'=>'jobpost','menu_op'=>'jobpostlist','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'userlist','menu_name'=>Language::get('bp_jobpost_staff_management'),	'menu_act'=>'user','menu_op'=>'userlist','linktype'=>'0');
		$arr[0]['submenu'][4] = array('menu_key'=>'userloglist','menu_name'=>Language::get('bp_jobpost_employees_log'),	'menu_act'=>'user','menu_op'=>'userlog','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}