<?php
/**
 * 工作台
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class indexControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('index');
    }

	public function indexOp(){
		//初始变量
		$year = date('Y',time());
		Tpl::output('year',$year);
		/**
		 * 实例化模型
		 */
		$model = Model();
		//查询记事本提醒信息
		$where['np_userid'] = $_SESSION['member_id'];
		$where['np_state'] = 0;
		$where['np_remindtime'] = array(array('gt',0),array('elt',time()),'and');
		$datetime = date('Y-m-d',time());
		$np_list = $model->table('notepad')->where($where)->order('np_executetime asc')->page(($t=C('index_np_maxnum'))>0?$t:5)->select();
		Tpl::output('np_list',$np_list);

		//公告
		$on = "noticetext.ntt_id=notice.nt_nttid,noticetext.ntt_id=noticeread.ntread_nttid and noticeread.ntread_uid ={$_SESSION['member_id']}";
		$table = 'noticetext,notice,noticeread';
		$where = " (nt_rectype =2 OR (nt_rectype =0 AND nt_recid ='{$_SESSION['member_id']}') OR ( nt_rectype =1 AND nt_recid ='{$_SESSION['dp_id']}')) ";
		$where .= " and (ntread_state = 1 or ntread_state is null) ";
		$notice_list = $model->table($table)->join('left,left')->on($on)->where($where)->order('ntt_istop desc,ntt_id desc')->limit(0,10)->select();
		if (!empty($notice_list)){
			$notice_list[0]['ntt_content'] = replaceHtmlAndJs(htmlspecialchars_decode($notice_list[0]['ntt_content']));
		}
		Tpl::output('notice_list',$notice_list);
		//待办任务
		$cm_list  = $model->table('mission')->where("cm_status=1 and (cm_excstaff like '%,".$_SESSION['member_id'].",%' or cm_addstaff = ".$_SESSION['member_id'].")")->order('cm_donedate asc')->select(array('limit'=>'all'));
		$one_week = time()+3600*24*7;
		$one_week_mission = array();
		$expire_mission   = array();
		if(!empty($cm_list)){
			foreach ((array)$cm_list as $k=>$v){
				if($v['cm_donedate'] <= $one_week && $v['cm_donedate'] >= time()){
					$one_week_mission[] = $v;
					unset($cm_list[$k]);
				}
				if($v['cm_donedate'] < time()){
					$expire_mission[] = $v;
					unset($cm_list[$k]);
				}
			}
		}
		if(!empty($one_week_mission)){
			$one_week_mission = array_chunk($one_week_mission, C('index_mission_maxnum'));
			$one_week_mission = $one_week_mission[0];
		}
		if(!empty($expire_mission)){
			$expire_mission   = array_chunk($expire_mission, C('index_mission_maxnum'));
			$expire_mission   = $expire_mission[0];
		}
		if(!empty($cm_list)){
			$cm_list = array_chunk($cm_list, C('index_mission_maxnum'));
			$cm_list = $cm_list[0];
		}
		Tpl::output('one_week_mission',$one_week_mission);
		Tpl::output('expire_mission',$expire_mission);
		Tpl::output('cm_list',$cm_list);
		//工作日历
		if (cPermission('work_calendar','calendar_show')){
			$tmp_schedule_info = $model->table('schedule')->where(array('cs_staff_id'=>$_SESSION['member_id']))->select();
			$schedule_list = array();
			$now_time = time();
			if(!empty($tmp_schedule_info) && is_array($tmp_schedule_info)){
				foreach ((array)$tmp_schedule_info as $k=>$v){
					$start_d_plus = round(($v['cs_start_time']-$now_time)/(3600*24));
					$end_d_plus   = round(($v['cs_end_time']-$now_time)/(3600*24));
					$schedule_list[] = array(
						'title'=>$v['cs_subject'],
						'start'=>'y,m,d'.($start_d_plus>=0?'+'.$start_d_plus:$start_d_plus).','.date('h,i',$v['cs_start_time']),
						'end'=>'y,m,d'.($end_d_plus>=0?'+'.$end_d_plus:$end_d_plus).','.date('h,i',$v['cs_end_time']),
						'url'=>'index.php?act=schedule&op=schedule_view&cs_id='.$v['cs_id']
					);
				}
			}
		}
		Tpl::output('schedule_list',$schedule_list);
		//订单列表
		$order_where = array();
		$order_where['orders.co_status'] = array('neq',3);
		if($_SESSION['shop_id'] > 0){
			$order_where['orders.shop_id'] = $_SESSION['shop_id'];
		}
		$order_list = $model->field('orders.co_id,orders.co_status,orders.co_code,orders.co_addtime,shop.shop_name,customer.cc_name')->table('orders,shop,customer')->join('left')->on('orders.shop_id=shop.shop_id,orders.cc_id=customer.cc_id')->where($order_where)->page(C('index_order_maxnum'))->order('orders.co_addtime desc')->select();
		Tpl::output('order_list',$order_list);

		//销售统计
		if (cPermission('statinventory','stati_sales')){//允许查看销售统计
			$model = Model();
			$timequantum = gettimequantum($year);
			//年订单总金额、毛利、订单个数
			$where = array();
			$where['co_status'] = array('in',array(0,1,2));
			if ($_SESSION['shop_id']){
				$where['shop_id'] = $_SESSION['shop_id'];
			}
			$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
			$orderlist = $model->table('orders')->where($where)->select();
			unset($where);
			$orderstat = array('orderamount'=>0,'ordernum'=>0,'costamount'=>0);
			if(!empty($orderlist)){
				$orderidarr = array();
				foreach((array)$orderlist as $k=>$v){
					$orderstat['orderamount'] += $v['co_final_price'];
					$orderstat['costamount'] += $v['co_cost_price'];
					$orderstat['ordernum'] += 1;
					$orderidarr[] = $v['co_id'];
				}
				$orderstat['orderamount'] = ncPriceFormat($orderstat['orderamount']);
				$orderstat['profitamount'] = ncPriceFormat($orderstat['orderamount'] - $orderstat['costamount']);
				unset($where);
			}
			Tpl::output('orderstat',$orderstat);

		}
		//会员统计
		if (cPermission('statinventory','stati_customer')){//允许查看会员统计
			//新增会员统计
			$model = Model('statistics');
			$customerlist = $model->getMonthNewCustomer($year,$_SESSION['shop_id']);
			$stat_data = array();
			$customerlist_new = array();
			$countnum = 0;
			$newcustomer_stat_json = '';
			if (!empty($customerlist)){
				$stat_data = array();
				foreach ((array)$customerlist as $k=>$v){
					$customerlist_new[$v['monthval']] = $v['num'];
					$countnum += intval($v['num']);
					$stat_data[$v['monthval']-1] = array('value'=>$v['num'],'label'=>$v['monthval'].Language::get('bp_index_month'));
				}
				for($i=1;$i<=12;$i++){
					if (!isset($customerlist_new[$i])){
						$customerlist_new[$i] = 0;
						$stat_data[$i-1] = array('value'=>0,'label'=>$i.Language::get('bp_index_month'));
					}
				}
				ksort($stat_data);
	  			$newcustomer_stat_json = getStatData_Column2D($year.Language::get('bp_index_in_statistics_monthly_new_members'),Language::get('bp_index_a_new_membership'),$stat_data,'integer');
			}
			Tpl::output('newcustomer_stat_json',$newcustomer_stat_json);
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('index');
	}
}