<?php
/**
 * 统计图表功能
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdata_statduserControl extends exportdataControl{
	private $commonwhere=array();
	private $where_arr = array();
	private $exporttype='excel';

	public function __construct($type,$where_arr = array(),$exporttype='excel'){
		parent::__construct();
        Language::read('exportdata_statduser');
		$this->exporttype = $exporttype;

		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['user_department'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['user_id'] = $_SESSION['member_id'];
		}

		$this->where_arr = $where_arr;
	}
	/*
	 * 员工状态分布
	 */
	public function statuser_state(){
		return $this->typestat('state');
	}
	/*
	 * 员工学历分布
	 */
	public function statuser_education(){
		return $this->typestat('education');
	}
	/*
	 * 员工性别分布
	 */
	public function statuser_sex(){
		return $this->typestat('sex');
	}
	/*
	 * 员工固定类型统计
	 */
	private function typestat($stattype){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['uex_entrytime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['uex_entrytime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['uex_entrytime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$dataformat = 'integer';
		$type_desc = Language::get('bp_exportdata_statduser_the_number');
		$field ='count(*) as num';
		switch($stattype){
			case 'education':
				$field .=',uex_education as stattext';
				$caption = Language::get('bp_exportdata_statduser_employees_degree_distribution');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statduser_record_of_formal_schooling'),'valuetitle'=>Language::get('bp_exportdata_statduser_the_number'));
				$typetext_arr = array(0=>Language::get('bp_exportdata_statduser_the_unknown'),1=>Language::get('bp_exportdata_statduser_primary_school'),2=>Language::get('bp_exportdata_statduser_junior_high_school'),3=>Language::get('bp_exportdata_statduser_technical_secondary_school'),4=>Language::get('bp_exportdata_statduser_senior_high_school'),5=>Language::get('bp_exportdata_statduser_college_degree'),6=>Language::get('bp_exportdata_statduser_undergraduate_course'),7=>Language::get('bp_exportdata_statduser_masters_degree'),8=>Language::get('bp_exportdata_statduser_dr.'),9=>Language::get('bp_exportdata_statduser_other'));
				$where['user_state'] = array('neq',2);
				break;
			case 'state':
				$field .=',user_state as stattext';
				$caption = Language::get('bp_exportdata_statduser_employee_status_distribution');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statduser_state'),'valuetitle'=>Language::get('bp_exportdata_statduser_the_number'));
				$typetext_arr = array(0=>Language::get('bp_exportdata_statduser_on-the-job'),1=>Language::get('bp_exportdata_statduser_the_suspension'),2=>Language::get('bp_exportdata_statduser_departure'));
				break;
			case 'sex':
				$field .=',uex_sex as stattext';
				$caption = Language::get('bp_exportdata_statduser_employees_gender_distribution');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statduser_gender'),'valuetitle'=>Language::get('bp_exportdata_statduser_the_number'));
				$typetext_arr = array(0=>Language::get('bp_exportdata_statduser_the_unknown'),1=>Language::get('bp_exportdata_statduser_female'),2=>Language::get('bp_exportdata_statduser_male'));
				$where['user_state'] = array('neq',2);
				break;
		}
		$statlist = $model->table('user,userextend')->field($field)->join('left')->on('user.user_id = userextend.uex_userid')->where($where)->group('stattext')->select();
		$stat_json = '';
		$statlist_new = array();
		foreach((array)$statlist as $k=>$v){
			if ($v['stattext']){
				$statlist_new[$v['stattext']] = $v;
			}else{
				$statlist_new[0] = $v;
			}
		}
		foreach ((array)$typetext_arr as $k=>$v){
			if (isset($statlist_new[$k])){
				$tmp['value'] = $statlist_new[$k]['num'];
			}else {
				$tmp['value'] = 0;
			}
			$tmp['text'] = $v;
			$statlist_new[$k] = $tmp;
		}
		ksort($statlist_new);
		if ($this->exporttype == 'pdf'){
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$stat_data[] = array('value'=>$v['value'],'label'=>$v['text']);
			}
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			return array('column2d',$stat_json);
		} else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
			//data
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/*
	 * 员工地区分布
	 */
	public function statuser_area(){
		$model = Model();
		$where = $this->commonwhere;
		$where['user_state'] = array('neq',2);
		//搜索条件
		if($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['uex_entrytime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['uex_entrytime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['uex_entrytime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field = ' uex_province as stattext,count(*) as statvalue ';
		$caption = Language::get('bp_exportdata_statduser_regional_distribution_of_employees1');
		$type_desc = Language::get('bp_exportdata_statduser_the_number');
		$on = 'user.user_id = userextend.uex_userid';
		$statlist = $model->table('user,userextend')->field($field)->join('left')->on($on)->where($where)->group('stattext')->order('uex_entrytime')->select();
		$statlist_new = array();
		foreach((array)$statlist as $k=>$v){
			if (empty($v['stattext'])){
				$k_new = Language::get('bp_exportdata_statduser_other');
			}else {
				$k_new = $v['stattext'];
			}
			$statlist_new[$k_new]['value'] += ncPriceFormat($v['statvalue']);
		}
		if ($this->exporttype == 'pdf'){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach ((array)$statlist_new as $k=>$v){
				$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>($v['value']>0?$v['value']:0));
				$i++;
			}
			$stat_json = getStatData_Pie2D($caption,$stat_data);
			return array('pie2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statduser_area'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$k);
				$tmp[] = array('format'=>'Number','data'=>($v['value']>0?$v['value']:0));
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/*
	 * 员工拥有机会数量前20名
	 */
	public function statuser_chancenumtop(){
		return $this->statuserrelevantdata('chancenum','top');
	}
	/*
	 * 员工拥有机会数量后20名
	 */
	public function statuser_chancenumlower(){
		return $this->statuserrelevantdata('chancenum','lower');
	}
	/*
	 * 员工行动历史数量前20名
	 */
	public function statuser_historynumtop(){
		return $this->statuserrelevantdata('historynum','top');
	}
	/*
	 * 员工行动历史数量后20名
	 */
	public function statuser_historynumlower(){
		return $this->statuserrelevantdata('historynum','lower');
	}
	/*
	 * 员工会员数统计
	 */
	private function statuserrelevantdata($stattype,$order){
		$model = Model();
		$where = $this->commonwhere;
		$where['user_state'] = array('neq',2);
		$field = ' user_truename as stattext,user_id';
		switch($stattype){
			case 'chancenum':
				$caption = Language::get('bp_exportdata_statduser_employees_have_the_opportunity');
				$type_desc = Language::get('bp_exportdata_statduser_the_number');
				$table = 'chance,user';
				$on = 'chance.cha_userid = user.user_id';
				$field .=",count(*) as statvalue ";
				$dataformat = 'integer';
				//搜索条件
				if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
					$where['cha_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
				}elseif($this->where_arr['stime'] > 0){
					$where['cha_addtime'] = array('egt',"{$this->where_arr['stime']}");
				}elseif($this->where_arr['etime']>0){
					$where['cha_addtime'] = array('elt',"{$this->where_arr['etime']}");
				}
				$where['cha_istrash'] = 0;
				break;
			case 'historynum':
				$caption = Language::get('bp_exportdata_statduser_employee_number_operation_history');
				$type_desc = Language::get('bp_exportdata_statduser_the_number');
				$table = 'customer_action,user';
				$on = 'customer_action.cca_excstaff = user.user_id';
				$field .=",count(*) as statvalue ";
				$dataformat = 'integer';
				//搜索条件
				if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
					$where['cca_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
				}elseif($this->where_arr['stime'] > 0){
					$where['cca_addtime'] = array('egt',"{$this->where_arr['stime']}");
				}elseif($this->where_arr['etime']>0){
					$where['cca_addtime'] = array('elt',"{$this->where_arr['etime']}");
				}
				break;
		}
		if($order == 'top'){
			$ordertext = 'statvalue desc';
			$caption .= Language::get('bp_exportdata_statduser_the_top_20');
		}else{
			$ordertext = 'statvalue asc';
			$caption .= Language::get('bp_exportdata_statduser_after_20');
		}
		$statlist = $model->table($table)->field($field)->join('inner')->on($on)->where($where)->group('user_id')->order($ordertext)->select();
		$stat_json = '';

		$i = 1;
		foreach((array)$statlist as $k=>$v){
			$tmp['text'] = $v['stattext'];
			if($dataformat == 'money'){
				$tmp['value'] = ncPriceFormat($v['statvalue']);
			}else{
				$tmp['value'] = $v['statvalue'];
			}
			$tmp['order'] = $i;
			$statlist_new[] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			$i++;
		}
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,'integer');
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statduser_sorting'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statduser_employees'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['order']);
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
}