<?php
/**
 * 统计图表功能
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdata_statdtrackingControl extends exportdataControl{
	private $commonwhere=array();
	private $where_arr = array();
	private $exporttype='excel';

	public function __construct($type,$where_arr = array(),$exporttype='excel'){
		parent::__construct();
        Language::read('exportdata_statdtracking');
		$this->exporttype = $exporttype;
		$history_typearr = array('historytype','historynumtop','monthlyhistory');
		if (in_array($_GET['type'],$history_typearr)){
			if($_SESSION['shop_id']){
				$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
			}
		}
		$this->where_arr = $where_arr;
	}
	/*
	 * 行动历史类型统计
	 */
	public function stattracking_historytype(){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['cca_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['cca_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['cca_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$tableheader = array();
		$dataformat = 'integer';
		$field ='cca_ismission,count(*) as num';
		$caption = Language::get('bp_exportdata_statdtracking_action_history_type_distribution');
		$type_desc = Language::get('bp_exportdata_statdtracking_the_number');
		$tableheader = array('typetitle'=>Language::get('bp_exportdata_statdtracking_type'),'valuetitle'=>Language::get('bp_exportdata_statdtracking_the_number'));
		$actionstat = $model->table('customer_action,customer')->join('left')->on('customer_action.cc_id = customer.cc_id')->field($field)->where($where)->group('cca_ismission')->select();
		$stat_json = '';
		$actionstat_new = array();
		foreach((array)$actionstat as $k=>$v){
			$actionstat_new[$v['cca_ismission']] = $v;
		}
		for ($i=0;$i<3;$i++){
			if (isset($actionstat_new[$i])){
				$tmp['value'] = $actionstat_new[$i]['num'];
			}else {
				$tmp['value'] = 0;
			}
			switch($i){
				case 0:
					$tmp['text'] = Language::get('bp_exportdata_statdtracking_the_schedule');
					break;
				case 1:
					$tmp['text'] = Language::get('bp_exportdata_statdtracking_the_task');
					break;
				case 2:
					$tmp['text'] = Language::get('bp_exportdata_statdtracking_member_of_the_care');
					break;
			}
			$actionstat_new[$i] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($actionstat_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			return array('column2d',$stat_json);
		} else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
			//data
			foreach ((array)$actionstat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 日程类型统计
	 */
	public function stattracking_scheduletype(){
		$model = Model();
		if ($_SESSION['shop_id']){
			$where['shop_id'] = $_SESSION['shop_id'];
		}
		//添加时间搜索
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['cs_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['cs_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['cs_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field ='cs_type as stattext,count(*) as statvalue';
		$schedulestat = $model->table('schedule,customer')->join('left')->on('schedule.cc_id = customer.cc_id')->field($field)->where($where)->group('cs_type')->order('cs_addtime')->select();
		$excel_data = $this->dictionarystat('scheduletype',$schedulestat);
		return $excel_data;
	}
	/**
	 * 订单数据字典相关数据统计
	 */
	private function dictionarystat($type,$statlist){
		$model = Model();
		//数据字典字段与数据库字段对应
		switch ($type){
			case 'scheduletype':
				$dic_key = 'mission_type';
				$caption = Language::get('bp_exportdata_statdtracking_the_schedule_type_distribution');
				$type_desc = Language::get('bp_exportdata_statdtracking_the_number');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statdtracking_type'),'valuetitle'=>Language::get('bp_exportdata_statdtracking_the_number'));
				$dateformat = 'integer';
				break;
		}
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			return array();
		}
		$stat_json = '';
		$statlist_new = array();
		foreach((array)$statlist as $k=>$v){
			if ($dateformat == 'money'){
				$v['statvalue'] = ncPriceFormat($v['statvalue']);
			}
			if (empty($v['stattext'])){
				$statlist_new[0] = array('text'=>Language::get('bp_exportdata_statdtracking_empty'),'value'=>$v['statvalue']);
				$stat_data[] = array('value'=>$v['statvalue'],'label'=>Language::get('bp_exportdata_statdtracking_empty'));
			}else {
				$statlist_new[$v['stattext']] = $v;
			}
		}
		foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
			$tmp = array();
			$tmp['text'] = $v['cd_name'];
			if (isset($statlist_new[$k])){
				$tmp['value'] = $statlist_new[$k]['statvalue'];
			}else{
				$tmp['value'] = 0;
			}
			$statlist_new[$k] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($statlist_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
			//data
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}

	/**
	 * 月度行动历史统计
	 */
	public function stattracking_monthlyhistory(){
		$model = Model();
		$where = $this->commonwhere;
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['cca_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['cca_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['cca_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field = 'cca_addtime,YEAR(FROM_UNIXTIME(cca_addtime)) as yearval,MONTH(FROM_UNIXTIME(cca_addtime)) as monthval,count(*) as statvalue';
		$statlist = $model->table('customer_action,customer')->join('left')->on('customer_action.cc_id = customer.cc_id')->field($field)->where($where)->group('monthval')->order('cca_addtime asc')->select();
		$statlistnew = array();
		if(!empty($statlist)){
			foreach((array)$statlist as $k=>$v){
				$statlistnew[$v['monthval']] = $v;
			}
		}
		return $this->statShowByMonth('monthlyhistory',$statlistnew,$year);
	}
	/**
	 * 按照月份显示统计信息
	 */
	private function statShowByMonth($type,$statlist,$year){
		$caption = '';
		$type_desc = '';
		switch ($type){
			case 'monthlyhistory':
				$caption = Language::get('bp_exportdata_statdtracking_historical_statistics_monthly_operations');
				$type_desc = Language::get('bp_exportdata_statdtracking_the_number');
				$dateformat = 'integer';
				break;
		}
		if ($this->exporttype == 'pdf'){
			foreach ((array)$statlist as $k=>$v){
				if ($dateformat == 'money'){
					$v['value'] = ncPriceFormat($v['statvalue']);
				}else {
					$v['value'] = $v['statvalue'];
				}
				$stat_data[] = array('value'=>$v['value'],'label'=>($v['yearval'].'-'.$v['monthval']));
			}
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			return array('column2d',$stat_json);
		} else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdtracking_in'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['yearval'].'-'.$v['monthval']);
				if ($dateformat == 'money'){
					$v['value'] = ncPriceFormat($v['statvalue']);
				}else {
					$v['value'] = $v['statvalue'];
				}
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
}