<?php
/**
 * 数据导出之销售统计
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdata_statdsalesControl extends exportdataControl{
	private $commonwhere=array();
	private $where_arr = array();
	private $exporttype='excel';

	public function __construct($type,$where_arr = array(),$exporttype='excel'){
		parent::__construct();
        Language::read('exportdata_statdsales');
		$this->exporttype = $exporttype;

		$model = Model();
		//按照订单统计数据
		$order_typearr = array('statenum','stateamount','ordertype','ordertypemoney','ordernum','ordersaleroom','orderprofity','amountinterval');
		if (in_array($type,$order_typearr)){
			if ($_SESSION['shop_id']){
				$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
			}elseif (intval($_GET['shopid']) > 0) {
				$this->commonwhere['shop_id'] = intval($_GET['shopid']);
			}
		}
		//按照订单统计数据并且使用多表联查
		$order_typejoinarr = array('paymethod','areanum','areasaleroom','areaatv');
		if (in_array($type,$order_typejoinarr)){
			if ($_SESSION['shop_id']){
				$this->commonwhere['orders.shop_id'] = $_SESSION['shop_id'];
			}elseif (intval($_GET['shopid']) > 0) {
				$this->commonwhere['orders.shop_id'] = intval($_GET['shopid']);
			}
		}
		$this->where_arr = $where_arr;
	}
	/**
	 * 订单状态分布
	 */
	public function statsales_statenum(){
		$excel_data = $this->orderstate_stat('num');
		return $excel_data;
	}
	/**
	 * 订单状态金额分布
	 */
	public function statsales_stateamount(){
		$excel_data = $this->orderstate_stat('amount');
		return $excel_data;
	}
	/**
	 * 订单状态统计
	 */
	private function orderstate_stat($type){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['stime']>0){
			$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$tableheader = array();
		$dataformat = 'integer';
		$field = 'co_status';
		switch ($type){
			case 'num':
				$field .=',count(*) as num';
				$caption = Language::get('bp_exportdata_statdsales_distribution_of_the_order_status');
				$type_desc = Language::get('bp_exportdata_statdsales_the_order_quantity');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statdsales_state'),'valuetitle'=>Language::get('bp_exportdata_statdsales_the_number'));
				break;
			case 'amount':
				$field .=',sum(co_final_price) as amount';
				$caption = Language::get('bp_exportdata_statdsales_distribution_for_the_amount_of_the_order_status');
				$type_desc = Language::get('bp_exportdata_statdsales_the_order_amount');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statdsales_state'),'valuetitle'=>Language::get('bp_exportdata_statdsales_the_amount'));
				$dataformat = 'money';
				break;
		}
		$orderstat = $model->table('orders')->field($field)->where($where)->group('co_status')->select();
		$orderstat_new = array();
		foreach((array)$orderstat as $k=>$v){
			$orderstat_new[$v['co_status']] = $v;
		}
		for ($i=0;$i<=3;$i++){
			if (isset($orderstat_new[$i])){
				if ($dataformat == 'money'){
					$tmp['value'] = ncPriceFormat($orderstat_new[$i][$type]);
				}else {
					$tmp['value'] = $orderstat_new[$i][$type];
				}
			}else {
				$tmp['value'] = 0;
			}
			switch($i){
				case 0:
					$tmp['text'] = Language::get('bp_exportdata_statdsales_the_execution_of');
					break;
				case 1:
					$tmp['text'] = Language::get('bp_exportdata_statdsales_end_of_the');
					break;
				case 2:
					$tmp['text'] = Language::get('bp_exportdata_statdsales_crashes,');
					break;
				case 3:
					$tmp['text'] = Language::get('bp_exportdata_statdsales_to_cancel');
					break;
			}
			$orderstat_new[$i] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($orderstat_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
			//data
			foreach ((array)$orderstat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 订单类型统计
	 */
	public function statsales_ordertype(){
		$excel_data = $this->dictionarystat('ordertype','sales_ordertype');
		return $excel_data;
	}
	/**
	 * 订单类型金额分布
	 */
	public function statsales_ordertypemoney(){
		$excel_data = $this->dictionarystat('ordertype','sales_ordertypemoney');
		return $excel_data;
	}
	/**
	 * 订单数据字典相关数据统计
	 */
	private function dictionarystat($dic_key,$menukey){
		$model = Model();
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			return array();
		}
		$table = 'orders';
		$where = $this->commonwhere;
		//数据字典字段与数据库字段对应
		switch ($menukey){
			case 'sales_ordertype':
				$caption = Language::get('bp_exportdata_statdsales_order_type_distribution1');
				$type_desc = Language::get('bp_exportdata_statdsales_the_order_number');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statdsales_type'),'valuetitle'=>Language::get('bp_exportdata_statdsales_the_number'));
				$dateformat = 'integer';
				$field = 'co_type as stattext,count(*) as statvalue';
				//搜索条件
				$where['co_status'] = array('neq',3);
				if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
					$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
				}elseif($this->where_arr['stime'] > 0){
					$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
				}elseif($this->where_arr['etime']>0){
					$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
				}
				break;
			case 'sales_ordertypemoney':
				$caption = Language::get('bp_exportdata_statdsales_order_type_distribution');
				$type_desc = Language::get('bp_exportdata_statdsales_the_amount');
				$tableheader = array('typetitle'=>Language::get('bp_exportdata_statdsales_type'),'valuetitle'=>Language::get('bp_exportdata_statdsales_the_amount'));
				$dateformat = 'money';
				$field = 'co_type as stattext,sum(co_final_price) as statvalue';
				//搜索条件
				$where['co_status'] = array('neq',3);
				if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
					$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
				}elseif($this->where_arr['stime'] > 0){
					$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
				}elseif($this->where_arr['etime']>0){
					$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
				}
				break;
		}
		if (empty($join)){
			$statlist = $model->table($table)->field($field)->where($where)->group('stattext')->select();
		}else {
			$statlist = $model->table($table)->field($field)->join($join)->on($on)->where($where)->group('stattext')->select();
		}
		$statlist_new = array();
		$stat_json = '';
		foreach((array)$statlist as $k=>$v){
			if ($dateformat == 'money'){
				$v['statvalue'] = ncPriceFormat($v['statvalue']);
			}
			if (empty($v['stattext'])){
				$statlist_new[0] = array('text'=>Language::get('bp_exportdata_statdsales_empty'),'value'=>$v['statvalue']);
				$stat_data[] = array('value'=>$v['statvalue'],'label'=>Language::get('bp_exportdata_statdsales_empty'));
			}else {
				$statlist_new[$v['stattext']] = $v;
			}
		}
		foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
			$tmp = array();
			$tmp['text'] = $v['cd_name'];
			if (isset($statlist_new[$k])){
				$tmp['value'] = $statlist_new[$k]['statvalue'];
			}else{
				$tmp['value'] = 0;
			}
			$statlist_new[$k] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($statlist_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['typetitle']);
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$tableheader['valuetitle']);
			//data
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 销量月份统计
	 */
	public function statsales_orderprofity(){
		$statlist = $this->getmonthsalestat('orderprofity');
		$excel_data = $this->statShowByMonth('orderprofity',$statlist);
		return $excel_data;
	}
	/*
	 * 销售额月份统计
	 */
	public function statsales_ordersaleroom(){
		$statlist = $this->getmonthsalestat('ordersaleroom');
		$excel_data = $this->statShowByMonth('ordersaleroom',$statlist);
		return $excel_data;
	}
	/**
	 * 毛利润月份统计
	 */
	public function statsales_ordernum(){
		$statlist = $this->getmonthsalestat('ordernum');
		$excel_data = $this->statShowByMonth('ordernum',$statlist);
		return $excel_data;
	}
	/*
	 * 获得某年月销售额统计
	 */
	private function getmonthsalestat($type){
		$model = Model();
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field = 'co_addtime,YEAR(FROM_UNIXTIME(co_addtime)) as yearval,MONTH(FROM_UNIXTIME(co_addtime)) as monthval';
		switch ($type){
			case 'orderprofity':
				$field .= ',sum(co_final_price-co_cost_price) as statvalue';
				break;
			case 'ordersaleroom':
				$field .= ',sum(co_final_price) as statvalue';
				break;
			case 'ordernum':
				$field .= ',count(*) as statvalue';
				break;
		}
		$statlist = $model->table('orders')->field($field)->where($where)->group('yearval,monthval')->order('co_addtime')->select();
		$statlistnew = array();
		if(!empty($statlist)){
			foreach((array)$statlist as $k=>$v){
				$tmp = array();
				$tmp['text'] = $v['yearval'].'-'.$v['monthval'];
				$tmp['value'] = $v['statvalue'];
				$statlistnew[] = $tmp;
			}
		}
		return $statlistnew;
	}
	/**
	 * 按照月份显示统计信息
	 */
	private function statShowByMonth($type,$statlist){
		$type_desc = '';
		$caption = '';
		switch ($type){
			case 'ordernum':
				$caption = Language::get('bp_exportdata_statdsales_monthly_sales_statistics');
				$type_desc = Language::get('bp_exportdata_statdsales_the_number');
				$dateformat = 'integer';
				break;
			case 'ordersaleroom':
				$caption = Language::get('bp_exportdata_statdsales_monthly_sales_statistics1');
				$type_desc = Language::get('bp_exportdata_statdsales_the_amount');
				$dateformat = 'money';
				break;
			case 'orderprofity':
				$caption = Language::get('bp_exportdata_statdsales_gross_monthly_statistics');
				$type_desc = Language::get('bp_exportdata_statdsales_the_amount');
				$dateformat = 'money';
				break;
		}
		$stat_json = '';
		if ($this->exporttype == 'pdf'){
			$stat_data = array();
			foreach ((array)$statlist as $k=>$v){
				$stat_data[] = array('value'=>$v['value'],'label'=>$v['text']);
			}
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dateformat);
			return array('column2d',$stat_json);
		} else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdsales_in'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 订单区域分布
	 */
	public function statsales_areanum(){
		$excel_data = $this->getAreaSalestat('areanum');
		return $excel_data;
	}
	/**
	 * 订单区域统计
	 */
	private function getAreaSalestat($type){
		$model = Model();
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		//搜索条件
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field = ' cc_province as stattext ';
		switch ($type){
			case 'areanum':
				$field .= ' ,count(*) as statvalue ';
				$caption = Language::get('bp_exportdata_statdsales_regional_distribution_of_the_order');
				$type_desc = Language::get('bp_exportdata_statdsales_the_number');
				$dataformat = 'integer';
				break;
			case 'areasaleroom':
				$field .= ' ,sum(co_final_price) as statvalue ';
				$caption = Language::get('bp_exportdata_statdsales_regional_distribution_of_sales_orders');
				$type_desc = Language::get('bp_exportdata_statdsales_the_amount');
				$dataformat = 'money';
				break;
			case 'areaatv'://客单价
				$field .= ' ,sum(co_final_price)/count(*) as statvalue';
				$caption = Language::get('bp_exportdata_statdsales_regional_distribution_of_guest_unit_price');
				$type_desc = Language::get('bp_exportdata_statdsales_the_amount');
				$dataformat = 'money';
				break;
		}
		$on = 'orders.cc_id = customer.cc_id';
		$orderlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($where)->group('stattext')->order('co_addtime asc')->select();
		$statlist = array();
		if(!empty($orderlist)){
			foreach((array)$orderlist as $k=>$v){
				if (empty($v['stattext'])){
					$k_new = Language::get('bp_exportdata_statdsales_other');
				}else {
					$k_new = $v['stattext'];
				}
				$statlist[$k_new]['value'] += $v['statvalue'];
			}
		}
		foreach ((array)$statlist as $k=>$v){
			if ($dataformat == 'integer'){
				$statlist[$k]['value'] = intval($v['value']);
			}else {
				$statlist[$k]['value'] = ncPriceFormat($v['value']);
			}
		}
		if ($this->exporttype == 'pdf'){
			//构造颜色数组
			$color_arr = getColorArr(50);
			$i = 0;
			foreach ((array)$statlist as $k=>$v){
				$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>$v['value']);
				$i++;
			}
			$stat_json = getStatData_Pie2D($caption,$stat_data);
			return array('pie2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdsales_area'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$k);

				$tmp[] = array('format'=>'Number','data'=>($v['value']>0?$v['value']:0));
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 订单销售额区域分布
	 */
	public function statsales_areasaleroom(){
		$excel_data = $this->getAreaSalestat('areasaleroom');
		return $excel_data;
	}
	/**
	 * 订单客单价区域分布
	 */
	public function statsales_areaatv(){
		$model = Model();
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		//搜索条件
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field = ' cc_province as stattext,sum(co_final_price)/count(*) as statvalue';
		$on = 'orders.cc_id = customer.cc_id';
		$orderlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($where)->group('stattext')->order('co_addtime asc')->select();
		$orderlist_new = array();
		$caption = Language::get('bp_exportdata_statdsales_regional_distribution_of_guest_unit_price');
		$type_desc = Language::get('bp_exportdata_statdsales_the_guest_unit_price');
		foreach((array)$orderlist as $k=>$v){
			if (!empty($v['stattext'])){
				$tmp = array();
				$tmp['text'] = $v['stattext'];
				$tmp['value'] = ncPriceFormat($v['statvalue']);
				$statlist[] = $tmp;
				$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
			}
		}
		if ($this->exporttype == 'pdf'){
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data);
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdsales_provinces_and_cities'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/*
	 * 订单金额分布范围
	 */
	public function statsales_amountinterval(){
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		$where['co_status'] = array('neq',3);
		//搜索条件
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array['orderamountinterval'])){
			return array();
		}
		$interval_new = array();
		foreach ((array)$dic_array['orderamountinterval']['child_option'] as $k=>$v){
			$interval_new[] = $v['cd_name'];
		}
		for($i=0;$i <= count($interval_new);$i++){
			$statvalue_name = 'statvalue'.$i;
			if($i==0){
				$field = "sum(IF(co_final_price <= {$interval_new[$i]},1,0)) as {$statvalue_name}";
			}elseif($i == count($interval_new)){
				$field .= ",sum(IF(co_final_price > {$interval_new[$i-1]},1,0)) as {$statvalue_name}";
			}else{
				$field .= ",sum(IF(co_final_price > {$interval_new[$i-1]} and co_final_price <= {$interval_new[$i]},1,0)) as {$statvalue_name}";
			}
		}
		$orderlist = $model->table('orders')->field($field)->where($where)->find();
		$statlist = array();
		if (count($interval_new)>0){
			$stat_data = array();
			for($i=0;$i <= count($interval_new);$i++){
				if($i==0){
					$keynew = '0-'.$interval_new[$i];
				}elseif($i == count($interval_new)){
					$keynew = $interval_new[$i-1].Language::get('bp_exportdata_statdsales_the_above');
				}else{
					$keynew = $interval_new[$i-1].'-'.$interval_new[$i];
				}
				$statlist[] = array('text'=>$keynew,'value'=>intval($orderlist['statvalue'.$i]));
				$stat_data[] = array('value'=>$orderlist['statvalue'.$i],'label'=>$keynew);
			}
			if ($this->exporttype == 'pdf'){
				//得到统计图数据
				$stat_json = getStatData_Column2D(Language::get('bp_exportdata_statdsales_order_amount_range_distribution'),Language::get('bp_exportdata_statdsales_the_number'),$stat_data,'integer');
				return array('column2d',$stat_json);
			} else {
				$excel_data = array();
				//header
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdsales_scope_of_the'));
				$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdsales_the_number'));
				//data
				foreach ((array)$statlist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>$v['text']);
					$tmp[] = array('format'=>'Number','data'=>$v['value']);
					$excel_data[] = $tmp;
				}
				return $excel_data;
			}
		} else {
			return array();
		}
	}
}