<?php
/**
 * 统计图表功能
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdata_statdproductControl extends exportdataControl{
	private $commonwhere=array();
	private $where_arr = array();
	private $exporttype='excel';

	public function __construct($type,$where_arr = array(),$exporttype='excel'){
		parent::__construct();
        Language::read('exportdata_statdproduct');
		$this->exporttype = $exporttype;
		$this->where_arr = $where_arr;
	}
	/*
	 * 商品销量前20名
	 */
	public function statproduct_ordernumtop(){
		return $this->statproductrelevantdata('ordernum','top');
	}
	/*
	 * 商品销量后20名
	 */
	public function statproduct_ordernumlower(){
		return $this->statproductrelevantdata('ordernum','lower');
	}
	/*
	 * 商品销售额前20名
	 */
	public function statproduct_orderamounttop(){
		return $this->statproductrelevantdata('orderamount','top');
	}
	/*
	 * 商品销售额后20名
	 */
	public function statproduct_orderamountlower(){
		return $this->statproductrelevantdata('orderamount','lower');
	}
	/*
	 * 商品毛利润前20名
	 */
	public function statproduct_orderprofitytop(){
		return $this->statproductrelevantdata('orderprofity','top');
	}
	/*
	 * 商品毛利润后20名
	 */
	public function statproduct_orderprofitylower(){
		return $this->statproductrelevantdata('orderprofity','lower');
	}
	/*
	 * 员工会员数统计
	 */
	private function statproductrelevantdata($stattype,$order){
		$model = Model('department');
		$where = array();
		$where['co_status'] = array('in',array(0,1,2));
		if ($_SESSION['shop_id']){
			$where['shop_id'] = $_SESSION['shop_id'];
		}
		//添加时间搜索
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['co_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['co_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['co_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$field = 'product.cp_id,product.cp_name as stattext';
		switch($stattype){
			case 'ordernum':
				$caption = Language::get('bp_exportdata_statdproduct_sales_of_goods');
				$type_desc = Language::get('bp_exportdata_statdproduct_the_number');
				$field .=",sum(cop_pnum) as statvalue";
				$dataformat = 'integer';
				break;
			case 'orderamount':
				$caption = Language::get('bp_exportdata_statdproduct_sales_of_goods1');
				$type_desc = Language::get('bp_exportdata_statdproduct_the_amount');
				$field .=",sum(order_product.cop_total_price) as statvalue ";
				$dataformat = 'money';
				break;
			case 'orderprofity':
				$caption = Language::get('bp_exportdata_statdproduct_commodity_gross_profit');
				$type_desc = Language::get('bp_exportdata_statdproduct_the_amount');
				$field .=",sum(order_product.cop_total_price - order_product.cp_cost*cop_pnum) as statvalue ";
				$dataformat = 'money';
				break;
		}
		if($order == 'top'){
			$ordertext = 'statvalue desc';
			$caption .= Language::get('bp_exportdata_statdproduct_the_top_20');
		}else{
			$ordertext = 'statvalue asc';
			$caption .= Language::get('bp_exportdata_statdproduct_after_20');
		}
		$table = 'order_product,orders,product';
		$on = 'order_product.co_id=orders.co_id,order_product.cp_id=product.cp_id';
		$statlist = $model->table($table)->field($field)->join('inner,inner')->on($on)->where($where)->group('product.cp_id')->order($ordertext)->select();
		$stat_json = '';
		$i = 1;
		foreach((array)$statlist as $k=>$v){
			$tmp['text'] = $v['stattext'];
			if($dataformat == 'money'){
				$tmp['value'] = ncPriceFormat($v['statvalue']);
			}else{
				$tmp['value'] = $v['statvalue'];
			}
			$tmp['order'] = $i;
			$tmp['cp_id'] = $v['cp_id'];
			$statlist_new[] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>str_cut($tmp['text'],24,'...'));
			$i++;
		}
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdproduct_sorting'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdproduct_goods'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$statlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['order']);
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
}