<?php
/**
 * 数据导出之会员统计
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdata_statdcustomerControl extends exportdataControl{
	private $commonwhere=array();
	private $exporttype='excel';

	public function __construct($type,$where_arr = array(),$exporttype='excel'){
		parent::__construct();
        Language::read('exportdata_statdcustomer');
		$this->exporttype = $exporttype;

		$model = Model();
		$cus_typearr = array('typescale','degree','cusclass','cusindustry','cusrelationship','cusfrom','cuspotentialvalue','cusprovince','cusstaffsize');
		if (in_array($type,$cus_typearr)){
			//获得所有查询共有条件
			$this->commonwhere['cc_isdel'] = 0;
			if ($_SESSION['shop_id']){//如果员工负责某店铺
				$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
			}
			if ($where_arr['stime'] > 0 && $where_arr['etime']>0){
				$this->commonwhere['cc_addtime'] = array(array('egt',"{$where_arr['stime']}"),array('elt',"{$where_arr['etime']}"),'and');
			}elseif($where_arr['stime'] > 0){
				$this->commonwhere['cc_addtime'] = array('egt',"{$where_arr['stime']}");
			}elseif($where_arr['etime']>0){
				$this->commonwhere['cc_addtime'] = array('elt',"{$where_arr['etime']}");
			}
		}
		$sales_typearr = array('cusamounttop','cusprofittop');
		if (in_array($type,$sales_typearr)){
			$this->commonwhere['co_status'] = array('in',array(0,1,2));
			if ($_SESSION['shop_id']){//如果员工负责某店铺
				$this->commonwhere['shop_id'] = $_SESSION['shop_id'];
			}
			if ($where_arr['stime'] > 0 && $where_arr['etime']>0){
				$this->commonwhere['co_addtime'] = array(array('egt',"{$where_arr['stime']}"),array('elt',"{$where_arr['etime']}"),'and');
			}elseif($where_arr['stime'] > 0){
				$this->commonwhere['co_addtime'] = array('egt',"{$where_arr['stime']}");
			}elseif($where_arr['etime']>0){
				$this->commonwhere['co_addtime'] = array('elt',"{$where_arr['etime']}");
			}
		}
		$action_typearr = array('cusactiontop');
		if (in_array($type,$action_typearr)){
			if ($_SESSION['shop_id']){//如果员工负责某店铺
				$this->commonwhere['customer.shop_id'] = $_SESSION['shop_id'];
			}
			if ($where_arr['stime'] > 0 && $where_arr['etime']>0){
				$this->commonwhere['customer_action.cca_addtime'] = array(array('egt',"{$where_arr['stime']}"),array('elt',"{$where_arr['etime']}"),'and');
			}elseif($where_arr['stime'] > 0){
				$this->commonwhere['customer_action.cca_addtime'] = array('egt',"{$where_arr['stime']}");
			}elseif($where_arr['etime']>0){
				$this->commonwhere['customer_action.cca_addtime'] = array('elt',"{$where_arr['etime']}");
			}
		}
	}
	/*
	 * 各个会员特殊类型占会员总数比例统计
	 */
	public function statcustomer_typescale(){
		$model = Model();
		$field = " count(*) as allnum,sum(IF(cc_insea = 1,1,0)) as seanum,sum(IF(cc_ispotential = 1,1,0)) as potentialnum,sum(IF(cc_type = 1,1,0)) as companynum,sum(IF(cc_type = 2,1,0)) as personalnum";
		$customerstat = $model->table('customer')->field($field)->where($this->commonwhere)->find();
		$customerstat_new = array();
		$stat_data = array();
		foreach((array)$customerstat as $k=>$v){
			$tmp['value'] = $v>0?$v:0;
			switch($k){
				case 'allnum':
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_the_total_membership');
					break;
				case 'seanum':
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_member_of_the_high_seas');
					break;
				case 'potentialnum':
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_a_potential_member_of');
					break;
				case 'companynum':
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_corporate_member');
					break;
				case 'personalnum':
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_individual_members');
					break;
			}
			if($customerstat['allnum'] >0){
				$tmp['rate'] = round($v/$customerstat['allnum']*100,2).'%';
			}else{
				$tmp['rate'] = "0%";
			}
			$customerstat_new[] = $tmp;
			$stat_data[] = array('value'=>$v,'label'=>$tmp['text']);
		}
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D(Language::get('bp_exportdata_statdcustomer_member_type_total_proportion'),Language::get('bp_exportdata_statdcustomer_membership'),$stat_data,'integer');
			return array('column2d',$stat_json);
		}else{
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_type'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_the_number'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_proportion'));
			//data
			foreach ((array)$customerstat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$tmp[] = array('data'=>$v['rate']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}

	}
	/**
	 * 会员信用等级分布
	 */
	public function statcustomer_degree(){
		$model = Model();
		$customerstat = $model->table('customer')->field("cc_credit_degree,count(*) as allnum")->where($this->commonwhere)->group('cc_credit_degree')->select();
		$customerstat_new = array();
		foreach((array)$customerstat as $k=>$v){
			$customerstat_new[$v['cc_credit_degree']] = $v;
		}
		$stat_data = array();
		for ($i=1;$i<=3;$i++){
			if (isset($customerstat_new[$i])){
				$tmp['value'] = $customerstat_new[$i]['allnum'];
			}else {
				$tmp['value'] = 0;
			}
			switch($i){
				case 1:
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_low');
					break;
				case 2:
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_in_the');
					break;
				case 3:
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_high');
					break;
			}
			$customerstat_new[$i] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($customerstat_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D(Language::get('bp_exportdata_statdcustomer_membership_credit_rating_distribution'),Language::get('bp_exportdata_statdcustomer_membership'),$stat_data,'integer');
			return array('column2d',$stat_json);
		}else{
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_type'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_the_number'));
			//data
			foreach ((array)$customerstat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 会员种类分布
	 */
	public function statcustomer_cusclass(){
		$excel_data = $this->dictionarystat('customer_class','cus_class');
		return $excel_data;
	}
	/**
	 * 会员行业分布
	 */
	public function statcustomer_cusindustry(){
		$excel_data = $this->dictionarystat('industry','cus_industry');
		return $excel_data;
	}
	/**
	 * 会员关系等级分布
	 */
	public function statcustomer_cusrelationship(){
		$excel_data = $this->dictionarystat('relationship','cus_relationship');
		return $excel_data;
	}
	/**
	 * 会员来源分布
	 */
	public function statcustomer_cusfrom(){
		$excel_data = $this->dictionarystat('customer_from','cus_from');
		return $excel_data;
	}
	/**
	 * 员工规模分布
	 */
	public function statcustomer_cusstaffsize(){
		$excel_data = $this->dictionarystat('staff_size','cus_staffsize');
		return $excel_data;
	}
	/**
	 * 会员数据字典相关数据统计
	 */
	private function dictionarystat($dic_key,$menukey){
		$model = Model();
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			showDialog(Language::get('bp_exportdata_statdcustomer_data_dictionary_information_errors').Language::get('bp_comma').Language::get('bp_exportdata_statdcustomer_cannot_view_the_related_statistics'),'','error');
		}
		$table = 'customer';
		//数据字典字段与数据库字段对应
		switch ($dic_key){
			case 'customer_class':
				$data_key = 'cc_class';
				break;
			case 'industry':
				$data_key = 'cc_industry';
				break;
			case 'relationship':
				$data_key = 'cc_relationship';
				break;
			case 'customer_from':
				$data_key = 'cc_from';
				break;
			case 'staff_size':
				$data_key = 'cci_staff_size';
				$table = 'customer,company_info';
				$join = 'left';
				$on = 'company_info.cc_id = customer.cc_id';
				$this->commonwhere['cc_type'] = 1;
				break;
		}
		if (empty($join)){
			$customerstat = $model->table($table)->field("$data_key,count(*) as allnum")->where($this->commonwhere)->group($data_key)->select();
		}else {
			$customerstat = $model->table($table)->field("$data_key,count(*) as allnum")->join($join)->on($on)->where($this->commonwhere)->group($data_key)->select();
		}
		$title = $dic_array[$dic_key]['class']['cd_name'].Language::get('bp_exportdata_statdcustomer_distribution_of_the');
		$stat_json = '';
		$customerstat_new = array();
		foreach((array)$customerstat as $k=>$v){
			if (empty($v[$data_key])){
				$customerstat_new[0] = array('text'=>Language::get('bp_exportdata_statdcustomer_empty'),'value'=>(intval($customerstat_new[0]['value'])+$v['allnum']));
				$stat_data[0] = array('value'=>$customerstat_new[0]['value'],'label'=>Language::get('bp_exportdata_statdcustomer_empty'));
			}else {
				$customerstat_new[$v[$data_key]] = $v;
			}
		}
		foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
			$tmp = array();
			$tmp['text'] = $v['cd_name'];
			if (isset($customerstat_new[$k])){
				$tmp['value'] = $customerstat_new[$k]['allnum'];
			}else{
				$tmp['value'] = 0;
			}
			$customerstat_new[$k] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($customerstat_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($title,Language::get('bp_exportdata_statdcustomer_membership'),$stat_data,'integer');
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_type'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_the_number'));
			//data
			foreach ((array)$customerstat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 潜在会员潜在价值分布
	 */
	public function statcustomer_cuspotentialvalue(){
		$model = Model();
		$where = $this->commonwhere;
		$where['cc_ispotential'] = '1';
		$customerstat = $model->table('customer')->field("cc_potential_value,count(*) as allnum")->where($where)->group('cc_potential_value')->select();
		$stat_json = '';
		$customerstat_new = array();
		foreach((array)$customerstat as $k=>$v){
			$customerstat_new[$v['cc_potential_value']] = $v;
		}
		for ($i=1;$i<=3;$i++){
			if (isset($customerstat_new[$i])){
				$tmp['value'] = $customerstat_new[$i]['allnum'];
			}else {
				$tmp['value'] = 0;
			}
			switch($i){
				case 1:
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_low');
					break;
				case 2:
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_in_the');
					break;
				case 3:
					$tmp['text'] = Language::get('bp_exportdata_statdcustomer_high');
					break;
			}
			$customerstat_new[$i] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($customerstat_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D(Language::get('bp_exportdata_statdcustomer_potential_members_value_distribution'),Language::get('bp_exportdata_statdcustomer_membership'),$stat_data,'integer');
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_type'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_the_number'));
			//data
			foreach ((array)$customerstat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 会员省市分布
	 */
	public function statcustomer_cusprovince(){
		$model = Model();
		$field = 'cc_province,count(*) as num';
		$customerlist = $model->table('customer')->field($field)->where($this->commonwhere)->group('cc_province')->select();
		$customerlist_new = array();
		if (!empty($customerlist)){
			foreach ((array)$customerlist as $k=>$v){
				if (empty($v['cc_province'])){
					$k_new = Language::get('bp_exportdata_statdcustomer_other');
				}else {
					$k_new = $v['cc_province'];
				}
				$customerlist_new[$k_new]['countnum'] += intval($v['num']);
			}
		}
		$stat_json = '';
		//构造颜色数组
		$color_arr = getColorArr(50);
		$i = 0;
		foreach ((array)$customerlist_new as $k=>$v){
			$stat_data[] = array("color"=>$color_arr[$i],"label"=>$k,"value"=>$customerlist_new[$k]['countnum']);
			$i++;
		}
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Pie2D(Language::get('bp_exportdata_statdcustomer_member_provinces_distribution'),$stat_data);
			return array('pie2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_area'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_the_number'));
			//data
			foreach ((array)$customerlist_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$k);
				$tmp[] = array('format'=>'Number','data'=>($v['countnum']>0?$v['countnum']:0));
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 会员top20销售额统计
	 */
	public function statcustomer_cusamounttop(){
		$ordercustomerlist = $this->getyearcustomersalesstat('amount','top');
		$excel_data = $this->getyearcustomersalesstatshowdata('amount','top',$ordercustomerlist);
		return $excel_data;
	}
	/**
	 * 会员top20毛利润统计
	 */
	public function statcustomer_cusprofittop(){
		$ordercustomerlist = $this->getyearcustomersalesstat('profit','top');
		$excel_data = $this->getyearcustomersalesstatshowdata('profit','top',$ordercustomerlist);
		return $excel_data;
	}
	/**
	 * 获得某年会员销售统计展示数据
	 *
	 * @param unknown_type $year
	 * @param unknown_type $type
	 * @param unknown_type $order
	 */
	private function getyearcustomersalesstatshowdata($type,$order,$customerlist){
		$stat_json = '';
		$caption = '';
		$type_desc = '';
		$dataformat = 'money';
		switch ($type){
			case 'amount':
				$type_desc = Language::get('bp_exportdata_statdcustomer_sales');
				break;
			case 'profit':
				$type_desc = Language::get('bp_exportdata_statdcustomer_gross_profit_margin');
				break;
			case 'action':
				$type_desc = Language::get('bp_exportdata_statdcustomer_action_history');
				$dataformat = 'integer';
				break;
		}
		if ($order == 'top'){
			$caption = Language::get('bp_exportdata_statdcustomer_member_of_the').$type_desc.Language::get('bp_exportdata_statdcustomer_the_top_20');
		}else{
			$caption = Language::get('bp_exportdata_statdcustomer_member_of_the').$type_desc.Language::get('bp_exportdata_statdcustomer_after_20');
		}
		$stat_data = array();
		$customerlistnew = array();
		foreach ((array)$customerlist as $k=>$v){
			$stat_data[] = array('value'=>$v[$type],'label'=>$v['cc_name']);
			$v['statvalue'] = $v[$type];
			$customerlistnew[] = $v;
		}
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,$dataformat);
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_the_order'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdcustomer_member_name'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			//data
			foreach ((array)$customerlistnew as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['order']);
				$tmp[] = array('data'=>$v['cc_name']);
				$tmp[] = array('format'=>'Number','data'=>$v['statvalue']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 获得会员销售统计数据
	 * $year 为统计的年份
	 * $type 为查询数据类型包括销售额(amount)，毛利润(profit)
	 * $order 为查询数据排序方式包含top，lower
	 */
	private function getyearcustomersalesstat($type,$order){
		$field = 'orders.cc_id,customer.cc_name';
		switch ($type){
			case 'amount':
				$field .=",sum(co_final_price) as amount";
				$orderby = 'amount';
				break;
			case 'profit':
				$field .=",sum(co_final_price - co_cost_price) as profit";
				$orderby = 'profit';
				break;
		}
		if ($order == 'lower'){
			$orderby .= ' asc';
		}else {
			$orderby .= ' desc';
		}
		$on = 'orders.cc_id=customer.cc_id';
		$model = Model();
		$ordercustomerlist = $model->table('orders,customer')->field($field)->join('left')->on($on)->where($this->commonwhere)->group('orders.cc_id')->order($orderby)->limit(20)->select();
		$ordercustomerlistnew = array();
		if(!empty($ordercustomerlist)){
			$i=1;
			foreach((array)$ordercustomerlist as $k=>$v){
				$v['amount'] = ncPriceFormat($v['amount']);
				$v['profit'] = ncPriceFormat($v['profit']);
				$v['order'] = $i;
				$i++;
				$ordercustomerlistnew[$v['cc_id']] = $v;
			}
		}
		return $ordercustomerlistnew;
	}
	/**
	 * 会员日程行动历史前20名
	 */
	public function statcustomer_cusactiontop(){
		$model = Model();
		$field = 'customer_action.cc_id,customer.cc_name,count(*) as allnum';
		if ($order == 'lower'){
			$orderby = ' allnum asc ';
		}else {
			$orderby = ' allnum desc ';
		}
		$on = 'customer_action.cc_id=customer.cc_id';
		$actionlist = $model->table('customer_action,customer')->field($field)->join('left')->on($on)->where($this->commonwhere)->group('customer_action.cc_id')->order($orderby)->limit(20)->select();
		$actionlistnew = array();
		if(!empty($actionlist)){
			$i=1;
			foreach((array)$actionlist as $k=>$v){
				$v['action'] = $v['allnum'];
				$v['order'] = $i;
				$i++;
				$actionlistnew[$v['cc_id']] = $v;
			}
		}
		$excel_data = $this->getyearcustomersalesstatshowdata('action','top',$actionlistnew);
		return $excel_data;
	}
}