<?php
/**
 * 数据导出之销售机会统计
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdata_statdchanceControl extends exportdataControl{
	private $commonwhere= array();
	private $where_arr = array();
	private $exporttype='excel';

	public function __construct($type,$where_arr = array(),$exporttype='excel'){
		parent::__construct();
        Language::read('exportdata_statdchance');

		$this->exporttype = $exporttype;
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['cha_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['cha_userid'] = $_SESSION['member_id'];
		}
		$this->where_arr = $where_arr;
	}
	/*
	 * 机会发现时间月份统计
	 */
	public function statchance_discovery(){
		$excel_data = $this->statShowByMonth('discovery');
		return $excel_data;
	}
	/**
	 * 机会预计签单时间月份统计
	 */
	public function statchance_predictdate(){
		$excel_data = $this->statShowByMonth('predictdate');
		return $excel_data;
	}
	/**
	 * 按照月份显示统计信息
	 */
	private function statShowByMonth($type){
		$model = Model();
		//添加自定义搜索条件
		$caption = '';
		$type_desc = '';
		$field = ' count(*) as allnum';
		$where = $this->commonwhere;
		switch ($type){
			case 'discovery':
				if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
					$where['cha_discoverydate'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
				}elseif($this->where_arr['stime'] > 0){
					$where['cha_discoverydate'] = array('egt',"{$this->where_arr['stime']}");
				}elseif($this->where_arr['etime']>0){
					$where['cha_discoverydate'] = array('elt',"{$this->where_arr['etime']}");
				}
				$field .= ',cha_discoverydate,YEAR(FROM_UNIXTIME(cha_discoverydate)) as yearval,MONTH(FROM_UNIXTIME(cha_discoverydate)) as monthval ';
				$order = 'cha_discoverydate asc';
				$caption = Language::get('bp_exportdata_statdchance_monthly_opportunity_discovery_time_statistics');
				$type_desc = Language::get('bp_exportdata_statdchance_opportunity_number');
				break;
			case 'predictdate':
				if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
					$where['cha_predictdate'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
				}elseif($this->where_arr['stime'] > 0){
					$where['cha_predictdate'] = array('egt',"{$this->where_arr['stime']}");
				}elseif($this->where_arr['etime']>0){
					$where['cha_predictdate'] = array('elt',"{$this->where_arr['etime']}");
				}
				$field .= ',cha_predictdate,YEAR(FROM_UNIXTIME(cha_predictdate)) as yearval,MONTH(FROM_UNIXTIME(cha_predictdate)) as monthval ';
				$order = 'cha_predictdate asc';
				$caption = Language::get('bp_exportdata_statdchance_monthly_statistics_is_expected_to_sign_the_bill');
				$type_desc = Language::get('bp_exportdata_statdchance_opportunity_number');
				break;
		}
		$chancelist = $model->table('chance')->field($field)->where($where)->group('yearval,monthval')->order($order)->select();
		if ($this->exporttype == 'pdf'){
			$stat_json = '';
			if (!empty($chancelist)){
				foreach((array)$chancelist as $k=>$v){
					$stat_data[] = array('value'=>$v['allnum'],'label'=>($v['yearval'].'-'.$v['monthval']));
				}
				//得到统计图数据
				$stat_json = getStatData_Column2D($caption,$type_desc,$stat_data,'integer');
			}
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdchance_jan.'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>$type_desc);
			if (!empty($chancelist)){
				foreach((array)$chancelist as $k=>$v){
					$tmp = array();
					$tmp[] = array('data'=>($v['yearval'].'-'.$v['monthval']));
					$tmp[] = array('format'=>'Number','data'=>$v['allnum']);
					$excel_data[] = $tmp;
				}
			}
			return $excel_data;
		}
	}
	/**
	 * 机会状态统计
	 */
	public function statchance_state(){
		$model = Model();
		$where = $this->commonwhere;
		//添加时间搜索
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['cha_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['cha_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($this->where_arr['etime']>0){
			$where['cha_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		$chancestat = $model->table('chance')->field("cha_state,count(*) as allnum")->where($where)->group('cha_state')->select();
		$chancestat_new = array();
		foreach((array)$chancestat as $k=>$v){
			$chancestat_new[$v['cha_state']] = $v;
		}
		for ($i=0;$i<=4;$i++){
			if (isset($chancestat_new[$i])){
				$tmp['value'] = $chancestat_new[$i]['allnum'];
			}else {
				$tmp['value'] = 0;
			}
			switch($i){
				case 0:
					$tmp['text'] = Language::get('bp_exportdata_statdchance_tracking');
					break;
				case 1:
					$tmp['text'] = Language::get('bp_exportdata_statdchance_success');
					break;
				case 2:
					$tmp['text'] = Language::get('bp_exportdata_statdchance_failure');
					break;
				case 3:
					$tmp['text'] = Language::get('bp_exportdata_statdchance_put_on_hold');
					break;
				case 4:
					$tmp['text'] = Language::get('bp_exportdata_statdchance_failure1');
					break;
			}
			$chancestat_new[$i] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($chancestat_new);
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D(Language::get('bp_exportdata_statdchance_opportunity_to_state_distribution'),Language::get('bp_exportdata_statdchance_opportunity_number'),$stat_data,'integer');
			return array('column2d',$stat_json);
		}else{
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdchance_state'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdchance_the_number'));
			//data
			foreach ((array)$chancestat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
	/**
	 * 机会类型统计
	 */
	public function statchance_chatype(){
		$excel_data = $this->dictionarystat('chancetype','cha_chatype');
		return $excel_data;
	}
	/**
	 * 机会来源统计
	 */
	public function statchance_source(){
		$excel_data = $this->dictionarystat('chancesource','cha_source');
		return $excel_data;
	}
	/**
	 * 机会阶段统计
	 */
	public function statchance_stage(){
		$excel_data = $this->dictionarystat('chancestage','cha_stage');
		return $excel_data;
	}
	/**
	 * 机会可能性统计
	 */
	public function statchance_probability(){
		$excel_data = $this->dictionarystat('chanceprobability','cha_probability');
		return $excel_data;
	}
	/**
	 * 机会数据字典相关数据统计
	 */
	private function dictionarystat($dic_key,$menukey){
		$model = Model();
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		if (empty($dic_array[$dic_key])){
			return array();
		}
		$table = 'chance';
		//数据字典字段与数据库字段对应
		switch ($dic_key){
			case 'chancetype':
				$data_key = 'cha_type';
				break;
			case 'chancesource':
				$data_key = 'cha_source';
				break;
			case 'chancestage':
				$data_key = 'cha_stage';
				break;
			case 'chanceprobability':
				$data_key = 'cha_probability';
				break;
		}
		//搜索条件
		$where = $this->commonwhere;
		if ($this->where_arr['stime'] > 0 && $this->where_arr['etime']>0){
			$where['cha_addtime'] = array(array('egt',"{$this->where_arr['stime']}"),array('elt',"{$this->where_arr['etime']}"),'and');
		}elseif($this->where_arr['stime'] > 0){
			$where['cha_addtime'] = array('egt',"{$this->where_arr['stime']}");
		}elseif($etime>0){
			$where['cha_addtime'] = array('elt',"{$this->where_arr['etime']}");
		}
		if (empty($join)){
			$chancestat = $model->table($table)->field("$data_key,count(*) as allnum")->where($where)->group($data_key)->select();
		}else {
			$chancestat = $model->table($table)->field("$data_key,count(*) as allnum")->join($join)->on($on)->where($where)->group($data_key)->select();
		}
		$chancestat_new = array();
		foreach((array)$chancestat as $k=>$v){
			if (empty($v[$data_key])){
				$chancestat_new[0] = array('text'=>Language::get('bp_exportdata_statdchance_empty'),'value'=>$v['allnum']);
				$stat_data[] = array('value'=>$v['allnum'],'label'=>Language::get('bp_exportdata_statdchance_empty'));
			}else{
				$chancestat_new[$v[$data_key]] = $v;
			}
		}
		foreach ((array)$dic_array[$dic_key]['child_option'] as $k=>$v){
			$tmp = array();
			$tmp['text'] = $v['cd_name'];
			if (isset($chancestat_new[$k])){
				$tmp['value'] = $chancestat_new[$k]['allnum'];
			}else{
				$tmp['value'] = 0;
			}
			$chancestat_new[$k] = $tmp;
			$stat_data[] = array('value'=>$tmp['value'],'label'=>$tmp['text']);
		}
		ksort($chancestat_new);
		$caption = $dic_array[$dic_key]['class']['cd_name'].Language::get('bp_exportdata_statdchance_distribution_of_the');
		if ($this->exporttype == 'pdf'){
			//得到统计图数据
			$stat_json = getStatData_Column2D($caption,Language::get('bp_exportdata_statdchance_opportunity_number'),$stat_data,'integer');
			return array('column2d',$stat_json);
		}else {
			$excel_data = array();
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdchance_type'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_statdchance_the_number'));
			//data
			foreach ((array)$chancestat_new as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['text']);
				$tmp[] = array('format'=>'Number','data'=>$v['value']);
				$excel_data[] = $tmp;
			}
			return $excel_data;
		}
	}
}