<?php
/**
 * 数据导出
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class exportdataControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('exportdata');
    }

	public function export_excelOp(){
		set_time_limit(0);
		if (chksubmit()){
			if(empty($_POST['m'])){
				showDialog(Language::get('bp_exportdata_please_select_a_derived_data_item'),'','error');
			}
			$where = array();
			$where['stime'] = @strtotime($_POST['search_stime']);
			$where['etime'] = @strtotime($_POST['search_etime']);
			//导出Excel
			import('excel#class');
			$excel_class = new ExcelXML(C('exportfilefont'));
			//设置样式
			$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
			//导出会员信息
			if(in_array('customer',$_POST['m']) && cPermission('customer','customer_list')){
				$excel_data = array();
				$excel_data = $this->getCustomer($where);
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_exportdata_membership_information'));
			}
			//导出销售机会
			if(in_array('chance',$_POST['m']) && cPermission('chance','chancelist')){
				$excel_data = array();
				$excel_data = $this->getChance($where);
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_exportdata_sales_opportunities'));
			}
			//导出订单数据
			if(in_array('order',$_POST['m']) && cPermission('order','order_list')){
				$excel_data = array();
				$excel_data = $this->getOrder($where);
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_exportdata_the_order_information'));
			}
			//导出商品信息
			if(in_array('product',$_POST['m']) && cPermission('product','product_list')){
				$excel_data = array();
				$excel_data = $this->getProduct($where);
				$excel_class->addArray($excel_data);
				$excel_class->addWorksheet(Language::get('bp_exportdata_commodity_information'));
			}
			//会员统计
			if(in_array('statdetail_customer',$_POST['m']) && cPermission('statdetail','statdetail_customer')){
				$sheet_arr = array();
				$sheet_arr['typescale'] = Language::get('bp_exportdata_member_type_total_proportion');
				$sheet_arr['degree'] = Language::get('bp_exportdata_membership_credit_rating_distribution');
				$sheet_arr['cusclass'] = Language::get('bp_exportdata_member_of_species_distribution');
				$sheet_arr['cusindustry'] = Language::get('bp_exportdata_members_of_industry_distribution');
				$sheet_arr['cusrelationship'] = Language::get('bp_exportdata_membership_grade_distribution');
				$sheet_arr['cusfrom'] = Language::get('bp_exportdata_member_of_the_source_distribution');
				$sheet_arr['cuspotentialvalue'] = Language::get('bp_exportdata_potential_members_value_distribution');
				$sheet_arr['cusprovince'] = Language::get('bp_exportdata_member_provinces_distribution');
				$sheet_arr['cusstaffsize'] = Language::get('bp_exportdata_enterprise_staff_member_size_distribution');
				$sheet_arr['cusamounttop'] = Language::get('bp_exportdata_membership_sales_top_20');
				$sheet_arr['cusprofittop'] = Language::get('bp_exportdata_gross_profit_before_20_members');
				$sheet_arr['cusactiontop'] = Language::get('bp_exportdata_action_history_top_20_members');
				foreach($sheet_arr as $k=>$v){
					$excel_data = array();
					$excel_data = $this->getStatdCustomer($k,$where);
					$excel_class->addArray($excel_data);
					$excel_class->addWorksheet($v);
				}
			}
			//销售机会统计
			if(in_array('statdetail_chance',$_POST['m']) && cPermission('statdetail','statdetail_chance')){
				$sheet_arr = array();
				$sheet_arr['discovery'] = Language::get('bp_exportdata_monthly_opportunity_discovery_time_statistics');
				$sheet_arr['predictdate'] = Language::get('bp_exportdata_monthly_statistics_is_expected_to_sign_the_bill');
				$sheet_arr['state'] = Language::get('bp_exportdata_opportunity_to_state_distribution');
				$sheet_arr['chatype'] = Language::get('bp_exportdata_chance_type_distribution');
				$sheet_arr['source'] = Language::get('bp_exportdata_chance_to_source_distribution');
				$sheet_arr['stage'] = Language::get('bp_exportdata_the_distribution_of_the_stages_of_opportunity');
				$sheet_arr['probability'] = Language::get('bp_exportdata_opportunity_possibility_distribution');
				foreach($sheet_arr as $k=>$v){
					$excel_data = array();
					$excel_data = $this->getStatdChance($k,$where);
					$excel_class->addArray($excel_data);
					$excel_class->addWorksheet($v);
				}
			}
			//销售统计
			if(in_array('statdetail_sales',$_POST['m']) && cPermission('statdetail','statdetail_sales')){
				$sheet_arr = array();
				$sheet_arr['statenum'] = Language::get('bp_exportdata_distribution_of_the_order_status');
				$sheet_arr['stateamount'] = Language::get('bp_exportdata_distribution_for_the_amount_of_the_order_status');
				$sheet_arr['ordertype'] = Language::get('bp_exportdata_order_type_distribution');
				$sheet_arr['ordertypemoney'] = Language::get('bp_exportdata_order_type_distribution1');
				$sheet_arr['ordernum'] = Language::get('bp_exportdata_monthly_sales_statistics');
				$sheet_arr['ordersaleroom'] = Language::get('bp_exportdata_monthly_sales_statistics1');
				$sheet_arr['orderprofity'] = Language::get('bp_exportdata_gross_monthly_statistics');
				$sheet_arr['areanum'] = Language::get('bp_exportdata_regional_distribution_of_the_order');
				$sheet_arr['areasaleroom'] = Language::get('bp_exportdata_regional_distribution_of_sales_orders');
				$sheet_arr['areaatv'] = Language::get('bp_exportdata_regional_distribution_of_guest_unit_price');
				$sheet_arr['amountinterval'] = Language::get('bp_exportdata_order_amount_range_distribution');
				foreach($sheet_arr as $k=>$v){
					$excel_data = array();
					$excel_data = $this->getStatdSales($k,$where);
					$excel_class->addArray($excel_data);
					$excel_class->addWorksheet($v);
				}
			}
			//会员跟踪
			if(in_array('statdetail_tracking',$_POST['m']) && cPermission('statdetail','statdetail_tracking')){
				$sheet_arr = array();
				$sheet_arr['historytype'] = Language::get('bp_exportdata_action_history_type_distribution');
				$sheet_arr['scheduletype'] = Language::get('bp_exportdata_the_schedule_type_distribution');
				$sheet_arr['monthlyhistory'] = Language::get('bp_exportdata_historical_statistics_monthly_operations');
				foreach($sheet_arr as $k=>$v){
					$excel_data = array();
					$excel_data = $this->getStatdTracking($k,$where);
					$excel_class->addArray($excel_data);
					$excel_class->addWorksheet($v);
				}
			}
			//员工统计
			if(in_array('statdetail_user',$_POST['m']) && cPermission('statdetail','statdetail_user')){
				$sheet_arr = array();
				$sheet_arr['state'] = Language::get('bp_exportdata_employee_status_distribution');
				$sheet_arr['education'] = Language::get('bp_exportdata_employees_degree_distribution');
				$sheet_arr['sex'] = Language::get('bp_exportdata_employees_gender_distribution');
				$sheet_arr['area'] = Language::get('bp_exportdata_regional_distribution_of_employees');
				$sheet_arr['chancenumtop'] = Language::get('bp_exportdata_before_the_employee_has_the_opportunity_number_20');
				$sheet_arr['chancenumlower'] = Language::get('bp_exportdata_after_the_employee_has_the_opportunity_number_20');
				$sheet_arr['historynumtop'] = Language::get('bp_exportdata_employee_action_history_before_the_number_20');
				$sheet_arr['historynumlower'] = Language::get('bp_exportdata_employee_action_history_after_the_number_20');
				foreach($sheet_arr as $k=>$v){
					$excel_data = array();
					$excel_data = $this->getStatdUser($k,$where);
					$excel_class->addArray($excel_data);
					$excel_class->addWorksheet($v);
				}
			}
			//商品统计
			if(in_array('statdetail_product',$_POST['m']) && cPermission('statdetail','statdetail_product')){
				$sheet_arr = array();
				$sheet_arr['ordernumtop'] = Language::get('bp_exportdata_commodity_sales_top_20');
				$sheet_arr['ordernumlower'] = Language::get('bp_exportdata_20_after_sales');
				$sheet_arr['orderamounttop'] = Language::get('bp_exportdata_commodity_sales_in_the_top_20');
				$sheet_arr['orderamountlower'] = Language::get('bp_exportdata_20_after_commodity_sales');
				$sheet_arr['orderprofitytop'] = Language::get('bp_exportdata_commodity_gross_profit_before_20');
				$sheet_arr['orderprofitylower'] = Language::get('bp_exportdata_20_after_commodity_gross_profit');
				foreach($sheet_arr as $k=>$v){
					$excel_data = array();
					$excel_data = $this->getStatdProduct($k,$where);
					$excel_class->addArray($excel_data);
					$excel_class->addWorksheet($v);
				}
			}
			$excel_class->generateXML(Language::get('bp_exportdata_crm_batch_export_data').date('Y-m-d H-i-s',time()));
		}else{
			$excel_item = array();
			if (cPermission('customer','customer_list')){
				$excel_item['customer']['name'] = Language::get('bp_exportdata_membership_information1');
			}
			if (cPermission('chance','chancelist')){
				$excel_item['chance']['name'] = Language::get('bp_exportdata_sales_opportunities');
			}
			if (cPermission('order','order_list')){
				$excel_item['order']['name'] = Language::get('bp_exportdata_the_order_information');
			}
			if (cPermission('product','product_list')){
				$excel_item['product']['name'] = Language::get('bp_exportdata_commodity_information');
			}
			if (cPermission('statdetail','statdetail_customer')){
				$excel_item['statdetail']['son']['customer'] = Language::get('bp_exportdata_member_of_the_statistics');
			}
			if (cPermission('statdetail','statdetail_chance')){
				$excel_item['statdetail']['son']['chance'] = Language::get('bp_exportdata_sales_opportunities_statistics');
			}
			if (cPermission('statdetail','statdetail_sales')){
				$excel_item['statdetail']['son']['sales'] = Language::get('bp_exportdata_sales_statistics');
			}
			if (cPermission('statdetail','statdetail_tracking')){
				$excel_item['statdetail']['son']['tracking'] = Language::get('bp_exportdata_member_of_the_track');
			}
			if (cPermission('statdetail','statdetail_user')){
				$excel_item['statdetail']['son']['user'] = Language::get('bp_exportdata_staff_statistics');
			}
			if (cPermission('statdetail','statdetail_product')){
				$excel_item['statdetail']['son']['product'] = Language::get('bp_exportdata_commodity_statistics');
			}
			if (!empty($excel_item['statdetail']['son'])){
				$excel_item['statdetail']['name'] = Language::get('bp_exportdata_statistical_chart');
			}
			/**
			 * 左侧菜单
			 */
			$this->setleftmenu('export_excel');
			/**
			 * 模板输出
			 */
			Tpl::output('excel_item',$excel_item);
			Tpl::showpage('exportdata_excel');
		}
	}
	/**
	 * 导出PDF
	 */
	public function export_pdfOp(){
		set_time_limit(0);
		if (chksubmit()){
			if(empty($_POST['m'])){
				showDialog(Language::get('bp_exportdata_please_select_a_derived_data_item'),'','error');
			}
			$where = array();
			$where['stime'] = @strtotime($_POST['search_stime']);
			$where['etime'] = @strtotime($_POST['search_etime']);
			$stat_json = array();
			//会员统计
			if(in_array('statdetail_customer',$_POST['m']) && cPermission('statdetail','statdetail_customer')){
				$sheet_arr = array();
				$sheet_arr['typescale'] = Language::get('bp_exportdata_member_type_total_proportion');
				$sheet_arr['degree'] = Language::get('bp_exportdata_membership_credit_rating_distribution');
				$sheet_arr['cusclass'] = Language::get('bp_exportdata_member_of_species_distribution');
				$sheet_arr['cusindustry'] = Language::get('bp_exportdata_members_of_industry_distribution');
				$sheet_arr['cusrelationship'] = Language::get('bp_exportdata_membership_grade_distribution');
				$sheet_arr['cusfrom'] = Language::get('bp_exportdata_member_of_the_source_distribution');
				$sheet_arr['cuspotentialvalue'] = Language::get('bp_exportdata_potential_members_value_distribution');
				$sheet_arr['cusprovince'] = Language::get('bp_exportdata_member_provinces_distribution');
				$sheet_arr['cusstaffsize'] = Language::get('bp_exportdata_enterprise_staff_member_size_distribution');
				$sheet_arr['cusamounttop'] = Language::get('bp_exportdata_membership_sales_top_20');
				$sheet_arr['cusprofittop'] = Language::get('bp_exportdata_gross_profit_before_20_members');
				$sheet_arr['cusactiontop'] = Language::get('bp_exportdata_action_history_top_20_members');
				foreach($sheet_arr as $k=>$v){
					$stat_json[] = $this->getStatdCustomer($k,$where,'pdf');
				}
			}
			//销售机会统计
			if(in_array('statdetail_chance',$_POST['m']) && cPermission('statdetail','statdetail_chance')){
				$sheet_arr = array();
				$sheet_arr['discovery'] = Language::get('bp_exportdata_monthly_opportunity_discovery_time_statistics');
				$sheet_arr['predictdate'] = Language::get('bp_exportdata_monthly_statistics_is_expected_to_sign_the_bill');
				$sheet_arr['state'] = Language::get('bp_exportdata_opportunity_to_state_distribution');
				$sheet_arr['chatype'] = Language::get('bp_exportdata_chance_type_distribution');
				$sheet_arr['source'] = Language::get('bp_exportdata_chance_to_source_distribution');
				$sheet_arr['stage'] = Language::get('bp_exportdata_the_distribution_of_the_stages_of_opportunity');
				$sheet_arr['probability'] = Language::get('bp_exportdata_opportunity_possibility_distribution');
				foreach($sheet_arr as $k=>$v){
					$stat_json[] = $this->getStatdChance($k,$where,'pdf');
				}
			}
			//销售统计
			if(in_array('statdetail_sales',$_POST['m']) && cPermission('statdetail','statdetail_sales')){
				$sheet_arr = array();
				$sheet_arr['statenum'] = Language::get('bp_exportdata_distribution_of_the_order_status');
				$sheet_arr['stateamount'] = Language::get('bp_exportdata_distribution_for_the_amount_of_the_order_status');
				$sheet_arr['ordertype'] = Language::get('bp_exportdata_order_type_distribution');
				$sheet_arr['ordertypemoney'] = Language::get('bp_exportdata_order_type_distribution1');
				$sheet_arr['ordernum'] = Language::get('bp_exportdata_monthly_sales_statistics');
				$sheet_arr['ordersaleroom'] = Language::get('bp_exportdata_monthly_sales_statistics1');
				$sheet_arr['orderprofity'] = Language::get('bp_exportdata_gross_monthly_statistics');
				$sheet_arr['areanum'] = Language::get('bp_exportdata_regional_distribution_of_the_order');
				$sheet_arr['areasaleroom'] = Language::get('bp_exportdata_regional_distribution_of_sales_orders');
				$sheet_arr['areaatv'] = Language::get('bp_exportdata_regional_distribution_of_guest_unit_price');
				$sheet_arr['amountinterval'] = Language::get('bp_exportdata_order_amount_range_distribution');
				foreach($sheet_arr as $k=>$v){
					$stat_json[] = $this->getStatdSales($k,$where,'pdf');
				}
			}
			//会员跟踪
			if(in_array('statdetail_tracking',$_POST['m']) && cPermission('statdetail','statdetail_tracking')){
				$sheet_arr = array();
				$sheet_arr['historytype'] = Language::get('bp_exportdata_action_history_type_distribution');
				$sheet_arr['scheduletype'] = Language::get('bp_exportdata_the_schedule_type_distribution');
				$sheet_arr['monthlyhistory'] = Language::get('bp_exportdata_historical_statistics_monthly_operations');
				foreach($sheet_arr as $k=>$v){
					$stat_json[] = $this->getStatdTracking($k,$where,'pdf');
				}
			}
			//员工统计
			if(in_array('statdetail_user',$_POST['m']) && cPermission('statdetail','statdetail_user')){
				$sheet_arr = array();
				$sheet_arr['state'] = Language::get('bp_exportdata_employee_status_distribution');
				$sheet_arr['education'] = Language::get('bp_exportdata_employees_degree_distribution');
				$sheet_arr['sex'] = Language::get('bp_exportdata_employees_gender_distribution');
				$sheet_arr['area'] = Language::get('bp_exportdata_regional_distribution_of_employees');
				$sheet_arr['chancenumtop'] = Language::get('bp_exportdata_before_the_employee_has_the_opportunity_number_20');
				$sheet_arr['chancenumlower'] = Language::get('bp_exportdata_after_the_employee_has_the_opportunity_number_20');
				$sheet_arr['historynumtop'] = Language::get('bp_exportdata_employee_action_history_before_the_number_20');
				$sheet_arr['historynumlower'] = Language::get('bp_exportdata_employee_action_history_after_the_number_20');
				foreach($sheet_arr as $k=>$v){
					$stat_json[] = $this->getStatdUser($k,$where,'pdf');
				}
			}
			//商品统计
			if(in_array('statdetail_product',$_POST['m']) && cPermission('statdetail','statdetail_product')){
				$sheet_arr = array();
				$sheet_arr['ordernumtop'] = Language::get('bp_exportdata_commodity_sales_top_20');
				$sheet_arr['ordernumlower'] = Language::get('bp_exportdata_20_after_sales');
				$sheet_arr['orderamounttop'] = Language::get('bp_exportdata_commodity_sales_in_the_top_20');
				$sheet_arr['orderamountlower'] = Language::get('bp_exportdata_20_after_commodity_sales');
				$sheet_arr['orderprofitytop'] = Language::get('bp_exportdata_commodity_gross_profit_before_20');
				$sheet_arr['orderprofitylower'] = Language::get('bp_exportdata_20_after_commodity_gross_profit');
				foreach($sheet_arr as $k=>$v){
					$stat_json[] = $this->getStatdProduct($k,$where,'pdf');
				}
			}
			$pagename = 'exportdata_pdfshow';
			$pdf_name = Language::get('bp_exportdata_crm_batch_export_data');
			Tpl::output('stat_json',$stat_json);
			Tpl::output('pdf_name',$pdf_name);
		} else {
			$image_item = array();
			if (cPermission('statdetail','statdetail_customer')){
				$image_item['statdetail']['son']['customer'] = Language::get('bp_exportdata_member_of_the_statistics');
			}
			if (cPermission('statdetail','statdetail_chance')){
				$image_item['statdetail']['son']['chance'] = Language::get('bp_exportdata_sales_opportunities_statistics');
			}
			if (cPermission('statdetail','statdetail_sales')){
				$image_item['statdetail']['son']['sales'] = Language::get('bp_exportdata_sales_statistics');
			}
			if (cPermission('statdetail','statdetail_tracking')){
				$image_item['statdetail']['son']['tracking'] = Language::get('bp_exportdata_member_of_the_track');
			}
			if (cPermission('statdetail','statdetail_user')){
				$image_item['statdetail']['son']['user'] = Language::get('bp_exportdata_staff_statistics');
			}
			if (cPermission('statdetail','statdetail_product')){
				$image_item['statdetail']['son']['product'] = Language::get('bp_exportdata_commodity_statistics');
			}
			if (!empty($image_item['statdetail']['son'])){
				$image_item['statdetail']['name'] = Language::get('bp_exportdata_statistical_chart');
			}
			$pagename = 'exportdata_pdf';
			Tpl::output('image_item',$image_item);
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('export_pdf');
		/**
		 * 模板输出
		 */
		Tpl::showpage($pagename);
	}
	/**
	 * 获得会员数据
	 */
	private function getCustomer($where){
		$model = Model();
		if ($_SESSION['shop_id']){
			$where_condition['shop_id'] = $_SESSION['shop_id'];
		}
		//时间搜索
		if ($where['stime'] > 0 && $where['etime']>0){
			$where_condition['cc_addtime'] = array(array('egt',"{$where['stime']}"),array('elt',"{$where['etime']}"),'and');
		}elseif($stime > 0){
			$where_condition['cc_addtime'] = array('egt',"{$where['stime']}");
		}elseif($etime>0){
			$where_condition['cc_addtime'] = array('elt',"{$where['etime']}");
		}
		//从数据库中调取数据
		$customer_list = $model->table('customer')->where($where_condition)->order('cc_addtime desc')->select();
		//自定义字段的处理
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>1))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		//从缓存中调取数据字典信息
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		//构造Excel数组
		$excel_data = array();
		//header
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_membership_number'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_how_important'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_member_name'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_member_type'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_creation_date'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_high_seas'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_claim_on_time'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_belong_to_the_store'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_a_potential_member_of'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_potential_value'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_a_credit_rating'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_their_industry'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_relationship_between_grades'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_member_of_the_source'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_type'));
		if(!empty($selfdic_show) && is_array($selfdic_show)){
			foreach ((array)$selfdic_show as $sk=>$sv){
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$sv['field_name']);
			}
		}
		//data
		foreach ((array)$customer_list as $k=>$v){
			$tmp = array();
			$tmp[] = array('data'=>$v['cc_id']);
			switch ($v['cc_important']){
			 	case '1':
			 		$tmp[] = array('data'=>Language::get('bp_exportdata_low'));
			 		break;
			 	case '2':
			 		$tmp[] = array('data'=>Language::get('bp_exportdata_in_the'));
			 		break;
			 	case '3':
			 		$tmp[] = array('data'=>Language::get('bp_exportdata_high'));
			 		break;
			}
			$tmp[] = array('data'=>($v['cc_name']==''?Language::get('bp_exportdata_have_been_unable_to_find_the_member_data'):$v['cc_name']));
			$tmp[] = array('data'=>($v['cc_class']==0?'':$dic_array['customer_class']['child_option'][$v['cc_class']]['cd_name']));
			$tmp[] = array('data'=>date('Y-m-d H:i:s',$v['cc_addtime']));
			$tmp[] = array('data'=>($v['cc_insea'] == 1?Language::get('bp_exportdata_is'):Language::get('bp_exportdata_no')));
			$tmp[] = array('data'=>($v['cc_getseatime']!=0?date('Y-m-d H:i:s',$v['cc_getseatime']):Language::get('bp_exportdata_no1')));
			$usertree_arr = ($t = F('user')) ? $t : H('user',true,'file');
			$tmp[] = array('data'=>$shop_list[$v['shop_id']]['shop_name']);
			$tmp[] = array('data'=>($v['cc_ispotential']==1?Language::get('bp_exportdata_is'):Language::get('bp_exportdata_no')));
			//潜在价值
			switch($v['cc_potential_value']){
				case 1:
					$tmp[] = array('data'=>Language::get('bp_exportdata_low'));
					break;
				case 2:
					$tmp[] = array('data'=>Language::get('bp_exportdata_in_the'));
					break;
				case 3:
					$tmp[] = array('data'=>Language::get('bp_exportdata_high'));
					break;
			}
			//信用等级
			switch($v['cc_credit_degree']){
				case 1:
					$tmp[] = array('data'=>Language::get('bp_exportdata_low'));
					break;
				case 2:
					$tmp[] = array('data'=>Language::get('bp_exportdata_in_the'));
					break;
				case 3:
					$tmp[] = array('data'=>Language::get('bp_exportdata_high'));
					break;
			}
			//所属行业
			$tmp[] = array('data'=>($v['cc_industry']==0?'':$dic_array['industry']['child_option'][$v['cc_industry']]['cd_name']));
			//关系等级
			$tmp[] = array('data'=>($v['cc_relationship']==0?'':$dic_array['relationship']['child_option'][$v['cc_relationship']]['cd_name']));
			//会员来源
			$tmp[] = array('data'=>($v['cc_from']==0?'':$dic_array['customer_from']['child_option'][$v['cc_from']]['cd_name']));
			//类型
			$tmp[] = array('data'=>($v['cc_type'] == 1?Language::get('bp_exportdata_corporate_member'):Language::get('bp_exportdata_individual_members')));
			if(!empty($selfdic_show) && is_array($selfdic_show)){
				$selfdic_choose = unserialize($v['cc_self_field']);
				foreach ((array)$output['selfdic_show'] as $sk=>$sv){
					$tmp[] = array('data'=>(intval($selfdic_choose[$sv['p_id']])==0?Language::get('bp_exportdata_no12'):$sv['child_option'][$selfdic_choose[$sv['p_id']]]['cd_name']));
				}
			}
			$excel_data[] = $tmp;
		}
		return $excel_data;
	}
	/**
	 * 获得销售机会数据
	 */
	private function getChance($where_arr){
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$where['cha_departmentid'] = array('in',$d_idarr);
		}else{
			$where['cha_userid'] = $_SESSION['member_id'];
		}
		$where['cha_istrash'] = '0';
		if ($where_arr['stime'] > 0 && $where_arr['etime']>0){
			$where['cha_predictdate'] = array(array('egt',"{$where_arr['stime']}"),array('elt',"{$where_arr['etime']}"),'and');
		}elseif($where_arr['stime'] > 0){
			$where['cha_predictdate'] = array('egt',"{$where_arr['stime']}");
		}elseif($where_arr['etime']>0){
			$where['cha_predictdate'] = array('elt',"{$where_arr['etime']}");
		}
		$chancelist = $model->table('chance,customer')->join('left')->on('chance.cha_customerid=customer.cc_id')->where($where)->order('cha_id desc')->select();

		$chancelistnew = array();
		$predmoney_pagecount = 0;
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		$chancestate_arr = array(0=>Language::get('bp_exportdata_tracking'),1=>Language::get('bp_exportdata_success'),2=>Language::get('bp_exportdata_failure'),3=>Language::get('bp_exportdata_put_on_hold'),4=>Language::get('bp_exportdata_failure1'));
		//构造Excel数据
		$excel_data = array();
		//header
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_opportunity_to_theme'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_employees'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_member_of_the'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_type'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_is_expected_to_sign_the_bill_date'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_expected_amount'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_phase'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_possibility'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_find_the_time'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_source'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_state'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_stay').Language::get('bp_openparen').Language::get('bp_exportdata_day').Language::get('bp_closeparen'));
		if(!empty($chancelist)){
			foreach((array)$chancelist as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['cha_title']);
				$tmp[] = array('data'=>$v['cha_username']);
				if (empty($v['cc_id']) || $v['cc_isdel'] == 1){
					$v['cc_statetext'] = Language::get('bp_openparen').Language::get('bp_exportdata_has_been_deleted').Language::get('bp_closeparen');
				}
				$tmp[] = array('data'=>$v['cha_customername'].$v['cc_statetext']);
				$tmp[] = array('data'=>$dic_array['chancetype']['child_option'][$v['cha_type']]['cd_name']);
				$tmp[] = array('data'=>(($t = $v['cha_predictdate'])?@date('Y-m-d',$v['cha_predictdate']):''));
				$tmp[] = array('data'=>ncPriceFormat($v['cha_predictmoney']));
				$tmp[] = array('data'=>$dic_array['chancestage']['child_option'][$v['cha_stage']]['cd_name']);
				$tmp[] = array('data'=>$dic_array['chanceprobability']['child_option'][$v['cha_probability']]['cd_name']);
				$tmp[] = array('data'=>(($t = $v['cha_discoverydate'])?@date('Y-m-d',$v['cha_discoverydate']):''));
				$tmp[] = array('data'=>$dic_array['chancesource']['child_option'][$v['cha_source']]['cd_name']);
				$tmp[] = array('data'=>$chancestate_arr[$v['cha_state']]);
				$tmp[] = array('data'=>floor((time() - $v['cha_stagechangedate'])/86400));
				$excel_data[] = $tmp;
			}
		}
		return $excel_data;
	}
	/**
	 * 获得订单数据
	 */
	private function getOrder($where_arr){
		$model = Model();
		if ($_SESSION['shop_id']){
			$where_condition['shop_id'] = $_SESSION['shop_id'];
		}
		if ($where_arr['stime'] > 0 && $where_arr['etime']>0){
			$where_condition['co_addtime'] = array(array('egt',"{$where_arr['stime']}"),array('elt',"{$where_arr['etime']}"),'and');
		}elseif($where_arr['stime'] > 0){
			$where_condition['co_addtime'] = array('egt',"{$where_arr['stime']}");
		}elseif($where_arr['etime']>0){
			$where_condition['co_addtime'] = array('elt',"{$where_arr['etime']}");
		}
		$order_list = $model->field('orders.*,customer.cc_name,user.user_truename')->table('orders,customer,user')->join('left')->on('customer.cc_id=orders.cc_id,orders.co_staff_id=user.user_id')->where($where_condition)->order('orders.co_addtime desc')->select();
		//从缓存中调取数据字典信息
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//自定义字段的处理
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		//构造Excel数据
		$excel_data = array();
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_order_number'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_name_of_the_shop'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_member_name'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_amount_of_goods'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_courier_fees'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_amount_actually_paid'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_payment_time'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_place_the_order_of_time'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_review_the_status'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_order_status'));
		if(!empty($selfdic_show) && is_array($selfdic_show)){
			foreach ((array)$selfdic_show as $sk=>$sv){
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$sv['field_name']);
			}
		}
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		//data
		foreach ((array)$order_list as $k=>$v){
			$tmp = array();
			$tmp[] = array('data'=>$v['co_code']);
			$tmp[] = array('data'=>$shop_list[$v['shop_id']]['shop_name']);
			$tmp[] = array('data'=>($v['cc_name']==''?'<font style="color:red">'.Language::get('bp_exportdata_have_been_unable_to_find_the_member_data').'</font>':$v['cc_name']));
			$tmp[] = array('format'=>'Number','data'=>ncPriceFormat($v['co_total_price']));
			$tmp[] = array('format'=>'Number','data'=>ncPriceFormat($v['express_payment']));
			$tmp[] = array('format'=>'Number','data'=>ncPriceFormat($v['co_final_price']));
			$tmp[] = array('data'=>@date('Y-m-d H:i:s',$v['co_paytime']));
			$tmp[] = array('data'=>@date('Y-m-d H:i:s',$v['co_addtime']));
			switch ($v['co_check']){
				case '0':
					$tmp[] = array('data'=>Language::get('bp_exportdata_not_audit'));
					break;
				case '1':
					$tmp[] = array('data'=>Language::get('bp_exportdata_approved'));
					break;
				case '2':
					$tmp[] = array('data'=>Language::get('bp_exportdata_abnormal'));
					break;
			}
			switch ($v['co_status']){
				case '0':
					$tmp[] = array('data'=>Language::get('bp_exportdata_conducted_in_the'));
					break;
				case '1':
					$tmp[] = array('data'=>Language::get('bp_exportdata_transaction_completed'));
					break;
				case '2':
					$tmp[] = array('data'=>Language::get('bp_exportdata_already_shipping'));
					break;
				case '3':
					$tmp[] = array('data'=>Language::get('bp_exportdata_has_been_shut_down'));
					break;
			}
			if(!empty($selfdic_show) && is_array($selfdic_show)){
				$selfdic_choose = unserialize($v['cc_self_field']);
				foreach ((array)$output['selfdic_show'] as $sk=>$sv){
					$tmp[] = array('data'=>(intval($selfdic_choose[$sv['p_id']])==0?Language::get('bp_exportdata_no12'):$sv['child_option'][$selfdic_choose[$sv['p_id']]]['cd_name']));
				}
			}
			$excel_data[] = $tmp;
		}
		return $excel_data;
	}
	/**
	 * 获得商品数据
	 */
	private function getProduct($where_arr){
		$model = Model();
		$where_condition = array();
		if ($_SESSION['shop_id']){
			$where_condition['shop_id'] = $_SESSION['shop_id'];
		}
		$product_list = $model->table('product')->where($where_condition)->order('cp_id')->select();
		//从缓存中调取数据字典信息
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//自定义字段的处理
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>3))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		//构造Excel数据
		$excel_data = array();
		//header
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_name_of_commodity'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_commodity_code'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_name_of_the_shop'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_inventory_quantity'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_the_sales_price'));
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_state'));
		if(!empty($selfdic_show) && is_array($selfdic_show)){
			foreach ((array)$selfdic_show as $sk=>$sv){
				$excel_data[0][] = array('styleid'=>'s_title','data'=>$sv['field_name']);
			}
		}
		$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_exportdata_product_pictures'));
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		//data
		foreach ((array)$product_list as $k=>$v){
			$tmp = array();
			$tmp[] = array('data'=>$v['cp_name']);
			$tmp[] = array('data'=>$v['cp_code']);
			$tmp[] = array('data'=>$shop_list[$v['shop_id']]['shop_name']);
			$tmp[] = array('data'=>$v['cp_num']);
			$tmp[] = array('data'=>ncPriceFormat($v['cp_ori_price']));
			switch ($v['cp_status']){
			 	case '1':
			 		$tmp[] = array('data'=>Language::get('bp_exportdata_shelves'));
			 		break;
			 	case '2':
			 		$tmp[] = array('data'=>Language::get('bp_exportdata_the_shelves'));
					break;
			}
			if(!empty($selfdic_show) && is_array($selfdic_show)){
				$selfdic_choose = unserialize($v['cc_self_field']);
				foreach ((array)$output['selfdic_show'] as $sk=>$sv){
					$tmp[] = array('data'=>(intval($selfdic_choose[$sv['p_id']])==0?Language::get('bp_exportdata_no12'):$sv['child_option'][$selfdic_choose[$sv['p_id']]]['cd_name']));
				}
			}
			$img = $v['cp_pic']!=''?$v['cp_pic']:SiteUrl.'/templates/default/images/default_goods_image.gif';
			$tmp[] = array('data'=>$img);
			$excel_data[] = $tmp;
		}
		return $excel_data;
	}
	/**
	 * 获得会员统计
	 */
	private function getStatdCustomer($type,$where_arr,$exporttype='excel'){
		include_once 'exportdata_statdcustomer.php';
		$statcustomer_class = new exportdata_statdcustomerControl($type,$where_arr,$exporttype);
		$fun_name = "statcustomer_".$type;
		if(!method_exists($statcustomer_class,$fun_name)){
			return array();
		}
		$excel_data = $statcustomer_class->$fun_name();
		return $excel_data;
	}
	/**
	 * 获得销售机会统计
	 */
	private function getStatdChance($type,$where_arr,$exporttype='excel'){
		include_once 'exportdata_statdchance.php';
		$statchance_class = new exportdata_statdchanceControl($type,$where_arr,$exporttype);
		$fun_name = "statchance_".$type;
		if(!method_exists($statchance_class,$fun_name)){
			return array();
		}
		$excel_data = $statchance_class->$fun_name();
		return $excel_data;
	}
	/**
	 * 获得销售统计
	 */
	private function getStatdSales($type,$where_arr,$exporttype='excel'){
		include_once 'exportdata_statdsales.php';
		$statsales_class = new exportdata_statdsalesControl($type,$where_arr,$exporttype);
		$fun_name = "statsales_".$type;
		if(!method_exists($statsales_class,$fun_name)){
			return array();
		}
		$excel_data = $statsales_class->$fun_name();
		return $excel_data;
	}
	/**
	 * 获得会员跟踪统计
	 */
	private function getStatdTracking($type,$where_arr,$exporttype='excel'){
		include_once 'exportdata_statdtracking.php';
		$stattracking_class = new exportdata_statdtrackingControl($type,$where_arr,$exporttype);
		$fun_name = "stattracking_".$type;
		if(!method_exists($stattracking_class,$fun_name)){
			return array();
		}
		$excel_data = $stattracking_class->$fun_name();
		return $excel_data;
	}
	/**
	 * 获得员工统计
	 */
	private function getStatdUser($type,$where_arr,$exporttype='excel'){
		include_once 'exportdata_statduser.php';
		$statuser_class = new exportdata_statduserControl($type,$where_arr,$exporttype);
		$fun_name = "statuser_".$type;
		if(!method_exists($statuser_class,$fun_name)){
			return array();
		}
		$excel_data = $statuser_class->$fun_name();
		return $excel_data;
	}
	/**
	 * 获得商品统计
	 */
	private function getStatdProduct($type,$where_arr,$exporttype='excel'){
		include_once 'exportdata_statdproduct.php';
		$statproduct_class = new exportdata_statdproductControl($type,$where_arr,$exporttype);
		$fun_name = "statproduct_".$type;
		if(!method_exists($statproduct_class,$fun_name)){
			return array();
		}
		$excel_data = $statproduct_class->$fun_name();
		return $excel_data;
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_exportdata_export_data'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'export_excel','menu_name'=>Language::get('bp_exportdata_export_excel'),	'menu_act'=>'exportdata','menu_op'=>'export_excel');
		$arr[0]['submenu'][1] = array('menu_key'=>'export_pdf','menu_name'=>Language::get('bp_exportdata_export_pdf'),	'menu_act'=>'exportdata','menu_op'=>'export_pdf');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}