<?php
/**
 * 下载数据
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class downloadControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('download');
    }

	/**
	 * 单次抓取到的远程数据
	 */
	private $rs_data;
	/**
	 * 淘宝类目抓取的数据数组
	 */
	private $tb_catdata = array();
	/**
	 * 下载商城数据信息
	 */
	public function downloadOp(){
		if(chksubmit()){
			//验证
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["shop_id"],"require"=>"true","message"=>Language::get('bp_download_please_select_a_store'));
			$validate_arr[] = array("input"=>$_POST["dl_type"],"require"=>"true","message"=>Language::get('bp_download_please_select_a_download_type'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$shop_id = intval($_POST['shop_id']);
			//调取店铺缓存信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			$shop_info = $shop_list[$shop_id];
			/*处理接口返回的json数据*/
			switch ($shop_info['shop_platform']){
				/**
				 * ShopNC体系店铺数据下载(sid:商城店铺ID；shop_id：ERP系统店铺ID)
				 */
				case 1:
					$platinfo = unserialize($shop_info['shop_platinfo']);
					$sid = $platinfo['shopnc_sid'];
					$apiurl = $platinfo['shopnc_apiurl'];
					$signkey = $platinfo['shopnc_sk'];
					$i = 1;
					$this->getdata($sid,trim($_POST["dl_type"]),$i,$apiurl,$signkey,$shop_info['shop_lastorder']);
					//showDialog($this->rs_data,'','error');
					if($this->rs_data === false){
						showDialog(Language::get('bp_download_download_data_failed'),'','error');
					}elseif ($this->rs_data === null){
						showDialog(Language::get('bp_download_no_data_available_for_download_at_present'),'','error');
					}else{
						$alldata = array();
						while($this->rs_data !== false && $this->rs_data !== null){
							foreach ((array)$this->rs_data as $val){
								array_push($alldata, $val);
							}
							++$i;
							$this->getdata($sid,trim($_POST["dl_type"]),$i,$apiurl,$signkey,$shop_info['shop_lastorder']);
						}
						if(!empty($alldata)){
							$sdrs = $this->save_data(trim($_POST["dl_type"]),$alldata,$shop_id);
							if($sdrs === true){
								showDialog(Language::get('bp_download_data_download_to_complete').Language::get('bp_comma').Language::get('bp_download_please_update_the_cache'),'','succ');
							}else{
								showDialog(Language::get('bp_download_data_save_failed').Language::get('bp_comma').'ERROR：'.$sdrs,'','error');
							}
						}else{
							showDialog(Language::get('bp_download_no_data_available_for_download_at_present'),'','error');
						}
					}
					break;
				/**
				 * 淘宝平台（含天猫）数据下载
				 */
				case 2:
					require(BasePath.'/framework/function/top.php');
					$tc = new TopClient();
					$tc->appKey    = '21513519';
					$tc->appSecret = '2bfcbf47bed3fafd4ffbb51ca04af002';
					$model = Model();
					$platinfo = unserialize($shop_info['shop_platinfo']);
					switch (trim($_POST['dl_type'])){
						//淘宝商品下载
						case 'product':
							$search_product = array();
							/*下载淘宝商品数据（在售+库存）*/
							$param = array();
							//在售商品
							$param['method']    = 'taobao.items.onsale.get';
							$param['fields']    = 'num_iid';
							$param['nick']      = $platinfo['tb_account'];
							$param['page_no']   = 1;
							$param['page_size'] = 200;
							$param['session']   = $platinfo['session'];
							$result_arr = $tc->reqdata($param);
							if(!is_array($result_arr) || !empty($result_arr['error_response'])){
								if($result_arr['error_response']['msg'] == 'Invalid session:session-expired'){
									//处理session过期
									$model->table('shop')->where(array('shop_id'=>intval($_GET['shop_id'])))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
									showDialog(Language::get('bp_download_taobao_the_session_expires').Language::get('bp_comma').Language::get('bp_download_please_bind_again'));
								}
								showDialog(Language::get('bp_download_goods_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
							}
							if(!empty($result_arr['items_onsale_get_response']['items']['item'])){
								foreach ((array)$result_arr['items_onsale_get_response']['items']['item'] as $k=>$v){
									$search_product[] = $v['num_iid'];
								}
							}
							$all_num = $result_arr['items_onsale_get_response']['total_results'];
							$page = ceil($all_num/200);
							if($page > 1){
								for ($i=2;$i<=$page;$i++){
									$param['page_no'] = $i;
									$result_arr = $tc->reqdata($param);
									if(!is_array($result_arr) || !empty($result_arr['error_response'])){
										showDialog(Language::get('bp_download_goods_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
									}
									if(!empty($result_arr['items_onsale_get_response']['items']['item'])){
										foreach ($result_arr['items_onsale_get_response']['items']['item'] as $k=>$v){
											$search_product[] = $v['num_iid'];
										}
									}
								}
							}
							//库存商品
							$param['taobao.items.inventory.get'];
							$param['page_no'] = 1;
							$result_arr = $tc->reqdata($param);
							if(!is_array($result_arr) || !empty($result_arr['error_response'])){
								showDialog(Language::get('bp_download_goods_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
							}
							if(!empty($result_arr['items_inventory_get_response']['items']['item'])){
								foreach ($result_arr['items_inventory_get_response']['items']['item'] as $k=>$v){
									$search_product[] = $v['num_iid'];
								}
							}
							$all_num = $result_arr['items_inventory_get_response']['total_results'];
							$page = ceil($all_num/200);
							if($page > 1){
								for ($i=2;$i<=$page;$i++){
									$param['page_no'] = $i;
									$result_arr = $tc->reqdata($param);
									if(!is_array($result_arr) || !empty($result_arr['error_response'])){
										showDialog(Language::get('bp_download_goods_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
									}
									if(!empty($result_arr['items_inventory_get_response']['items']['item'])){
										foreach ($result_arr['items_inventory_get_response']['items']['item'] as $k=>$v){
											$search_product[] = $v['num_iid'];
										}
									}
								}
							}
							if(empty($search_product)){
								showDialog(Language::get('bp_download_download_the_shop_no_goods'));
							}
							$all_spnum = count($search_product);
							/*抓取商品信息*/
							$sp_page = ceil($all_spnum/20);
							$product_list = array();
							$param['method'] = 'taobao.items.list.get';
							$param['fields'] = 'detail_url,num_iid,title,pic_url,approve_status,price,num,post_fee,express_fee,ems_fee,outer_id,sku.outer_id,sku.quantity,sku.price,sku.properties_name,sku.sku_id';
							for ($i=1;$i<=$sp_page;$i++){
								if($i == $sp_page){
									$param['num_iids'] = implode(',', $search_product);
								}else{
									$tmp_sp = array();
									for ($j=($i-1)*20;$j<=$i*20-1;$j++){
										$tmp_sp[] = $search_product[$j];
										unset($search_product[$j]);
									}
									$param['num_iids'] = implode(',', $tmp_sp);
									unset($tmp_sp);
								}
								$result_arr = $tc->reqdata($param);
								if(!is_array($result_arr) || !empty($result_arr['error_response'])){
									showDialog(Language::get('bp_download_goods_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
								}
								if(!empty($result_arr['items_list_get_response']['items']['item'])){
									foreach ($result_arr['items_list_get_response']['items']['item'] as $k=>$v){
										$product_list[] = $v;
									}
								}
							}
							/*处理商品数据*/
							$insert_array = array();
							//载入商品缓存
							$product_cache = ($t = F('product')) ? $t : H('product',true,'file');
							foreach ((array)$product_list as $k=>$v){
								//数据去重分析
								if(!empty($product_cache[$shop_id.'|'.$v['num_iid']])){
									$tmp_cache = $product_cache[$shop_id.'|'.$v['num_iid']];
									$tmp_pstatus = $v['approve_status']=='onsale'?1:2;
									$tmp_psku = serialize($v['skus']['sku']);
									if($tmp_cache['cp_code']!=$v['outer_id'] || $tmp_cache['cp_ori_price']!=$v['price'] || $tmp_cache['cp_name']!= $v['title'] || $tmp_cache['cp_pic']!= $v['pic_url'] || $tmp_cache['cp_postfee']!=$v['post_fee'] || $tmp_cache['cp_expressfee']!=$v['express_fee'] || $tmp_cache['cp_emsfee']!=$v['ems_fee'] || $tmp_cache['cp_status'] != $tmp_pstatus || $tmp_cache['cp_sku']!=$tmp_psku){
										$update_tmp_arr = array();
										$update_tmp_arr['cp_ori_price']  = $v['price'];
										$update_tmp_arr['cp_name']       = $v['title'];
										$update_tmp_arr['cp_status']     = $v['approve_status']=='onsale'?1:2;
										$update_tmp_arr['cp_pic']        = $v['pic_url'];
										$update_tmp_arr['cp_postfee']    = $v['post_fee']?floatval($v['post_fee']):0;
										$update_tmp_arr['cp_expressfee'] = $v['express_fee']?floatval($v['express_fee']):0;
										$update_tmp_arr['cp_emsfee']     = $v['ems_fee']?floatval($v['ems_fee']):0;
										$update_tmp_arr['cp_sku']        = serialize($v['skus']['sku']);
										$update_tmp_arr['cp_code']       = $v['outer_id'];
										$update_tmp_arr['cp_num']        = $v['num'];
										$update_tmp_arr['cp_updatetime']   = time();
										$update_tmp_arr['cp_updatestaff']  = $_SESSION['member_id'];
										$model->table('product')->where(array('shop_id'=>$shop_id,'cp_mallpid'=>$v['num_iid']))->update($update_tmp_arr);
										unset($update_tmp_arr);
									}
									unset($tmp_cache);
									unset($tmp_pstatus);
								}else{
									//插入数据
									$tmp_arr = array();
									$tmp_arr['cp_ori_price'] = $v['price'];
									$tmp_arr['cp_name']      = $v['title'];
									$tmp_arr['cp_updatetime']   = time();
									$tmp_arr['cp_updatestaff']  = $_SESSION['member_id'];
									$tmp_arr['cp_status']    = $v['approve_status']=='onsale'?1:2;
									$tmp_arr['cp_pic']       = $v['pic_url'];
									$tmp_arr['shop_id']      = $shop_id;
									$tmp_arr['cp_mallurl']   = $v['detail_url'];
									$tmp_arr['cp_mallpid']   = $v['num_iid'];
									$tmp_arr['cp_postfee']   = $v['post_fee']?floatval($v['post_fee']):0;
									$tmp_arr['cp_expressfee'] = $v['express_fee']?floatval($v['express_fee']):0;
									$tmp_arr['cp_emsfee']     = $v['ems_fee']?floatval($v['ems_fee']):0;
									$tmp_arr['cp_code']       = $v['outer_id'];
									$tmp_arr['cp_sku'] = serialize($v['skus']['sku']);
									$tmp_arr['cp_num'] = $v['num'];
									$insert_array[] = $tmp_arr;
									unset($tmp_arr);
								}
							}
							if(empty($insert_array)){
								H('product',true);
								showDialog(Language::get('bp_download_commodity_the_download_is_complete'),'','succ');
							}else{
								if($model->table('product')->insertAll($insert_array)){//*****SQL*****//
									H('product',true);
									showDialog(Language::get('bp_download_commodity_the_download_is_complete'),'','succ');
								}else{
									showDialog(Language::get('bp_download_goods_failed_download'));
								}
							}
							break;
						//淘宝订单下载（每次下载后记录最新订单的创建时间，+1后作为下次下载的起始创建时间）
						case 'order':
							H('product',true);
							$search_order_list = array();
							$param = array();
							$param['method']    = 'taobao.trades.sold.get';
							$param['session']   = $platinfo['session'];
							$param['fields']    = 'tid';
							$param['page_no']   = 1;
							$param['page_size'] = 100;
							$param['status']    = 'WAIT_SELLER_SEND_GOODS';
							if($shop_info['shop_lastorder'] > 0){
								$param['start_created'] = date('Y-m-d H:i:s',$shop_info['shop_lastorder']+1);
							}
							$result_arr = $tc->reqdata($param);
							if(!is_array($result_arr) || !empty($result_arr['error_response'])){
								if($result_arr['error_response']['msg'] == 'Invalid session:session-expired'){
									//处理session过期
									$model->table('shop')->where(array('shop_id'=>intval($_GET['shop_id'])))->update(array('shop_connect'=>0,'shop_platinfo'=>''));
									showDialog(Language::get('bp_download_taobao_the_session_expires').Language::get('bp_comma').Language::get('bp_download_please_bind_again'));
								}
								showDialog(Language::get('bp_download_the_order_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
							}
							if(!empty($result_arr['trades_sold_get_response']['trades']['trade'])){
								foreach ($result_arr['trades_sold_get_response']['trades']['trade'] as $k=>$v){
									$search_order_list[] = $v['tid'];
								}
							}
							$all_num = $result_arr['trades_sold_get_response']['total_results'];
							$page = ceil($all_num/200);
							if($page > 1){
								for ($i=2;$i<=$page;$i++){
									$param['page_no'] = $i;
									$result_arr = $tc->reqdata($param);
									if(!is_array($result_arr) || !empty($result_arr['error_response'])){
										showDialog(Language::get('bp_download_the_order_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
									}
									if(!empty($result_arr['trades_sold_get_response']['trades']['trade'])){
										foreach ($result_arr['trades_sold_get_response']['trades']['trade'] as $k=>$v){
											$search_order_list[] = $v['tid'];
										}
									}
								}
							}
							if(empty($search_order_list)){
								showDialog(Language::get('bp_download_the_shop_no_order_data_are_available_for_download'));
							}
							$order_list = array();
							$param_tradeinfo = array();
							$param_tradeinfo['method'] = 'taobao.trade.get';
							$param_tradeinfo['session'] = $platinfo['session'];
							$param_tradeinfo['field'] = 'tid,title,status,type,created,total_fee,payment,pay_time,buyer_nick,buyer_message,seller_memo,pay_time,shipping_type,post_fee,receiver_name,receiver_state,receiver_city,receiver_district,receiver_address,receiver_zip,receiver_mobile,receiver_phone,orders.title,orders.num_iid,orders.price,orders.num,orders.total_fee';
							foreach ((array)$search_order_list as $val){
								$param_tradeinfo['tid'] = $val;
								$result_arr = $tc->reqdata($param_tradeinfo);
								if(!is_array($result_arr) || !empty($result_arr['error_response'])){
									showDialog(Language::get('bp_download_the_order_failed_download').Language::get('bp_comma').'ERROR:'.$result_arr['error_response']['msg']);
								}
								$order_list[] = $result_arr['trade_get_response']['trade'];
							}
							/*处理获得的订单数组信息*/
							$cache_product  = ($t = F('product')) ? $t : H('product',true,'file');
							$insert_order_product_array = array();
							$shop_lastorder = 0;
							foreach ((array)$order_list as $k=>$v){
								if($k==0){
									$shop_lastorder = strtotime($v['created']);
								}
								$tmp_order = array(
									'co_subject'=>$v['title'],
									'co_code'=>$v['tid'],
									'co_addtime'=>strtotime($v['created']),
									'co_total_price'=>$v['total_fee'],
									'co_final_price'=>$v['payment'],
									'co_buyermsg'=>$v['buyer_message'],
									'co_sellermemo'=>$v['seller_memo'],
									'shop_id'=>$shop_id,
									'co_malloid'=>$v['tid'],
									'express_payment'=>$v['post_fee']?floatval($v['post_fee']):0,
									'co_status'=>0,
									'co_paytime'=>$v['pay_time']!=''?strtotime($v['pay_time']):0,
									'co_hdfk'=>$v['type']=='cod'?1:0
								);
								//判断买家会员是否存在
								$cc_info = $model->field('cc_id,cc_name')->table('customer')->where(array('shop_id'=>$shop_id,'cc_name'=>$v['buyer_nick']))->find();
								if(!empty($cc_info)){
									$tmp_order['cc_id'] = $cc_info['cc_id'];
									$address_info = $model->field('address_id,receiver_name')->table('address')->where(array('cc_id'=>$cc_info['cc_id'],'receiver_name'=>$v['receiver_name'],'address_detail'=>$v['receiver_state'].$v['receiver_city'].$v['receiver_district'].$v['receiver_address']))->find();
									if(!empty($address_info)){
										$tmp_order['address_id'] = $address_info['address_id'];
									}else{
										//添加地址信息
										$insert_address_array = array(
											'cc_id'=>$tmp_order['cc_id'],
											'receiver_name'=>$v['receiver_name'],
											'address_detail'=>$v['receiver_state'].$v['receiver_city'].$v['receiver_district'].$v['receiver_address'],
											'postcode'=>$v['receiver_zip']!=''?$v['receiver_zip']:'',
											'phone'=>$v['receiver_phone']!=''?$v['receiver_phone']:'',
											'mobilephone'=>$v['receiver_mobile']!=''?$v['receiver_mobile']:''
										);
										$tmp_order['address_id'] = $model->table('address')->insert($insert_address_array);
									}
								}else{
									//添加买家会员+地址信息
									$insert_customer_array = array(
										'cc_name'=>$v['buyer_nick'],
										'cc_type'=>2,
										'cc_important'=>2,//重要程度默认为“中”
										'shop_id'=>$shop_id,
										'shop_nickname'=>$v['buyer_nick'],
										'cc_addtime'=>time()
									);
									$tmp_order['cc_id'] = $model->table('customer')->insert($insert_customer_array);
									$insert_address_array = array(
										'cc_id'=>$tmp_order['cc_id'],
										'receiver_name'=>$v['receiver_name'],
										'address_detail'=>$v['receiver_state'].$v['receiver_city'].$v['receiver_district'].$v['receiver_address'],
										'postcode'=>$v['receiver_zip']!=''?$v['receiver_zip']:'',
										'phone'=>$v['receiver_phone']!=''?$v['receiver_phone']:'',
										'mobilephone'=>$v['receiver_mobile']!=''?$v['receiver_mobile']:''
									);
									$tmp_order['address_id'] = $model->table('address')->insert($insert_address_array);
								}
								//订单信息处理
								$co_id = $model->table('orders')->insert($tmp_order);
								unset($tmp_order);
								$all_cost = 0;
								foreach ((array)$v['orders']['order'] as $ok=>$ov){
									$cp_info = $cache_product[$shop_id.'|'.$ov['num_iid']];
									$insert_order_product_array[] = array(
										'cp_id'=>$cp_info['cp_id'],
										'co_id'=>$co_id,
										'cop_unitprice'=>$ov['price'],
										'cop_pnum'=>$ov['num'],
										'cop_total_price'=>$ov['total_fee'],
										'cp_ori_price'=>$cp_info['cp_ori_price'],
										'cp_cost'=>$cp_info['cp_cost']
									);
									$all_cost += $cp_info['cp_cost']*$ov['num'];
									unset($cp_info);
								}
								//更新订单成本信息
								$model->table('orders')->where(array('co_id'=>$co_id))->update(array('co_cost_price'=>$all_cost));
								unset($all_cost);
							}
							$model->table('order_product')->insertAll($insert_order_product_array);
							//记录最后下载订单的创建时间
							$model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_lastorder'=>$shop_lastorder));
							H('shop',true);
							showDialog(Language::get('bp_download_download_the_order_success'),"","succ");
							break;
					}
					break;
				/**
				 * ShopEx单店数据下载
				 */
				case 3:
					$platinfo = unserialize($shop_info['shop_platinfo']);
					$shopex_api = $platinfo['shopex_apiurl'];
					$model = Model();
					switch (trim($_POST['dl_type'])){
						//ShopEx单店商品下载
						case 'product':
							$final_url = $shopex_api.'/index.php?command=product';
							$opts = array(
							  'http'=>array(
							    'method'=>"GET",
							    'timeout'=>60,
							   )
							);
							$context   = stream_context_create($opts);
							$json_data = file_get_contents($final_url,false,$context);
							if($json_data === false){
								showDialog(Language::get('bp_download_download_data_failed'),'','error');
							}
							$product_list = json_decode($json_data,true);
							if($product_list['code']=='404' || $product_list['code']=='500'){
								showDialog(Language::get('bp_download_download_data_failed'),'','error');
							}
							if(empty($product_list['datas'])){
								showDialog(Language::get('bp_download_no_data_available_for_download_at_present'),'','error');
							}
							$product_list = $product_list['datas'];
							/*处理商品数据*/
							$insert_array = array();
							//载入商品缓存
							$product_cache = ($t = F('product')) ? $t : H('product',true,'file');
							foreach ((array)$product_list as $k=>$v){
								//数据去重分析
								if(!empty($product_cache[$shop_id.'|'.$v['goods_id']])){
									$tmp_cache = $product_cache[$shop_id.'|'.$v['goods_id']];
									$tmp_pstatus = $v['marketable']=='true'?1:2;
									$tmp_psku = serialize($v['sku']);
									if($tmp_cache['cp_code']!=$v['bn'] || $tmp_cache['cp_ori_price']!=$v['price'] || $tmp_cache['cp_name']!= $v['name'] || $tmp_cache['cp_pic']!= $v['thumbnail_pic'] || $tmp_cache['cp_status'] != $tmp_pstatus || $tmp_cache['cp_sku']!=$tmp_psku){
										$update_tmp_arr = array();
										$update_tmp_arr['cp_ori_price']  = $v['price'];
										$update_tmp_arr['cp_name']       = $v['name'];
										$update_tmp_arr['cp_status']     = $v['marketable']=='true'?1:2;
										$update_tmp_arr['cp_pic']        = $v['thumbnail_pic'];
										$update_tmp_arr['cp_postfee']    = 0;
										$update_tmp_arr['cp_expressfee'] = 0;
										$update_tmp_arr['cp_emsfee']     = 0;
										$update_tmp_arr['cp_sku']        = serialize($v['sku']);
										$update_tmp_arr['cp_code']       = $v['bn'];
										$update_tmp_arr['cp_num']        = $v['store'];
										$update_tmp_arr['cp_updatetime']   = time();
										$update_tmp_arr['cp_updatestaff']  = $_SESSION['member_id'];
										$model->table('product')->where(array('shop_id'=>$shop_id,'cp_mallpid'=>$v['goods_id']))->update($update_tmp_arr);
										unset($update_tmp_arr);
									}
									unset($tmp_cache);
									unset($tmp_pstatus);
								}else{
									//插入数据
									$tmp_arr = array();
									$tmp_arr['cp_ori_price'] = $v['price'];
									$tmp_arr['cp_name']      = $v['name'];
									$tmp_arr['cp_updatetime']   = time();
									$tmp_arr['cp_updatestaff']  = $_SESSION['member_id'];
									$tmp_arr['cp_status']    = $v['marketable']=='true'?1:2;
									$tmp_arr['cp_pic']       = $v['thumbnail_pic'];
									$tmp_arr['shop_id']      = $shop_id;
									$tmp_arr['cp_mallurl']   = $v['url'];
									$tmp_arr['cp_mallpid']   = $v['goods_id'];
									$tmp_arr['cp_postfee']   = 0;
									$tmp_arr['cp_expressfee'] = 0;
									$tmp_arr['cp_emsfee']     = 0;
									$tmp_arr['cp_code']       = $v['bn'];
									$tmp_arr['cp_sku'] = serialize($v['sku']);
									$tmp_arr['cp_num'] = $v['store'];
									$insert_array[] = $tmp_arr;
									unset($tmp_arr);
								}
							}
							if(empty($insert_array)){
								H('product',true);
								showDialog(Language::get('bp_download_commodity_the_download_is_complete'),'','succ');
							}else{
								if($model->table('product')->insertAll($insert_array)){//*****SQL*****//
									H('product',true);
									showDialog(Language::get('bp_download_commodity_the_download_is_complete'),'','succ');
								}else{
									showDialog(Language::get('bp_download_goods_failed_download'));
								}
							}
							break;
						//ShopEx单店订单下载
						case 'order':
							$final_url = $shopex_api.'/index.php?command=order';
							if($shop_info['shop_lastorder'] > 0){
								$final_url .= '&time='.$shop_info['shop_lastorder'];
							}
							$opts = array(
							  'http'=>array(
							    'method'=>"GET",
							    'timeout'=>60,
							   )
							);
							$context   = stream_context_create($opts);
							$json_data = file_get_contents($final_url,false,$context);
							if($json_data === false){
								showDialog(Language::get('bp_download_download_data_failed'),'','error');
							}
							$order_list = json_decode($json_data,true);
							if($order_list['code']=='404' || $order_list['code']=='500'){
								showDialog(Language::get('bp_download_download_data_failed'),'','error');
							}
							if(empty($order_list['datas'])){
								showDialog(Language::get('bp_download_no_data_available_for_download_at_present'),'','error');
							}
							$order_list = $order_list['datas'];
							H('product',true);
							/*处理获得的订单数组信息*/
							$cache_product  = ($t = F('product')) ? $t : H('product',true,'file');
							$insert_order_product_array = array();
							$shop_lastorder = 0;
							$last_sign = true;
							foreach ((array)$order_list as $k=>$v){
								if($last_sign){
									$shop_lastorder = $v['createtime'];
									$last_sign = false;
								}
								$tmp_order = array(
									'co_subject'=>'',
									'co_code'=>$v['order_id'],
									'co_addtime'=>$v['createtime'],
									'co_total_price'=>$v['cost_item'],
									'co_final_price'=>$v['total_amount'],
									'co_buyermsg'=>$v['memo']?$v['memo']:'',
									'co_sellermemo'=>$v['mark_text']?$v['mark_text']:'',
									'shop_id'=>$shop_id,
									'co_malloid'=>$v['order_id'],
									'express_payment'=>$v['cost_freight']?floatval($v['cost_freight']):0,
									'co_status'=>0,
									'co_paytime'=>0,
									'co_hdfk'=>0
								);
								//判断买家会员是否存在
								$cc_info = $model->field('cc_id,cc_name')->table('customer')->where(array('shop_id'=>$shop_id,'cc_name'=>$v['uname']))->find();
								if(!empty($cc_info)){
									$tmp_order['cc_id'] = $cc_info['cc_id'];
									$address_info = $model->field('address_id,receiver_name')->table('address')->where(array('cc_id'=>$cc_info['cc_id'],'receiver_name'=>$v['ship_name'],'address_detail'=>$v['ship_addr']))->find();
									if(!empty($address_info)){
										$tmp_order['address_id'] = $address_info['address_id'];
									}else{
										//添加地址信息
										$insert_address_array = array(
											'cc_id'=>$tmp_order['cc_id'],
											'receiver_name'=>$v['ship_name'],
											'address_detail'=>$v['ship_addr'],
											'postcode'=>$v['ship_zip']!=''?$v['ship_zip']:'',
											'phone'=>$v['ship_tel']!=''?$v['ship_tel']:'',
											'mobilephone'=>$v['ship_mobile']!=''?$v['ship_mobile']:''
										);
										$tmp_order['address_id'] = $model->table('address')->insert($insert_address_array);
									}
								}else{
									//添加买家会员+地址信息
									$insert_customer_array = array(
										'cc_name'=>$v['uname'],
										'cc_type'=>2,
										'cc_important'=>2,//重要程度默认为“中”
										'shop_id'=>$shop_id,
										'shop_nickname'=>$v['uname'],
										'cc_addtime'=>time()
									);
									$tmp_order['cc_id'] = $model->table('customer')->insert($insert_customer_array);
									$insert_address_array = array(
										'cc_id'=>$tmp_order['cc_id'],
										'receiver_name'=>$v['ship_name'],
										'address_detail'=>$v['ship_addr'],
										'postcode'=>$v['ship_zip']!=''?$v['ship_zip']:'',
										'phone'=>$v['ship_tel']!=''?$v['ship_tel']:'',
										'mobilephone'=>$v['ship_mobile']!=''?$v['ship_mobile']:''
									);
									$tmp_order['address_id'] = $model->table('address')->insert($insert_address_array);
								}
								//订单信息处理
								$co_id = $model->table('orders')->insert($tmp_order);
								unset($tmp_order);
								$all_cost = 0;
								foreach ((array)$v['cp_list'] as $ok=>$ov){
									$cp_info = $cache_product[$shop_id.'|'.$ov['goods_id']];
									$insert_order_product_array[] = array(
										'cp_id'=>$cp_info['cp_id'],
										'co_id'=>$co_id,
										'cop_unitprice'=>$ov['price'],
										'cop_pnum'=>$ov['nums'],
										'cop_total_price'=>$ov['amount'],
										'cp_ori_price'=>$cp_info['cp_ori_price'],
										'cp_cost'=>$cp_info['cp_cost']
									);
									$all_cost += $cp_info['cp_cost']*$ov['num'];
									unset($cp_info);
								}
								//更新订单成本信息
								$model->table('orders')->where(array('co_id'=>$co_id))->update(array('co_cost_price'=>$all_cost));
								unset($all_cost);
							}
							$model->table('order_product')->insertAll($insert_order_product_array);
							//记录最后下载订单的创建时间
							$model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_lastorder'=>$shop_lastorder));
							H('shop',true);
							showDialog(Language::get('bp_download_download_the_order_success'),"","succ");
							break;
					}
					break;
			}
		}
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('download');
		/**
		 * 模板输出
		 */
		Tpl::showpage('download');
	}
	/**
	 * 抓取数据
	 *
	 * @param $sid 商城店铺ID
	 * @param $type 数据类型
	 * @param $page 数据请求页数，默认为1
	 * @param $size 单次数据请求量，默认为100
	 * @param $signkey 店铺在商城的key
	 * @param $stdtime 下载订单的起始创建时间
	 *
	 * @return 数据信息数组；数据为空数组或失败均返回false
	 */
	private function getdata($sid,$type,$page=1,$api_url,$signkey,$stdtime){
		$size=100;
		$timeout=60;
		if(intval($sid) <=0  || $type == ''){ $this->rs_data = false; return false;}
		if($api_url == ''){ $this->rs_data = false; return false; }
		//接口请求参数
		switch ($type){
			case 'product':
				$r_url .= 'commend=product&sid='.$sid.'&page='.$page.'&size='.$size;
				$stdtime = trim($_POST['start_date']) != ''?strtotime(trim($_POST['start_date']).' '.trim($_POST['start_time'])):0;
				$endtime = trim($_POST['end_date']) != ''?strtotime(trim($_POST['end_date']).' '.trim($_POST['end_time'])):0;
				break;
			case 'order':
				$r_url .= 'commend=order&sid='.$sid.'&page='.$page.'&size='.$size;
				if($stdtime != 0){ $r_url .= '&stdtime='.($stdtime+1); }
				break;
		}
		//sign签权参数
		$key = rawurlencode(authcode($r_url,$signkey,''));
		$final_url = $api_url.'/index.php?sign='.$key.'&sid='.$sid;
		$opts = array(
		  'http'=>array(
		    'method'=>"GET",
		    'timeout'=>$timeout,
		   )
		);
		$context   = stream_context_create($opts);
		$json_data = file_get_contents($final_url,false,$context);
		//$this->rs_data = $stdtime; return false;
		if($json_data === false){
			$this->rs_data = false; return false;
		}
		$data = json_decode($json_data,true);
		if($data['code'] == '404' || $data['code'] == '500'){ $this->rs_data = false; return false; }
		if(empty($data['datas'])){ $this->rs_data = null; return false; }
		$this->rs_data = $data['datas'];
		return true;
	}
	/**
	 * 保存下载的数据
	 *
	 * @param $type 数据类型
	 * @param $data_arr 数据信息数组
	 * @return bool
	 */
	private function save_data($type,$data_arr,$shop_id){
		if($type == '' || empty($data_arr) || !is_array($data_arr)){ return false; }
		$model = Model();
		switch ($type){
			/*商品*/
			case 'product':
				H('product',true);
				$insert_array = array();
				if(empty($data_arr)){
					showDialog(Language::get('bp_download_download_the_shop_no_goods'));
				}
				//载入商品缓存
				$product_cache = ($t = F('product')) ? $t : H('product',true,'file');
				foreach ((array)$data_arr as $k=>$v){
					//计算总库存数量
					$all_num = 0;
					if(!empty($v['spec_list'])){
						foreach ($v['spec_list'] as $sk=>$sv){
							$all_num += $sv['storage'];
						}
					}
					//数据去重分析
					if(!empty($product_cache[$shop_id.'|'.$v['id']])){
						$tmp_cache = $product_cache[$shop_id.'|'.$v['id']];
						$tmp_pstatus = $v['state']==1?1:2;
						$tmp_psku = serialize($v['spec_list']);
						if($tmp_cache['cp_ori_price']!=$v['price'] || $tmp_cache['cp_name']!= $v['name'] || $tmp_cache['cp_pic']!= $v['thumb'] || $tmp_cache['cp_postfee']!=$v['py_price'] || $tmp_cache['cp_expressfee']!=$v['kd_price'] || $tmp_cache['cp_emsfee']!=$v['es_price'] || $tmp_cache['cp_status'] != $tmp_pstatus || $tmp_cache['cp_sku']!=$tmp_psku || $tmp_cache['cp_num']!=$all_num){
							$update_tmp_arr = array();
							$update_tmp_arr['cp_ori_price']  = $v['price'];
							$update_tmp_arr['cp_name']       = $v['name'];
							$update_tmp_arr['cp_status']     = $v['state']==1?1:2;
							$update_tmp_arr['cp_pic']        = $v['thumb'];
							$update_tmp_arr['cp_postfee']    = $v['py_price']!=''?$v['py_price']:0;
							$update_tmp_arr['cp_expressfee'] = $v['kd_price']!=''?$v['kd_price']:0;
							$update_tmp_arr['cp_emsfee']     = $v['es_price']!=''?$v['es_price']:0;
							$update_tmp_arr['cp_sku']        = serialize($v['spec_list']);
							$update_tmp_arr['cp_num']        = $all_num;
							$model->table('product')->where(array('shop_id'=>$shop_id,'cp_mallpid'=>$v['id']))->update($update_tmp_arr);
							unset($update_tmp_arr);
						}
						unset($tmp_cache);
						unset($tmp_pstatus);
					}else{
						//插入数据
						$tmp_arr = array();
						$tmp_arr['cp_ori_price'] = $v['price'];
						$tmp_arr['cp_name']      = $v['name'];
						$tmp_arr['cp_updatetime']   = time();
						$tmp_arr['cp_updatestaff']  = $_SESSION['member_id'];
						$tmp_arr['cp_status']    = $v['state']==1?1:2;
						$tmp_arr['cp_pic']       = $v['thumb'];
						$tmp_arr['shop_id']      = $shop_id;
						$tmp_arr['cp_mallurl']   = $v['url'];
						$tmp_arr['cp_mallpid']   = $v['id'];
						$tmp_arr['cp_postfee']   = $v['py_price']!=''?$v['py_price']:0;
						$tmp_arr['cp_expressfee'] = $v['kd_price']!=''?$v['kd_price']:0;
						$tmp_arr['cp_emsfee']     = $v['es_price']!=''?$v['es_price']:0;
						$tmp_arr['cp_sku'] = serialize($v['spec_list']);
						$tmp_arr['cp_num'] = $all_num;
						$insert_array[] = $tmp_arr;
						unset($tmp_arr);
					}
				}
				if(!empty($insert_array)){
					if($model->table('product')->insertAll($insert_array)){//*****SQL*****//
						showDialog(Language::get('bp_download_commodity_the_download_is_complete'),'','succ');
						H('product',true);
					}else{
						showDialog(Language::get('bp_download_goods_failed_download'));
					}
				}else{
					showDialog(Language::get('bp_download_commodity_the_download_is_complete'),'','succ');
					H('product',true);
				}
				break;
			/*订单*/
			case 'order':
				H('product',true);
				/*处理获得的订单数组信息*/
				$cache_product  = ($t = F('product')) ? $t : H('product',true,'file');
				$insert_order_product_array = array();
				$shop_lastorder = 0;
				foreach ((array)$data_arr as $k=>$v){
					if($k==0){
						$shop_lastorder = $v['createtime'];
					}
					$tmp_order = array(
						'co_subject'=>'',
						'co_code'=>$v['order_sn'],
						'co_addtime'=>$v['createtime'],
						'co_total_price'=>$v['goods_price'],
						'co_final_price'=>$v['order_price'],
						'co_buyermsg'=>$v['buyer_note']!=''?$v['buyer_note']:'',
						'co_sellermemo'=>'',
						'shop_id'=>$shop_id,
						'co_malloid'=>$v['order_sn'],
						'express_payment'=>$v['shipping_fee']!=''?$v['shipping_fee']:0,
						'co_status'=>0,
						'co_paytime'=>$v['payment_time']!=''?strtotime($v['payment_time']):0,
						'co_hdfk'=>$v['received_pay']!=''?$v['received_pay']:0
					);
					//判断买家会员是否存在
					$cc_info = $model->field('cc_id,cc_name')->table('customer')->where(array('shop_id'=>$shop_id,'cc_name'=>$v['member']['name']))->find();
					if(!empty($cc_info)){
						$tmp_order['cc_id'] = $cc_info['cc_id'];
						$address_info = $model->field('address_id,receiver_name')->table('address')->where(array('cc_id'=>$cc_info['cc_id'],'receiver_name'=>$v['address']['true_name'],'address_detail'=>$v['address']['area_info'].$v['address']['address']))->find();
						if(!empty($address_info)){
							$tmp_order['address_id'] = $address_info['address_id'];
						}else{
							//添加地址信息
							$insert_address_array = array(
								'cc_id'=>$tmp_order['cc_id'],
								'receiver_name'=>$v['address']['true_name'],
								'address_detail'=>$v['address']['area_info'].$v['address']['address'],
								'postcode'=>$v['address']['zip_code']!=''?$v['address']['zip_code']:'',
								'phone'=>$v['address']['tel_phone']!=''?$v['address']['tel_phone']:'',
								'mobilephone'=>$v['address']['mob_phone']!=''?$v['address']['mob_phone']:''
							);
							$tmp_order['address_id'] = $model->table('address')->insert($insert_address_array);
						}
					}else{
						//添加买家会员+地址信息
						$insert_customer_array = array(
							'cc_name'=>$v['member']['name'],
							'cc_type'=>2,
							'cc_important'=>2,//重要程度默认为“中”
							'shop_id'=>$shop_id,
							'shop_nickname'=>$v['member']['name'],
							'cc_addtime'=>$v['member']['createtime']
						);
						$tmp_order['cc_id'] = $model->table('customer')->insert($insert_customer_array);
						$insert_cpi_array = array(
							'cc_id'=>$tmp_order['cc_id'],
							'cpi_sex'=>$v['member']['sex'],
							'cpi_birthday'=>$v['member']['birthday']!=''?strtotime($v['member']['birthday']):0,
							'cpi_email'=>$v['member']['email']!=''?$v['member']['email']:'',
							'cpi_qq'=>$v['member']['qq']!=''?$v['member']['qq']:'',
							'cpi_ww'=>$v['member']['ww']!=''?$v['member']['ww']:'',
							'cpi_msn'=>$v['member']['msn']!=''?$v['member']['msn']:''
						);
						$model->table('personal_info')->insert($insert_cpi_array);
						$insert_address_array = array(
							'cc_id'=>$tmp_order['cc_id'],
							'receiver_name'=>$v['address']['true_name'],
							'address_detail'=>$v['address']['area_info'].$v['address']['address'],
							'postcode'=>$v['address']['zip_code']!=''?$v['address']['zip_code']:'',
							'phone'=>$v['address']['tel_phone']!=''?$v['address']['tel_phone']:'',
							'mobilephone'=>$v['address']['mob_phone']!=''?$v['address']['mob_phone']:''
						);
						$tmp_order['address_id'] = $model->table('address')->insert($insert_address_array);
					}
					//订单信息处理
					$co_id = $model->table('orders')->insert($tmp_order);
					unset($tmp_order);
					$all_cost = 0;
					foreach ((array)$v['goods_list'] as $ok=>$ov){
						$cp_info = $cache_product[$shop_id.'|'.$ov['goods_id']];
						$insert_order_product_array[] = array(
							'cp_id'=>$cp_info['cp_id'],
							'co_id'=>$co_id,
							'cop_unitprice'=>$ov['price'],
							'cop_pnum'=>$ov['goods_num'],
							'cop_total_price'=>$ov['price']*$ov['goods_num'],
							'cp_ori_price'=>$cp_info['cp_ori_price'],
							'cp_cost'=>$cp_info['cp_cost']
						);
						$all_cost += $cp_info['cp_cost']*$ov['goods_num'];
						unset($cp_info);
					}
					//更新订单成本信息
					$model->table('orders')->where(array('co_id'=>$co_id))->update(array('co_cost_price'=>$all_cost));
					unset($all_cost);
				}
				$model->table('order_product')->insertAll($insert_order_product_array);
				//记录最后下载订单的创建时间
				$model->table('shop')->where(array('shop_id'=>$shop_id))->update(array('shop_lastorder'=>$shop_lastorder));
				H('shop',true);
				showDialog(Language::get('bp_download_download_the_order_success'),"","succ");
				break;
		}
		return true;
	}
	/**
	 * 淘宝平台分类数据抓取函数
	 *
	 * @param $parent_cid 父类ID
	 * @param $get_child 是否递归获取所有子目录（默认为false）
	 * @return array 分类数据数组
	 */
	private function fetchcd_tb($parent_cid,$get_child = false){
		$tc = new TopClient();
		$tc->appKey    = '21365728';
		$tc->appSecret = 'c15e5a750ebf228744e8f268bf2d0849';
		$param = array();
		$param['method']        = 'taobao.itemcats.get';
		$param['fields']        = 'cid,parent_cid,name,is_parent,status';
		$param['parent_cid']    = $parent_cid==0?'0':$parent_cid;
		$result_arr = $tc->reqdata($param);
		if(!empty($result_arr['error_response'])){
			return $result_arr['error_response']['sub_msg'];
		}
		$data = $result_arr['itemcats_get_response']['item_cats']['item_cat'];
		if(!$get_child){
			return $data;
		}else{
			if(!empty($data)){
				foreach ($data as $k=>$v){
					$this->tb_catdata[] = $v;
					if($v['is_parent'] == true){
						$this->fetchcd_tb($v['cid'],true);
					}
				}
			}
		}
	}
	/**
	 * 获取淘宝根类目
	 */
	public function show_tbrootOp(){
		require(BasePath.'/framework/function/top.php');
		$data = $this->fetchcd_tb(0);
		echo json_encode($data);die;
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_download_download_the_data'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'download','menu_name'=>Language::get('bp_download_download_the_data'),'menu_act'=>'download','menu_op'=>'download');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}