<?php
/**
 * 数据字典
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class dictionaryControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('dictionary');
    }

	/**
	 * 数据字典列表
	 *
	 */
	public function indexOp(){
		/**
		 * 实例化模型
		 */
		$model_dic = Model();
		/**
		 * 调取数据字典信息
		 */
		$dic_menu_array = $this->setleftmenu(true);
		$dictionary_name = '';
		$cd_id = 0;
		$cd_model_id = 0;
		$cd_status = 1;
		if(is_array($dic_menu_array) && !empty($dic_menu_array)){
			foreach ((array)$dic_menu_array as $k=>$v){
				if($v['menu_op'] == trim($_GET['op'])){
					$dictionary_name = $v['menu_name'];
					if($v['cd_model_id'] == 0){
						$cd_key = $v['cd_key'];
						$cd_info = $model_dic->table('dictionary')->where("cd_key = '".$cd_key."'")->find();
						$cd_id = $cd_info['cd_id'];
					}else{
						$cd_status = $v['cd_status'];
						$cd_id = $v['cd_id'];
						$cd_model_id = $v['cd_model_id'];
						Tpl::output('cd_listshow_status',$v['cd_listshow_status']);
						Tpl::output('cd_listsearch_status',$v['cd_listsearch_status']);
					}
					break;
				}
			}
		}
		$dic_info_array = $model_dic->table('dictionary')->where(array('cd_parent_id'=>$cd_id))->select();
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu(false,trim($_GET['op']));
		/**
		 * 模板输出
		 */
		Tpl::output('cd_id',$cd_id);
		Tpl::output('dic_info_array',$dic_info_array);
		Tpl::output('dictionary_name',$dictionary_name);
		Tpl::output('cd_key',$cd_key);
		Tpl::output('cd_model_id',$cd_model_id);
		Tpl::output('cd_status',$cd_status);
		Tpl::showpage('dictionary_list');
	}
	/**
	 * 编辑数据字典
	 *
	 */
	public function dictionary_editOp(){
		/**
		 * 实例化模型
		 */
		$model_dic = Model();

		if (chksubmit()){
			//更新自定义字段的字段名、所属模块以及状态
			if($_POST['self_field'] == 'yes'){
				$model_dic->table('dictionary')->where(array('cd_id'=>intval($_POST['p_id'])))->update(array('cd_name'=>trim($_POST['self_cd_name']),'cd_status'=>intval($_POST['self_cd_status']),'cd_model_id'=>intval($_POST['cd_model_id']),'cd_listshow_status'=>intval($_POST['self_cd_listshow_status']),'cd_listsearch_status'=>intval($_POST['self_cd_listsearch_status'])));
			}
			//数据处理
			$cd_id = $_POST['cd_id'];
			$cd_name = $_POST['cd_name'];
			$p_id = trim($_POST['p_id']);
			$update_array = array();
			$insert_array = array();
			if(is_array($cd_id) && !empty($cd_id)){
				foreach ((array)$cd_id as $k=>$v){
					$update_array[$v] = array('cd_name'=>$cd_name[$k],'cd_model_id'=>intval($_POST['cd_model_id']));
				}
			}
			$id_num   = count($cd_id);
			$name_num = count($cd_name);
			if($name_num >$id_num){
				for ($i=$id_num;$i<$name_num;$i++){
					if($cd_name[$i] == ''){
						continue;
					}
					$insert_array[] = array('cd_name'=>$cd_name[$i],'cd_status'=>1,'cd_parent_id'=>$p_id,'cd_model_id'=>intval($_POST['cd_model_id']));
				}
			}
			//更新、添加数据库信息
			if(is_array($update_array) && !empty($update_array)){
				foreach ((array)$update_array as $k=>$v){
					$model_dic->table('dictionary')->where(array('cd_id'=>$k))->update(array('cd_name'=>$v['cd_name'],'cd_model_id'=>intval($_POST['cd_model_id'])));
				}
			}
			if(is_array($insert_array) && !empty($insert_array)){
				$model_dic->table('dictionary')->insertAll($insert_array);
			}
			showDialog(Language::get('bp_dictionary_data_dictionary_finished_update').Language::get('bp_comma').Language::get('bp_dictionary_please_update_the_cache'),'index.php?act=dictionary&op='.trim($_POST['op']),'succ');
		}
	}
	/**
	 * 自定义数据字典
	 *
	 */
	public function selfdic_addOp(){
		/**
		 * 实例化模型
		 */
		$model_dic = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cd_name"],"require"=>"true","message"=>Language::get('bp_dictionary_please_fill_out_the_field_names'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//判断是否存在该字段名
			$dic_info = $model_dic->table('dictionary')->where(array('cd_name'=>trim($_POST["cd_name"])))->find();
			if(!empty($dic_info)){
				showDialog(Language::get('bp_dictionary_the_field_name_is_already_in_use'),'','error');
			}
			//录入字段名
			$insert_array = array('cd_name'=>trim($_POST['cd_name']),'cd_parent_id'=>0,'cd_status'=>1,cd_model_id=>intval($_POST['cd_model_id']),'cd_listshow_status'=>intval($_POST['cd_listshow_status']),'cd_listsearch_status'=>intval($_POST['cd_listsearch_status']));
			$cd_id = $model_dic->table('dictionary')->insert($insert_array);
			if(!$cd_id){
				showDialog(Language::get('bp_dictionary_custom_fields_information_recorded_failure'),'','error');
			}
			//录入选项
			if(is_array($_POST['child_cd_name']) && !empty($_POST['child_cd_name'])){
				$insert_array_child = array();
				foreach ((array)$_POST['child_cd_name'] as $k=>$v){
					if($v != ''){
						$insert_array_child[] = array('cd_name'=>$v,'cd_parent_id'=>$cd_id,'cd_status'=>1,cd_model_id=>intval($_POST['cd_model_id']));
					}
				}
				$result = $model_dic->table('dictionary')->insertAll($insert_array_child);
				if(!$result){
					showDialog(Language::get('bp_dictionary_custom_fields_option_information_input_failed'),'','error');
				}
			}
			showDialog(Language::get('bp_dictionary_customize_data_fields_saved_successfully').Language::get('bp_comma').Language::get('bp_dictionary_please_update_the_cache'),'index.php?act=dictionary&op=selfdic_add','succ');
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu(false,'selfdic_add');
		/**
		 * 模板输出
		 */
		Tpl::showpage('selfdic_add');
	}
	/**
	 * 更新数据字典缓存文件
	 *
	 */
	public function cache_refreshOp(){
		/**
		 * 实例化模型
		 */
		$model_dic = Model();
		//调取数据库中的数据字典信息并写入缓存文件
		$tmp_array = $model_dic->table('dictionary')->select(array('limit'=>'all'));

		$dic_array = array();
		if(is_array($tmp_array) && !empty($tmp_array)){
			foreach ((array)$tmp_array as $k=>$v){
				if($v['cd_parent_id'] == 0){
					$tmp_child_array = array();
					foreach ((array)$tmp_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_array[$cv['cd_id']] = array('cd_id'=>$cv['cd_id'],'cd_name'=>$cv['cd_name'],'cd_status'=>$cv['cd_status']);
						}
					}
					$dic_array[$v['cd_key']] = array('class'=>array('cd_id'=>$v['cd_id'],'cd_name'=>$v['cd_name'],'cd_status'=>$v['cd_status'],'cd_model_id'=>$v['cd_model_id']),'child_option'=>$tmp_child_array);
					unset($tmp_child_array);
				}
			}
		}
		$file_path = BasePath.'/cache/dictionary.php';
		if(is_file($file_path)){
			@unlink($file_path);
		}
		$result = write_file($file_path, $dic_array);

		if($result){
			showDialog(Language::get('bp_dictionary_data_dictionary_cache_update_is_completed'),'index.php?act=dictionary&op='.trim($_GET['from_op']),'succ');
		}else{
			showDialog(Language::get('bp_dictionary_data_dictionary_cache_update_fails').Language::get('bp_comma').Language::get('bp_dictionary_please_try_again'),'','error');
		}
	}
	/**
	 * ajax改变数据字段使用状态
	 *
	 */
	public function dicstatus_editOp(){
		$cd_id  = intval($_GET['cd_id']);
		$cstate = intval($_GET['cstate']);
		if($cd_id > 0){
			$model = Model();
			$result = $model->table('dictionary')->where(array('cd_id'=>$cd_id))->update(array('cd_status'=>$cstate));
			if ($result){
				showDialog(Language::get('bp_dictionary_data_dictionary_state_is_changed').Language::get('bp_comma').Language::get('bp_dictionary_please_update_the_cache_to_take_effect'),'index.php?act=dictionary&op='.trim($_GET['ori_op']),'succ');
			}else{
				showDialog(Language::get('bp_dictionary_data_dictionary_status_change_failed'),'','error');
			}
		}else{
			showDialog(Language::get('bp_dictionary_parameter_error'),'','error');
		}
	}
	/**
	 * 设置左菜单
	 *
	 * @param $show_array 为true时将返回菜单数组信息
	 */
	private function setleftmenu($show_array = false,$menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_dictionary_system_data_dictionary'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>Language::get('bp_dictionary_members_related'),'menu_name'=>Language::get('bp_dictionary_members_related'),	'linktype'=>2);
		$arr[0]['submenu'][1] = array('menu_key'=>Language::get('bp_dictionary_member_type'),'menu_name'=>Language::get('bp_dictionary_member_type'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_member_type'),'cd_key'=>'customer_class');
		$arr[0]['submenu'][2] = array('menu_key'=>Language::get('bp_dictionary_their_industry'),'menu_name'=>Language::get('bp_dictionary_their_industry'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_their_industry'),'cd_key'=>'industry');
		$arr[0]['submenu'][3] = array('menu_key'=>Language::get('bp_dictionary_relationship_between_grades'),'menu_name'=>Language::get('bp_dictionary_relationship_between_grades'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_relationship_between_grades'),'cd_key'=>'relationship');
		$arr[0]['submenu'][4] = array('menu_key'=>Language::get('bp_dictionary_member_of_the_source'),'menu_name'=>Language::get('bp_dictionary_member_of_the_source'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_member_of_the_source'),'cd_key'=>'customer_from');
		$arr[0]['submenu'][5] = array('menu_key'=>Language::get('bp_dictionary_work_label'),'menu_name'=>Language::get('bp_dictionary_work_label'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_work_label'),'cd_key'=>'work_tag');
		$arr[0]['submenu'][6] = array('menu_key'=>Language::get('bp_dictionary_personnel_scale'),'menu_name'=>Language::get('bp_dictionary_personnel_scale'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_personnel_scale'),'cd_key'=>'staff_size');
		$arr[0]['submenu'][7] = array('menu_key'=>Language::get('bp_dictionary_products_related_to'),'menu_name'=>Language::get('bp_dictionary_products_related_to'),	'linktype'=>2);
		$arr[0]['submenu'][9] = array('menu_key'=>Language::get('bp_dictionary_pricing_strategy'),'menu_name'=>Language::get('bp_dictionary_pricing_strategy'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_pricing_strategy'),'cd_key'=>'price_strategy');
		$arr[0]['submenu'][10] = array('menu_key'=>Language::get('bp_dictionary_member_of_the_track'),'menu_name'=>Language::get('bp_dictionary_member_of_the_track'),	'linktype'=>2);
		$arr[0]['submenu'][11] = array('menu_key'=>Language::get('bp_dictionary_action_type'),'menu_name'=>Language::get('bp_dictionary_action_type'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_action_type'),'cd_key'=>'mission_type');
		$arr[0]['submenu'][12] = array('menu_key'=>Language::get('bp_dictionary_caring_type'),'menu_name'=>Language::get('bp_dictionary_caring_type'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_caring_type'),'cd_key'=>'care_type');

		$arr[0]['submenu'][13] = array('menu_key'=>Language::get('bp_dictionary_sales_opportunities'),'menu_name'=>Language::get('bp_dictionary_sales_opportunities'),	'linktype'=>2);
		$arr[0]['submenu'][14] = array('menu_key'=>Language::get('bp_dictionary_chance_to_type'),'menu_name'=>Language::get('bp_dictionary_chance_to_type'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_chance_to_type'),'cd_key'=>'chancetype');
		$arr[0]['submenu'][15] = array('menu_key'=>Language::get('bp_dictionary_source_of_opportunities'),'menu_name'=>Language::get('bp_dictionary_source_of_opportunities'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_source_of_opportunities'),'cd_key'=>'chancesource');
		$arr[0]['submenu'][16] = array('menu_key'=>Language::get('bp_dictionary_opportunity_to_stage'),'menu_name'=>Language::get('bp_dictionary_opportunity_to_stage'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_opportunity_to_stage'),'cd_key'=>'chancestage');
		$arr[0]['submenu'][17] = array('menu_key'=>Language::get('bp_dictionary_opportunity_possibility'),'menu_name'=>Language::get('bp_dictionary_opportunity_possibility'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_opportunity_possibility'),'cd_key'=>'chanceprobability');
		$arr[0]['submenu'][18] = array('menu_key'=>Language::get('bp_dictionary_the_order'),'menu_name'=>Language::get('bp_dictionary_the_order'),	'linktype'=>2);
		$arr[0]['submenu'][19] = array('menu_key'=>Language::get('bp_dictionary_terms_of_payment'),'menu_name'=>Language::get('bp_dictionary_terms_of_payment'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_terms_of_payment'),'cd_key'=>'paymethod');
		$arr[0]['submenu'][20] = array('menu_key'=>Language::get('bp_dictionary_the_order_type'),'menu_name'=>Language::get('bp_dictionary_the_order_type'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_the_order_type'),'cd_key'=>'ordertype');
		$arr[0]['submenu'][21] = array('menu_key'=>Language::get('bp_dictionary_shipment_delivery'),'menu_name'=>Language::get('bp_dictionary_shipment_delivery'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_shipment_delivery'),'cd_key'=>'express_delivery');
		$arr[0]['submenu'][22] = array('menu_key'=>Language::get('bp_dictionary_order_amount_range'),'menu_name'=>Language::get('bp_dictionary_order_amount_range'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_order_amount_range'),'cd_key'=>'orderamountinterval');

		$arr[0]['submenu'][23] = array('menu_key'=>Language::get('bp_dictionary_competitors'),'menu_name'=>Language::get('bp_dictionary_competitors'),	'linktype'=>2);
		$arr[0]['submenu'][24] = array('menu_key'=>Language::get('bp_dictionary_ability_to_compete'),'menu_name'=>Language::get('bp_dictionary_ability_to_compete'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_ability_to_compete'),'cd_key'=>'competitiveness');

		$arr[0]['submenu'][25] = array('menu_key'=>Language::get('bp_dictionary_other'),'menu_name'=>Language::get('bp_dictionary_other'),	'linktype'=>2);
		$arr[0]['submenu'][28] = array('menu_key'=>Language::get('bp_dictionary_store_classification'),'menu_name'=>Language::get('bp_dictionary_store_classification'),	'menu_act'=>'dictionary','menu_op'=>Language::get('bp_dictionary_store_classification'),'cd_key'=>'shop_class');

		$arr[1] = array('menu_name'=>Language::get('bp_dictionary_the_custom_data_dictionary'),	'menu_url'=>'#');
		$arr[1]['submenu'][0] = array('menu_key'=>'selfdic_add','menu_name'=>Language::get('bp_dictionary_new_fields'),	'menu_act'=>'dictionary','menu_op'=>'selfdic_add');

		Tpl::output('menu_key',$menu_key);

		//自定义数据字段
		$model_dic = Model();
		$selfdic_list = $model_dic->table('dictionary')->where(array('cd_parent_id'=>0,'cd_model_id'=>array('neq',0)))->select();
		if(is_array($selfdic_list) && !empty($selfdic_list)){
			$num = 1;
			foreach ((array)$selfdic_list as $k=>$v){
				$arr[1]['submenu'][$num] = array('menu_key'=>$v['cd_name'],'menu_name'=>$v['cd_name'],'menu_act'=>'dictionary','menu_op'=>$v['cd_name'],'cd_id'=>$v['cd_id'],'cd_model_id'=>$v['cd_model_id'],'cd_status'=>$v['cd_status'],'cd_listshow_status'=>$v['cd_listshow_status'],'cd_listsearch_status'=>$v['cd_listsearch_status']);
				$num += 1;
			}
		}
		//返回字段信息数组
		if($show_array){
			$menu_array = array();
			$arrnum = count($arr);
			for ($i=0;$i<$arrnum;$i++){
				foreach ((array)$arr[$i]['submenu'] as $k=>$v){
					$menu_array[] = $v;
				}
			}
			return $menu_array;
		}
		Tpl::output('leftmenu',$arr);
	}
}