<?php
/**
 * 默认展示页面
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class departmentControl extends BaseHomeControl{

    public function __construct()
    {
        parent::__construct();
        Language::read('department');
    }

	//首页
	public function departmentlistOp(){
		$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
		$usertree_arr = ($t = F('user')) ? $t : H('user',true,'file');
		foreach ((array)$tree_arr as $k=>$v){
			$i = 1;
			foreach ((array)$usertree_arr as $u_k=>$u_v){
				if ($u_v['user_department'] == $v['d_id']){
					$t = $u_v['jp_isleader'] == 1?0:$i;
					$tree_arr[$k]['user_arr'][$t] = $u_v;
					$i++;
					unset($usertree_arr[$u_k]);
				}
			}
			!empty($tree_arr[$k]['user_arr'])?ksort($tree_arr[$k]['user_arr']):'';
		}
		Tpl::output('dlist',$tree_arr);
		//左侧菜单
		$this->setleftmenu('departmentlist');
		Tpl::showpage('departmentlist');
	}
	/*
	 * 新增部门
	 */
	public function departmentaddOp(){
		$model = Model('department');
		if (chksubmit()){
			$pid = intval($_POST["d_pid"]);
			if($pid<=0){
				$pid = '';
			}
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["d_name"],"require"=>"true","message"=>Language::get('bp_department_please_add_the_department_name'));
			$validate_arr[] = array("input"=>$pid, "require"=>'true',"message"=>Language::get('bp_department_please_select_a_superior_departments'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询父级信息
			$p_info = $model->table('department')->where(array('d_id'=>$pid))->find();
			if(empty($p_info)){
				showDialog(Language::get('bp_department_the_superior_department_information_errors'),'','error');
			}
			//同一父类部门下不能存在相同名称的部门
			$same_department = $model->table('department')->where(array('d_name'=>$_POST['d_name'],'d_parentid'=>$pid))->find();
			if (!empty($same_department)){
				showDialog(Language::get('bp_department_department_name_already_exists'),'','error');
			}
			$insert_arr = array();
			$insert_arr['d_name'] = $_POST['d_name'];
			$insert_arr['d_intro'] = $_POST['d_intro'];
			$insert_arr['d_parentid'] = $p_info['d_id'];
			if (empty($p_info['d_allparentid'])){
				$insert_arr['d_allparentid'] = ",{$p_info['d_id']},";
			}else {
				$insert_arr['d_allparentid'] = "{$p_info['d_allparentid']}{$p_info['d_id']},";
			}
			$insert_arr['d_depth'] = $p_info['d_depth']+1;
			$insert_arr['d_state'] = $_POST['status'];
			if ($p_info['d_state'] == 0){//父部门关闭，则子部门必定关闭
				$insert_arr['d_state'] = 0;
			}
			$rs = $model->table('department')->insert($insert_arr);
			if ($rs){
				H('department',true,'file');//更新缓存
				showDialog(Language::get('bp_department_department_of_new_success'),'index.php?act=department&op=departmentlist','succ');
			}else {
				showDialog(Language::get('bp_department_department_of_new_failure'),'','error');
			}
		}else {
			//父级id
			$pid = $_GET['pid'];
			$pid = $pid>0?$pid:0;
			//获得部门select
			$selecthtml = $model->getDepartmentCacheSelect(true,$pid);
			Tpl::output('selecthtml',$selecthtml);
			//左侧菜单
			$this->setleftmenu('departmentlist');
			Tpl::showpage('departmentadd');
		}
	}
	/**
	 * 编辑部门状态
	 */
	private function editstate(){
		$id = intval($_GET['id']);
		if ($id<=0){
			showDialog(Language::get('bp_department_parameter_error'),'','error');
		}
		//查询部门信息
		$model = Model();
		$p_info = $model->table('department')->where(array('d_id'=>$id))->find();
		if (empty($p_info)){
			showDialog(Language::get('bp_department_wrong_information'),'','error');
		}
		$cstate = 0;
		if ($_GET['cstate'] == 1){
			$cstate = 1;
		}
		if ($cstate == 1){//开启部门时，则其上级部门必须开启
			if (empty($p_info['d_allparentid'])){
				$where = array('d_id'=>$p_info['d_id']);
			}else{
				$where = array('d_id'=>array('in',$p_info['d_allparentid'].$p_info['d_id']));
			}
			$rs = $model->table('department')->where($where)->update(array('d_state'=>1));
		}else {//关闭部门时，则其下级部门必须关闭
			$where = array();
			$dlist = ($t = F('department')) ? $t : H('department',true,'file');
			if (!empty($dlist[$p_info['d_id']])){
				$where['d_id'] = array('in',$dlist[$p_info['d_id']]['son'].','.$p_info['d_id']);
			}else {
				$where['d_id'] = $p_info['d_id'];
				if (empty($p_info['d_allparentid'])){
					$where['d_allparentid'] = array('like',"%,".$p_info['d_id'].",%");
				}else {
					$where['d_allparentid'] = array('like',"%".$p_info['d_allparentid'].$p_info['d_id'].",%");
				}
				$where['_op'] = 'or';
			}
			$rs = $model->table('department')->where($where)->update(array('d_state'=>0));
		}
		if ($rs){
			H('department',true,'file');//更新缓存
			showDialog(Language::get('bp_department_department_of_state_is_changed'),'index.php?act=department&op=departmentlist','succ');
		}else{
			showDialog(Language::get('bp_department_department_of_state_changes_fail'),'','error');
		}
	}
	/**
	 * 编辑部门信息（type=state:编辑状态;）
	 */
	public function departmenteditOp(){
		if (!empty($_GET['type'])){
			$funname = "edit".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else {
			//一般编辑操作
			$id = intval($_GET['id']);
			if ($id<=0){
				$id = intval($_POST['id']);
			}
			if ($id<=0){
				showDialog(Language::get('bp_department_parameter_error'),'','error');
			}
			$model = Model('department');
			//查询部门信息
			$d_info = $model->table('department')->where(array('d_id'=>$id))->find();
			if (empty($d_info)){
				showDialog(Language::get('bp_department_wrong_information'),'','error');
			}
			if (chksubmit()){
				$pid = intval($_POST["d_pid"]);
				if($pid<=0){
					$pid = 0;
				}
				$obj_validate = new Validate();
				$validate_arr[] = array("input"=>$_POST["d_name"],"require"=>"true","message"=>Language::get('bp_department_please_add_the_department_name'));
				//编辑顶级父类“公司”id为1时，不编辑上级部门
				if ($d_info['d_id'] != 1){
					$validate_arr[] = array("input"=>$pid, "require"=>'true',"message"=>Language::get('bp_department_please_select_a_superior_departments'));
				}
				$obj_validate -> validateparam = $validate_arr;
				$error = $obj_validate->validate();
				if ($error != ''){
					showDialog($error,'','error');
				}
				//同一父类部门下不能存在相同名称的部门
				if ($_POST['d_name'] != $d_info['d_name']){
					$same_department = $model->table('department')->where(array('d_name'=>$_POST['d_name'],'d_parentid'=>$pid))->find();
					if (!empty($same_department)){
						showDialog(Language::get('bp_department_department_name_already_exists'),'','error');
					}
				}
				//编辑顶级父类“公司”id为1时，不编辑上级部门
				if ($d_info['d_id'] != 1){
					//查询父级信息
					$p_info = $model->table('department')->where(array('d_id'=>$pid,'d_state'=>'1'))->find();
					if(empty($p_info)){
						showDialog(Language::get('bp_department_the_superior_department_information_errors'),'','error');
					}
				}
				$update_arr = array();
				$update_arr['d_name'] = $_POST['d_name'];
				$update_arr['d_intro'] = $_POST['d_intro'];
				//编辑顶级父类“公司”id为1时，不编辑上级部门
				if ($d_info['d_id'] != 1){
					$update_arr['d_parentid'] = $p_info['d_id']?$p_info['d_id']:0;
					if (empty($p_info['d_allparentid'])){
						$update_arr['d_allparentid'] = ",{$p_info['d_id']},";
					}else {
						$update_arr['d_allparentid'] = "{$p_info['d_allparentid']}{$p_info['d_id']},";
					}
					$update_arr['d_depth'] = $p_info['d_depth']+1;
				}
				$rs = $model->table('department')->where(array('d_id'=>$id))->update($update_arr);
				if ($rs){
					//部门层级移动则其下属部门也移动
					if ($pid != $d_info['d_parentid']){
						$c_depth = $d_info['d_depth'] - $update_arr['d_depth'];
						$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');//读取缓存
						if (!empty($tree_arr[$id])){//根据缓存更新
							if (empty($tree_arr[$id]['son'])){
								$model->execute("UPDATE ".C('tablepre')."department SET d_allparentid=replace(d_allparentid, '{$d_info['d_allparentid']}{$d_info['d_id']},','{$update_arr['d_allparentid']}{$d_info['d_id']},'),d_depth=d_depth-{$c_depth} WHERE (d_id in(''))");
							}else {
								$model->execute("UPDATE ".C('tablepre')."department SET d_allparentid=replace(d_allparentid, '{$d_info['d_allparentid']}{$d_info['d_id']},','{$update_arr['d_allparentid']}{$d_info['d_id']},'),d_depth=d_depth-{$c_depth} WHERE (d_id in({$tree_arr[$id]['son']}))");
							}
						}else{
							$model->execute("UPDATE ".C('tablepre')."department SET d_allparentid=replace(d_allparentid, '{$d_info['d_allparentid']}{$d_info['d_id']},','{$update_arr['d_allparentid']}{$d_info['d_id']},'),d_depth=d_depth-{$c_depth} WHERE (d_allparentid LIKE '{$d_info['d_allparentid']}{$d_info['d_id']},%')");
						}
					}
					H('department',true,'file');//更新缓存
					showDialog(Language::get('bp_department_department_to_edit_success'),'index.php?act=department&op=departmentlist','succ');
				}else {
					showDialog(Language::get('bp_department_department_to_edit_failed'),'','error');
				}
			}else {
				if (intval($d_info['d_parentid'])>0){
					//获得部门select
					$selecthtml = $model->getDepartmentCacheSelect(true,$d_info['d_parentid']);
				}
				Tpl::output('selecthtml',$selecthtml);
				Tpl::output('d_info',$d_info);
				//左侧菜单
				$this->setleftmenu('departmentlist');
				Tpl::showpage('departmentadd');
			}
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key){
		$arr[0] = array('menu_name'=>Language::get('bp_department_employees'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'departmentlist','menu_name'=>Language::get('bp_department_department_of_management'),	'menu_act'=>'department','menu_op'=>'departmentlist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'permissionlist','menu_name'=>Language::get('bp_department_permissions_set'),	'menu_act'=>'permission','menu_op'=>'permissionlist','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'jobpostlist','menu_name'=>Language::get('bp_department_post_management'),	'menu_act'=>'jobpost','menu_op'=>'jobpostlist','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'userlist','menu_name'=>Language::get('bp_department_staff_management'),	'menu_act'=>'user','menu_op'=>'userlist','linktype'=>'0');
		$arr[0]['submenu'][4] = array('menu_key'=>'userloglist','menu_name'=>Language::get('bp_department_employees_log'),	'menu_act'=>'user','menu_op'=>'userlog','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}
