<?php
/**
 * 会员分组管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class customergroupControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('customer_group');
	}
	/**
	 * 会员分组管理
	 */
	public function cgroupmanageOp(){
		if (!$_SESSION['shop_id']){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
		}
		//执行相应函数
		if (!empty($_GET['type'])){
			$funname = "cgroupmanage_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$this->cgroupmanage_list();
		}
	}
	/**
	 * 会员分组列表
	 */
	public function cgroupmanage_list(){
		$model = Model();
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['cgroup_shopid'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['search_shop']) > 0){
			$where['cgroup_shopid'] = intval($_GET['search_shop']);
		} elseif ($_GET['search_shop'] == 'all') {
			
		}else {
			//无所属店铺则找出默认店铺并进行优先显示
			$default_shop = 0;
			if(!empty($shop_list)){
				foreach ($shop_list as $k=>$v){
					if($v['shop_default'] == 1){
						$default_shop = $v['shop_id'];
						break;
					}
				}
				if ($default_shop > 0){
					$where['cgroup_shopid'] = intval($default_shop);
				}
				$_GET['search_shop'] = $default_shop;
			}
		}
		if ($_GET['search_name']){
			$where['cgroup_name'] = array('like',"%{$_GET['search_name']}%");
		}
		$cg_list = $model->table('customergroup,shop')->join('left')->on('customergroup.cgroup_shopid = shop.shop_id')->where($where)->order('cgroup_id desc')->page(20)->select();
		Tpl::output('cg_list',$cg_list);
		Tpl::output('show_page',$model->showpage(2));
		$this->setleftmenu('cgroupmanage');
		Tpl::showpage('customer_grouplist');
	}
	/**
	 * 新增会员分组
	 */
	public function cgroupmanage_add(){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cg_name"],"require"=>"true","message"=>Language::get('bp_customer_groupadd_please_add_the_group_name'));
			$validate_arr[] = array("input"=>$_POST["shopsel"],"require"=>"true","message"=>Language::get('bp_customer_groupadd_please_select_applicable_stores'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//-----------------按照条件查询会员数-----------------
			$cus_idarr = $this->statcus($_POST);
			$insert_arr = array();
			$insert_arr['cgroup_name'] = $_POST['cg_name'];
			$insert_arr['cgroup_shopid'] = $_POST['shopsel'];
			$insert_arr['cgroup_desc'] = $_POST['cg_remark'];
			$insert_arr['cgroup_orderrule'] = empty($_POST['orderrule'])?'':serialize($_POST['orderrule']);
			$insert_arr['cgroup_cusrule'] = empty($_POST['cusrule'])?'':serialize($_POST['cusrule']);
			$insert_arr['cgroup_arearule'] = empty($_POST['arearule'])?'':serialize($_POST['arearule']);
			$insert_arr['cgroup_cusnum'] = count($cus_idarr);
			$insert_arr['cgroup_cusid'] = !empty($cus_idarr)?serialize($cus_idarr):'';
			$insert_arr['cgroup_updatetime'] = time();
			$rs = $model->table('customergroup')->insert($insert_arr);
			if ($rs){
				showDialog(Language::get('bp_customer_groupadd_succ'),'index.php?act=customergroup&op=cgroupmanage','succ');
			}else {
				showDialog(Language::get('bp_customer_groupadd_fail'),'','error');
			}
		}else{
			//从缓存中调取数据字典信息
			$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('cgroupmanage');
			Tpl::showpage('customer_groupadd');
		}
	}
	/**
	 * 刷新会员信息
	 */
	public function cgroupmanage_refresh(){
		$cgid = $_GET['cgid'];
		if ($cgid <= 0){
			echo json_encode(array('done'=>false)); die;
		}
		//查询自定义分组
		$model = Model();
		$cg_info = $model->table('customergroup')->where(array('cgroup_id'=>$cgid))->find();
		if (empty($cg_info)){
			echo json_encode(array('done'=>false)); die;
		}
		$cg_info['orderrule'] = empty($cg_info['cgroup_orderrule'])?array():unserialize($cg_info['cgroup_orderrule']);
		$cg_info['cusrule'] = empty($cg_info['cgroup_cusrule'])?array():unserialize($cg_info['cgroup_cusrule']);
		$cg_info['arearule'] = empty($cg_info['cgroup_arearule'])?array('scope'=>'all','area'=>array()):unserialize($cg_info['cgroup_arearule']);
		$cg_info['shopsel'] = $cg_info['cgroup_shopid'];
		$cus_idarr = $this->statcus($cg_info);
		
		$update_arr = array();
		$update_arr['cgroup_cusnum'] = count($cus_idarr);
		$update_arr['cgroup_cusid'] = !empty($cus_idarr)?serialize($cus_idarr):'';
		$update_arr['cgroup_updatetime'] = time();
		$rs = $model->table('customergroup')->where(array('cgroup_id'=>$cgid))->update($update_arr);
		if ($rs){
			echo json_encode(array('done'=>true,'num'=>$update_arr['cgroup_cusnum'],'timestr'=>date('Y-m-d H:i:s',$update_arr['cgroup_updatetime']))); die;
		}else{
			echo json_encode(array('done'=>false)); die;
		}
	}
	/**
	 * 统计符合条件的会员信息
	 */
	private function statcus($conditions){
		$model = Model();
		$stat_where = array();
		$stat_where['shop_id'] = $conditions['shopsel'];
		//会员规则
		if (!empty($conditions['cusrule']['grade'])){
			$stat_where['cc_grade'] = $conditions['cusrule']['grade'];
		}
		if (!empty($conditions['cusrule']['credit'])){
			$stat_where['cc_credit_degree'] = $conditions['cusrule']['credit'];
		}
		if (!empty($conditions['cusrule']['class'])){
			$stat_where['cc_class'] = $conditions['cusrule']['class'];
		}
		if (!empty($conditions['cusrule']['relationship'])){
			$stat_where['cc_relationship'] = $conditions['cusrule']['relationship'];
		}
		if (!empty($conditions['cusrule']['from'])){
			$stat_where['cc_from'] = $conditions['cusrule']['from'];
		}
		//地区规则
		if ($conditions['arearule']['scope'] == 'part' && !empty($conditions['arearule']['area'])){
			$stat_where['cc_province'] = array('in',$conditions['arearule']['area']);
		}
		$cus_list = array();
		$cus_list = $model->table('customer')->field('cc_id')->where($stat_where)->select();
		$cus_idarr = array();
		if (!empty($cus_list)){
			foreach ($cus_list as $k=>$v){
				$cus_idarr[] = $v['cc_id'];
			}
		}
		unset($stat_where);//记得清除哦
		
		//订单规则
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['totality']['operator']) && !empty($conditions['orderrule']['totality']['val'])){//订单总数
			//等于
			$order_list = $model->table('orders')->field('cc_id,count(*) as totality')->where(array('shop_id'=>$conditions['shopsel']))->group('cc_id')->select();
			$ordercusid_totality = array();
			if (!empty($order_list)){
				foreach ($order_list as $k=>$v){
					switch ($conditions['orderrule']['totality']['operator']){
						case 'eq':
							if ($v['totality'] == $conditions['orderrule']['totality']['val'][0]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
						case 'elt':
							if ($v['totality'] <= $conditions['orderrule']['totality']['val'][0]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
						case 'egt':
							if ($v['totality'] >= $conditions['orderrule']['totality']['val'][0]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
						case 'between':
							if ($v['totality'] >= $conditions['orderrule']['totality']['val'][0] && $v['totality'] <= $conditions['orderrule']['totality']['val'][1]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
					}
				}
			}
			if (!empty($cus_idarr)){
				$noorder_cus = array();
				if ($conditions['orderrule']['totality']['val'][0] == 0){//当最小值为0时，订单信息不存在，但是仍符合条件
					$noorder_cus = array_flip($cus_idarr);
					foreach ((array)$order_list as $k=>$v){
						if (isset($noorder_cus[$v['cc_id']])){
							unset($noorder_cus[$v['cc_id']]);
						}
					}
					if (!empty($noorder_cus)){
						$noorder_cus = array_flip($noorder_cus);
					}
				}
				$cus_idarr = array_intersect($cus_idarr,$ordercusid_totality);
				if (!empty($noorder_cus)){
					$cus_idarr = array_merge($cus_idarr,$noorder_cus);
				}
			}
		}
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['amount']['operator']) && !empty($conditions['orderrule']['amount']['val'])){//订单总金额
			//等于
			$order_list = $model->table('orders')->field('cc_id,sum(co_final_price) as amount')->where(array('shop_id'=>$conditions['shopsel']))->group('cc_id')->select();
			$ordercusid_amount = array();
			if (!empty($order_list)){
				foreach ($order_list as $k=>$v){
					switch ($conditions['orderrule']['amount']['operator']){
						case 'eq':
							if ($v['amount'] == $conditions['orderrule']['amount']['val'][0]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
						case 'elt':
							if ($v['amount'] <= $conditions['orderrule']['amount']['val'][0]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
						case 'egt':
							if ($v['amount'] >= $conditions['orderrule']['amount']['val'][0]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
						case 'between':
							if ($v['amount'] >= $conditions['orderrule']['amount']['val'][0] && $v['amount'] <= $conditions['orderrule']['amount']['val'][1]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
					}
				}
			}
			if (!empty($cus_idarr)){
				$noorder_cus = array();
				if ($conditions['orderrule']['amount']['val'][0] == 0){//当最小值为0时，订单信息不存在，但是仍符合条件
					$noorder_cus = array_flip($cus_idarr);
					foreach ((array)$order_list as $k=>$v){
						if (isset($noorder_cus[$v['cc_id']])){
							unset($noorder_cus[$v['cc_id']]);
						}
					}
					if (!empty($noorder_cus)){
						$noorder_cus = array_flip($noorder_cus);
					}
				}
				$cus_idarr = array_intersect($cus_idarr,$ordercusid_amount);
				if (!empty($noorder_cus)){
					$cus_idarr = array_merge($cus_idarr,$noorder_cus);
				}
			}
		}
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['avgmoney']['operator']) && !empty($conditions['orderrule']['avgmoney']['val'])){//平均订单价
			//等于
			$order_list = $model->table('orders')->field('cc_id,sum(co_final_price)/count(*) as avgmoney')->where(array('shop_id'=>$conditions['shopsel']))->group('cc_id')->select();
			$ordercusid_avgmoney = array();
			if (!empty($order_list)){
				foreach ($order_list as $k=>$v){
					switch ($conditions['orderrule']['avgmoney']['operator']){
						case 'eq':
							if ($v['avgmoney'] == $conditions['orderrule']['avgmoney']['val'][0]){
								$ordercusid_avgmoney[] = $v['cc_id'];
							}
							break;
						case 'elt':
							if ($v['avgmoney'] <= $conditions['orderrule']['avgmoney']['val'][0]){
								$ordercusid_avgmoney[] = $v['cc_id'];
							}
							break;
						case 'egt':
							if ($v['avgmoney'] >= $conditions['orderrule']['avgmoney']['val'][0]){
								$ordercusid_avgmoney[] = $v['cc_id'];
							}
							break;
						case 'between':
							if ($v['avgmoney'] >= $conditions['orderrule']['avgmoney']['val'][0] && $v['avgmoney'] <= $conditions['orderrule']['avgmoney']['val'][1]){
								$ordercusid_avgmoney[] = $v['cc_id'];
							}
							break;
					}
				}
			}
			if (!empty($cus_idarr)){
				$noorder_cus = array();
				if ($conditions['orderrule']['avgmoney']['val'][0] == 0){//当最小值为0时，订单信息不存在，但是仍符合条件
					$noorder_cus = array_flip($cus_idarr);
					foreach ((array)$order_list as $k=>$v){
						if (isset($noorder_cus[$v['cc_id']])){
							unset($noorder_cus[$v['cc_id']]);
						}
					}
					if (!empty($noorder_cus)){
						$noorder_cus = array_flip($noorder_cus);
					}
				}
				$cus_idarr = array_intersect($cus_idarr,$ordercusid_avgmoney);
				if (!empty($noorder_cus)){
					$cus_idarr = array_merge($cus_idarr,$noorder_cus);
				}
			}
		}
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['cancel']['operator']) && !empty($conditions['orderrule']['cancel']['val'])){//平均订单价
			//等于
			$order_list = $model->table('orders')->field('cc_id,count(*) as cancel')->where(array('shop_id'=>$conditions['shopsel'],'co_status'=>'3'))->group('cc_id')->select();
			$ordercusid_cancel = array();
			if (!empty($order_list)){
				foreach ($order_list as $k=>$v){
					switch ($conditions['orderrule']['cancel']['operator']){
						case 'eq':
							if ($v['cancel'] == $conditions['orderrule']['cancel']['val'][0]){
								$ordercusid_cancel[] = $v['cc_id'];
							}
							break;
						case 'elt':
							if ($v['cancel'] <= $conditions['orderrule']['cancel']['val'][0]){
								$ordercusid_cancel[] = $v['cc_id'];
							}
							break;
						case 'egt':
							if ($v['cancel'] >= $conditions['orderrule']['cancel']['val'][0]){
								$ordercusid_cancel[] = $v['cc_id'];
							}
							break;
						case 'between':
							if ($v['cancel'] >= $conditions['orderrule']['cancel']['val'][0] && $v['cancel'] <= $conditions['orderrule']['cancel']['val'][1]){
								$ordercusid_cancel[] = $v['cc_id'];
							}
							break;
					}
				}
			}
			if (!empty($cus_idarr)){
				$noorder_cus = array();
				if ($conditions['orderrule']['cancel']['val'][0] == 0){//当最小值为0时，订单信息不存在，但是仍符合条件
					$noorder_cus = array_flip($cus_idarr);
					foreach ((array)$order_list as $k=>$v){
						if (isset($noorder_cus[$v['cc_id']])){
							unset($noorder_cus[$v['cc_id']]);
						}
					}
					if (!empty($noorder_cus)){
						$noorder_cus = array_flip($noorder_cus);
					}
				}
				$cus_idarr = array_intersect($cus_idarr,$ordercusid_cancel);
				if (!empty($noorder_cus)){
					$cus_idarr = array_merge($cus_idarr,$noorder_cus);
				}
			}
		}
		return $cus_idarr;
	} 
	/**
	 * 编辑会员分组
	 */
	public function cgroupmanage_edit(){
		$cgid = $_GET['cgid'];
		if ($cgid <= 0){
			$cgid = $_POST['cgid'];
		}
		if ($cgid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cg_name"],"require"=>"true","message"=>Language::get('bp_customer_groupadd_please_add_the_group_name'));
			$validate_arr[] = array("input"=>$_POST["shopsel"],"require"=>"true","message"=>Language::get('bp_customer_groupadd_please_select_applicable_stores'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//-----------------按照条件查询会员数-----------------
			$cus_idarr = $this->statcus($_POST);
			
			$update_arr = array();
			$update_arr['cgroup_name'] = $_POST['cg_name'];
			$update_arr['cgroup_shopid'] = $_POST['shopsel'];
			$update_arr['cgroup_desc'] = $_POST['cg_remark'];
			$update_arr['cgroup_orderrule'] = empty($_POST['orderrule'])?'':serialize($_POST['orderrule']);
			$update_arr['cgroup_cusrule'] = empty($_POST['cusrule'])?'':serialize($_POST['cusrule']);
			$update_arr['cgroup_arearule'] = empty($_POST['arearule'])?'':serialize($_POST['arearule']);
			$update_arr['cgroup_cusnum'] = count($cus_idarr);
			$update_arr['cgroup_cusid'] = !empty($cus_idarr)?serialize($cus_idarr):'';
			$update_arr['cgroup_updatetime'] = time();
			$rs = $model->table('customergroup')->where(array('cgroup_id'=>$cgid))->update($update_arr);
			if ($rs){
				showDialog(Language::get('bp_customer_group_editsucc'),'index.php?act=customergroup&op=cgroupmanage','succ');
			} else {
				showDialog(Language::get('bp_customer_group_editfail'),'','error');
			}
		}else{
			//查询自定义分组
			$cg_info = $model->table('customergroup')->where(array('cgroup_id'=>$cgid))->find();
			if (empty($cg_info)){
				showDialog(Language::get('bp_customer_group_recorderror'),'','error');
			}
			$cg_info['cgroup_orderrule_arr'] = empty($cg_info['cgroup_orderrule'])?array():unserialize($cg_info['cgroup_orderrule']);
			$cg_info['cgroup_cusrule_arr'] = empty($cg_info['cgroup_cusrule'])?array():unserialize($cg_info['cgroup_cusrule']);
			$cg_info['cgroup_arearule_arr'] = empty($cg_info['cgroup_arearule'])?array('scope'=>'all','area'=>array()):unserialize($cg_info['cgroup_arearule']);
			Tpl::output('cg_info',$cg_info);
			//从缓存中调取数据字典信息
			$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('cgroupmanage');
			Tpl::showpage('customer_groupadd');
		}
	}
	/**
	 * 查询分组名称是否存在
	 */
	public function cgroupmanage_check(){
		//查询分组信息
		$model = Model();
		$where = array();
		if (!empty($_GET['cgshopid'])){
			$where['cgroup_shopid'] = $_GET['cgshopid'];
		}
		$where['cgroup_name'] = $_GET['cgname'];
		$cg_info = $model->table('customergroup')->where($where)->find();
		if (empty($cg_info)){
			echo 'true'; die;
		}else{
			if ($cg_info['cgroup_id'] == $_GET['cgid']){
				echo 'true'; die;
			} else {
				echo 'false'; die;
			}
		}
	}
	/*
	 * 删除分组
	 */
	public function cgroupmanage_del(){
		$cgid = $_GET['cgid'];
		if (empty($cgid)){
			$cgid = $_POST['cgid'];
		}
		if (empty($cgid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (is_array($cgid)){
			$where['cgroup_id'] = array('in',$cgid);
		}else{
			$where['cgroup_id'] = $cgid;
		}
		$rs = $model->table('customergroup')->where($where)->delete();
		if ($rs){
			showDialog(Language::get('bp_customer_group_deletesucc'),'index.php?act=customergroup&op=cgroupmanage','succ');
		}else{
			showDialog(Language::get('bp_customer_group_deletefail'),'','error');
		}
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_member'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'customer_list','menu_name'=>Language::get('bp_home_member_manage'),	'menu_act'=>'customer','menu_op'=>'customer_list');
		$arr[0]['submenu'][1] = array('menu_key'=>'care_list','menu_name'=>Language::get('bp_home_member_care'),	'menu_act'=>'customer_care','menu_op'=>'care_list');
		$arr[0]['submenu'][2] = array('menu_key'=>'customer_history_list','menu_name'=>Language::get('bp_home_member_action'),	'menu_act'=>'customer','menu_op'=>'customer_history_list');
		
		$arr[1] = array('menu_name'=>Language::get('bp_home_member_group'),	'menu_url'=>'#');
		$arr[1]['submenu'][0] = array('menu_key'=>'cgroupmanage','menu_name'=>Language::get('bp_home_member_selfgroup'),'menu_act'=>'customergroup','menu_op'=>'cgroupmanage');
		
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}