<?php
/**
 * 会员关怀管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class customer_careControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('customercare');
	}
	/**
	 * 关怀列表
	 */
	public function care_listOp(){		
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('care_list');
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		/**
		 * 调取会员关怀记录信息列表
		 */
		
		//调取会员信息
		$model_customer = Model('customer');
		$where_condition = array();
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_withoutpermission'));
			}
			if(intval($_GET['shop_id']) == 0){
				redirect('index.php?act=customer_care&op=care_list&shop_id='.$_SESSION['shop_id']);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					redirect('index.php?act=customer_care&op=care_list&shop_id='.$default_shop);die;
				}
			}
		}
		//处理搜索表单内容
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'care_subject':
					$where_condition['customer_care.care_subject'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cc_name':
					$where_condition['customer.cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition['customer.shop_id'] = intval($_GET['shop_id']);
		}
		$care_list = $model->field('customer_care.*,customer.cc_name,customer.cc_type')->table('customer_care,customer')->join('left')->on('customer_care.cc_id=customer.cc_id')->where($where_condition)->page(10)->order('customer_care.care_id desc')->select();
		Tpl::output('care_list',$care_list);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model_customer->showpage(2));
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('care_list');
	}
	/**
	 * 新增关怀
	 */
	public function care_addOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 添加任务
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["care_subject"],"require"=>"true","message"=>Language::get('bp_care_subjectnull'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$insert_array = array();
			$insert_array['care_subject'] = trim($_POST['care_subject']);
			$insert_array['care_date'] = ($t = strtotime(trim($_POST['care_date']).' '.trim($_POST['care_time'])))>0?$t:0;
			$insert_array['cc_id'] = intval($_POST['cc_id']);
			$insert_array['ccc_id'] = intval($_POST['ccc_id']);
			$insert_array['care_content'] = trim($_POST['care_content']);
			$insert_array['care_type'] = intval($_POST['care_type']);
			$insert_array['care_feedback'] = trim($_POST['care_feedback']);
			$insert_array['care_note'] = trim($_POST['care_note']);
			$insert_array['care_addstaff'] = $_SESSION['member_id'];
			$insert_array['care_addtime'] = time();
			
			$rs = $model->table('customer_care')->insert($insert_array);
			//插入会员行动历史表中
			$insert_act_array = array();
			$insert_act_array['cc_id'] = intval($_POST['cc_id']);
			$insert_act_array['cca_addstaff'] = $_SESSION['member_id'];
			$insert_act_array['cca_addtime'] = time();
			$insert_act_array['cca_content'] = trim($_POST['care_subject']).Language::get('bp_colon').trim($_POST['care_content']);
			$insert_act_array['cca_start_time'] = time();
			$insert_act_array['cca_excstaff'] = $_SESSION['member_id'];
			$insert_act_array['cca_ismission'] = 2;
			$model->table('customer_action')->insert($insert_act_array);
			
			if($rs){
				showDialog(Language::get('bp_care_savesucc'),'index.php?act=customer&op=customer_view&cc_id='.intval($_POST['cc_id']),'succ');
			}else{
				showDialog(Language::get('bp_care_savefail'),'','error');
			}
		}
		//调取会员基本信息+企业会员联系人信息列表
		$cc_id = intval($_GET['cc_id']);
		$cc_info = $model->table('customer')->where(array('cc_id'=>$cc_id))->find();
		Tpl::output('cc_info',$cc_info);
		if($cc_info['cc_type'] == 1){
			$ccc_list = $model->field('ccc_id,ccc_name')->table('company_contact')->where(array('cc_id'=>$cc_id))->select();
			Tpl::output('ccc_list',$ccc_list);
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('care_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('care_add');
	}
	/**
	 * 编辑关怀
	 */
	public function care_editOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 添加任务
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["care_subject"],"require"=>"true","message"=>Language::get('bp_care_subjectnull'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_array = array();
			$update_array['care_subject'] = trim($_POST['care_subject']);
			$update_array['care_date'] = ($t = strtotime(trim($_POST['care_date']).' '.trim($_POST['care_time'])))>0?$t:0;
			$update_array['cc_id'] = intval($_POST['cc_id']);
			$update_array['ccc_id'] = intval($_POST['ccc_id']);
			$update_array['care_content'] = trim($_POST['care_content']);
			$update_array['care_type'] = intval($_POST['care_type']);
			$update_array['care_feedback'] = trim($_POST['care_feedback']);
			$update_array['care_note'] = trim($_POST['care_note']);
			
			$care_id = intval($_POST['care_id']);
			if($care_id <= 0){
				showDialog(Language::get('wrong_argument'));
			}
			$rs = $model->table('customer_care')->where(array('care_id'=>$care_id))->update($update_array);
			if(trim($_POST['from']) == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_POST['cc_id']);
			}else{
				$url = 'index.php?act=customer_care&op=care_list';
			}
			if($rs){
				showDialog(Language::get('bp_care_editsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_care_editfail'),'','error');
			}
		}
		/**
		 * 调取关怀信息等
		 */
		$care_id = intval($_GET['care_id']);
		$care_info = $model->field('customer.cc_name,customer.cc_type,customer_care.*')->table('customer_care,customer')->join('left')->on('customer.cc_id=customer_care.cc_id')->where(array('customer_care.care_id'=>$care_id))->find();
		if(empty($care_info)){
			showDialog(Language::get('bp_care_recorderror'));
		}
		if($care_info['cc_type'] == 1){
			$ccc_list = $model->field('ccc_id,ccc_name')->table('company_contact')->where(array('cc_id'=>$care_info['cc_id']))->select();
			Tpl::output('ccc_list',$ccc_list);
		}
		Tpl::output('care_info',$care_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('care_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('care_edit');
	}
	/**
	 * 查看会员关怀信息
	 */
	public function care_viewOp(){
		/**
		 * 实例化模型
		 */
		$model = Model();
		/**
		 * 调取关怀信息等
		 */
		$care_id = intval($_GET['care_id']);
		$care_info = $model->field('customer.cc_name,customer.cc_type,customer.cc_staff_id,customer.cc_dept_id,customer_care.*,user.user_truename,customer.shop_id')->table('customer_care,customer,user')->join('left')->on('customer.cc_id=customer_care.cc_id,customer_care.care_addstaff=user.user_id')->where(array('customer_care.care_id'=>$care_id))->find();
		if(empty($care_info)){
			showDialog(Language::get('bp_care_recorderror'));
		}
		/*判断当前用户是否有查看权限*/
		if($_SESSION['shop_id'] != 0 && $_SESSION['shop_id'] != $care_info['shop_id']){
			showDialog(Language::get('bp_withoutpermission'));
		}
		if($care_info['cc_type'] == 1){
			$ccc_list = $model->field('ccc_id,ccc_name')->table('company_contact')->where(array('cc_id'=>$care_info['cc_id']))->select();
			if(is_array($ccc_list) && !empty($ccc_list)){
				foreach ((array)$ccc_list as $k=>$v){
					if($v['ccc_id'] == $care_info['ccc_id']){
						Tpl::output('ccc_name',$v['ccc_name']);
						break;
					}
				}
			}
		}
		Tpl::output('care_info',$care_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('care_list');
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('html_title',Language::get('bp_care_viewtitle'));
		Tpl::showpage('care_view','windowopen_layout');
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_member'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'customer_list','menu_name'=>Language::get('bp_home_member_manage'),	'menu_act'=>'customer','menu_op'=>'customer_list');
		$arr[0]['submenu'][1] = array('menu_key'=>'care_list','menu_name'=>Language::get('bp_home_member_care'),	'menu_act'=>'customer_care','menu_op'=>'care_list');
		$arr[0]['submenu'][2] = array('menu_key'=>'customer_history_list','menu_name'=>Language::get('bp_home_member_action'),	'menu_act'=>'customer','menu_op'=>'customer_history_list');
		
		$arr[1] = array('menu_name'=>Language::get('bp_home_member_group'),	'menu_url'=>'#');
		$arr[1]['submenu'][0] = array('menu_key'=>'cgroupmanage','menu_name'=>Language::get('bp_home_member_selfgroup'),'menu_act'=>'customergroup','menu_op'=>'cgroupmanage');
		
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}