<?php
/**
 * 会员管理
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class customerControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('customer');
	}
	/**
	 * 会员列表
	 */
	public function customer_listOp(){
		set_time_limit(0);
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 调取会员列表信息
		 */
		$filter = trim($_GET['filter']);
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_withoutpermission'));
			}
			if(intval($_GET['shop_id']) == 0){
				redirect('index.php?act=customer&op=customer_list&shop_id='.$_SESSION['shop_id']);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					redirect('index.php?act=customer&op=customer_list&shop_id='.$default_shop);die;
				}
			}
		}
		$where_condition = array();
		$where_condition['cc_isdel']     = 0;
		$where_condition['cc_tostaffid'] = 0;
		if($filter == 'sea'){
			$where_condition['cc_insea'] = 1;
		}else{
			$where_condition['cc_insea'] = 0;
			switch ($filter){
				case 'qy':
					$where_condition['cc_type'] = 1;
					break;
				case 'gr':
					$where_condition['cc_type'] = 2;
					break;
				case 'potential':
					$where_condition['cc_ispotential'] = 1;
					break;
				case 'trash':
					if (!cPermission('customer','customer_del')){
						showMessage(Language::get('bp_withoutoperatingpermission'));
					}
					$where_condition['cc_isdel'] = 1;
					break;
			}
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'name':
					$where_condition['cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'shortname':
					$where_condition['cc_shortname'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition['customer.shop_id'] = intval($_GET['shop_id']);
		}
		//自定义字段的搜索处理
		if(!empty($_GET['selfdic_search'])){
			$sd_choose = array();
			foreach ((array)$_GET['selfdic_search'] as $sk=>$sv){
				if($sv != 0){
					$where_condition['cc_self_field'] = array('like','%'.$sv.'%');
					$sd_choose[] = $sv;
				}
			}
			Tpl::output('sd_choose',$sd_choose);
		}
		/**
		 * 从数据库中调取数据
		 */
		if ($_GET['exporttype'] == 'excel'){
			$customer_list = $model_customer->field('customer.*,shop.shop_name')->table('customer,shop')->join('left')->on('customer.shop_id=shop.shop_id')->where($where_condition)->order('cc_addtime desc')->select();
		}else {
			//每页显示条数
			$pagesize = intval($_GET['pagesize']) > 0 ? intval($_GET['pagesize']) : 10;
			$customer_list = $model_customer->field('customer.*,shop.shop_name')->table('customer,shop')->join('left')->on('customer.shop_id=shop.shop_id')->where($where_condition)->page($pagesize)->order('cc_addtime desc')->select();
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 自定义字段的处理
		 */
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>1))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		//导出Excel
		if ($_GET['exporttype'] == 'excel'){
			//导出Excel
			import('excel#class');
			$excel_class = new ExcelXML(C('exportfilefont'));
			$excel_data = array();
			//设置样式
			$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_contact_add_how_important'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_add_member_name'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_company_view_the_name_of_the_shop'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_add_member_type'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_list_creation_date'));
			if(C('use_sea') == 1){
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_list_the_high_seas'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_list_claim_on_time'));
			}
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_customer_add_member_of_the_type'));
			if(!empty($selfdic_show) && is_array($selfdic_show)){
				foreach ((array)$selfdic_show as $sk=>$sv){
					$excel_data[0][] = array('styleid'=>'s_title','data'=>$sv['field_name']);
				}
			}
			//data
			foreach ((array)$customer_list as $k=>$v){
				$tmp = array();
				switch ($v['cc_important']){
				 	case '1':
				 		$tmp[] = array('data'=>Language::get('bp_customer_add_low'));
				 		break;
				 	case '2':
				 		$tmp[] = array('data'=>Language::get('bp_customer_add_in_the'));
				 		break;
				 	case '3':
				 		$tmp[] = array('data'=>Language::get('bp_customer_add_high'));
				 		break;
				}
				$tmp[] = array('data'=>($v['cc_name']==''?Language::get('bp_customer_have_been_unable_to_find_thecustomer'):$v['cc_name']));
				$tmp[] = array('data'=>($v['shop_name']));
				$tmp[] = array('data'=>($v['cc_class']==0?'':$dic_array['customer_class']['child_option'][$v['cc_class']]['cd_name']));
				$tmp[] = array('data'=>date('Y-m-d H:i:s',$v['cc_addtime']));
				if(C('use_sea') == 1){
				$tmp[] = array('data'=>($v['cc_insea'] == 1?Language::get('bp_yes'):Language::get('bp_no')));
				$tmp[] = array('data'=>($v['cc_getseatime']!=0?date('Y-m-d H:i:s',$v['cc_getseatime']):Language::get('bp_common_none')));
				}
				$tmp[] = array('data'=>($v['cc_type'] == 1?Language::get('bp_customer_add_corporate_member'):Language::get('bp_customer_add_individual_members')));
				if(!empty($selfdic_show) && is_array($selfdic_show)){
					$selfdic_choose = unserialize($v['cc_self_field']);
					foreach ((array)$output['selfdic_show'] as $sk=>$sv){
						$tmp[] = array('data'=>(intval($selfdic_choose[$sv['p_id']])==0?Language::get('bp_common_none'):$sv['child_option'][$selfdic_choose[$sv['p_id']]]['cd_name']));
					}
				}
				$excel_data[] = $tmp;
			}
			$excel_class->addArray($excel_data);
			$excel_class->addWorksheet(Language::get('bp_customer_information'));
			$excel_class->generateXML(Language::get('bp_customer_information').date('Y-m-d H-i-s',time()));
			exit();
		}
		Tpl::output('selfdic_show',$selfdic_show);
		Tpl::output('selfdic_search',$selfdic_search);
		Tpl::output('currenturl',request_uri());
		//判断是否有需要确认的转移会员
		$trans_customer = $model_customer->table('customer')->where(array('cc_tostaffid'=>$_SESSION['member_id']))->select(array('limit'=>1));
		if(!empty($trans_customer)){
			Tpl::output('trans_customer',true);
		}
		/**
		 * 模板输出
		 */
		Tpl::output('dic_array',$dic_array);
		Tpl::output('customer_list',$customer_list);
		Tpl::output('show_page',$model_customer->showpage(2));
		Tpl::showpage('customer_list');
	}
	/**
	 * 新增会员（基本信息）
	 * 
	 */
	public function customer_addOp(){
		if(trim($_GET['type']) == 'step2'){
			$this->customer_add_step2();die;
		}
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		/**
		 * 保存信息
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cc_type"],"require"=>"true","message"=>Language::get('bp_customer_add_please_select_a_membership_type'));
			$validate_arr[] = array("input"=>$_POST["cc_name"], "require"=>'true',"message"=>Language::get('bp_customer_add_please_fill_in_username'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//自定义字段的处理
			$cc_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$cc_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			
			$insert_array = array(
				'cc_type'=>intval($_POST['cc_type']),
				'cc_name'=>trim($_POST['cc_name']),
				'cc_shortname'=>trim($_POST['cc_shortname']),
				'cc_important'=>intval($_POST['cc_important']),
				'cc_credit_degree'=>intval($_POST['cc_credit_degree']),
				'cc_class'=>trim($_POST['cc_class']),
				'cc_industry'=>trim($_POST['cc_industry']),
				'cc_relationship'=>trim($_POST['cc_relationship']),
				'cc_worktag'=>trim($_POST['cc_worktag']),
				'cc_from'=>trim($_POST['cc_from']),
				'cc_ispotential'=>intval($_POST['cc_ispotential']),
				'cc_potential_value'=>intval($_POST['cc_potential_value']),
				'cc_fromactionid'=>intval($_POST['cc_fromactionid']),
				'cc_self_field'=>serialize($cc_self_field),
				'cc_addtime'=>time(),
				'cc_addstaffid'=>$_SESSION['member_id'],
				'cc_lat'=>floatval($_POST['cc_lat']),
				'cc_lng'=>floatval($_POST['cc_lng'])
			);
			$insert_array['cc_insea']    = 0;
			$insert_array['cc_staff_id'] = $_SESSION['member_id'];
			$insert_array['cc_dept_id']  = $_SESSION['dp_id'];
			$staff_dp_info = $model_customer->table('department')->field('d_allparentid')->where(array('d_id'=>$_SESSION['dp_id']))->find();
			$cc_id = $model_customer->table('customer')->insert($insert_array);
			if($cc_id != false){
				showDialog(Language::get('bp_customer_add_the_first_step_succ'),'index.php?act=customer&op=customer_add&type=step2&cc_type='.intval($_POST['cc_type']).'&cc_id='.$cc_id,'succ');
			}else{
				showDialog(Language::get('bp_customer_add_the_first_step_fail'),'','error');
			}
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>1))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 分析当前员工的权限范围
		 */
		$staff_where = array();
		if($_SESSION['shop_id'] > 0){
			$staff_where['user_shopid'] = $_SESSION['shop_id'];
		}
		$staff_info = $model_customer->table('user')->field('user_id,user_truename,user_departmentname')->where($staff_where)->order('user_departmentname')->select();
		Tpl::output('staff_info',$staff_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('customer_add');
	}
	/**
	 * 新增会员第二步（企业OR个人会员详细信息），此步骤完成会员的录入
	 */
	private function customer_add_step2(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		/**
		 * 保存信息
		 */
		if (chksubmit()){
			//企业会员信息录入
			if(intval($_POST['cc_type']) == 1){
				$insert_array = array(
					'cc_id'=>intval($_POST['cc_id']),
					'cci_staff_size'=>trim($_POST['cci_staff_size']),
					'cci_intro'=>trim($_POST['cci_intro']),
					'cci_phone'=>trim($_POST['cci_phone']),
					'cci_fax'=>trim($_POST['cci_fax']),
					'cci_email'=>trim($_POST['cci_email']),
					'cci_postcode'=>trim($_POST['cci_postcode']),
					'cci_website'=>trim($_POST['cci_website']),
					'cci_note'=>trim($_POST['cci_note'])
				);
				$result = $model_customer->table('company_info')->insert($insert_array);
			}else{//个人会员信息录入
				$insert_array = array(
					'cc_id'=>intval($_POST['cc_id']),
					'cpi_sex'=>intval($_POST['cpi_sex']),
					'cpi_mobilephone'=>trim($_POST['cpi_mobilephone']),
					'cpi_workphone'=>trim($_POST['cpi_workphone']),
					'cpi_homephone'=>trim($_POST['cpi_homephone']),
					'cpi_fax'=>trim($_POST['cpi_fax']),
					'cpi_email'=>trim($_POST['cpi_email']),
					'cpi_qq'=>trim($_POST['cpi_qq']),
					'cpi_msn'=>trim($_POST['cpi_msn']),
					'cpi_skype'=>trim($_POST['cpi_skype']),
					'cpi_ww'=>trim($_POST['cpi_ww']),
					'cpi_postcode'=>trim($_POST['cpi_postcode']),
					'cpi_website'=>trim($_POST['cpi_website']),
					'cpi_hobby'=>trim($_POST['cpi_hobby']),
					'cpi_birthday'=>($t = strtotime(trim($_POST['cpi_birthday'])))>0?$t:0,
					'cpi_note'=>trim($_POST['cpi_note'])
				);
				$result = $model_customer->table('personal_info')->insert($insert_array);
			}
			//向会员表里插入地区数据
			$update_customer_array = array(
				'cc_country'=>trim($_POST['country_final']),
				'cc_province'=>trim($_POST['province_final']),
				'cc_city'=>trim($_POST['city_final']),
				'cc_district'=>trim($_POST['district_final']),
				'cc_address'=>intval($_POST['cc_type']) == 1?trim($_POST['cci_address']):trim($_POST['cpi_address'])
			);
			$update_rs = $model_customer->table('customer')->where(array('cc_id'=>intval($_POST['cc_id'])))->update($update_customer_array);
			if($result != false && $update_rs != false){
				showDialog(Language::get('bp_customer_add_finish'),'index.php?act=customer&op=customer_list','succ');
			}else{
				showDialog(Language::get('bp_customer_add_the_second_step_fail'),'','error');
			}
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('cc_id',intval($_GET['cc_id']));
		Tpl::output('dic_array',$dic_array);
		if(intval($_GET['cc_type']) == 1){
			Tpl::showpage('customer_add_step2_qy');
		}else{
			Tpl::showpage('customer_add_step2_gr');
		}
	}
	/**
	 * 编辑会员信息
	 */
	public function customer_editOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		
		/**
		 * 更新会员信息
		 */
		if (chksubmit()){
			$cc_id   = intval($_POST['cc_id']);
			$cc_type = intval($_POST['cc_type']);
			//自定义字段的处理
			$cc_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$cc_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			//更新会员基本信息
			$baseinfo_update_array = array(
				'cc_name'=>trim($_POST['cc_name']),
				'cc_shortname'=>trim($_POST['cc_shortname']),
				'cc_important'=>intval($_POST['cc_important']),
				'cc_credit_degree'=>intval($_POST['cc_credit_degree']),
				'cc_class'=>trim($_POST['cc_class']),
				'cc_industry'=>trim($_POST['cc_industry']),
				'cc_relationship'=>trim($_POST['cc_relationship']),
				'cc_worktag'=>trim($_POST['cc_worktag']),
				'cc_from'=>trim($_POST['cc_from']),
				'cc_ispotential'=>intval($_POST['cc_ispotential']),
				'cc_potential_value'=>intval($_POST['cc_potential_value']),
				'cc_fromactionid'=>intval($_POST['cc_fromactionid']),
				'cc_self_field'=>serialize($cc_self_field),
				'cc_country'=>trim($_POST['country_final']),
				'cc_province'=>trim($_POST['province_final']),
				'cc_city'=>trim($_POST['city_final']),
				'cc_district'=>trim($_POST['district_final']),
				'cc_address'=>$cc_type == 1?trim($_POST['cci_address']):trim($_POST['cpi_address']),
				'cc_lat'=>floatval($_POST['cc_lat']),
				'cc_lng'=>floatval($_POST['cc_lng'])
			);
			$baseinfo_result = $model_customer->table('customer')->where(array('cc_id'=>$cc_id))->update($baseinfo_update_array);
			if($cc_type == 1){//企业
				$cci_id = intval($_POST['cci_id']);
				//判断会员信息扩展表是否有数据，没有则插入一条
				if($cci_id == 0){
					$cci_id = $model_customer->table('company_info')->insert(array('cc_id'=>$cc_id));
				}
				if($cci_id > 0){
					$detailinfo_update_array = array(
						'cci_staff_size'=>trim($_POST['cci_staff_size']),
						'cci_intro'=>trim($_POST['cci_intro']),
						'cci_phone'=>trim($_POST['cci_phone']),
						'cci_fax'=>trim($_POST['cci_fax']),
						'cci_email'=>trim($_POST['cci_email']),
						'cci_postcode'=>trim($_POST['cci_postcode']),
						'cci_website'=>trim($_POST['cci_website']),
						'cci_note'=>trim($_POST['cci_note'])
					);
					$detailinfo_result = $model_customer->table('company_info')->where(array('cci_id'=>$cci_id))->update($detailinfo_update_array);
				}else{
					showDialog(Language::get('bp_customer_edit_not_find_information'));
				}
			}else{//个人
				$cpi_id = intval($_POST['cpi_id']);
				//判断会员信息扩展表是否有数据，没有则插入一条
				if($cpi_id == 0){
					$cpi_id = $model_customer->table('personal_info')->insert(array('cc_id'=>$cc_id));
				}
				if($cpi_id > 0){
					$detailinfo_update_array = array(
						'cpi_sex'=>intval($_POST['cpi_sex']),
						'cpi_mobilephone'=>trim($_POST['cpi_mobilephone']),
						'cpi_workphone'=>trim($_POST['cpi_workphone']),
						'cpi_homephone'=>trim($_POST['cpi_homephone']),
						'cpi_fax'=>trim($_POST['cpi_fax']),
						'cpi_email'=>trim($_POST['cpi_email']),
						'cpi_qq'=>trim($_POST['cpi_qq']),
						'cpi_msn'=>trim($_POST['cpi_msn']),
						'cpi_skype'=>trim($_POST['cpi_skype']),
						'cpi_ww'=>trim($_POST['cpi_ww']),
						'cpi_postcode'=>trim($_POST['cpi_postcode']),
						'cpi_website'=>trim($_POST['cpi_website']),
						'cpi_hobby'=>trim($_POST['cpi_hobby']),
						'cpi_birthday'=>($t = strtotime(trim($_POST['cpi_birthday'])))>0?$t:0,
						'cpi_note'=>trim($_POST['cpi_note'])
					);
					$detailinfo_result = $model_customer->table('personal_info')->where(array('cpi_id'=>$cpi_id))->update($detailinfo_update_array);
				}else{
					showDialog(Language::get('bp_customer_edit_not_find_information'));
				}
			}
			if($baseinfo_result && $detailinfo_result){
				showDialog(Language::get('bp_customer_edit_succ'),'index.php?act=customer&op=customer_list','succ');
			}else{
				showDialog(Language::get('bp_customer_edit_fail'),'','error');
			}
		}
		$cc_type = intval($_GET['cc_type']);
		$cc_id   = intval($_GET['cc_id']);
		if($cc_id == 0 || $cc_type == 0){
			showMessage(Language::get('wrong_argument'));
		}
		/**
		 * 调取会员信息
		 */
		switch ($cc_type){
			case 1:
				$field = 'customer.*,company_info.*,customer.cc_id';
				$table = 'customer,company_info';
				$on = 'customer.cc_id=company_info.cc_id';
				$tpl_name = 'customer_edit_qy';
				break;
			case 2:
				$field = 'customer.*,personal_info.*,customer.cc_id';
				$table = 'customer,personal_info';
				$on = 'customer.cc_id=personal_info.cc_id';
				$tpl_name = 'customer_edit_gr';
				break;
		}
		$customer_info = $model_customer->field($field)->table($table)->join('left')->on($on)->where(array('customer.cc_id'=>$cc_id))->find();
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_model_id'=>1))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ($selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 分析当前员工的权限范围
		 */
		$staff_where = true;
		if($_SESSION['shop_id'] > 0){
			$staff_where = array('user_shopid'=>$_SESSION['shop_id']);
		}
		$staff_info = $model_customer->table('user')->field('user_id,user_truename,user_departmentname')->where($staff_where)->order('user_departmentname')->select();
		Tpl::output('staff_info',$staff_info);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('selfdic_select',unserialize($customer_info['cc_self_field']));
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('customer_info',$customer_info);
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage($tpl_name);
	}
	/**
	 * 删除会员
	 * 
	 */
	public function customer_delOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		$cc_id = intval($_GET['cc_id']);
		if($cc_id == 0){
			showDialog(Language::get('wrong_argument'));
		}else{
			//判断该会员是否产生订单
			$co_list = $model_customer->field('co_id,co_code')->table('orders')->where(array('cc_id'=>$cc_id))->select();
			if(!empty($co_list)){
				showDialog(Language::get('bp_customer_haveorder_cannotbedeleted'));
			}
			$result = $model_customer->table('customer')->where(array('cc_id'=>$cc_id))->update(array('cc_isdel'=>1));
			if($result){
				showDialog(Language::get('bp_customer_deletesucc'),'index.php?act=customer&op=customer_list','succ');
			}else{
				showDialog(Language::get('bp_customer_deletefail'),'','error');
			}
		}
	}
	/**
	 * 恢复已删除的会员
	 * 
	 */
	public function customer_returnOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		
		$cc_id = intval($_GET['cc_id']);
		if($cc_id == 0){
			showMessage(Language::get('wrong_argument'));
		}else{
			$result = $model_customer->table('customer')->where(array('cc_id'=>$cc_id))->update(array('cc_isdel'=>0));
			if($result){
				showDialog(Language::get('bp_customer_returnsucc'),'index.php?act=customer&op=customer_list','succ');
			}else{
				showDialog(Language::get('bp_customer_returnfail'),'','error');
			}
		}
	}
	/**
	 * 彻底清除会员数据
	 */
	public function customer_clearOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		$cc_id = intval($_GET['cc_id']);
		if($cc_id == 0){
			showMessage(Language::get('wrong_argument'));
		}else{
			$result = $model_customer->table('customer')->where(array('cc_id'=>$cc_id))->delete();
			if($result){
				showDialog(Language::get('bp_customer_clearsucc'),'index.php?act=customer&op=customer_list','succ');
			}else{
				showDialog(Language::get('bp_customer_clearfail'),'','error');
			}
		}
	}
	/**
	 * 查看会员信息
	 */
	public function customer_viewOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		/**
		 * 从数据库中调取会员信息
		 */
		$cc_id = intval($_GET['cc_id']);
		//调取会员基本信息
		$customer_info = $model_customer->field('customer.*,shop.shop_name')->table('customer,shop')->join('left')->on('customer.shop_id=shop.shop_id')->where(array('cc_id'=>$cc_id))->find();
		if(empty($customer_info)){
			showMessage(Language::get('bp_customer_recorderror'));
		}
		/*判断当前用户是否有查看权限*/
		if($customer_info['cc_insea'] != 1 && $_SESSION['shop_id'] != 0 && $customer_info['shop_id'] != $_SESSION['shop_id']){
			showMessage(Language::get('bp_withoutpermission'));
		}
		$cc_type = $customer_info['cc_type'];
		switch ($cc_type){
			case 1:
				$table = 'company_info';
				$tpl_name = 'customer_company_view';
				break;
			case 2:
				$table = 'personal_info';
				$tpl_name = 'customer_personal_view';
				break;
		}
		$customer_add_info = $model_customer->table($table)->where(array('cc_id'=>$cc_id))->find();
		if(is_array($customer_add_info)){
			$customer_info = array_merge($customer_info,$customer_add_info);
		}
		//调取所有人和添加人员姓名
		$staff_info = $model_customer->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',$customer_info['cc_staff_id'].','.$customer_info['cc_addstaffid'])))->select();
		if(is_array($staff_info) && !empty($staff_info)){
			foreach ((array)$staff_info as $k=>$v){
				if($v['user_id'] == $customer_info['cc_staff_id']){
					$customer_info['owner'] = $v['user_truename'];
				}
				if($v['user_id'] == $customer_info['cc_addstaffid']){
					$customer_info['addstaff'] = $v['user_truename'];
				}
			}
		}
		//如果是企业会员则从数据库中调取企业联系人信息
		if($cc_type == 1){
			$contact_info = $model_customer->table('company_contact')->where(array('cc_id'=>$customer_info['cc_id'],'ccc_isdel'=>0))->select();
			Tpl::output('contact_info',$contact_info);
			/**
			 * 自定义字段的处理
			 */
			$selfdic_array = $model_customer->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>2))->select();
			$selfdic_show = array();//列表展示字段
			$selfdic_search = array();//列表搜素字段
			if(is_array($selfdic_array) && !empty($selfdic_array)){
				foreach ((array)$selfdic_array as $k=>$v){
					if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && $v['cd_listshow_status'] == 1){
						$tmp_child_list = array();
						foreach ((array)$selfdic_array as $ck=>$cv){
							if($cv['cd_parent_id'] == $v['cd_id']){
								$tmp_child_list[$cv['cd_id']] = $cv;
							}
						}
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
						unset($tmp_child_list);
					}
				}
			}
			Tpl::output('selfdic_show',$selfdic_show);
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//调取该模块自定义字段信息
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_model_id'=>1))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		//调取该会员的待办任务
		$mission_list = $model_customer->field('mission.*,user.user_truename')->table('mission,user')->join('left')->on('mission.cm_addstaff=user.user_id')->where(array('mission.cc_id'=>$cc_id))->order('mission.cm_addtime desc')->select();
		Tpl::output('mission_list',$mission_list);
		//调取针对该会员的日程安排
		$schedule_list = $model_customer->table('schedule')->where(array('cc_id'=>$cc_id))->order('cs_addtime desc')->select();
		Tpl::output('schedule_list',$schedule_list);
		//调取针对该会员的行动历史
		$act_history_list = $model_customer->table('customer_action')->where(array('cc_id'=>$cc_id))->order('cca_addtime desc')->select();
		Tpl::output('act_history_list',$act_history_list);
		//调取针对该会员的会员关怀
		if($customer_info['cc_type'] == 1){
			$care_list = $model_customer->field('customer_care.*,company_contact.ccc_name')->table('customer_care,company_contact')->join('left')->on('company_contact.ccc_id=customer_care.ccc_id')->where(array('customer_care.cc_id'=>$cc_id))->order('customer_care.care_id desc')->select();
		}else{
			$care_list = $model_customer->table('customer_care')->where(array('cc_id'=>$cc_id))->order('care_id desc')->select();
		}
		Tpl::output('care_list',$care_list);
		//查询会员需求
		$reqimportant_arr = array(1=>Language::get('bp_customer_requirement_important1'),2=>Language::get('bp_customer_requirement_important2'),3=>Language::get('bp_customer_requirement_important3'),4=>Language::get('bp_customer_requirement_important4'));
		
		$requirement_list = $model_customer->table('requirement')->where(array('req_customerid'=>$cc_id))->order('req_id desc')->select();
		Tpl::output('requirement_list',$requirement_list);
		Tpl::output('reqimportant_arr',$reqimportant_arr);
		//查询解决方案
		$solution_list = $model_customer->table('solution')->where(array('sol_customerid'=>$cc_id))->order('sol_id desc')->select();
		Tpl::output('solution_list',$solution_list);
		//查询竞争对手
		$competitor_list = $model_customer->table('competitor')->where(array('cpr_customerid'=>$cc_id))->order('cpr_id desc')->select();
		Tpl::output('competitor_list',$competitor_list);
		//查询报价单
		$quotedprice_list = $model_customer->table('quotedprice')->where(array('qp_customerid'=>$cc_id))->order('qp_id desc')->select();
		Tpl::output('quotedprice_list',$quotedprice_list);
		//查询记事本
		$notepad_list = $model_customer->table('notepad')->where(array('np_customerid'=>$cc_id,'np_userid'=>$_SESSION['member_id']))->order('np_id desc')->select();
		Tpl::output('notepad_list',$notepad_list);
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('selfdic_select',unserialize($customer_info['cc_self_field']));
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('dic_array',$dic_array);
		Tpl::output('customer_info',$customer_info);
		Tpl::showpage($tpl_name,'windowopen_layout');	
	}
	/**
	 * 添加企业联系人
	 */
	public function contact_addOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		
		/**
		 * 保存信息
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["ccc_name"],"require"=>"true","message"=>Language::get('bp_contact_add_please_fill_in_contact_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//自定义字段的处理
			$ccc_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$ccc_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			$insert_array = array(
				'cc_id'=>intval($_POST['cc_id']),
				'ccc_name'=>trim($_POST['ccc_name']),
				'ccc_sex'=>intval($_POST['ccc_sex']),
				'ccc_important'=>intval($_POST['ccc_important']),
				'ccc_isfirst'=>intval($_POST['ccc_isfirst']),
				'ccc_company_dept'=>trim($_POST['ccc_company_dept']),
				'ccc_company_job'=>trim($_POST['ccc_company_job']),
				'ccc_mobilephone'=>trim($_POST['ccc_mobilephone']),
				'ccc_workphone'=>trim($_POST['ccc_workphone']),
				'ccc_homephone'=>trim($_POST['ccc_homephone']),
				'ccc_email'=>trim($_POST['ccc_email']),
				'ccc_msn'=>trim($_POST['ccc_msn']),
				'ccc_skype'=>trim($_POST['ccc_skype']),
				'ccc_ww'=>trim($_POST['ccc_ww']),
				'ccc_qq'=>trim($_POST['ccc_qq']),
				'ccc_homeaddress'=>trim($_POST['ccc_homeaddress']),
				'ccc_postcode'=>trim($_POST['ccc_postcode']),
				'ccc_birthday'=>($t = strtotime(trim($_POST['ccc_birthday'])))>0?$t:0,
				'ccc_hobby'=>trim($_POST['ccc_hobby']),
				'ccc_note'=>trim($_POST['ccc_note']),
				'ccc_self_field'=>serialize($ccc_self_field),
				'ccc_addtime'=>time(),
				'ccc_addstaffid'=>$_SESSION['member_id']
			);
			$result = $model_customer->table('company_contact')->insert($insert_array);
			if($result){
				showDialog(Language::get('bp_contact_add_succ'),'index.php?act=customer&op=customer_view&cc_id='.intval($_POST['cc_id']).'&cc_type=1','succ');
			}else{
				showDialog(Language::get('bp_contact_add_fail'),'','error');
			}
		}
		
		$cc_id = intval($_GET['cc_id']);
		$cci_id = intval($_GET['cci_id']);
		$cc_info = $model_customer->table('customer')->field('cc_id,cc_name')->where(array('cc_id'=>$cc_id))->find();
		if (empty($cc_info) || !is_array($cc_info)){
			showMessage(Language::get('wrong_argument'),'index.php?act=customer&op=customer_list');
		}
		$cc_info['cci_id'] = $cci_id;
		
		//调取该模块自定义字段信息
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>2))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('cc_info',$cc_info);
		Tpl::showpage('contact_add');
	}
	/**
	 * 编辑企业联系人
	 */
	public function contact_editOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		/**
		 * 更新信息
		 */
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["ccc_name"],"require"=>"true","message"=>Language::get('bp_contact_add_please_fill_in_contact_name'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//自定义字段的处理
			$ccc_self_field = array();
			if(is_array($_POST['self_field_pid']) && !empty($_POST['self_field_pid'])){
				foreach ((array)$_POST['self_field_pid'] as $k=>$v){
					$ccc_self_field[$v] = $_POST['self_field_option'][$k];
				}
			}
			$update_array = array(
				'ccc_name'=>trim($_POST['ccc_name']),
				'ccc_sex'=>intval($_POST['ccc_sex']),
				'ccc_important'=>intval($_POST['ccc_important']),
				'ccc_isfirst'=>intval($_POST['ccc_isfirst']),
				'ccc_company_dept'=>trim($_POST['ccc_company_dept']),
				'ccc_company_job'=>trim($_POST['ccc_company_job']),
				'ccc_mobilephone'=>trim($_POST['ccc_mobilephone']),
				'ccc_workphone'=>trim($_POST['ccc_workphone']),
				'ccc_homephone'=>trim($_POST['ccc_homephone']),
				'ccc_email'=>trim($_POST['ccc_email']),
				'ccc_msn'=>trim($_POST['ccc_msn']),
				'ccc_skype'=>trim($_POST['ccc_skype']),
				'ccc_ww'=>trim($_POST['ccc_ww']),
				'ccc_qq'=>trim($_POST['ccc_qq']),
				'ccc_homeaddress'=>trim($_POST['ccc_homeaddress']),
				'ccc_postcode'=>trim($_POST['ccc_postcode']),
				'ccc_birthday'=>($t = strtotime(trim($_POST['ccc_birthday'])))>0?$t:0,
				'ccc_hobby'=>trim($_POST['ccc_hobby']),
				'ccc_note'=>trim($_POST['ccc_note']),
				'ccc_self_field'=>serialize($ccc_self_field)
			);
			$ccc_id = intval($_POST['ccc_id']);
			$result = $model_customer->table('company_contact')->where(array('ccc_id'=>$ccc_id))->update($update_array);
			if($result){
				showDialog(Language::get('bp_contact_edit_succ'),'index.php?act=customer&op=customer_view&cc_id='.intval($_POST['cc_id']),'succ');
			}else{
				showDialog(Language::get('bp_contact_edit_fail'),'','error');
			}
		}
		/**
		 * 调取企业及联系人信息
		 */
		$cc_id    = intval($_GET['cc_id']);
		$cc_info  = $model_customer->table('customer')->field('cc_id,cc_name')->where(array('cc_id'=>$cc_id))->find();
		$ccc_id   = intval($_GET['ccc_id']);
		$ccc_info = $model_customer->table('company_contact')->where(array('ccc_id'=>$ccc_id))->find();
		if(empty($cc_info) || empty($ccc_info)){
			showMessage(Language::get('wrong_argument'),'index.php?act=customer&op=customer_list');
		}
		//调取该模块自定义字段信息
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_model_id'=>2))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('selfdic_select',unserialize($ccc_info['ccc_self_field']));
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('cc_info',$cc_info);
		Tpl::output('ccc_info',$ccc_info);
		Tpl::showpage('contact_edit');
	}
	/**
	 * 查看企业联系人
	 */
	public function contact_viewOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		/**
		 * 调取企业及联系人信息
		 */
		$ccc_id = intval($_GET['ccc_id']);
		$cc_id  = intval($_GET['cc_id']);
		$cc_info  = $model_customer->table('customer')->field('cc_id,cc_name')->where(array('cc_id'=>$cc_id))->find();
		$ccc_info = $model_customer->field('company_contact.*,user.user_truename')->table('company_contact,user')->join('left')->on('company_contact.ccc_addstaffid=user.user_id')->where(array('company_contact.ccc_id'=>$ccc_id))->find();
		if(empty($cc_info) || empty($ccc_info)){
			showDialog(Language::get('wrong_argument'),'index.php?act=customer&op=customer_list');
		}
		//调取该模块自定义字段信息
		$selfdic_array = $model_customer->table('dictionary')->where(array('cd_model_id'=>2))->select();
		$selfdic_list = array();
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[] = $cv;
						}
					}
					$selfdic_list[] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					unset($tmp_child_list);
				}
			}
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('customer_list');
		/**
		 * 模板输出
		 */
		Tpl::output('selfdic_select',unserialize($ccc_info['ccc_self_field']));
		Tpl::output('selfdic_list',$selfdic_list);
		Tpl::output('cc_info',$cc_info);
		Tpl::output('ccc_info',$ccc_info);
		Tpl::output('html_title',Language::get('bp_contact_company_contact_details'));
		Tpl::showpage('contact_view','windowopen_layout');
	}
	/**
	 * 删除企业联系人进回收站
	 */
	public function contact_delOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		
		$ccc_id = intval($_GET['ccc_id']);
		$cc_id = intval($_GET['cc_id']);
		if($ccc_id == 0){
			showMessage(Language::get('wrong_argument'));
		}else{
			$result = $model_customer->table('company_contact')->where(array('ccc_id'=>$ccc_id))->delete();
			if($result){
				showDialog(Language::get('bp_contact_delete_succ'),'index.php?act=customer&op=customer_view&cc_id='.$cc_id.'&cc_type=1','succ');
			}else{
				showDialog(Language::get('bp_contact_delete_fail'),'','error');
			}
		}
	}
	/**
	 * 认领公海会员
	 */
	public function get_seacustomerOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		
		$cc_id = intval($_GET['cc_id']);
		if($cc_id > 0){
			//判断当前员工是否超过系统设置的最大认领公海会员数量
			$get_customer_list = $model_customer->field('cc_id,cc_getseatime')->table('customer')->where(array('cc_getseatime'=>array('gt',0),'cc_staff_id'=>$_SESSION['member_id']))->select();
			if(count($get_customer_list) >= C('max_scnum')){
				showDialog(Language::get('bp_customer_to_achieve_the_seasmaximumnumber'));
			}
			//查找该员工所属部门的上级部门ID
			$allpdp = '';
			$dp_info = H('department');
			if(is_array($dp_info) && !empty($dp_info)){
				foreach ((array)$dp_info as $k=>$v){
					if($v['d_id'] == $_SESSION['dp_id']){
						$allpdp = $v['d_allparentid'];
						break;
					}
				}
			}
			$update_array = array(
				'cc_insea'=>0,
				'cc_staff_id'=>$_SESSION['member_id'],
				'cc_dept_id'=>$_SESSION['dp_id'],
				'cc_getseatime'=>time()
			);
			$result = $model_customer->table('customer')->where(array('cc_id'=>$cc_id))->update($update_array);
			if($result){
				//转移销售机会及其相关数据
				$chancelist = $model_customer->table('chance')->where(array('cha_customerid'=>$cc_id))->select();
				$insert_arr = array();
				foreach ((array)$chancelist as $k=>$v){
					$inserttmp_arr = array();
					$inserttmp_arr['chal_chanceid'] = $v['cha_id'];
					$inserttmp_arr['chal_chancetitle'] = $v['cha_title'];
					$inserttmp_arr['chal_operatorid'] = $_SESSION['member_id'];
					$inserttmp_arr['chal_operatorname'] = $_SESSION['truename'];
					$inserttmp_arr['chal_addtime'] = time();
					$inserttmp_arr['chal_note'] = Language::get('bp_customer_claimprompt');
					//转入日志
					$inserttmp_to_arr['chal_userid'] = $_SESSION['member_id'];
					$inserttmp_to_arr['chal_username'] = $_SESSION['truename'];
					$inserttmp_to_arr['chal_departmentid'] = $_SESSION['dp_id'];
					$inserttmp_to_arr['chal_type'] = 2;
					$insert_arr[] = array_merge($inserttmp_arr,$inserttmp_to_arr);
				}
				$model_customer->table('chance')->where(array('cha_customerid'=>$cc_id))->update(array('cha_userid'=>$_SESSION['member_id'],'cha_username'=>$_SESSION['truename'],'cha_departmentid'=>$_SESSION['dp_id']));
				$model_customer->table('chancelog')->insertAll($insert_arr);
				//会员需求转移
				$model_customer->table('requirement')->where(array('req_customerid'=>$cc_id))->update(array('req_userid'=>$_SESSION['member_id'],'req_username'=>$_SESSION['truename'],'req_departmentid'=>$_SESSION['dp_id']));
				//解决方案转移
				$model_customer->table('solution')->where(array('sol_customerid'=>$cc_id))->update(array('sol_userid'=>$_SESSION['member_id'],'sol_username'=>$_SESSION['truename'],'sol_departmentid'=>$_SESSION['dp_id']));
				//报价管理转移
				$model_customer->table('quotedprice')->where(array('qp_customerid'=>$cc_id))->update(array('qp_userid'=>$_SESSION['member_id'],'qp_username'=>$_SESSION['truename'],'qp_departmentid'=>$_SESSION['dp_id']));
				//竞争对手转移
				$model_customer->table('competitor')->where(array('cpr_customerid'=>$cc_id))->update(array('cpr_userid'=>$_SESSION['member_id'],'cpr_username'=>$_SESSION['truename'],'cpr_departmentid'=>$_SESSION['dp_id']));
				showDialog(Language::get('bp_customer_claim_succ'),'index.php?act=customer&op=customer_list','succ');
			}else{
				showDialog(Language::get('bp_customer_claim_fail'),'','error');
			}
		}else{
			showDialog(Language::get('bp_customer_wrong_argument_unable_to_claim'),'','error');
		}
	}
	/**
	 * 会员批量状态转移
	 */
	public function status_batch_switchOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model('customer');
		$customer_id = trim($_GET['customer_id'],',');
		if($customer_id == ''){
			showDialog(Language::get('bp_customer_list_please_select_a_membership'),'','error');
		}
		$customer_array = explode(',', $customer_id);
		switch (trim($_GET['type'])){
			case 'sea':
				$insert_ctlog_array = array();
				if(is_array($customer_array) && !empty($customer_array)){
					foreach ((array)$customer_array as $k=>$v){
						$tmp_cc_info = explode('-', $v);
						if($tmp_cc_info[2] == 1){
							continue;
						}
						$model_customer->table('customer')->where(array('cc_id'=>$tmp_cc_info[0]))->update(array('cc_insea'=>1,'cc_staff_id'=>0,'cc_dept_id'=>0));
						$insert_ctlog_array[] = array('cc_id'=>$tmp_cc_info[0],'ct_from'=>$tmp_cc_info[1],'ct_to'=>0,'ct_opstaffid'=>$_SESSION['member_id'],'ct_time'=>time(),'ct_note'=>Language::get('bp_customer_turn_on_the_seas_note'));
						unset($tmp_cc_info);
					}
				}
				$model_customer->table('ctlog')->insertAll($insert_ctlog_array);
				showDialog(Language::get('bp_customer_batch_turn_on_the_seas_succ'),'index.php?act=customer&op=customer_list','succ');
				break;
			case 'clear':
				$customer_id_string = '';
				if(is_array($customer_array) && !empty($customer_array)){
					foreach ((array)$customer_array as $k=>$v){
						$tmp_cc_info = explode('-', $v);
						$customer_id_string .= $tmp_cc_info[0].',';
						unset($tmp_cc_info);
					}
				}
				$customer_id_string = trim($customer_id_string,',');
				$result = $model_customer->table('customer')->where(array('cc_id'=>array('in',$customer_id_string)))->delete();
				if($result){
					showDialog(Language::get('bp_customer_batch_clearup_succ'),'index.php?act=customer&op=customer_list','succ');
				}else{
					showDialog(Language::get('bp_customer_batch_clearup_fail'),'','error');
				}
				break;
			case 'return':
				$customer_id_string = '';
				if(is_array($customer_array) && !empty($customer_array)){
					foreach ((array)$customer_array as $k=>$v){
						$tmp_cc_info = explode('-', $v);
						$customer_id_string .= $tmp_cc_info[0].',';
						unset($tmp_cc_info);
					}
				}
				$customer_id_string = trim($customer_id_string,',');
				$result = $model_customer->table('customer')->where(array('cc_id'=>array('in',$customer_id_string)))->update(array('cc_isdel'=>0));
				if($result){
					showDialog(Language::get('bp_customer_batch_return_succ'),'index.php?act=customer&op=customer_list','succ');
				}else{
					showDialog(Language::get('bp_customer_batch_return_fail'),'','error');
				}
				break;
		}
	}
	/**
	 * 会员行动历史记录列表
	 */
	public function customer_history_listOp(){
		/**
		 * 实例化模型
		 */
		$model_customer = Model();
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		/**
		 * 调取会员跟踪记录信息列表
		 */
		//调取会员信息
		$model_customer = Model('customer');
		$where_condition = array();
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_withoutpermission'));
			}
			if(intval($_GET['shop_id']) == 0){
				$r_url = 'index.php?act=customer&op=customer_history_list&shop_id='.$_SESSION['shop_id'];
				if(trim($_GET['from']) != ''){
					$r_url .= '&from='.trim($_GET['from']);
				}
				redirect($r_url);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					$r_url = 'index.php?act=customer&op=customer_history_list&shop_id='.$default_shop;
					if(trim($_GET['from']) != ''){
						$r_url .= '&from='.trim($_GET['from']);
					}
					redirect($r_url);die;
				}
			}
		}
		//处理搜索表单内容
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'cca_content':
					$where_condition['customer_action.cca_content'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
				case 'cc_name':
					$where_condition['customer.cc_name'] = array('like','%'.trim($_GET['search_content']).'%');
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition['customer.shop_id'] = intval($_GET['shop_id']);
		}
		//处理过滤标签
		$filter = trim($_GET['filter']);
		switch ($filter){
			case 'sd':
				$where_condition['cca_ismission'] = 0;
				break;
			case 'ms':
				$where_condition['cca_ismission'] = 1;
				break;
			case 'care':
				$where_condition['cca_ismission'] = 2;
				break;
		}
		$ch_list = $model_customer->field('customer_action.*,customer.cc_name,user.user_truename,shop.shop_name')->table('customer_action,customer,user,shop')->join('left')->on('customer_action.cc_id=customer.cc_id,customer_action.cca_addstaff=user.user_id,customer.shop_id=shop.shop_id')->where($where_condition)->page(10)->order('customer_action.cca_addtime desc')->select();
		Tpl::output('ch_list',$ch_list);
		/**
		 * 左侧菜单
		 */
		if(trim($_GET['from']) == 'lm'){
			setlogleftmenu('customer_history_list');
		}else{
			$this->setleftmenu('customer_history_list');
		}
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model_customer->showpage(2));
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('customer_history_list');
	}
	/**
	 * ajax返回会员联系人列表
	 * 
	 */
	public function get_contactOp(){
		$cc_id = intval($_POST['cc_id']);
		/**
		 * 实例化模型
		 */
		$model = Model();
		$cc_info = $model->table('customer')->where(array('cc_id'=>$cc_id))->find();
		if($cc_info['cc_type'] == 2){
			echo json_encode(array('done'=>true,'contact'=>'person','name'=>$cc_info['cc_name']));die;
		}
		$contact_list = $model->table('company_contact')->where(array('cc_id'=>$cc_id,'ccc_isdel'=>0))->select();
		if(!empty($contact_list)){
			echo json_encode(array('done'=>true,'contact'=>$contact_list));
		}else{
			echo json_encode(array('done'=>false));
		}
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_member'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'customer_list','menu_name'=>Language::get('bp_home_member_manage'),	'menu_act'=>'customer','menu_op'=>'customer_list');
		$arr[0]['submenu'][1] = array('menu_key'=>'care_list','menu_name'=>Language::get('bp_home_member_care'),	'menu_act'=>'customer_care','menu_op'=>'care_list');
		$arr[0]['submenu'][2] = array('menu_key'=>'customer_history_list','menu_name'=>Language::get('bp_home_member_action'),	'menu_act'=>'customer','menu_op'=>'customer_history_list');
		
		$arr[1] = array('menu_name'=>Language::get('bp_home_member_group'),	'menu_url'=>'#');
		$arr[1]['submenu'][0] = array('menu_key'=>'cgroupmanage','menu_name'=>Language::get('bp_home_member_selfgroup'),'menu_act'=>'customergroup','menu_op'=>'cgroupmanage');
		
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}