<?php
/**
 * control父类
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class BaseHomeControl{
	/**
	 * 构造函数
	 */
	public function __construct(){
		/**
		 * 读取通用、布局的语言包
		 */
		Language::read('common,home_layout');
		/**
		 * 系统状态检查
		 */
		if(C('system_close')) halt(C('close_reason'));
		/**
		 * 会员验证
		 */
		if ($_GET['act'] != 'login'){
			$this->checkLogin();
			//验证权限
			if ($_SESSION['permission'] != 'all'){
				$allowvisit = cPermission();
				if (!$allowvisit){
					showMessage(Language::get('bp_withoutoperatingpermission'),'','html','succ',0);
				}
			}
		}
		/**
		 * 设置模板文件夹路径
		 */
		Tpl::setDir('home');
		/**
		 * 设置布局文件内容
		 */
		Tpl::setLayout('home_layout');
	}
	/**
	 * 验证用户是否登录
	 *
	 * @param 
	 * @return 
	 */
	private function checkLogin(){
		//验证是否过期
		if (Session::isExpired() || $_SESSION['is_login'] !== '1'){
			Session::destroy();
			$ref_url = request_uri();
			if ($_GET['inajax']){
				showDialog('','','js',"window.location.replace('index.php?act=login&ref_url=".urlencode($ref_url)."');",200);
			}elseif ($_GET['indialog']){
				$ref_url = $_SERVER['HTTP_REFERER'];
				echo "<script>{window.location.replace('index.php?act=login&ref_url=".urlencode($ref_url)."');}</script>";
			}else {
				@header("location: index.php?act=login&ref_url=".urlencode($ref_url));
			}
			exit;
		}
	}
}