<?php
/**
 * 竞争对手管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class competitorControl extends BaseHomeControl{
	private $commonwhere=array();
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('competitor');
		
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['cpr_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['cpr_userid'] = $_SESSION['member_id'];
		}
	}
	/**
	 * 竞争对手列表
	 */
	public function competitorlistOp(){
		$model = Model();
		$where = $this->commonwhere;
		if (!empty($_GET['search_cpyname'])){
			$where['cpr_companyname'] = array(array('like',"%{$_GET['search_cpyname']}%"));
		}
		if (!empty($_GET['search_cname'])){
			$where['cpr_customername'] = array('like',"%{$_GET['search_cname']}%");
		}
		if (!empty($_GET['search_chance'])){
			$where['cpr_chancetitle'] = array('like',"%{$_GET['search_chance']}%");
		}
		if (!empty($_GET['search_power'])){
			$where['cpr_competitiveness'] = $_GET['search_power'];
		}
		$cpr_list = $model->table('competitor')->where($where)->order('cpr_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('cpr_list',$cpr_list);
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		Tpl::output('dic_array',$dic_array);
		//左侧菜单
		$this->setleftmenu('competitorlist');
		Tpl::showpage('competitorlist');
	}
	/**
	 * 添加竞争对手
	 */
	public function competitoraddOp(){
		//实例化模型
		$model = Model();
		//添加日程
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cpr_cid"],"require"=>"true","message"=>Language::get('bp_competitoradd_please_select_a_membership'));
			$validate_arr[] = array("input"=>$_POST["cpr_cpyname"],"require"=>"true","message"=>Language::get('bp_competitoradd_please_add_the_name_of_the_company'));
			$validate_arr[] = array("input"=>$_POST["cpr_productsdesc"],"require"=>"true","message"=>Language::get('bp_competitoradd_please_add_description_competitive_products_or'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>intval($_POST["cpr_cid"]),'cc_isdel'=>0,'cc_insea'=>0))->find();
			if(empty($customer_info)){
				showDialog(Language::get('bp_competitor_customererror'),'','error');
			}
			$insert_array = array();
			$insert_array['cpr_customerid'] = $customer_info['cc_id'];
			$insert_array['cpr_customername'] = $customer_info['cc_name'];
			if(intval($_POST['cpr_chance']) > 0){
				$insert_array['cpr_chanceid'] = intval($_POST['cpr_chance']);
				$insert_array['cpr_chancetitle'] = $_POST['cpr_chancetitle'];
			}
			$insert_array['cpr_companyname'] = trim($_POST['cpr_cpyname']);
			$insert_array['cpr_price'] = $_POST['cpr_price'];
			$insert_array['cpr_competitiveness'] = $_POST['cpr_power'];
			$insert_array['cpr_productsdesc'] = trim($_POST['cpr_productsdesc']);
			$insert_array['cpr_superiority'] = trim($_POST['cpr_superiority']);
			$insert_array['cpr_inferiority'] = trim($_POST['cpr_inferiority']);
			$insert_array['cpr_strategy'] = trim($_POST['cpr_strategy']);
			$insert_array['cpr_remark'] = trim($_POST['cpr_remark']);
			$insert_array['cpr_addtime'] = time();
			$insert_array['cpr_adduserid'] = $_SESSION['member_id'];
			$insert_array['cpr_addusername'] = $_SESSION['truename'];
			$insert_array['cpr_adddepartmentid'] = $_SESSION['dp_id'];
			$insert_array['cpr_userid'] = $_SESSION['member_id'];
			$insert_array['cpr_username'] = $_SESSION['truename'];
			$insert_array['cpr_departmentid'] = $_SESSION['dp_id'];
			$rs = $model->table('competitor')->insert($insert_array);
			$url = 'index.php?act=competitor&op=competitorlist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$insert_array['cpr_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$insert_array['cpr_customerid'];
			}
			if($rs){
				showDialog(Language::get('bp_competitor_addsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_competitor_addfail'),'','error');
			}
		}else{
			//如果来自会员详情页面则调取该会员信息
			if(intval($_GET['cc_id']) > 0){
				$cc_id = intval($_GET['cc_id']);
				$cc_info  = $model->table('customer')->where(array('cc_id'=>$cc_id,'cc_isdel'=>0))->find();
				if(empty($cc_info)){					
					showMessage(Language::get('bp_competitor_customererror'));
				}else{
					//查询销售机会信息
					$chancelist = $model->table('chance')->where(array('cha_customerid'=>$cc_info['cc_id'],'cha_istrash'=>0))->select();
					Tpl::output('cc_info',$cc_info);
					Tpl::output('chancelist',$chancelist);
				}
			}elseif (intval($_GET['chance_id']) > 0){
				$chance_id = intval($_GET['chance_id']);
				//查询销售机会详细
				$chance_info = $model->table('chance')->where(array('cha_id'=>$chance_id,'cha_istrash'=>0))->find();
				if(empty($chance_info)){
					showMessage(Language::get('bp_competitor_chanceerror'));
				}else{
					//查询会员
					$cc_info  = $model->table('customer')->where(array('cc_id'=>$chance_info['cha_customerid'],'cc_isdel'=>0))->find();
					if(empty($cc_info)){
						showMessage(Language::get('bp_competitor_chanceerror'));
					}
					Tpl::output('chance_info',$chance_info);
				}
			}
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('competitorlist');
			//模板输出
			Tpl::showpage('competitoradd');
		}
	}
	/*
	 * 竞争对手编辑
	 */
	public function competitoreditOp(){
		$cprid = intval($_GET['cprid']);
		if ($cprid<=0){
			$cprid = intval($_POST['cprid']);
		}
		if ($cprid<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		//实例化模型
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		$where['cpr_id'] = $cprid;
		//查询竞争对手详细
		$cpr_info = $model->table('competitor')->where($where)->find();
		if(empty($cpr_info)){
			showDialog(Language::get('bp_competitor_recorderror'),'','error');
		}
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["cpr_cpyname"],"require"=>"true","message"=>Language::get('bp_competitoradd_please_add_the_name_of_the_company'));
			$validate_arr[] = array("input"=>$_POST["cpr_productsdesc"],"require"=>"true","message"=>Language::get('bp_competitoradd_please_add_description_competitive_products_or'));
			
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			$update_arr = array();
			$update_arr['cpr_companyname'] = trim($_POST['cpr_cpyname']);
			$update_arr['cpr_price'] = $_POST['cpr_price'];
			$update_arr['cpr_competitiveness'] = $_POST['cpr_power'];
			$update_arr['cpr_productsdesc'] = trim($_POST['cpr_productsdesc']);
			$update_arr['cpr_superiority'] = trim($_POST['cpr_superiority']);
			$update_arr['cpr_inferiority'] = trim($_POST['cpr_inferiority']);
			$update_arr['cpr_strategy'] = trim($_POST['cpr_strategy']);
			$update_arr['cpr_remark'] = trim($_POST['cpr_remark']);
			$rs = $model->table('competitor')->where(array('cpr_id'=>$cpr_info['cpr_id']))->update($update_arr);
			$url = 'index.php?act=competitor&op=competitorlist';
			if ($_POST['source'] == 'chance'){
				$url = 'index.php?act=chance&op=chanceview&cid='.$cpr_info['cpr_chanceid'];
			}elseif ($_POST['source'] == 'customer'){
				$url = 'index.php?act=customer&op=customer_view&cc_id='.$cpr_info['cpr_customerid'];
			}
			if($rs){
				showDialog(Language::get('bp_competitor_editsucc'),$url,'succ');
			}else{
				showDialog(Language::get('bp_competitor_editfail'),'','error');
			}
		}else{
			$source = '';
			if(intval($_GET['cc_id']) > 0){
				$source = 'customer';
			}elseif (intval($_GET['chance_id']) > 0){
				$source = 'chance';
			}
			Tpl::output('source',$source);
			Tpl::output('cpr_info',$cpr_info);
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('competitorlist');
			//模板输出
			Tpl::showpage('competitoradd');
		}
	}
	/**
	 * 删除竞争对手
	 */
	public function competitordelOp(){
		$cprid = $_GET['cprid'];
		if (empty($cprid)){
			$cprid = $_POST['cprid'];
		}
		if (empty($cprid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		$where = $this->commonwhere;
		if (is_array($cprid)){
			$where['cpr_id'] = array('in',$cprid);
		}else {
			$where['cpr_id'] = $cprid;
		}
		$rs = $model->table('competitor')->where($where)->delete();
		$url = 'index.php?act=competitor&op=competitorlist';
		if(intval($_GET['cc_id']) > 0){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.intval($_GET['cc_id']);
		}elseif (intval($_GET['chance_id']) > 0){
			$url = 'index.php?act=chance&op=chanceview&cid='.intval($_GET['chance_id']);
		}
		if ($rs){
			showDialog(Language::get('bp_common_del_succ'),$url,'succ');
		} else {
			showDialog(Language::get('bp_common_del_fail'),'','error');
		}
	}
	/*
	 * 竞争对手查看
	 */
	public function competitorviewOp(){
		$cprid = intval($_GET['cprid']);
		if ($cprid<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		//实例化模型
		$model = Model('department');
		$cpr_info = $model->table('competitor')->where(array('cpr_id'=>$cprid))->find();
		if(empty($cpr_info)){
			showDialog(Language::get('bp_competitor_recorderror'),'','error');
		}
		$source = '';
		if(intval($_GET['cc_id']) > 0){
			$source = 'customer';
		}elseif (intval($_GET['chance_id']) > 0){
			$source = 'chance';
		}
		$url = 'index.php?act=competitor&op=competitorlist';
		if ($source == 'chance'){
			$url = 'index.php?act=chance&op=chanceview&cid='.$cpr_info['cpr_chanceid'];
		}elseif ($source == 'customer'){
			$url = 'index.php?act=customer&op=customer_view&cc_id='.$cpr_info['cpr_customerid'];
		}
		Tpl::output('backurl',$url);
		Tpl::output('source',$source);
		Tpl::output('cpr_info',$cpr_info);
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		Tpl::output('dic_array',$dic_array);
		//左侧菜单
		$this->setleftmenu('competitorlist');
		//模板输出
		Tpl::showpage('competitorview','windowopen_layout');	
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_home_sale_chance'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'chancelist','menu_name'=>Language::get('bp_home_chance_manage'),'menu_act'=>'chance','menu_op'=>'chancelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'chancetransfer','menu_name'=>Language::get('bp_home_chance_transfer'),'menu_act'=>'chance','menu_op'=>'chancetransfer','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'chancetransferlog','menu_name'=>Language::get('bp_home_chance_transfer_log'),'menu_act'=>'chance','menu_op'=>'chancetransfer','menu_url'=>'index.php?act=chance&op=chancetransfer&type=log','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'chancefiller','menu_name'=>Language::get('bp_home_sale_filler'),'menu_act'=>'chance','menu_op'=>'chancefiller','linktype'=>'0');
		
		$arr[1] = array('menu_name'=>Language::get('bp_home_sale_track'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'requirementlist','menu_name'=>Language::get('bp_home_member_need'),'menu_act'=>'requirement','menu_op'=>'requirementlist','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'solutionlist','menu_name'=>Language::get('bp_home_solution'),'menu_act'=>'solution','menu_op'=>'solutionlist','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'quotedpricelist','menu_name'=>Language::get('bp_home_quote'),'menu_act'=>'quotedprice','menu_op'=>'quotedpricelist','linktype'=>'0');
		$arr[1]['submenu'][3] = array('menu_key'=>'competitorlist','menu_name'=>Language::get('bp_home_competitor'),'menu_act'=>'competitor','menu_op'=>'competitorlist','linktype'=>'0');
		
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}