<?php
/**
 * 公用数据
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class commondataControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		Language::read('commondata');
	}
	/**
	 * 异步获取岗位列表json数据
	 */
	public function jobpostlistOp(){
		$model = Model();
		$where = array();
		if (intval($_GET['did'])>0){
			$where['jp_departmentid'] = intval($_GET['did']);
		}		
		$where['jp_id'] = array('neq',1);
		$jp_list = $model->table('jobpost')->where($where)->select();
		if (!empty($jp_list)){
			$jp_listnew = array();
			foreach ((array)$jp_list as $k=>$v){
				$jp_listnew[$k] = array('id'=>$v['jp_id'],'name'=>$v['jp_name']);
			}
			$rs = json_encode($jp_listnew);
		}
		echo $rs; die;
	}
	/**
	 * 验证用户名是否存在
	 */
	public function checkuserOp(){
		$model = Model();
		//查询员工信息
		$u_info = $model->table('user')->where(array('user_name'=>$_GET['u_name']))->find();
		if (empty($u_info)){
			echo 'true'; die;
		}else {
			if (intval($u_info['user_id']) == intval($_GET['u_id'])){//编辑时
				echo 'true'; die;
			}else {
				echo 'false'; die;
			}
		}
	}
	/**
	 * 异步获取会员列表
	 */
	public function customer_listOp(){
		$model = Model();
		$filter = trim($_GET['filter']);
		$condition = array();
		$condition['customer.cc_isdel'] = 0;
		$condition['customer.cc_insea'] = 0;
		if ($_SESSION['shop_id'] > 0){
			$condition['customer.shop_id'] = $_SESSION['shop_id'];
		}
		//处理检索表单的请求
		if(trim($_GET['search_content'])!=''){
			$condition['customer.cc_name'] = trim($_GET['search_content']);
		}
		/**
		 * 从数据库中调取数据
		 */
		$customer_list = $model->field('customer.*,shop.shop_name')->table('customer,shop')->join('left')->on('customer.shop_id=shop.shop_id')->where($condition)->select();
		echo json_encode($customer_list);die;
	}
	/**
	 * 检索会员页面
	 */
	public function search_customerOp(){
		Tpl::showpage('search_customer','null_layout');
	}
	/**
	 * 员工列表
	 */
	public function user_listOp(){
		$model = Model('department');
		$where['user_id'] = array('neq',1);
		$where['user_state'] = 0;
		if(!empty($_GET['search_did'])){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$did = intval($_GET['search_did']);
			$d_info = $tree_arr[$did];
			if (!empty($tree_arr[$did]['son'])){
				$d_idarr = explode(',',$tree_arr[$did]['son']);
			}
			$d_idarr[] = $did;
			$where['user_department'] = array('in',$d_idarr);
		}
		if (!empty($_GET['search_jpid'])){
			$where['user_jobpost'] = intval($_GET['search_jpid']);
		}
		if (!empty($_GET['search_content'])){
			switch ($_GET['search_type']){
				case 'uname':
					$where['user_name'] = array('like',"%{$_GET['search_content']}%");
					break;
				case 'truename':
					$where['user_truename'] = array('like',"%{$_GET['search_content']}%");
					break;
			}
		}
		$user_list = $model->table('user')->where($where)->order('user_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('user_list',$user_list);
		//获得部门select
		$selecthtml = $this->getDepartmentList(intval($_GET['search_did']));
		Tpl::output('selecthtml',$selecthtml);
		Tpl::showpage('search_user','null_layout');
	}
	/**
	 * 员工列表JOSN数据
	 */
	public function userlistjsonOp(){
		$model = Model();
		$where['user_id'] = array('neq',1);
		$where['user_state'] = 0;
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$where['user_department'] = array('in',$d_idarr);
		}else{
			$where['user_id'] = $_SESSION['member_id'];
		}
		$user_list = $model->table('user')->where($where)->order('user_id asc')->select();
		if (!empty($user_list)){
			$user_listnew = array();
			foreach ((array)$user_list as $k=>$v){
				$user_listnew[$k] = array('id'=>$v['user_id'],'name'=>$v['user_truename']);
			}
			$rs = json_encode($user_listnew);
		}
		echo $rs;die;
	}
	/**
	 * 查询有权限访问的部门数据
	 */
	private function getDepartmentList($did = 0){
		$start_id = 0;
		/*if($this->datapermission['data'] == 'dp'){
			$start_id = $this->datapermission['d_info']['d_id'];
		}*/
		$model = Model('department');
		$selecthtml = $model->getDepartmentCacheSelect(false,$did,'',$start_id);
		return $selecthtml;
	}
	/**
	 * 获得部门树
	 */
	public function department_treeOp(){
		$model = Model('department');
		$start_id = 0;
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$start_id = $_SESSION['dp_id'];
			$did = $_GET['did'];//选择ID
			$dlist = $model->getDepartmentCacheTree(false,$did,$start_id);
		} else {
			$dlist = array();
		}
		Tpl::output('dlist',$dlist);
		Tpl::showpage('departmenttree','null_layout');
	}
	/**
	 * 获取某员工的某会员联系人列表
	 */
	public function contactslistOp(){
		if(empty($_GET['customerid'])){
			echo ''; die;
		}
		//查询会员信息
		$model = Model('customer');
		$condition = array();
		$condition['cc_isdel'] = '0';
		$condition['cc_insea'] = '0';
		$condition['cc_id'] = intval($_GET['customerid']);
		$customer_info = $model->getCustomerInfo($condition);
		
		if(empty($customer_info)){
			echo ''; die;
		}
		$rs = '';
		if ($customer_info['cc_type'] == 1){
			$where = array();
			$where['ccc_isdel'] = 0;
			$where['cc_id'] = $_GET['customerid'];
			$contactslist = $model->table('company_contact')->field('ccc_id,ccc_name')->where($where)->select();
			if (!empty($contactslist)){
				$contactslistnew = array();
				foreach ((array)$contactslist as $k=>$v){
					$contactslistnew[$k] = array('id'=>$v['ccc_id'],'name'=>$v['ccc_name']);
				}
				
			}
		}else{
			$contactslistnew[0] = array('id'=>$customer_info['cc_id'],'name'=>$customer_info['cc_name']);
		}
		if(!empty($contactslistnew)){
			$rs = json_encode($contactslistnew);
		}
		echo $rs; die;
	}
	/**
	 * 检索商品页面
	 */
	public function search_goodsOp(){
		$shop_list = array();
		if (!$_SESSION['shop_id']){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
		}
		Tpl::output('shop_list',$shop_list);
		Tpl::showpage('search_goods','null_layout');
	}
	/**
	 * 根据条件获取商品列表
	 */
	public function goods_listOp(){
		$model = Model();
		$where = array();
		$where['cp_status'] = 1;
		$where['cp_status'] = array('like',"%{$_GET['search_content']}%");
		if ($_SESSION['shop_id']){
			$where['shop_id'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['search_shop']) > 0){
			$where['shop_id'] = intval($_GET['search_shop']);
		}
		$goods_list = $model->field('cp_id,cp_name,cp_cost,cp_ori_price,cp_lowest_price,cp_code,cp_barcode,cp_mallurl')->table('product')->where($where)->select();
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		//整理商品信息数组
		if(is_array($goods_list) && !empty($goods_list)){
			foreach ((array)$goods_list as $k=>$v){
				$goods_list[$k]['cp_ori_price'] = ncPriceFormat($v['cp_ori_price']);
			}
		}
		echo json_encode($goods_list);die;
	}
	/**
	 * 获取个人销售机会列表
	 */
	public function chancelistOp(){
		if(empty($_GET['customerid'])){
			echo ''; die;
		}
		$where = array();
		$where['cha_istrash'] = 0;
		$where['cha_customerid'] = $_GET['customerid'];
		$where['cha_userid'] = $_SESSION['member_id'];
		$model = Model();
		$reqlist = $model->table('chance')->field('cha_id,cha_title')->where($where)->select();
		if (!empty($reqlist)){
			$reqlistnew = array();
			foreach ((array)$reqlist as $k=>$v){
				$reqlistnew[$k] = array('id'=>$v['cha_id'],'title'=>$v['cha_title']);
			}
		}
		if(!empty($reqlistnew)){
			$rs = json_encode($reqlistnew);
		}
		echo $rs; die;
	}
	/**
	 * 获取会员收货地址列表
	 */
	public function getaddressOp(){
		$model = Model();
		$address_list = $model->table('address')->where('cc_id='.intval($_GET['cc_id']))->select();
		echo json_encode($address_list);die;
	}
	/**
	 * 检索订单页面
	 */
	public function search_orderOp(){
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		Tpl::showpage('search_order','null_layout');
	}
	/**
	 * 根据条件获取订单列表
	 */
	public function order_listOp(){
		$model = Model();
		$where_condition = "orders.co_status = 0";
		if(trim($_GET['co_code']) != ''){
			$where_condition .= " and orders.co_code like '%".trim($_GET['co_code'])."%'";
		}
		if(trim($_GET['cc_name']) != ''){
			$where_condition .= " and customer.cc_name like '%".trim($_GET['cc_name'])."%'";
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition .= " and orders.shop_id = ".intval($_GET['shop_id']);
		}else{
			/*分析当前员工的权限范围*/
			if($_SESSION['shop_id'] > 0){
				$where_condition .= " and orders.shop_id = ".$_SESSION['shop_id'];
			}
		}
		$order_list = $model->field('orders.co_id,orders.co_subject,orders.co_code,customer.cc_name,customer.cc_id')->table('orders,customer')->join('left')->on('orders.cc_id=customer.cc_id')->where($where_condition)->select();
		echo json_encode($order_list);die;
	}
	/**
	 * 获取订单商品列表
	 */
	public function get_order_productOp(){
		$model = Model();
		$co_id = intval($_GET['co_id']);
		$order_product_list = $model->field('order_product.*,product.cp_name')->table('order_product,product')->where('order_product.cp_id=product.cp_id and order_product.co_id='.$co_id)->select();
		//处理数组信息
		if(is_array($order_product_list) && !empty($order_product_list)){
			//从缓存中调取数据字典信息
			$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
			foreach ((array)$order_product_list as $k=>$v){
				$order_product_list[$k]['cop_unitprice'] = ncPriceFormat($v['cop_unitprice']);
				$order_product_list[$k]['cop_total_price'] = ncPriceFormat($v['cop_total_price']);
				$order_product_list[$k]['cp_ori_price'] = ncPriceFormat($v['cp_ori_price']);
				$order_product_list[$k]['cp_cost'] = ncPriceFormat($v['cp_cost']);
				$order_product_list[$k]['remain_num'] = $v['cop_pnum']-$v['cop_given'];
			}
		}
		echo json_encode($order_product_list);die;
	}
	/**
	 * 检索收款单页面
	 */
	public function search_incomeOp(){
		Tpl::showpage('search_income','null_layout');
	}
	/**
	 * 根据条件获取收款单列表
	 */
	public function income_listOp(){
		$model = Model();
		$where_condition = 'income.co_id=orders.co_id and income.cc_id=customer.cc_id and income.ci_bill=0';
		if(trim($_GET['ci_code']) != ''){
			$where_condition .= " and income.ci_code like '%".trim($_GET['ci_code'])."%'";
		}
		if(trim($_GET['cc_name']) != ''){
			$where_condition .= " and customer.cc_name like '%".trim($_GET['cc_name'])."%'";
		}
		$income_list = $model->field('income.*,orders.co_id,orders.co_code,orders.co_subject,customer.cc_name,customer.cc_id')->table('income,orders,customer')->where($where_condition)->select();
		echo json_encode($income_list);die;
	}
	/**
	 * 检索供应商页面
	 */
	public function search_supplierOp(){
		Tpl::showpage('search_supplier','null_layout');
	}
	/**
	 * 异步获取供应商列表
	 */
	public function supplier_listOp(){
		$model = Model();
		$where = array();
		$where['sup_istrash'] = '0';
		$where['sup_name'] = array('like',"%{$_GET['search_content']}%");
		$supplier_list = $model->table('supplier')->where($where)->select();
		echo json_encode($supplier_list);die;
	}
	/**
	 * 检索发货单页面
	 */
	public function search_shipmentOp(){
		Tpl::showpage('search_shipment','null_layout');
	}
	/**
	 * 根据条件异步获取发货单列表
	 */
	public function shipment_listOp(){
		$model = Model();
		$where_condition = 'shipment.co_id=orders.co_id and orders.cc_id=customer.cc_id';
		if(trim($_GET['shipment_code']) != ''){
			$where_condition .= " and shipment.shipment_code like '%".trim($_GET['shipment_code'])."%'";
		}
		if(trim($_GET['cc_name']) != ''){
			$where_condition .= " and customer.cc_name like '%".trim($_GET['cc_name'])."%'";
		}
		$income_list = $model->field('shipment.shipment_id,shipment.shipment_code,orders.co_code,orders.co_id,customer.cc_name')->table('shipment,orders,customer')->where($where_condition)->select();
		echo json_encode($income_list);die;
	}
	/**
	 * 弹出框搜索员工
	 */
	public function search_staffOp(){
		//获取部门列表
		$model = Model();
		$dp_list = $model->field('d_id,d_name')->table('department')->where(true)->select();
		Tpl::output('dp_list',$dp_list);
		Tpl::showpage('search_staff','null_layout');
	}
	/**
	 * 根据条件搜索员工
	 */
	public function staff_listOp(){
		$model = Model();
		$where_condition = array();
		if(trim($_GET['user_truename']) != ''){
			$where_condition['user_truename'] = array('like','%'.trim($_GET['user_truename']).'%');
		}
		if(trim($_GET['user_department']) != ''){
			$where_condition['user_department'] = intval($_GET['user_department']);
		}
		$staff_list = $model->field('user_id,user_truename,user_jobpostname')->table('user')->where($where_condition)->select();
		echo json_encode($staff_list);die;
	}
	/**
	 * 查询会员等级
	 */
	public function cusgrade_listOp(){
		$model = Model();
		$where = array();
		$where['cg_state'] = 1;
		if(intval($_GET['shopid']) > 0){
			$where['cg_shopid'] = intval($_GET['shopid']);
		}
		$cg_list = $model->field('cg_id,cg_name')->table('customergrade')->where($where)->select();
		echo json_encode($cg_list);die;
	}
	/**
	 * 查询会员自定义分组
	 */
	public function cusgroup_listOp(){
		$model = Model();
		$where = array();
		if(intval($_GET['shopid']) > 0){
			$where['cgroup_shopid'] = intval($_GET['shopid']);
		}
		$cgroup_list = $model->field('cgroup_id,cgroup_name')->table('customergroup')->where($where)->select();
		echo json_encode($cgroup_list);die;
	}
}