<?php
/**
 * 清除数据
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class cleardataControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('cleardata');
	}
	/*
	 * 公告数据列表
	 */
	public function clearnoticelistOp(){
		//读取语言包
		Language::read('notice');
		
		$where = array();
		if (!empty($_GET['search_content'])){
			$where['ntt_title|ntt_content'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime >0 && $etime > 0){
			$where['ntt_sendtime'] = array(array('gt',$stime),array('lt',$etime),'and');
		}elseif ($stime > 0) {
			$where['ntt_sendtime'] = array(array('gt',$stime));
		}elseif ($etime > 0) {
			$where['ntt_sendtime'] = array(array('lt',$etime));
		}
		$model = Model();
		$notice_list = $model->table('noticetext')->where($where)->order('ntt_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('notice_list',$notice_list);
		//左侧菜单
		$this->setleftmenu('clearnoticelist');
		Tpl::showpage('clear_noticelist');
	}
	/*
	 * 查看公告
	 */
	public function clearnoticeinfoOp(){
		//读取语言包
		Language::read('notice');
		
		$id = intval($_GET['id']);
		if ($id<=0){
			showMessage(Language::get('wrong_argument'),'','exception','error',1,0);
		}
		$model = Model();
		$notice_info = $model->table('noticetext')->where(array('ntt_id'=>$id))->find();
		if (empty($notice_info)){
			showMessage(Language::get('bp_notice_recorderror'),'','exception','error',1,0);
		}
		$notice_info['ntt_content'] = htmlspecialchars_decode($notice_info['ntt_content']);
		Tpl::output('notice_info',$notice_info);
		Tpl::showpage('clear_noticeinfo','windowopen_layout');
	}
	/*
	 * 彻底删除公告
	 */
	public function clearnoticedelOp(){
		//读取语言包
		Language::read('notice');
		$nid = $_GET['nid'];
		if (empty($nid)){
			$nid = $_POST['nid'];
		}
		if (empty($nid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$where = array();
		if (is_array($nid)){
			$where['ntt_id']= array('in',$nid);
		}else {
			$where['ntt_id']= $nid;
		}
		$model = Model();
		//添加清除日志
		$search_nid = is_array($nid)?implode(',',$nid):$nid;
		$ntt_info = $model->field('ntt_id,ntt_title')->table('noticetext')->where('ntt_id in ('.$search_nid.')')->select();
		$clear_log_insert_array = array();
		if(!empty($ntt_info)){
			foreach ((array)$ntt_info as $k=>$v){
				$clear_log_insert_array[] = array(
					'clog_type'=>'notice',
					'clog_time'=>time(),
					'clog_excstaff'=>$_SESSION['member_id'],
					'clog_truename'=>$_SESSION['truename'],
					'clog_content'=>Language::get('bp_notice_noticesubject').Language::get('bp_colon').$v['ntt_title']
				);
			}
		}
		$model->table('clearlog')->insertAll($clear_log_insert_array);
		
		$rs = $model->table('noticetext')->where($where)->delete();
		if($rs){
			//删除接收表记录
			$model->table('notice')->where(array('nt_nttid'=>$where['ntt_id']))->delete();
			//删除已读记录
			$model->table('noticeread')->where(array('ntread_nttid'=>$where['ntt_id']))->delete();
			showDialog(Language::get('bp_common_del_succ'),'index.php?act=cleardata&op=clearnoticelist','succ');
		}else{
			showDialog(Language::get('bp_common_del_fail'),'index.php?act=cleardata&op=clearnoticelist','error');
		}
	}
	/*
	 * 获得员工和岗位列表
	 */
	private function getUserList(){
		//查询报告给该岗位的员工
		$model = Model('user');
		$userlist = $model->getUserAndJobpostList();
		return $userlist;
	}
	/*
	 * 日报数据列表
	 */
	public function clearreportlistOp(){
		//读取语言包
		Language::read('report');
		
		$where = array();
		$where['rpt_type'] = 0;
		$where['rpt_issubmit'] = 1;
		//员工
		if (!empty($_GET['search_user'])){
			$where['rpt_userid'] = $_GET['search_user'];
		}
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 2:
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_pass'] = 2;
					break;
			}
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['rpt_recordtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['rpt_recordtime'] = array('elt',"$etime");
		}
		$model = Model();
		$reportlist = $model->table('report')->where($where)->order('rpt_recordtime desc')->page(10)->select();
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		$userlist = $this->getUserList();
		Tpl::output('userlist',$userlist);
		$this->setleftmenu('clearreportlist');
		Tpl::showpage('clearreportlist_day');
	}
	/*
	 * 周报数据列表
	 */
	public function clearreportweeklistOp(){
		//读取语言包
		Language::read('report');
		
		$where = array();		
		$where['rpt_type'] = 1;
		$where['rpt_issubmit'] = 1;
		//员工
		if (!empty($_GET['search_user'])){
			$where['rpt_userid'] = $_GET['search_user'];
		}
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 2:
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_pass'] = 2;
					break;
			}
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['rpt_recordtime'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['rpt_recordtime'] = array('elt',"$etime");
		}
		$model = Model('report');
		$reportlist = $model->getReportWeekList($where,10);
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		$userlist = $this->getUserList();
		Tpl::output('userlist',$userlist);
		$this->setleftmenu('clearreportlist');
		Tpl::showpage('clearreportlist_week');
	}
	/*
	 * 月报数据列表
	 */
	public function clearreportmonthlistOp(){
		//读取语言包
		Language::read('report');
		
		$where = array();		
		$where['rpt_type'] = 2;
		$where['rpt_issubmit'] = 1;
		//员工
		if (!empty($_GET['search_user'])){
			$where['rpt_userid'] = $_GET['search_user'];
		}
		//状态
		if (!empty($_GET['search_state'])){
			switch($_GET['search_state']){
				case 2:
					$where['rpt_pass'] = 0;
					break;
				case 3:
					$where['rpt_pass'] = 1;
					break;
				case 4:
					$where['rpt_pass'] = 2;
					break;
			}
		}
		//时间
		$year = intval($_GET['r_year']);
		$month = intval($_GET['r_month']);
		if ($year > 0 && $month > 0){
			$stime = mktime(0, 0, 0, $month, 1, $year);
			$etime = mktime(0, 0, 0, $month+1, 0, $year);
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($year > 0){
			$stime = mktime(0, 0, 0, 1, 1, $year);
			$etime = mktime(0, 0, 0, 12, 31, $year);
			$where['rpt_recordtime'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}
		$model = Model('report');
		$reportlist = $model->getReportMonthList($where,10);
		if (!empty($reportlist)){
			foreach ((array)$reportlist as $k=>$v){
				$v['rpt_summary'] = replaceHtmlAndJs($v['rpt_summary']);
				$v['rpt_summary'] = strip_tags($v['rpt_summary']);
				$reportlist[$k] = $v;
			}
		}
		Tpl::output('reportlist',$reportlist);
		Tpl::output('show_page',$model->showpage(2));
		//年
		$year_arr = getSystemYearArr();
		//月
		$month_arr = getSystemMonthArr();
		Tpl::output('year_arr',$year_arr);
		Tpl::output('month_arr',$month_arr);
		
		$userlist = $this->getUserList();
		Tpl::output('userlist',$userlist);
		$this->setleftmenu('clearreportlist');
		Tpl::showpage('clearreportlist_month');
	}
	/*
	 * 日报数据详细
	 */
	public function clearreportinfoOp(){
		//读取语言包
		Language::read('report');
		
		//查询当日报告记录		
		$rpt_id = intval($_GET['rpt_id']);
		if($rpt_id <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$reportinfo = $model->table('report')->where(array('rpt_id'=>$rpt_id,'rpt_type'=>0,'rpt_issubmit'=>1))->find();
		$reportinfo['rpt_summary'] = htmlspecialchars_decode($reportinfo['rpt_summary']);
		$reportinfo['rpt_plan'] = htmlspecialchars_decode($reportinfo['rpt_plan']);
		Tpl::output('reportinfo',$reportinfo);
		Tpl::showpage('clearreportinfo_day','windowopen_layout');
	}
	/*
	 * 周报数据详细
	 */
	public function clearreportweekinfoOp(){
		//读取语言包
		Language::read('report');
		
		$rpt_id = intval($_GET['rpt_id']);
		if($rpt_id <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询本周报告记录
		$reportinfo = $model->table('report')->where(array('rpt_id'=>$rpt_id,'rpt_type'=>1,'rpt_issubmit'=>1))->find();
		$reportinfo['rpt_summary'] = htmlspecialchars_decode($reportinfo['rpt_summary']);
		$reportinfo['rpt_plan'] = htmlspecialchars_decode($reportinfo['rpt_plan']);
		if (!empty($reportinfo)){
			$end_date = date('Y-m-d',$reportinfo['rpt_recordtime']);
			$start_time = $reportinfo['rpt_recordtime'] - 86400*6;
			$start_date = date('Y-m-d',$start_time);
		}
		Tpl::output('start_date',$start_date);
		Tpl::output('end_date',$end_date);
		Tpl::output('reportinfo',$reportinfo);
		Tpl::showpage('clearreportinfo_week','windowopen_layout');
	}
	/*
	 * 月报数据详细
	 */
	public function clearreportmonthinfoOp(){
		//读取语言包
		Language::read('report');
		
		$rpt_id = intval($_GET['rpt_id']);
		if($rpt_id<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$reportinfo = $model->table('report')->where(array('rpt_id'=>$rpt_id,'rpt_type'=>2,'rpt_issubmit'=>1))->find();
		$reportinfo['rpt_summary'] = htmlspecialchars_decode($reportinfo['rpt_summary']);
		$reportinfo['rpt_plan'] = htmlspecialchars_decode($reportinfo['rpt_plan']);
		$year = 0;
		$month = 0;
		if (!empty($reportinfo)){
			$year = @date('Y',$reportinfo['rpt_recordtime']);
			$month = @date('m',$reportinfo['rpt_recordtime']);
		}
		Tpl::output('year',$year);
		Tpl::output('month',$month);
		Tpl::output('reportinfo',$reportinfo);
		Tpl::showpage('clearreportinfo_month','windowopen_layout');
	}
	/*
	 * 删除报告数据
	 */
	public function clearreportdelOp(){
		//读取语言包
		Language::read('report');
		
		$rid = $_GET['rid'];
		if (empty($rid)){
			$rid = $_POST['rid'];
		}
		if (empty($rid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$where = array();
		if (is_array($rid)){
			$where['rpt_id']= array('in',$rid);
		}else {
			$where['rpt_id']= $rid;
		}
		$where['rpt_issubmit']= 1;
		$model = Model();
		//添加清除日志
		$search_rid = is_array($rid)?implode(',',$rid):$rid;
		$ntt_info = $model->field('rpt_id,rpt_username,rpt_type,rpt_summary,rpt_plan,rpt_recordtime')->table('report')->where('rpt_id in ('.$search_rid.')')->select();
		$clear_log_insert_array = array();
		if(!empty($ntt_info)){
			foreach ((array)$ntt_info as $k=>$v){
				$clear_log_insert_array[] = array(
					'clog_type'=>'report',
					'clog_time'=>time(),
					'clog_excstaff'=>$_SESSION['member_id'],
					'clog_truename'=>$_SESSION['truename'],
					'clog_content'=>Language::get('bp_report_submited_by').Language::get('bp_colon').$v['rpt_username'].Language::get('bp_comma').Language::get('bp_report_view_recordtype').Language::get('bp_colon').($v['rpt_type']==0?Language::get('bp_report_daily_report'):($v['rpt_type']==1?Language::get('bp_report_weekly_report'):Language::get('bp_report_monthly_report'))).Language::get('bp_comma').Language::get('bp_report_view_recordtime').Language::get('bp_colon').date('Y-m-d',$v['rpt_recordtime'])
				);
			}
		}
		$model->table('clearlog')->insertAll($clear_log_insert_array);
		
		$rs = $model->table('report')->where($where)->delete();
		$op = 'clearreportlist';
		if($_GET['type'] == 'week'){
			$op = 'clearreportweeklist';
		}elseif($_GET['type'] == 'month'){
			$op = 'clearreportmonthlist';
		}
		if($rs){
			showDialog(Language::get('bp_common_del_succ'),'index.php?act=cleardata&op='.$op,'succ');
		}else{
			showDialog(Language::get('bp_common_del_fail'),'index.php?act=cleardata&op='.$op,'error');
		}
	}
	/*
	 * 订单数据列表
	 */
	public function clearorderlistOp(){
		//读取语言包
		Language::read('order');
		
		$model = Model();
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		$where_condition = "orders.cc_id=customer.cc_id and orders.co_staff_id=user.user_id";
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_withoutpermission'));
			}
			if(intval($_GET['shop_id']) == 0){
				redirect('index.php?act=cleardata&op=clearorderlist&shop_id='.$_SESSION['shop_id']);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					redirect('index.php?act=cleardata&op=clearorderlist&shop_id='.$default_shop);die;
				}
			}
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition .= " and orders.shop_id = ".intval($_GET['shop_id']);
		}
		//过滤器
		$filter = trim($_GET['filter']);
		switch ($filter){
			case 'working':
				$where_condition .= " and orders.co_status = 0";
				break;
			case 'done':
				$where_condition .= " and orders.co_status = 1";
				break;
			case 'shipment':
				$where_condition .= " and orders.co_status = 2";
				break;
			case 'trash':
				$where_condition .= " and orders.co_status = 3";
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'co_subject':
					$where_condition .= " and orders.co_subject like '%".trim($_GET['search_content'])."%'";
					break;
				case 'cc_name':
					$where_condition .= " and customer.cc_name like '%".trim($_GET['search_content'])."%'";
					break;
				case 'co_code':
					$where_condition .= " and orders.co_code like '%".trim($_GET['search_content'])."%'";
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		//自定义字段的搜索处理
		if(!empty($_GET['selfdic_search'])){
			$sd_choose = array();
			foreach ((array)$_GET['selfdic_search'] as $sk=>$sv){
				if($sv != 0){
					$where_condition .= " and orders.co_self_field like '%".$sv."%'";
					$sd_choose[] = $sv;
				}
			}
			Tpl::output('sd_choose',$sd_choose);
		}
		//每页显示条数
		$pagesize = intval($_GET['pagesize']) > 0 ? intval($_GET['pagesize']) : 10;
		$order_list = $model->field('orders.*,customer.cc_name,user.user_truename,shop.shop_name')->table('orders,customer,user,shop')->join('left')->on('customer.cc_id=orders.cc_id,orders.co_staff_id=user.user_id,orders.shop_id=shop.shop_id')->where($where_condition)->page($pagesize)->order('orders.co_addtime desc')->select();
		Tpl::output('order_list',$order_list);
		Tpl::output('show_page',$model->showpage(2));
		$this->setleftmenu('clearorderlist');
		/**
		 * 自定义字段的处理
		 */
		$selfdic_array = $model->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		Tpl::output('selfdic_show',$selfdic_show);
		Tpl::output('selfdic_search',$selfdic_search);
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('clearorderlist');
	}
	/*
	 * 清除订单数据
	 */
	public function order_clearOp(){
		//读取语言包
		Language::read('order');
		
		$model = Model();
		$clear_order = '';
		//批量清除
		if(trim($_GET['type']) == 'batch'){
			if(empty($_POST['co_check']) || !is_array($_POST['co_check'])){
				showDialog(Language::get('wrong_argument'));
			}
			foreach ((array)$_POST['co_check'] as $k=>$v){
				$clear_order .= $v.',';
			}
			$clear_order = trim($clear_order,',');
		}else{//单个清除
			$clear_order = intval($_GET['co_id']);
		}
		//添加清除日志
		$order_info = $model->field('orders.co_id,orders.co_code,orders.co_subject,customer.cc_name')->table('orders,customer')->where('orders.cc_id=customer.cc_id and orders.co_id in ('.$clear_order.')')->select();
		$clear_log_insert_array = array();
		if(!empty($order_info)){
			foreach ((array)$order_info as $k=>$v){
				$clear_log_insert_array[] = array(
					'clog_type'=>'order',
					'clog_time'=>time(),
					'clog_excstaff'=>$_SESSION['member_id'],
					'clog_truename'=>$_SESSION['truename'],
					'clog_content'=>Language::get('bp_order_order_sn').Language::get('bp_colon').$v['co_code'].Language::get('bp_comma').Language::get('bp_order_order_theme').Language::get('bp_colon').$v['co_subject'].Language::get('bp_comma').Language::get('bp_order_member_name').Language::get('bp_colon').$v['cc_name']
				);
			}
		}
		$model->table('clearlog')->insertAll($clear_log_insert_array);
		//清除订单及其所有相关数据信息
		$model->table('orders')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('order_log')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('order_product')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('bill')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('income')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('returns')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('shipment')->where('co_id in ('.$clear_order.')')->delete();
		$model->table('refund')->where('co_id in ('.$clear_order.')')->delete();
		
		showDialog(Language::get('bp_order_clearsucc'),'index.php?act=cleardata&op=clearorderlist','succ');
	}
	/**
	 * 记事本列表
	 */
	public function clearnotepadlistOp(){
		//读取语言包
		Language::read('notepad');
		
		//一般列表
		$model = Model();
		if (!empty($_GET['search_content'])){
			$where['np_title|np_content'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		if (!empty($_GET['search_cname'])){
			$where['np_customername'] = array('like',"%{$_GET['search_cname']}%");
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['np_executetime'] = array(array('gt',"$stime"),array('lt',"$etime"),'and');
		}elseif($stime > 0){
			$where['np_executetime'] = array('gt',"$stime");
		}elseif($etime>0){
			$where['np_executetime'] = array('lt',"$etime");
		}
		$np_list = $model->table('notepad')->where($where)->order('np_id desc')->page(10)->select();
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('np_list',$np_list);
		$this->setleftmenu('clearnotepadlist');
		Tpl::showpage('clearnotepadlist');
	}
	/**
	 * 删除记事本
	 */
	public function clearnotepaddelOp(){
		//读取语言包
		Language::read('notepad');
		
		$npid = $_GET['npid'];
		if (empty($npid)){
			$npid = $_POST['npid'];
		}
		if (empty($npid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		if (is_array($npid)){
			$where['np_id'] = array('in',$npid);
		}else {
			$where['np_id'] = $npid;
		}
		//添加清除日志
		$search_npid = is_array($npid)?implode(',',$npid):$npid;
		$ntt_info = $model->field('np_id,np_title')->table('notepad')->where('np_id in ('.$search_npid.')')->select();
		$clear_log_insert_array = array();
		if(!empty($ntt_info)){
			foreach ((array)$ntt_info as $k=>$v){
				$clear_log_insert_array[] = array(
					'clog_type'=>'notepad',
					'clog_time'=>time(),
					'clog_excstaff'=>$_SESSION['member_id'],
					'clog_truename'=>$_SESSION['truename'],
					'clog_content'=>Language::get('bp_notepad_notepadtitle').Language::get('bp_colon').$v['np_title']
				);
			}
		}
		$model->table('clearlog')->insertAll($clear_log_insert_array);
		//删除记事本信息
		$rs = $model->table('notepad')->where($where)->delete();
		if ($rs){
			showDialog(Language::get('bp_common_del_succ'),'index.php?act=cleardata&op=clearnotepadlist','succ');
		} else {
			showDialog(Language::get('bp_common_del_fail'),'','error');
		}
	}
	/**
	 * 记事本查看详细
	 */
	public function clearnotepadviewOp(){
		//读取语言包
		Language::read('notepad');
		
		$npid = intval($_GET['npid']);
		if ($npid<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询记事本详细
		$np_info = $model->table('notepad')->where(array('np_id'=>$npid))->find();
		Tpl::output('np_info',$np_info);
		Tpl::showpage('clearnotepadview','windowopen_layout');
	}
	/*
	 * 商品数据列表
	 */
	public function clearproductlistOp(){
		//读取语言包
		Language::read('product');
		
		$model = Model('product_class');
		$where_condition = '';
		$filter = trim($_GET['filter']);
		/**
		 * 调取店铺缓存信息
		 */
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		Tpl::output('shop_list',$shop_list);
		//优先显示所属店铺信息
		if($_SESSION['shop_id'] > 0){
			if(intval($_GET['shop_id'])>0 && intval($_GET['shop_id'])!=$_SESSION['shop_id']){
				showDialog(Language::get('bp_withoutpermission'));
			}
			if(intval($_GET['shop_id']) == 0){
				redirect('index.php?act=cleardata&op=clearproductlist&shop_id='.$_SESSION['shop_id']);die;
			}
		}else{
			if(trim($_GET['search_content']) == '' && trim($_GET['shop_id']) != 'all'){
				//无所属店铺则找出默认店铺并进行优先显示
				$default_shop = 0;
				if(!empty($shop_list)){
					foreach ($shop_list as $k=>$v){
						if($v['shop_default'] == 1){
							$default_shop = $v['shop_id'];
							break;
						}
					}
				}
				if(intval($_GET['shop_id']) == 0 && $default_shop > 0){
					redirect('index.php?act=cleardata&op=clearproductlist&shop_id='.$default_shop);die;
				}
			}
		}
		if(intval($_GET['shop_id']) > 0){
			$where_condition .= ' and product.shop_id = '.intval($_GET['shop_id']);
		}
		switch ($filter){
			case 'onsale':
				$where_condition .= ' and product.cp_status=1';
				break;
			case 'instock':
				$where_condition .= ' and product.cp_status=2';
				break;
		}
		//处理检索表单的请求
		$search_type = trim($_GET['search_type']);
		if ($search_type != ''){
			switch (trim($_GET['search_type'])){
				case 'product_name':
					$where_condition .= " and product.cp_name like '%".trim($_GET['search_content'])."%'";
					break;
				case 'product_code':
					$where_condition .= " and product.cp_code like '%".trim($_GET['search_content'])."%'";
					break;
				case 'product_barcode':
					$where_condition .= " and product.cp_barcode like '%".trim($_GET['search_content'])."%'";
					break;
			}
			Tpl::output('search_content',trim($_GET['search_content']));
			Tpl::output('search_type',trim($_GET['search_type']));
		}
		//自定义字段的搜索处理
		if(!empty($_GET['selfdic_search'])){
			$sd_choose = array();
			foreach ((array)$_GET['selfdic_search'] as $sk=>$sv){
				if($sv != 0){
					$where_condition .= ' and product.cp_self_field like \'%"'.$sv.'"%\'';
					$sd_choose[] = $sv;
				}
			}
			Tpl::output('sd_choose',$sd_choose);
		}
		$where_condition = substr($where_condition, 5);
		//每页显示条数
		$pagesize = intval($_GET['pagesize']) > 0 ? intval($_GET['pagesize']) : 10;
		$product_list = $model->field('product.*,shop.shop_name')->table('product,shop')->join('left')->on('product.shop_id=shop.shop_id')->where($where_condition)->page($pagesize)->order('product.cp_updatetime desc')->select();
		/**
		 * 从缓存中调取数据字典信息
		 */
		$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
		/**
		 * 自定义字段的处理
		 */
		$selfdic_array = $model->table('dictionary')->where('cd_status=1 and cd_model_id=3')->select();
		$selfdic_show = array();//列表展示字段
		$selfdic_search = array();//列表搜素字段
		if(is_array($selfdic_array) && !empty($selfdic_array)){
			foreach ((array)$selfdic_array as $k=>$v){
				if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0 && ($v['cd_listshow_status'] == 1 || $v['cd_listsearch_status'] == 1)){
					$tmp_child_list = array();
					foreach ((array)$selfdic_array as $ck=>$cv){
						if($cv['cd_parent_id'] == $v['cd_id']){
							$tmp_child_list[$cv['cd_id']] = $cv;
						}
					}
					if($v['cd_listshow_status'] == 1){
						$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					if($v['cd_listsearch_status'] == 1){
						$selfdic_search[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
					}
					unset($tmp_child_list);
				}
			}
		}
		Tpl::output('selfdic_show',$selfdic_show);
		Tpl::output('selfdic_search',$selfdic_search);
		/**
		 * 模板输出
		 */
		Tpl::output('product_list',$product_list);
		Tpl::output('dic_array',$dic_array);
		Tpl::output('show_page',$model->showpage(2));
		$this->setleftmenu('clearproductlist');
		Tpl::showpage('clearproductlist');
	}
	/*
	 * 清除商品数据
	 */
	public function product_clearOp(){
		//读取语言包
		Language::read('product');
		
		$model = Model('product_class');
		$clear_product = '';
		//批量清除
		if(trim($_GET['type']) == 'batch'){
			if(empty($_POST['cp_check']) || !is_array($_POST['cp_check'])){
				showDialog(Language::get('wrong_argument'));
			}
			foreach ((array)$_POST['cp_check'] as $k=>$v){
				$clear_product .= $v.',';
			}
			$clear_product = trim($clear_product,',');
		}else{//单个清除
			$clear_product = intval($_GET['cp_id']);
		}
		//添加清除日志
		$cp_info = $model->field('cp_id,cp_name,cp_pic')->table('product')->where('cp_id in ('.$clear_product.')')->select();
		$clear_log_insert_array = array();
		$delete_pics = array();
		if(!empty($cp_info)){
			foreach ((array)$cp_info as $k=>$v){
				$clear_log_insert_array[] = array(
					'clog_type'=>'product',
					'clog_time'=>time(),
					'clog_excstaff'=>$_SESSION['member_id'],
					'clog_truename'=>$_SESSION['truename'],
					'clog_content'=>Language::get('bp_product_goods_name').Language::get('bp_colon').$v['cp_name']
				);
				$delete_pics[] = $v['cp_pic'];
			}
		}
		$clog_rs = $model->table('clearlog')->insertAll($clear_log_insert_array);
		//清除商品及其所有相关数据信息
		$rs = $model->table('product')->where('cp_id in ('.$clear_product.')')->delete();
		//删除商品图片
		foreach ((array)$delete_pics as $del_pic){
			@unlink(BasePath.'/upload/product/'.$del_pic);
		}
		if($rs && $clog_rs){
			showDialog(Language::get('bp_product_clearsucc'),'index.php?act=cleardata&op=clearproductlist','succ');
		}else{
			showDialog(Language::get('bp_product_clearfail'));
		}
	}
	/*
	 * 清除日志
	 */
	public function clear_logOp(){
		$model = Model();
		/**
		 * 调取日志信息
		 */
		//处理检索表单的请求
		$where_condition = '';
		if(trim($_GET['clog_type']) != ''){
			$where_condition .= " and clog_type = '".trim($_GET['clog_type'])."'";
		}
		if(trim($_GET['search_content']) != ''){
			$where_condition .= " and clog_truename like '%".trim($_GET['search_content'])."%'";
			Tpl::output('search_content',trim($_GET['search_content']));
		}
		$where_condition = substr($where_condition, 5);
		$clear_log_list = $model->table('clearlog')->where($where_condition)->page(10)->order('clog_time desc')->select();
		Tpl::output('clear_log_list',$clear_log_list);
		/**
		 * 模板输出
		 */
		Tpl::output('show_page',$model->showpage(2));
		$this->setleftmenu('clear_log');
		Tpl::showpage('clear_log');
	}
	/**
	 * 销售机会列表
	 */
	public function clearchancelistOp(){
		//读取语言包
		Language::read('chance');
		
		$model = Model();
		$where = array();
		if (!empty($_GET['search_content'])){
			$where['cha_title'] = array(array('like',"%{$_GET['search_content']}%"));
		}
		if (!empty($_GET['search_ctype'])){
			$where['cha_type'] = intval($_GET['search_ctype']);
		}
		if (!empty($_GET['search_stage'])){
			$where['cha_stage'] = intval($_GET['search_stage']);
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cha_predictdate'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cha_predictdate'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cha_predictdate'] = array('elt',"$etime");
		}
		$chancelist = $model->table('chance')->where($where)->order('cha_id desc')->page(10)->select();
		$chancelistnew = array();
		if(!empty($chancelist)){
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			foreach((array)$chancelist as $k=>$v){
				$v['typetext'] = $dic_array['chancetype']['child_option'][$v['cha_type']]['cd_name'];
				$v['predictdate_text'] = ($t = $v['cha_predictdate'])?@date('Y-m-d',$t):'';
				$v['stagetext'] = $dic_array['chancestage']['child_option'][$v['cha_stage']]['cd_name'];
				$v['probabilitytext'] = $dic_array['chanceprobability']['child_option'][$v['cha_probability']]['cd_name'];
				$v['statetext'] = $this->chancestate_arr[$v['cha_state']];
				$v['stopdays'] = floor((time() - $v['cha_stagechangedate'])/86400);
				$chancelistnew[$k] = $v;
			}
		}
		$where['cha_state'] = 0;
		Tpl::output('chancelist',$chancelistnew);
		Tpl::output('show_page',$model->showpage(2));
		
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		Tpl::output('dic_array',$dic_array);
		//左侧菜单
		$this->setleftmenu('clearchancelist');
		Tpl::showpage('clearchancelist');	
	}
	
	/**
	 * 删除销售机会数据
	 */
	public function clearchancedelOp(){
		//读取语言包
		Language::read('chance');
		$cid = $_GET['cid'];
		if (empty($cid)){
			$cid = $_POST['cid'];
		}
		if (empty($cid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		if (is_array($cid)){
			$where['cha_id'] = array('in',$cid);
		}else {
			$where['cha_id'] = $cid;
		}
		//添加清除日志
		$chance_list = $model->field('cha_id,cha_title,cha_username')->table('chance')->where($where)->select();
		$clear_log_insert_array = array();
		if(!empty($chance_list)){
			foreach ((array)$chance_list as $k=>$v){
				$clear_log_insert_array[] = array(
					'clog_type'=>'chance',
					'clog_time'=>time(),
					'clog_excstaff'=>$_SESSION['member_id'],
					'clog_truename'=>$_SESSION['truename'],
					'clog_content'=>Language::get('bp_chance_user').Language::get('bp_colon').$v['cha_username'].Language::get('bp_comma').Language::get('bp_home_sale_chance').Language::get('bp_colon').$v['cha_title']
				);
			}
		}
		$model->table('clearlog')->insertAll($clear_log_insert_array);
		$rs = $model->table('chance')->where($where)->delete();
		if ($rs){
			//删除销售机会相关数据
			$model->table('chancelog')->where(array('chal_chanceid'=>$where['cha_id']))->delete();//销售机会转移日志
			$model->table('chanceprogress')->where(array('cp_chanceid'=>$where['cha_id']))->delete();//销售机会进程日志
			$model->table('quotedprice')->where(array('qp_chanceid'=>$where['cha_id']))->delete();//报价单
			$model->table('requirement')->where(array('req_chanceid'=>$where['cha_id']))->delete();//详细需求
			$model->table('schedule')->where(array('cs_chanceid'=>$where['cha_id']))->delete();//日程
			$model->table('solution')->where(array('sol_chanceid'=>$where['cha_id']))->delete();//解决方案
			$model->table('mission')->where(array('cm_chanceid'=>$where['cha_id']))->delete();//任务
			$model->table('competitor')->where(array('cpr_chanceid'=>$where['cha_id']))->delete();//竞争对手
			$model->table('customer_action')->where(array('cca_chanceid'=>$where['cha_id']))->delete();//历史行动
			showDialog(Language::get('bp_common_del_succ'),'index.php?act=cleardata&op=clearchancelist','succ');
		} else {
			showDialog(Language::get('bp_common_del_fail'),'','error');
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_clean_up_data'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'clearnoticelist','menu_name'=>Language::get('bp_cleardata_noticedata'),'menu_act'=>'cleardata','menu_op'=>'clearnoticelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'clearreportlist','menu_name'=>Language::get('bp_cleardata_reportdata'),'menu_act'=>'cleardata','menu_op'=>'clearreportlist','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'clearorderlist','menu_name'=>Language::get('bp_cleardata_ordersdata'),'menu_act'=>'cleardata','menu_op'=>'clearorderlist','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'clearproductlist','menu_name'=>Language::get('bp_cleardata_productdata'),'menu_act'=>'cleardata','menu_op'=>'clearproductlist','linktype'=>'0');
		$arr[0]['submenu'][4] = array('menu_key'=>'clearnotepadlist','menu_name'=>Language::get('bp_cleardata_notepaddata'),'menu_act'=>'cleardata','menu_op'=>'clearnotepadlist','linktype'=>'0');
		$arr[0]['submenu'][5] = array('menu_key'=>'clearchancelist','menu_name'=>Language::get('bp_cleardata_chancedata'),'menu_act'=>'cleardata','menu_op'=>'clearchancelist','linktype'=>'0');
		$arr[0]['submenu'][6] = array('menu_key'=>'clear_log','menu_name'=>Language::get('bp_cleardata_clearlog'),'menu_act'=>'cleardata','menu_op'=>'clear_log','linktype'=>'0');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}