<?php
/**
 * 销售机会页面
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class chanceControl extends BaseHomeControl{
	private $chancestate_arr;
	private $commonwhere= array();
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('chance');
		
		$this->chancestate_arr = array(0=>Language::get('bp_chance_state_0'),1=>Language::get('bp_chance_state_1'),2=>Language::get('bp_chance_state_2'),3=>Language::get('bp_chance_state_3'),4=>Language::get('bp_chance_state_4'));
		Tpl::output('chancestate_arr',$this->chancestate_arr);
				
		$model = Model();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['cha_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['cha_userid'] = $_SESSION['member_id'];
		}
	}
	/**
	 * 机会列表
	 */
	public function chancelistOp(){
		set_time_limit(0);
		$model = Model();
		$where = $this->commonwhere;
		if(trim($_GET['filter']) == 'trash'){
			$where['cha_istrash'] = '1';
		}else {
			$where['cha_istrash'] = '0';
		}
		if(empty($this->commonwhere['cha_userid']) && !empty($_GET['search_user'])){//权限为部门领导是搜索部门
			$where['cha_userid'] = $_GET['search_user'];
		}
		if (!empty($_GET['search_ctype'])){
			$where['cha_type'] = intval($_GET['search_ctype']);
		}
		if (!empty($_GET['filter']) && trim($_GET['filter']) != 'trash'){
			$where['cha_stage'] = intval($_GET['filter']);
		}
		if (!empty($_GET['search_probability'])){
			$where['cha_probability'] = intval($_GET['search_probability']);
		}
		if (!empty($_GET['search_state'])){
			$where['cha_state'] = intval($_GET['search_state'])-1;
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['cha_predictdate'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cha_predictdate'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cha_predictdate'] = array('elt',"$etime");
		}
		if ($_GET['exporttype'] == 'excel'){
			$chancelist = $model->table('chance,customer')->join('left')->on('chance.cha_customerid=customer.cc_id')->where($where)->order('cha_id desc')->select();
		}else {
			$chancelist = $model->table('chance,customer')->join('left')->on('chance.cha_customerid=customer.cc_id')->where($where)->order('cha_id desc')->page(10)->select();
			//查询状态为跟踪的机会预期金额总和
			$where['cha_state'] = 0;
			$predmoney_count = $model->table('chance')->field('sum(cha_predictmoney) as moneysum')->where($where)->find();
		}
		$chancelistnew = array();
		$predmoney_pagecount = 0;
		if(!empty($chancelist)){
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			foreach((array)$chancelist as $k=>$v){
				$v['typetext'] = $dic_array['chancetype']['child_option'][$v['cha_type']]['cd_name'];
				$v['predictdate_text'] = ($t = $v['cha_predictdate'])?@date('Y-m-d',$v['cha_predictdate']):'';
				$v['stagetext'] = $dic_array['chancestage']['child_option'][$v['cha_stage']]['cd_name'];
				$v['probabilitytext'] = $dic_array['chanceprobability']['child_option'][$v['cha_probability']]['cd_name'];
				$v['statetext'] = $this->chancestate_arr[$v['cha_state']];
				$v['stopdays'] = floor((time() - $v['cha_stagechangedate'])/86400);
				if ($v['cha_state'] == 0){
					$predmoney_pagecount += round($v['cha_predictmoney'],2);
				}
				if (empty($v['cc_id']) || $v['cc_isdel'] == 1){
					$v['cc_statetext'] = Language::get('bp_openparen').Language::get('bp_chance_customerdeleted').Language::get('bp_closeparen');
				}
				$chancelistnew[$k] = $v;
			}
		}
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		//导出Excel
		if ($_GET['exporttype'] == 'excel'){
			//导出Excel
			import('excel#class');
			$excel_class = new ExcelXML(C('exportfilefont'));
			$excel_data = array();
			//设置样式
			$excel_class->setStyle(array('id'=>'s_title','Font'=>array('FontName'=>C('exportfilefont'),'Size'=>'12','Bold'=>'1')));
			//header
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_subject'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_user'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_member'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_typetext'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_predictdate'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_predictmoney'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_stage'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_probability'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_state'));
			$excel_data[0][] = array('styleid'=>'s_title','data'=>Language::get('bp_chance_stopdays'));
			//data
			foreach ((array)$chancelistnew as $k=>$v){
				$tmp = array();
				$tmp[] = array('data'=>$v['cha_title']);
				$tmp[] = array('data'=>$v['cha_username']);
				$tmp[] = array('data'=>$v['cha_customername'].$v['cc_statetext']);
				$tmp[] = array('data'=>$v['typetext']);
				$tmp[] = array('data'=>$v['predictdate_text']);
				$tmp[] = array('data'=>ncPriceFormat($v['cha_predictmoney']));
				$tmp[] = array('data'=>$v['stagetext']);
				$tmp[] = array('data'=>$v['probabilitytext']);
				$tmp[] = array('data'=>$v['statetext']);
				$tmp[] = array('data'=>$v['stopdays']);
				$excel_data[] = $tmp;
			}
			$excel_class->addArray($excel_data);
			$excel_class->addWorksheet(Language::get('bp_home_sale_chance'));
			$excel_class->generateXML(Language::get('bp_home_sale_chance').date('Y-m-d H-i-s',time()));
			exit();
		}
		Tpl::output('dic_array',$dic_array);
		Tpl::output('currenturl',request_uri());
		
		Tpl::output('chancelist',$chancelistnew);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('predmoney_pagecount',ncPriceFormat($predmoney_pagecount));
		Tpl::output('predmoney_count',$predmoney_count['moneysum']);
		$this->setleftmenu('chancelist');
		Tpl::showpage('chancelist');
	}
	/**
	 * 新增机会
	 */
	public function chanceaddOp(){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["c_title"],"require"=>"true","message"=>Language::get('bp_chance_add_subjectnull'));
			$validate_arr[] = array("input"=>$_POST["c_cid"],"require"=>"true","message"=>Language::get('bp_chance_add_customernull'));
			$validate_arr[] = array("input"=>$_POST["c_discoverydate"],"require"=>"true","message"=>Language::get('bp_chance_add_discoverydatenull'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>$_POST["c_cid"],'cc_isdel'=>0,'cc_insea'=>0))->find();
			if(empty($customer_info)){
				showDialog(Language::get('bp_chance_add_customererror'),'','error');
			}
			//查询联系人信息
			if(!empty($_POST['c_contacts']) && $customer_info['cc_type'] == 1){
				$contacts_info = $model->table('company_contact')->where(array('ccc_id'=>$_POST['c_contacts'],'ccc_isdel'=>'0','cc_id'=>$customer_info['cc_id']))->find();
			}
			$insert_arr = array();
			$insert_arr['cha_title'] = $_POST['c_title'];
			$insert_arr['cha_customerid'] = $customer_info['cc_id'];
			$insert_arr['cha_customername'] = $customer_info['cc_name'];
			$insert_arr['cha_contactid'] = $contacts_info['ccc_id'];
			$insert_arr['cha_contactname'] = $contacts_info['ccc_name'];
			$insert_arr['cha_type'] = intval($_POST['c_type']);
			$insert_arr['cha_discoverydate'] = ($t=$_POST['c_discoverydate'])?strtotime($t):0;
			$insert_arr['cha_addtime'] = time();
			$insert_arr['cha_source'] = intval($_POST['c_source']);
			$insert_arr['cha_adduserid'] = $_SESSION['member_id'];
			$insert_arr['cha_addusername'] = $_SESSION['truename'];
			$insert_arr['cha_adddepartmentid'] = $_SESSION['dp_id'];
			$insert_arr['cha_userid'] = $_SESSION['member_id'];
			$insert_arr['cha_username'] = $_SESSION['truename'];
			$insert_arr['cha_departmentid'] = $_SESSION['dp_id'];
			$insert_arr['cha_needtext'] = $_POST['c_needtext'];
			$insert_arr['cha_predictdate'] = ($t=$_POST['c_predictdate'])?strtotime($t):0;
			$insert_arr['cha_predictmoney'] = $_POST['c_predictmoney']?$_POST['c_predictmoney']:0;
			$insert_arr['cha_stage'] = intval($_POST['c_stage']);
			$insert_arr['cha_probability'] = intval($_POST['c_probability']);
			$insert_arr['cha_state'] = intval($_POST['c_state']);
			$insert_arr['cha_stageremark'] = $_POST['c_stageremark'];
			$insert_arr['cha_stagechangedate'] = time();
			$insert_arr['cha_istrash'] = 0;
			$rs = $model->table('chance')->insert($insert_arr);
			if ($rs){
				//记录推进日志
				$insertlog_arr = array();
				$insertlog_arr['cp_chanceid'] = $rs;
				$insertlog_arr['cp_adddate'] = time();
				$insertlog_arr['cp_state'] = $insert_arr['cha_state'];
				$insertlog_arr['cp_stage'] = $insert_arr['cha_stage'];
				$insertlog_arr['cp_operatoruid'] = $insert_arr['cha_userid'];
				$insertlog_arr['cp_operatoruname'] = $insert_arr['cha_username'];
				$insertlog_arr['cp_remark'] = $_POST['c_stageremark'];
				$model->table('chanceprogress')->insert($insertlog_arr);
				showDialog(Language::get('bp_chance_add_succ'),'index.php?act=chance&op=chancelist','succ');
			}else {
				showDialog(Language::get('bp_chance_add_fail'),'','error');
			}
		}else{
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('chancelist');
			Tpl::showpage('chanceadd');
		}
	}
	/*
	 * 编辑销售机会
	 */
	public function chanceeditOp(){
		$cid = intval($_GET['cid']);
		if ($cid<=0){
			$cid = intval($_POST['cid']);
		}
		if ($cid<=0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where = array();
		$where['cha_id'] = $cid;
		$where['cha_istrash'] = 0;
		$where = array_merge($where,$this->commonwhere);
		//查询销售机会详细
		$chance_info = $model->table('chance')->where($where)->find();
		if (empty($chance_info)){
			showDialog(Language::get('bp_chance_recorderror'),'','error');
		}
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["c_title"],"require"=>"true","message"=>Language::get('bp_chance_add_subjectnull'));
			$validate_arr[] = array("input"=>$_POST["c_cid"],"require"=>"true","message"=>Language::get('bp_chance_add_customernull'));
			$validate_arr[] = array("input"=>$_POST["c_discoverydate"],"require"=>"true","message"=>Language::get('bp_chance_add_discoverydatenull'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>$_POST["c_cid"],'cc_insea'=>0))->find();
			if(!empty($customer_info) && !empty($_POST['c_contacts']) && $customer_info['cc_type'] == 1){
				//查询联系人信息
				$contacts_info = $model->table('company_contact')->where(array('ccc_isdel'=>'0','cc_id'=>$customer_info['cc_id']))->find();
			}			
			$update_arr = array();
			$update_arr['cha_title'] = $_POST['c_title'];
			$update_arr['cha_contactid'] = $contacts_info['ccc_id'];
			$update_arr['cha_contactname'] = $contacts_info['ccc_name'];
			$update_arr['cha_type'] = intval($_POST['c_type']);			
			$update_arr['cha_discoverydate'] = ($t=$_POST['c_discoverydate'])?strtotime($t):0;
			$update_arr['cha_source'] = intval($_POST['c_source']);
			$update_arr['cha_needtext'] = $_POST['c_needtext'];
			$update_arr['cha_predictdate'] = ($t=$_POST['c_predictdate'])?strtotime($t):0;
			$update_arr['cha_predictmoney'] = $_POST['c_predictmoney']?$_POST['c_predictmoney']:0;
			$update_arr['cha_stage'] = intval($_POST['c_stage']);
			$update_arr['cha_probability'] = intval($_POST['c_probability']);
			$update_arr['cha_state'] = intval($_POST['c_state']);
			$is_progress = false;
			if ($update_arr['cha_stage'] != $chance_info['cha_stage'] || $update_arr['cha_state']!= $chance_info['cha_state']){
				$is_progress = true;
				$update_arr['cha_stageremark'] = $_POST['c_stageremark'];
			}
			if ($is_progress){
				$update_arr['cha_stagechangedate'] = time();
			}
			$rs = $model->table('chance')->where(array('cha_id'=>$cid))->update($update_arr);
			if ($rs){
				if ($is_progress){
					//记录推进日志
					$insertlog_arr = array();
					$insertlog_arr['cp_chanceid'] = $chance_info['cha_id'];
					$insertlog_arr['cp_adddate'] = time();
					$insertlog_arr['cp_state'] = $update_arr['cha_state'];
					$insertlog_arr['cp_stage'] = $update_arr['cha_stage'];
					$insertlog_arr['cp_operatoruid'] = $chance_info['cha_userid'];
					$insertlog_arr['cp_operatoruname'] = $chance_info['cha_username'];
					$insertlog_arr['cp_remark'] = $_POST['c_stageremark'];
					$model->table('chanceprogress')->insert($insertlog_arr);
				}
				showDialog(Language::get('bp_chance_edit_succ'),'index.php?act=chance&op=chancelist','succ');
			}else {
				showDialog(Language::get('bp_chance_edit_fail'),'','error');
			}
		}else{
			//查询会员信息
			$customer_info = $model->table('customer')->where(array('cc_id'=>$chance_info["cha_customerid"],'cc_insea'=>0))->find();
			if(empty($customer_info)){
				showDialog(Language::get('bp_chance_add_customererror'),'','error');
			}
			$chance_info['stagestopdays'] = floor((time() - $chance_info['cha_stagechangedate'])/86400);
			//查询推进记录
			$progress_list = $model->table('chanceprogress')->where(array('cp_chanceid'=>$chance_info['cha_id']))->order('cp_id asc')->select();
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			Tpl::output('c_info',$chance_info);
			Tpl::output('customer_info',$customer_info);
			Tpl::output('progress_list',$progress_list);
			//左侧菜单
			$this->setleftmenu('chancelist');
			Tpl::showpage('chanceadd');
		}
	}
	/*
	 * 删除销售机会进回收站
	 */
	public function chancedelOp(){
		$cid = $_GET['cid'];
		if (empty($cid)){
			$cid = $_POST['cid'];
		}
		if (empty($cid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		//查询销售机会详细
		$model = Model();
		$where = array();
		if (is_array($cid)){
			$where['cha_id'] = array('in',$cid);
		}else {
			$where['cha_id'] = $cid;
		}
		$where['cha_istrash'] = 0;
		$where = array_merge($where,$this->commonwhere);
		$rs = $model->table('chance')->where($where)->update(array('cha_istrash'=>1));
		if ($rs){
			showDialog(Language::get('bp_common_del_succ'),'index.php?act=chance&op=chancelist','succ');
		}else {
			showDialog(Language::get('bp_common_del_fail'),'','error');
		}
	}
	/**
	 * 机会查看
	 */
	public function chanceviewOp(){
		$cid = $_GET['cid'];
		if ($cid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		//查询销售机会详细
		$where = array();
		$where['cha_id'] = $cid;
		$where = array_merge($where,$this->commonwhere);
		$chance_info = $model->table('chance,customer')->join('left')->on('chance.cha_customerid=customer.cc_id')->where($where)->find();
		if (empty($chance_info)){
			showDialog(Language::get('bp_chance_recorderror'),'','error');
		}
		if (empty($chance_info['cc_id']) || $chance_info['cc_isdel'] == 1){
			$chance_info['cc_statetext'] = Language::get('bp_openparen').Language::get('bp_chance_customerdeleted').Language::get('bp_closeparen');
		}
		$chance_info['stagestopdays'] = floor((time() - $chance_info['cha_stagechangedate'])/86400);
		//查询推进记录
		$progress_list = $model->table('chanceprogress')->where(array('cp_chanceid'=>$chance_info['cha_id']))->order('cp_id asc')->select();
		//查询针对该销售机会的日程安排
		$schedule_list = $model->table('schedule')->where(array('cs_chanceid'=>$chance_info['cha_id']))->order('cs_id desc')->select();
		Tpl::output('schedule_list',$schedule_list);
		//调取该会员的待办任务
		$mission_list = $model->field('mission.*,user.user_truename')->table('mission,user')->on('mission.cm_addstaff=user.user_id')->where(array('cm_chanceid'=>$chance_info['cha_id']))->order('mission.cm_addtime desc')->select();
		Tpl::output('mission_list',$mission_list);
		//调取针对该会员的行动历史
		$act_history_list = $model->table('customer_action')->where(array('cca_chanceid'=>$chance_info['cha_id']))->order('cca_id desc')->select();
		Tpl::output('act_history_list',$act_history_list);
		
		//查询会员需求
		$reqimportant_arr = array(1=>Language::get('bp_chance_requirement_important1'),2=>Language::get('bp_chance_requirement_important2'),3=>Language::get('bp_chance_requirement_important3'),4=>Language::get('bp_chance_requirement_important4'));
		$requirement_list = $model->table('requirement')->where(array('req_chanceid'=>$chance_info['cha_id']))->order('req_id desc')->select();
		//获得所有查询共有条件
		/*if(isset($this->commonwhere['cha_departmentid'])){
			foreach ((array)$requirement_list as $k=>$v){
				if (in_array($v['req_departmentid'],$this->commonwhere['cha_departmentid'][1])){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$requirement_list[$k] = $v;
			}
		}else{
			foreach ((array)$requirement_list as $k=>$v){
				if ($v['req_userid'] == $this->commonwhere['cha_userid']){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$requirement_list[$k] = $v;
			}
		}*/
		Tpl::output('requirement_list',$requirement_list);
		Tpl::output('reqimportant_arr',$reqimportant_arr);
		
		
		//查询解决方案
		$solution_list = $model->table('solution')->where(array('sol_chanceid'=>$chance_info['cha_id']))->order('sol_id desc')->select();
		/*if(isset($this->commonwhere['cha_departmentid'])){
			foreach ((array)$solution_list as $k=>$v){
				if (in_array($v['sol_departmentid'],$this->commonwhere['cha_departmentid'][1])){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$solution_list[$k] = $v;
			}
		}else{
			foreach ((array)$solution_list as $k=>$v){
				if ($v['sol_userid'] == $this->commonwhere['cha_userid']){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$solution_list[$k] = $v;
			}
		}*/
		Tpl::output('solution_list',$solution_list);
		
		
		//查询竞争对手
		$competitor_list = $model->table('competitor')->where(array('cpr_chanceid'=>$chance_info['cha_id']))->order('cpr_id desc')->select();
		/*if(isset($this->commonwhere['cha_departmentid'])){
			foreach ((array)$competitor_list as $k=>$v){
				if (in_array($v['cpr_departmentid'],$this->commonwhere['cha_departmentid'][1])){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$competitor_list[$k] = $v;
			}
		}else{
			foreach ((array)$competitor_list as $k=>$v){
				if ($v['cpr_userid'] == $this->commonwhere['cha_userid']){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$competitor_list[$k] = $v;
			}
		}*/
		Tpl::output('competitor_list',$competitor_list);
		//查询报价单
		$quotedprice_list = $model->table('quotedprice')->where(array('qp_chanceid'=>$chance_info['cha_id']))->order('qp_id desc')->select();
		/*if(isset($this->commonwhere['cha_departmentid'])){
			foreach ((array)$quotedprice_list as $k=>$v){
				if (in_array($v['qp_departmentid'],$this->commonwhere['cha_departmentid'][1])){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$quotedprice_list[$k] = $v;
			}
		}else{
			foreach ((array)$quotedprice_list as $k=>$v){
				if ($v['qp_userid'] == $this->commonwhere['cha_userid']){
					$v['able_edit'] = true;
				}else {
					$v['able_edit'] = false;
				}
				$quotedprice_list[$k] = $v;
			}
		}*/
		Tpl::output('quotedprice_list',$quotedprice_list);
		//从缓存中调取数据字典信息
		$dic_array = H('dictionary');
		Tpl::output('dic_array',$dic_array);
		Tpl::output('c_info',$chance_info);
		Tpl::output('progress_list',$progress_list);
		Tpl::showpage('chanceview','windowopen_layout');
	}
	/**
	 * 机会批量转移列表
	 */
	public function chancetransferOp(){
		if (!empty($_POST['type']) || !empty($_GET['type'])){
			$funname = "transfer".($_GET['type']?$_GET['type']:$_POST['type']);
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$model = Model();
			$where = array();
			$where['cha_istrash'] = '0';
			$where = array_merge($where,$this->commonwhere);
			if (!empty($_GET['search_user'])){
				$where['cha_userid'] = $_GET['search_user'];
			}
			if (!empty($_GET['search_ctype'])){
				$where['cha_type'] = intval($_GET['search_ctype']);
			}
			if (!empty($_GET['search_stage'])){
				$where['cha_stage'] = intval($_GET['search_stage']);
			}
			if (!empty($_GET['search_probability'])){
				$where['cha_probability'] = intval($_GET['search_probability']);
			}
			if (!empty($_GET['search_state'])){
				$where['cha_state'] = intval($_GET['search_state'])-1;
			}
			$stime = strtotime($_GET['search_stime']);
			$etime = strtotime($_GET['search_etime']);
			if ($stime > 0 && $etime>0){
				$where['cha_predictdate'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
			}elseif($stime > 0){
				$where['cha_predictdate'] = array('egt',"$stime");
			}elseif($etime>0){
				$where['cha_predictdate'] = array('elt',"$etime");
			}			
			$chancelist = $model->table('chance,customer')->join('left')->on('chance.cha_customerid=customer.cc_id')->where($where)->order('cha_id desc')->page(10)->select();
			
			$chancelistnew = array();
			if(!empty($chancelist)){
				//从缓存中调取数据字典信息
				$dic_array = H('dictionary');
				foreach((array)$chancelist as $k=>$v){
					$v['typetext'] = $dic_array['chancetype']['child_option'][$v['cha_type']]['cd_name'];
					$v['predictdate_text'] = ($t = $v['cha_predictdate'])?@date('Y-m-d',$v['cha_predictdate']):'';
					$v['stagetext'] = $dic_array['chancestage']['child_option'][$v['cha_stage']]['cd_name'];
					$v['probabilitytext'] = $dic_array['chanceprobability']['child_option'][$v['cha_probability']]['cd_name'];
					$v['statetext'] = $this->chancestate_arr[$v['cha_state']];
					$v['stopdays'] = floor((time() - $v['cha_stagechangedate'])/86400);
					if (empty($v['cc_id']) || $v['cc_isdel'] == 1){
						$v['cc_statetext'] = Language::get('bp_openparen').Language::get('bp_chance_customerdeleted').Language::get('bp_closeparen');
					}
					$chancelistnew[$k] = $v;
				}
			}
			Tpl::output('chancelist',$chancelistnew);
			Tpl::output('show_page',$model->showpage(2));
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
			Tpl::output('dic_array',$dic_array);
			//左侧菜单
			$this->setleftmenu('chancetransfer');
			Tpl::showpage('chancetransfer');
		}
	}
	/**
	 * 机会转移
	 */
	private function transferupdate(){
		$obj_validate = new Validate();
		$validate_arr[] = array("input"=>$_POST["cid"],"require"=>"true","message"=>Language::get('bp_chance_transfer_chancenull'));
		$validate_arr[] = array("input"=>$_POST["touser"],"require"=>"true","message"=>Language::get('bp_chance_transfer_tousernull'));
		$obj_validate -> validateparam = $validate_arr;
		$error = $obj_validate->validate();
		if ($error != ''){
			showDialog($error,'','error');
		}
		$model = Model();
		//查询员工信息
		$touserinfo = $model->table('user')->where(array('user_id'=>$_POST['touser'],'user_state'=>0))->find();
		if (empty($touserinfo)){
			showDialog(Language::get('bp_chance_transfer_tousererror'),'','error');
		}
		//查询员工拥有的会员信息
		//$customerlist = $model->table('customer')->where(array('cc_staff_id'=>$touserinfo['user_id'],'cc_isdel'=>0))->select();
		$customerlist = $model->table('customer')->where(array('cc_isdel'=>0))->select();
		if (empty($customerlist)){
			//showDialog('请确保机会所属的会员已经属该目标所有者员工所拥有','','error','',20);
			showDialog(Language::get('bp_chance_add_customererror'),'','error','',20);
		}
		$customerid_arr = array();
		foreach ((array)$customerlist as $k=>$v){
			$customerid_arr[] = $v['cc_id'];
		}
		//查询销售机会信息
		$where = array();
		$where['cha_id'] = array('in',$_POST['cid']);
		$where['cha_istrash'] = 0;
		$where['cha_customerid'] = array('in',$customerid_arr);
		$where = array_merge($where,$this->commonwhere);
		$chancelist = $model->table('chance')->where($where)->select();
		if (empty($chancelist)){
			//showDialog('您没有选择销售机会或者销售机会所属的会员不属于目标所有者拥有，导致转移失败','','error','',20);
			showDialog(Language::get('bp_chance_transfer_chanceerror'),'','error','',20);
		}
		$update_arr = array();
		$insert_arr = array();
		foreach ((array)$chancelist as $k=>$v){
			if ($touserinfo['user_id'] != $v['cha_userid']){
				$update_arr[] = $v['cha_id'];
				$inserttmp_arr = array();
				$inserttmp_arr['chal_chanceid'] = $v['cha_id'];
				$inserttmp_arr['chal_chancetitle'] = $v['cha_title'];
				$inserttmp_arr['chal_operatorid'] = $_SESSION['member_id'];
				$inserttmp_arr['chal_operatorname'] = $_SESSION['truename'];
				$inserttmp_arr['chal_addtime'] = time();
				$inserttmp_arr['chal_note'] = trim($_POST['explain']);
				//转出日志数组
				$inserttmp_from_arr['chal_userid'] = $v['cha_userid'];
				$inserttmp_from_arr['chal_username'] = $v['cha_username'];
				$inserttmp_from_arr['chal_departmentid'] = $v['cha_departmentid'];
				$inserttmp_from_arr['chal_type'] = 1;
				$insert_arr[] = array_merge($inserttmp_arr,$inserttmp_from_arr);
				//转入日志
				$inserttmp_to_arr['chal_userid'] = $touserinfo['user_id'];
				$inserttmp_to_arr['chal_username'] = $touserinfo['user_truename'];
				$inserttmp_to_arr['chal_departmentid'] = $touserinfo['user_department'];
				$inserttmp_to_arr['chal_type'] = 2;
				$insert_arr[] = array_merge($inserttmp_arr,$inserttmp_to_arr);
			}
		}
		//更新机会记录
		$rs = $model->table('chance')->where(array('cha_id'=>array('in',$update_arr)))->update(array('cha_userid'=>$touserinfo['user_id'],'cha_username'=>$touserinfo['user_truename'],'cha_departmentid'=>$touserinfo['user_department']));
		if ($rs){
			$model->table('chancelog')->insertAll($insert_arr);
			//会员需求转移
			$model->table('requirement')->where(array('req_chanceid'=>array('in',$update_arr)))->update(array('req_userid'=>$touserinfo['user_id'],'req_username'=>$touserinfo['user_truename'],'req_departmentid'=>$touserinfo['user_department']));
			//解决方案转移
			$model->table('solution')->where(array('sol_chanceid'=>array('in',$update_arr)))->update(array('sol_userid'=>$touserinfo['user_id'],'sol_username'=>$touserinfo['user_truename'],'sol_departmentid'=>$touserinfo['user_department']));
			//报价管理转移
			$model->table('quotedprice')->where(array('qp_chanceid'=>array('in',$update_arr)))->update(array('qp_userid'=>$touserinfo['user_id'],'qp_username'=>$touserinfo['user_truename'],'qp_departmentid'=>$touserinfo['user_department']));
			//竞争对手转移
			$model->table('competitor')->where(array('cpr_chanceid'=>array('in',$update_arr)))->update(array('cpr_userid'=>$touserinfo['user_id'],'cpr_username'=>$touserinfo['user_truename'],'cpr_departmentid'=>$touserinfo['user_department']));
			showDialog(Language::get('bp_chance_transfer_succ'),'index.php?act=chance&op=chancetransfer','succ');
		}else {
			showDialog(Language::get('bp_chance_transfer_fail'),'','error');
		}
	}
	/**
	 * 机会批量转移日志
	 */
	private function transferlog(){
		$model = Model();
		$where = array();
		//查询岗位信息
		$jobpost_info = $model->table('jobpost')->where(array('jp_id'=>$_SESSION['jp_id']))->find();
		//获得所有查询共有条件
		if($jobpost_info['jp_isleader'] == 1 || $_SESSION['member_id'] == 1){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			$d_idarr = array();
			//从缓存查询子部门
			$d_info = $tree_arr[$_SESSION['dp_id']];
			if (!empty($tree_arr[$_SESSION['dp_id']]['son'])){
				$d_idarr = explode(',',$tree_arr[$_SESSION['dp_id']]['son']);
			}
			$d_idarr[] = $_SESSION['dp_id'];
			$this->commonwhere['chal_departmentid'] = array('in',$d_idarr);
		}else{
			$this->commonwhere['chal_userid'] = $_SESSION['member_id'];
		}
		if (!empty($_GET['search_ctitle'])){
			$where['chal_chancetitle'] = array('like',"%{$_GET['search_ctitle']}%");
		}
		$stime = strtotime($_GET['search_stime']);
		$etime = strtotime($_GET['search_etime']);
		if ($stime > 0 && $etime>0){
			$where['chal_addtime'] = array(array('gt',"$stime"),array('lt',"$etime"),'and');
		}elseif($stime > 0){
			$where['chal_addtime'] = array('gt',"$stime");
		}elseif($etime>0){
			$where['chal_addtime'] = array('lt',"$etime");
		}
		$chanceloglist = $model->table('chancelog')->where($where)->order('chal_id desc')->page(10)->select();
		$chanceloglist_new = array();
		if (!empty($chanceloglist)){
			$tree_arr = ($t = F('department')) ? $t : H('department',true,'file');
			foreach ((array)$chanceloglist as $k=>$v){
				switch ($v['chal_type']){
					case 1:
						$v['operatortext'] = Language::get('bp_chance_transfer_explain_1').$tree_arr[$v['chal_departmentid']]['d_name'].Language::get('bp_chance_transfer_explain_2').$v['chal_username'].Language::get('bp_chance_transfer_explain_3');
						break;
					case 2:
						$v['operatortext'] = Language::get('bp_chance_transfer_explain_4').$tree_arr[$v['chal_departmentid']]['d_name'].Language::get('bp_chance_transfer_explain_5').$v['chal_username'].Language::get('bp_chance_transfer_explain_6');
						break;
				}
				$chanceloglist_new[$k] = $v;
			}
		}
		Tpl::output('chanceloglist',$chanceloglist_new);
		Tpl::output('show_page',$model->showpage(2));
		//左侧菜单
		if(trim($_GET['from']) == 'lm'){
			setlogleftmenu('chancetransferlog');
		}else{
			$this->setleftmenu('chancetransferlog');
		}
		Tpl::showpage('chancetransferlog');
	}
	/**
	 * 机会漏斗
	 */
	public function chancefillerOp(){
		if (!empty($_POST['type']) || !empty($_GET['type'])){
			$funname = "filler".($_GET['type']?$_GET['type']:$_POST['type']);
			if (method_exists($this,$funname)){
				$this->$funname();
			}
		}else{
			$model = Model();
			$where = array();
			$where['cha_state'] = '0';
			$where['cha_istrash'] = '0';
			$where = array_merge($where,$this->commonwhere);
			$fillerlist = $model->table('chance')->field('cha_stage,count(*) as cnum,sum(cha_predictmoney) as pmoneysum')->where($where)->group('cha_stage')->order('cha_stage asc')->select();
			//从缓存中调取数据字典信息
			$dic_array = H('dictionary');
				
			if (!empty($fillerlist)){
				$cnum_amount = 0;
				$pmoneysum_amount = 0;
				foreach ((array)$fillerlist as $k=>$v){
					$fillerlistnew[$v['cha_stage']] = $v;
					$cnum_amount += $v['cnum'];
					$pmoneysum_amount += $v['pmoneysum'];
					if (in_array($v['cha_stage'],array_keys($dic_array['chancestage']['child_option']))){
						$tmp_cnum += $v['cnum'];
						$tmp_pmoneysum += $v['pmoneysum'];
					}
				}
				$show_pmoneysum = true;
				if ($tmp_pmoneysum <= 0){//如果总金额小于等于0，则不显示统计图表
					$show_pmoneysum = false;
				}
				$show_cnum = true;
				if ($tmp_cnum <= 0){//如果总数小于等于0，则不显示统计图表
					$show_cnum = false;
				}
				$cnumfiller_data = array();
				$pmoneysumfiller_data = array();
				$cnumfiller_data[] = array("displayvalue"=>Language::get('bp_home_sale_chance'),"label"=>Language::get('bp_home_sale_chance'),"value"=>$cnum_amount);
				$pmoneysumfiller_data[] = array("displayvalue"=>Language::get('bp_home_sale_chance'),"label"=>Language::get('bp_home_sale_chance'),"value"=>$pmoneysum_amount);
				foreach ((array)$dic_array['chancestage']['child_option'] as $k=>$v){
					$cnum_rate = $cnum_amount>0?round($tmp_cnum/$cnum_amount,4)*100:0;
					$pmoneysum_rate = $pmoneysum_amount>0?round($tmp_pmoneysum/$pmoneysum_amount,4)*100:0;
					$cnumfiller_data[] = array("displayvalue"=>$v['cd_name'].','.$tmp_cnum,"label"=>$v['cd_name'].",$cnum_rate%","value"=>$tmp_cnum);
					$pmoneysumfiller_data[] = array("displayvalue"=>$v['cd_name'].','.ncPriceFormat($tmp_pmoneysum),"label"=>$v['cd_name'].",$pmoneysum_rate%","value"=>ncPriceFormat($tmp_pmoneysum));
					if (!empty($fillerlistnew[$v['cd_id']])){
						$tmp_cnum = $tmp_cnum - $fillerlistnew[$v['cd_id']]['cnum'];
						$tmp_pmoneysum = $tmp_pmoneysum - $fillerlistnew[$v['cd_id']]['pmoneysum'];
					}
				}
				$cnumfiller_chart = array(
					"showtooltipshadow"=>"1",
			    	"showborder"=>"0",
			    	"issliced"=>"1",
			    	"numbersuffix"=>"%",
			    	"caption"=>Language::get('bp_chance_filler_caption1 '),
			    	"decimals"=>"0",
			    	"captionpadding"=>"30",
			    	"animation"=>"0",
			    	"manageresize"=>"1");
				$pmoneysumfiller_chart = array(
					"showtooltipshadow"=>"1",
			    	"showborder"=>"0",
			    	"issliced"=>"1",
			    	"numbersuffix"=>"%",
			    	"caption"=>Language::get('bp_chance_filler_caption2 '),
			    	"decimals"=>"0",
			    	"captionpadding"=>"30",
			    	"animation"=>"0",
			    	"manageresize"=>"1");
				$cnumfiller = json_encode(array('chart'=>$cnumfiller_chart,'data'=>$cnumfiller_data));
				$pmoneysumfiller = json_encode(array('chart'=>$pmoneysumfiller_chart,'data'=>$pmoneysumfiller_data));
			}
			Tpl::output('cnumfiller',$cnumfiller);
			Tpl::output('pmoneysumfiller',$pmoneysumfiller);
			Tpl::output('dic_array',$dic_array);
			Tpl::output('show_pmoneysum',$show_pmoneysum);
			Tpl::output('show_cnum',$show_cnum);
			//左侧菜单
			$this->setleftmenu('chancefiller');
			Tpl::showpage('chancefiller');
		}
	}
	/**
	 * 查询销售漏斗对应的销售机会列表
	 */
	private function fillerlist(){
		$dic_array = H('dictionary');
		$model = Model();
		$where = array();
		$where['cha_state'] = '0';
		$where['cha_istrash'] = '0';
		$where = array_merge($where,$this->commonwhere);
		if (!empty($_GET['stage'])){
			$where['cha_stage'] = intval($_GET['stage']);
		}
		$chancelist = $model->table('chance,customer')->join('left')->on('chance.cha_customerid=customer.cc_id')->where($where)->order('cha_id desc')->page(10)->select();
		$chancelistnew = array();
		$predmoney_pagecount = 0;
		if(!empty($chancelist)){
			//从缓存中调取数据字典信息
			foreach((array)$chancelist as $k=>$v){
				$v['typetext'] = $dic_array['chancetype']['child_option'][$v['cha_type']]['cd_name'];
				$v['predictdate_text'] = ($t = $v['cha_predictdate'])?@date('Y-m-d',$v['cha_predictdate']):'';
				$v['stagetext'] = $dic_array['chancestage']['child_option'][$v['cha_stage']]['cd_name'];
				$v['probabilitytext'] = $dic_array['chanceprobability']['child_option'][$v['cha_probability']]['cd_name'];
				$v['statetext'] = $this->chancestate_arr[$v['cha_state']];
				$v['stopdays'] = floor((time() - $v['cha_stagechangedate'])/86400);
				if (empty($v['cc_id']) || $v['cc_isdel'] == 1){
					$v['cc_statetext'] = Language::get('bp_openparen').Language::get('bp_chance_customerdeleted').Language::get('bp_closeparen');
				}
				$predmoney_pagecount += round($v['cha_predictmoney'],2);
				$chancelistnew[$k] = $v;
			}
		}
		$predmoney_count = $model->table('chance')->field('sum(cha_predictmoney) as moneysum')->where($where)->find();
		
		Tpl::output('predmoney_pagecount',ncPriceFormat($predmoney_pagecount));
		Tpl::output('predmoney_count',$predmoney_count['moneysum']);
		
		Tpl::output('chancelist',$chancelistnew);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('dic_array',$dic_array);
		Tpl::showpage('chancefiller_list','null_layout');
	}
	/**
	 * 销售机会回收站恢复数据功能
	 */
	public function chancetrashreturnOp(){
		$cid = $_GET['cid'];
		if (empty($cid)){
			$cid = $_POST['cid'];
		}
		if (empty($cid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		//查询销售机会详细
		$model = Model();
		$where = array();
		if (is_array($cid)){
			$where['cha_id'] = array('in',$cid);
		}else {
			$where['cha_id'] = $cid;
		}
		$rs = $model->table('chance')->where($where)->update(array('cha_istrash'=>0));
		if ($rs){
			showDialog(Language::get('bp_chance_returnsucc'),'index.php?act=chance&op=chancelist&filter=trash','succ');
		}else {
			showDialog(Language::get('bp_chance_returnfail'),'','error');
		}
	}
	/*
	 * 左侧菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		//两级菜单
		$arr[0] = array('menu_name'=>Language::get('bp_home_sale_chance'),	'linktype'=>'2');
		$arr[0]['submenu'][0] = array('menu_key'=>'chancelist','menu_name'=>Language::get('bp_home_chance_manage'),'menu_act'=>'chance','menu_op'=>'chancelist','linktype'=>'0');
		$arr[0]['submenu'][1] = array('menu_key'=>'chancetransfer','menu_name'=>Language::get('bp_home_chance_transfer'),'menu_act'=>'chance','menu_op'=>'chancetransfer','linktype'=>'0');
		$arr[0]['submenu'][2] = array('menu_key'=>'chancetransferlog','menu_name'=>Language::get('bp_home_chance_transfer_log'),'menu_act'=>'chance','menu_op'=>'chancetransfer','menu_url'=>'index.php?act=chance&op=chancetransfer&type=log','linktype'=>'0');
		$arr[0]['submenu'][3] = array('menu_key'=>'chancefiller','menu_name'=>Language::get('bp_home_sale_filler'),'menu_act'=>'chance','menu_op'=>'chancefiller','linktype'=>'0');
		
		$arr[1] = array('menu_name'=>Language::get('bp_home_sale_track'),	'linktype'=>'2');
		$arr[1]['submenu'][0] = array('menu_key'=>'requirementlist','menu_name'=>Language::get('bp_home_member_need'),'menu_act'=>'requirement','menu_op'=>'requirementlist','linktype'=>'0');
		$arr[1]['submenu'][1] = array('menu_key'=>'solutionlist','menu_name'=>Language::get('bp_home_solution'),'menu_act'=>'solution','menu_op'=>'solutionlist','linktype'=>'0');
		$arr[1]['submenu'][2] = array('menu_key'=>'quotedpricelist','menu_name'=>Language::get('bp_home_quote'),'menu_act'=>'quotedprice','menu_op'=>'quotedpricelist','linktype'=>'0');
		$arr[1]['submenu'][3] = array('menu_key'=>'competitorlist','menu_name'=>Language::get('bp_home_competitor'),'menu_act'=>'competitor','menu_op'=>'competitorlist','linktype'=>'0');
		
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}