<?php
/**
 * 清理缓存
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class cacheControl extends BaseHomeControl{
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('cache');
	}
	/**
	 * 清理缓存
	 */
	public function clearOp(){
		if (chksubmit()){
			if(empty($_POST['cache']) && $_POST['ck_all']!=1){
				showDialog(Language::get('bp_cache_chooseitemnull'),"index.php?act=cache&op=clear","error");
			}
			//清理所有缓存
			if($_POST['ck_all']==1){
				H('setting',true);
				H('department',true);
				H('user',true);
				H('table',true);
				H('dictionary',true);
				H('product',true);
				H('customer',true);
				H('address',true);
				H('shop',true);
				delCacheFile('fields');
		        showDialog(Language::get('bp_common_save_succ'),"index.php?act=cache&op=clear","succ");
			}
			//清理基本缓存
			if (@in_array('setting',$_POST['cache'])){
				H('setting',true);
			}
			//清理部门缓存
			if (@in_array('department',$_POST['cache'])){
				H('department',true);
			}
			//清理员工缓存
			if (@in_array('user',$_POST['cache'])){
				H('user',true);
			}
			//清理TABLE缓存
			if (@in_array('table',$_POST['cache'])){
		        delCacheFile('fields');
			}
			//清理数据字典缓存
			if (@in_array('dictionary',$_POST['cache'])){
				H('dictionary',true);
			}
			//商品缓存
			if (@in_array('product',$_POST['cache'])){
				H('product',true);
			}
			//会员缓存
			if (@in_array('customer',$_POST['cache'])){
				H('customer',true);
			}
			//收货地址缓存
			if (@in_array('address',$_POST['cache'])){
				H('address',true);
			}
			//店铺信息缓存
			if (@in_array('shop',$_POST['cache'])){
				H('shop',true);
			}
			showDialog(Language::get('bp_common_save_succ'),"index.php?act=cache&op=clear","succ");
		}
		/**
		 * 左侧菜单
		 */
		$this->setleftmenu('cache_clear');
		/**
		 * 模板输出
		 */
		Tpl::showpage('cacheclear');
	}
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_clear_cache'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'cache_clear','menu_name'=>Language::get('bp_home_clear_cache'),	'menu_act'=>'cache','menu_op'=>'clear');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}