<?php
/**
 * 营销活动管理
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
defined('InBizpower') or exit('Access Invalid!');
class activeControl extends BaseHomeControl{
	private $commonwhere= array();
	public function __construct(){
		parent::__construct();
		//读取语言包
		Language::read('active');
	}
	/**
	 * 短信活动管理
	 */
	public function activesmsOp(){
		$op_arr = array('list','add','edit');
		if (!$_SESSION['shop_id'] && (in_array($_GET['type'],$op_arr) || !$_GET['type'])){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach($shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
		}
		if (!empty($_GET['type'])){
			$funname = "active_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname('sms');
			}
		}else{
			$this->active_list('sms');
		}
	}
	/**
	 * 营销列表
	 */
	public function active_list($rtype){
		$model = Model();
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		if ($_SESSION['shop_id']){//如果员工负责某店铺
			$where['act_shopid'] = $_SESSION['shop_id'];
		} elseif (intval($_GET['search_shop']) > 0){
			$where['act_shopid'] = intval($_GET['search_shop']);
		} elseif ($_GET['search_shop'] == 'all') {
		} else {
			//无所属店铺则找出默认店铺并进行优先显示
			$default_shop = 0;
			if(!empty($shop_list)){
				foreach ($shop_list as $k=>$v){
					if($v['shop_default'] == 1){
						$default_shop = $v['shop_id'];
						break;
					}
				}
				if ($default_shop > 0){
					$where['act_shopid'] = intval($default_shop);
				}
				$_GET['search_shop'] = $default_shop;
			}
		}
		$where['act_type'] = $rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
		if ($_GET['search_name']){
			$where['act_name'] = array('like',"%{$_GET['search_name']}%");
		}
		$act_list = $model->table('active')->where($where)->order('act_id desc')->page(20)->select();
		Tpl::output('act_list',$act_list);
		Tpl::output('show_page',$model->showpage(2));
		Tpl::output('pagetype',$rtype);
		$this->setleftmenu('active'.$rtype);
		Tpl::showpage('active_list');
	}
	/**
	 * 新增活动
	 */
	public function active_add($rtype){
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["act_name"],"require"=>"true","message"=>Language::get('bp_active_add_namenull'));
			$validate_arr[] = array("input"=>$_POST["shopsel"],"require"=>"true","message"=>Language::get('bp_active_add_shopnull'));
			$validate_arr[] = array("input"=>$_POST["act_stime"],"require"=>"true","message"=>Language::get('bp_active_add_stimenull'));
			$validate_arr[] = array("input"=>$_POST["act_etime"],"require"=>"true","message"=>Language::get('bp_active_add_etimenull'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//-----------------按照条件查询会员数-----------------
			$cus_idarr = $this->statcus($_POST);
			$insert_arr = array();
			$insert_arr['act_shopid'] = $_POST['shopsel'];
			$insert_arr['act_name'] = $_POST['act_name'];
			$insert_arr['act_type'] = $rtype;
			$insert_arr['act_stime'] = $_POST['act_stime']?strtotime($_POST['act_stime']):0;
			$insert_arr['act_etime'] = $_POST['act_etime']?strtotime($_POST['act_etime']):0;
			$insert_arr['act_describe'] = $_POST['act_describe'];
			$insert_arr['act_cost'] = $_POST['act_cost'];
			if ($_POST['filter'] == 'group'){
				$insert_arr['act_cusgroupid'] = intval($_POST['cusgroup']);
				//查询会员自定义分组
				$cgroup_info = $model->table('customergroup')->where(array('cgroup_id'=>$insert_arr['act_cusgroupid']))->find();
				$insert_arr['act_cusnum'] = intval($cgroup_info['cgroup_cusnum']);
				$insert_arr['act_cusid'] = $cgroup_info['cgroup_cusid'];				
			}else {
				$cus_idarr = $this->statcus($_POST);
				$insert_arr['act_orderrule'] = empty($_POST['orderrule'])?'':serialize($_POST['orderrule']);
				$insert_arr['act_cusrule'] = empty($_POST['cusrule'])?'':serialize($_POST['cusrule']);
				$insert_arr['act_arearule'] = empty($_POST['arearule'])?'':serialize($_POST['arearule']);
				$insert_arr['act_cusnum'] = count($cus_idarr);
				$insert_arr['act_cusid'] = !empty($cus_idarr)?serialize($cus_idarr):'';
			}
			if ($_POST['choosetpl'] == 'template'){
				$insert_arr['act_tplid'] = $_POST['templatesel'];
			}else {
				$insert_arr['act_tplid'] = 0;
			}
			$insert_arr['act_content'] = $_POST['act_content'];
			$insert_arr['act_addtime'] = time();
			$insert_arr['act_adduserid'] = $_SESSION['member_id'];
			$insert_arr['act_state'] = 0;
			$rs = $model->table('active')->insert($insert_arr);
			if ($rs){
				showDialog(Language::get('bp_active_add_succ'),'index.php?act=active&op=active'.$rtype,'succ');
			}else{
				showDialog(Language::get('bp_active_add_fail'),'','error');
			}
		}else{
			//从缓存中调取数据字典信息
			$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
			Tpl::output('dic_array',$dic_array);
			//查询模板
			$tpl_list = $model->table('template')->where(array('tpl_type'=>$rtype,'tpl_state'=>1))->select();
			Tpl::output('tpl_list',$tpl_list);
			//左侧菜单
			$rtype?$rtype:'sms';//活动类型 'sms'为短信,'email'为邮件
			$this->setleftmenu('active'.$rtype);
			Tpl::output('pagetype',$rtype);
			Tpl::showpage('active_add');
		}
	}
	/**
	 * 刷新活动
	 */
	public function active_refresh($rtype){
		$actid = $_GET['actid'];
		if ($actid <= 0){
			echo json_encode(array('done'=>false)); die;
		}
		//查询活动
		$model = Model();
		$act_info = $model->table('active')->where(array('act_id'=>$actid,'act_state'=>0))->find();//未完成时可更新
		if (empty($act_info)){
			echo json_encode(array('done'=>false)); die;
		}
		$update_arr = array();
		if($act_info['act_cusgroupid']){
			//查询会员自定义分组
			$cgroup_info = $model->table('customergroup')->where(array('cgroup_id'=>$act_info['act_cusgroupid']))->find();
			$update_arr['act_cusnum'] = intval($cgroup_info['cgroup_cusnum']);
			$update_arr['act_cusid'] = $cgroup_info['cgroup_cusid'];
		}else {
			$act_info['orderrule'] = empty($act_info['act_orderrule'])?array():unserialize($act_info['act_orderrule']);
			$act_info['cusrule'] = empty($act_info['act_cusrule'])?array():unserialize($act_info['act_cusrule']);
			$act_info['arearule'] = empty($act_info['act_arearule'])?array('scope'=>'all','area'=>array()):unserialize($act_info['act_arearule']);
			$act_info['shopsel'] = $act_info['act_shopid'];
			$cus_idarr = $this->statcus($act_info);
			$update_arr['act_cusnum'] = count($cus_idarr);
			$update_arr['act_cusid'] = !empty($cus_idarr)?serialize($cus_idarr):'';
		}
		$rs = $model->table('active')->where(array('act_id'=>$actid))->update($update_arr);
		if ($rs){
			echo json_encode(array('done'=>true,'num'=>$update_arr['act_cusnum'])); die;
		}else{
			echo json_encode(array('done'=>false)); die;
		}
	}
	/**
	 * 统计符合条件的会员信息
	 */
	private function statcus($conditions){
		$model = Model();
		$stat_where = array();
		$stat_where['shop_id'] = $conditions['shopsel'];
		//会员规则
		if (!empty($conditions['cusrule']['grade'])){
			$stat_where['cc_grade'] = $conditions['cusrule']['grade'];
		}
		if (!empty($conditions['cusrule']['credit'])){
			$stat_where['cc_credit_degree'] = $conditions['cusrule']['credit'];
		}
		if (!empty($conditions['cusrule']['class'])){
			$stat_where['cc_class'] = $conditions['cusrule']['class'];
		}
		if (!empty($conditions['cusrule']['relationship'])){
			$stat_where['cc_relationship'] = $conditions['cusrule']['relationship'];
		}
		if (!empty($conditions['cusrule']['from'])){
			$stat_where['cc_from'] = $conditions['cusrule']['from'];
		}
		$stime = $conditions['cusrule']['birthday']['val'][0]?strtotime($conditions['cusrule']['birthday']['val'][0]):0;
		$etime = $conditions['cusrule']['birthday']['val'][1]?strtotime($conditions['cusrule']['birthday']['val'][1]):0;
		if ($stime > 0 && $etime>0){
			$where['cpi_birthday'] = array(array('egt',"$stime"),array('elt',"$etime"),'and');
		}elseif($stime > 0){
			$where['cpi_birthday'] = array('egt',"$stime");
		}elseif($etime>0){
			$where['cpi_birthday'] = array('elt',"$etime");
		}
		//地区规则
		if ($conditions['arearule']['scope'] == 'part' && !empty($conditions['arearule']['area'])){
			$stat_where['cc_province'] = array('in',$conditions['arearule']['area']);
		}
		$cus_list = array();
		$cus_list = $model->table('customer,personal_info')->join('left')->on('customer.cc_id = personal_info.cc_id')->field('customer.cc_id')->where($stat_where)->select();
		$cus_idarr = array();
		if (!empty($cus_list)){
			foreach ($cus_list as $k=>$v){
				$cus_idarr[] = $v['cc_id'];
			}
		}
		unset($stat_where);//记得清除哦
		
		//订单规则
		$field = 'cc_id';
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['totality']['operator']) && !empty($conditions['orderrule']['totality']['val'])){//订单总数
			$field = ' ,count(*) as totality';
		}
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['amount']['operator']) && !empty($conditions['orderrule']['amount']['val'])){//订单总金额
			$field .= ' ,sum(co_final_price) as amount';
		}
		$order_list = $model->table('orders')->field($field)->where(array('shop_id'=> $conditions['shopsel']))->group('cc_id')->select();
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['totality']['operator']) && !empty($conditions['orderrule']['totality']['val'])){//订单总数
			$ordercusid_totality = array();
			if (!empty($order_list)){
				foreach ($order_list as $k=>$v){
					switch ($conditions['orderrule']['totality']['operator']){
						case 'eq':
							if ($v['totality'] == $conditions['orderrule']['totality']['val'][0]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
						case 'elt':
							if ($v['totality'] <= $conditions['orderrule']['totality']['val'][0]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
						case 'egt':
							if ($v['totality'] >= $conditions['orderrule']['totality']['val'][0]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
						case 'between':
							if ($v['totality'] >= $conditions['orderrule']['totality']['val'][0] && $v['totality'] <= $conditions['orderrule']['totality']['val'][1]){
								$ordercusid_totality[] = $v['cc_id'];
							}
							break;
					}
				}
			}
			if (!empty($cus_idarr)){
				$noorder_cus = array();
				if ($conditions['orderrule']['totality']['val'][0] == 0){//当最小值为0时，订单信息不存在，但是仍符合条件
					$noorder_cus = array_flip($cus_idarr);
					foreach ((array)$order_list as $k=>$v){
						if (isset($noorder_cus[$v['cc_id']])){
							unset($noorder_cus[$v['cc_id']]);
						}
					}
					if (!empty($noorder_cus)){
						$noorder_cus = array_flip($noorder_cus);
					}
				}
				$cus_idarr = array_intersect($cus_idarr,$ordercusid_totality);
				if (!empty($noorder_cus)){
					$cus_idarr = array_merge($cus_idarr,$noorder_cus);
				}
			}
		}
		if (!empty($cus_idarr) && !empty($conditions['orderrule']['amount']['operator']) && !empty($conditions['orderrule']['amount']['val'])){//订单总金额
			$ordercusid_amount = array();
			if (!empty($order_list)){
				foreach ((array)$order_list as $k=>$v){
					switch ($conditions['orderrule']['amount']['operator']){
						case 'eq':
							if ($v['amount'] == $conditions['orderrule']['amount']['val'][0]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
						case 'elt':
							if ($v['amount'] <= $conditions['orderrule']['amount']['val'][0]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
						case 'egt':
							if ($v['amount'] >= $conditions['orderrule']['amount']['val'][0]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
						case 'between':
							if ($v['amount'] >= $conditions['orderrule']['amount']['val'][0] && $v['amount'] <= $conditions['orderrule']['amount']['val'][1]){
								$ordercusid_amount[] = $v['cc_id'];
							}
							break;
					}
				}
			}
			if (!empty($cus_idarr)){
				$noorder_cus = array();
				if ($conditions['orderrule']['amount']['val'][0] == 0){//当最小值为0时，订单信息不存在，但是仍符合条件
					$noorder_cus = array_flip($cus_idarr);
					foreach ((array)$order_list as $k=>$v){
						if (isset($noorder_cus[$v['cc_id']])){
							unset($noorder_cus[$v['cc_id']]);
						}
					}
					if (!empty($noorder_cus)){
						$noorder_cus = array_flip($noorder_cus);
					}
				}
				$cus_idarr = array_intersect($cus_idarr,$ordercusid_amount);
				if (!empty($noorder_cus)){
					$cus_idarr = array_merge($cus_idarr,$noorder_cus);
				}
			}
		}
		return $cus_idarr;
	} 
	/**
	 * 编辑活动
	 */
	public function active_edit($rtype){
		$actid = $_GET['actid'];
		if ($actid <= 0){
			$actid = $_POST['actid'];
		}
		if ($actid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (chksubmit()){
			$obj_validate = new Validate();
			$validate_arr[] = array("input"=>$_POST["act_name"],"require"=>"true","message"=>Language::get('bp_active_add_namenull'));
			$validate_arr[] = array("input"=>$_POST["shopsel"],"require"=>"true","message"=>Language::get('bp_active_add_shopnull'));
			$validate_arr[] = array("input"=>$_POST["act_stime"],"require"=>"true","message"=>Language::get('bp_active_add_stimenull'));
			$validate_arr[] = array("input"=>$_POST["act_etime"],"require"=>"true","message"=>Language::get('bp_active_add_etimenull'));
			$obj_validate -> validateparam = $validate_arr;
			$error = $obj_validate->validate();
			if ($error != ''){
				showDialog($error,'','error');
			}
			//-----------------按照条件查询会员数-----------------
			$cus_idarr = $this->statcus($_POST);
			$update_arr = array();
			$update_arr['act_shopid'] = $_POST['shopsel'];
			$update_arr['act_name'] = $_POST['act_name'];
			$update_arr['act_stime'] = $_POST['act_stime']?strtotime($_POST['act_stime']):0;
			$update_arr['act_etime'] = $_POST['act_etime']?strtotime($_POST['act_etime']):0;
			$update_arr['act_describe'] = $_POST['act_describe'];
			$update_arr['act_cost'] = $_POST['act_cost'];
			if ($_POST['filter'] == 'group'){
				$update_arr['act_cusgroupid'] = intval($_POST['cusgroup']);
				//查询会员自定义分组
				$cgroup_info = $model->table('customergroup')->where(array('cgroup_id'=>$update_arr['act_cusgroupid']))->find();
				$update_arr['act_cusnum'] = intval($cgroup_info['cgroup_cusnum']);
				$update_arr['act_cusid'] = $cgroup_info['cgroup_cusid'];
			}else{
				$cus_idarr = $this->statcus($_POST);
				$update_arr['act_orderrule'] = empty($_POST['orderrule'])?'':serialize($_POST['orderrule']);
				$update_arr['act_cusrule'] = empty($_POST['cusrule'])?'':serialize($_POST['cusrule']);
				$update_arr['act_arearule'] = empty($_POST['arearule'])?'':serialize($_POST['arearule']);
				$update_arr['act_cusnum'] = count($cus_idarr);
				$update_arr['act_cusid'] = !empty($cus_idarr)?serialize($cus_idarr):'';
			}
			if ($_POST['choosetpl'] == 'template'){
				$update_arr['act_tplid'] = $_POST['templatesel'];
			}else {
				$update_arr['act_tplid'] = 0;
			}
			$update_arr['act_content'] = $_POST['act_content'];
			
			$rs = $model->table('active')->where(array('act_id'=>$actid))->update($update_arr);
			if ($rs){
				showDialog(Language::get('bp_active_edit_succ'),'index.php?act=active&op=active'.$rtype,'succ');
			} else {
				showDialog(Language::get('bp_active_edit_fail'),'','error');
			}
		}else{
			//查询活动
			$act_info = $model->table('active')->where(array('act_id'=>$actid,'act_type'=>$rtype))->find();
			if (empty($act_info)){
				showDialog(Language::get('bp_active_recorderror'),'','error');
			}
			$act_info['act_orderrule_arr'] = empty($act_info['act_orderrule'])?array():unserialize($act_info['act_orderrule']);
			$act_info['act_cusrule_arr'] = empty($act_info['act_cusrule'])?array():unserialize($act_info['act_cusrule']);
			$act_info['act_arearule_arr'] = empty($act_info['act_arearule'])?array('scope'=>'all','area'=>array()):unserialize($act_info['act_arearule']);
			Tpl::output('act_info',$act_info);
			//从缓存中调取数据字典信息
			$dic_array = ($t = F('dictionary')) ? $t : H('dictionary',true,'file');
			Tpl::output('dic_array',$dic_array);
			//查询模板
			$tpl_list = $model->table('template')->where(array('tpl_type'=>$rtype,'tpl_state'=>1))->select();
			Tpl::output('tpl_list',$tpl_list);
			//左侧菜单
			Tpl::output('pagetype',$rtype);
			$this->setleftmenu('active'.$rtype);
			Tpl::showpage('active_add');
		}
	}
	/**
	 * 查询活动名称是否存在
	 */
	public function active_checkname($rtype){
		//查询分组信息
		$model = Model();
		$where = array();
		$where['act_type'] = $rtype;
		if (!empty($_GET['actshopid'])){
			$where['act_shopid'] = $_GET['actshopid'];
		}
		$where['act_name'] = $_GET['actname'];
		$act_info = $model->table('active')->where($where)->find();
		if (empty($act_info)){
			echo 'true'; die;
		}else{
			if ($act_info['act_id'] == $_GET['actid']){
				echo 'true'; die;
			} else {
				echo 'false'; die;
			}
		}
	}
	/*
	 * 删除活动
	 */
	public function active_del($rtype){
		$actid = $_GET['actid'];
		if (empty($actid)){
			$actid = $_POST['actid'];
		}
		if (empty($actid)){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		if (is_array($actid)){
			$where['act_id'] = array('in',$actid);
		}else{
			$where['act_id'] = $actid;
		}
		$rs = $model->table('active')->where($where)->delete();
		if ($rs){
			showDialog(Language::get('bp_active_del_succ'),'index.php?act=active&op=active'.$rtype,'succ');
		}else{
			showDialog(Language::get('bp_active_del_fail'),'','error');
		}
	}
	/**
	 * 发送短信
	 */
	public function active_send($rtype){
		//如果要开启发送邮件和短息功能，请删除以下提示内容
		if ($rtype == 'sms'){
			showDialog(Language::get('bp_active_list_smssendwarn'),'','notice','',10);
		}
		if ($rtype == 'email'){
			showDialog(Language::get('bp_active_list_emailsendwarn'),'','notice','',10);
		}
		$actid = intval($_GET['actid']);
		if ($actid <= 0){
			showDialog(Language::get('wrong_argument'),'','error');
		}
		$model = Model();
		$where['act_id'] = $actid;
		$where['act_savestate'] = 0;//是否已经保存在邮件发送表中：0未保存 1已保存
		$where['act_etime'] = array('gt',time());//活动还在进行中
		$act_info = $model->table('active')->where($where)->find();
		if (empty($act_info)){
			showDialog(Language::get('bp_active_recorderror'),'','error');
		}
		$act_cusidarr = $act_info['act_cusid']?unserialize($act_info['act_cusid']):array();
		if (empty($act_cusidarr)){
			showDialog(Language::get('bp_active_list_sendtousernull'),'','error');
		}
		//查询会员信息
		$cus_list = $model->table('customer,personal_info')->join('left')->on('customer.cc_id = personal_info.cc_id')->where(array('customer.cc_id'=>array('in',$act_cusidarr)))->select();
		if (empty($act_cusidarr)){
			showDialog(Language::get('bp_active_list_sendtousernull'),'','error');
		}
		//从缓存中调取店铺信息
		$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
		if(!empty($shop_list)){
			$shopname = $shop_list[$act_info['act_shopid']]['shop_name'];
		}
		$i = 0;
		foreach ((array)$cus_list as $k=>$v){
			$ischeck = false;
			if ($act_info['act_type'] == 'sms' && $v['cpi_mobilephone']){
				$ischeck = true;
			} elseif ($act_info['act_type'] == 'email' && $v['cpi_email']){
				$ischeck = true;
			}
			if ($ischeck){
				$search = array ("{membername}","{shopname}");
				$replace = array ("{$v['cc_name']}","$shopname");
				
				$infotmp = array();
				$infotmp['ad_shopid'] = $act_info['act_shopid'];
				$infotmp['ad_actid'] = $act_info['act_id'];
				$infotmp['ad_type'] = $act_info['act_type'];
				$infotmp['ad_stime'] = $act_info['act_stime'];
				$infotmp['ad_etime'] = $act_info['act_etime'];
				$infotmp['ad_sendtime'] = 0;
				$infotmp['ad_ccid'] = $v['cc_id'];
				$infotmp['ad_title'] = $act_info['act_name'];
				$infotmp['ad_content'] = @str_replace($search, $replace, $act_info['act_content']);
				$infotmp['ad_state'] = 0;
				$tmp = intval($i/100);
				$infoinsert_arr[$tmp][] = $infotmp;
				$i++;
			}
		}
		
		//每100条重新执行一次sql
		foreach ((array)$infoinsert_arr as $k=>$v){
			$model->table('activedata')->insertAll($v);
		}
		//将活动状态修改为已经保存数据
		$model->table('active')->where(array('act_id'=>$act_info['act_id']))->update(array('act_savestate'=>'1'));
		if ($act_info['act_type'] == 'sms'){
			//读取“crm_activedata”表数据发送短信
		}
		if ($act_info['act_type'] == 'email'){
			//读取“crm_activedata”表数据发送邮件
		}
		showDialog(Language::get('bp_active_list_sendsucc'),'index.php?act=active&op=active'.$act_info['act_type'],'succ');
	}
	/**
	 * 邮件活动管理
	 */
	public function activeemailOp(){
		$op_arr = array('list','add','edit');
		if (!$_SESSION['shop_id'] && (in_array($_GET['type'],$op_arr) || !$_GET['type'])){
			//从缓存中调取店铺信息
			$shop_list = ($t = F('shop')) ? $t : H('shop',true,'file');
			if(!empty($shop_list)){
				foreach((array)$shop_list as $k=>$v){
					if($v['shop_isuse'] == 0){
						unset($shop_list[$k]);
					}
				}
			}
			Tpl::output('shop_list',$shop_list);
		}
		if (!empty($_GET['type'])){
			$funname = "active_".$_GET['type'];
			if (method_exists($this,$funname)){
				$this->$funname('email');
			}
		}else{
			$this->active_list('email');
		}
	}
	
	/**
	 * 设置左菜单
	 */
	private function setleftmenu($menu_key=''){
		$arr = array();
		$arr[0] = array('menu_name'=>Language::get('bp_home_member_active'),	'menu_url'=>'#');
		$arr[0]['submenu'][0] = array('menu_key'=>'activesms','menu_name'=>Language::get('bp_home_member_sms_active'),	'menu_act'=>'active','menu_op'=>'activesms');
		$arr[0]['submenu'][1] = array('menu_key'=>'activeemail','menu_name'=>Language::get('bp_home_member_edm_active'),	'menu_act'=>'active','menu_op'=>'activeemail');
		Tpl::output('leftmenu',$arr);
		Tpl::output('menu_key',$menu_key);
	}
}