<?php
/**
 * Bizpower CRM移动端统计类接口
 *
 *
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
error_reporting(E_ALL & ~E_NOTICE);
define('InBizpower',true);

define('BasePath',dirname(__FILE__));

if(file_exists('config.php')){require('config.php');}else{exit();}
if(file_exists('model.class.php')){require('model.class.php');}else{exit();}

//总是输出UTF-8编码
header("Content-type: text/html; charset=utf-8");


class run{
	public function __construct(){
		$this->index();
	}
	private function index(){
		$func = '_'.$_GET['commend'];
		if(method_exists($this,$func)){
			$this->$func();
		}else{
			exit($this->callback('',self::ERROR_404));
		}
	}
	/**
	 * 会员数据统计
	 */
	private function _customerstat(){
		$m = M();
		$error = '';
		if(trim($_GET['type']) == '' || intval($_GET['uid']) <= 0) {
			$error='参数错误';
			$output['error'] = $error;
			$this->loadtpl('column',$output);
			exit();
		}
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			$error = '未找到用户数据';
		}else{
			switch (trim($_GET['type'])){
				case 'cusamounttop':
					$ordercustomerlist = $this->getyearcustomersalesstat('amount','top',intval($_GET['uid']));
					//处理数组信息
					$cc_name_arr = array();
					$data_string = '';
					if(empty($ordercustomerlist)){
						$error = '未找到相关销售数据';
					}else{
						foreach ($ordercustomerlist as $k=>$v){
							$cc_name_arr[] = mb_substr($v['cc_name'],0,4,'utf-8');
							$data_string  .= $v['amount'].',';
						}
					}
					$data_string = trim($data_string,',');
					$output['x_name']      = $cc_name_arr;
					$output['data_string'] = $data_string;
					$output['title']       = '会员销售额前5名';
					break;
				case 'cusprofittop':
					$ordercustomerlist = $this->getyearcustomersalesstat('profit','top',intval($_GET['uid']));
					//处理数组信息
					$cc_name_arr = array();
					$data_string = '';
					if(empty($ordercustomerlist)){
						$error = '未找到相关销售数据';
					}else{
						foreach ($ordercustomerlist as $k=>$v){
							$cc_name_arr[] = mb_substr($v['cc_name'],0,4,'utf-8');
							$data_string  .= $v['profit'].',';
						}
					}
					$data_string = trim($data_string,',');
					$output['x_name']      = $cc_name_arr;
					$output['data_string'] = $data_string;
					$output['title']       = '会员毛利润前5名';
					break;	
				default:
					$error = '参数错误';
			}
		}
		//加载模版进行图表展示
		$output['error'] = $error;
		$this->loadtpl('column',$output);
	}
	/**
	 * 员工数据统计
	 */
//	private function _staffstat(){
//		$m = M();
//		$error = '';
//		if(trim($_GET['type']) == '' || intval($_GET['uid']) <= 0) {
//			$error='参数错误';
//			$output['error'] = $error;
//			$this->loadtpl('column',$output);
//			exit();
//		}
//		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
//		$user_info = $user_info[0];
//		if(empty($user_info)){
//			$error = '未找到用户数据';
//		}else{
//			$datapermission = $this->getParentDepartment($user_info['user_department'],$user_info['user_jobpost'],'customer');
//			$commonwhere = array();
//			//获得所有查询共有条件
//			if($this->datapermission['data'] == 'own'){
//				$commonwhere['user_id'] = intval($_GET['uid']);
//			}elseif($this->datapermission['data'] == 'dp'){
//				$commonwhere['user_department'] = array('in',$datapermission['d_id']);
//			}
//			switch (trim($_GET['type'])){
//				case 'orderamounttop':
//					$data = $this->statuserrelevantdata('orderamount','top',$commonwhere);
//					$output['title'] = '员工销售额前5名';
//					break;
//				case 'orderamountlower':
//					$data = $this->statuserrelevantdata('orderamount','lower',$commonwhere);
//					$output['title'] = '员工销售额后5名';
//					break;
//				case 'orderprofitytop':
//					$data = $this->statuserrelevantdata('orderprofity','top',$commonwhere);
//					$output['title'] = '员工毛利润前5名';
//					break;
//				case 'orderprofitylower':
//					$data = $this->statuserrelevantdata('orderprofity','lower',$commonwhere);
//					$output['title'] = '员工毛利润后5名';
//					break;
//				default:
//					$error = '参数错误';
//			}
//		}
//		//处理数组信息
//		if(empty($data)){
//			$error = '未找到相关销售数据';
//		}else{
//			$staff_name_arr = array();
//			$data_string = '';
//			foreach ($data as $k=>$v){
//				$staff_name_arr[] = $v['stattext'];
//				$data_string .= $this->ncPriceFormat($v['statvalue']).',';
//			}
//			$data_string = trim($data_string,',');
//			$output['x_name'] = $staff_name_arr;
//			$output['data_string'] = $data_string;
//		}
//		//加载模版进行图表展示
//		$output['error'] = $error;
//		$this->loadtpl('column',$output);
//	}
	/**
	 * 商品数据统计
	 */
	private function _productstat(){
		$m = M();
		$error = '';
		if(trim($_GET['type']) == '' || intval($_GET['uid']) <= 0) {
			$error='参数错误';
			$output['error'] = $error;
			$this->loadtpl('column',$output);
			exit();
		}
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			$error = '未找到用户数据';
		}else{
			switch (trim($_GET['type'])){
				case 'ordernumtop':
					$data = $this->statproductrelevantdata('ordernum','top',intval($_GET['uid']));
					$output['title'] = '商品销量前5名';
					break;
				case 'ordernumlower':
					$data = $this->statproductrelevantdata('ordernum','lower',intval($_GET['uid']));
					$output['title'] = '商品销量后5名';
					break;
				case 'orderamounttop':
					$data = $this->statproductrelevantdata('orderamount','top',intval($_GET['uid']));
					$output['title'] = '商品销售额前5名';
					break;
				case 'orderamountlower':
					$data = $this->statproductrelevantdata('orderamount','lower',intval($_GET['uid']));
					$output['title'] = '商品销售额后5名';
					break;
				case 'orderprofitytop':
					$data = $this->statproductrelevantdata('orderprofity','top',intval($_GET['uid']));
					$output['title'] = '商品毛利润前5名';
					break;
				case 'orderprofitylower':
					$data = $this->statproductrelevantdata('orderprofity','lower',intval($_GET['uid']));
					$output['title'] = '商品毛利润后5名';
					break;
				default:
					$error = '参数错误';
			}
		}
		//处理数组信息
		if(empty($data)){
			$error = '未找到相关销售数据';
		}else{
			$staff_name_arr = array();
			$data_string = '';
			foreach ($data as $k=>$v){
				$staff_name_arr[] = mb_substr($v['stattext'],0,4,'utf-8');;
				$data_string .= $this->ncPriceFormat($v['statvalue']).',';
			}
			$data_string = trim($data_string,',');
			$output['x_name'] = $staff_name_arr;
			$output['data_string'] = $data_string;
		}
		//加载模版进行图表展示
		$output['error'] = $error;
		$this->loadtpl('column',$output);
	}
	/**
	 * 月度数据统计
	 */
	private function _monthstat(){
		$m = M();
		$error = '';
		if(trim($_GET['type']) == '' || intval($_GET['uid']) <= 0 || intval($_GET['year']) <= 0) {
			$error='参数错误';
			$output['error'] = $error;
			$this->loadtpl('column',$output);
			exit();
		}
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			$error = '未找到用户数据';
		}else{
			$datapermission = $this->getParentDepartment($user_info['user_department'],$user_info['user_jobpost'],'customer');
			$commonwhere = array();
			//获得所有查询共有条件
			if($this->datapermission['data'] == 'own'){
				$commonwhere['co_staff_id'] = intval($_GET['uid']);
			}elseif($this->datapermission['data'] == 'dp'){
				$commonwhere['dp_id'] = array('in',$datapermission['d_id']);
			}
			switch (trim($_GET['type'])){
				case 'ordernum':
					$data = $this->getmonthsalestat('ordernum',intval($_GET['year']),intval($_GET['uid']));
					$output['title'] = intval($_GET['year']).'年月度销量统计';
					break;
				case 'orderamount':
					$data = $this->getmonthsalestat('ordersaleroom',intval($_GET['year']),intval($_GET['uid']));
					$output['title'] = intval($_GET['year']).'年月度销售额统计';
					break;
				case 'orderprofit':
					$data = $this->getmonthsalestat('orderprofity',intval($_GET['year']),intval($_GET['uid']));
					$output['title'] = intval($_GET['year']).'年月度毛利润统计';
					break;
			}
		}
		//处理数组信息
		if(empty($data)){
			$error = '未找到相关销售数据';
		}else{
			$data_string = '';
			for ($i=1;$i<13;$i++){
				$data_string .= empty($data[$i])?'0.00,':$this->ncPriceFormat($data[$i]['statvalue']).',';
			}
			$data_string = trim($data_string,',');
			$output['x_name']      = array('1','2','3','4','5','6','7','8','9','10','11','12');
			$output['data_string'] = $data_string;
		}
		//加载模版进行图表展示
		$output['error'] = $error;
		$this->loadtpl('column',$output);
	}
	/**********以下为获取统计数据函数**********/
	/**
	 * 获得会员销售统计数据
	 * 
	 * $type 为查询数据类型包括销售额(amount)，毛利润(profit)
	 * $order 为查询数据排序方式包含top，lower
	 * $uid 员工ID
	 */
	private function getyearcustomersalesstat($type,$order,$uid){
		$m = M();
		$where = array();
		$where['co_status'] = array('in','0,1,2');
		$user_info = $m->table('user')->where("user_id = {$uid}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		if($user_info['user_shopid'] > 0){
			$where['shop_id'] = $user_info['user_shopid'];
		}
		$field = 'orders.cc_id,customer.cc_name';
		switch ($type){
			case 'amount':
				$field .=",sum(co_final_price) as amount";
				$orderby = 'amount';
				break;
			case 'profit':
				$field .=",sum(co_final_price - co_cost_price) as profit";
				$orderby = 'profit';
				break;
		}
		if ($order == 'lower'){
			$orderby .= ' asc';
		}else {
			$orderby .= ' desc';
		}
		$on = 'orders.cc_id=customer.cc_id';
		$ordercustomerlist = $m->table('orders,customer')->field($field)->join('LEFT JOIN')->on($on)->where($where)->group('orders.cc_id')->order($orderby)->limit(5)->select();
		$ordercustomerlistnew = array();
		if(!empty($ordercustomerlist)){
			$i=1;
			foreach((array)$ordercustomerlist as $k=>$v){
				$v['amount'] = $this->ncPriceFormat($v['amount']);
				$v['profit'] = $this->ncPriceFormat($v['profit']);
				$v['order']  = $i;
				$i++;
				$ordercustomerlistnew[$v['cc_id']] = $v;
			}
		}
		return $ordercustomerlistnew;
	}
	/**
	 * 获得员工销售统计数据
	 * 
	 * $stattype 为查询数据类型包括销售额(orderamount)，毛利润(orderprofity)
	 * $order 为查询数据排序方式包含top，lower
	 * $commonwhere 为公有查询条件
	 */
	private function statuserrelevantdata($stattype,$order,$commonwhere=array()){
		$m = M();
		$where = $commonwhere;
		$where['user_state'] = array('neq',2);
		$field = 'user_truename as stattext,user_id';
		switch($stattype){
			case 'orderamount':
				$table = 'orders,user';
				$on = 'orders.co_staff_id = user.user_id';
				$field .=",sum(co_final_price * exchange_rate) as statvalue ";
				$where['co_status'] = array('neq',3);
				break;
			case 'orderprofity':
				$table = 'orders,user';
				$on = 'orders.co_staff_id = user.user_id';
				$field .=",sum(co_final_price * exchange_rate - co_cost_price) as statvalue ";
				break;
		}
		if($order == 'top'){
			$ordertext = 'statvalue desc';
		}else{
			$ordertext = 'statvalue asc';
		}
		$statlist = $m->table($table)->field($field)->join('INNER JOIN')->on($on)->where($where)->group('user_id')->order($ordertext)->limit(5)->select();
		return $statlist;
	}
	/**
	 * 获得商品销售统计数据
	 * 
	 * $stattype 为查询数据类型包括销量(ordernum)，销售额(orderamount)，毛利润(orderprofity)
	 * $order 为查询数据排序方式包含top，lower
	 * $uid 员工ID
	 */
	private function statproductrelevantdata($stattype,$order,$uid){
		$m = M();
		$where = array();
		$where['co_status'] = array('in','0,1,2');
		$field = 'product.cp_id,product.cp_name as stattext';
		$user_info = $m->table('user')->where("user_id = {$uid}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		if($user_info['user_shopid'] > 0){
			$where['product.shop_id'] = $user_info['user_shopid'];
		}
		switch($stattype){
			case 'ordernum':
				$field .=",sum(cop_pnum) as statvalue";
				$dataformat = 'integer';
				break;
			case 'orderamount':
				$field .=",sum(order_product.cop_total_price) as statvalue ";
				$dataformat = 'money';
				break;
			case 'orderprofity':
				$field .=",sum(order_product.cop_total_price - order_product.cp_cost*cop_pnum) as statvalue ";
				$dataformat = 'money';
				break;
		}
		if($order == 'top'){
			$ordertext = 'statvalue desc';
		}else{
			$ordertext = 'statvalue asc';
		}
		$table = 'order_product,orders,product';
		$on = 'order_product.co_id=orders.co_id,order_product.cp_id=product.cp_id';
		$statlist = $m->table($table)->field($field)->join('INNER JOIN')->on($on)->where($where)->group('product.cp_id')->order($ordertext)->limit(5)->select();
		return $statlist;
	}
	/**
	 * 获得某年月销售额统计
	 * 
	 * $type 为查询数据类型包括销量(ordernum)，销售额(ordersaleroom)，毛利润(orderprofity)
	 * $year 为查询数据年份
	 * $uid 员工ID
	 */
	private function getmonthsalestat($type,$year,$uid){
		$m = M();
		$timequantum = $this->gettimequantum($year);
		$where = array();
		$where['co_status']  = array('neq',3);
		$where['co_addtime'] = array(array('egt',"{$timequantum['stime']}"),array('elt',"{$timequantum['etime']}"),'and');
		$user_info = $m->table('user')->where("user_id = {$uid}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		if($user_info['user_shopid'] > 0){
			$where['shop_id'] = $user_info['user_shopid'];
		}
		$field = 'MONTH(FROM_UNIXTIME(co_addtime)) as monthval';
		switch ($type){
			case 'orderprofity':
				$field .= ',sum(co_final_price - co_cost_price) as statvalue';
				break;
			case 'ordersaleroom':
				$field .= ',sum(co_final_price) as statvalue';
				break;
			case 'ordernum':
				$field .= ',count(*) as statvalue';
				break;				
		}
		$statlist = $m->table('orders')->field($field)->where($where)->group('monthval')->select();
		$statlistnew = array();
		if(!empty($statlist)){
			foreach((array)$statlist as $k=>$v){
				$statlistnew[$v['monthval']] = $v;
			}
		}
		return $statlistnew;
	}
	/**********以下为通用函数**********/
	/**
	 * 获得下级部门ID及本身ID的数组
	 *
	 */
	private function getParentDepartment($dp_id,$jp_id,$module='user'){
		$datapermission = array();
		$datapermission = $this->cDataPermission($module,$jp_id);
		if($datapermission['data'] == 'dp' || $datapermission['data'] == 'all'){
			$tree_arr = include '../cache/department.php';
			$d_idarr = array();
			if (!empty($tree_arr[$dp_id])){//从缓存查询子部门
				$d_info = $tree_arr[$dp_id];
				if (!empty($tree_arr[$dp_id]['son'])){
					$d_idarr = explode(',',$tree_arr[$dp_id]['son']);
				}
			}else {
				//查询子部门
				$d_info = $this->table('department')->where(array('d_id'=>$dp_id,'d_state'=>1))->select();
				$d_info = $d_info[0];
				$d_idarr = array();
				if(!empty($d_info)){
					$d_arr = $this->table('department')->where(array('d_allparentid'=>array('like',$d_info['d_allparentid'].$d_info['d_id'].','),'d_state'=>1))->select();
					foreach((array)$d_arr as $k=>$v){
						$d_idarr[] = $v['d_id'];
					}
				}
			}
			$d_idarr[] = $d_info['d_id'];
			$datapermission['d_id'] = $d_idarr;
			$datapermission['d_info'] = $d_info;
		}
		return $datapermission;
	}
	/**
	 * 验证数据权限
	 * 
	 * @param $module 模块名称
	 * @param $jp_id 员工岗位ID
	 */
	private function cDataPermission($module,$jp_id){
		$m = M();
		/*查询员工所在岗位信息和权限信息*/
		$pdata_arr = array();
		$jp_info = $m->table('jobpost,permission')->join('LEFT JOIN')->on('jobpost.jp_permissionid=permission.pmn_id')->where(array('jp_id'=>$jp_id))->select();
		$jp_info = $jp_info[0];
		//数据权限
		$pdata_arr['data']   = $jp_info['pmn_dataright'];
		
		if ($pdata_arr['data'] == ''){
			return array('data'=>'own','operate'=>'edit');
		}elseif ($pdata_arr['data'] == 'all'){
			return array('data'=>'all','operate'=>'edit');
		}
		$p_arr = unserialize($pdata_arr['data']);
		if ($p_arr['type'] == 'common'){
			return $p_arr['info'];
		}else{
			if (isset($p_arr['info'][$module]) && !empty($p_arr['info'][$module])){
				return $p_arr['info'][$module];
			}else {//模块未设置默认为仅个人数据
				return array('data'=>'own','operate'=>'all');
			}
		}
	}
   /**
	* 价格格式化
	*
	* @param int	$price
	* @return string	$price_format
	*/
	private function ncPriceFormat($price) {
		$price_format	= number_format($price,2,'.','');
		return $price_format;
	}
	/**
	 * 获取统计数据时间段
	 */
	private function gettimequantum($year){
		$m = M();
		$setting = include '../cache/setting.php';
		$month = ($t = intval($setting['annualinventorydate_month']))>0?$t:12;
		$day = ($t = intval($setting['annualinventorydate_day']))>0?$t:31;
		$stime = mktime(23,59,59,$month,$day,$year-1)+1;
		$etime = mktime(23,59,59,$month,$day,$year);
		return array('stime'=>$stime,'etime'=>$etime);
	}
	/**
	 * 加载图表模版
	 */
	private function loadtpl($type='column',$output=array()){
		include 'chartshow/'.$type.'tpl.php';
	}
}
new run();