<?php
/**
 * 模型
 *
 */
defined('InBizpower') or exit('Access Invalid!');
class model{
	/**
	 * 查询类型
	 *
	 * @var 查询类型 mysqli,mysql
	 */
	private $query_type;
	/**
	 * 当前链接对象
	 *
	 * @var obj $link
	 */
	private $link;
	
	private $join_type = '';
	
	private $on = '';

	private $where = '';
	
	private $order = '';

	private $group = '';
	
	private $limit = '';
	
	private $table = '';
	
	private $field = '';
	
	public function __construct($table = ''){
		$this->table($table);
		$this->_ini_db();
	}

	/**
	 * 数据库初始化
	 *
	 */
	private function _ini_db(){
		if (extension_loaded('mysqli')){
			$link = mysqli_connect(DB_HOST,DB_USER,DB_PWD,DB_NAME,DB_PORT) or die("不能连接数据库 : ".mysqli_connect_error());
			$this->query_type = 'mysqli';
		}else{
			$link = mysql_connect(DB_HOST.':'.DB_PORT,DB_USER,DB_PWD,DB_NAME) or die("不能连接数据库 : ".mysql_error());
			$this->query_type = 'mysql';
		}
		$this->link = $link;
		
		if (strtoupper(CHARSET)=='UTF-8'){
			$query_string = " SET CHARACTER_SET_CLIENT = utf8,
                 CHARACTER_SET_CONNECTION = utf8,
                 CHARACTER_SET_DATABASE = utf8,
                 CHARACTER_SET_RESULTS = utf8,
                 CHARACTER_SET_SERVER = utf8,
                 COLLATION_CONNECTION = utf8_general_ci,
                 COLLATION_DATABASE = utf8_general_ci,
                 COLLATION_SERVER = utf8_general_ci,
                 sql_mode=''";
		}else{
			$query_string = " SET CHARACTER_SET_CLIENT = gbk,
                 CHARACTER_SET_CONNECTION = gbk,
                 CHARACTER_SET_DATABASE = gbk,
                 CHARACTER_SET_RESULTS = gbk,
                 CHARACTER_SET_SERVER = gbk,
                 COLLATION_CONNECTION = gbk_chinese_ci,
                 COLLATION_DATABASE = gbk_chinese_ci,
                 COLLATION_SERVER = gbk_chinese_ci,
                 sql_mode=''";
		}
		$this->_query($query_string);
	}
	
	public function query(){
		if (empty($this->table)) return false;
		if (empty($this->field)) $this->field = '*';

		$sql = 'SELECT '.$this->field.' FROM '.$this->table.$this->join_type.$this->where.$this->group.$this->order.$this->limit;
		return $this->_query($sql);
	}

	public function select($sql = ''){
		if ($sql != ''){
			return $this->_select($sql);
		}

		if (empty($this->table) && empty($this->join_type)) {
			exit('table name is null');
		}

		if (empty($this->field)) $this->field = '*';
		//处理连表
		$tmp_tables = explode(',', $this->table);
		if (!empty($tmp_tables) && count($tmp_tables) > 1){
			$join_sql = '';
			if ($this->join_type == '' || $this->on == '') throw_exception('Sql Error:join param not found');
			$tmp_joinon = explode(',', $this->on);
			for ($i=1;$i<count($tmp_tables);$i++){
				$join_sql .= $this->join_type.' `'.DB_PRE.$tmp_tables[$i].'` as `'.$tmp_tables[$i].'` ON '.$tmp_joinon[$i-1].' ';
			}
			$sql = 'SELECT '.$this->field.' FROM `'.DB_PRE.$tmp_tables[0].'` as `'.$tmp_tables[0].'` '.$join_sql.$this->where.$this->group.$this->order.$this->limit;
		}else{
			$sql = 'SELECT '.$this->field.' FROM '.$this->table.$this->where.$this->group.$this->order.$this->limit;
		}
		//echo $sql.'<br>';
		return $this->_select($sql);
	}
	/**
	 * INSERT操作
	 *
	 * @param array $param
	 * @return int/bool
	 */
	public function insert($param){
		if (is_array($param)){
			$_sql = '';
			foreach ($param as $k=>$v) {
				$_sql .= "`{$k}`='{$v}',";
			}
			$sql = 'INSERT INTO '.$this->table.' SET '.trim($_sql,',');
			if ($this->_query($sql)){
				return $this->insert_id();
			}else{
				return false;
			}
		}
		return false;
	}

	/**
	 * UPDATE操作
	 *
	 * @param array $param
	 * @return int/bool
	 */
	public function update($param){
		if (is_array($param)){
			$_sql = '';
			foreach ($param as $k=>$v) {
				$_sql .= "`{$k}`='{$v}',";
			}
			$sql = 'UPDATE '.$this->table.' SET '.trim($_sql,',').$this->where;
//			die($sql);
			if ($this->_query($sql)){
				return true;
			}else{
				return false;
			}
		}
		return false;
	}
	/**
	 * 执行SQL
	 *
	 * @param string $sql
	 * @return unknown
	 */
	private function _query($sql){
		if (strtoupper(CHARSET) == 'GBK'){
			$sql = charset($sql,'UTF-8','GBK');
		}
		if ($this->query_type == 'mysqli'){
			$result = mysqli_query($this->link,$sql);
		}else{
			$result = mysql_query($sql,$this->link);
		}
		if (!$result){
//			echo mysqli_error($this->link);exit;
			throw_exception(mysqli_error($this->link));
		}
		return $result ? true : false;
	}

	/**
	 * 
	 *
	 * @param unknown_type $condition
	 */
	private function _select($sql){
		if (strtoupper(CHARSET) == 'GBK'){
			$sql = charset($sql,'UTF-8','GBK');
		}
		if ($this->query_type == 'mysqli'){
			$rs = mysqli_query($this->link,$sql);
			if (!$rs) exit(mysqli_error($this->link));
			if (!$rs) throw_exception(mysqli_error($this->link));
			$array = array();
			while ($row = mysqli_fetch_array($rs,MYSQLI_ASSOC)) {
				$array[] = $row;
			}
		}else{
			$rs = mysql_query($sql,$this->link);
//			if (!$rs) exit(mysql_error());
			if (!$rs) throw_exception(mysqli_error($this->link));
			
			$array = array();
			while ($row = mysql_fetch_array($rs,MYSQLI_ASSOC)) {
				$array[] = $row;
			}
		}
		return $array;
	}
	
	private function insert_id(){
		if ($this->query_type == 'mysqli'){
			return mysqli_insert_id($this->link);
		}else{
			return mysql_insert_id($this->link);
		}
	}

	/**
	 * Enter description here...
	 *
	 * @param array,string $param
	 */
	public function where($param){
		$where = '';
		if (is_array($param)){
			foreach ($param as $k=>$v) {
				if(is_array($v)){
					if($v[0] == 'lt'){ $where .= " AND `{$k}`<'{$v[1]}'"; }
					if($v[0] == 'gt'){ $where .= " AND `{$k}`>'{$v[1]}'"; }
					if($v[0] == 'neq'){ $where .= " AND `{$k}`!='{$v[1]}'"; }
					if($v[0] == 'in'){ $where .= " AND `{$k}` in ({$v[1]})"; }
					if($v[0] == 'like'){ $where .= " AND `{$k}` like '%{$v[1]}%'"; }
				}else{
					$where .= " AND `{$k}`='{$v}'";
				}
			}
			$param = empty($param)?'':' WHERE '.substr($where,4);
		}elseif(is_string($param)){
			if (substr(strtoupper(trim($param)),0,5) != 'WHERE'){
				$param = ' WHERE '.$param;
			}
		}else{
			$param = '';
		}
		$this->where = $param;
		return $this;
	}

	public function delete(){
		$sql = 'DELETE FROM '.$this->table.$this->where;
		return $this->_query($sql);
	}
	public function order($string = ''){
		if (!is_string($string)){
			$this->order = '';
			return $this;
		}
		if (substr(strtoupper(trim($string)),0,8) != 'ORDER BY'){
			$string = ' ORDER BY '.$string;
		}
		$this->order = $string;
		return $this;
	}

	public function group($string = ''){
		if (!is_string($string)) $this->order = '';
		
		if (substr(strtoupper(trim($string)),0,8) != 'GROUP BY'){
			$string = ' GROUP BY '.$string;
		}
		$this->group = $string;
		return $this;
	}

	public function limit($start = '', $end = ''){
		$limit = '';
		if (is_numeric($start)){
			$limit = $start;
			if (is_numeric($end)){
				$limit .= ','.$end;
			}
			$this->limit = ' LIMIT '.$limit;
		}else{
			$this->limit = '';
		}
		return $this;
	}

	public function field($field = ''){
		if (!is_string($field)) $this->field = '';
		$this->field = $field;
		return $this;	
	}
	
	public function table($table = ''){
		if (stripos($table,',') !== false){
			$this->table = $table;
		}elseif($table != ''){
			$this->table = '`'.DB_PRE.$table.'`';
		}
		return $this;
	}

	public function join($str = ''){
		$this->join_type = $str;
		return $this;
	}
	
	public function on($str = ''){
		$this->on = $str;
		return $this;
	}
	
	public function clear(){
		$this->field = $this->table = $this->join_type = $this->group = $this->limit = $this->order = '';
	}
}

/*********************************************************/
/**
 * 
 * 以下为通用函数
 * 
 */
/*********************************************************/

	function M($table = ''){
		return new model($table);
	}
	
	function table($table){
		return '`'.DB_PRE.$table.'`';
	}
	
	function throw_exception($error){
		echo json_encode(array('code'=>500,'datas'=>$error));exit();
	}

	function html2text($document){
		$document = trim($document);
		if (strlen($document) <= 0){
		  return $document;
		}
		$search = array ("'<script[^>]*?>.*?</script>'si",  // 去掉 javascript
		                  "'<[\/\!]*?[^<>]*?>'si",          // 去掉 HTML 标记
		                  "'([\r\n])[\s]+'",                // 去掉空白字符
		                  "'&(quot|#34);'i",                // 替换 HTML 实体
		                  "'&(amp|#38);'i",
		                  "'&(lt|#60);'i",
		                  "'&(gt|#62);'i",
		                  "'&(nbsp|#160);'i");
		$replace = array ("",
		                   "",
		                   "\\1",
		                   "\"",
		                   "&",
		                   "<",
		                   ">",
		                   " ");
		return @preg_replace ($search, $replace, $document);
	}

	function fliter(&$array){
		if (!empty($array)){
			while (list($k,$v) = each($array)) {
				if (is_string($v)) {
					$patterns = array("/<script.*>.*< {0,}\/script>/siU","/<iframe.*>.*< {0,}\/iframe>/siU","/<input(.*submit.*)(\>|\/\>)/siUe","/<form(.*action.*)>/siUe");
					$replacements = array('','','','');
					$v = preg_replace($patterns, $replacements, $v);					
					
					$v = preg_replace('/&amp;((#(\d{3,5}|x[a-fA-F0-9]{4})|[a-zA-Z][a-z0-9]{2,5});)/', '&\\1',
					str_replace(array('&', '"', '<', '>'), array('&amp;', '&quot;', '&lt;', '&gt;'), $v));

					if (!get_magic_quotes_gpc()){
						$array[$k] = addslashes(trim($v));
					}else {
						$array[$k] = trim($v);
					}
				}elseif (is_array($v))  {
					$array[$k] = fliter($v);
				}
			}
			return $array;
		}
	}

	/**
	 * 统一编码处理
	 *
	 * @param string/array $string
	 * @return string/array
	 */
	function charset($string='',$from='UTF-8',$to='GBK'){
		if (is_array($string)){
			$result = var_export($string, true);//变为字符串
			$result = myencode($result,$from,$to);
			eval("\$result = $result;");//转换回数组
		} else {
			$result = myencode($string,$from,$to);
		}
		return $result;
	}

	function myencode($string='',$from,$to){
        if(function_exists('mb_convert_encoding')){
            return mb_convert_encoding ($string, $to, $from);
        }elseif(function_exists('iconv')){
            return iconv($from,$to,$string);
        }else{
            return $string;
        }
	}
	function authcode($string, $operation = 'DECODE', $key = '', $expiry = 0) {
	
		$ckey_length = 4;
		$key = md5($key ? $key : SIGN_KEY);
		$keya = md5(substr($key, 0, 16));
		$keyb = md5(substr($key, 16, 16));
		$keyc = $ckey_length ? ($operation == 'DECODE' ? substr($string, 0, $ckey_length): substr(md5(microtime()), -$ckey_length)) : '';

		$cryptkey = $keya.md5($keya.$keyc);
		$key_length = strlen($cryptkey);

		$string = $operation == 'DECODE' ? base64_decode(substr($string, $ckey_length)) : sprintf('%010d', $expiry ? $expiry + time() : 0).substr(md5($string.$keyb), 0, 16).$string;
		$string_length = strlen($string);
	
		$result = '';
		$box = range(0, 255);
	
		$rndkey = array();
		for($i = 0; $i <= 255; $i++) {
			$rndkey[$i] = ord($cryptkey[$i % $key_length]);
		}
	
		for($j = $i = 0; $i < 256; $i++) {
			$j = ($j + $box[$i] + $rndkey[$i]) % 256;
			$tmp = $box[$i];
			$box[$i] = $box[$j];
			$box[$j] = $tmp;
		}
	
		for($a = $j = $i = 0; $i < $string_length; $i++) {
			$a = ($a + 1) % 256;
			$j = ($j + $box[$a]) % 256;
			$tmp = $box[$a];
			$box[$a] = $box[$j];
			$box[$j] = $tmp;
			$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
		}
	
		if($operation == 'DECODE') {
			if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
				return substr($result, 26);
			} else {
				return '';
			}
		} else {
			return $keyc.str_replace('=', '', base64_encode($result));
		}
	
	}

	function authsid($string, $operation = 'DECODE') {	
		for($a = $j = $i = 0; $i < strlen($string); $i++) {
			$a = ($a + 1) % 256;
			$j = ($j + $box[$a]) % 256;
			$tmp = $box[$a];
			$box[$a] = $box[$j];
			$box[$j] = $tmp;
			$result .= chr(ord($string[$i]) ^ ($box[($box[$a] + $box[$j]) % 256]));
		}
	
		if($operation == 'DECODE') {
			if((substr($result, 0, 10) == 0 || substr($result, 0, 10) - time() > 0) && substr($result, 10, 16) == substr(md5(substr($result, 26).$keyb), 0, 16)) {
				return substr($result, 26);
			} else {
				return '';
			}
		} else {
			return $keyc.str_replace('=', '', base64_encode($result));
		}
	
	}	

?>