<?php
/**
 * Bizpower CRM移动端功能类接口
 *
 * @copyright  Copyright (c) 2007-2013 Bizpower Inc. (http://www.bizpower.com)
 * @license    http://www.bizpower.com
 * @link       http://www.bizpower.com
 * @since      File available since Release v1.0
 */
error_reporting(E_ALL & ~E_NOTICE);
define('InBizpower',true);

define('BasePath',dirname(__FILE__));

if(file_exists('config.php')){require('config.php');}else{exit();}
if(file_exists('model.class.php')){require('model.class.php');}else{exit();}

//总是输出UTF-8编码
header("Content-type: text/html; charset=utf-8");


class run{
	/**
	 * 内部服务器错误（数据库错误、PHP处理异常等所有异常情况）
	 *
	 */
	const ERROR_500 = '500';
	/**
	 * 参数不正确
	 *
	 */
	const ERROR_404 = '404';

	public function __construct(){
		$this->index();
	}
	private function index(){
		$func = '_'.$_GET['commend'];
		if(method_exists($this,$func)){
			$this->$func();
		}else{
			exit($this->callback('',self::ERROR_404));
		}
	}
	/**
	 * 验证是否登陆过
	 * 
	 */
	private function checklogin($uid){
		$m = M('mobilelogin');
		$mobile_login = $m->where('uid = '.$uid)->select();
		if(!empty($mobile_login[0])){
			return true;
		}else{
			return false;
		}
	}
	/**
	 * 登陆
	 * 
	 */
	private function _login(){
		$m = M();
		$username = trim($_POST['username']);
		$password = trim($_POST['password']);
		$device   = trim($_POST['device']);
		$user_info = $m->table('user')->where("user_name = '".$username."' and user_password = '".$password."'")->select();
		
		if(!empty($user_info[0])){
			if($this->checklogin($user_info[0]['user_id'])){//曾经登陆过
				$m->table('mobilelogin')->where("username = '".$username."'")->update(array('lastlogin_time'=>time(),'lastlogin_device'=>$device,'ip'=>$_SERVER['REMOTE_ADDR']));
			}else{//第一次登陆
				$m->table('mobilelogin')->insert(array('uid'=>$user_info[0]['user_id'],'username'=>$user_info[0]['user_name'],'lastlogin_time'=>time(),'lastlogin_device'=>$device,'ip'=>$_SERVER['REMOTE_ADDR']));
			}
			//返回员工基本信息
			echo $this->callback(array('uid'=>$user_info[0]['user_id'],'username'=>$user_info[0]['user_name'],'truename'=>$user_info[0]['user_truename'],'did'=>$user_info[0]['user_department']));
		}else{
			echo $this->callback('login failed');
		}
	}
	/**
	 * 任务列表
	 * 
	 */
	private function _mlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$count = $m->field('count(*) as count')->table('mission')->where("cm_addstaff = '{$_GET['uid']}' OR cm_excstaff = 'all' OR cm_excstaff like '%,{$_GET['uid']},%'")->select();
		$mission_list = $m->field('cm_id,cm_subject,cm_type,cm_donedate')->table('mission')->where("cm_addstaff = '{$_GET['uid']}' OR cm_excstaff = 'all' OR cm_excstaff like '%,{$_GET['uid']},%'")->order("cm_addtime desc")->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($mission_list)))<=0?false:true;
		//处理数组信息
		$dic_array = include '../cache/dictionary.php';
		if(!empty($mission_list)){
			foreach ($mission_list as $k=>$v){
				$mission_list[$k]['cm_type']   = $dic_array['mission_type']['child_option'][$v['cm_type']]['cd_name'];
				$mission_list[$k]['is_expire'] = time() < $v['cm_donedate']?0:1;
			}
		}
		echo $this->callback($mission_list,200,$addon);
	}
	/**
	 * 任务详情
	 * 
	 */
	private function _mdetail(){
		$m = M();
		if (intval($_GET['mid']) <= 0) exit($this->callback('',self::ERROR_404));
		$mission_info = $m->field('mission.*,user.user_truename,customer.cc_name,customer.cc_type,company_contact.ccc_name')->table('mission,user,customer,company_contact')->join('LEFT JOIN')->on('mission.cm_addstaff=user.user_id,mission.cc_id=customer.cc_id,mission.cm_contact=company_contact.ccc_id')->where("mission.cm_id = {$_GET['mid']}")->select();
		$mission_info = $mission_info[0];
		if(empty($mission_info)) {
			echo $this->callback('data not found');exit();
		}
		//处理数组信息
		$dic_array = include '../cache/dictionary.php';
		$mission_info['cm_type']   = $dic_array['mission_type']['child_option'][$mission_info['cm_type']]['cd_name'];
		$mission_info['is_expire'] = time() < $mission_info['cm_donedate']?0:1;
		$mission_info['cc_name']   = $mission_info['cc_name']==''?'无':$mission_info['cc_name'];
		$mission_info['ccc_name']  = $mission_info['ccc_name']==''?'无':$mission_info['ccc_name'];
		echo $this->callback($mission_info);
	}
	/**
	 * 检查未完成任务数量
	 * 
	 */
	private function _mcheck(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$mission_list = $m->field('cm_id,cm_subject')->table('mission')->where("(cm_excstaff = 'all' OR cm_excstaff like '%,{$_GET['uid']},%') AND cm_status=1")->select();
		echo $this->callback(count($mission_list));
	}
	/**
	 * 日程列表
	 * 
	 */
	private function _schlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$count = $m->table('schedule')->field('count(*) as count')->where("cs_staff_id = {$_GET['uid']}")->select();
		$schedule_list = $m->table('schedule')->field('cs_id,cs_subject,cs_type,cs_start_time,cs_end_time')->where("cs_staff_id = {$_GET['uid']}")->order("cs_addtime desc")->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($schedule_list)))<=0?false:true;
		//处理数组信息
		$dic_array = include '../cache/dictionary.php';
		if(!empty($schedule_list)){
			foreach ($schedule_list as $k=>$v){
				$schedule_list[$k]['cs_type'] = $dic_array['mission_type']['child_option'][$v['cs_type']]['cd_name'];
			}
		}
		echo $this->callback($schedule_list,200,$addon);
	}
	/**
	 * 日程详情
	 * 
	 */
	private function _schdetail(){
		$m = M();
		if (intval($_GET['schid']) <= 0) exit($this->callback('',self::ERROR_404));
		$schedule_info = $m->table('schedule,customer,chance,user,department')->field('schedule.*,customer.cc_name,chance.cha_title,user.user_truename as cs_staff_name,department.d_name as cs_dp_name')->join('LEFT JOIN')->on('schedule.cc_id=customer.cc_id,schedule.cs_chanceid=chance.cha_id,schedule.cs_staff_id=user.user_id,schedule.cs_dp_id=department.d_id')->where("schedule.cs_id = '{$_GET['schid']}'")->select();
		$schedule_info = $schedule_info[0];
		if(empty($schedule_info)) { 
			echo $this->callback('data not found');exit();
		}
		//处理数组信息
		$dic_array = include '../cache/dictionary.php';
		$schedule_info['cs_type']   = $dic_array['mission_type']['child_option'][$schedule_info['cs_type']]['cd_name'];
		$schedule_info['cha_title'] = $schedule_info['cha_title']==''?'无':$schedule_info['cha_title'];
		echo $this->callback($schedule_info);
	}
	/**
	 * 记事本列表
	 * 
	 */
	private function _nplist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$count = $m->field('count(*) as count')->table('notepad')->where("np_userid = '{$_GET['uid']}'")->select();
		$note_list = $m->field('*')->table('notepad')->where("np_userid = '{$_GET['uid']}'")->order('np_addtime desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($note_list)))<=0?false:true;
		echo $this->callback($note_list,200,$addon);
	}
	/**
	 * 记事本详情
	 * 
	 */
	private function _npdetail(){
		$m = M();
		if (intval($_GET['npid']) <= 0) exit($this->callback('',self::ERROR_404));
		$note_info = $m->table('notepad')->where("np_id = '{$_GET['npid']}'")->select();
		$note_info = $note_info[0];
		//拼接记事本详情中的图片信息
		$pic_list = array(); 
		if($note_info['np_attachment'] != ''){
			$m2 = M();
			$tmp_pic_list = $m->field('ca_id,ca_name,ca_type')->table('attachment')->where(array('ca_id'=>array('in',$note_info['np_attachment'])))->select();
			$allow_type = array('gif','jpg','jpeg','bmp','png');
			if(!empty($tmp_pic_list)){
				foreach ($tmp_pic_list as $k=>$v){
					if(in_array($v['ca_type'], $allow_type)){
						$pic_list[] = array('url'=>SiteUrl.'/upload/file/'.$v['ca_name'],'imgid'=>$v['ca_id']);
					}
				}
			}
		}
		$note_info['pic_list'] = $pic_list;
		if(empty($note_info)) {
			echo $this->callback('data not found');exit();
		}
		echo $this->callback($note_info);
	}
	/**
	 * 内部公告
	 * 
	 */
	private function _ntlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$count = $m->field('count(*) as count')->table('notice,noticetext')->join('LEFT JOIN')->on('notice.nt_nttid=noticetext.ntt_id')->where("notice.nt_recid = 0 OR notice.nt_recid = {$_GET['uid']}")->select();
		$notice_list = $m->field('noticetext.ntt_id,noticetext.ntt_title,noticetext.ntt_content,noticetext.ntt_sendtime')->table('notice,noticetext')->join('LEFT JOIN')->on('notice.nt_nttid=noticetext.ntt_id')->where("notice.nt_recid = 0 OR notice.nt_recid = {$_GET['uid']}")->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($notice_list)))<=0?false:true;
		//处理数组信息
		$ntt_id_string = '';
		if(!empty($notice_list)){
			foreach ($notice_list as $k=>$v){
				$ntt_id_string .= $v['ntt_id'].',';
			}
			$ntt_id_string = trim($ntt_id_string,',');
			$nread_list = $m->field('ntread_nttid,ntread_state')->table('noticeread')->where("ntread_uid = '{$_GET['uid']}' AND ntread_nttid in ({$ntt_id_string})")->select();
			foreach ($notice_list as $k=>$v){
				$notice_list[$k]['isread'] = 0;
				$notice_list[$k]['isdel']  = 0;
				if(!empty($nread_list)){
					foreach ($nread_list as $rk=>$rv){
						if($v['ntt_id'] == $rv['ntread_nttid']){
							$notice_list[$k]['isread'] = 1;
							$notice_list[$k]['isdel']  = $rv['ntread_state']==2?1:0;
						}
					}
				}
			}
		}
		echo $this->callback($notice_list,200,$addon);
	}
	/**
	 * 内部公告详情
	 * 
	 */
	private function _ntdetail(){
		$m = M();
		if (intval($_GET['ntid']) <= 0) exit($this->callback('',self::ERROR_404));
		$notice_info = $m->table('noticetext')->where("ntt_id = {$_GET['ntid']}")->select();
		$notice_info = $notice_info[0];
		if(empty($notice_info)){
			echo $this->callback('data not found');exit();
		} 
		echo $this->callback($notice_info);
	}
	/**
	 * 检测未读公告
	 * @return int $num
	 */
	private function _ntcheck(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$notice_list = $m->field('noticetext.ntt_id,noticetext.ntt_title')->table('notice,noticetext')->join('LEFT JOIN')->on('notice.nt_nttid=noticetext.ntt_id')->where("notice.nt_recid = 0 OR notice.nt_recid = {$_GET['uid']}")->select();
		//处理数组信息
		$ntt_id_string = '';
		if(!empty($notice_list)){
			foreach ($notice_list as $k=>$v){
				$ntt_id_string .= $v['ntt_id'].',';
			}
			$ntt_id_string = trim($ntt_id_string,',');
			$nread_list = $m->field('ntread_nttid,ntread_state')->table('noticeread')->where("ntread_uid = '{$_GET['uid']}' AND ntread_nttid in ({$ntt_id_string})")->select();
			foreach ($notice_list as $k=>$v){
				if(!empty($nread_list)){
					foreach ($nread_list as $rk=>$rv){
						if($v['ntt_id'] == $rv['ntread_nttid']){
							unset($notice_list[$k]);
						}
					}
				}
			}
		}
		echo $this->callback(count($notice_list));
	}
	/**
	 * 会员列表
	 * 
	 */
	private function _cclist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		//分析当前员工的权限范围
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['shop_id'] = $shop_id;
		$where_condition['cc_isdel']     = 0;
		$where_condition['cc_tostaffid'] = 0;
		if(trim($_GET['filter']) == 'sea'){
			$where_condition['cc_insea'] = 1;
		}else{
			$where_condition['cc_insea'] = 0;
			switch (trim($_GET['filter'])){
				case 'qy':
					$where_condition['cc_type'] = 1;
					break;
				case 'gr':
					$where_condition['cc_type'] = 2;
					break;
				case 'potential':
					$where_condition['cc_ispotential'] = 1;
					break;
				case 'trash':
					$where_condition['cc_isdel'] = 1;
					break;
			}
		}
		if(trim($_GET['search']) != ''){
			$where_condition['cc_name'] = array('like','%'.trim($_GET['search']).'%');
		}
		//调取会员数据
		$count = $m->field('count(*) as count')->table('customer')->where($where_condition)->select();
		$customer_list = $m->field('customer.cc_id,cc_name,cc_shortname,cc_type,cc_insea,cc_ispotential,cc_important,cc_province,cc_city,cc_district,cc_industry,company_info.cci_staff_size')->table('customer,company_info')->join('LEFT JOIN')->on('customer.cc_id=company_info.cc_id')->where($where_condition)->order('cc_addtime desc')->limit($start,$size)->select();
		//处理数组信息
		if(!empty($customer_list)){
			$dic_array = include '../cache/dictionary.php';
			foreach ($customer_list as $k=>$v){
				$customer_list[$k]['cc_industry'] = $dic_array['industry']['child_option'][$v['cc_industry']]['cd_name'];
				$customer_list[$k]['cci_staff_size'] = $dic_array['staff_size']['child_option'][$v['cci_staff_size']]['cd_name'];
			}
		}
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($customer_list)))<=0?false:true;
		echo $this->callback($customer_list,200,$addon);
	}
	/**
	 * 会员详情
	 * 
	 */
	private function _ccdetail(){
		$m = M();
		if (intval($_GET['ccid']) <= 0) exit($this->callback('',self::ERROR_404));
		if (intval($_GET['cctype']) <= 0) exit($this->callback('',self::ERROR_404));
		$customer_info = $m->table('customer')->where(array('cc_id'=>intval($_GET['ccid'])))->select();
		$customer_info = $customer_info[0];
		if(empty($customer_info)){
			echo $this->callback('data not found');exit();
		}else{
			switch (intval($_GET['cctype'])){
				case 1:
					$table = 'company_info';
					break;
				case 2:
					$table = 'personal_info';
					break;
			}
			$m2 = M();
			$customer_add_info = $m2->table($table)->where(array('cc_id'=>intval($_GET['ccid'])))->select();
			$customer_add_info = $customer_add_info[0];
			if(is_array($customer_add_info)){
				$customer_info = array_merge($customer_info,$customer_add_info);
			}
			//处理数组信息
			$dic_array = include '../cache/dictionary.php';
			$customer_info['cc_class'] = $dic_array['customer_class']['child_option'][$customer_info['cc_class']]['cd_name'];
			$customer_info['cc_industry'] = $dic_array['industry']['child_option'][$customer_info['cc_industry']]['cd_name'];
			$customer_info['cc_relationship'] = $dic_array['relationship']['child_option'][$customer_info['cc_relationship']]['cd_name'];
			$customer_info['cc_from'] = $dic_array['customer_from']['child_option'][$customer_info['cc_from']]['cd_name'];
			$customer_info['cc_worktag'] = $dic_array['work_tag']['child_option'][$customer_info['cc_worktag']]['cd_name'];
			if(intval($_GET['cctype'] == 1)){
				$customer_info['cci_staff_size'] = $dic_array['staff_size']['child_option'][$customer_info['cci_staff_size']]['cd_name'];
			}
			/*自定义字段的处理*/
			$tmp_self_field_array = unserialize($customer_info['cc_self_field']);
			$self_field_array = array();
			if(!empty($tmp_self_field_array)){
				$m3 = M();
				$selfdic_array = $m3->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>1))->select();
				$selfdic_show = array();
				if(is_array($selfdic_array) && !empty($selfdic_array)){
					foreach ((array)$selfdic_array as $k=>$v){
						if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
							$tmp_child_list = array();
							foreach ((array)$selfdic_array as $ck=>$cv){
								if($cv['cd_parent_id'] == $v['cd_id']){
									$tmp_child_list[$cv['cd_id']] = $cv;
								}
							}
							$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
							unset($tmp_child_list);
						}
					}
				}
				foreach ($tmp_self_field_array as $k=>$v){
					$self_field_array[$selfdic_show[$k]['field_name']] = $selfdic_show[$k]['child_option'][$v]['cd_name'];
				}
				$customer_info['cc_self_field'] = $self_field_array;
			}else{
				$customer_info['cc_self_field'] = array();
			}
			//处理员工姓名部分
			$m4 = M();
			$user_list = $m4->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',$customer_info['cc_staff_id'] == $customer_info['cc_addstaffid']?$customer_info['cc_staff_id']:$customer_info['cc_staff_id'].','.$customer_info['cc_addstaffid'])))->select();
			$customer_info['cc_staff_name']   = '';
			$customer_info['cc_addstaffname'] = '';
			if(!empty($user_list)){
				foreach ($user_list as $k=>$v){
					if($v['user_id'] == $customer_info['cc_staff_id']){
						$customer_info['cc_staff_name'] = $v['user_truename'];
					}
					if($v['user_id'] == $customer_info['cc_addstaffid']){
						$customer_info['cc_addstaffname'] = $v['user_truename'];
					}
				}
			}
			unset($customer_info['cc_mall']);
			unset($customer_info['cc_mallcid']);
			unset($customer_info['cc_tostaffid']);
			unset($customer_info['cc_transtime']);
			unset($customer_info['cc_getseatime']);
		}
		echo $this->callback($customer_info);
	}
	/**
	 * 会员关怀列表
	 */
	private function _carelist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['shop_id'] = $shop_id;
		$count = $m->field('count(*) as count')->table('customer_care,customer')->join('LEFT JOIN')->on('customer_care.cc_id=customer.cc_id')->where($where_condition)->select();
		$care_list = $m->field('care_id,care_subject,care_type')->table('customer_care,customer')->join('LEFT JOIN')->on('customer_care.cc_id=customer.cc_id')->where($where_condition)->order('care_id desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($care_list)))<=0?false:true;
		//处理数组信息
		if(!empty($care_list)){
			$dic_array = include '../cache/dictionary.php';
			foreach ($care_list as $k=>$v){
				$care_list[$k]['care_type'] = $dic_array['care_type']['child_option'][$v['care_type']]['cd_name'];
			}
		}
		echo $this->callback($care_list,200,$addon);
	}
	/**
	 * 会员关怀详情
	 */
	private function _caredetail(){
		$m = M();
		if (intval($_GET['careid']) <= 0) exit($this->callback('',self::ERROR_404));
		$care_info = $m->field('customer_care.*,customer.cc_name,customer.cc_type,company_contact.ccc_name')->table('customer_care,customer,company_contact')->join('LEFT JOIN')->on('customer_care.cc_id=customer.cc_id,customer_care.ccc_id=company_contact.ccc_id')->where(array('care_id'=>intval($_GET['careid'])))->select();
		$care_info = $care_info[0];
		if(empty($care_info)){
			echo $this->callback('data not found');exit();
		}
		//处理数组
		$dic_array = include '../cache/dictionary.php';
		$care_info['care_type'] = $dic_array['care_type']['child_option'][$care_info['care_type']]['cd_name'];
		echo $this->callback($care_info);
	}
	/**
	 * 会员跟踪日志
	 */
	private function _ccalist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['shop_id'] = $shop_id;
		$count = $m->field('count(*) as count')->table('customer_action,user,customer')->join('LEFT JOIN')->on('customer_action.cca_addstaff=user.user_id,customer_action.cc_id=customer.cc_id')->where($where_condition)->select();
		$cca_list = $m->field('customer_action.*,user.user_truename as cca_addstaffname')->table('customer_action,user,customer')->join('LEFT JOIN')->on('customer_action.cca_addstaff=user.user_id,customer_action.cc_id=customer.cc_id')->where($where_condition)->order('customer_action.cca_addtime desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($cca_list)))<=0?false:true;
		echo $this->callback($cca_list,200,$addon);
	}
	/**
	 * 订单列表
	 */
	private function _orderlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['shop_id'] = $shop_id;
		if(trim($_GET['search']) != ''){
			$where_condition['co_code'] = array('like','%'.trim($_GET['search']).'%');
		}
		$count = $m->field('count(*) as count')->table('orders,user')->join('LEFT JOIN')->on('orders.co_staff_id=user.user_id')->where($where_condition)->select();
		$order_list = $m->field('orders.co_id,orders.co_code,orders.co_status,orders.co_final_price,orders.late_delivery_time,user.user_truename as co_staff_name')->table('orders,user')->join('LEFT JOIN')->on('orders.co_staff_id=user.user_id')->where($where_condition)->order('orders.co_addtime desc')->limit($start,$size)->select();
		//处理数组
		if(!empty($order_list)){
			$dic_array = include '../cache/dictionary.php';
			foreach ($order_list as $k=>$v){
				$order_list[$k]['co_price'] = number_format($v['co_final_price'],2,'.','');
				unset($order_list[$k]['co_final_price']);
			}
		}
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($order_list)))<=0?false:true;
		echo $this->callback($order_list,200,$addon);
	}
	/**
	 * 订单详情
	 */
	private function _orderdetail(){
		$m = M();
		if (intval($_GET['coid']) <= 0) exit($this->callback('',self::ERROR_404));
		$co_info = $m->field('orders.*,customer.cc_name,address.*')->table('orders,customer,address')->join('LEFT JOIN')->on('orders.cc_id=customer.cc_id,orders.address_id=address.address_id')->where(array('co_id'=>intval($_GET['coid'])))->select();
		$co_info = $co_info[0];
		/*处理数组信息*/
		if(!empty($co_info)){
			//处理价格部分
			$co_info['co_return_money'] = number_format($co_info['co_return_money'],2,'.','');
			$co_info['co_total_price']  = number_format($co_info['co_total_price'],2,'.','');
			$co_info['co_final_price']  = number_format($co_info['co_final_price'],2,'.','');
			$co_info['co_cost_price']   = number_format($co_info['co_cost_price'],2,'.','');
			//涉及数据字典的部分
			$dic_array = include '../cache/dictionary.php';
			$co_info['co_type'] = $dic_array['ordertype']['child_option'][$co_info['co_type']]['cd_name'];
			$co_info['co_paymethod'] = $dic_array['paymethod']['child_option'][$co_info['co_paymethod']]['cd_name'];
			$co_info['currency_unit'] = $dic_array['currency_unit']['child_option'][$co_info['currency_unit']]['cd_name'];
			//自定义字段的处理
			$tmp_self_field_array = unserialize($co_info['co_self_field']);
			$self_field_array = array();
			if(!empty($tmp_self_field_array)){
				$m2 = M();
				$selfdic_array = $m2->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>4))->select();
				$selfdic_show = array();
				if(is_array($selfdic_array) && !empty($selfdic_array)){
					foreach ((array)$selfdic_array as $k=>$v){
						if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
							$tmp_child_list = array();
							foreach ((array)$selfdic_array as $ck=>$cv){
								if($cv['cd_parent_id'] == $v['cd_id']){
									$tmp_child_list[$cv['cd_id']] = $cv;
								}
							}
							$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
							unset($tmp_child_list);
						}
					}
				}
				foreach ($tmp_self_field_array as $k=>$v){
					$self_field_array[$selfdic_show[$k]['field_name']] = $selfdic_show[$k]['child_option'][$v]['cd_name'];
				}
				$co_info['co_self_field'] = $self_field_array;
			}else{
				$co_info['co_self_field'] = array();
			}
			//订单商品列表
			$m3 = M();
			$cop_list = $m3->field('order_product.*,product.cp_name')->table('order_product,product')->join('LEFT JOIN')->on('order_product.cp_id=product.cp_id')->where(array('co_id'=>$co_info['co_id']))->order('order_product.cop_id desc')->select();
			if(!empty($cop_list)){
				foreach ($cop_list as $k=>$v){
					$cop_list[$k]['cop_unitprice'] = number_format($v['cop_unitprice'],2,'.','');
					$cop_list[$k]['cop_total_price'] = number_format($v['cop_total_price'],2,'.','');
					$cop_list[$k]['cp_ori_price'] = number_format($v['cp_ori_price'],2,'.','');
					$cop_list[$k]['cp_cost'] = number_format($v['cp_cost'],2,'.','');
					unset($cop_list[$k]['cop_id']);
					unset($cop_list[$k]['cp_id']);
					unset($cop_list[$k]['co_id']);
					unset($cop_list[$k]['cop_lock']);
				}
			}
			$co_info['cop_list'] = $cop_list;
			//去掉无用数组信息
			unset($co_info['dl_info']);
			unset($co_info['co_mall']);
			unset($co_info['co_malloid']);
			unset($co_info['address_id']);
		}else{
			echo $this->callback('data not found');exit();
		}
		echo $this->callback($co_info);
	}
	/**
	 * 订单日志
	 */
	private function _orderlog(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['shop_id'] = $shop_id;
		$count = $m->field('count(*) as count')->table('order_log,orders,user')->join('LEFT JOIN')->on('order_log.co_id=orders.co_id,order_log.col_staff=user.user_id')->where($where_condition)->select();
		$orderlog_list = $m->field('order_log.*,orders.co_code,orders.late_delivery_time,user.user_truename as col_staffname')->table('order_log,orders,user')->join('LEFT JOIN')->on('order_log.co_id=orders.co_id,order_log.col_staff=user.user_id')->where($where_condition)->order('order_log.col_time desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($orderlog_list)))<=0?false:true;
		echo $this->callback($orderlog_list,200,$addon);
	}
	/**
	 * 发货单列表
	 */
	private function _shipmentlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['orders.shop_id'] = $shop_id;
		if(trim($_GET['search']) != ''){
			$where_condition['shipment_code'] = array('like','%'.trim($_GET['search']).'%');
		}
		$count = $m->field('count(*) as count')->table('shipment,orders')->join('LEFT JOIN')->on('shipment.co_id=orders.co_id')->where($where_condition)->select();
		$shipment_list = $m->field('shipment.shipment_id,shipment.shipment_code,shipment.shipment_verify,shipment.shipment_finish,orders.co_code')->table('shipment,orders')->join('LEFT JOIN')->on('shipment.co_id=orders.co_id')->where($where_condition)->order('shipment.addstaff_time desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($shipment_list)))<=0?false:true;
		echo $this->callback($shipment_list,200,$addon);
	}
	/**
	 * 发货单详情
	 */
	private function _shipmentdetail(){
		$m = M();
		if (intval($_GET['shipmentid']) <= 0) exit($this->callback('',self::ERROR_404));
		$shipment_info = $m->field('shipment.*,orders.co_code')->table('shipment,orders')->join('LEFT JOIN')->on('shipment.co_id=orders.co_id')->where(array('shipment_id'=>intval($_GET['shipmentid'])))->select();
		$shipment_info = $shipment_info[0];
		if(empty($shipment_info)){
			echo $this->callback('data not found');exit();
		}
		$shipment_info['shipment_info'] = unserialize($shipment_info['shipment_info']);
		//处理员工姓名部分
		$m4 = M();
		$user_list = $m4->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',$shipment_info['verify_staff'] == $shipment_info['shipment_staff']?$shipment_info['verify_staff']:$shipment_info['verify_staff'].','.$shipment_info['shipment_staff'])))->select();
		$shipment_info['verify_staff_name'] = '';
		$shipment_info['shipment_staff_name'] = '';
		if(!empty($user_list)){
			foreach ($user_list as $k=>$v){
				if($v['user_id'] == $shipment_info['verify_staff']){
					$shipment_info['verify_staff_name'] = $v['user_truename'];
				}
				if($v['user_id'] == $shipment_info['shipment_staff']){
					$shipment_info['shipment_staff_name'] = $v['user_truename'];
				}
			}
		}
		$dic_array = include '../cache/dictionary.php';
		$shipment_info['shipment_express'] = $dic_array['express_delivery']['child_option'][$shipment_info['shipment_express']]['cd_name'];
		echo $this->callback($shipment_info);
	}
	/**
	 * 发货日志
	 */
	private function _shipmentlog(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['orders.shop_id'] = $shop_id;
		$count = $m->field('count(*) as count')->table('shipment_log,shipment,user,orders')->join('LEFT JOIN')->on('shipment_log.shipment_id=shipment.shipment_id,shipment_log.csl_staff=user.user_id,orders.co_id=shipment.co_id')->where($where_condition)->select();
		$csl_list = $m->field('shipment_log.*,shipment.shipment_code,user.user_truename as csl_staff_name,orders.co_code')->table('shipment_log,shipment,user,orders')->join('LEFT JOIN')->on('shipment_log.shipment_id=shipment.shipment_id,shipment_log.csl_staff=user.user_id,orders.co_id=shipment.co_id')->where($where_condition)->order('shipment_log.csl_time desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($csl_list)))<=0?false:true;
		echo $this->callback($csl_list,200,$addon);
	}
	/**
	 * 收款单列表
	 */
	private function _incomelist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['search']) != ''){
			$where_condition['ci_code'] = array('like','%'.trim($_GET['search']).'%');
		}
		$count = $m->field('count(*) as count')->table('income,customer,orders')->join('LEFT JOIN')->on('customer.cc_id=income.cc_id,income.co_id=orders.co_id')->where($where_condition)->select();
		$income_list = $m->field('income.ci_id,income.ci_code,income.ci_money,income.ci_price_unit,income.ci_payback_time,orders.co_code,customer.cc_name')->table('income,customer,orders')->join('LEFT JOIN')->on('customer.cc_id=income.cc_id,income.co_id=orders.co_id')->where($where_condition)->order('income.ci_addtime desc')->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($income_list)))<=0?false:true;
		//处理数组信息
		if(!empty($income_list)){
			$dic_array = include '../cache/dictionary.php';
			foreach ($income_list as $k=>$v){
				$income_list[$k]['ci_price_unit']    = $dic_array['currency_unit']['child_option'][$v['ci_price_unit']]['cd_name'];
				$income_list[$k]['ci_money']         = number_format($v['ci_money'],2,'.','');
			}
		}
		echo $this->callback($income_list,200,$addon);
	}
	/**
	 * 收款单详情
	 */
	private function _incomedetail(){
		$m = M();
		if (intval($_GET['ciid']) <= 0) exit($this->callback('',self::ERROR_404));
		$ci_info = $m->field('income.*,orders.co_code,customer.cc_name')->table('income,customer,orders')->join('LEFT JOIN')->on('customer.cc_id=income.cc_id,income.co_id=orders.co_id')->where(array('ci_id'=>intval($_GET['ciid'])))->select();
		$ci_info = $ci_info[0];
		/*处理数组信息*/
		if(!empty($ci_info)){
			//处理员工姓名部分
			$m2 = M();
			$user_list = $m2->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',$ci_info['ci_addstaff'] == $ci_info['ci_excstaff']?$ci_info['ci_addstaff']:$ci_info['ci_addstaff'].','.$ci_info['ci_excstaff'])))->select();
			$ci_info['ci_addstaff_name'] = '';
			$ci_info['ci_excstaff_name'] = '';
			if(!empty($user_list)){
				foreach ($user_list as $k=>$v){
					if($v['user_id'] == $ci_info['ci_addstaff']){
						$ci_info['ci_addstaff_name'] = $v['user_truename'];
					}
					if($v['user_id'] == $ci_info['ci_excstaff']){
						$ci_info['ci_excstaff_name'] = $v['user_truename'];
					}
				}
			}
			$dic_array = include '../cache/dictionary.php';
			$ci_info['ci_price_unit']    = $dic_array['currency_unit']['child_option'][$ci_info['ci_price_unit']]['cd_name'];
			$ci_info['ci_paymethod']     = $dic_array['paymethod']['child_option'][$ci_info['ci_paymethod']]['cd_name'];
			$ci_info['ci_money']         = number_format($ci_info['ci_money'],2,'.','');
		}
		echo $this->callback($ci_info);
	}
	/**
	 * 退货单列表
	 */
	private function _returnlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition['orders.shop_id'] = $shop_id;
		if(trim($_GET['search']) != ''){
			$where_condition['cr_code'] = array('like','%'.trim($_GET['search']).'%');
		}
		$count = $m->field('count(*) as count')->table('returns,orders,customer')->join('LEFT JOIN')->on('returns.co_id=orders.co_id,customer.cc_id=returns.cc_id')->where($where_condition)->select();
		$return_list = $m->field('returns.cr_id,returns.cr_code,returns.cr_total_price,returns.currency_unit,returns.cr_addtime,orders.co_code,customer.cc_name')->table('returns,orders,customer')->join('LEFT JOIN')->on('returns.co_id=orders.co_id,customer.cc_id=returns.cc_id')->where($where_condition)->order('returns.cr_addtime desc')->limit($start,$size)->select();
		//处理数组信息
		if(!empty($return_list)){
			$dic_array = include '../cache/dictionary.php';
			foreach ($return_list as $k=>$v){
				$return_list[$k]['currency_unit']    = $dic_array['currency_unit']['child_option'][$v['currency_unit']]['cd_name'];
				$return_list[$k]['cr_total_price']   = number_format($v['cr_total_price'],2,'.','');
			}
		}
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($return_list)))<=0?false:true;
		echo $this->callback($return_list,200,$addon);
	}
	/**
	 * 退货单详情
	 */
	private function _returndetail(){
		$m = M();
		if (intval($_GET['crid']) <= 0) exit($this->callback('',self::ERROR_404));
		$cr_info = $m->field('returns.*,orders.co_code,customer.cc_name')->table('returns,orders,customer')->join('LEFT JOIN')->on('returns.co_id=orders.co_id,customer.cc_id=returns.cc_id')->where(array('cr_id'=>intval($_GET['crid'])))->select();
		$cr_info = $cr_info[0];
		/*处理数组信息*/
		if(!empty($cr_info)){
			//处理员工姓名部分
			$m2 = M();
			$user_list = $m2->field('user_id,user_truename')->table('user')->where(array('user_id'=>array('in',$cr_info['return_excstaff'] == $cr_info['refund_excstaff']?$cr_info['return_excstaff']:$cr_info['return_excstaff'].','.$cr_info['refund_excstaff'])))->select();
			$cr_info['return_excstaff_name'] = '';
			$cr_info['refund_excstaff_name'] = '';
			if(!empty($user_list)){
				foreach ($user_list as $k=>$v){
					if($v['user_id'] == $cr_info['return_excstaff']){
						$cr_info['return_excstaff_name'] = $v['user_truename'];
					}
					if($v['user_id'] == $cr_info['refund_excstaff']){
						$cr_info['refund_excstaff_name'] = $v['user_truename'];
					}
				}
			}
			$dic_array = include '../cache/dictionary.php';
			$cr_info['currency_unit']  = $dic_array['currency_unit']['child_option'][$cr_info['currency_unit']]['cd_name'];
			$cr_info['cr_total_price'] = number_format($cr_info['cr_total_price'],2,'.','');
			//退货商品列表
			$cr_content = unserialize($cr_info['cr_content']);
			if(!empty($cr_content)){
				foreach ($cr_content as $k=>$v){
					$cr_content[$k]['cp_unit'] = $dic_array['product_unit']['child_option'][$v['cp_unit']]['cd_name'];
				}
			}
			$cr_info['cr_content'] = $cr_content;
		}
		echo $this->callback($cr_info);
	}
	/**
	 * 商品分类
	 */
	private function _productclass(){
		$m = M();
		if (intval($_GET['pid']) < 0 || $_GET['pid'] == '') exit($this->callback('',self::ERROR_404));
		$pc_list = $m->field('pc_id,pc_name')->table('product_class')->where(array('pc_pid'=>intval($_GET['pid']),'pc_isdel'=>0))->order('pc_id asc')->select();
		if(empty($pc_list)){
			echo $this->callback('no child class');die;
		}
		echo $this->callback($pc_list);
	}
	/**
	 * 商品列表
	 */
	private function _productlist(){
		$m = M();
		if (intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		//分析当前员工的权限范围
		$where_condition = array();
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
		}
		$where_condition = array();
		if($_GET['classid'] != ''){
			$where_condition['cp_class'] = intval($_GET['classid']);
		}
		if(trim($_GET['search']) != ''){
			$where_condition['cp_name'] = array('like','%'.trim($_GET['search']).'%');
		}
		$where_condition['shop_id'] = $shop_id;
		$count = $m->field('count(*) as count')->table('product')->where($where_condition)->select();
		$product_list = $m->field('cp_id,cp_ori_price,cp_name,cp_pic,cp_code')->table('product')->where($where_condition)->order('cp_updatetime desc')->limit($start,$size)->select();
		//处理数组信息
		if(!empty($product_list)){
			foreach ($product_list as $k=>$v){
				$product_list[$k]['cp_ori_price'] = number_format($v['cp_ori_price'],2,'.','');
			}
		}
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($product_list)))<=0?false:true;
		echo $this->callback($product_list,200,$addon);
	}
	/**
	 * 商品详情
	 */
	private function _productdetail(){
		$m = M();
		if (intval($_GET['cpid']) <= 0) exit($this->callback('',self::ERROR_404));
		$cp_info = $m->field('product.*,user.user_truename as cp_addstaff_name')->table('product,user')->join('LEFT JOIN')->on('product.cp_updatestaff=user.user_id')->where(array('cp_id'=>intval($_GET['cpid'])))->select();
		$cp_info = $cp_info[0];
		/*处理数组信息*/
		if(!empty($cp_info)){
			$dic_array = include '../cache/dictionary.php';
			$cp_info['cp_ori_price'] = number_format($cp_info['cp_ori_price'],2,'.','');
			$cp_info['cp_lowest_price'] = number_format($cp_info['cp_lowest_price'],2,'.','');
			$cp_info['cp_cost'] = number_format($cp_info['cp_cost'],2,'.','');
			//价格策略
			$tmp_cp_saleprice = unserialize($cp_info['cp_saleprice']);
			$cp_saleprice = array();
			if(!empty($tmp_cp_saleprice)){
				foreach ($tmp_cp_saleprice as $k=>$v){
					$cp_saleprice[$dic_array['price_strategy']['child_option'][$k]['cd_name']] = number_format($v['price'],2,'.','').$dic_array['currency_unit']['child_option'][$v['currency_unit']]['cd_name'];
				}
			}
			$cp_info['cp_saleprice'] = $cp_saleprice;
			//自定义字段的处理
			$tmp_self_field_array = unserialize($cp_info['cp_self_field']);
			$self_field_array = array();
			if(!empty($tmp_self_field_array)){
				$m2 = M();
				$selfdic_array = $m2->table('dictionary')->where(array('cd_status'=>1,'cd_model_id'=>3))->select();
				$selfdic_show = array();
				if(is_array($selfdic_array) && !empty($selfdic_array)){
					foreach ((array)$selfdic_array as $k=>$v){
						if($v['cd_status'] == 1 && $v['cd_parent_id'] == 0){
							$tmp_child_list = array();
							foreach ((array)$selfdic_array as $ck=>$cv){
								if($cv['cd_parent_id'] == $v['cd_id']){
									$tmp_child_list[$cv['cd_id']] = $cv;
								}
							}
							$selfdic_show[$v['cd_id']] = array('field_name'=>$v['cd_name'],'p_id'=>$v['cd_id'],'child_option'=>$tmp_child_list);
							unset($tmp_child_list);
						}
					}
				}
				foreach ($tmp_self_field_array as $k=>$v){
					$self_field_array[$selfdic_show[$k]['field_name']] = $selfdic_show[$k]['child_option'][$v]['cd_name'];
				}
				$cp_info['cp_self_field'] = $self_field_array;
			}else{
				$cp_info['cp_self_field'] = array();
			}
			//杂项处理
			$cp_info['cp_class'] = $cp_info['pc_name'];
			unset($cp_info['cp_mall']);
			unset($cp_info['cp_mallpid']);
			unset($cp_info['cp_mallspec']);
			unset($cp_info['pc_name']);
		}
		echo $this->callback($cp_info);
	}
	/**
	 * 日程/任务类型
	 */
	private function _mschtype(){
		$dic_array = include '../cache/dictionary.php';
		$type_list = $dic_array['mission_type']['child_option'];
		//处理数组信息
		if(!empty($type_list)){
			foreach ($type_list as $k=>$v){
				if($v['cd_status'] == 0){
					unset($type_list[$k]);
				}
			}
		}
		echo $this->callback($type_list);
	}
	/**
	 * 获取会员联系人
	 */
	private function _getcontact(){
		$m = M();
		if (intval($_GET['ccid']) <= 0 || intval($_GET['cctype']) <= 0) exit($this->callback('',self::ERROR_404));
		$contact_list = array();
		switch (intval($_GET['cctype'])){
			case 1:
				$ccc_info = $m->field('ccc_id,ccc_name')->table('company_contact')->where(array('cc_id'=>intval($_GET['ccid'])))->select();
				$contact_list = $ccc_info;
				break;
			case 2:
				$cc_info = $m->field('cc_id,cc_name')->table('customer')->where(array('cc_id'=>intval($_GET['ccid'])))->select();
				$cc_info = $cc_info[0];
				$contact_list[] = array('ccc_id'=>0,'ccc_name'=>$cc_info['cc_name']);
				break;
		}
		echo $this->callback($contact_list);
	}
	/**
	 * 日周月报之报告管理列表（已经批复通过的只能查看不能编辑）
	 */
	private function _reportlist(){
		$m = M();
		if (trim($_GET['type']) == '' || intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		$count = $m->table('report')->where(array('rpt_userid'=>intval($_GET['uid']),'rpt_type'=>intval($_GET['type'])))->select();
		$report_list = $m->table('report')->where(array('rpt_userid'=>intval($_GET['uid']),'rpt_type'=>intval($_GET['type'])))->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($report_list)))<=0?false:true;
		echo $this->callback($report_list,200,$addon);
	}
	/**
	 * 日周月报之批复管理列表
	 */
	private function _reportreply(){
		$m = M();
		if (trim($_GET['type']) == '' || intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$page  = !is_numeric(intval($_GET['page']))?1:intval($_GET['page']);
		$size  = !is_numeric(intval($_GET['size']))?50:intval($_GET['size']);
		$start = ($page-1)*$size;
		//验证是否有批复权限
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		if(!$this->cPermission('report','reportreply',$user_info['user_jobpost'])) exit($this->callback('no permission'));
		$m2 = M();
		$count = $m2->table('report')->where(array('rpt_jpid'=>$user_info['user_jobpost'],'rpt_type'=>intval($_GET['type']),'rpt_issubmit'=>1))->select();
		$report_list = $m2->table('report')->where(array('rpt_jpid'=>$user_info['user_jobpost'],'rpt_type'=>intval($_GET['type']),'rpt_issubmit'=>1))->limit($start,$size)->select();
		$addon = array();
		$addon['count'] = $count[0]['count'];
		//计算是否还有其余数据
		$addon['haveMore'] = ($addon['count']-($size*($page-1)+count($report_list)))<=0?false:true;
		echo $this->callback($report_list,200,$addon);
	}
	/**
	 * 日周月报详情
	 */
	private function _reportdetail(){
		$m = M();
		if (intval($_GET['rptid']) <= 0) exit($this->callback('',self::ERROR_404));
		$report_info = $m->table('report')->where(array('rpt_id'=>intval($_GET['rptid'])))->select();
		$report_info = $report_info[0];
		echo $this->callback($report_info);
	}
	/**
	 * 调取系统数据字典
	 */
	private function _loaddict(){
		if (trim($_GET['type']) == '') exit($this->callback('',self::ERROR_404));
		$dic_array = include '../cache/dictionary.php';
		$dic_array = $dic_array[trim($_GET['type'])]['child_option'];
		//处理数组信息
		$return_arr = array();
		foreach ($dic_array as $k=>$v){
			if($v['cd_status'] == 1){
				$return_arr[] = array('cd_id'=>$v['cd_id'],'cd_name'=>$v['cd_name']);
			}
		}
		echo $this->callback($return_arr);
	}
	/**
	 * 调取店铺信息
	 */
	private function _shoplist(){
		$m = M();
		$shop_list = $m->field('shop_id,shop_name')->table('shop')->where(true)->select();
		echo $this->callback($shop_list);
	}
	/**********以下为写操作类接口**********/
	/**
	 * 日程
	 */
	private function _schw(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		if(trim($_POST['cs_subject']) == '' || intval($_POST['starttime']) <= 0) exit($this->callback('lack of param'));
		switch (trim($_POST['type'])){
			case 'add':
				if(intval($_POST['cc_id']) <= 0) exit($this->callback('lack of param'));
				$insert_array = array();
				$insert_array['cc_id'] = intval($_POST['cc_id']);
				$insert_array['cs_subject']  = trim($_POST['cs_subject']);
				$insert_array['cs_staff_id'] = intval($_POST['uid']);
				$insert_array['cs_addtime']  = time();
				$insert_array['cs_start_time'] = intval($_POST['starttime']);
				$insert_array['cs_end_time']   = intval($_POST['endtime']);
				$insert_array['cs_note'] = trim($_POST['cs_content']);
				$insert_array['cs_type'] = intval($_POST['cs_type']);
				//处理部门信息
				$m2 = M();
				$cc_info = $m2->field('cc_id,cc_dept_id')->table('customer')->where(array('cc_id'=>intval($_POST['cc_id'])))->select();
				$cc_info = $cc_info[0];
				$insert_array['cs_dp_id'] = $cc_info['cc_dept_id'];
				$rs = $m->table('schedule')->insert($insert_array);
				//插入到行动历史表中
				$insert_action_array = array();
				$insert_action_array['cc_id'] = intval($_POST['cc_id']);
				$insert_action_array['cca_addstaff'] = intval($_POST['uid']);
				$insert_action_array['cca_addtime']  = time();
				$insert_action_array['cca_content']  = trim($_POST['cs_subject']).'：'.trim($_POST['cs_content']);
				$insert_action_array['cca_start_time'] = intval($_POST['starttime']);
				$insert_action_array['cca_end_time'] = intval($_POST['endtime']);
				$insert_action_array['cca_excstaff'] = intval($_POST['uid']);
				$insert_action_array['cca_dp_id']    = $cc_info['cc_dept_id'];
				$m3 = M();
				$rs_act = $m3->table('customer_action')->insert($insert_action_array);
				if($rs && $rs_act){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			case 'edit':
				if(intval($_POST['cs_id']) <= 0) exit($this->callback('lack of param'));
				$update_array = array();
				$update_array['cc_id'] = intval($_POST['cc_id']);
				$update_array['cs_subject'] = trim($_POST['cs_subject']);
				$update_array['cs_start_time'] = intval($_POST['starttime']);
				$update_array['cs_end_time'] = intval($_POST['endtime']);
				$update_array['cs_note'] = trim($_POST['cs_content']);
				$update_array['cs_type'] = intval($_POST['cs_type']);
				$rs = $m->table('schedule')->where(array('cs_id'=>$_POST['cs_id']))->update($update_array);
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			default:
				echo $this->callback('type error');die;
		}
	}
	/**
	 * 待办任务
	 */
	private function _missionw(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		if(trim($_POST['cm_subject']) == '') exit($this->callback('lack of param'));
		switch (trim($_POST['type'])){
			case 'edit':
				//验证当前用户是否有权限修改该任务
				if(intval($_POST['cm_id']) <= 0) exit($this->callback('lack of param'));
				$cm_info = $m->table('mission')->where(array('cm_id'=>intval($_POST['cm_id']),'cm_addstaff'=>intval($_POST['uid'])))->select();
				$cm_info = $cm_info[0];
				if(empty($cm_info)){
					echo $this->callback('no permission');die;
				}
				$update_array = array();
				$update_array['cm_subject']  = trim($_POST['cm_subject']);
				$update_array['cm_priority'] = intval($_POST['cm_priority']);
				$update_array['cm_donedate'] = intval($_POST['donedate']);
				$update_array['cm_status']   = intval($_POST['cm_status']);
				$update_array['cm_type']     = intval($_POST['cm_type']);
				$update_array['cm_note']     = trim($_POST['cm_note']);
				$update_array['cc_id']       = intval($_POST['cc_id']);
				$update_array['cm_contact']  = intval($_POST['ccc_id']);
				$m2 = M();
				$rs = $m2->table('mission')->where(array('cm_id'=>$_POST['cm_id']))->update($update_array);
				//状态转变为“已完成”状态时向会员行动历史表中插入数据
				if($_POST['old_status'] !=0 && intval($_POST['cm_status']) == 0){
					$m3 = M();
					$insert_act_array = array();
					$insert_act_array['cc_id']          = intval($_POST['cc_id']);
					$insert_act_array['cca_addstaff']   = intval($_POST['uid']);
					$insert_act_array['cca_addtime']    = time();
					$insert_act_array['cca_content']    = trim($_POST['cm_subject']).'：'.trim($_POST['cm_note']);
					$insert_act_array['cca_start_time'] = time();
					$insert_act_array['cca_excstaff']   = trim($_POST['excstaff']);
					$insert_act_array['cca_ismission']  = 1;
					//处理部门信息
					$cc_info = $m3->table('customer')->where(array('cc_id'=>intval($_POST['cc_id'])))->find();
					$insert_action_array['cca_dp_id']   = $cc_info['cc_dept_id'];
					$m4 = M();
					$m4->table('customer_action')->insert($insert_act_array);
				}
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			default:
				echo $this->callback('type error');die;
		}
	}
	/**
	 * 记事本
	 */
	private function _npw(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		if(trim($_POST['np_title']) == '' || trim($_POST['np_content']) == '') exit($this->callback('lack of param'));
		switch (trim($_POST['type'])){
			case 'add':
				$insert_arr = array();
				$insert_arr['np_title']        = trim($_POST['np_title']);
				$insert_arr['np_executetime']  = intval($_POST['np_time']);
				//计算提醒时间
				if (intval($_POST['np_remindtime'])>0){
					$insert_arr['np_remindtime'] = $insert_arr['np_executetime'] - intval($_POST['np_remindtime'])*3600*24;
				}
				$insert_arr['np_content']  = trim($_POST['np_content']);
				$insert_arr['np_userid']   = intval($_POST['uid']);
				$insert_arr['np_username'] = trim($_POST['truename']);
				$insert_arr['np_addtime']  = time();
				$insert_arr['np_state']    = intval($_POST['np_state']);
				if(intval($_POST['img']) == 1){
					require_once './upload.class.php';
					$uploaddir = CRMBasePath.'/upload/file';
					$upload = new UploadFile();
        			$upload->set('default_dir',$uploaddir);
        			$result = $upload->upfile('uploadimg');
        			if($result){
        				$pic_array = array('ca_name'=>$upload->file_name,'ca_size'=>$_FILES['uploadimg']['size'],'ca_type'=>$upload->ext,'ca_model'=>'notepad','ca_addstaff'=>intval($_POST['uid']),'ca_addtime'=>time(),'ca_note'=>$_FILES['uploadimg']['name']);
        				$m2 = M();
        				$ca_id = $m2->table('attachment')->insert($pic_array);
        				$insert_arr['np_attachment'] = $ca_id;
        			}
				}
				$rs = $m->table('notepad')->insert($insert_arr);
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			case 'edit':
				$m2 = M();
				if(intval($_POST['np_id']) <= 0) exit($this->callback('lack of param'));
				$note_info = $m2->table('notepad')->where("np_id = '{$_POST['np_id']}'")->select();
				$note_info = $note_info[0];
				$update_arr = array();
				$update_arr['np_title']        = trim($_POST['np_title']);
				$update_arr['np_executetime']  = intval($_POST['np_time']);
				//计算提醒时间
				if (intval($_POST['np_remindtime'])>0){
					$update_arr['np_remindtime'] = $update_arr['np_executetime'] - intval($_POST['np_remindtime'])*3600*24;
				}else{
					$update_arr['np_remindtime'] = 0;
				}
				$update_arr['np_content'] = trim($_POST['np_content']);
				$update_arr['np_state']   = intval($_POST['np_state']);
				$update_arr['np_attachment'] = $note_info['np_attachment'];
				//删除图片
				if(trim($_POST['imgdel']) != ''){
					$tmp_del_img = explode(',', trim($_POST['imgdel']));
					$ori_img = explode(',', $note_info['np_attachment']);
					foreach ($ori_img as $k=>$v){
						if(in_array($v, $tmp_del_img)){
							unset($ori_img[$k]);
						}
					}
					$update_arr['np_attachment'] = implode(',', $ori_img);
					//清空attachment表数据并删除相关图片
					$m3 = M();
					$attdel_list = $m3->field('ca_id,ca_name')->table('attachment')->where(array('ca_id'=>array('in',trim($_POST['imgdel']))))->select();
					if(!empty($attdel_list)){
						foreach ($attdel_list as $k=>$v){
							unlink(CRMBasePath.'/upload/file/'.$v['ca_name']);
						}
					}
					$m4 = M();
					$m4->table('attachment')->where(array('ca_id'=>array('in',trim($_POST['imgdel']))))->delete();
				}
				//添加图片
				if(intval($_POST['img']) == 1){
					require_once './upload.class.php';
					$uploaddir = CRMBasePath.'/upload/file';
					$upload = new UploadFile();
        			$upload->set('default_dir',$uploaddir);
        			$result = $upload->upfile('uploadimg');
        			if($result){
        				$pic_array = array('ca_name'=>$upload->file_name,'ca_size'=>$_FILES['uploadimg']['size'],'ca_type'=>$upload->ext,'ca_model'=>'notepad','ca_addstaff'=>intval($_POST['uid']),'ca_addtime'=>time(),'ca_note'=>$_FILES['uploadimg']['name']);
        				$m2 = M();
        				$ca_id = $m2->table('attachment')->insert($pic_array);
        				$update_arr['np_attachment'] = $update_arr['np_attachment']==''?$ca_id:$update_arr['np_attachment'].','.$ca_id;
        			}
				}
				$rs = $m->table('notepad')->where(array('np_id'=>intval($_POST['np_id'])))->update($update_arr);
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			default:
				echo $this->callback('type error');die;	
		}
	}
	/**
	 * 内部公告
	 */
	private function _ntw(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		if(trim($_POST['n_title']) == '' || trim($_POST['n_content']) == '') exit($this->callback('lack of param'));
		switch (trim($_POST['type'])){
			case 'edit':
				if(intval($_POST['nttid']) <= 0) exit($this->callback('lack of param'));
				$update_arr = array();
				$update_arr['ntt_title']   = trim($_POST['n_title']);
				$update_arr['ntt_content'] = trim($_POST['n_content']);
				$update_arr['ntt_istop']   = intval($_POST['istop'])==1?1:0;
				$rs = $m->table('noticetext')->where(array('ntt_id'=>intval($_POST['nttid']),'ntt_senduid'=>intval($_POST['uid'])))->update($update_arr);
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			default:
				echo $this->callback('type error');die;
		}
	}
	/**
	 * 日周月报
	 */
	private function _reportw(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		$m2 = M();
		switch (trim($_POST['type'])){
			case 'day':
				if(trim($_POST['summary_content']) == '') exit($this->callback('lack of param'));
				$date = date('Y-m-d',time());
				if(!empty($_GET['date'])){
					$date = $_GET['date'];
				}
				if(!empty($_POST['r_time'])){
					$date = $_POST["r_time"];
				}
				$datetime = ($t = strtotime($date))>0?$t:0;
				$reportinfo = $m2->table('report')->where(array('rpt_userid'=>intval($_POST['uid']),'rpt_type'=>0,'rpt_recordtime'=>$datetime))->select();
				$reportinfo = $reportinfo[0];
				$this->reportexc(0, $datetime, $user_info, $reportinfo);
				break;
			case 'week':
				if(trim($_POST['summary_content']) == '') exit($this->callback('lack of param'));
				//查询本周报告记录
				$end_num = 0;//本周的前num周
				if(!empty($_POST['r_num'])){
					$end_num = intval($_POST['r_num']);
				}
				$end_time = strtotime("{$end_num} week Sunday");
				$start_time = $end_time - 86400*6;
		
				$start_date = date('Y-m-d',$start_time);
				$end_date   = date('Y-m-d',$end_time);
				
				$where = array();
				$where['rpt_userid'] = intval($_POST['uid']);
				$where['rpt_type']   = 1;
				$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
				$reportinfo = $m2->table('report')->where($where)->find();
				$reportinfo = $reportinfo[0];
				$this->reportexc(1, $end_time, $user_info, $reportinfo);
				break;
			case 'month':
				if(trim($_POST['summary_content']) == '') exit($this->callback('lack of param'));
				//年
				$year_arr  = $this->getSystemYearArr();
				//月
				$month_arr = $this->getSystemMonthArr();
				//查询本月报告记录
				$year = date('Y');
				$month = date('m');
				if(!empty($_POST['r_year']) && !empty($_POST['r_month'])){
					$year = intval($_POST['r_year']);
					$month = intval($_POST['r_month']);
				}
				if(!in_array($year,$year_arr) || !in_array($month,$month_arr)){
					$year = date('Y');
					$month = date('m');
				}
				$start_time = mktime(0, 0, 0, $month, 1, $year);
				$end_time   = mktime(0, 0, 0, $month+1, 0, $year);
				
				$where = array();
				$where['rpt_userid'] = intval($_POST['uid']);
				$where['rpt_type']   = 2;
				$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
				$reportinfo = $m2->table('report')->where($where)->select();
				$reportinfo = $reportinfo[0];
				$this->reportexc(2, $end_time, $user_info, $reportinfo);
				break;
			case 'replyday':
				//查询当日报告记录	
				if(!empty($_POST['r_time']) && !empty($_POST['uid'])){
					$date = $_POST["r_time"];
					$uid = $_POST['uid'];
				}
				if(empty($date) || empty($uid)){
					echo $this->callback('param error');exit();
				}
				$datetime   = strtotime($date);
				$reportinfo = $m2->table('report')->where(array('rpt_userid'=>$uid,'rpt_type'=>0,'rpt_recordtime'=>$datetime,'rpt_jpid'=>$user_info['user_jobpost'],'rpt_issubmit'=>1))->find();
				$reportinfo = $reportinfo[0];
				$this->replyexc($reportinfo);
				break;
			case 'replyweek':
				//查询本周报告记录
				$end_num = 0;
				if(isset($_POST['r_num']) && !empty($_POST['uid'])){
					$end_num = intval($_POST['r_num']);
					$uid = $_POST['uid'];
				}
				if(!isset($end_num) || empty($uid)){
					echo $this->callback('param error');exit();
				}
				$end_time = strtotime("{$end_num} week Sunday");
				$start_time = $end_time - 86400*6;
				$start_date = date('Y-m-d',$start_time);
				$end_date   = date('Y-m-d',$end_time);
				$where = array();
				$where['rpt_userid'] = $uid;
				$where['rpt_type']   = 1;
				$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
				$where['rpt_jpid']     = $user_info['user_jobpost'];
				$where['rpt_issubmit'] = 1;
				$reportinfo = $m2->table('report')->where($where)->select();
				$reportinfo = $reportinfo[0];
				$this->replyexc($reportinfo);
				break;
			case 'replymonth':
				//年
				$year_arr  = $this->getSystemYearArr();
				//月
				$month_arr = $this->getSystemMonthArr();
				//查询本月报告记录
				$year  = date('Y');
				$month = date('m');
				if(!empty($_POST['r_year']) && !empty($_POST['r_month'])){
					$year = intval($_POST['r_year']);
					$month = intval($_POST['r_month']);
					$uid = $_POST['uid'];
				}
				if(empty($uid) || !in_array($year,$year_arr) || !in_array($month,$month_arr)){
					echo $this->callback('param error');exit();
				}
				$start_time = mktime(0, 0, 0, $month, 1, $year);
				$end_time   = mktime(0, 0, 0, $month+1, 0, $year);
				$where = array();
				$where['rpt_userid'] = $uid;
				$where['rpt_type']   = 2;
				$where['rpt_recordtime'] = array(array('egt',$start_time),array('elt',$end_time),'and');
				$where['rpt_jpid']       = $user_info['user_jobpost'];
				$where['rpt_issubmit']   = 1;
				$reportinfo = $m2->table('report')->where($where)->select();
				$reportinfo = $reportinfo[0];
				$this->replyexc($reportinfo);
				break;
			default:
				echo $this->callback('type error');die;
		}
	}
	/**
	 * 报告记录的数据库写操作处理函数
	 * 
	 * @param $type 报告类型
	 * @param $recordtime 报告时间
	 * @param $reportinfo 报告内容
	 * @param $user_info 员工信息数组
	 */
	private function reportexc($type,$recordtime,$user_info,$reportinfo){
		$m = M();
		//查询需要报告给的岗位信息
		$jp_info = $m->table('jobpost')->where(array('jp_id'=>$user_info['user_jobpost'],'jp_state'=>'1'))->find();
		if(empty($jp_info)){
			echo $this->callback('system error');exit();
		}
		$m2 = M();
		if(empty($reportinfo)){
			$insert = array();
			$insert['rpt_userid']   = $user_info['user_id'];
			$insert['rpt_username'] = $user_info['user_truename'];
			$insert['rpt_jpid']     = $jp_info['jp_reportto'];
			$insert['rpt_type']     = $type;
			$insert['rpt_summary']  = $_POST["summary_content"];
			$insert['rpt_plan']     = $_POST["plan_content"];
			$insert['rpt_issubmit'] = $_POST['savetype'] == 'handin'?1:0;
			$insert['rpt_recordtime'] = $recordtime;
			$date = date('Y-m-d',time());
			$insert['rpt_submittime'] = strtotime($date);
			//计算延迟天数
			$insert['rpt_delaydays'] = ($t= ($insert['rpt_submittime'] - $insert['rpt_recordtime'])/86400) <= 0?0:$t;
			$rs = $m2->table('report')->insert($insert);
		}else{
			$update = array();
			$update['rpt_jpid']    = $jp_info['jp_reportto'];
			$update['rpt_summary'] = $_POST["summary_content"];
			$update['rpt_plan']    = $_POST["plan_content"];
			if($reportinfo['rpt_issubmit'] == 0){//第一次提交时，才记录提交时间
				$update['rpt_issubmit'] = $_POST['savetype'] == 'handin'?1:0;
				$date = date('Y-m-d',time());
				$update['rpt_submittime'] = strtotime($date);
				//计算延迟天数
				$update['rpt_delaydays']  = ($t= ($update['rpt_submittime'] - $reportinfo['rpt_recordtime'])/86400) <= 0?0:$t;
			}
			$rs = $m2->table('report')->where(array('rpt_id'=>$reportinfo['rpt_id']))->update($update);
		}
		if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }exit();
	}
	/**
	 * 批复报告的数据库写操作处理函数
	 */
	private function replyexc($reportinfo){
		//报告信息数组不能为空
		if(empty($reportinfo)){
			echo $this->callback('system error');exit();
		}
		//审批状态不能为空
		if(empty($_POST["ispass"])){
			echo $this->callback('please choose review status');exit();
		}
		$m = M();
		$update = array();
		if(in_array($_POST["ispass"],array(0,1,2))){
			$update['rpt_pass'] = $_POST["ispass"];
		}else{
			$update['rpt_pass'] = 0;
		}
		$update['rpt_replytext'] = $_POST["reply_content"];
		$rs = $m->table('report')->where(array('rpt_id'=>$reportinfo['rpt_id']))->update($update);
		if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }exit();	
	}
	/**
	 * 获得系统年份数组
	 */
	private function getSystemYearArr(){
		$year_arr = array('2010'=>'2010','2011'=>'2011','2012'=>'2012','2013'=>'2013','2014'=>'2014','2015'=>'2015','2016'=>'2016','2017'=>'2017','2018'=>'2018','2019'=>'2019','2020'=>'2020');
		return $year_arr;
	}
	/**
	 * 获得系统月份数组
	 */
	private function getSystemMonthArr(){
		$month_arr = array('1'=>'01','2'=>'02','3'=>'03','4'=>'04','5'=>'05','6'=>'06','7'=>'07','8'=>'08','9'=>'09','10'=>'10','11'=>'11','12'=>'12');
		return $month_arr;
	}
	/**
	 * 会员关怀
	 */
	private function _carew(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		if(trim($_POST['care_subject']) == '') exit($this->callback('lack of param'));
		switch (trim($_POST['type'])){
			case 'add':
				$insert_array = array();
				$insert_array['care_subject']  = trim($_POST['care_subject']);
				$insert_array['care_date']     = intval($_POST['care_date']);
				$insert_array['cc_id']         = intval($_POST['cc_id']);
				$insert_array['ccc_id']        = intval($_POST['ccc_id']);
				$insert_array['care_content']  = trim($_POST['care_content']);
				$insert_array['care_type']     = intval($_POST['care_type']);
				$insert_array['care_feedback'] = trim($_POST['care_feedback']);
				$insert_array['care_note']     = trim($_POST['care_note']);
				$insert_array['care_addstaff'] = intval($_POST['uid']);
				$insert_array['care_addtime']  = time();
				$rs = $m->table('customer_care')->insert($insert_array);
				//插入会员行动历史表中
				$insert_act_array = array();
				$insert_act_array['cc_id']          = intval($_POST['ccid']);
				$insert_act_array['cca_addstaff']   = intval($_POST['uid']);
				$insert_act_array['cca_addtime']    = time();
				$insert_act_array['cca_content']    = trim($_POST['care_subject']).'：'.trim($_POST['care_content']);
				$insert_act_array['cca_start_time'] = time();
				$insert_act_array['cca_excstaff']   = intval($_POST['uid']);
				$insert_act_array['cca_ismission']  = 2;
				$m2  = M();
				$rsa = $m2->table('customer_action')->insert($insert_act_array);
				if($rs && $rsa){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			case 'edit':
				if(intval($_POST['careid']) <= 0) exit($this->callback('lack of param'));
				$update_array = array();
				$update_array['care_subject']  = trim($_POST['care_subject']);
				$update_array['care_date']     = intval($_POST['care_date']);
				$update_array['cc_id']         = intval($_POST['cc_id']);
				$update_array['ccc_id']        = intval($_POST['ccc_id']);
				$update_array['care_content']  = trim($_POST['care_content']);
				$update_array['care_type']     = intval($_POST['care_type']);
				$update_array['care_feedback'] = trim($_POST['care_feedback']);
				$update_array['care_note']     = trim($_POST['care_note']);
				$rs = $m->table('customer_care')->where(array('care_id'=>intval($_POST['careid'])))->update($update_array);
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			default:
				echo $this->callback('type error');die;
		}
	}
	/**
	 * 订单
	 */
	private function _orderw(){
		$m = M();
		if(trim($_POST['type']) == '' || intval($_POST['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		switch (trim($_POST['type'])){
			case 'editstatus':
				//验证当前用户是否有权限修改订单状态
				$user_info = $m->table('user')->where("user_id = {$_POST['uid']}")->select();
				$user_info = $user_info[0];
				if(!$this->cPermission('order','order_edit',$user_info['user_jobpost'])) exit($this->callback('no permission'));
				if($_POST['co_status'] == '' || intval($_POST['coid']) <= 0) exit($this->callback('lack of param'));
				$rs = $m->table('orders')->where(array('co_id'=>intval($_POST['coid'])))->update(array('co_status'=>intval($_POST['co_status'])));
				if($rs){ echo $this->callback('success'); }else{ echo $this->callback('failed'); }
				break;
			default:
				echo $this->callback('type error');die;
		}
	}
	/**********特殊类型接口**********/
	/**
	 * 会员列表坐标版
	 */
	private function _cclistzb(){
		$m = M();
		if(intval($_GET['uid']) <= 0) exit($this->callback('',self::ERROR_404));
		$where_condition = "cc_isdel=0 and cc_tostaffid=0";
		if(trim($_GET['lat'])!='' && trim($_GET['lng'])!='' && trim($_GET['r']) == ''){
			$range_array = $this->getaround(floatval($_GET['lat']), floatval($_GET['lng']), intval($_GET['r']));
			$where_condition .= " and cc_lat > ".$range_array[0]." and cc_lat < ".$range_array[1]." and cc_lng > ".$range_array[2]." and cc_lng < ".$range_array[3];
		}
		//会员数据范围
		$user_info = $m->table('user')->where("user_id = {$_GET['uid']}")->select();
		$user_info = $user_info[0];
		if(empty($user_info)){
			echo $this->callback('userinfo not found');exit();
		}
		if(trim($_GET['shop_id']) != ''){
			$shop_id = intval($_GET['shop_id']);
			$where_condition .= " and shop_id=".$shop_id;
		}else{
			if($user_info['user_shopid'] > 0){
				$shop_id = $user_info['user_shopid'];
			}else{
				echo $this->callback('need choose shop');exit();
			}
			$where_condition .= " and shop_id=".$shop_id;
		}
		$cc_list = $m->field('cc_id,cc_name,cc_lat,cc_lng')->table('customer')->where($where_condition)->select();
		echo $this->callback($cc_list);
	}
	/**********以下为通用函数**********/
	/**
	 * 返回数据函数
	 * 
	 * @param $data 返回数据
	 * @param $code 返回标识,默认200
	 */
	private function callback($data,$code=200,$addon=array()){
		if (strtoupper(CHARSET) == 'GBK'){
			$data = charset($data,'GBK','UTF-8');
		}
		if ($_GET['debug'] == '1'){
			if ($code != 200){
				echo $code;exit;
			}else{
				echo '<pre>';
				print_R($data);
				echo '</pre>';
				exit();
			}
		}else{
			return json_encode(array('code'=>$code,'datas'=>$data,'count'=>!empty($addon)?$addon['count']:'0','haveMore'=>!empty($addon)?$addon['haveMore']:false));
		}
	}
	/**
	 * 验证数据权限
	 * 
	 * @param $module 模块名称
	 * @param $jp_id 员工岗位ID
	 */
	private function cDataPermission($module,$jp_id){
		$m = M();
		/*查询员工所在岗位信息和权限信息*/
		$pdata_arr = array();
		$jp_info = $m->table('jobpost,permission')->join('LEFT JOIN')->on('jobpost.jp_permissionid=permission.pmn_id')->where(array('jp_id'=>$jp_id))->select();
		$jp_info = $jp_info[0];
		//数据权限
		$pdata_arr['data']   = $jp_info['pmn_dataright'];
		
		if ($pdata_arr['data'] == ''){
			return array('data'=>'own','operate'=>'edit');
		}elseif ($pdata_arr['data'] == 'all'){
			return array('data'=>'all','operate'=>'edit');
		}
		$p_arr = unserialize($pdata_arr['data']);
		if ($p_arr['type'] == 'common'){
			return $p_arr['info'];
		}else{
			if (isset($p_arr['info'][$module]) && !empty($p_arr['info'][$module])){
				return $p_arr['info'][$module];
			}else {//模块未设置默认为仅个人数据
				return array('data'=>'own','operate'=>'all');
			}
		}
	}
	/**
	 * 验证当前员工权限是否可以进行操作
	 *
	 */
	private function cPermission($act='',$op='',$jp_id){
		//不需要验证的act
		$nocheck_act = array('seccode','commondata','index','profiles','notepad');
		if (in_array($act,$nocheck_act)){
			return true;
		}
		//不需要验证的op
		$nocheck_op = array('noticelist','noticeinfo','noticehide','reportlist','reportweeklist','reportmonthlist','reportdayadd','reportweekadd','reportmonthadd','customer_view','care_view','mission_view','schedule_view','order_view','shipment_view','income_view','return_view','bill_view','product_view','get_contact','ajax_upload_file','class_edit','class_add','ajax_productpic_upload','get_seacustomer','status_batch_switch','transfer_confirm','userview');
		if (in_array($op,$nocheck_op)){
			return true;
		}
		$m = M();
		if(intval($jp_id) <= 0){ return false; }
		/*查询员工所在岗位信息和权限信息*/
		$pdata_arr = array();
		$jp_info = $m->table('jobpost,permission')->join('LEFT JOIN')->on('jobpost.jp_permissionid=permission.pmn_id')->where(array('jp_id'=>$jp_id))->select();
		$jp_info = $jp_info[0];
		//访问权限
		$pdata_arr['access'] = $jp_info['pmn_accessright'];
		if($pdata_arr['access'] == 'all') return true;
		$permission_arr = array();
		if(!empty($pdata_arr['access'])){
			$permission_arr = explode(',',$pdata_arr['access']);
		}
		//验证op
		if (in_array($op,$permission_arr)){
			return true;
		}
		return false;
	}
	/**
	 * 商圈经纬度范围计算函数(单位：米)
	 * 
	 * @param int $lat 纬度
	 * @param int $lng 经度
	 * @param int $raidus 半径
	 * @return array (minlat,maxlat,minlng,maxlng)经纬度范围
	 */
	private function getaround($lat,$lng,$raidus){
		$pi = 3.1415926;
		$degree = (24901*1609)/360.0;
		$dpmlat = 1/$degree;
		$raiduslat = $dpmlat*$raidus;
		$minlat = $lat-$raiduslat;
		$maxlat = $lat+$raiduslat;
		
		$mpdlng = $degree*cos($lat*($pi/180));
		$dpmlng = 1/$mpdlng;
		$raiduslng = $dpmlng*$raidus;
		$minlng = $lng-$raiduslng;
		$maxlng = $lng+$raiduslng;
		return array($minlat,$maxlat,$minlng,$maxlng);
	}
	/**
	 * 计算两个坐标之间的距离（单位：千米）
	 * 
	 * @param $lat1,$lng1,$lat2,$lng2(两个坐标的经纬度)
	 * @return $s距离
	 */
	private function rad($d){  
	    return $d * 3.1415926535898 / 180.0;  
	} 
	private function getdistance($lat1, $lng1, $lat2, $lng2){
		$EARTH_RADIUS = 6378.137;  
		$radLat1 = $this->rad($lat1);  
		$radLat2 = $this->rad($lat2);  
		$a = $radLat1 - $radLat2;  
		$b = $this->rad($lng1) - $this->rad($lng2);  
		$s = 2 * asin(sqrt(pow(sin($a/2),2) +  
		cos($radLat1)*cos($radLat2)*pow(sin($b/2),2)));  
		$s = $s *$EARTH_RADIUS;  
		$s = round($s * 10000) / 10000;  
		return $s;  
	}
}
new run();