<!DOCTYPE HTML>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
<title>Bizpower Mobile Chart</title>
<script type="text/javascript" src="chartshow/jquery.min.js"></script>
<script type="text/javascript" src="chartshow/highcharts.js"></script>
<script type="text/javascript">
$(function () {
    var chart;
    $(document).ready(function() {
        chart = new Highcharts.Chart({
            chart: {
                renderTo: 'container',
                type: 'column'
            },
            title: {
                text: '<?php echo $output['title']; ?>',
                style: {
                	color:'#c11010',
                	fontSize:'24px'
                },
                y:20
            },
            xAxis: {
                categories: [
                             <?php foreach ($output['x_name'] as $val){?>
                             '<?php echo $val; ?>',
                             <?php } ?>
                ],
                labels: {
                	style: {
                    	fontSize:'14px'
                    },
                    y:20
                }
            },
            yAxis: {
                min: 0,
                title: {
                    text: ''
                },
                labels: {
                	style: {
                    	fontSize:'20px'
                    }
                }
            },
            tooltip: {
                formatter: function() {
                    return ''+
                        this.x +':'+ this.y;
                }
            },
            plotOptions: {
                column: {
                    pointPadding: 0.3,
                    borderWidth: 1
                }
            },
            series: [{
                data: [<?php echo $output['data_string']; ?>]
            }],
            legend: {
            	enabled: false
            }
        });
    });
    
});
</script>
</head>
<body>
<?php if($output['error'] == ''){?>
<div id="container" style="width:100%;margin: 50px auto;"></div>
<?php }else{ ?>
<span style="color:#333;font-size:60px;min-width:480px;text-align:center;display:block;padding-top:100px"><?php echo $output['error']; ?></span>
<?php } ?>
</body>
</html>