/*
 *
 *  Wake.js
 *  (c) May 15 2005 by Dirk Lembens
 *  Latest Version 0.64
 *
 */

var hostnames;

function hostnameChanged()
{
	var select = document.getElementById('hostname-popup');
	hostname = hostnames[select.selectedIndex +1];
	document.getElementById("hostnameLabel").innerText = hostname;
}

//
// Wakes up selected host
//

function wake()
{
	document.getElementById("doButton").src = "Images/Button_down.png";

	// get selected hostname
	var select = document.getElementById('hostname-popup');
	hostname = hostnames[select.selectedIndex +1];
	// document.getElementById("outputText").value = hostname;

	// get hostname from input field
	// hostname = document.getElementById("inputText").value;

	// get path to WakeOnLan.app's simple text file
	path = widget.system("/bin/bash -c 'echo -n ~'", null).outputString;
	hostfile = path + "/Library/Preferences/com.readpixel.wakeonlan.hosts.txt"

	// run shell command 'python ./wake.pl iMac 123.45.67.8 00:01:02:03:04:05'
	// we use awk to print the first column with "_____" delimiters directly before and behind
	// the hostname, and search for _____hostname_____ to avoid multiple grep finds for hosts
	// with similar names, e.g. "Dirk iMac" and "iMac" would return two lines instead of one.
	cmd = "/bin/bash -c 'python ./wake.pl `cat " + hostfile + " | awk -f ./print3columnslimiter.awk | grep -ai _____" + hostname + "_____`'";

	// cmd = "/bin/bash -c 'python ./wake.pl `cat " + hostfile + " | grep -ai " + hostname + "`'";
	// alert (cmd);
	err = widget.system(cmd, null).outputString;

	// document.getElementById("outputText").value = err;
}

function showWebsite()
{
}

//
// When the action button is clicked upon or clicked on, moused out, and moused up,
// it needs to be replaced by the unactive version of the button.
//

function buttonUpOut()
{
	document.getElementById("doButton").src = "Images/Button.png";
}

//
// Updates the host popup menu with the actual WakeOnLan host list
//

function populateHostnamesPopup()
{
	// remember current selection
	var select = document.getElementById('hostname-popup');
	index = select.selectedIndex;
	if (index >= 0) {
		oldHostname = hostnames[index +1];
	} else {
		oldHostname = "";
	}

	// remove old entries
	while (select.hasChildNodes())
		select.removeChild(select.firstChild);
	
	// get path to WakeOnLan.app's simple text file
	path = widget.system("/bin/bash -c 'echo -n ~'", null).outputString;
	hostfile = path + "/Library/Preferences/com.readpixel.wakeonlan.hosts.txt";

	// read known WakeOnLan host names
	cmd = "/bin/bash -c 'awk \"{ print \\$1 }\" \"" + hostfile + "\"'";
	ret = widget.system(cmd, null).outputString;

	// return if no host list
	if (!ret) return -1;

	// split into strings, ignore first (WakeOnLan) and last (empty) row
	hostnames = ret.split("\n");

	// check for success (first entry is 'WakeOnLan')
	if (hostnames[0] != "WakeOnLan") { return -1; }
	numHosts = hostnames.length - 2;

	// add each hostname to the popup menu
	for (var j=1; j<=numHosts; j++) {	
	    	var element = document.createElement("option");
		hostname = hostnames[j];
	        element.innerText = hostname;
        	element.setAttribute("name", hostname);
        	select.appendChild(element);
     	}

	// re-select old selection
    	select.options[0].selected = true;
	for (j=1; j<=numHosts; j++) {
		if (hostnames[j] == oldHostname) 
			select.options[j-1].selected = true;
	}

	// set label text to popup selection
	var select = document.getElementById('hostname-popup');
	hostname = hostnames[select.selectedIndex +1];
	document.getElementById("hostnameLabel").innerText = hostname;
}

//
// Widget init, set function called each time widget is shown
//

function setupWidget() 
{
	populateHostnamesPopup();

	widget.onshow = onshown;
	widget.onhide = onhide;

	// create 'done' button
	var doneButton = document.getElementById('done');
	createGenericButton (doneButton, "Done", selectDone);
	doneButton.childNodes[1].style.minWidth = '30px';

	// hide backside
	var backElement = document.getElementById ('back');
	back.style.display="none";
}

//
// Update host popup each time widget is shown
//

function onshown () 
{
	populateHostnamesPopup();
}

function onhide() {
    // document.getElementById ('from_text_area').blur();
    // document.getElementById ('to_text_area').blur();
}

//
// what follows is the huge code needed for the "i" fade in and out
// copied from Apple's Translate Widget
//

var flipAnimation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, element:null, timer:null};
var flipShown = false;
var kAnimationFrameMilliseconds = 13;

function enterflip(event)
{
    document.getElementById('flip_rollie').style.display = 'block';
}

function exitflip(event)
{
    document.getElementById('flip_rollie').style.display = 'none';
}

function limit_3 (a, b, c) {
    return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
    return from + (to - from) * ease;
}

function flipAnimate()
{
	var T;
	var ease;
	var time = (new Date).getTime();
		
	
	T = limit_3(time-flipAnimation.starttime, 0, flipAnimation.duration);
	
	if (T >= flipAnimation.duration)
	{
		clearInterval (flipAnimation.timer);
		flipAnimation.timer = null;
		flipAnimation.now = flipAnimation.to;
	}
	else
	{
		ease = 0.5 - (0.5 * Math.cos(Math.PI * T / flipAnimation.duration));
		flipAnimation.now = computeNextFloat (flipAnimation.from, flipAnimation.to, ease);
	}
	
	flipAnimation.element.style.opacity = flipAnimation.now;
}

function mousemove (event)
{
	if (!flipShown)
	{
		// fade in the flip widget
		if (flipAnimation.timer != null)
		{
			clearInterval (flipAnimation.timer);
			flipAnimation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - kAnimationFrameMilliseconds; // set it back one frame
		
		flipAnimation.duration = 500;
		flipAnimation.starttime = starttime;
		flipAnimation.element = document.getElementById ('flip');
		flipAnimation.timer = setInterval ("flipAnimate();", kAnimationFrameMilliseconds);
		flipAnimation.from = flipAnimation.now;
		flipAnimation.to = 1.0;
		flipAnimate();
		flipShown = true;
	}
}

function mouseexit (event)
{
	if (flipShown)
	{
		// fade in the flip widget
		if (flipAnimation.timer != null)
		{
			clearInterval (flipAnimation.timer);
			flipAnimation.timer  = null;
		}
		
		var starttime = (new Date).getTime() - kAnimationFrameMilliseconds; // set it back one frame
		
		flipAnimation.duration = 500;
		flipAnimation.starttime = starttime;
		flipAnimation.element = document.getElementById ('flip');
		flipAnimation.timer = setInterval ("flipAnimate();", kAnimationFrameMilliseconds);
		flipAnimation.from = flipAnimation.now;
		flipAnimation.to = 0.0;
		flipAnimate();
		flipShown = false;
	}
	
}

function showbackside(event) 
{
	if( flipShown )
	{
		var front = document.getElementById("front");
		// var frontimage = document.getElementById("front_ImageDiv");
		var back = document.getElementById("back");

		if (window.widget)
			widget.prepareForTransition("ToBack");
	
		front.style.display="none";
		// frontimage.style.display="none";
		back.style.display="block";
	
		if (window.widget)
			setTimeout('widget.performTransition();', 0);
				
		document.getElementById('flip_rollie').style.display = "none";
		flipShown = false;
	}
}

function selectDone ()
{
	var front = document.getElementById("front");
	// var frontimage = document.getElementById("front_ImageDiv");
	var back = document.getElementById("back");

	if (window.widget)
		widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	// frontimage.style.display="block";
	back.style.display="none";
	
	if (window.widget)
		setTimeout('widget.performTransition();', 0);
				
	// onshow();
}
