<?php
/*
  $Id: index.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" dir="<?php echo $osC_Language->getTextDirection(); ?>" xml:lang="<?php echo $osC_Language->getCode(); ?>" lang="<?php echo $osC_Language->getCode(); ?>">

<head>

<meta http-equiv="Content-Type" content="text/html; charset=<?php echo $osC_Language->getCharacterSet(); ?>" />
<meta http-equiv="x-ua-compatible" content="ie=7" />
<link rel="shortcut icon" href="templates/<?php echo $osC_Template->getCode(); ?>/images/tomatocart.ico" type="image/x-icon" />

<title><?php echo ($osC_Template->hasMetaPageTitle() ? $osC_Template->getMetaPageTitle() . ' - ' : '') . STORE_NAME; ?></title>
<base href="<?php echo osc_href_link(null, null, 'AUTO', false); ?>" />

<link rel="stylesheet" type="text/css" href="templates/<?php echo $osC_Template->getCode(); ?>/stylesheet.css" />
<link rel="stylesheet" type="text/css" href="ext/autocompleter/Autocompleter.css" />

<!--[if IE]>
<style type="text/css">
  #productInfoTab a {
    top:11px;
  }
  
  #productInfoTab a.unselect {
    top:13px;
  }
</style>
<![endif]-->
<?php
  if ($osC_Template->hasPageTags()) {
    echo $osC_Template->getPageTags();
  }

  if ($osC_Template->hasJavascript()) {
    $osC_Template->getJavascript();
  }
  
  if ($osC_Template->hasStyleSheet()) {
    $osC_Template->getStyleSheet();
  }
  
  $navigations = $osC_Template->getNavigation();
?>

<meta name="Generator" content="TomatoCart" />
</head>
<body>

<div class="block">
  <ul>
    <?php if ($osC_Customer->isLoggedOn()) { ?>
      <li>
        <?php echo osc_link_object(osc_href_link(FILENAME_ACCOUNT, 'logoff', 'SSL'), '[退出]'); ?>
      </li>
    <?php } else { ?>
      <li>
        <?php echo osc_link_object(osc_href_link(FILENAME_ACCOUNT, 'login', 'SSL'), '[登录]'); ?>
      </li>
    <?php } ?>
    
    <li class="create">
      <?php echo osc_link_object(osc_href_link(FILENAME_ACCOUNT, 'create', 'SSL'), '[注册]'); ?>
    </li>
    
    <?php
      if (is_array($navigations['top']) && sizeof($navigations['top']) > 0 ) {
        foreach ($navigations['top'] as $navigation) {
          echo '<li>' . osc_link_object($navigation['url'], $navigation['name'], 'target=' . $navigation['target']) . '</li>';
        }
      }
    ?>
    
    <li class="cart">
      <?php echo osc_link_object(osc_href_link(FILENAME_CHECKOUT, null, 'SSL'), '<span id="popupCart">' . osc_image('templates/' . $osC_Template->getCode() . '/images/shopping_cart_icon.png') . '<span>购物车</span>' . '<span id="popupCartItems">' . $osC_ShoppingCart->numberOfItems() . '</span>' . '<span>' . '件商品' . '</span></span>') ; ?>
    </li>
  </ul>
</div>

<?php
  if ($osC_Template->hasPageHeader()) {
?>

<div id="pageHeader">
  <div id="headerBar">
    <div style="float: right; margin-top: 20px; width: 372px;">
      <form name="search" action="<?php echo osc_href_link(FILENAME_SEARCH, null, 'NONSSL', false);?>" method="get" style="float: right;">
        <?php
          $osC_CategoryTree->setSpacerString('&nbsp;', 2);

          $categories_array = array(array('id' => '', 'text' => $osC_Language->get('filter_all_categories')));
        
          foreach ($osC_CategoryTree->buildBranchArray(0) as $category) {
            $categories_array[] = array('id' => $category['id'],
                                        'text' => $category['title']);
          }
        
          echo osc_draw_pull_down_menu('cPath', $categories_array);
        ?>
        <?php echo osc_draw_input_field('keywords', '', 'maxlength="20"') ?>
        <input type="image" src="<?php echo 'templates/' . $osC_Template->getCode() . '/images/button_quick_find.png'; ?>" alt="<?php echo $osC_Language->get('box_search_heading'); ?>" title="<?php echo $osC_Language->get('box_search_heading'); ?>" id="quickSearch" /><?php echo osc_draw_hidden_session_id_field(); ?>
      </form>
      
      <div id="popular_search">
        <ul>
          <li style="color: red;">热门搜索：</li>
          <?php 
            $Qterms = $osC_Database->query('select search_terms_id, text, search_count from :table_search_terms where show_in_terms = 1 order by search_count DESC limit 5');
            $Qterms->bindTable(':table_search_terms', TABLE_SEARCH_TERMS);
            $Qterms->setCache('box-popular-search-terms', BOX_POPULAR_SEARCH_TERM_CACHE);
            $Qterms->execute();
            
            $search_terms = array();
            while($Qterms->next()) {
              echo '<li><a href="' . osc_href_link(FILENAME_SEARCH, 'keywords=' . $Qterms->value('text')) . '">' . $Qterms->value('text') . '</a></li>';
            }
          ?>
        </ul>
      </div>
    </div>
    
    <?php
      echo osc_link_object(osc_href_link(FILENAME_DEFAULT), osc_image($osC_Template->getLogo(), STORE_NAME), 'id="siteLogo"');
    ?>
  </div>
  
  <?php
    if (is_array($navigations['center']) && sizeof($navigations['center']) > 0 ) {
  ?>
  <div id="navigationBar">
    <div id="navigationInner">
      <ul id="navigation">
        <?php
          foreach ($navigations['center'] as $navigation) {
            echo '<li>' . osc_link_object($navigation['url'], $navigation['name'], 'target=' . $navigation['target']) . '</li>';
          }
        ?>
      </ul>
    </div>
  </div>
  <?php
    }
  ?>
  
  <?php
      if ($osC_Services->isStarted('breadcrumb')) {
  ?>
      <div id="breadcrumbPath">
      <?php
        echo $breadcrumb->trail(' &raquo; ');
      ?>
      </div>
  <?php
    }
  ?>
</div>

<?php
}
?>
  
<?php 
  $slideshow = $osC_Template->getContentGroup('幻灯片区域');
  if ($slideshow !== false) {
?>  
<div id="slideShow">
     <?php echo $slideshow; ?>
</div>
<?php    
  }
?>

<div id="pageWrapper">

  <?php
    $content_left = $osC_Template->getBoxGroup('左侧区域');

    if (!empty($content_left)) {
  ?>

    <div id="pageColumnLeft">
      <div class="boxGroup">
	      <?php
	          echo $content_left;
	      ?>
      </div>
      <div style="clear: both;"></div>
    </div>

  <?php
    } 
  ?>
  
    <div id="pageContent">
      <?php
        if ($messageStack->size('header') > 0) {
          echo $messageStack->output('header');
        }

        if ($osC_Template->hasPageContentModules()) {
          foreach ($osC_Services->getCallBeforePageContent() as $service) {
            $$service[0]->$service[1]();
          }

          $content_before = $osC_Template->getContentGroup('前置区域');
          if (!empty($content_before)) {
            echo $content_before;
          }
        }

        if ($osC_Template->getCode() == DEFAULT_TEMPLATE) {
          include('templates/' . $osC_Template->getCode() . '/content/' . $osC_Template->getGroup() . '/' . $osC_Template->getPageContentsFilename());
        } else {
          if (file_exists('templates/' . $osC_Template->getCode() . '/content/' . $osC_Template->getGroup() . '/' . $osC_Template->getPageContentsFilename())) {
            include('templates/' . $osC_Template->getCode() . '/content/' . $osC_Template->getGroup() . '/' . $osC_Template->getPageContentsFilename());
          } else {
            include('templates/' . DEFAULT_TEMPLATE . '/content/' . $osC_Template->getGroup() . '/' . $osC_Template->getPageContentsFilename());
          }
        }
      ?>

      <div style="clear: both;"></div>

      <?php
        if ($osC_Template->hasPageContentModules()) {
          foreach ($osC_Services->getCallAfterPageContent() as $service) {
            $$service[0]->$service[1]();
          }
        
          $content_after = $osC_Template->getContentGroup('后置区域');
          if (!empty($content_after)) {
            echo $content_after;
          }
        }
      ?>
      <div style="clear: both;"></div>
    </div>


  <?php
    if ( empty($content_left) ) {
  ?>
      <style type="text/css"><!--
      #pageContent, #pageBlockLeft{
        width:960px;
      }
      
      .moduleBox h1, .moduleBox h6 {
        background: #f3f3f3 url(<?php echo 'templates/' . $osC_Template->getCode() . '/images/content_header_long_bg.png'; ?>) repeat-x left top;
      }
      
      .productlistingbox {
        background: url(<?php echo 'templates/' . $osC_Template->getCode() . '/images/content_header_long_bg.png'; ?>) repeat-x scroll left top #F3F3F3;
      }
      --></style>
  <?php
      unset($content_left);
    }
  ?>
  <div style="clear: both;"></div>
</div>

<div>
  <?php 
    $article_categories_list = $osC_Template->getContentGroup('底部区域');
    if ($article_categories_list !== false) {
      echo $article_categories_list;
    }
  ?>
</div>

<?php 
  if ($osC_Template->hasPageFooter()) {
?>
  <div id="pageFooter">
    <ul>
      <?php
        echo '<li>' . osc_link_object(osc_href_link(FILENAME_DEFAULT, 'index'), $osC_Language->get('home')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_PRODUCTS, 'specials'), $osC_Language->get('specials')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_PRODUCTS, 'new'), $osC_Language->get('new_products')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_ACCOUNT, null, 'SSL'), $osC_Language->get('my_account')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_ACCOUNT, 'wishlist', 'SSL'), $osC_Language->get('my_wishlist')) . '<span>|</span></li>' .     
             '<li>' . osc_link_object(osc_href_link(FILENAME_CHECKOUT, null, 'SSL'), $osC_Language->get('cart_contents')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_CHECKOUT, 'checkout', 'SSL'), $osC_Language->get('checkout')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_INFO, 'contact'), $osC_Language->get('contact_us')) . '<span>|</span></li>'.
             '<li>' . osc_link_object(osc_href_link(FILENAME_INFO, 'guestbook'), $osC_Language->get('guest_book')) . '<span>|</span></li>' .
             '<li>' . osc_link_object(osc_href_link(FILENAME_DEFAULT, 'rss'), osc_image(DIR_WS_IMAGES . 'rss16x16.png') . '<span>RSS</span>') . '</li>';
      ?>
    </ul>
    <div style="clear:both"></div>
    <p style="margin: 3px;">
      <?php
        echo sprintf($osC_Language->get('footer'), date('Y'), osc_href_link(FILENAME_DEFAULT), STORE_NAME);
      ?>
    </p>
  </div>  
<?php 
    if ($osC_Services->isStarted('banner') && $osC_Banner->exists('468x60')) {
      echo '<p align="center">' . $osC_Banner->display() . '</p>';
    }
  }
?>

<script type="text/javascript" src="ext/autocompleter/Autocompleter.js"></script>
<script type="text/javascript" src="ext/autocompleter/Autocompleter.Request.js"></script>
<script type="text/javascript" src="ext/autocompleter/Observer.js"></script>
<script type="text/javascript" src="includes/javascript/auto_completer.js"></script>
<script type="text/javascript" src="includes/javascript/popup_cart.js"></script>
<script type="text/javascript" src="includes/javascript/bookmark.js"></script>

<script type="text/javascript">
  window.addEvent('domready', function() {
    new PopupCart({
      template: '<?php echo $osC_Template->getCode(); ?>',
      sessionName: '<?php echo $osC_Session->getName(); ?>',
      sessionId: '<?php echo $osC_Session->getID(); ?>'
    });
    
    new TocAutoCompleter('keywords', {
      sessionName: '<?php echo $osC_Session->getName(); ?>',
      sessionId: '<?php echo $osC_Session->getID(); ?>',
      template: '<?php echo $osC_Template->getCode(); ?>',
      width: 300
    });
  });
</script>

<?php
  if ($osC_Services->isStarted('piwik')) {
    echo $toC_Piwik->renderJs();
  }
?>
</body>
</html>