<?php
/*
  $Id: shopping_cart.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
?>

<?php
  if ($messageStack->size('shopping_cart') > 0) {
    echo $messageStack->output('shopping_cart');
  }
?>

<?php
  if ($osC_ShoppingCart->hasContents()) {
?>

<form name="shopping_cart" action="<?php echo osc_href_link(FILENAME_CHECKOUT, 'action=cart_update', 'SSL'); ?>" method="post">

<div class="moduleBox">
  <h6><?php echo $osC_Language->get('shopping_cart_heading'); ?></h6>

  <div class="content" id="shoppingCartList">
    <table cellspacing="0">
      <tbody>
        <tr>
          <th><?php echo '商品编号'; ?></th>
          <th><?php echo '商品名称'; ?></th>
          <th><?php echo '市场价'; ?></th>
          <th><?php echo '商城价'; ?></th>
          <th><?php echo '商品数量'; ?></th>
          <th><?php echo '删除'; ?></th>
        </tr>
        <?php
          foreach ($osC_ShoppingCart->getProducts() as $products_id => $products) {
            $market_price_total += $products['market_price'] * $products['quantity'];
            $weight_total += $products['weight'];
        ?>
        <tr class="products">
          <td><?php echo $products['sku']; ?></td>
          <td align="left" class="productsName">
            <?php
              echo osc_link_object(osc_href_link(FILENAME_PRODUCTS, $products['id']), $osC_Image->show($products['image'], $products['name'], '', 'mini') . $products['name']);

              if ( (STOCK_CHECK == '1') && ($osC_ShoppingCart->isInStock($products['id']) === false) ) {
                echo '<span class="markProductOutOfStock">' . STOCK_MARK_PRODUCT_OUT_OF_STOCK . '</span>';
              }
        
              if (isset($products['error'])) {
                echo '<br /><span class="markProductError">' . $products['error'] . '</span>';
                $osC_ShoppingCart->clearError($products_id);
              }
              
              if ($products['type'] == PRODUCT_TYPE_GIFT_CERTIFICATE) {
                echo '<br />- ' . $osC_Language->get('senders_name') . ': ' . $products['gc_data']['senders_name'];
                
                if ($products['gc_data']['type'] == GIFT_CERTIFICATE_TYPE_EMAIL) {
                  echo '<br />- ' . $osC_Language->get('senders_email')  . ': ' . $products['gc_data']['senders_email'];
                }
                
                echo '<br />- ' . $osC_Language->get('recipients_name') . ': ' . $products['gc_data']['recipients_name'];
                
                if ($products['gc_data']['type'] == GIFT_CERTIFICATE_TYPE_EMAIL) {
                  echo '<br />- ' . $osC_Language->get('recipients_email')  . ': ' . $products['gc_data']['recipients_email'];
                }
                
                echo '<br />- ' . $osC_Language->get('message')  . ': ' . $products['gc_data']['message'];
              }
              
              $atttributes_array = array();
        
              if ($osC_ShoppingCart->hasVariants($products['id'])) {
                foreach ($osC_ShoppingCart->getVariants($products['id']) as $variants) {
                  $atttributes_array[$variants['groups_id']] = $variants['variants_values_id'];
        
                  echo '<br />- ' . $variants['groups_name'] . ': ' . $variants['values_name'];
                }
              }
            
              if ( isset($products['customizations']) && !empty($products['customizations']) ) {
            ?>
              <p>
            <?php      
              foreach ($products['customizations'] as $key => $customization) {
            ?>
              <div style="float: left">
                <?php echo osc_draw_input_field('products[' . $products_id . '][' . $key . ']', $customization['qty'], 'size="4" style="width: 20px"') . ' x '; ?>
              </div>
              <div style="margin-left: 40px">
                <?php
                  foreach ($customization['fields'] as $field) {
                    echo $field['customization_fields_name'] . ': ' . $field['customization_value'] . '<br />';
                  }
                ?>
              </div>
              <div style="clear: both"></div>
            <?php } ?>
              </p>
          <?php } ?>
          </td>
          <td><?php echo $osC_Currencies->displayPrice($products['market_price'] , $products['tax_class_id']); ?></td>
          <td style="color: red;"><?php echo $osC_Currencies->displayPrice($products['price'] , $products['tax_class_id']); ?></td>
          <td>
            <?php echo osc_draw_image_submit_button('button_update_cart-1.gif', $osC_Language->get('button_update_cart'), 'id="button_decrease_' . $products_id . '"'); ?>
            <?php echo osc_draw_input_field('products[' . $products_id . ']', $products['quantity'], 'id="products_' . $products_id. '" size="4" style="width: 40px"'); ?>
            <?php echo osc_draw_image_submit_button('button_update_cart-2.gif', $osC_Language->get('button_update_cart'), 'id="button_add_' . $products_id . '"'); ?>
          </td>
          <td>
          <?php
            $variants_string = null;
            if (!is_numeric($products_id) && (strpos($products_id, '#') != false)) {
              $tmp = explode('#', $products_id);
              $variants_string = $tmp[1];
            }
             
            echo osc_link_object(osc_href_link(FILENAME_CHECKOUT, osc_get_product_id($products_id) . (!empty($variants_string) ? '&variants=' . $variants_string : '') . '&action=cart_remove', 'SSL'), osc_draw_image_button('small_delete.gif', $osC_Language->get('button_delete')));
          ?>
          </td>
        </tr>
        <?php
          }
        ?>
        <tr>
          <td valign="top" colspan="6" align="right">
            <span><?php echo '重量总计：'. $osC_Weight->display($weight_total, SHIPPING_WEIGHT_UNIT) . '&nbsp;&nbsp;&nbsp;&nbsp;' . '原始金额&nbsp;' . $osC_Currencies->displayPrice($osC_ShoppingCart->getSubTotal() , $products['tax_class_id']) . ',' . '比市场价&nbsp;' . $osC_Currencies->displayPrice($market_price_total, $products['tax_class_id']) . '&nbsp;节省了&nbsp;' . $osC_Currencies->displayPrice(($market_price_total - $osC_ShoppingCart->getSubTotal()), $products['tax_class_id']); ?></span>
            <br />
            <span style="font-size: 14px;font-weight: bold;"><?php echo '商品总金额:' ?><font color="red"><?php echo $osC_Currencies->displayPrice($osC_ShoppingCart->getSubTotal(), $products['tax_class_id']); ?></font></span>
          </td>
        </tr>
      </tbody>
    </table>
    
    <div style="text-align: right; margin: 15px 10px 10px 0;">
      <span><?php echo osc_draw_image_submit_button('button_continue_shopping.gif', $osC_Language->get('button_continue_shopping'), 'onclick="javascript:history.go(-1);return false;"'); ?></span>
      <span><?php echo osc_link_object(osc_href_link(FILENAME_JSON, 'module=cn_checkout&action=check_shipping_address', 'SSL'), osc_draw_image_button('button_checkout.gif', $osC_Language->get('button_checkout'))); ?></span>
    </div>
  </div>

<?php
    if ( (STOCK_CHECK == '1') && ($osC_ShoppingCart->hasStock() === false) ) {
      if (STOCK_ALLOW_CHECKOUT == '1') {
        echo '<p class="stockWarning" align="center">' . sprintf($osC_Language->get('products_out_of_stock_checkout_possible'), STOCK_MARK_PRODUCT_OUT_OF_STOCK) . '</p>';
      } else {
        echo '<p class="stockWarning" align="center">' . sprintf($osC_Language->get('products_out_of_stock_checkout_not_possible'), STOCK_MARK_PRODUCT_OUT_OF_STOCK) . '</p>';
      }
    }
?>

</div>

</form>
  <?php
    $initialize_checkout_methods = $payment_modules->get_checkout_initialization_methods();
    
    if ( !empty($initialize_checkout_methods) && is_array($initialize_checkout_methods) ) {
      reset($initialize_checkout_methods);
    
  ?>
  
    <div align="right">
      <?php 
        foreach($initialize_checkout_methods as $value) {
          echo $value;
        }        
      ?>
    </div>
    
  <?php 
    } 
  } else {
?>

<p><?php echo $osC_Language->get('shopping_cart_empty'); ?></p>

<div style="text-align: right; margin: 15px 10px 10px 0;">
  <?php echo osc_link_object(osc_href_link(FILENAME_DEFAULT), osc_draw_image_button('button_continue.gif', $osC_Language->get('button_continue'))); ?>
</div>

<?php
  }
?>

<script type="text/javascript">
  window.addEvent('domready', function(){
    <?php
      foreach ($osC_ShoppingCart->getProducts() as $products_id => $products) {
    ?>
      $('button_decrease_<?php echo $products_id; ?>').addEvent('click', function(e) {
        $('products_<?php echo $products_id; ?>').value = $('products_<?php echo $products_id; ?>').value.toInt() - 1; 
      }.bind(this));
      
      $('button_add_<?php echo $products_id; ?>').addEvent('click', function(e) {
        $('products_<?php echo $products_id; ?>').value = $('products_<?php echo $products_id; ?>').value.toInt() + 1; 
      }.bind(this));
    <?php
      }
    ?>
  });
</script>