<?php
/*
  $Id: cn_shipping_address_details.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
?>

<?php
  $Qaddresses = osC_AddressBook::getListing();
  
  while ($Qaddresses->next()) {
    $address_book_id = $Qaddresses->valueInt('address_book_id');
?>
<div class="moduleBox">
  <h6><?php echo $osC_Language->get('shipping_address_title'); ?></h6>
  <div class="content">
    <form action="json.php?module=cn_checkout&action=save_shipping_address" method="post" name="shippingAddressDetailsForm" id="shippingAddressDetailsForm">
      <table cellspacing="1" cellpadding="5" border="0" bgcolor="" align="center" width="99%" id="shipping_address_table">
        <tbody>
          <tr>
            <td><?php echo $osC_Language->get('table_heading_shipping_address'); ?></td>
            <td colspan="3">
              <ol>
                <li id="shipping-country-<?php echo $address_book_id; ?>">
                  <?php
                    $countries_array = array(array('id' => '',
                                             'text' => $osC_Language->get('pull_down_default')),
                                       array('id' => CHINA_COUNTRY_ID,
                                             'text' => '中国'));
                                       
                    $country_id = $Qaddresses->valueInt('country_id');
                    echo osc_draw_pull_down_menu('shipping_country_' . $address_book_id, $countries_array, $country_id, 'class="country" disabled="true"');
                  ?>
                </li>

                <li id="shipping-state-<?php echo $address_book_id; ?>">
                  <?php
                    $zones_array = array();
                    foreach (osC_Address::getZones($country_id) as $zone) {
                      $zones_array[] = array('id' => $zone['name'], 'text' => $zone['name']);
                    }

                    if ( $Qaddresses->valueInt('zone_id') > 0 ) {
                      $state = $Qaddresses->valueInt('zone_id');
                    }
                    
                    if (is_numeric($state)) {
                      $state = osC_Address::getZoneName($state);
                    }
                
                    if (sizeof($zones_array) > 0) {
                      echo osc_draw_pull_down_menu('shipping_state_' . $address_book_id, $zones_array, $state, 'disabled="true"');
                    } else {
                      echo osc_draw_input_field('shipping_state_' . $address_book_id, $state, 'disabled="true"');
                    }
                  ?>
                </li>
                
                <li id="shipping-city-<?php echo $address_book_id; ?>">
                  <?php
                    $cities_array = array();
                    if ($country_id == CHINA_COUNTRY_ID) {
                      if ($state == null) {
                        if (sizeof($zones_array) > 0) {
                          $state = $zones_array[0]['text'];
                        }
                      }
                      
                      if ($state !== null) {
                        foreach (toC_China_Address::getCities($state) as $region) {
                          $cities_array[] = array('id' => $region['name'], 'text' => $region['name']);
                        }        
                      }
                    }

                    $city = $Qaddresses->value('city');
                    if (sizeof($cities_array) > 0) {
                      echo osc_draw_pull_down_menu('shipping_city_' . $address_book_id, $cities_array, $city, 'disabled="true"');
                    } else {
                      echo osc_draw_input_field('shipping_city_' . $address_book_id, $city, 'disabled="true"');
                    }
                  ?>
                </li>
                
                <li id="shipping-suburb-<?php echo $address_book_id; ?>">
                  <?php
                    $suburb_array = array();
                    if ($country_id == CHINA_COUNTRY_ID) {
                      if ($city == null) {
                        if (sizeof($cities_array) > 0) {
                          $city = $cities_array[0]['text'];
                        }
                      }
                            
                      if ($city !== null) {
                        $city_id = toC_China_Address::getChinaRegionId($city, REGION_TYPE_CITY);
                        foreach (toC_China_Address::getDistricts($city_id) as $region) {
                          $suburb_array[] = array('id' => $region['name'], 'text' => $region['name']);
                        }        
                      }
                    }
                  
                    $suburb = $Qaddresses->value('suburb');
                    if (sizeof($suburb_array) > 0) {
                      echo osc_draw_pull_down_menu('shipping_suburb_' . $address_book_id, $suburb_array, $suburb, 'disabled="true"');
                    } else {
                      echo osc_draw_input_field('shipping_suburb_' . $address_book_id, $suburb, 'disabled="true"');
                    }
                  ?>
                </li>
              </ol>
            </td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_gender'); ?></td>
            <td>
              <?php
                $gender_array = array(array('id' => 'm', 'text' => $osC_Language->get('gender_male')),
                                      array('id' => 'f', 'text' => $osC_Language->get('gender_female')));
                
                echo osc_draw_radio_field('shipping_gender-' . $address_book_id, $gender_array, $Qaddresses->value('gender'), 'disabled="true"');
              ?>
            </td>
            <td><?php echo $osC_Language->get('field_customer_company'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_company-' . $address_book_id, $Qaddresses->value('company'), 'disabled="true"'); ?></td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_last_name'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_lastname-' . $address_book_id, $Qaddresses->value('lastname'), 'disabled="true"'); ?></td>
            <td><?php echo $osC_Language->get('field_customer_first_name'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_firstname-' . $address_book_id, $Qaddresses->value('firstname'), 'disabled="true"'); ?></td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_street_address'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_street_address-' . $address_book_id, $Qaddresses->value('street_address'), 'disabled="true"'); ?></td>
            <td><?php echo $osC_Language->get('field_customer_post_code'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_postcode-' . $address_book_id, $Qaddresses->value('postcode'), 'disabled="true"'); ?></td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_telephone_number'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_telephone-' . $address_book_id, $Qaddresses->value('telephone'), 'disabled="true"'); ?></td>
            <td><?php echo $osC_Language->get('field_customer_fax_number'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_fax-' . $address_book_id, $Qaddresses->value('fax'), 'disabled="true"'); ?></td>
          </tr>
          
          <tr>
            <td colspan="4" align="right">
              <?php echo osc_draw_image_submit_button('button_shipping_address.png', $osC_Language->get('button_continue'), 'style="cursor: pointer"'); ?>
            </td>
          </tr>
        </tbody>
      </table>
      
      <?php echo osc_draw_hidden_field('shipping_address_id', $address_book_id); ?>
    </form>
  </div>
</div>
<?php
  }
?>  
  
<div class="moduleBox">  
  <h6><?php echo $osC_Language->get('shipping_address_title'); ?></h6>
  <div class="content">
    <form name="shippingAddressDetailsForm" id="shippingAddressDetailsForm">
      <table cellspacing="1" cellpadding="5" border="0" bgcolor="" align="center" width="99%" id="shipping_address_table">
        <tbody>
          <tr>
            <td><?php echo $osC_Language->get('table_heading_shipping_address'); ?></td>
            <td colspan="3">
              <ol>
                <li id="shipping-country">
                  <?php
                    $countries_array = array(array('id' => '',
                                             'text' => $osC_Language->get('pull_down_default')),
                                       array('id' => '44',
                                             'text' => '中国'));

                    $country_id = '44';
                    
                    echo osc_draw_pull_down_menu('shipping_country', $countries_array, $country_id, "class=country");
                  ?>
                </li>

                <li id="shipping-state">
                  <?php
                    $zones_array = array();
                    foreach (osC_Address::getZones($country_id) as $zone) {
                      $zones_array[] = array('id' => $zone['name'], 'text' => $zone['name']);
                    }

                    $state = '';
                    
                    if (is_numeric($state)) {
                      $state = osC_Address::getZoneName($state);
                    }
                
                    if (sizeof($zones_array) > 0) {
                      echo osc_draw_pull_down_menu('shipping_state', $zones_array, $state);
                    } else {
                      echo osc_draw_input_field('shipping_state', $state);
                    }
                  ?>
                </li>
                
                <li id="shipping-city">
                  <?php
                    $cities_array = array();
                    if ($country_id == CHINA_COUNTRY_ID) {
                      if ($state == null) {
                        if (sizeof($zones_array) > 0) {
                          $state = $zones_array[0]['text'];
                        }
                      }
                      
                      if ($state !== null) {
                        foreach (toC_China_Address::getCities($state) as $region) {
                          $cities_array[] = array('id' => $region['name'], 'text' => $region['name']);
                        }        
                      }
                    }
              
                    $city = '';
                    
                    if (sizeof($cities_array) > 0) {
                      echo osc_draw_pull_down_menu('shipping_city', $cities_array, $city);
                    } else {
                      echo osc_draw_input_field('shipping_city', $city);
                    }
                  ?>
                </li>
                
                <li id="shipping-suburb">
                  <?php
                    $suburb_array = array();
                    if ($country_id == CHINA_COUNTRY_ID) {
                      if ($city == null) {
                        if (sizeof($cities_array) > 0) {
                          $city = $cities_array[0]['text'];
                        }
                      }
                            
                      if ($city !== null) {
                        $city_id = toC_China_Address::getChinaRegionId($city, REGION_TYPE_CITY);
                        foreach (toC_China_Address::getDistricts($city_id) as $region) {
                          $suburb_array[] = array('id' => $region['name'], 'text' => $region['name']);
                        }        
                      }
                    }

                    $suburb = '';
                    if (sizeof($suburb_array) > 0) {
                      echo osc_draw_pull_down_menu('shipping_suburb', $suburb_array, $suburb);
                    } else {
                      echo osc_draw_input_field('shipping_suburb', $suburb);
                    }
                  ?>
                </li>
              </ol>
            </td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_gender'); ?></td>
            <td>
              <?php
                $gender_array = array(array('id' => 'm', 'text' => $osC_Language->get('gender_male')),
                                      array('id' => 'f', 'text' => $osC_Language->get('gender_female')));
                
                echo osc_draw_radio_field('shipping_gender', $gender_array, 'm');
              ?>
            </td>
            <td><?php echo $osC_Language->get('field_customer_company'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_company', ''); ?></td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_last_name'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_lastname', ''); ?></td>
            <td><?php echo $osC_Language->get('field_customer_first_name'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_firstname', ''); ?></td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_street_address'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_street_address', ''); ?></td>
            <td><?php echo $osC_Language->get('field_customer_post_code'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_postcode', ''); ?></td>
          </tr>
          
          <tr>
            <td><?php echo $osC_Language->get('field_customer_telephone_number'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_telephone', ''); ?></td>
            <td><?php echo $osC_Language->get('field_customer_fax_number'); ?></td>
            <td><?php echo osc_draw_input_field('shipping_fax', ''); ?></td>
          </tr>
          
          <tr>
            <td colspan="4" align="right">
              <?php echo osc_draw_image_button('button_shipping_address.png', $osC_Language->get('button_continue'), 'id="btnSaveShippingInformation" style="cursor: pointer"'); ?>
            </td>
          </tr>
        </tbody>
      </table>
    </form>
  </div>
</div>

<script type="text/javascript">
  window.addEvent('domready', function() {
    checkout = new CnCheckout({
      remoteUrl: '<?php echo osc_href_link('json.php', null, 'SSL', false, false, true); ?>',
      isLoggedOn: <?php echo ($osC_Customer->isLoggedOn() === true) ? 'true' : 'false';?>,
      sessionName: '<?php echo $osC_Session->getName(); ?>',
      sessionId: '<?php echo $osC_Session->getID(); ?>'
    });
    
    checkout.iniShippingAddress();
  });
</script>