<?php
/*
  $Id: cn_checkout.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd;
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
?>

<h1><?php echo $osC_Language->get('checkout')?></h1>

<div id="checkoutForm">
  <div class="moduleBox" style="position: relative;">
    <h6><?php echo $osC_Language->get('products_list_title'); ?></h6>
    <a href="checkout.php" style="position: absolute; top: 0; right: 0; margin-top: 5px; margin-right: 5px; color: #333333"><?php echo $osC_Language->get('edit'); ?></a>
    
    <div class="content" id="check_products_list">
      <table cellspacing="0">
        <tbody>
          <tr>
            <th><?php echo $osC_Language->get('table_heading_sku'); ?></th>
            <th><?php echo $osC_Language->get('table_heading_name'); ?></th>
            <th><?php echo $osC_Language->get('table_heading_market_price'); ?></th>
            <th><?php echo $osC_Language->get('table_heading_price'); ?></th>
            <th><?php echo $osC_Language->get('table_heading_quantity'); ?></th>
          </tr>
          <?php
            foreach ($osC_ShoppingCart->getProducts() as $products_id => $products) {
              $market_price_total += $products['market_price'] * $products['quantity'];
              $weight_total += $products['weight'];
          ?>
          <tr class="products">
            <td><?php echo $products['sku']; ?></td>
            <td align="left" class="productsName"><?php echo osc_link_object(osc_href_link(FILENAME_PRODUCTS, $products['id']), $osC_Image->show($products['image'], $products['name'], '', 'mini') . $products['name']); ?></td>
            <td><?php echo $osC_Currencies->displayPrice($products['market_price'] , $products['tax_class_id']); ?></td>
            <td style="color: red;"><?php echo $osC_Currencies->displayPrice($products['price'] , $products['tax_class_id']); ?></td>
            <td><?php echo $products['quantity']; ?></td>
          </tr>
          <?php
            }
          ?>
          <tr>
            <td valign="top" colspan="5" align="right">
              <span><?php echo $osC_Language->get('weight_total') . $osC_Weight->display($weight_total, SHIPPING_WEIGHT_UNIT) . '&nbsp;&nbsp;&nbsp;&nbsp;' . $osC_Language->get('original_price_total') . '&nbsp;' . $osC_Currencies->displayPrice($osC_ShoppingCart->getSubTotal() , $products['tax_class_id']) . ',' . $osC_Language->get('compare_price') . '&nbsp;' . $osC_Currencies->displayPrice($market_price_total, $products['tax_class_id']) . '&nbsp;' . $osC_Language->get('spare') . '&nbsp;' . $osC_Currencies->displayPrice(($market_price_total - $osC_ShoppingCart->getSubTotal()), $products['tax_class_id']); ?></span>
              <br />
              <span style="font-size: 14px;font-weight: bold;"><?php echo $osC_Language->get('order_price_total'); ?><font color="red"><?php echo $osC_Currencies->displayPrice($osC_ShoppingCart->getSubTotal(), $products['tax_class_id']); ?></font></span>
            </td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  
  <div class="blank"></div>
  
  <?php
    $address = $osC_ShoppingCart->getShippingAddress();
  ?>
  <div class="moduleBox" style="position: relative;">
    <h6><?php echo $osC_Language->get('shipping_address_title'); ?></h6>
    <a href="checkout.php?cn_shipping_address" style="position: absolute; top: 0; right: 0; margin-top: 5px; margin-right: 5px; color: #333333"><?php echo $osC_Language->get('edit'); ?></a>
    <div class="content" id="check_shipping_address">
      <table cellspacing="0">
        <tbody>
          <tr>
            <td><?php echo $osC_Language->get('shipping_address_name'); ?></td>
            <td><?php echo $address['lastname'] . $address['firstname']; ?></td>
            <td><?php echo $osC_Language->get('shipping_address'); ?></td>
            <td><?php echo $address['state'] . $address['city'] . $address['suburb'] . $address['street_address']; ?></td>
          </tr>
          <tr>
            <td><?php echo $osC_Language->get('shipping_address_post_code'); ?></td>
            <td><?php echo $address['postcode']; ?></td>
            <td><?php echo $osC_Language->get('shipping_address_telephone_number'); ?></td>
            <td><?php echo $address['telephone_number']; ?></td>
          </tr>
        </tbody>
      </table>
    </div>
  </div>
  
  <div class="blank"></div>
  
  <div class="moduleBox" id="check_shipping_method">
    <h6><?php echo $osC_Language->get('shipping_method_title'); ?></h6>
    <div class="content">
      <?php
        ob_start();
      
        include('includes/modules/shipping_method_form.php'); 
        $form = ob_get_contents();
        
        ob_end_clean();
        
        echo $form;
      ?>
    </div>
  </div>
  
  <div class="blank"></div>
  
  <div class="moduleBox" id="check_payment_method">
    <h6><?php echo $osC_Language->get('payment_method_title'); ?></h6>
    <div class="content">
      <?php
        ob_start();
      
        include('includes/modules/payment_method_form.php'); 
        $form = ob_get_contents();
        
        ob_end_clean();
        
        echo $form;
      ?>
    </div>
  </div>
  
  <div class="blank"></div>
  
  <div class="moduleBox" id="check_order_information">
    <h6><?php echo $osC_Language->get('order_total_title'); ?></h6>
    <div class="content">
      <?php
        ob_start();
      
        include('includes/modules/order_confirmation_form.php'); 
        $form = ob_get_contents();
        
        ob_end_clean();
        
        echo $form;
      ?>
    </div>
  </div>
</div>

<div class="submitFormButtons" id="submitFormButtons">
  <form name="checkout_confirmation" action="checkout.php?process" method="post">
    <div style="text-align: right;">
      <?php echo osc_draw_image_submit_button('button_confirm_order.gif', $osC_Language->get('button_confirm_order'), 'id="btnConfirmOrder"'); ?>
    </div>
  </form>
</div>

<script type="text/javascript">
  function selectShippingMethod(shippingMethod) {
    var data = {module: 'cn_checkout', action: 'change_shipping_method'};
    
    data.shipping_method = shippingMethod.value;
    
    var loadRequest = new Request({
      url: 'json.php',
      data: data,
      onSuccess: function(response) {
        result = JSON.decode(response);
        
        $('check_order_information').getElement('div').set('html', result.order_confirmation_form);
      }.bind(this)
    }).send();
  }
  
  function selectPaymentMethod(paymentMethod) {
    var data = {module: 'cn_checkout', action: 'change_payment_method'};
    
    data.payment_method = paymentMethod.value;
    
    var loadRequest = new Request({
      url: 'json.php',
      data: data,
      onSuccess: function(response) {
        result = JSON.decode(response);
        
        $('submitFormButtons').set('html', result.form);
        checkout.iniConfirmOrder();
      }.bind(this)
    }).send();
  }
  
  window.addEvent('domready', function() {
    if ( typeof(checkout) == "undefined" ) {
      checkout = new CnCheckout({
        remoteUrl: '<?php echo osc_href_link('json.php', null, 'SSL', false, false, true); ?>',
        isLoggedOn: <?php echo ($osC_Customer->isLoggedOn() === true) ? 'true' : 'false';?>,
        sessionName: '<?php echo $osC_Session->getName(); ?>',
        sessionId: '<?php echo $osC_Session->getID(); ?>'
      });
    }
    
    checkout.iniPaymentMethodInformation();
    checkout.iniConfirmOrder();
    
    if ( $defined($('defaultPaymentMethodSelected')) ) {
      $('defaultPaymentMethodSelected').getElement('input').click();
    }
    
  });
</script>