# $Id: tomatocart_sample_data.sql $
#
# TomatoCart Open Source Shopping Cart Solutions
# http://www.tomatocart.com
#
# Copyright (c) 2009 Elootech Technology Ltd.,  Copyright (c) 2006 osCommerce
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License v2 (1991)
# as published by the Free Software Foundation.
#
# NOTE: * Please make any modifications to this file by hand!
#       * DO NOT use a mysqldump created file for new changes!
#       * Please take note of the table structure, and use this
#         structure as a standard for future modifications!
#       * Any tables you add here should be added in admin/backup.php
#         and in catalog/install/includes/functions/database.php
#       * To see the 'diff'erence between MySQL databases, use
#         the mysqldiff perl script located in the extras
#         directory of the 'catalog' module.
#       * Comments should be like these, full line comments.
#         (don't use inline comments)


INSERT INTO toc_configuration ( configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES
('幻灯片转换间隔', 'MODULE_CONTENT_SLIDE_SHOW_INTERVAL', '3000', '幻灯片转换时间间隔。', 6, 0, NULL, now(), NULL, NULL),
('幻灯片转换时间', 'MODULE_CONTENT_SLIDE_SHOW_DURATION', '1000', '幻灯片效果转换时间。', 6, 0, NULL, now(), NULL, NULL),
('图片区域高度', 'MODULE_CONTENT_SLIDE_SHOW_HEIGHT', '310', '图片区域高度(px)。', 6, 0, NULL, now(), NULL, NULL),
('图片区域宽度', 'MODULE_CONTENT_SLIDE_SHOW_WIDTH', '960', '图片区域宽度(px)。', 6, 0, NULL, now(), NULL, NULL),
('显示幻灯片信息区域', 'MODULE_CONTENT_SLIDE_SHOW_DISPLAY_INFO', 'False', '显示幻灯片信息区域。', 6, 0, NULL, now(), NULL, 'osc_cfg_set_boolean_value(array(''True'', ''False''))'),
('幻灯片模式[垂直, 水平]', 'MODULE_CONTENT_SLIDE_SHOW_MODE', 'horizontal', '幻灯片转换模式[垂直方向, 水平方向]。', 6, 0, NULL, now(), NULL, 'osc_cfg_set_boolean_value(array(''horizontal'', ''vertical''))');

INSERT INTO toc_templates_boxes (id, title, code, author_name, author_www, modules_group) VALUES
(100, '幻灯片展示', 'slide_show', 'TomatoCart', 'http://www.tomatocart.com', 'content');

INSERT INTO toc_templates_boxes_to_pages (templates_boxes_id, templates_id, content_page, boxes_group, sort_order, page_specific) VALUES
(100, 1, 'index/index', '幻灯片区域', 0, 0);

# Articles Categories
INSERT INTO toc_articles_categories (articles_categories_id, articles_categories_status, articles_categories_order) VALUES (2, 1, 2);
INSERT INTO toc_articles_categories (articles_categories_id, articles_categories_status, articles_categories_order) VALUES (3, 1, 3);
INSERT INTO toc_articles_categories (articles_categories_id, articles_categories_status, articles_categories_order) VALUES (4, 1, 4);
INSERT INTO toc_articles_categories (articles_categories_id, articles_categories_status, articles_categories_order) VALUES (5, 1, 5);
INSERT INTO toc_articles_categories (articles_categories_id, articles_categories_status, articles_categories_order) VALUES (6, 1, 6);

# Articles
INSERT INTO toc_articles (articles_id, articles_categories_id, articles_status, articles_order, articles_date_added, articles_last_modified, articles_image) VALUES
(6, 2, 1, 6, now(), now(), NULL),
(7, 2, 1, 7, now(), now(), NULL),
(8, 3, 1, 8, now(), now(), NULL),
(9, 3, 1, 9, now(), now(), NULL),
(10, 3, 1, 10, now(), now(), NULL),
(11, 4, 1, 11, now(), now(), NULL),
(12, 4, 1, 11, now(), now(), NULL),
(13, 5, 1, 12, now(), now(), NULL),
(14, 5, 1, 12, now(), now(), NULL),
(15, 6, 1, 13, now(), now(), NULL),
(16, 6, 1, 14, now(), now(), NULL);

INSERT INTO toc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES
('最多显示文章分类个数', 'BOX_ARTICLES_CATEGORIES_MAX_LIST', '10', '在列表中最多显示文章分类个数。', 6, 0, NULL, now(), NULL, NULL);
INSERT INTO toc_templates_boxes (id, title, code, author_name, author_www, modules_group) VALUES (101, '文章分类', 'articles_categories', 'TomatoCart', 'http://www.tomatocart.com', 'boxes');

# Shop by price
INSERT INTO toc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, last_modified, date_added, use_function, set_function) VALUES
('人民币', 'BOX_SHOP_BY_PRICE_CNY', '3500;7000;10000;15000', '人民币 interval (Price seperated by ";")', 6, 0, NULL, now(), NULL, NULL);

INSERT INTO toc_templates_boxes (id, title, code, author_name, author_www, modules_group) VALUES (102, '价格区间', 'shop_by_price', 'TomatoCart', 'http://www.tomatocart.com', 'boxes');

#manufacturers
INSERT INTO toc_manufacturers (manufacturers_id, manufacturers_name, manufacturers_image, date_added, last_modified) VALUES 
(1, '苹果', 'apple.png', now(), now()),
(2, '戴尔', 'dell.png', now(), now()),
(3, '惠普', 'hp.png', now(), now()),
(4, '联想', 'lenovo.png', now(), now()),
(5, '索尼', 'sony.png', now(), now());


#product categories
INSERT INTO toc_categories (categories_id, categories_image, parent_id, sort_order, date_added, last_modified) VALUES
(1, 'categories_notebooks.jpg', 0, 0, now(), NULL),
(2, 'categories_desktops.jpg', 0, 0, now(), NULL),
(3, 'categories_monitor.jpg', 0, 0, now(), NULL),
(4, 'categories_printer.jpg', 0, 0, now(), NULL),
(5, 'categories_printer.jpg', 4, 0, now(), NULL),
(6, 'categories_printer.jpg', 4, 0, now(), NULL),
(7, 'categories_printer.jpg', 4, 0, now(), NULL),
(8, 'categories_printer.jpg', 4, 0, now(), NULL),
(9, 'categories_ipod.jpg', 0, 0, now(), NULL);


#products
INSERT INTO toc_products (products_id, products_quantity, products_market_price, products_price, products_date_added, products_last_modified, products_date_available, products_weight, products_weight_class, products_status, products_tax_class_id, manufacturers_id, products_ordered, quantity_discount_groups_id, quantity_unit_class, products_sku, products_model) VALUES
(1, 10, 820.0000, 799.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 2, 0, 0, 1, '', ''),
(2, 10, 610.0000, 599.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 3, 0, 0, 1, '', ''),
(3, 10, 860.0000, 849.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 4, 0, 0, 1, '', ''),
(4, 10, 1200.0000, 1099.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(5, 10, 1300.0000, 1199.0000, now(), NULL, NULL, 5.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(6, 10, 1400.0000, 1299.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(7, 10, 1900.0000, 1799.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 4, 0, 0, 1, '', ''),
(8, 10, 1100.0000, 999.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 4, 0, 0, 1, '', ''),
(9, 10, 1000.0000, 899.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 4, 0, 0, 1, '', ''),
(10, 10, 600.0000, 499.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 3, 0, 0, 1, '', ''),
(11, 10, 500.0000, 449.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 6, 0, 0, 1, '', ''),
(12, 10, 500.0000, 479.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 3, 0, 0, 1, '', ''),
(13, 10, 750.0000, 699.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 3, 0, 0, 1, '', ''),
(14, 10, 650.0000, 599.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 6, 0, 0, 1, '', ''),
(15, 10, 100.0000, 79.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(16, 10, 130.0000, 120.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(17, 10, 450.0000, 399.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(18, 10, 350.0000, 300.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 1, 0, 0, 1, '', ''),
(19, 10, 250.0000, 199.0000, now(), NULL, NULL, 10.00, 2, 1, 0, 5, 0, 0, 1, '', '');


INSERT INTO toc_products_images (id, products_id, image, default_flag, sort_order, date_added) VALUES
(1, 1, '4589430859034895043.jpg', 1, 0, '2009-01-26 17:32:02'),
(2, 2, '5443523452354.jpg', 1, 0, '2009-01-26 17:45:14'),
(3, 3, '437893748943838943.jpg', 1, 0, '2009-01-26 17:56:27'),
(4, 4, '54892437589237584.jpg', 1, 0, '2009-01-26 18:12:38'),
(5, 4, '0904856904586475689.jpg', 0, 0, '2009-01-26 18:12:57'),
(6, 4, '098489508435893845.jpg', 0, 0, '2009-01-26 18:13:09'),
(7, 5, '0904856904586475689.jpg', 0, 0, '2009-01-26 18:56:24'),
(8, 5, '54892437589237584.jpg', 1, 0, '2009-01-26 18:56:31'),
(9, 5, '098489508435893845.jpg', 0, 0, '2009-01-26 18:56:39'),
(10, 6, '54892437589237584.jpg', 1, 0, '2009-01-26 19:03:33'),
(11, 6, '098489508435893845.jpg', 0, 0, '2009-01-26 19:03:42'),
(12, 6, '0904856904586475689.jpg', 0, 0, '2009-01-26 19:03:50'),
(18, 7, 'h45435345345345.jpg', 0, 0, '2009-01-26 19:18:13'),
(19, 7, 'v34234234234234.jpg', 1, 0, '2009-01-26 19:18:16'),
(22, 8, '56435345345345345.jpg', 1, 0, '2009-01-26 19:23:50'),
(26, 9, 't400-ds798348923482.jpg', 1, 0, '2009-01-26 19:33:59'),
(24, 8, '67567567567567.jpg', 0, 0, '2009-01-26 19:23:57'),
(27, 10, 'dv70-1240-34823489234.jpg', 1, 0, '2009-01-26 19:36:59'),
(28, 10, 'dv70-1240-34823484349234.jpg', 0, 0, '2009-01-26 19:37:18'),
(30, 11, 'a355-349234-23489234.jpg', 1, 0, '2009-01-26 19:45:27'),
(31, 11, 'a355-349234-33489234.jpg', 0, 0, '2009-01-26 19:46:15'),
(32, 12, '6735s-ks117ut-334839234.jpg', 1, 0, '2009-01-26 19:56:00'),
(33, 13, 'tx2510us-39293843.jpg', 1, 0, '2009-01-26 19:59:08'),
(34, 13, 'tx2510us-39293845.jpg', 0, 0, '2009-01-26 19:59:36'),
(35, 13, 'tx2510us-39493845.jpg', 0, 0, '2009-01-26 20:00:00'),
(36, 14, 'l305d-s5904-39293323.jpg', 1, 0, '2009-01-26 20:04:36'),
(37, 14, 'l305d-s5904-39245323.jpg', 0, 0, '2009-01-26 20:04:57'),
(38, 14, 'l305d-s5904-55593323.jpg', 0, 0, '2009-01-26 20:05:04'),
(39, 15, 'ipod-nano3-392339239.jpg', 1, 0, '2009-01-26 21:51:24'),
(40, 16, 'ipod-touch-392033.jpg', 1, 0, '2009-01-26 22:04:47'),
(41, 16, 'ipod-touch-3323.jpg', 0, 0, '2009-01-26 22:10:45'),
(42, 16, 'ipod-touch-39203333.jpg', 0, 0, '2009-01-26 22:11:38'),
(43, 17, 'iphone-03923923.jpg', 1, 0, '2009-01-26 22:18:37'),
(44, 18, 'cinema-3923823.jpg', 1, 0, '2009-01-26 22:34:17'),
(45, 19, 'dsc-t700-38324.jpg', 1, 0, '2009-01-26 22:38:18'),
(46, 19, 'dsc-t700-38434.jpg', 0, 0, '2009-01-26 22:38:39'),
(47, 19, 'dsc-t700-42434.jpg', 0, 0, '2009-01-26 22:38:44');

INSERT INTO toc_products_to_categories (products_id, categories_id) VALUES
(1, 2),
(2, 2),
(3, 2),
(4, 1),
(5, 1),
(6, 1),
(7, 1),
(8, 1),
(9, 1),
(10, 1),
(11, 1),
(12, 1),
(13, 1),
(14, 1),
(15, 5),
(16, 5),
(17, 5),
(18, 3),
(19, 5);

#popular search term
INSERT INTO toc_configuration (configuration_title, configuration_key, configuration_value, configuration_description, configuration_group_id, sort_order, date_added) values ('缓存数据时间', 'BOX_POPULAR_SEARCH_TERM_CACHE', '60', '您希望缓存热门关键字数据多少分钟 (0表示不缓存数据)。', '6', '0', now());
INSERT INTO toc_search_terms (search_terms_id, text, products_count, search_count, synonym, show_in_terms, date_updated) VALUES
(1, '苹果', 2, 30, '', 1, now()),
(2, '华硕', 0, 7, '', 0, now()),
(3, 'IBM', 0, 16, '', 0, now()),
(4, '索尼', 0, 27, '', 1, now()),
(5, '宏基', 0, 95, '', 1, now()),
(6, '明基', 0, 46, '', 1, now()),
(7, '联想', 0, 55, '', 1, now()),
(8, '诺基亚', 0, 74, '', 1, now()),
(9, 'LG', 0, 75, '', 1, now()),
(10, '三星', 0, 42, '', 1, now());

#feature products
INSERT INTO toc_products_frontpage (products_id, sort_order) VALUES
(6, 1),
(5, 2),
(17, 3),
(19, 4),
(3, 5),
(9, 6);


#language_chinese
#Slide show
INSERT INTO toc_slide_images (image_id, language_id, description, image, image_url, sort_order, status) VALUES
(1, 1, '请在此输入所需信息。', 'slide1.jpg', 'products.php?1', 0, 1),
(2, 1, '请在此输入所需信息。', 'slide2.jpg', 'products.php?18', 0, 1),
(3, 1, '请在此输入所需信息。', 'slide3.jpg', 'products.php?13', 0, 1);


# Articles Categories
INSERT INTO toc_articles_categories_description (articles_categories_id, language_id, articles_categories_name, articles_categories_url) VALUES (2, 1, '新手上路', 'information');
INSERT INTO toc_articles_categories_description (articles_categories_id, language_id, articles_categories_name, articles_categories_url) VALUES (3, 1, '购物指南', 'information');
INSERT INTO toc_articles_categories_description (articles_categories_id, language_id, articles_categories_name, articles_categories_url) VALUES (4, 1, '配送方式', 'information');
INSERT INTO toc_articles_categories_description (articles_categories_id, language_id, articles_categories_name, articles_categories_url) VALUES (5, 1, '支付方式', 'information');
INSERT INTO toc_articles_categories_description (articles_categories_id, language_id, articles_categories_name, articles_categories_url) VALUES (6, 1, '购物条款', 'information');


#Articles Categories
INSERT INTO toc_articles_description (articles_id, language_id, articles_name, articles_url, articles_description) VALUES
(6, 1, '注册会员(免费)', 'imprint', '<b>会员注册完全免费。</b><br><br>您只要点击网站顶部的【注册】链接，填写一些基本信息，即可创建您在本站的账户，成为本站的普通会员。'),
(7, 1, '会员登录', 'imprint', '您只要点击网站顶部的【登录】链接，通过您注册时填写的邮箱和密码，即可登录本站。'),
(8, 1, '购物流程', 'imprint', '&nbsp;&nbsp;&nbsp; 第一步 浏览本站，寻找需要购买的商品<br><br>&nbsp;&nbsp;&nbsp; 第二步 加入购物车或者直接购买<br><br>&nbsp;&nbsp;&nbsp; 第三步 登录注册<br><br>&nbsp;&nbsp;&nbsp; 第四步 填写收货地址等信息<br><br>&nbsp;&nbsp;&nbsp; 第五步 选择并确认订单'),
(9, 1, '购物常见问题', 'imprint', '请修改后台购物常见问题文章将问题加入'),
(10, 1, '忘记密码怎么办？', 'imprint', '1.点击网站顶部的【登录】链接<br><br>2.在登录框的下面，有【忘记密码？】链接的提示，请点击进入<br><br>3.在出现的【忘记密码】窗口中，输入您注册时使用的电子邮箱，并点击【确认】<br><br>4.登录您的电子邮箱查收新密码邮件<br><br>如果您不记得注册时的电子邮箱了，请与本站联系，我们将核对您的基本信息后为您提供新密码。<br>'),
(11, 1, '顺丰快递', 'imprint', '请输入您网站能提供的顺丰快递配送范围及报价的详细信息。'),
(12, 1, '圆通快递', 'imprint', '请输入您网站能提供的圆通快递配送范围及报价的详细信息。'),
(13, 1, '货到付款', 'imprint', '请输入您网站货到付款的详细规定。'),
(14, 1, '支付宝支付', 'imprint', '请输入您网站支付宝支付的详细规定。'),
(15, 1, '交易条例', 'imprint', '在注册前请您仔细阅读如下服务条款：本服务协议双方为本网站与本网站用户，本服务协议具有合同效力。您确认本服务协议后，本服务协议即在您和本网站之间产生法律效力。请您务必在注册之前认真阅读全部服务协议内容，如有任何疑问，可向本网站咨询。无论您事实上是否在注册之前认真阅读了本服务协议，只要您按照本网站注册程序成功注册为用户，您的行为仍然表示您同意并签署了本服务协议。<br><br>1.本网站将尽最大努力保证您所购商品与网站上公布的价格一致，但价目表和声明并不构成要约。本网站有权在发现了其网站上显现的产品及订单的明显错误或缺货的情况下，单方面撤回。(参见下面相关条款)。<br>本网站保留对产品订购的数量的限制权。 在下订单的同时，您也同时承认了您拥有购买这些产品的权利能力和行为能力，并且您对您在订单中提供的所有信息的真实性负责。<br><br>2. 价格变化和缺货<br>产品的价格和可获性都在本网站站上指明。这类信息将随时更改且不发任何通知。送货费将另外结算，费用根据您选择的送货方式的不同而异。如果发生了意外情况，在确认了您的订单后，由于供应商提价，税额变化引起的价格变化，或是由于网站的错误等造成商品价格变化，您有权取消您的订单，并希望您能及时通过电子邮件或电话通知本网站客户服务部。<br>您所订购的商品，如果发生缺货，您有权取消订单。<br><br>3. 邮件/短信服务<br>本网站保留通过邮件和短信的形式，对本网站注册、购物用户发送订单信息、促销活动等告知服务的权利。如果您在本网站注册、购物，表明您已默示同意接受此项服务。<br>如果您不想接收来自本网站的邮件和短信，请在收到短信后直接回复“N”，或在邮件下方输入您的E-mail地址自助完成退阅；您也可以向本网站客服提出退阅申请，并注明您的E-mail地址或手机号，本网站会在收到邮件后为您办理退阅。<br><br>4.退款政策<br>退货或换货商品缺货时产生的现金款项，退回方式视支付方式的不同而不同：<br>1） 网上支付的订单，退款退回至原支付卡；<br>2） 银行转帐或邮局汇款支付的订单，退款退回至下订单账户的账户余额中；<br>3） 货到付款的订单，由送货员当场处理退款。<br><br>5. 条款的修正<br>这些交易条件的条款适用于本网站为您提供的产品销售服务。这些条款将有可能不时的被修正。任何修正条款的发生，本网站都将会及时公布。<br><br>6. 条款的可执行性<br>如果出于任何原因，这些条款及其条件的部分不能得以执行，其他条款及其条件的有效性将不受影响。<br><br>7. 适用的法律和管辖权<br>您和本网站之间的契约将适用中华人民共和国的法律，所有的争端将诉诸于本网站所在地的人民法院。<br><br>协议的变更<br><br>本网站可以在没有特殊通知的情况下自行变更本条款、本网站的任何其它条款和条件、或您的计划会员资格的任何方面。 对这些条款的任何修改将被包含在本网站的更新的条款中。如果任何变更被认定为无效、废止或因任何原因不可执行，则该变更是可分割的，且不影响其它变更或条件的有效性或可执行性。在我们变更这些条款后，您对本网站的继续使用，构成您对变更的接受。如果您不同意本使用交易条款中的任何一条，您可以不使用本网站。<br><br>终止<br><br>本网站可以不经通知而自行决定终止全部或部分计划，或终止您的计划会员资格。即使本网站没有要求或强制您严格遵守这些条款，也并不构成对属于本网站的任何权利的放弃。<br>如果您在本网站的客户账户被关闭，那么您也将丧失您的会员资格。对于该会员资格的丧失，您对本网站不能主张任何权利或为此索赔。<br><br>隐私声明<br><br>电子通讯<br>当您访问本网站站或给我们发送电子邮件和与在线客服联系时，您与我们用电子方式进行联系。您同意以电子方式接受我们的信息。我们将用电子邮件或通过在本网站上发布通知的方式与您进行联系。您同意我们用电子方式提供给您的所有协议、通知、披露和其他信息是符合此类通讯必须是书面形式的法定要求的。如果本网站能够证明以电子形式的信息已经发送给您或者本网站立即在本网站网站上张贴这样的通知，将被视为您已收到所有协议、声明、披露和其他信息<br><br>版权声明<br>本网站上的所有内容诸如文字、图表、标识、按钮图标、图像、声音文件片段、数字下载、数据编辑和软件、商标都是广州市本网站生鲜配送服务中心或其关联公司或其内容提供者的财产，受中国和国际版权法的保护。未经本网站书面授权或许可，不得以任何目的对本网站网站或其任何部分进行复制、复印、仿造、出售、转售、访问、或以其他方式加以利用。<br><br>您的账户<br>如果您使用本网站网站，您有责任对您的账户和密码保守秘密并对进入您的计算机作出限制，并且您同意对在您的账户和密码下发生的所有活动承担责任。本网站提供的生鲜产品以及生活用品，都只将它们销售给成年人。如果您在18岁以下，您只能在父母或监护人的参与下才能使用本网站。本网站及其关联公司保留在中华人民共和国法律允许的范围内独自决定拒绝服务、关闭账户、清除或编辑内容或取消订单的权利。<br><br>评论、意见、消息和其他内容<br><br>访问者可以张贴评论、意见及其他内容，以及提出建议、主意、意见、问题或其他信息，只要内容不是非法、淫秽、威胁、诽谤、侵犯隐私、侵犯知识产权或以其他形式对第三者构成伤害或侵犯或令公众讨厌，也不包含软件病毒、政治宣传、商业招揽、连锁信、大宗邮件或任何形式的"垃圾邮件"。您不可以使用虚假的电子邮件地址、冒充任何他人或实体或以其它方式对卡片或其他内容的来源进行误导。本网站保留清除或编辑这些内容的权利（但非义务），但不对所张贴的内容进行经常性的审查。<br>如果您确实张贴了内容或提交了材料，除非我们有相反指示，您授予本网站及其关联公司非排他的、免费的、永久的、不可撤销的和完全的再许可权而在全世界范围内任何媒体上使用、复制、修改、改写、出版、翻译、创作衍生作品、分发和展示这样的内容。您授予本网站及其关联公司和被转许可人使用您所提交的与这些内容有关的名字的权利，如果他们选择这样做的话。您声明并担保您拥有或以其它方式控制您所张贴内容的权利，内容是准确的，对您所提供内容的使用不违反本政策并不会对任何人和实体造成伤害。您声明并保证对于因您所提供的内容引起的对本网站或其关联公司的损害进行赔偿。本网站有权（但非义务）监控和编辑或清除任何活动或内容。本网站对您或任何第三方所张贴的内容不承担责任。<br><br>合同缔结<br><br>如果您通过我们网站订购产品，您的订单就成为一种购买产品的申请或要约。我们将发送给您一封确认收到订单的电子邮件，其中载明订单的细节。但是只有当我们向您发出送货确认的电子邮件通知您我们已将产品发出时，我们对您合同申请的批准与接受才成立。如果您在一份订单里订购了多种产品并且我们只给您发出了关于其中一部分的发货确认电子邮件，那么直到我们发出关于其他产品的发货确认电子邮件，关于那部分产品的合同才成立。当您所购买的商品离开了本网站或其关联公司的库房时，该物品的所有权和灭失风险即转移到您这一方。<br><br>产品说明<br><br>本网站及其关联公司努力使产品说明尽可能准确。不过，我们并不保证产品说明或本网站网站上的其他内容是准确的、完整的、可靠的、最新的或无错误的。如果本网站提供的产品本身并非如说明所说，您唯一的救济是将该未经使用过的产品退还我们。<br>价格<br>直到您发出订单，我们才能确认商品的价格。尽管我们做出最大的努力，我们的商品目录里的一小部分商品可能会有定价错误。如果我们发现错误定价，我们将采取下列之一措施：<br>（1） 如果某一商品的正确定价低于我们的错误定价，我们将按照较低的定价向您销售交付该商品。<br>（2） 如果某一商品的正确定价高于我们的错误定价，我们会根据我们的情况决定,是否在交付前联系您寻求您的指示, 或者取消订单并通知您。<br>'),
(16, 1, '会员条款', 'imprint', '第一章 总则<br>第1条 本网站所有权、管理经营权均属本网站。<br><br>第二章 网站用户<br>第2条 在本网站注册的用户（以下简称"网站用户"），拥有网站用户基本权限。网站用户参与网站活动时必须遵守《本条款》。<br>第3条 本网站用户的个人资料受到保护，不接受任何个人或单位的查询请求，公安机关和司法部门或根据国家相关法律规定提供除外。<br>第4条 本网站用户享有在网站各公开栏目发表言论的权利，若栏目中有特殊规定，或受到网站处罚而关闭发言权限则例外。<br>第5条 本网站用户有义务遵守国家法律法规及本网站各项规章制度。<br>第6条 本网站用户有义务遵守网络礼仪。<br><br>第三章 言论规则<br>第7条 网站用户享有言论自由权利；并适度拥有修改、删除自己发表的文章的权利。<br>第8条 本网站用户不得在本网站发表包含以下内容的言论：<br>（一）煽动抗拒、破坏宪法和法律、行政法规实施的；<br>（二）煽动颠覆国家政权，推翻社会主义制度的；<br>（三）煽动分裂国家、破坏国家统一的；<br>（四）煽动民族仇恨、民族歧视，破坏民族团结的；<br>（五）任何包含对种族、性别、宗教、地域内容等歧视的；<br>（六）捏造或者歪曲事实，散布谣言，扰乱社会秩序的；<br>（七）宣扬封建迷信、淫秽、色情、赌博、暴力、凶杀、恐怖、教唆犯罪的；<br>（八）公然侮辱他人或者捏造事实诽谤他人的，或者进行其他恶意攻击的；<br>（九）损害国家机关信誉的；<br>（十）其他违反宪法和法律行政法规的。<br>第9条 本网站用户在相关讨论区发表文章或评论时，除遵守本条款外，还应遵守该讨论区的相关规定。<br>第10条 未经本网站同意，禁止在本网站内发布任何形式的广告。<br><br>第四章 版权声明<br>第11条 本网站用户发表的文章仅代表作者本人观点，与本网站立场无关，作者文责自负。<br>第12条 本网站有权将在本网站发表的文章或图片自行使用或者与其他人合作使用于其他用途，包括但不限于网站、电子杂志、杂志、刊物等，使用时需为作者署名，以发表文章时注明的署名为准。文章有附带版权声明者除外。<br>第13条 本网站的文章及图片（包括转贴的文章及图片）版权仅归原作者所有，若作者有版权声明或原作从其它网站转载而附带有原版权声明者，其版权归属以附带声明为准。<br>第14条 任何转载、引用发表于本网站的版权文章须符合以下规范：<br>（1）用于非商业、非盈利、非广告性目的时需注明作者及文章及图片的出处为“本网站”。<br>（2）用于商业、盈利、广告性目的时需征得文章或图片原作者的同意，并注明作者姓名、授权范围及原作出处“本网站”。<br>（3）任何文章或图片的修改或删除均应保持作者原意并征求原作者同意，并注明授权范围。<br><br>第五章 处罚原则<br>第15条 本网站用户不得在本网站进行任何违反国家法律法规及网站各项规章制度的活动，不得在本网站进行任何破坏公共安全的活动，不得在本网站进行任何非法商业活动，不得在本网站进行任何破坏公共秩序的活动，如有违反，网站管理人员将依据有关规定进行处罚。<br>第16条 本网站用户不得利用网站BUG进行任何活动，如有违反，网站有权作出关闭其部分权限、暂停帐号使用直至删除帐号处理，同时网站保留追究责任人法律及经济责任的权利。<br><br>第六章 责任声明<br>第17条 本网站用户之间通过网站相识、交往中所发生或可能发生的任何心理、生理上的伤害和经济上的纠纷与损失，本网站不承担任何责任。用户可以及时与本网站的客服或管理人员联系。<br>第18条 本网站用户因为违反本网站规定而触犯中华人民共和国法律的，责任自负，本网站不承担任何责任。<br>第19条 本网站如因系统维护或升级而需暂停服务时，将事先公告。若因硬件故障或其它不可抗力而导致暂停服务，于暂停服务期间造成的一切不便与损失，本网站不承担任何责任。');


#store notice
INSERT INTO toc_notice (notice_id, notice_status, notice_order, notice_date_added, notice_last_modified, notice_image) VALUES
(1, 1, 1, now(), NULL, NULL),
(2, 1, 2, now(), NULL, NULL);

INSERT INTO toc_notice_description (notice_id, language_id, notice_name, notice_url, notice_description, notice_page_title, notice_meta_keywords, notice_meta_description) VALUES
(1, 1, '欢迎光临本店，祝您购物愉快！', 'welcome', '欢迎光临本店，小店新开，优惠多多，祝您购物愉快！', '', '', ''),
(2, 1, '新年给力大促销！', 'special', '为了迎接新年的到来，本店全部商品8折销售！同时消费满500，送200本店购物券！', '', '', '');


#friend link
INSERT INTO toc_friend_link (friend_link_id, friend_link_status, friend_link_order, friend_link_date_added, friend_link_last_modified, friend_link_image, friend_link_url) VALUES
(1, 1, 1, now(), NULL, NULL, 'http://www.tomatocart.cn'),
(2, 1, 2, now(), NULL, NULL, 'http://guide.tomatocart.cn'),
(3, 1, 3, now(), NULL, NULL, 'http://bbs.tomatocart.cn');

INSERT INTO toc_friend_link_description (friend_link_id, language_id, friend_link_name) VALUES
(1, 1, 'TomatoCart网店系统'),
(2, 1, 'TomatoCart帮助中心'),
(3, 1, 'TomatoCart中文社区');


#special products
INSERT INTO toc_specials (specials_id, products_id, specials_new_products_price, specials_date_added, specials_last_modified, start_date, expires_date, date_status_change, status) VALUES
(1, 19, 150.0000, now(), NULL, now(), '2055-11-29 00:00:00', NULL, 1),
(2, 17, 300.0000, now(), NULL, now(), '2055-11-29 00:00:00', NULL, 1);


#manufacturers_info
INSERT INTO toc_manufacturers_info (manufacturers_id, languages_id, manufacturers_url, manufacturers_friendly_url, url_clicked, date_last_click) VALUES 
(1, 1, 'http://www.apple.com', 'apple', '0', NULL),
(2, 1, 'http://www.dell.com', 'dell', '0', NULL),
(3, 1, 'http://www.hp.com', 'hp', '0', NULL),
(4, 1, 'http://www.lenovo.com', 'lenovo', '0', NULL),
(5, 1, 'http://www.sony.com', 'sony', '0', NULL);


INSERT INTO toc_categories_description (categories_id, language_id, categories_name, categories_url) VALUES
(1, 1, '笔记本电脑', 'laptop'),
(2, 1, '台式电脑', 'desktops'),
(3, 1, '显示器', 'monitors'),
(4, 1, '打印机 & 扫描仪', 'printers-scanners'),
(5, 1, '惠普', 'hp'),
(6, 1, '兄弟', 'brother'),
(7, 1, '爱普生', 'epson'),
(8, 1, '佳能', 'canon'),
(9, 1, '音乐播放器 & 照相机', 'ipod-camera');


INSERT INTO toc_products_description (products_id, language_id, products_name, products_description, products_keyword, products_tags, products_friendly_url, products_viewed) VALUES
(1, 1, '戴尔 XPS 630', '<h2>产品特征 </h2><ul><li>XPS630采用了最先进的技术和创新设计：线条流畅，性能优越，是一款顶级的游戏台式机 </li><li>一场超音速游戏盛宴：XPS630通过BIOS或NVIDIA ? nTune9800GT以及 英特尔?Q9300四核处理器，以及750w电源支持，提供超频体验。 </li><li>前：Usb2.0(2), 1394a,耳机插孔，话筒，可选的19合1读卡器 </li><li>后（声卡）：S/PDIF光纤，输入线，输出线，麦克风，环绕，中心/LFE，集成HDA7.1声卡 </li><li>后（其他）：USB2.0(4),1394A, PS / 2鼠标和键盘, Gigabit Ethernet8网卡驱动</li><li>Vista的SP1的64位高级<br></li></ul><p><br></p>', NULL, '', 'dell-xps-630', 4),
(2, 1, '惠普 Pavilion a6433w-b', '<h2>产品特征\r\n\r\n</h2><ul><li>惠普w2207h 22“宽屏液晶显示器，内置扬声器 </li><li>1680 x 1050分辨率，5毫秒 响应时间和1000:1的对比度&nbsp; </li><li>2 GHz的英特尔奔腾双核台式机处理器E2180 </li><li>提供了真正 的多任务处理能力和多媒体要求&nbsp; </li><li>3 GB的DDR2系统内存 </li><li>为满足当今用户需求，提供了改进的性能：扩大到8 GB&nbsp; </li><li>500 GB硬盘，7200rpm </li><li>提供了存储大量的文件，游戏，音乐，照片和视频的空间&nbsp; </li><li>SuperMulti DVD + / - RW驱动器与双层能力 </li><li>支持刻录和播放DVD和CD&nbsp; </li><li>10/100/1000 Base - T网络接口和56K调制解调器 </li><li>通过DSL，电缆或拨号上网服务连接到互联网&nbsp; </li><li>15合1数字多媒体读卡器 </li><li>识别几乎所有的记忆卡 格式，所以你可 以随心所欲欣赏照片，音乐和其他文件&nbsp; </li><li>Vista家庭高级版的Windows媒体中心和Service Pack 1 </li></ul><p>&nbsp;</p>', NULL, '', 'hp-pavilion-a6433w-b', 2),
(3, 1, '联想ThinkCentre M57p', '<h2>产品特征</h2><ul><li>2.66GHz英特尔酷睿 E8200处理器</li><li>正版Windows Vista商业版</li><li>超小外形</li><li>内存：1GB DDR2（667MHz）</li><li>硬盘：160GB</li><li>光驱：CD-RW/DVD-ROM Combo 48X/32X/48X/16X Max </li></ul>', NULL, '', 'thinkcentre-m57p', 0),
(4, 1, '15.4英寸 Macbook Pro MB134LL/A', '<h2>产品特征</h2><p><br></p><ul><li>2.5 GHz Intel 双核处理器，6 MB 单片二级缓存,预装 Mac OS X v10.5 Leopard</li><li>2 GB RAM (two SO-DIMM)，677 MHz DDR2 SD-RAM (PC2-5300)显存, 250 GB 5400 rpm Serial ATA 硬盘驱动</li><li>1个 FireWire 400, 1个 FireWire 800, 2个 USB 2.0 接口, ExpressCard/34 slot</li><li>内置 10/100/1000BASE-T (Gigabit); 内置 54 Mbps AirPort Extreme (802.11n); 内置Bluetooth 2.0+EDR</li><li>15.4英寸, 1440 x 900 分辨率, TFT LED 宽频显示器，带NVIDIA GeForce 8600M GT 和 512 MB GDDR3 SDRAM和双路 DVI', NULL, '', '15-4-macbook-pro-mb134ll-a', 5),
(5, 1, '17英寸 MACBOOK PRO MB166LL/A', '<h2>产品特征</h2><br><ul><li>2.5GHz Core2 Duo处理器, L2 cache 6MB &nbsp;</li><li>250 GB硬盘驱动 </li><li>另外可以选择8X DVD+-RW/CD-RW驱动 </li><li>RAM 标准的 2GB DDR2 SDRAM显存 </li><li>支持4GB RAM &nbsp;</li><li>17 寸显示器, 支持分辨率 1680 x 1050 &nbsp;</li><li>支持NIC Gigabit 以太网 &nbsp;</li><li>内置无线 NIC &nbsp;</li><li>支持蓝牙 &nbsp;</li><li>安装OS Mac OS X v10.5 Leopard 软件 </li></ul><br>', NULL, '', '17-macbook-pro-mb166ll-a', 1),
(6, 1, '13.3寸苹果 MACBOOK AIR超薄电脑Z0FS0LL/A', '<h2>产品特征</h2><br><ul><li>1.8GHz Core2 Duo 处理器 , 6MB 片上共享二级缓存 </li><li>64GB 固态驱动</li><li>另外可以单独选择苹果 MacBook Air超级驱动 </li><li>与主内存共享的2GB 667MHz DDR2 SDRAM 显存 </li><li>支持NIC Gigabit 以太网 &nbsp;</li><li>内置无线 NIC &nbsp;</li><li>支持蓝牙 &nbsp;</li><li>安装软件包括Mac OS X v10.5 Leopard; iLife (includes iTunes, iPhoto, iMovie, iDVD, iWeb, GarageBand)</li></ul>', NULL, '', '13-3-macbook-air-apple-z0fs0ll-a', 3),
(7, 1, '联想ThinkPad X301, SU9400 1.4GHZ CPU', '<h2>产品特征</h2><br><ul><li>1.4GHz 酷睿2 SU900处理器</li><li>操作系统：正版 Windows XP Professional – 32位 </li><li>LED显示屏：13.3" WXGA + TFT宽屏（1440 x 900像素&nbsp; &nbsp;</li><li>内存：: 3GB PC3-8500 DDR3 SDRAM 1067MHz 内存 </li><li>WWAN: 可升级</li><li>硬盘驱动：128GB Solid State Drive</li><li>定点设备：UltraNav TrackPoint(指点杆)/触摸板，指纹识别</li><li>显卡：Intel GMA4500MHD 显卡</li><li>光驱：DVD/RW 双层刻录（CD& DVD）</li><li>内置网卡：Intel Pro 无线 WiFi 链接 5100 (AGN)</li></ul>', NULL, '', 'lenovo-thinkpad-x301-su9400-1-4ghz-cpu', 6),
(8, 1, '联想ThinkPad X200', '<h2>产品特征</h2><br><ul><li>2.8GHz英特尔酷睿双核处理器 P8600</li><li>3MB二级缓存，1066MHz总线速度 </li><li>2048MB内存（PC2-8500）-最大4MB</li><li>160GB（5400转）SATA硬盘</li><li>6芯锂电池，AC电源适配器，电源适配器延长线</li><li>软件包 – Windows XP Professional, Microsoft Office 2007 60天试用版，McAfee VirusScan Plus 30天使用</li></ul><br>', NULL, '', 'lenovo-thinkpad-x200', 3),
(9, 1, '联想ThinkPad T400 2767', '<h2>产品特征</h2><br><ul><li>2.53GHz酷睿双核处理器 T9400/– 迅驰2博锐技术</li><li>2G内存 </li><li>160G硬盘 </li><li>DVD刻录机</li><li>显卡Mobility Radeon HD3470/GMA 4500MHD</li><li>细胞的MDM /女士（CDMA 2000 1X服务的EV - DO版本A的WCDMA，HSPA网络</li><li>通讯</li><li>千兆以太网</li><li>无线通讯：802.11 a/b/g/n (draft), 蓝牙2.0 –</li><li>TPM安全芯片</li><li>指纹识别</li><li>Vista商务版</li><li> 14.1寸宽屏    TFT，1440 x 900（WXGA）</li></ul><br>', NULL, '', 'lenovo-thinkpad-t400-2767', 1),
(10, 1, '惠普 Pavilion DV7-1240US 17.0英寸笔记本电脑', '<h2>产品特征</h2><br><ul><li>以娱乐为中心的笔记本电脑：铜铬材料构成的流畅现代的线条设计;宽屏17英寸液晶显示器 </li><li>2.1千兆赫的AMD Turion X2的RM - 72双核心处理器，320 GB硬盘，4 GB内存（最大8 GB ），LightScribe的双层DVD驱动器 </li><li>Draft - N Wi – Fi （的802.11a/b/g/n），千兆以太网; ATI Radeon HD 3200显卡（高达1918 MB ） </li><li>连接：4个USB ，1个HDMI，1个VGA，54/34的ExpressCard，5合1存储卡读卡器 </li><li>预先安装了Windows Vista家庭高级版与SP1（64位版本）;包括远程控制</li></ul>', NULL, '', 'hp-pavilion-dv7-1240us-17-0-inch-laptop', 0),
(11, 1, '东芝Satellite A355-S6921', '<h2>产品特征</h2><br><ul><li>可携带多媒体笔记本，16英寸屏幕，16:9显示尺寸，720p高清画面</li><li>2.0GHz AMD Turion2 双核处理器， 250GB 硬盘，3G内存（最大4GB），光雕技术双层DVD驱动</li><li>无线网络协议（802.11b/g/n），以太网，ATI Radeon 3100图形（最高可达1919MB显存）</li><li>端口：4个USB接口（有一个共享eSata）,火线接口，VGA接口，ExpressCard 54/53, 五合一读卡器 </li><li>预装Windows Vista 家庭高级版和补丁包（64位）, </li></ul><br>', NULL, '', 'toshiba-satellite-a355-s6921', 2),
(12, 1, '惠普 Compaq 6735s KS117UT 15.4英寸笔记本', '产品特征<br><br>AMD的M780G芯片组 <br>处理器：AMD公司的Turion X2双核移动处理器的RM – 70（2.0 GHz, 2 x 512 KB，二级缓存） <br>内存标准：667 MHz or 800 MHz DDR2内存，支持双通道内存1024MB或2048MB的双插槽 <br>最大：可升级至8192MB,两插槽内分别放置4096MB SODIMM<br>ADM Sempron处理器，最大内存4096MB<br>双通道：最大化的双通道性能要求两个内存插槽内具有相同规模和速度的SODIMMS <br>图形集成的UMA 显卡ATI的Mobility Radeon高清3200共享系统内存：微软DirectX 10 <br>内部显示：15.4英寸对角线  WXGA防眩光（1280 × 800分辨率）15.4英寸的BrightView) 对角线 WXGA（1280 × 800分辨率） <br>外部：颜色深度多达32位每个像素 VGA端口位支持分辨率高达2048 × 1536， 75赫兹， 较低的分辨率高达100赫兹。<br>', NULL, '', 'hp-compaq-6735s-ks117ut-15-4-inch-notebook', 0),
(13, 1, '惠普 Pavilion TX2510US', '<h2>产品特征</h2><br><ul><li>12.1英寸宽屏，触摸屏，可变换显示屏最大分辨率1280 x 800, 面板可180度翻转 </li><li>2.10 GHz AMD Turion X2 ZM-80超双核移动处理器，带2 MB L2缓存 </li><li>3072 MB DDR2 系统内寸(2 Dimm), 250 GB (5400RPM) 硬盘驱动 (SATA), ATI Radeon HD 3200 Graphics RS780M ，带 64 MB DDR2 (外置显存)， 支持 1470 MB 总图形内存 </li><li>LightScribe Super Multi 8X DVD，支持双极层，无线LAN 802.11a/b/g/n，带蓝牙</li><li>Windows Vista 家庭高级版， dims in inches: 约8.82 (W) x 12.05 (L) x 1.52 (H)., 4.56 lbs.</li></ul><br>', NULL, '', 'hp-pavilion-tx2510us-12-1-inch-laptop', 0),
(14, 1, '东芝Satellite L305D-S5904 15.4寸笔记本', '<h2>产品特征</h2><br><ul><li>15.4寸宽屏TruBrite TFT LCD显示屏，1280 x 800分辨率</li><li>2.0GHz AMB Turion64 X2 双核移动技术，1MB二级缓存</li><li>3072MB DDR2内存，250GB（5400转）SATA硬盘，ATI Radeon X1250图形，128-831 MB的动态分配共享显存 </li><li>DVD DL支持LabelFlash, Atheros 802.11 b/g无线协议</li><li>Windows Vista家庭高级版，规格4.75 (W) x 14.3 (L) x 1.33 (H)，5.49磅</li></ul><br>', NULL, '', 'toshiba-satellite-l305d-s5904-15-4-inch-laptop', 0),
(15, 1, '苹果 IPOD NANO 4GB SILVER 3RD GEN', '拥有抛光阳极铝制外壳，搭配5种绚丽色彩。更大更亮的显示屏，让你获得愉悦的视觉体验。<br><br>可连续5小时播放视频或24小时音频文件。<br><br><b>Cover Flow</b><br>可预览音频文件夹封面，并浏览所有音频文件。<br><br><b>Music</b><br>在iTunes Store可以购买电影，并同步到你的iPod nano，随时随地观看。<br><br><b>Movies</b><br>Buy movies from the iTunes Store and you can sync them to your iPod nano to watch anywhere, anytime. Up to 5 hours of video playback means you can watch two movies back to back. And for your viewing pleasure, the 320-by-240-pixel display--with a whopping 204 pixels per inch--is 65 percent brighter than before. <br>', NULL, '', 'apple-ipod-nano-4gb-silver-3rd-gen', 2),
(16, 1, '苹果 iPod touch 8 GB', '<h2>产品特征</h2><ul><li>显示屏大小：3.5英寸</li><li>显示特点：电池电量提示</li><li>数字存储媒体：8G（内置存储器）</li><li>PC 接口支持：USB，无线网络</li><li>电池工作时间：将近22个小时</li><li>电池型号：内置电池</li><li>尺寸（宽度*厚度*高度）：2.4英寸*0.31英寸*4.3英寸</li><li>重量：4.2盎司</li><li>制造方编号：MA623ZO/B</li></ul><p><br>&nbsp;</p>', NULL, '', 'apple-ipod-touch-8-gb', 1),
(17, 1, '苹果 iphone 3G', '产品特征<br><br><ul><li>APPLE 3G 8GB</li><li>3.5英寸触摸屏</li><li>手机制式：QUAD-BAND GSM &amp; EDGE</li><li> WI-FI上网 (支持802.11b/g)</li><li>支持蓝牙2.0 EDR</li><li>8GB 内存 </li></ul>', NULL, '', 'apple-iphone-3g', 1),
(18, 1, '苹果23英寸 HD CINEMA COLOR DISPLAY', '<h2>产品特征</h2><br><ul><li>兼容: Mac</li><li>面板类型: TFT主动式矩阵液晶显示器</li><li>显示器: 23英寸</li><li>最大可视屏宽: 23 英寸</li><li>分辨率: 1920 x 1200 pixels (optimum)</li><li>对比度: 350:1</li><li>表面光泽度: 反光硬模</li><li>水平视角: 170度</li><li>垂直视角: 170 度</li><li>亮度: 200 cd/m2</li><li>视频信号: 数字</li><li>输入接口: 电源, USB,数位图形接口，双接口自供电USB集线器</li><li>最大逐行扫描分辨率: 1920 x 1200</li><li> Power on/off: 支持系统power on/sleep/wake</li><li>亮度: 可调</li><li>Swivel: 用户可调</li><li>系统要求（以下选其一）: (a) Power Mac G4，带NVIDIA GeForce2 MX, GeForce3, GeForce4 MX, 或 GeForce4 Ti 显卡, 或 ATI Radeon 7500 显卡; 以及 Mac OS X v10.1.3 或 Mac OS 9.2.2, (b) Power Mac G4 ，带 DVI 接口 (通过NVIDIA GeForce4 Ti 显卡) 和 苹果DVI 至 ADC 转换器, (c) PowerBook G4，带DVI 接口和苹果DVI至ADC转换器</li><li>宽度: 24.2 英寸</li><li>高度: 19.2 英寸</li><li>厚度: 7.3 英寸</li><li>重量: 25.3 磅</li></ul><br>', NULL, '', 'apple-23-hd-cinema-color-display', 0),
(19, 1, '索尼 DSC-T700数码像机', '<h2>产品特征</h2><ul><li>轻便美观的外形设计</li><li>1010万有效像素</li><li>4GB内存，能够储存多达4万张照片</li><li>强大的相册功能来存储，管理和分享你的照片</li><li>一笑即拍功能自动捕捉每张笑脸</li><li>人脸检测功能和红眼消除技术</li><li>在宽大的3.5寸触摸LCD屏上享受你的图片</li><li>快捷的网络上传功能助你在网络上分享图片</li><li>双重防抖技术</li><li>可携带相册</li><li>人脸检测</li><li>智能场景识别模式</li><li>相机内部编辑图片</li><li>分享HD高清图片 </li></ul>', NULL, '', 'sony-dsc-t700-g-digital-video-camera', 2);
