<?php
/*
  $Id: shipping_method_form.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
?>

<table cellspacing="0">
  <tbody>
    <tr>
      <th>&nbsp;</th>
      <th><?php echo $osC_Language->get('table_heading_shipping_name'); ?></th>
      <th><?php echo $osC_Language->get('table_heading_shipping_description'); ?></th>
      <th><?php echo $osC_Language->get('table_heading_shipping_price'); ?></th>
      <th><?php echo $osC_Language->get('table_heading_shipping_free_price'); ?></th>
    </tr>
    
    <?php
      require_once('includes/classes/china_shipping.php');
      $osC_Shipping = new toC_China_Shipping();
      
      if ($osC_Shipping->numberOfQuotes() >= 1) {
        foreach ($osC_Shipping->getQuotes() as $quotes) {
          if ($quotes['id'] . '_' . $quotes['methods'][0]['id'] == $osC_ShoppingCart->getShippingMethod('id')) {
            echo '<tr id="defaultShippingMethodSelected" class="moduleRowSelected" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(\'checkout_address\', this)">' . "\n";
          } else {
            echo '<tr class="moduleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="selectRowEffect(\'checkout_address\', this)">' . "\n";
          }
          echo '<td>' . osc_draw_radio_field('shipping_method', $quotes['id'] . '_' . $quotes['methods'][0]['id'], $osC_ShoppingCart->getShippingMethod('id'), 'onclick="selectShippingMethod(this)"') . '</td>';
          echo '<td><strong>' . $quotes['module'] . '</strong></td>';
          echo '<td>' . $quotes['methods'][0]['title'] . '</td>';
          echo '<td>' . $osC_Currencies->displayPrice($quotes['methods'][0]['cost'], $quotes['tax_class_id']) . osc_draw_hidden_field('shipping_mod_sel', $quotes['id'] . '_' . $quotes['methods'][0]['id']) . '</td>';
          echo '<td>' . $osC_Currencies->displayPrice($quotes['methods'][0]['free_shipping_cost'], $quotes['tax_class_id']) . osc_draw_hidden_field('shipping_mod_sel', $quotes['id'] . '_' . $quotes['methods'][0]['id']) . '</td>';
          echo '</tr>';
        }
      }
    ?>
  </tbody>
</table>

<?php
  if (!class_exists('osC_OrderTotal')) {
    include('includes/classes/order_total.php');
  }
  
  if ( !isset($osC_OrderTotal) ) {
    $osC_OrderTotal = new osC_OrderTotal();
  }
?>
      
<?php
  global $osC_OrderTotal_gift_wrapping;
  
  if(isset($osC_OrderTotal_gift_wrapping) && is_object($osC_OrderTotal_gift_wrapping) && $osC_OrderTotal_gift_wrapping->isEnabled()){
?>
<div class="moduleBox">
  <h6><?php echo '<b>' . $osC_Language->get('gift_wrapping_heading') . '</b>'; ?></h6>

  <div class="content">
    <?php 
      $price = MODULE_ORDER_TOTAL_GIFT_WRAPPING_PRICE;
      echo osc_draw_checkbox_field('gift_wrapping', '1', $osC_ShoppingCart->isGiftWrapping() ? true : false) . '&nbsp;<b>' . sprintf($osC_Language->get('gift_wrapping_description'), $osC_Currencies->format(MODULE_ORDER_TOTAL_GIFT_WRAPPING_PRICE)) . '</b>'; ?>
    
    <h6><?php echo '<b>' . $osC_Language->get('gift_wrapping_heading') . '</b>'; ?></h6>
    <?php echo osc_draw_textarea_field('gift_wrapping_comments', (isset($_SESSION['gift_wrapping_comments']) ? $_SESSION['gift_wrapping_comments'] : null), null, null, 'style="width: 98%;"'); ?>
  </div>
</div>
<?php
  }
?>

<div class="moduleBox">
  <h6><?php echo $osC_Language->get('add_comment_to_order_title'); ?></h6>

  <div class="content">
    <?php echo osc_draw_textarea_field('shipping_comments', (isset($_SESSION['comments']) ? $_SESSION['comments'] : null), null, null, 'style="width: 98%;"'); ?>
  </div>
</div>

<br />
