<?php
/*
  $Id: emsexpress.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/
  require_once('includes/classes/china_shipping.php');
  
  class osC_Shipping_emsexpress extends toC_China_Shipping {
    var $icon;

    var $_title,
        $_code = 'emsexpress',
        $_status = false,
        $_sort_order,
        $_base_weight = 500,
        $_step_weight = 500,
        $_weight_type = 1,
        $_shipping_area_id = 0;

// class constructor
    function osC_Shipping_emsexpress() {
      global $osC_Language;

      $this->icon = '';

      $this->_title = $osC_Language->get('shipping_emsexpress_title');
      $this->_description = $osC_Language->get('shipping_emsexpress_description');
      $this->_status = (defined('MODULE_SHIPPING_EMSEXPRESS_STATUS') && (MODULE_SHIPPING_EMSEXPRESS_STATUS == 'True') ? true : false);
      $this->_sort_order = (defined('MODULE_SHIPPING_EMSEXPRESS_SORT_ORDER') ? MODULE_SHIPPING_EMSEXPRESS_SORT_ORDER : null);
    }

  // class methods
    function initialize() {
      global $osC_Database, $osC_ShoppingCart;

      $this->tax_class = MODULE_SHIPPING_EMSEXPRESS_TAX_CLASS;

      $this->_shipping_area_id = parent::getChinaShippingAreaId();
      if ($this->_shipping_area_id === false) {
        $this->_status = false;
      } else {
        $this->_status = true;
      }
    }

    function quote() {
      global $osC_Language, $osC_Database, $osC_ShoppingCart, $osC_Weight;
      
      $cost = 0;

      if ($this->_shipping_area_id > 0) {
        $Qconfigure = $osC_Database->query('select configure from :table_china_shipping_area where china_shipping_area_id = :china_shipping_area_id');
        $Qconfigure->bindTable(':table_china_shipping_area', TABLE_CHINA_SHIPPING_AREA);
        $Qconfigure->bindInt(':china_shipping_area_id', $this->_shipping_area_id);
        $Qconfigure->execute();
        
        if ( $Qconfigure->numberOfRows() === 1 ) {
          $configure = $Qconfigure->value('configure');
          $params = unserialize($configure);

          if (sizeof($params) > 0) {
            $base_weight = $osC_Weight->convert($this->_base_weight, $this->_weight_type, SHIPPING_WEIGHT_UNIT);
            $step_weight = $osC_Weight->convert($this->_step_weight, $this->_weight_type, SHIPPING_WEIGHT_UNIT);
            
            $weight = $osC_ShoppingCart->getWeight();
            
            if ($params['emsexpress_free_shipping'] != 0 && $osC_ShoppingCart->getSubTotal() >= $params['emsexpress_free_shipping']) {
              $cost = 0;
            } else {
              $cost = $params['emsexpress_base_fee'] + ceil(($weight - $base_weight) / $step_weight) * $params['emsexpress_step_fee'];
            }
          }
        }
      }
      
      $this->quotes = array('id' => $this->_code,
                            'module' => $this->_title,
                            'methods' => array(array('id' => $this->_code,
                                                     'title' => $osC_Language->get('shipping_emsexpress_method'),
                                                     'cost' => $cost)),
                            'tax_class_id' => $this->tax_class);

      if (!empty($this->icon)) $this->quotes['icon'] = osc_image($this->icon, $this->_title);

      return $this->quotes;
    }
  }
?>
