<?php
/*
  $Id: product_listing.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2007 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  // create column list
  $define_list = array('PRODUCT_LIST_SKU' => PRODUCT_LIST_SKU, 
                       'PRODUCT_LIST_NAME' => PRODUCT_LIST_NAME,
                       'PRODUCT_LIST_REVIEWS' => PRODUCT_LIST_REVIEWS,
                       'PRODUCT_LIST_MANUFACTURER' => PRODUCT_LIST_MANUFACTURER,
                       'PRODUCT_LIST_PRICE' => PRODUCT_LIST_PRICE,
                       'PRODUCT_LIST_QUANTITY' => PRODUCT_LIST_QUANTITY,
                       'PRODUCT_LIST_WEIGHT' => PRODUCT_LIST_WEIGHT,
                       'PRODUCT_LIST_IMAGE' => PRODUCT_LIST_IMAGE,
                       'PRODUCT_LIST_BUY_NOW' => PRODUCT_LIST_BUY_NOW);
  
  asort($define_list);
  
  $column_list = array();
  reset($define_list);
  while (list($key, $value) = each($define_list)) {
    if ($value > 0) $column_list[] = $key;
  }

  if ( ($Qlisting->numberOfRows() > 0) && ( (PREV_NEXT_BAR_LOCATION == '1') || (PREV_NEXT_BAR_LOCATION == '3') ) ) {
?>
    <div class="listingPageLinks">
      <span style="float: right;"><?php echo $Qlisting->getBatchPageLinks('page', osc_get_all_get_params(array('page', 'info', 'x', 'y')),false); ?></span>
    
      <?php echo $Qlisting->getBatchTotalPages($osC_Language->get('result_set_number_of_products')); ?>
    </div>
<?php
  }
?>

<div class="productlistingbox">
  <h6><?php echo $osC_Template->getPageTitle(); ?></h6>
  <?php
    if ($Qlisting->numberOfRows() > 0) {
      $sortings = array();
      $list_headings = array();
      
      for ($col = 0, $n = sizeof($column_list); $col < $n; $col++) {
        $lc_key = false;
        $lc_align = 'center';

        switch ($column_list[$col]) {
          case 'PRODUCT_LIST_SKU':
            $lc_text = $osC_Language->get('listing_sku_heading');
            $lc_key = 'sku';
            break;
          case 'PRODUCT_LIST_NAME':
            $lc_text = $osC_Language->get('listing_products_heading');
            $lc_key = 'name';
            break;
          case 'PRODUCT_LIST_REVIEWS':
            $lc_text = $osC_Language->get('listing_products_reviews_heading');
            break;
          case 'PRODUCT_LIST_MANUFACTURER':
            $lc_text = $osC_Language->get('listing_manufacturer_heading');
            $lc_key = 'manufacturer';
            break;
          case 'PRODUCT_LIST_PRICE':
            $lc_text = $osC_Language->get('listing_price_heading');
            $lc_key = 'price';
            $lc_align = 'right';
            break;
          case 'PRODUCT_LIST_QUANTITY':
            $lc_text = $osC_Language->get('listing_quantity_heading');
            $lc_key = 'quantity';
            $lc_align = 'right';
            break;
          case 'PRODUCT_LIST_WEIGHT':
            $lc_text = $osC_Language->get('listing_weight_heading');
            $lc_key = 'weight';
            $lc_align = 'right';
            break;
          case 'PRODUCT_LIST_IMAGE':
            $lc_text = $osC_Language->get('listing_image_heading');
            $lc_align = 'center';
            break;
          case 'PRODUCT_LIST_BUY_NOW':
            $lc_text = $osC_Language->get('listing_buy_now_heading');
            $lc_align = 'center';
            break;
        }
        
        $list_headings[] = array('lc_align' => $lc_align, 'lc_text' => $lc_text);
        
        if ($lc_key !== false) {
          // Put sortable field into array
          $sortings[] = array('id' => $lc_key, 'text' => $lc_text . '(升序)');
          $sortings[] = array('id' => $lc_key . '|d', 'text' => $lc_text . '(降序)');
        }
      }
      
      if (!empty($sortings)) {
        $frm_sort = '<div class="productSorts">' .
        
        $frm_sort .= '<form name="sort" action="' . osc_href_link(basename($_SERVER['SCRIPT_FILENAME'])) . '" method="get">';

	      if ($osC_Template->getGroup() == 'search') {
          foreach($_GET as $key =>$value) {
            if(isset($value) && !empty($value)){
              $frm_sort .= osc_draw_hidden_field($key, $value);
            }
          }
	      }          
        
        if(isset($_GET['cPath']) && !empty($_GET['cPath'])) {
          $frm_sort .= osc_draw_hidden_field('cPath', $_GET['cPath']);
        }
        if(isset($_GET['manufacturers']) && !empty($_GET['manufacturers'])) {
          $frm_sort .= osc_draw_hidden_field('manufacturers', $_GET['manufacturers']);
        }
        $frm_sort .= osc_draw_pull_down_menu('sort', $sortings, $_GET['sort'], ' onchange="this.form.submit()"');
        
        $params = explode('&', osc_get_all_get_params(array('page', 'sort')));
        foreach ($params as $key => $value) {
          $key_value = explode('=', $value);
          $frm_sort .= osc_draw_hidden_field($key_value[0], $key_value[1]);
        }
        
        $frm_sort .= '</form>';
        $frm_sort .= '</div>';
        
        echo $frm_sort;
      }
      
      $product_view_style = '<div class="productViewStyle">' .
                              '<span>' . $osC_Language->get('products_views_label') . '</span>';
      
      $firstParam = null;
      if(isset($_GET['cPath']) && !empty($_GET['cPath'])) {
        $firstParam = 'cPath='. $_GET['cPath'];
      }
      if(isset($_GET['manufacturers']) && !empty($_GET['manufacturers'])) {
        $firstParam = 'manufacturers='. $_GET['manufacturers'];
      }
      
      if ($osC_Template->getGroup() == 'search') {
        foreach($_GET as $key => $value) {
          if(isset($value) && !empty($value)){
            $firstParam .= '&'. $key. '='. $value;
          }
        }
        $firstParam = substr($firstParam, 1, (strlen($firstParam) - 1));
      }  
      
      if ( (!isset($_GET['view']) && !isset($_SESSION['view'])) || (isset($_GET['view']) && $_GET['view'] == 'list') ) {
        $product_view_style .= '<span>'. osc_image('images/list_view_color.png', 'list_view', 18, 18) . '</span>' . 
                               '<span>' . osc_link_object(osc_href_link(basename($_SERVER['SCRIPT_FILENAME']), $firstParam . '&view=grid'), osc_image('images/grid_view.png', 'grid_view', 18, 18)) . '</span>';
      }else if ( isset($_GET['view']) && $_GET['view'] == 'grid') {
        $product_view_style .= '<span>' . osc_link_object(osc_href_link(basename($_SERVER['SCRIPT_FILENAME']), $firstParam . '&view=list'), osc_image('images/list_view.png', 'list_view', 18, 18)) . '</span>' .
                               '<span>' . osc_image('images/grid_view_color.png', 'grid_view', 18, 18) . '</span>';
      }else if( !isset($_GET['view']) && isset($_SESSION['view']) ) {
        $view_style = $_SESSION['view'];
        if($view_style == 'list') {
	        $product_view_style .= '<span>'. osc_image('images/list_view_color.png', 'list_view', 18, 18) . '</span>' . 
	                               '<span>' . osc_link_object(osc_href_link(basename($_SERVER['SCRIPT_FILENAME']), $firstParam . '&view=grid'), osc_image('images/grid_view.png', 'grid_view', 18, 18)) . '</span>';
        }else {
	        $product_view_style .= '<span>' . osc_link_object(osc_href_link(basename($_SERVER['SCRIPT_FILENAME']), $firstParam . '&view=list'), osc_image('images/list_view.png', 'list_view', 18, 18)) . '</span>' .
	                               '<span>' . osc_image('images/grid_view_color.png', 'grid_view', 18, 18) . '</span>';
        }
      }      


      $product_view_style .= '</div>';
      
      
      echo $product_view_style;
      
      echo '<div style="clear: both;"></div>';
      
    ?>
      
    <?php 
      if ((!isset($_GET['view']) && !isset($_SESSION['view'])) || (isset($_GET['view']) && $_GET['view'] == 'list')) {
        require('products_list.php');
      }else if (isset($_GET['view']) && $_GET['view'] == 'grid') {
        require('products_grid.php');
      }else if( !isset($_GET['view']) && isset($_SESSION['view']) ){
        $view_type = $_SESSION['view'];
        require('products_'. $view_type. '.php');
      }
    }else{
      echo '<div style="clear: both;"></div>';
      echo '<div style="padding: 20px 5px 10px;">'. $osC_Language->get('no_products_in_category'). '</div>';    
    }
  ?>
</div>

 
<?php
  if ( ($Qlisting->numberOfRows() > 0) && ((PREV_NEXT_BAR_LOCATION == '2') || (PREV_NEXT_BAR_LOCATION == '3')) ) {
?>
    <div class="listingPageLinks">
      <span style="float: right;"><?php echo $Qlisting->getBatchPageLinks('page', osc_get_all_get_params(array('page', 'info', 'x', 'y'))); ?></span>
    
      <?php echo $Qlisting->getBatchTotalPages($osC_Language->get('result_set_number_of_products')); ?>
    </div>
<?php
  }
?>
