<?php
/*
  $Id: chinabank.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2009 Wuxi Elootec Technology Co., Ltd;  Copyright (c) 2006 osCommerce

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  class osC_Payment_chinabank extends osC_Payment{
  
    var $_title;
    var $_code = 'chinabank';
    var $_status = false;
    var $_sort_order;
    var $_order_id;
    var $form_action_url;
    
    function osC_Payment_chinabank() {
      global $osC_Language;
      
      $this->_title = $osC_Language->get('payment_chinabank_title');
      $this->_method_title = $osC_Language->get('payment_chinabank_method_title');
      $this->_status = ((MODULE_PAYMENT_CHINABANK_STATUS == '1') ? true : false);
      $this->_sort_order = MODULE_PAYMENT_CHINABANK_SORT_ORDER;
      $this->form_action_url = 'https://pay3.chinabank.com.cn/PayGate';
      
      if ($this->_status === true) {
        if ((int)MODULE_PAYMENT_CHINABANK_ORDER_STATUS_ID > 0) {
          $this->order_status = MODULE_PAYMENT_CHINABANK_ORDER_STATUS_ID;
        }

        if ((int)MODULE_PAYMENT_CHINABANK_ZONE > 0) {
          $check_flag = false;

          $Qcheck = $osC_Database->query('select zone_id from :table_zones_to_geo_zones where geo_zone_id = :geo_zone_id and zone_country_id = :zone_country_id order by zone_id');
          $Qcheck->bindTable(':table_zones_to_geo_zones', TABLE_ZONES_TO_GEO_ZONES);
          $Qcheck->bindInt(':geo_zone_id', MODULE_PAYMENT_CHINABANK_ZONE);
          $Qcheck->bindInt(':zone_country_id', $osC_ShoppingCart->getBillingAddress('country_id'));
          $Qcheck->execute();

          while ($Qcheck->next()) {
            if ($Qcheck->valueInt('zone_id') < 1) {
              $check_flag = true;
              break;
            } elseif ($Qcheck->valueInt('zone_id') == $osC_ShoppingCart->getBillingAddress('zone_id')) {
              $check_flag = true;
              break;
            }
          }

          if ($check_flag == false) {
            $this->_status = false;
          }
        }
      }
      
    }
  
    function selection() {
      return array('id' => $this->_code,
                   'module' => $this->_method_title);
    }
  
//    function process() {
//      $this->_order_id = osC_Order::insert();
//      osC_Order::process($this->_order_id, $this->order_status);
//    }
    
    function confirmation() {
      $this->_order_id = osC_Order::insert(ORDERS_STATUS_PREPARING);
    }   
    
    function process_button() {
      global $osC_Customer, $osC_Currencies, $osC_ShoppingCart, $osC_Session;
      
      $merchant_id = MODULE_PAYMENT_MERCHANT_ID;
//      $amount = $osC_Currencies->formatRaw($osC_ShoppingCart->getTotal());
      $amount = 0.01;
      $money_type = 'CNY';
      $return_url = osc_href_link(FILENAME_CHECKOUT, 'callback&module=' . $this->_code, 'SSL', null, null, true);
      $md5key = MODULE_PAYMENT_KEY;
      $order_id = $this->_order_id;
      
      $text = $amount.$money_type.$order_id.$merchant_id.$return_url.$md5key;      
      
      $parameters = array(
        "v_mid" => $merchant_id,  
        "v_oid" => $order_id,         
        "v_amount" => $amount,      
        "v_moneytype" => $money_type,      
        "v_url" => $return_url,  
        "v_md5info" => strtoupper(md5($text)),       
        "remark1" => trim(session_id()),       
        "remark2" => 'very good',     

        "v_rcvname" => $osC_ShoppingCart->getBillingAddress('firstname'). ''. $osC_ShoppingCart->getBillingAddress('lastname'),         
        "v_rcvtel" => $osC_ShoppingCart->getBillingAddress('telephone_number'),   
        "v_rcvpost" => $osC_ShoppingCart->getBillingAddress('postcode'),             
        "v_rcvaddr" => $osC_ShoppingCart->getBillingAddress('street_address'),          
        "v_rcvemail" => $osC_ShoppingCart->getBillingAddress('telephone_number'),    
        "v_rcvmobile" => $osC_Customer->getEmailAddress(),    
      
        "v_ordername" => $osC_ShoppingCart->getBillingAddress('firstname'). ''. $osC_ShoppingCart->getBillingAddress('lastname'),        
        "v_ordertel" => $osC_ShoppingCart->getBillingAddress('telephone_number'),    
        "v_orderpost" => $osC_ShoppingCart->getBillingAddress('postcode'),        
        "v_orderaddr" => $osC_ShoppingCart->getBillingAddress('street_address'),    
        "v_ordermobile" => $osC_ShoppingCart->getBillingAddress('telephone_number'),        
        "v_orderemail" => $osC_Customer->getEmailAddress()
      );
      
      
      $process_button_string = '';
      foreach ($parameters as $key => $value) {
        $value = trim($value);
        $process_button_string .= osc_draw_hidden_field($key, $value);
      }
      
      return $process_button_string;
        
    }
    
    function callback(){
      $key = MODULE_PAYMENT_KEY;              
  
			$v_oid     =trim($_POST['v_oid']);       // 商户发送的v_oid定单编号   
			$v_pmode   =trim($_POST['v_pmode']);    // 支付方式（字符串）   
			$v_pstatus =trim($_POST['v_pstatus']);   //  支付状态 ：20（支付成功）；30（支付失败）
			$v_pstring =trim($_POST['v_pstring']);   // 支付结果信息 ： 支付完成（当v_pstatus=20时）；失败原因（当v_pstatus=30时,字符串）； 
			$v_amount  =trim($_POST['v_amount']);     // 订单实际支付金额
			$v_moneytype  =trim($_POST['v_moneytype']); //订单实际支付币种    
			$remark1   =trim($_POST['remark1' ]);      //备注字段1
			$remark2   =trim($_POST['remark2' ]);     //备注字段2
			$v_md5str  =trim($_POST['v_md5str' ]);   //拼凑后的MD5校验值  

      $md5string=strtoupper(md5($v_oid.$v_pstatus.$v_amount.$v_moneytype.$key));

			if ($v_md5str==$md5string){
			  if($v_pstatus=="20"){
			    $comment = '支付成功！';
			    session_id($remark1);
			    osC_Order::process($v_oid, $this->order_status, $comment);
			    osc_redirect(osc_href_link(FILENAME_CHECKOUT, 'process', 'NOSSL'));
			  }else{
			    echo "支付失败";
			  }
			}else{
			  echo "<br>校验失败,数据可疑";
			}
    }
    
  }
?>