<?php
/*
  $Id: order_search.php $
  TomatoCart Open Source Shopping Cart Solutions
  http://www.tomatocart.com

  Copyright (c) 2010 Wuxi Elootec Technology Co., Ltd

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License v2 (1991)
  as published by the Free Software Foundation.
*/

  include('includes/classes/order.php');
  
  class toC_Json_Order_Search {
  	
    function searchOrder() {
      global $osC_Database, $osC_Language, $toC_Json;
      
      $osC_Language->load('order_search');
      
      $content = $osC_Language->get('orders_status');
      
      $Qorder = $osC_Database->query('select * from :table_orders where orders_id = :orders_id');
      $Qorder->bindTable(':table_orders', TABLE_ORDERS);
      $Qorder->bindInt(':orders_id', $_REQUEST['orders_id']);
      $Qorder->execute();
      
      if ( $Qorder->numberOfRows() > 0 ) {
        $osC_Order = new osC_Order($_REQUEST['orders_id']);
        
        $Qstatus = $osC_Order->getStatusListing();
        $Qstatus->execute();
        
        while ( $Qstatus->next() ) {
          $content .= $Qstatus->value('orders_status_name') . '&nbsp;';
        }
        
        if ( $osC_Order->info['tracking_no'] != null ) {
          $shipping_module = $osC_Order->info['shipping_module'];
          $shipping = explode('_', $shipping_module);
          
          $url = constant('MODULE_SHIPPING_' . strtoupper($shipping[0]) . '_URL');
          
          $content .= '<br>' . $osC_Language->get('tracking_no') . '<a href="' . $url . '" target="_blank">' . $osC_Order->info['tracking_no'] . '</a>';
        }
        
        $response = array('success' => true, 'html' => $content);
      } else {
        $response = array('success' => false, 'html' => $osC_Language->get('invalid_orders_id'));
      }

      echo $toC_Json->encode($response);
    }
  }
?>